# LiteMongo

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Commitizen friendly](https://img.shields.io/badge/commitizen-friendly-brightgreen.svg)](http://commitizen.github.io/cz-cli/)
[![security: bandit](https://img.shields.io/badge/security-bandit-yellow.svg)](https://github.com/PyCQA/bandit)

## About

LiteMongo provides a drop-in replacement for `pymongo` without the need for a MongoDB server.
The database is stored on disk, making this an ideal tool for projects that require small MongoDB databases without wanting to go to the effort of installing the official server.
This is all made possible by building on top of the wonderful [Mongomock](https://github.com/mongomock/mongomock) library.


## Development

### Tests

Simply run `pytest`. For more detailed output, including test coverage:

```sh
pytest -vv --cov=. --cov-report term-missing
```

### Contributing

If you would like to contribute to the project:

- if you're making code contributions, please try and write some tests to accompany your code, and ensure that the tests pass.
- commit your changes via `cz commit`. Follow the prompts. When you're done, `pre-commit` will be invoked to ensure that your contributions and commits follow defined conventions. See `pre-commit-config.yaml` for more details.
- your commit messages should follow the conventions described [here](https://www.conventionalcommits.org/en/v1.0.0/). Write your commit message in the imperative: "Fix bug" and not "Fixed bug" or "Fixes bug." This convention matches up with commit messages generated by commands like `git merge` and `git revert`.
Once you are done, please send a [merge request](https://docs.gitlab.com/ee/user/project/merge_requests/).

----
