# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkconfig.endpoint import endpoint_data

class PutDeliveryChannelRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Config', '2019-01-08', 'PutDeliveryChannel')
		self.set_method('POST')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_ClientToken(self): # String
		return self.get_body_params().get('ClientToken')

	def set_ClientToken(self, ClientToken):  # String
		self.add_body_params('ClientToken', ClientToken)
	def get_Description(self): # String
		return self.get_body_params().get('Description')

	def set_Description(self, Description):  # String
		self.add_body_params('Description', Description)
	def get_DeliveryChannelTargetArn(self): # String
		return self.get_body_params().get('DeliveryChannelTargetArn')

	def set_DeliveryChannelTargetArn(self, DeliveryChannelTargetArn):  # String
		self.add_body_params('DeliveryChannelTargetArn', DeliveryChannelTargetArn)
	def get_DeliveryChannelCondition(self): # String
		return self.get_body_params().get('DeliveryChannelCondition')

	def set_DeliveryChannelCondition(self, DeliveryChannelCondition):  # String
		self.add_body_params('DeliveryChannelCondition', DeliveryChannelCondition)
	def get_DeliveryChannelAssumeRoleArn(self): # String
		return self.get_body_params().get('DeliveryChannelAssumeRoleArn')

	def set_DeliveryChannelAssumeRoleArn(self, DeliveryChannelAssumeRoleArn):  # String
		self.add_body_params('DeliveryChannelAssumeRoleArn', DeliveryChannelAssumeRoleArn)
	def get_DeliveryChannelName(self): # String
		return self.get_body_params().get('DeliveryChannelName')

	def set_DeliveryChannelName(self, DeliveryChannelName):  # String
		self.add_body_params('DeliveryChannelName', DeliveryChannelName)
	def get_DeliveryChannelId(self): # String
		return self.get_body_params().get('DeliveryChannelId')

	def set_DeliveryChannelId(self, DeliveryChannelId):  # String
		self.add_body_params('DeliveryChannelId', DeliveryChannelId)
	def get_DeliveryChannelType(self): # String
		return self.get_body_params().get('DeliveryChannelType')

	def set_DeliveryChannelType(self, DeliveryChannelType):  # String
		self.add_body_params('DeliveryChannelType', DeliveryChannelType)
	def get_Status(self): # Integer
		return self.get_body_params().get('Status')

	def set_Status(self, Status):  # Integer
		self.add_body_params('Status', Status)
