"""
Database of known languages

TODO: refactor for alternate extensions
"""

# because one is a subset of the other
CLONES = [["xml", "html", "php"], ["c", "c++"], ["javascript", "typescript"]]

# popularity data is from:
# https://pypl.github.io/PYPL.html?country=US
# CC-BY-SA 3.0, original data from google.
POPULARITY = {
    "python": "1",
    "java": "2",
    "javascript": "3",
    "c#": "4",
    "c++": "5",
    "php": "6",
    "r": "7",
    "objectivec": "8",
    "swift": "9",
    "typescript": "10",
    "matlab": "11",
    "kotlin": "12",
    "go": "13",
    "vba": "14",
    "ruby": "15",
    "rust": "16",
    "scala": "17",
    "vbnet": "18",
    "lua": "19",
    "ada": "20",
    "dart": "21",
    "abap": "22",
    "perl": "23",
    "julia": "24",
    "groovy": "25",
    "cobol": "26",
    "haskell": "27",
    "delphi": "28",
}
POPULARITY_LIST = [
    "python",
    "java",
    "javascript",
    "c#",
    "c++",
    "php",
    "r",
    "objectivec",
    "swift",
    "typescript",
    "matlab",
    "kotlin",
    "go",
    "vba",
    "ruby",
    "rust",
    "scala",
    "vbnet",
    "lua",
    "ada",
    "dart",
    "abap",
    "perl",
    "julia",
    "groovy",
    "cobol",
    "haskell",
    "delphi",
]

FILE_EXTENSIONS = {
    "batchfile": [".bat"],
    # "c": [".c"],
    "c#": [".cs"],
    "c++": [".cpp", ".gcc"],
    # "css": [".css"],
    # "coffeescript": [".coffee"],
    # "erlang": [".erlang"],
    # "go": [".go"],
    # "html": [".html"],
    # "haskell": [".haskell"],
    # "java": [".java"],
    # "javascript": [".js"],
    # "json": [".json"],
    "jupyter notebook": [".nb"],
    # "lua": [".lua"],
    # "markdown": [".md"],
    # "matlab": [".matlab"],
    "objective-C": [".objc"],
    # "php": [".php"],
    # "perl": [".perl"],
    # "powershell": [".ps1"],
    # "python": [".py"],
    "r": [".r"],
    # "ruby": [".rb"],
    # "rust": [".rust"],
    # "sql": [".sql"],
    # "scala": [".scala"],
    "shell": [".sh"],
    # "swift": [".swift"],
    # "tex": [".tex"],
    # "yaml": [".yml"],
    # "typescript": [".ts"],
    "abap": [".abap", ".ABAP"],
    "apl": [".apl"],
    "abnf": [".abnf"],
    "actionscript3": [".as"],
    "actionscript": [".as"],
    "ada": [".adb", ".ads", ".ada"],
    "adl": [".adl", ".adls", ".adlf", ".adlx"],
    "agda": [".agda"],
    "aheui": [".aheui"],
    "alloy": [".als"],
    "ambienttalk": [".at"],
    "ampl": [".run"],
    "angular2html": [".ng2"],
    "antlractionscript": [".G", ".g"],
    "antlrcsharp": [".G", ".g"],
    "antlrcpp": [".G", ".g"],
    "antlrjava": [".G", ".g"],
    "antlrobjectivec": [".G", ".g"],
    "antlrperl": [".G", ".g"],
    "antlrpython": [".G", ".g"],
    "antlrruby": [".G", ".g"],
    "apacheconf": [".htaccess", "apache.conf", "apache2.conf"],
    "applescript": [".applescript"],
    "arduino": [".ino"],
    "arrow": [".arw"],
    "aspectj": [".aj"],
    "asymptote": [".asy"],
    "augeas": [".aug"],
    "autoit": [".au3"],
    "autohotkey": [".ahk", ".ahkl"],
    "awk": [".awk"],
    "bbcbasic": [".bbc"],
    "bc": [".bc"],
    "bst": [".bst"],
    "bare": [".bare"],
    "bash": [
        ".sh",
        ".ksh",
        ".bash",
        ".ebuild",
        ".eclass",
        ".exheres-0",
        ".exlib",
        ".zsh",
        ".bashrc",
        "bashrc",
        ".bash_*",
        "bash_*",
        "zshrc",
        ".zshrc",
        "PKGBUILD",
    ],
    "bashsession": [".sh-session", ".shell-session"],
    "batch": [".bat", ".cmd"],
    "befunge": [".befunge"],
    "bibtex": [".bib"],
    "blitzbasic": [".bb", ".decls"],
    "blitzmax": [".bmx"],
    "bnf": [".bnf"],
    "boa": [".boa"],
    "boo": [".boo"],
    "boogie": [".bpl"],
    "brainfuck": [".bf", ".b"],
    "bugs": [".bug"],
    "camkes": [".camkes", ".idl4"],
    "c": [".c", ".h", ".idc"],
    "cmake": [".cmake", "CMakeLists.txt"],
    "cobjdump": [".c-objdump"],
    "cpsa": [".cpsa"],
    "csharpaspx": [".aspx", ".asax", ".ascx", ".ashx", ".asmx", ".axd"],
    "csharp": [".cs"],
    "ca65": [".s"],
    "cadl": [".cadl"],
    "capdl": [".cdl"],
    "capnproto": [".capnp"],
    "cbmbasicv2": [".bas"],
    "ceylon": [".ceylon"],
    "cfengine3": [".cf"],
    "chaiscript": [".chai"],
    "chapel": [".chpl"],
    "charmci": [".ci"],
    "cheetah": [".tmpl", ".spt"],
    "cirru": [".cirru"],
    "clay": [".clay"],
    "clean": [".icl", ".dcl"],
    "clojure": [".clj"],
    "clojurescript": [".cljs"],
    "cobolfreeformat": [".cbl", ".CBL"],
    "cobol": [".cob", ".COB", ".cpy", ".CPY"],
    "coffeescript": [".coffee"],
    "coldfusioncfc": [".cfc"],
    "coldfusionhtml": [".cfm", ".cfml"],
    "commonlisp": [".cl", ".lisp"],
    "componentpascal": [".cp", ".cps"],
    "coq": [".v"],
    "cpp": [
        ".cpp",
        ".hpp",
        ".c++",
        ".h++",
        ".cc",
        ".hh",
        ".cxx",
        ".hxx",
        ".C",
        ".H",
        ".cp",
        ".CPP",
    ],
    "cppobjdump": [".cpp-objdump", ".c++-objdump", ".cxx-objdump"],
    "crmsh": [".crmsh", ".pcmk"],
    "croc": [".croc"],
    "cryptol": [".cry"],
    "crystal": [".cr"],
    "csounddocument": [".csd"],
    "csoundorchestra": [".orc", ".udo"],
    "csoundscore": [".sco"],
    "css": [".css"],
    "cuda": [".cu", ".cuh"],
    "cypher": [".cyp", ".cypher"],
    "cython": [".pyx", ".pxd", ".pxi"],
    "d": [".d", ".di"],
    "dobjdump": [".d-objdump"],
    "darcspatch": [".dpatch", ".darcspatch"],
    "dart": [".dart"],
    "dasm16": [".dasm16", ".dasm"],
    "debiancontrol": ["control"],
    "delphi": [".pas", ".dpr"],
    "devicetree": [".dts", ".dtsi"],
    "dg": [".dg"],
    "diff": [".diff", ".patch"],
    "docker": ["Dockerfile", ".docker"],
    "dtd": [".dtd"],
    "duel": [".duel", ".jbst"],
    "dylanconsole": [".dylan-console"],
    "dylan": [".dylan", ".dyl", ".intr"],
    "dylanlid": [".lid", ".hdp"],
    "ecl": [".ecl"],
    "ec": [".ec", ".eh"],
    "earlgrey": [".eg"],
    "easytrieve": [".ezt", ".mac"],
    "ebnf": [".ebnf"],
    "eiffel": [".e"],
    "elixir": [".ex", ".eex", ".exs"],
    "elm": [".elm"],
    "emacslisp": [".el"],
    # "email": [".eml"], # not a programming language
    "erlang": [".erl", ".hrl", ".es", ".escript"],
    "erlangshell": [".erl-sh"],
    "evoquehtml": [".html"],
    "evoque": [".evoque"],
    "evoquexml": [".xml"],
    "execline": [".exec"],
    "ezhil": [".n"],
    "fsharp": [".fs", ".fsi"],
    "fstar": [".fst", ".fsti"],
    "factor": [".factor"],
    "fancy": [".fy", ".fancypack"],
    "fantom": [".fan"],
    "felix": [".flx", ".flxh"],
    "fennel": [".fnl"],
    "fishshell": [".fish", ".load"],
    "floscript": [".flo"],
    "forth": [".frt", ".fs"],
    "fortranfixed": [".f", ".F"],
    "fortran": [".f03", ".f90", ".F03", ".F90"],
    "foxpro": [".PRG", ".prg"],
    "freefem": [".edp"],
    "gap": [".g", ".gd", ".gi", ".gap"],
    "gdscript": [".gd"],
    "glshader": [".vert", ".frag", ".geo"],
    "gas": [".s", ".S"],
    "genshi": [".kid"],
    "gettext": [".pot", ".po"],
    "gherkin": [".feature"],
    "gnuplot": [".plot", ".plt"],
    "go": [".go"],
    "golo": [".golo"],
    "gooddatacl": [".gdc"],
    "gosu": [".gs", ".gsx", ".gsp", ".vark"],
    "gosutemplate": [".gst"],
    "groff": [".[1234567]", ".man"],
    "groovy": [".groovy", ".gradle"],
    "hlslshader": [".hlsl", ".hlsli"],
    "haml": [".haml"],
    "handlebarshtml": [".handlebars", ".hbs"],
    "haskell": [".hs"],
    "haxe": [".hx", ".hxsl"],
    "hsail": [".hsail"],
    "html": [".html", ".htm", ".xhtml", ".xslt"],
    "htmlphp": [".phtml"],
    "hxml": [".hxml"],
    "hy": [".hy"],
    "hybris": [".hy", ".hyb"],
    "idl": [".pro"],
    "icon": [".icon", ".ICON"],
    "idris": [".idr"],
    "igor": [".ipf"],
    "inform6": [".inf"],
    "inform6template": [".i6t"],
    "inform7": [".ni", ".i7x"],
    "ini": [".ini", ".cfg", ".inf"],
    "io": [".io"],
    "ioke": [".ik"],
    "irclogs": [".weechatlog"],
    "isabelle": [".thy"],
    "j": [".ijs"],
    "jags": [".jag", ".bug"],
    "jasmin": [".j"],
    "java": [".java"],
    "javascript": [".js", ".jsm", ".mjs", ".javascript"],
    "jcl": [".jcl"],
    "jsgf": [".jsgf"],
    "jsonld": [".jsonld"],
    "json": [".json", "Pipfile.lock"],
    "jsp": [".jsp"],
    "julia": [".jl"],
    "juttle": [".juttle"],
    "kal": [".kal"],
    "kconfig": ["Kconfig*", "*Config.in*", "external.in*", "standard-modules.in"],
    "kernellog": [".kmsg", ".dmesg"],
    "koka": [".kk", ".kki"],
    "kotlin": [".kt", ".kts"],
    "lsl": [".lsl"],
    "lasso": [".lasso", ".lasso[89]"],
    "lean": [".lean"],
    "lesscss": [".less"],
    "limbo": [".b"],
    "liquid": [".liquid"],
    "literateagda": [".lagda"],
    "literatecryptol": [".lcry"],
    "literatehaskell": [".lhs"],
    "literateidris": [".lidr"],
    "livescript": [".ls"],
    "llvm": [".ll"],
    "llvmmir": [".mir"],
    "logos": [".x", ".xi", ".xm", ".xmi"],
    "logtalk": [".lgt", ".logtalk"],
    "lua": [".lua", ".wlua"],
    "moocode": [".moo"],
    "makefile": [".mak", ".mk", "Makefile", "makefile", "Makefile.*", "GNUmakefile"],
    "mako": [".mao"],
    "maql": [".maql"],
    "markdown": [".md", ".markdown"],
    "mask": [".mask"],
    "mason": [".m", ".mhtml", ".mc", ".mi", "autohandler", "dhandler"],
    "mathematica": [".nb", ".cdf", ".nbp", ".ma"],
    "matlab": [".m"],
    "miniscript": [".ms"],
    "modelica": [".mo"],
    "modula2": [".def", ".mod"],
    "monkey": [".monkey"],
    "monte": [".mt"],
    "moonscript": [".moon"],
    "mosel": [".mos"],
    "mozpreproccss": [".css.in"],
    "mozpreprocjavascript": [".js.in"],
    "mozpreprocxul": [".xul.in"],
    "mql": [".mq4", ".mq5", ".mqh"],
    "mscgen": [".msc"],
    "mupad": [".mu"],
    "mxml": [".mxml"],
    "myghty": [".myt", "autodelegate"],
    "ncl": [".ncl"],
    "nsis": [".nsi", ".nsh"],
    "nasm": [".asm", ".ASM"],
    "nasmobjdump": [".objdump-intel"],
    "nemerle": [".n"],
    "nesc": [".nc"],
    "newlisp": [".lsp", ".nl", ".kif"],
    "newspeak": [".ns2"],
    "nginxconf": ["nginx.conf"],
    "nimrod": [".nim", ".nimrod"],
    "nit": [".nit"],
    "nix": [".nix"],
    "nusmv": [".smv"],
    "objdump": [".objdump"],
    "objectivec": [".m", ".h"],
    "objectivecpp": [".mm", ".hh"],
    "objectivej": [".j"],
    "ocaml": [".ml", ".mli", ".mll", ".mly"],
    "octave": [".m"],
    "odin": [".odin"],
    "ooc": [".ooc"],
    "opa": [".opa"],
    "openedge": [".p", ".cls"],
    "pacmanconf": ["pacman.conf"],
    "pan": [".pan"],
    "parasail": [".psi", ".psl"],
    "pawn": [".p", ".pwn", ".inc"],
    "peg": [".peg"],
    "perl6": [
        ".pl",
        ".pm",
        ".nqp",
        ".p6",
        ".6pl",
        ".p6l",
        ".pl6",
        ".6pm",
        ".p6m",
        ".pm6",
        ".t",
        ".raku",
        ".rakumod",
        ".rakutest",
        ".rakudoc",
    ],
    "perl": [".pl", ".pm", ".t", ".perl"],
    "php": [".php", ".php[345]", ".inc"],
    "pig": [".pig"],
    "pike": [".pike", ".pmod"],
    "pkgconfig": [".pc"],
    "pointless": [".ptls"],
    "pony": [".pony"],
    "postscript": [".ps", ".eps"],
    "povray": [".pov", ".inc"],
    "powershell": [".ps1", ".psm1"],
    "praat": [".praat", ".proc", ".psc"],
    "prolog": [".ecl", ".prolog", ".pro", ".pl"],
    "promql": [".promql"],
    "properties": [".properties"],
    "protobuf": [".proto"],
    "pug": [".pug", ".jade"],
    "puppet": [".pp"],
    "pypylog": [".pypylog"],
    "python2traceback": [".py2tb"],
    "python": [
        ".py",
        ".pyw",
        ".jy",
        ".sage",
        ".sc",
        "SConstruct",
        "SConscript",
        ".bzl",
        "BUCK",
        "BUILD",
        "BUILD.bazel",
        "WORKSPACE",
        ".tac",
        ".python",
    ],
    "pythontraceback": [".pytb", ".py3tb"],
    "qbasic": [".BAS", ".bas"],
    "qvto": [".qvto"],
    "qml": [".qml", ".qbs"],
    "rconsole": [".Rout"],
    "rnccompact": [".rnc"],
    "rpmspec": [".spec"],
    "racket": [".rkt", ".rktd", ".rktl"],
    "ragelc": [".rl"],
    "ragelcpp": [".rl"],
    "rageld": [".rl"],
    "ragelembedded": [".rl"],
    "rageljava": [".rl"],
    "ragelobjectivec": [".rl"],
    "ragelruby": [".rl"],
    "rd": [".Rd"],
    "reason": [".re", ".rei"],
    "rebol": [".r", ".r3", ".reb"],
    "red": [".red", ".reds"],
    "redcode": [".cw"],
    "regedit": [".reg"],
    "rexx": [".rexx", ".rex", ".rx", ".arexx"],
    "rhtml": [".rhtml"],
    "ride": [".ride"],
    "roboconfgraph": [".graph"],
    "roboconfinstances": [".instances"],
    "robotframework": [".robot"],
    "rql": [".rql"],
    "rsl": [".rsl"],
    "rst": [".rst", ".rest"],
    "rts": [".rts"],
    "ruby": [
        ".rb",
        ".rbw",
        "Rakefile",
        ".rake",
        ".gemspec",
        ".rbx",
        ".duby",
        "Gemfile",
        ".ruby",
    ],
    "rust": [".rs", ".rs.in"],
    "sas": [".SAS", ".sas"],
    "s": [".S", ".R", ".Rhistory", ".Rprofile", ".Renviron"],
    "sml": [".sml", ".sig", ".fun"],
    "sarl": [".sarl"],
    "sass": [".sass"],
    "scala": [".scala"],
    "scaml": [".scaml"],
    "scdoc": [".scd", ".scdoc"],
    "scheme": [".scm", ".ss"],
    "scilab": [".sci", ".sce", ".tst"],
    "scss": [".scss"],
    "shexc": [".shex"],
    "shen": [".shen"],
    "sieve": [".siv", ".sieve"],
    "silver": [".sil", ".vpr"],
    "singularity": [".def", "Singularity"],
    "slash": [".sla"],
    "slim": [".slim"],
    "slurmbash": [".sl"],
    "smali": [".smali"],
    "smalltalk": [".st"],
    "smartgameformat": [".sgf"],
    "smarty": [".tpl"],
    "snobol": [".snobol"],
    "snowball": [".sbl"],
    "solidity": [".sol"],
    "sourcepawn": [".sp"],
    "sourceslist": ["sources.list"],
    "sparql": [".rq", ".sparql"],
    "sql": [".sql"],
    "sqliteconsole": [".sqlite3-console"],
    "squidconf": ["squid.conf"],
    "ssp": [".ssp"],
    "stan": [".stan"],
    "stata": [".do", ".ado"],
    "supercollider": [".sc", ".scd"],
    "swift": [".swift"],
    "swig": [".swg", ".i"],
    "systemverilog": [".sv", ".svh"],
    "tap": [".tap"],
    "tnt": [".tnt"],
    "toml": [".toml", "Pipfile", "poetry.lock"],
    "tads3": [".t"],
    "tasm": [".asm", ".ASM", ".tasm"],
    "tcl": [".tcl", ".rvt"],
    "tcsh": [".tcsh", ".csh"],
    "teatemplate": [".tea"],
    "teraterm": [".ttl"],
    "termcap": ["termcap", "termcap.src"],
    "terminfo": ["terminfo", "terminfo.src"],
    "terraform": [".tf"],
    "tex": [".tex", ".aux", ".toc"],
    "text": [".txt"],
    "thrift": [".thrift"],
    "tiddlywiki5": [".tid"],
    "todotxt": ["todo.txt", ".todotxt"],
    "transactsql": [".sql"],
    "treetop": [".treetop", ".tt"],
    "turtle": [".ttl"],
    "twightml": [".twig"],
    "typescript": [".ts", ".tsx"],
    "typoscript": [".typoscript"],
    "ucode": [".u", ".u1", ".u2"],
    "unicon": [".icn"],
    "urbiscript": [".u"],
    "usd": [".usd", ".usda"],
    "vbscript": [".vbs", ".VBS"],
    "vcl": [".vcl"],
    "vgl": [".rpf"],
    "vala": [".vala", ".vapi"],
    "vbnetaspx": [".aspx", ".asax", ".ascx", ".ashx", ".asmx", ".axd"],
    "vbnet": [".vb", ".bas"],
    "velocity": [".vm", ".fhtml"],
    "verilog": [".v"],
    "vhdl": [".vhdl", ".vhd"],
    "vim": [
        ".vim",
        ".vimrc",
        ".exrc",
        ".gvimrc",
        "_vimrc",
        "_exrc",
        "_gvimrc",
        "vimrc",
        "gvimrc",
    ],
    "wdiff": [".wdiff"],
    "webidl": [".webidl"],
    "whiley": [".whiley"],
    "x10": [".x10"],
    "xquery": [".xqy", ".xquery", ".xq", ".xql", ".xqm"],
    "xml": [".xml", ".xsl", ".rss", ".xslt", ".xsd", ".wsdl", ".wsf"],
    "xorg": ["xorg.conf"],
    "xslt": [".xsl", ".xslt", ".xpl"],
    "xtend": [".xtend"],
    "xtlang": [".xtm"],
    "yamljinja": [".sls"],
    "yaml": [".yaml", ".yml"],
    "yang": [".yang"],
    "zeek": [".zeek", ".bro"],
    "zephir": [".zep"],
    "zig": [".zig"],
}
