"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iot = require("@aws-cdk/aws-iot");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class IotToS3 extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToS3Props} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup S3 Bucket
        if (!props.existingBucketInterface) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            this.s3BucketInterface = this.s3Bucket;
        }
        else {
            this.s3BucketInterface = props.existingBucketInterface;
        }
        // Role to allow IoT to send messages to the S3 Bucket
        this.iotActionsRole = new iam.Role(this, 'iot-actions-role', {
            assumedBy: new iam.ServicePrincipal('iot.amazonaws.com')
        });
        // Setup the IAM policy for IoT Actions
        this.s3BucketInterface.grantWrite(this.iotActionsRole);
        const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
                s3: {
                    key: props.s3Key || '${topic()}/${timestamp()}',
                    bucketName: this.s3BucketInterface.bucketName,
                    roleArn: this.iotActionsRole.roleArn
                }
            }]);
        const iotTopicProps = defaults.overrideProps(defaultIotTopicProps, props.iotTopicRuleProps, true);
        // Create the IoT topic rule
        this.iotTopicRule = new iot.CfnTopicRule(this, 'IotTopicRule', iotTopicProps);
        // If existing bucket has a KMS CMK, explicitly provide IoTActionsRole necessary access to write to the bucket
        if (this.s3Bucket && this.s3Bucket.encryptionKey) {
            this.s3Bucket.encryptionKey.grantEncrypt(this.iotActionsRole);
        }
    }
}
exports.IotToS3 = IotToS3;
_a = JSII_RTTI_SYMBOL_1;
IotToS3[_a] = { fqn: "@aws-solutions-constructs/aws-iot-s3.IotToS3", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,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