# botank
Библиотека для автоматического тестирования навыков Алисы 
(и в перспективе других чат-ботов).
Засыпаем бота случайными запросами и смотрим, как он справляется.

Библиотека написана на питоне, но ботов дёргает по вебхуку, 
и поэтому сами боты могут быть написаны на любом языке или вообще без языка.

Ссылки: [GitHub](https://github.com/avidale/botank), 
[PyPI](https://pypi.org/project/botank/).

Read this in other languages: 
[English](https://github.com/avidale/botank/blob/master/README_EN.md), 
[Русский](https://github.com/avidale/botank).

## Самое главное
Для установки необходимо иметь Python>=3.6 и пакетный менеджер pip 
(либо аналог). 
Пока что только так. 

Установка:
```commandline
pip install botank
```

Как запустить:
```commandline
python -m botank http://localhost:5000/alice/ -n 100 -o results.txt
```
При подобном запуске ботанк направит по адресу `http://localhost:5000/alice/` 
100 случайных запросов в навык, и сохранит результат обстрела 
в файл `results.txt`.

В процессе диалог будет примерно таким:
```commandline
Running 100 turns of Botank simulation...

u: привет
b: Привет. Добро пожаловать в навык "Донорство костного мозга". Я отвечу на ваши вопросы про кровь и костный мозг. Выберите раздел и начнем!
Например: Рак крови.
u: Костный мозг
b: Хорошо, поговорим на тему костный мозг. Выбирайте вопрос! Например, можете спросить: Как по-английски будет костный мозг?
u: Что такое кроветворение?
b: Кроветворение - это процесс образования, развития и созревания клеток крови - лейкоцитов, эритроцитов, тромбоцитов. За 70 лет жизни человека костный мозг вырабатывает приблизительно 1000 кг лейкоцитов и 650 кг эритроцитов. Даже меня это впечатляет.
u: и 650
...
u: домой
b: Я вас не понимаю. Спросите у меня что-нибудь про кровь или костный мозг! Например: Передается ли рак крови половым путем?
u: Как стать донором костного мозга?
b: Мне кажется, что вы хороший человек, раз задаете этот вопрос. Стать донором очень просто. Вы можете сдать кровь в ближайшей лаборатории «Инвитро», и ее внесут в базу потенциальных доноров. И если ваш генетический двойник заболеет, вы сможете спасти его жизнь. Хотите узнать, как найти генетического двойника?

Summary:
Codes: 200 - 100
Timings: min 1.02557, max 1.35971, average 1.07610431
```

## Зачем
Предполагается, что ботанк будет применяться на ранних стадиях разработки
навыка, когда он ещё не испытан "в бою", 
и нужно его перед релизом испытать хоть как-то.

Во-первых, подобный обстрел может помочь протыкать все сценарии диалога
(если для них есть саджесты) и выявить запросы, на которых бот падает. 

Во-вторых, обстрел может выявить запросы, на которых бот отвечает слишком долго.

В-третьих, ботанк (когда мы его допилим) можно будет использовать 
для нагрузочного тестирования, чтобы понимать, под каким RPS навык может выжить.

Ну и сами тексты сгенерированного скриптом диалога, несмотря на его бредовость, 
надеемся, могут навести разработчика бота на плодотворные мысли.


## Как это работает
На каждом шаге ботанк случайным образом выбирает одно из действий:
1. нажать на случайную кнопку из предложенных;
1. кинуть в бота случайной подстрокой его предыдущего ответа;
1. кинуть в бота случайно выбранной фразой из захардкоженного списка.

Эти действия происходят каскадно: (1) происходит только если кнопки есть, 
да и то лишь с некоторой вероятностью (`--button`). 
Действие (2) происходит, только если 
не произошло (1), и тоже лишь с некоторой вероятностью (`--repeat`). 
Во всех остальных случаех происходит (3).

После заданного числа итераций подобного обстрела выдаётся статистика 
по кодам и временам ответа, 
а запросы и ответы сохраняются в файл для дальнейшего анализа.

В выходном файле каждая строка - это JSON, содержащий поля:
* `request` - отправленный в навык запрос;
* `response` - ответ навыка;
* `code` - код ответа;
* `time` - время, потребовавшееся на ответ.

## Как это конфигурировать

Всё управление "симулятором юзера" - опциями командной строки:
* `--button` вероятность, с которой симулятор читает случайную кнопку 
(по умолчанию равна 0.5).
* `--repeat` вероятность, с которой симулятор читает случайную подстроку
предыдущего ответа, если не нажал кнопку (по умолчанию так же равна 0.5) 
* `--texts` - путь до текстового файла с потенциальными запросами в навык. 
Если его не указывать, на шаге (3) используется десяток захардкоженных фраз.
Указать эту опцию можно много раз, тогда фразы из разных файлов будут перемешаны.

Другие опции:
* `-n` - число запросов (по умолчанию 100)
* `-o` - файл для сохранения результатов
* `--silent` - не печатать текущий диалог в командную строку 
(по умолчанию печатает)

## Дальнейшие планы
Предполагается добавить в этот инструмент ещё несколько опций:
* Явное управление нагрузкой - чтобы можно было делать 
нагрузочное тестирование навыков. 
* Использование машиннообученной "болталки" в качестве 
модели пользователя - чтобы генерируемые диалоги были реалистичнее.
* Использование ботанка как питонячей либы для автоматических 
функциональных тестов навыка.


Обсудить желаемые фичи или пожаловаться на баги можно 
в [issues](https://github.com/avidale/botank/issues)
или в [чате разработчиков навыков Алисы](https://t.me/yadialogschat).
