/*
* Copyright (c) 2021, Stefan Güttel, Xinye Chen
* Licensed under BSD 3-Clause License
* All rights reserved.
*

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <iostream>
#include "toydata.h"
#include "ABBA.h"
#include <vector>
using namespace std;

int main(){
    vector<double> r_fabba_series;
    std::vector<std::string> symbols;
    fABBA::ABBA fabba;

        // ---------------- test 1 ------------------ 
    auto ts1 = generate_random_sequence(10, "uniform");
    cout << "\n*****************************test 1" << endl<< endl; 
    print_vector("time series 1:", ts1);
    // no paramters setting; 
    fabba = fABBA::ABBA(0.01, 0.01, "lexi", 1, 20, true);
    symbols = fabba.fit_transform(ts1);
    print_vector("symbols: ",symbols);
    r_fabba_series = fabba.inverse_transform(ts1[0]);
    print_vector("reconstruction series: ", r_fabba_series);

        // ---------------- test 2 ------------------ 
    auto ts2 = generate_random_sequence(10, "normal");
    cout << "\n*****************************test 2" << endl<< endl; 
    print_vector("time series 2:", ts2);
    // no paramters setting; 
    fabba = fABBA::ABBA(0.1, 0.1, "lexi", 1, 20, true);
    symbols = fabba.fit_transform(ts2);
    print_vector("symbols: ", symbols);
    r_fabba_series = fabba.inverse_transform(ts2[0]);
    print_vector("reconstruction series: ", r_fabba_series);

        // ---------------- python compare, fixed sample ------------------ 
    vector<double> ts = \
        {9.71210492e-01, 9.49020177e-01, 7.76122327e-01, 2.93301159e-01,
        7.16476003e-01, 7.59666778e-01, 5.47098823e-01, 4.63685454e-01,
        3.27870667e-01, 4.76515126e-01, 5.28159856e-01, 8.36771026e-01,
        4.74866473e-01, 3.72360827e-01, 4.90481025e-01, 3.76484871e-01,
        3.87213840e-01, 3.54050327e-01, 8.07605954e-01, 9.65929346e-01,
        5.37673479e-01, 2.05198799e-01, 1.59241293e-01, 7.29704941e-02,
        4.50472655e-01, 2.76425186e-01, 6.41226102e-01, 9.00278024e-01,
        6.91075195e-01, 6.58182645e-01, 8.17159487e-01, 2.79593769e-01,
        6.96564817e-01, 1.40699464e-01, 9.11284637e-01, 8.36180605e-01,
        5.35101455e-01, 4.10871716e-01, 3.93869972e-01, 1.52941995e-01,
        9.57789930e-01, 4.97761491e-01, 1.32957246e-01, 4.16498048e-01,
        4.96037802e-01, 1.84492061e-01, 5.53192176e-01, 6.82172596e-01,
        9.56131964e-01, 3.12346830e-01, 4.53853184e-01, 9.99711664e-01,
        9.74750095e-01, 9.90629034e-01, 4.16251832e-01, 6.28875803e-01,
        2.80670851e-01, 7.29182125e-01, 3.37534328e-01, 2.35027562e-01,
        6.39395275e-01, 9.46153410e-01, 9.86857295e-01, 7.50510041e-01,
        5.91754823e-01, 4.95504614e-01, 5.03069511e-02, 1.32838729e-01,
        1.28457485e-01, 6.16543210e-02, 9.80749116e-01, 7.22957971e-01,
        5.17658780e-01, 8.48762123e-01, 9.09563972e-02, 8.65253895e-01,
        9.50985786e-01, 4.71499991e-01, 3.53669951e-01, 1.64278269e-02,
        5.19949611e-01, 3.12903782e-01, 1.97035290e-01, 9.06497745e-01,
        3.95314909e-01, 4.38211218e-01, 8.54108157e-01, 5.36589274e-01,
        6.18051870e-01, 1.79498556e-01, 9.62795851e-01, 8.22506407e-01,
        8.22261084e-01, 3.95648055e-01, 2.13658651e-01, 1.62015562e-01,
        7.32697141e-01, 9.05757952e-02, 4.76051408e-01, 2.40558265e-01,
        6.73310121e-01, 2.56702026e-01, 7.08563312e-01, 9.71055650e-01,
        6.96639339e-02, 5.54270590e-01, 8.38339458e-01, 6.72925848e-01,
        8.78430954e-01, 9.19169589e-01, 8.96168847e-01, 6.71144789e-01,
        3.77417139e-01, 6.85718585e-01, 9.51710278e-01, 2.89911397e-02,
        6.31505558e-01, 9.20001494e-01, 6.30029577e-01, 7.82552552e-01,
        2.98190543e-01, 2.99276194e-01, 3.20253309e-01, 1.85660166e-01,
        5.44869881e-01, 3.78228053e-01, 8.65169411e-01, 2.71331706e-01,
        8.96595180e-01, 7.45581814e-01, 5.79631874e-03, 7.52399125e-04,
        2.11628106e-01, 1.93512044e-01, 8.49099133e-01, 7.41939072e-01,
        4.86814083e-01, 8.78416346e-01, 7.46240935e-02, 6.66528894e-01,
        3.98709498e-02, 3.91370323e-01, 2.80513461e-02, 7.24722571e-01,
        7.27718554e-01, 2.19752101e-01, 1.55515729e-01, 4.22147190e-01,
        5.22806077e-01, 2.87620865e-01, 1.72529150e-01, 8.81122425e-01,
        3.36697753e-01, 6.92626540e-01, 7.72851433e-01, 7.65757241e-01,
        5.87475868e-01, 9.27892610e-03, 2.17248053e-01, 4.58707006e-01,
        8.97177778e-01, 1.56016630e-01, 8.01051114e-01, 7.36135394e-01,
        9.90202716e-01, 7.86288002e-01, 1.73653730e-01, 5.95385857e-01,
        1.78372425e-01, 5.67313935e-01, 5.50193247e-01, 6.95272613e-01,
        8.46415136e-01, 9.16485375e-01, 4.71152444e-03, 3.56677231e-01,
        9.52972628e-01, 5.73659545e-01, 1.18085196e-02, 5.63713068e-02,
        5.47402533e-01, 7.15735996e-01, 6.66196746e-01, 3.02453847e-01,
        6.95229522e-01, 7.17510747e-01, 6.01730562e-01, 8.16554539e-01,
        7.86294025e-01, 3.22464525e-01, 6.24508879e-01, 6.57875492e-01,
        1.99667721e-01, 2.92434481e-01, 8.75539206e-01, 1.20192529e-01,
        5.75390781e-01, 7.27482382e-01, 7.38439467e-01, 8.38213198e-01,
        3.38388488e-01, 4.83420118e-01, 5.18238380e-01, 9.13296060e-01,
        7.36914007e-01, 9.50882458e-01, 6.59886645e-01, 7.26411378e-01,
        9.54949779e-01, 3.94879517e-01, 3.57218494e-01, 8.93110077e-01,
        4.89523008e-01, 8.58827462e-01, 3.63174279e-01, 3.06396995e-01,
        5.57461354e-02, 9.41001521e-02, 2.28381844e-01, 3.66088778e-01,
        2.14405319e-01, 5.46261633e-01, 1.78059627e-01, 8.17384966e-01,
        8.67830175e-01, 5.36769157e-01, 4.97240680e-01, 3.09840478e-01,
        8.97992895e-01, 5.37006876e-01, 5.34304084e-01, 1.97014380e-01,
        7.81549037e-01, 2.30457122e-02, 2.14788922e-01, 1.73464014e-02,
        9.81100895e-01, 9.02537123e-01, 1.01848131e-01, 6.45126712e-01,
        2.51255789e-01, 8.27160531e-01, 7.36390259e-01, 2.58890925e-01,
        6.88157407e-01, 3.90189599e-01, 9.10138639e-01, 5.46772242e-01,
        5.04676235e-01, 3.09087501e-02, 7.58296421e-01, 7.07132354e-01,
        8.49028060e-01, 9.59170294e-01, 9.60200438e-01, 9.21277151e-01,
        6.40062303e-01, 4.21882385e-01, 8.34420233e-02, 8.46788935e-01,
        4.79957368e-01, 5.26354593e-01, 3.14848432e-01, 8.95799122e-01,
        7.81918085e-01, 7.39260606e-01, 7.32971878e-01, 9.26762837e-01,
        5.71189823e-01, 3.64755746e-01, 7.05466404e-01, 2.69960607e-01,
        5.46866512e-02, 1.96995710e-01, 9.03662194e-01, 3.10731201e-01,
        4.86106335e-02, 2.45238690e-01, 9.57894470e-01, 1.19775890e-01,
        9.50653277e-01, 7.88754453e-01, 1.75930504e-01, 5.65314734e-01,
        5.94687916e-01, 7.36992651e-01, 9.74715884e-01, 8.52390062e-01,
        3.20412979e-01, 3.43922313e-01, 5.84100098e-01, 2.01634919e-01,
        1.38297345e-01, 8.89228445e-01, 7.95102485e-01, 5.31868480e-01,
        3.43698703e-01, 2.93778188e-01, 5.64113466e-01, 1.85536818e-01,
        4.85343204e-01, 1.15391614e-01, 9.23468003e-03, 1.46179865e-01,
        8.45652171e-01, 2.45444394e-01, 5.34425589e-01, 4.41750636e-01,
        2.45834079e-01, 8.62316212e-01, 4.66032765e-01, 8.36290351e-01,
        8.42481122e-01, 3.95802454e-01, 3.11041617e-01, 3.38929911e-01,
        7.45518734e-02, 6.38248935e-01, 4.78047904e-02, 6.72851996e-01,
        9.40017738e-01, 8.89741340e-02, 5.23185886e-01, 4.61702930e-01,
        5.19317834e-01, 9.78011415e-01, 9.41479068e-01, 4.94152972e-01,
        5.83582273e-01, 9.56460081e-01, 9.35419434e-01, 5.05357821e-01,
        8.50043301e-01, 7.07056185e-02, 9.92789891e-01, 5.18071357e-01,
        7.40038813e-01, 3.17122283e-01, 7.76085841e-01, 2.19234096e-01,
        2.89846871e-01, 5.51436463e-01, 2.16004404e-01, 8.24165101e-01,
        3.07683485e-01, 9.48500397e-02, 5.88939865e-01, 2.59905512e-01,
        6.26509611e-01, 9.92432037e-01, 6.64086993e-01, 9.73317322e-01,
        4.04428809e-01, 6.15625745e-01, 5.91212653e-01, 1.68711752e-01,
        1.05121580e-01, 2.26160877e-01, 7.55430477e-01, 6.38349804e-01,
        1.56460197e-01, 1.27558897e-02, 2.21241100e-01, 6.99262685e-01,
        7.13626680e-02, 6.25804795e-01, 5.53778595e-01, 7.35507966e-01,
        3.47784317e-01, 4.87894629e-01, 3.32054345e-01, 4.71877805e-01,
        2.14655412e-01, 9.37331499e-01, 8.90065257e-01, 7.95360854e-01,
        3.48713222e-02, 8.07325524e-01, 2.61108317e-01, 4.14429112e-01,
        3.71986875e-01, 2.30952739e-01, 4.24788852e-01, 3.23448700e-01,
        9.31304552e-01, 2.73711474e-01, 3.67881752e-01, 6.55747387e-01,
        6.66715606e-01, 6.43793364e-01, 2.43519809e-01, 6.57432405e-01,
        2.42161115e-01, 2.00570328e-01, 3.01330641e-01, 9.34846560e-01,
        5.91890848e-01, 1.73451205e-01, 5.81225572e-01, 1.85430422e-01,
        9.06028703e-01, 2.10031080e-01, 3.06143769e-03, 5.39915444e-01,
        1.72983482e-01, 1.96140561e-02, 2.98418841e-01, 6.90666405e-01,
        8.87976070e-01, 9.70838496e-01, 7.43282890e-01, 3.84743342e-01,
        1.47253175e-01, 2.47973246e-01, 1.46269242e-01, 3.52722829e-02,
        5.45010379e-01, 4.92920284e-01, 6.51154904e-01, 2.28005907e-01,
        9.31629297e-01, 8.96922727e-01, 1.26951753e-01, 7.19411040e-01,
        7.94497622e-01, 9.40606672e-01, 1.70012107e-01, 4.07428317e-01,
        8.63786846e-01, 7.64449750e-01, 7.41584726e-01, 4.55953048e-01,
        3.75787252e-01, 9.23015307e-01, 4.19400306e-01, 6.38006848e-01,
        5.05183731e-01, 6.02934138e-01, 1.93044625e-01, 6.85381333e-01,
        6.73746420e-01, 6.79953319e-01, 5.06071799e-01, 9.01867171e-01,
        1.14866074e-01, 6.73707363e-02, 6.68297064e-01, 4.41850419e-01,
        1.42615473e-01, 4.89049623e-01, 6.95334578e-01, 1.96358059e-01,
        3.03842777e-01, 5.61734970e-01, 2.70211396e-01, 9.94590678e-01,
        8.52105432e-01, 9.42621037e-03, 2.07615196e-01, 2.62122261e-02,
        5.09522958e-01, 7.45846077e-01, 8.38983554e-02, 6.58699432e-01,
        4.77946546e-01, 5.43226403e-02, 4.81318085e-01, 6.05562758e-01,
        6.55177710e-01, 6.45978906e-01, 8.48559772e-02, 9.96485163e-01,
        6.81244062e-01, 3.78032136e-01, 8.94750782e-01, 1.19674032e-01,
        2.02414220e-01, 9.72617552e-02, 8.32655623e-02, 1.27968198e-01,
        3.79766502e-01, 3.72523461e-01, 8.32347549e-01, 9.43519637e-01,
        1.18395231e-01, 2.09743092e-02, 3.34882149e-01, 2.45192758e-01,
        8.18629452e-01, 8.38759124e-01, 8.37183699e-01, 9.31323508e-01,
        8.72835864e-01, 3.79534806e-01, 8.45856671e-01, 8.21452989e-02,
        9.03793179e-02, 5.99509726e-01, 9.54773656e-01, 2.22434771e-01,
        2.69860508e-01, 3.48147902e-01, 4.33698712e-01, 1.32666658e-01,
        4.69806363e-01, 3.72400708e-01, 8.39420604e-01, 2.62755735e-01,
        1.99297969e-01, 1.41598882e-01, 4.75202929e-01, 2.90086857e-01,
        3.28242680e-01, 5.43989701e-01, 4.19914842e-01, 7.08517171e-01,
        5.97967898e-01, 9.49494776e-03, 3.49132107e-01, 4.63664903e-01,
        1.10379047e-01, 4.69397573e-01, 2.51238096e-01, 7.15020792e-01,
        8.13133543e-01, 6.59945446e-03, 4.95477382e-01, 2.02609739e-01,
        6.81409552e-01, 5.32513458e-01, 2.55394996e-01, 3.97466006e-01,
        4.80811914e-02, 6.84495951e-02, 2.65318853e-01, 6.61878435e-01,
        7.16367130e-01, 1.96649981e-01, 4.62782099e-01, 1.76137618e-01,
        1.24888848e-01, 2.93648587e-01, 9.99366882e-02, 2.09428558e-01,
        5.49183127e-01, 4.25704311e-01, 8.25807765e-01, 1.53818102e-01,
        4.86749881e-01, 9.14973969e-01, 1.11505940e-01, 4.87150597e-01,
        3.94922393e-01, 3.54923380e-01, 7.92617113e-01, 8.09440026e-01,
        1.08179347e-02, 3.50093795e-01, 7.91610869e-01, 7.27351476e-01,
        6.51465335e-01, 8.50684492e-01, 6.60498319e-01, 7.79211022e-01,
        7.63675571e-01, 4.98022251e-01, 6.55324126e-01, 6.09277562e-01,
        1.43045732e-01, 7.75588732e-01, 5.67803039e-02, 4.18511632e-01,
        8.97505117e-01, 8.44365700e-01, 3.86158924e-01, 3.82828126e-01,
        4.85734348e-01, 1.48002416e-01, 4.95881757e-01, 3.65160884e-02,
        2.66330838e-01, 2.49039356e-01, 9.85033170e-01, 9.74388769e-01,
        5.84623154e-01, 6.93437514e-01, 6.41540210e-02, 8.36754525e-01,
        3.17635542e-03, 1.05871754e-02, 9.89705822e-01, 7.11458484e-01,
        9.63197710e-01, 9.70625689e-01, 7.84932009e-01, 8.56109042e-01,
        3.70452107e-01, 1.87523800e-01, 4.33250386e-01, 9.82856590e-02,
        7.30356552e-01, 5.32224204e-01, 8.35470511e-01, 6.21877135e-01,
        8.81619387e-01, 9.61460130e-01, 5.61818532e-01, 3.04455394e-01,
        1.20041848e-01, 5.19957067e-01, 5.40779130e-01, 7.14697044e-01,
        3.81634939e-01, 5.92204246e-01, 1.79325574e-01, 6.15535704e-01,
        5.81427594e-01, 6.35223029e-01, 9.85099374e-01, 2.27509956e-01,
        8.52810838e-01, 2.07859729e-02, 3.46053585e-01, 9.89878973e-01,
        7.30426796e-01, 7.68124384e-01, 1.89165227e-01, 7.62410693e-01,
        9.18920264e-01, 8.84760679e-02, 1.77880129e-01, 6.35730906e-01,
        7.30700037e-01, 8.05393318e-01, 1.64947659e-01, 8.12872133e-02,
        1.36693981e-01, 6.39862223e-01, 3.36106610e-01, 6.80619018e-01,
        5.23548802e-01, 1.26952826e-01, 8.34033035e-01, 4.47598199e-01,
        6.91018215e-02, 4.06680937e-01, 6.09156051e-01, 9.81630297e-01,
        8.16163585e-01, 8.31186081e-01, 4.43243003e-02, 6.11277211e-01,
        3.78704324e-01, 9.51916231e-01, 5.29274164e-01, 9.09915341e-01,
        8.37342673e-05, 6.81870200e-01, 3.77870930e-01, 5.54096355e-02,
        4.97987956e-01, 5.60631397e-01, 2.27867276e-01, 4.10571432e-01,
        3.06359005e-01, 6.28476797e-02, 3.88659279e-01, 2.31583069e-01,
        3.95269452e-01, 4.22257976e-01, 7.63429919e-01, 7.85140636e-01,
        3.10704111e-01, 2.29121179e-02, 3.65971560e-01, 3.83575107e-01,
        1.19281278e-01, 9.88390293e-02, 4.15222977e-01, 6.54053376e-02,
        9.45525516e-01, 3.17554003e-01, 4.60546386e-02, 7.38194056e-01,
        9.37793018e-01, 7.21310590e-01, 3.64800387e-01, 8.13248272e-01,
        8.82034354e-01, 8.62348104e-01, 7.60276598e-01, 3.38531739e-02,
        9.71397597e-01, 3.42273355e-01, 6.10153474e-01, 6.98149122e-01,
        9.43138909e-01, 8.58579255e-01, 7.62385982e-01, 6.54890693e-01,
        8.86063323e-01, 2.52038895e-01, 2.03076191e-01, 9.63722537e-01,
        5.84717327e-01, 6.95406767e-01, 9.70767116e-01, 9.29440571e-02,
        6.74914909e-01, 2.55812394e-01, 3.23822749e-01, 2.93008003e-01,
        9.18243640e-01, 8.38406745e-01, 7.69988921e-01, 6.81279599e-01,
        3.97149570e-01, 9.96516901e-01, 6.45392659e-03, 4.54037101e-01,
        9.21325368e-01, 3.87410622e-01, 5.21271418e-01, 9.25851934e-01,
        5.44920868e-01, 9.52854342e-02, 7.85812657e-02, 6.72515830e-01,
        3.26080459e-01, 2.95565156e-01, 2.58916244e-01, 5.67462617e-01,
        3.59478406e-01, 4.66105386e-01, 3.16824415e-01, 2.92983925e-01,
        8.14554369e-01, 1.90172818e-01, 6.16294719e-01, 8.86479094e-01,
        5.41938659e-01, 1.29779378e-01, 9.03349122e-01, 4.93546019e-01,
        9.50751528e-02, 3.76933788e-01, 9.75933384e-01, 3.34299675e-01,
        7.10943611e-01, 6.16393565e-01, 6.23363309e-01, 2.60694998e-01,
        6.36286925e-01, 9.82358617e-01, 1.02675767e-01, 5.03663370e-01,
        7.31991615e-01, 6.92891748e-01, 7.87225031e-01, 5.69509235e-01,
        8.19025310e-02, 4.19823933e-01, 3.52204859e-01, 7.13431588e-01,
        7.17969672e-02, 4.92274064e-01, 3.83159851e-01, 9.42686918e-01,
        2.22551547e-01, 4.48560683e-01, 4.81352953e-01, 9.62134453e-01,
        8.10836447e-01, 4.53502638e-01, 4.85443713e-01, 1.69208989e-01,
        8.07798350e-01, 4.70787154e-01, 1.03795047e-01, 7.79760452e-01,
        5.48185667e-01, 5.06462120e-01, 7.99473784e-01, 3.30450489e-01,
        4.41719776e-01, 8.11127313e-03, 9.88943884e-01, 7.45141886e-01,
        2.56832210e-01, 1.78801974e-01, 8.86623700e-01, 8.13811413e-02,
        7.24393640e-01, 2.64810670e-02, 8.79830444e-01, 4.32262993e-01,
        2.60661998e-01, 6.35107619e-01, 3.29056277e-01, 2.98844811e-01,
        6.93146417e-01, 6.34583744e-03, 9.66529453e-01, 7.85072338e-01,
        7.37522346e-01, 4.15232592e-01, 6.90753851e-02, 1.30172500e-01,
        7.76512922e-01, 3.16331175e-01, 1.41617211e-01, 3.24407406e-01,
        4.35533756e-01, 4.77815026e-01, 6.69688280e-01, 3.09248385e-02,
        9.51546884e-01, 2.49080409e-01, 1.41120843e-01, 8.39127186e-01,
        1.76979264e-01, 8.39322331e-01, 6.11009782e-01, 2.33654385e-01,
        7.60607636e-01, 7.69775405e-01, 1.25721081e-01, 6.27840653e-01,
        1.65213144e-01, 8.07157978e-01, 3.99368236e-01, 1.05397876e-01,
        7.73271949e-01, 6.74650556e-01, 6.79238004e-01, 4.15607955e-01,
        6.49696187e-01, 7.83523395e-01, 1.07495202e-01, 5.04717187e-01,
        5.54000813e-02, 5.96567442e-01, 3.45015331e-01, 9.00019226e-01,
        1.73392644e-01, 8.83470898e-01, 5.27088030e-01, 6.05071670e-02,
        8.98272639e-01, 3.23999555e-01, 7.50878511e-01, 5.09734205e-02,
        8.95146865e-02, 1.30461855e-01, 9.53108552e-01, 1.48011676e-01,
        1.57109385e-01, 6.10293732e-01, 1.60645300e-01, 6.64309477e-01,
        2.43053568e-01, 7.88833831e-01, 7.14191917e-01, 5.78962078e-01,
        3.57383911e-01, 2.38015782e-01, 6.15180539e-01, 8.70324257e-01,
        6.14102641e-01, 7.97936694e-01, 9.05684726e-01, 7.81338055e-01,
        1.84010045e-01, 2.60494225e-01, 4.65027104e-01, 1.58909960e-01,
        2.58547428e-01, 9.54843409e-01, 3.59876758e-01, 7.22906705e-01,
        3.80026719e-01, 5.40184592e-01, 4.16939804e-01, 2.14174524e-01,
        8.43719707e-01, 3.81019608e-02, 5.09318616e-01, 9.21798022e-01,
        9.35306853e-01, 3.16315217e-01, 7.02461718e-02, 6.47594765e-02,
        1.99187687e-01, 6.72344719e-01, 8.37225236e-01, 6.02069364e-01,
        7.62141048e-01, 3.18363927e-01, 1.61981104e-01, 3.22532444e-01,
        3.97012742e-01, 3.64817304e-01, 4.99721573e-01, 4.40920031e-01,
        2.68980328e-01, 7.69127619e-01, 6.57246652e-01, 9.59673816e-01,
        9.86853535e-01, 5.10972998e-01, 1.27948071e-01, 2.72224141e-01,
        6.38170081e-01, 3.17813530e-01, 4.31021832e-01, 5.50335392e-01,
        6.03882606e-01, 8.84826730e-01, 8.97911334e-01, 6.53931170e-02,
        3.29554724e-01, 6.66865953e-01, 2.48475301e-01, 4.82288064e-01,
        8.99185665e-01, 2.27436525e-01, 6.52338650e-01, 4.97684985e-01,
        6.67185588e-01, 2.84318191e-01, 9.81860308e-01, 8.69049012e-01,
        2.86483238e-01, 9.96933080e-01, 6.24310056e-01, 8.87642271e-01,
        8.26318370e-01, 6.79575743e-01, 8.55166282e-01, 7.78940780e-01,
        3.80133232e-01, 6.71063047e-01, 4.62550981e-01, 8.90910012e-01,
        6.07408562e-01, 2.10659550e-01, 3.34645728e-01, 9.35457495e-01,
        7.35874514e-01, 8.14592550e-01, 5.21514908e-01, 1.77837342e-02,
        9.31635685e-01, 7.04691548e-01, 5.43060364e-02, 3.23986616e-01,
        6.03693214e-01, 7.68881276e-01, 3.52963992e-01, 6.53449399e-01,
        6.53785527e-01, 8.58482180e-01, 5.78692143e-01, 4.53317102e-01,
        9.81272973e-01, 5.91330420e-01, 5.28169142e-01, 3.60108889e-01,
        3.37400619e-01, 1.54852442e-01, 5.17268450e-01, 5.97408812e-01,
        6.97873046e-01, 7.38417960e-01, 4.92056648e-01, 1.50817293e-01,
        5.03456562e-02, 7.80294020e-01, 4.40014284e-01, 8.68533496e-01,
        8.53747218e-01, 6.77291584e-01, 9.35958113e-01, 7.34293149e-02,
        9.93642813e-01, 4.34077680e-01, 3.35441700e-01, 1.77939493e-01,
        5.59604993e-01, 6.29771060e-01, 2.54292785e-01, 6.97981405e-01,
        2.47358091e-01, 4.02189502e-01, 8.96997382e-01, 4.74823901e-01,
        7.93861544e-01, 5.16099273e-01, 2.24367653e-01, 3.39601972e-02};

    fabba = fABBA::ABBA(0.01, 0.01, "lexi", 1, ts.size(), true);
    symbols= fabba.fit_transform(ts);
    print_vector("symbols: ", symbols);
    r_fabba_series = fabba.inverse_transform(ts[0]);
    cout << std::endl << "fABBA model:";
    fabba.print_parameters();
    print_vector("inverse time series: ", r_fabba_series);

    return  0;
}
