from .widgets import (
    ActiveButton,
    ActiveCheckbutton,
    ActiveCombobox,
    ActiveEntry,
    ActiveLabel,
    ActiveOptionMenu,
    ActiveProgressbar,
    ActiveRadiobutton,
    ActiveScale,
    ActiveSpinbox,
    BaseKeypad,
    bbox_to_width_and_height,
    bind_mousewheel,
    BrowserLauncherTab,
    center_window,
    check_entry_ascii_digits,
    check_entry_ascii_hexdigits,
    check_entry_ascii_letters,
    check_entry_ascii_letters_digits,
    check_entry_ascii_lowercase,
    check_entry_ascii_lowercase_digits,
    check_entry_ascii_octdigits,
    check_entry_ascii_printable,
    check_entry_ascii_uppercase,
    check_entry_ascii_uppercase_digits,
    check_entry_contents,
    check_entry_float,
    check_entry_int,
    check_entry_type,
    check_in_bounds,
    ColumnFrame,
    CommandLauncherTab,
    complex_widget_search,
    ConsoleTab,
    ConsoleWidget,
    ConstrainedEntry,
    copy_to_user_clipboard,
    CopyBox,
    Counter,
    create_round_rectangle,
    CycleButton,
    default_pack,
    default_separator,
    default_vertical_pack,
    default_vertical_separator,
    DialerKeypad,
    DigitsEntry,
    EasySizegrip,
    enable_notebook_movement,
    ExampleTile,
    FloatCounter,
    FloatEntry,
    focus_next,
    FocusedToplevel,
    force_aspect,
    get_asset,
    get_bundled_themes_list,
    get_generated_font_image,
    get_generated_font_images,
    get_generated_font_images_lookup,
    get_local_appdata_folder,
    get_themes_folder,
    HamburgerFrame,
    HexdigitsEntry,
    IntEntry,
    KeypadButton,
    LabeledButton,
    LabeledButtonEntry,
    LabeledCheckbutton,
    LabeledCombobox,
    LabeledConstrainedEntry,
    LabeledCopyBox,
    LabeledCounter,
    LabeledCycleButton,
    LabeledCycleButton,
    LabeledDigitsEntry,
    LabeledEntry,
    LabeledFloatCounter,
    LabeledFloatEntry,
    LabeledHexdigitsEntry,
    LabeledIntEntry,
    LabeledLettersDigitsEntry,
    LabeledLettersEntry,
    LabeledLowercaseDigitsEntry,
    LabeledLowercaseEntry,
    LabeledMultiButton,
    LabeledMultiButtonEntry,
    LabeledMultiCheckbutton,
    LabeledMultiCombobox,
    LabeledMultiConstrainedEntry,
    LabeledMultiCopyBox,
    LabeledMultiCounter,
    LabeledMultiCycleButton,
    LabeledMultiDigitsEntry,
    LabeledMultiEntry,
    LabeledMultiFloatCounter,
    LabeledMultiFloatEntry,
    LabeledMultiHexdigitsEntry,
    LabeledMultiIntEntry,
    LabeledMultiLettersDigitsEntry,
    LabeledMultiLettersEntry,
    LabeledMultiLowercaseDigitsEntry,
    LabeledMultiLowercaseEntry,
    LabeledMultiOctdigitsEntry,
    LabeledMultiOptionMenu,
    LabeledMultiPasswordEntry,
    LabeledMultiPathEntry,
    LabeledMultiPrintableEntry,
    LabeledMultiProgressbar,
    LabeledMultiRadioTable,
    LabeledMultiScale,
    LabeledMultiSimpleRadioTable,
    LabeledMultiSpinbox,
    LabeledMultiUppercaseDigitsEntry,
    LabeledMultiUppercaseEntry,
    LabeledMultiWidgetMixin,
    LabeledOctdigitsEntry,
    LabeledOptionMenu,
    LabeledPasswordEntry,
    LabeledPathEntry,
    LabeledPrintableEntry,
    LabeledProgressbar,
    LabeledRadioTable,
    LabeledScale,
    LabeledSimpleRadioTable,
    LabeledSpinbox,
    LabeledUppercaseDigitsEntry,
    LabeledUppercaseEntry,
    LabeledValue,
    Labeler,
    LauncherTab,
    LettersDigitsEntry,
    LettersEntry,
    ListWindow,
    LowercaseDigitsEntry,
    LowercaseEntry,
    make_aspect_frames,
    make_temp_config_file,
    MultiWidgetMixin,
    NoticeWindow,
    OctdigitsEntry,
    open_link,
    OrderedListbox,
    PasswordEntry,
    PasswordWindow,
    PrintableEntry,
    PromptWindow,
    RadioTable,
    recursive_widget_search,
    ResizableCanvas,
    run_cl,
    ScrolledCanvas,
    ScrolledEntry,
    ScrolledListBox,
    ScrolledText,
    ScrolledTree,
    SimpleRadioTable,
    SuperWidgetMixin,
    Tab,
    Table,
    TableTab,
    TiledCanvas,
    ToolTip,
    TreeTable,
    TreeTableTab,
    UppercaseDigitsEntry,
    UppercaseEntry,
    YesNoCancelWindow,
    ListManipulator,
    TextWindow,
)

from .utils.color import (
    reduce_255,
    rgb_to_hex,
    rgba_to_hex,
    hex_to_rgb,
    hex_to_rgba,
    get_gradient,
    rgb_to_scalar,
    scalar_to_rgb,
    linear_gradient,
    get_rainbow,
    needs_white_text,
)

from .utils.HTML_Generator import HTML_Generator
from .utils.TXT_Generator import TXT_Generator
from .utils.MD_Generator import MD_Generator
from .utils.utils import (
    check_if_module_installed,
    check_string_contains,
    dummy_function,
    format_SI,
    get_friendly_modified_time,
    get_friendly_time,
    # get_installed_packages,
    get_unix_timestamp,
    get_unix_timestring,
    get_user_home_folder,
    modify_filename,
    open_folder_in_explorer,
    sort_dict_by_keys,
    timer_decorator,
)
from .utils.History import HistoryMixin
from .utils.scaling import enable_dpi_awareness, get_scaling
from .utils.ProfilesSystem import (
    ProfilesSystem,
    UserProfile,
    get_profiles_folder,
    get_profiles_list,
)
from .utils.zip_packager import (
    package_folder,
    get_package_file,
    get_package_manifest,
    get_package_manifest_json,
)
from .utils.tcl_commands import (
    tcl_bell,
    tcl_center_window,
    tcl_choose_font,
    tcl_download_file,
)

from .mega_widgets.chat import ConversationsTab
from .mega_widgets.notes import NotesTab
from .mega_widgets.profile_manager import ProfilesWindow
from .mega_widgets.timecard_maker import TimecardTab, TimecardMaker
from .mega_widgets.wattage_calculator import WattageTab, WattageCalculator
from .mega_widgets.shopping_list import ShoppingListTab, ShoppingList
from .mega_widgets.launcher import ConfigurableLauncher, LauncherTools
from .app import App
from .form import FormApp
from .version import version, __version__

if not check_if_module_installed("PIL"):
    PILLOW_AVAILABLE = False
    print("Pillow not detected, not importing pillow-only widgets")
else:
    PILLOW_AVAILABLE = True
    print("Pillow detected, importing pillow-only widgets")
    from .pillow_widgets.GifLoader import GifLoader, GifViewer
    from .pillow_widgets.ImageCore import (
        convert_image_to_blackandwhite,
        convert_image_to_grayscale,
        load_image_from_byte_array,
        load_tk_image_from_bytes_array,
        make_checkerboard,
    )
