# 🔥 Backcraft CLI

Client CLI pour Backcraft - Générateur de projets Python alimenté par l'IA.

## Installation

```bash
pip install backcraft-cli
```

Ou depuis les sources:
```bash
git clone https://github.com/julesc31/pyforge-2.0-clean.git
cd pyforge-2.0-clean/cli-client
pip install -e .
```

## Configuration

Lors de la première utilisation, configurez le CLI:

```bash
backcraft configure
```

Le CLI vous demandera:
- **Server URL**: L'adresse du serveur Backcraft (ex: https://api.backcraft.io)
- **Anthropic API Key**: Votre clé API personnelle (obtenue sur https://console.anthropic.com)

⚠️ **Important**: Vous utilisez VOTRE propre clé API Anthropic. Les coûts de génération sont à votre charge.

## Utilisation

### 💬 Mode conversationnel (recommandé)

Le mode conversationnel vous permet de discuter avec l'IA pour affiner votre projet:

```bash
backcraft chat MonProjet
```

L'IA vous demande d'abord votre idée, puis vous guide avec des questions adaptées.

**🌍 Langues supportées:**
- 🇫🇷 Français
- 🇬🇧 English
- 🇩🇪 Deutsch
- 🇪🇸 Español
- 🇮🇹 Italiano
- 🇵🇹 Português

**🎯 Niveaux techniques:**
- **👶 Débutant** - Questions en langage simple, sans jargon technique
  - Exemple: "Les utilisateurs devront-ils se connecter ?"
  - Exemple: "Allez-vous accepter des paiements ?"
- **🚀 Professionnel** - Questions techniques pour développeurs
  - Exemple: "JWT ou OAuth2 pour l'authentification ?"
  - Exemple: "Redis ou Memcached pour le cache ?"

L'IA adapte ses questions à votre langue et votre niveau technique !

**Exemple de conversation:**

```
🤖 Let's Chat

Project: BiblioAPI

🌍 Step 1/3: Choose your language

  [1] 🇫🇷 Français
  [2] 🇬🇧 English
  [3] 🇩🇪 Deutsch
  [4] 🇪🇸 Español
  [5] 🇮🇹 Italiano
  [6] 🇵🇹 Português

Select language: 1

🎯 Step 2/3: Choose your technical level

  [1] 👶 Beginner - I'm not technical, use simple language
  [2] 🚀 Professional - I know tech, you can use technical terms

Select level: 1

✓ Language: 🇫🇷 Français
✓ Level: 👶 Beginner

🎯 Step 3/3: Parlez-moi de votre projet

Que voulez-vous construire ?: API REST pour gérer une bibliothèque avec des livres et emprunts

🔍 Analyse de votre idée...

✓ Here's what I understood:
📌 Domain: library-management
🎯 Purpose: Manage books and loans with REST API
👥 Users: librarians, readers

💭 Now, let me ask you a few questions...

Question 1/5:
  Les utilisateurs devront-ils se connecter pour accéder à la bibliothèque ?
  💡 This helps determine: système d'authentification

Your answer: oui, les bibliothécaires et lecteurs ont des permissions différentes

Question 2/5:
  Devez-vous suivre la disponibilité des livres et les réservations ?
  💡 This helps determine: gestion de l'inventaire

Your answer: oui, avec des listes d'attente pour les livres populaires
...

✅ Perfect! I have all the information I need.

🎯 Final Understanding
Domain: library-management
Purpose: Complete library management system with auth, inventory, and reservations
Key Entities: Book, User, Loan, Reservation
Features: auth, rbac, inventory, reservations, notifications

Ready to generate? [yes/no]: yes

🚀 Starting generation...
```

### 🚀 Mode rapide

Pour une génération directe sans questions:

```bash
backcraft create MonProjet --idea "Je veux créer une API REST pour gérer une bibliothèque avec des livres et des emprunts"
```

Options:
- `--output` / `-o`: Répertoire de sortie (défaut: répertoire actuel)

### Vérifier le statut d'une génération

```bash
backcraft status <generation-id>
```

### Afficher la configuration actuelle

```bash
backcraft info
```

## Workflow complet

### Mode conversationnel (recommandé)

```bash
# 1. Configuration initiale
backcraft configure

# 2. Créer un projet avec conversation
backcraft chat BiblioAPI --output ./projects

# L'IA vous demande votre idée, puis vous pose des questions
# Répondez naturellement, sans termes techniques

# 3. Installer le projet généré
cd projects
python BiblioAPI-installer.py

# 4. Lancer le projet
cd BiblioAPI
docker-compose up
```

### Mode rapide

```bash
# 1. Configuration initiale
backcraft configure

# 2. Créer un projet directement
backcraft create BiblioAPI \
  --idea "API REST pour gérer une bibliothèque avec authentification JWT, gestion des emprunts et réservations" \
  --output ./projects

# 3. Installer et lancer
cd projects && python BiblioAPI-installer.py
cd BiblioAPI && docker-compose up
```

## Architecture

Le CLI est un **client léger** qui communique avec le serveur Backcraft:

1. Vous installez le CLI sur votre machine
2. Le CLI envoie vos requêtes au serveur Backcraft
3. Le serveur utilise VOTRE clé Anthropic pour générer le code
4. Le CLI télécharge le projet généré

```
┌─────────────────┐          ┌─────────────────┐          ┌─────────────────┐
│   Votre CLI     │─────────▶│  Serveur        │─────────▶│   Anthropic     │
│   (local)       │          │  Backcraft      │          │   Claude API    │
│                 │          │                 │          │                 │
│ + Votre clé API │◀─────────│  Orchestration  │◀─────────│  (avec votre    │
│                 │          │                 │          │   clé API)      │
└─────────────────┘          └─────────────────┘          └─────────────────┘
```

## Coûts

- ✅ Le CLI est **gratuit**
- ✅ Le serveur Backcraft est **gratuit**
- ⚠️ Vous payez uniquement les **appels à l'API Anthropic** via votre clé

Coûts indicatifs (tarifs Anthropic Claude):
- Petit projet (~5000 tokens): ~$0.02
- Projet moyen (~20000 tokens): ~$0.08
- Grand projet (~50000 tokens): ~$0.20

## Support

- Issues: https://github.com/julesc31/pyforge-2.0-clean/issues
- Documentation: https://docs.backcraft.io

## License

MIT
