"""
Type annotations for omics service literal definitions.

[Open documentation](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_omics/literals/)

Usage::

    ```python
    from mypy_boto3_omics.literals import AnnotationImportJobCreatedWaiterName

    data: AnnotationImportJobCreatedWaiterName = "annotation_import_job_created"
    ```
"""
import sys

if sys.version_info >= (3, 9):
    from typing import Literal
else:
    from typing_extensions import Literal

__all__ = (
    "AnnotationImportJobCreatedWaiterName",
    "AnnotationStoreCreatedWaiterName",
    "AnnotationStoreDeletedWaiterName",
    "AnnotationTypeType",
    "EncryptionTypeType",
    "FileTypeType",
    "FormatToHeaderKeyType",
    "JobStatusType",
    "ListAnnotationImportJobsPaginatorName",
    "ListAnnotationStoresPaginatorName",
    "ListReadSetActivationJobsPaginatorName",
    "ListReadSetExportJobsPaginatorName",
    "ListReadSetImportJobsPaginatorName",
    "ListReadSetsPaginatorName",
    "ListReferenceImportJobsPaginatorName",
    "ListReferenceStoresPaginatorName",
    "ListReferencesPaginatorName",
    "ListRunGroupsPaginatorName",
    "ListRunTasksPaginatorName",
    "ListRunsPaginatorName",
    "ListSequenceStoresPaginatorName",
    "ListVariantImportJobsPaginatorName",
    "ListVariantStoresPaginatorName",
    "ListWorkflowsPaginatorName",
    "ReadSetActivationJobCompletedWaiterName",
    "ReadSetActivationJobItemStatusType",
    "ReadSetActivationJobStatusType",
    "ReadSetExportJobCompletedWaiterName",
    "ReadSetExportJobItemStatusType",
    "ReadSetExportJobStatusType",
    "ReadSetFileType",
    "ReadSetImportJobCompletedWaiterName",
    "ReadSetImportJobItemStatusType",
    "ReadSetImportJobStatusType",
    "ReadSetStatusType",
    "ReferenceFileType",
    "ReferenceImportJobCompletedWaiterName",
    "ReferenceImportJobItemStatusType",
    "ReferenceImportJobStatusType",
    "ReferenceStatusType",
    "RunCompletedWaiterName",
    "RunExportType",
    "RunLogLevelType",
    "RunRunningWaiterName",
    "RunStatusType",
    "SchemaValueTypeType",
    "StoreFormatType",
    "StoreStatusType",
    "TaskCompletedWaiterName",
    "TaskRunningWaiterName",
    "TaskStatusType",
    "VariantImportJobCreatedWaiterName",
    "VariantStoreCreatedWaiterName",
    "VariantStoreDeletedWaiterName",
    "WorkflowActiveWaiterName",
    "WorkflowEngineType",
    "WorkflowExportType",
    "WorkflowStatusType",
    "WorkflowTypeType",
    "OmicsServiceName",
    "ServiceName",
    "ResourceServiceName",
    "PaginatorName",
    "WaiterName",
)

AnnotationImportJobCreatedWaiterName = Literal["annotation_import_job_created"]
AnnotationStoreCreatedWaiterName = Literal["annotation_store_created"]
AnnotationStoreDeletedWaiterName = Literal["annotation_store_deleted"]
AnnotationTypeType = Literal[
    "CHR_POS",
    "CHR_POS_REF_ALT",
    "CHR_START_END_ONE_BASE",
    "CHR_START_END_REF_ALT_ONE_BASE",
    "CHR_START_END_REF_ALT_ZERO_BASE",
    "CHR_START_END_ZERO_BASE",
    "GENERIC",
]
EncryptionTypeType = Literal["KMS"]
FileTypeType = Literal["BAM", "CRAM", "FASTQ"]
FormatToHeaderKeyType = Literal["ALT", "CHR", "END", "POS", "REF", "START"]
JobStatusType = Literal[
    "CANCELLED", "COMPLETED", "COMPLETED_WITH_FAILURES", "FAILED", "IN_PROGRESS", "SUBMITTED"
]
ListAnnotationImportJobsPaginatorName = Literal["list_annotation_import_jobs"]
ListAnnotationStoresPaginatorName = Literal["list_annotation_stores"]
ListReadSetActivationJobsPaginatorName = Literal["list_read_set_activation_jobs"]
ListReadSetExportJobsPaginatorName = Literal["list_read_set_export_jobs"]
ListReadSetImportJobsPaginatorName = Literal["list_read_set_import_jobs"]
ListReadSetsPaginatorName = Literal["list_read_sets"]
ListReferenceImportJobsPaginatorName = Literal["list_reference_import_jobs"]
ListReferenceStoresPaginatorName = Literal["list_reference_stores"]
ListReferencesPaginatorName = Literal["list_references"]
ListRunGroupsPaginatorName = Literal["list_run_groups"]
ListRunTasksPaginatorName = Literal["list_run_tasks"]
ListRunsPaginatorName = Literal["list_runs"]
ListSequenceStoresPaginatorName = Literal["list_sequence_stores"]
ListVariantImportJobsPaginatorName = Literal["list_variant_import_jobs"]
ListVariantStoresPaginatorName = Literal["list_variant_stores"]
ListWorkflowsPaginatorName = Literal["list_workflows"]
ReadSetActivationJobCompletedWaiterName = Literal["read_set_activation_job_completed"]
ReadSetActivationJobItemStatusType = Literal["FAILED", "FINISHED", "IN_PROGRESS", "NOT_STARTED"]
ReadSetActivationJobStatusType = Literal[
    "CANCELLED",
    "CANCELLING",
    "COMPLETED",
    "COMPLETED_WITH_FAILURES",
    "FAILED",
    "IN_PROGRESS",
    "SUBMITTED",
]
ReadSetExportJobCompletedWaiterName = Literal["read_set_export_job_completed"]
ReadSetExportJobItemStatusType = Literal["FAILED", "FINISHED", "IN_PROGRESS", "NOT_STARTED"]
ReadSetExportJobStatusType = Literal[
    "CANCELLED",
    "CANCELLING",
    "COMPLETED",
    "COMPLETED_WITH_FAILURES",
    "FAILED",
    "IN_PROGRESS",
    "SUBMITTED",
]
ReadSetFileType = Literal["INDEX", "SOURCE1", "SOURCE2"]
ReadSetImportJobCompletedWaiterName = Literal["read_set_import_job_completed"]
ReadSetImportJobItemStatusType = Literal["FAILED", "FINISHED", "IN_PROGRESS", "NOT_STARTED"]
ReadSetImportJobStatusType = Literal[
    "CANCELLED",
    "CANCELLING",
    "COMPLETED",
    "COMPLETED_WITH_FAILURES",
    "FAILED",
    "IN_PROGRESS",
    "SUBMITTED",
]
ReadSetStatusType = Literal["ACTIVATING", "ACTIVE", "ARCHIVED", "DELETED", "DELETING"]
ReferenceFileType = Literal["INDEX", "SOURCE"]
ReferenceImportJobCompletedWaiterName = Literal["reference_import_job_completed"]
ReferenceImportJobItemStatusType = Literal["FAILED", "FINISHED", "IN_PROGRESS", "NOT_STARTED"]
ReferenceImportJobStatusType = Literal[
    "CANCELLED",
    "CANCELLING",
    "COMPLETED",
    "COMPLETED_WITH_FAILURES",
    "FAILED",
    "IN_PROGRESS",
    "SUBMITTED",
]
ReferenceStatusType = Literal["ACTIVE", "DELETED", "DELETING"]
RunCompletedWaiterName = Literal["run_completed"]
RunExportType = Literal["DEFINITION"]
RunLogLevelType = Literal["ALL", "ERROR", "FATAL", "OFF"]
RunRunningWaiterName = Literal["run_running"]
RunStatusType = Literal[
    "CANCELLED", "COMPLETED", "DELETED", "FAILED", "PENDING", "RUNNING", "STARTING", "STOPPING"
]
SchemaValueTypeType = Literal["BOOLEAN", "DOUBLE", "FLOAT", "INT", "LONG", "STRING"]
StoreFormatType = Literal["GFF", "TSV", "VCF"]
StoreStatusType = Literal["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
TaskCompletedWaiterName = Literal["task_completed"]
TaskRunningWaiterName = Literal["task_running"]
TaskStatusType = Literal[
    "CANCELLED", "COMPLETED", "FAILED", "PENDING", "RUNNING", "STARTING", "STOPPING"
]
VariantImportJobCreatedWaiterName = Literal["variant_import_job_created"]
VariantStoreCreatedWaiterName = Literal["variant_store_created"]
VariantStoreDeletedWaiterName = Literal["variant_store_deleted"]
WorkflowActiveWaiterName = Literal["workflow_active"]
WorkflowEngineType = Literal["NEXTFLOW", "WDL"]
WorkflowExportType = Literal["DEFINITION"]
WorkflowStatusType = Literal["ACTIVE", "CREATING", "DELETED", "FAILED", "INACTIVE", "UPDATING"]
WorkflowTypeType = Literal["PRIVATE", "SERVICE"]
OmicsServiceName = Literal["omics"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "alexaforbusiness",
    "amp",
    "amplify",
    "amplifybackend",
    "amplifyuibuilder",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appconfigdata",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "arc-zonal-shift",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "backup",
    "backup-gateway",
    "backupstorage",
    "batch",
    "billingconductor",
    "braket",
    "budgets",
    "ce",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-media-pipelines",
    "chime-sdk-meetings",
    "chime-sdk-messaging",
    "chime-sdk-voice",
    "cleanrooms",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudtrail-data",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecatalyst",
    "codecommit",
    "codedeploy",
    "codeguru-reviewer",
    "codeguruprofiler",
    "codepipeline",
    "codestar",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectcampaigns",
    "connectcases",
    "connectparticipant",
    "controltower",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "dax",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "docdb-elastic",
    "drs",
    "ds",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "elastic-inference",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "emr-serverless",
    "es",
    "events",
    "evidently",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "fsx",
    "gamelift",
    "gamesparks",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "honeycode",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "inspector2",
    "internetmonitor",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot-roborunner",
    "iot1click-devices",
    "iot1click-projects",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotfleetwise",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iottwinmaker",
    "iotwireless",
    "ivs",
    "ivschat",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kendra-ranking",
    "keyspaces",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesis-video-webrtc-storage",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "license-manager-linux-subscriptions",
    "license-manager-user-subscriptions",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "m2",
    "machinelearning",
    "macie",
    "macie2",
    "managedblockchain",
    "marketplace-catalog",
    "marketplace-entitlement",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migration-hub-refactor-spaces",
    "migrationhub-config",
    "migrationhuborchestrator",
    "migrationhubstrategy",
    "mobile",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "network-firewall",
    "networkmanager",
    "nimble",
    "oam",
    "omics",
    "opensearch",
    "opensearchserverless",
    "opsworks",
    "opsworkscm",
    "organizations",
    "outposts",
    "panorama",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "pinpoint-sms-voice-v2",
    "pipes",
    "polly",
    "pricing",
    "privatenetworks",
    "proton",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rbin",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "redshift-serverless",
    "rekognition",
    "resiliencehub",
    "resource-explorer-2",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "rolesanywhere",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53resolver",
    "rum",
    "s3",
    "s3control",
    "s3outposts",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-geospatial",
    "sagemaker-metrics",
    "sagemaker-runtime",
    "savingsplans",
    "scheduler",
    "schemas",
    "sdb",
    "secretsmanager",
    "securityhub",
    "securitylake",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "simspaceweaver",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "ssm-sap",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "support",
    "support-app",
    "swf",
    "synthetics",
    "textract",
    "timestream-query",
    "timestream-write",
    "tnb",
    "transcribe",
    "transfer",
    "translate",
    "voice-id",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "worklink",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "workspaces-web",
    "xray",
]
ResourceServiceName = Literal[
    "cloudformation",
    "cloudwatch",
    "dynamodb",
    "ec2",
    "glacier",
    "iam",
    "opsworks",
    "s3",
    "sns",
    "sqs",
]
PaginatorName = Literal[
    "list_annotation_import_jobs",
    "list_annotation_stores",
    "list_read_set_activation_jobs",
    "list_read_set_export_jobs",
    "list_read_set_import_jobs",
    "list_read_sets",
    "list_reference_import_jobs",
    "list_reference_stores",
    "list_references",
    "list_run_groups",
    "list_run_tasks",
    "list_runs",
    "list_sequence_stores",
    "list_variant_import_jobs",
    "list_variant_stores",
    "list_workflows",
]
WaiterName = Literal[
    "annotation_import_job_created",
    "annotation_store_created",
    "annotation_store_deleted",
    "read_set_activation_job_completed",
    "read_set_export_job_completed",
    "read_set_import_job_completed",
    "reference_import_job_completed",
    "run_completed",
    "run_running",
    "task_completed",
    "task_running",
    "variant_import_job_created",
    "variant_store_created",
    "variant_store_deleted",
    "workflow_active",
]
