#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['facet',
 'facet.crossfit',
 'facet.data',
 'facet.data.partition',
 'facet.inspection',
 'facet.selection',
 'facet.simulation',
 'facet.simulation.viz',
 'facet.validation']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['gamma-pytools  ~=1.1.2',
 'matplotlib     >=3.0,<3.4',
 'numpy          >=1.16,<1.21',
 'packaging      >=20',
 'pandas         >=0.24,<1.3',
 'scipy          >=1.2,<1.6',
 'shap           >=0.34,<0.40',
 'sklearndf      ~=1.1.0',
 'boruta         >=0.3',
 'lightgbm       >=3.0',
 'scikit-learn   >=0.21,<0.24',
 'joblib         >=0.14,<1.1',
 'typing_inspect >=0.4,<0.7',
 'ipython        >=7']

extras_require = \
{'docs': ['sphinx == 3.4.*',
          'sphinx-autodoc-typehints == 1.11.*',
          'pydata-sphinx-theme == 0.4.*',
          'nbsphinx ~= 0.8.5',
          'jupyter >= 1.0',
          'docutils',
          'xlrd == 1.2.*',
          'm2r == 0.2.*'],
 'testing': ['pytest >= 5.2.*',
             'pytest-cov == 2.8.*',
             'flake8 == 3.8.*',
             'flake8-comprehensions == 3.2.*',
             'isort == 5.5.*']}

setup(name='gamma-facet',
      version='1.2.0rc0',
      description='Human-explainable AI.',
      author='Boston Consulting Group (BCG)',
      author_email=None,
      url='https://github.com/BCG-Gamma/facet',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6,<3.9',
     )
