"""Broadworks OCI-P Interface Request Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-19T17:35:53.953786
# fmt: off
from typing import List

from classforge import Field

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIRequest


class AuthenticationRequest(OCIRequest):
    """
    ``AuthenticationRequest()`` is 1st stage of the 2 stage OCI login process.


    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class AuthenticationVerifyRequest(OCIRequest):
    """
    ``AuthenticationVerifyRequest()`` is used to authenticate a user using the user Id and
    password.

    The response is a ``AuthenticationVerifyResponse()`` or an ``ErrorResponse()``

    Replaced By: ``AuthenticationVerifyRequest14sp8()``

    Attributes:
        user_id: userId
        password: password
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("password", "password", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)


class AuthenticationVerifyRequest14sp8(OCIRequest):
    """
    ``AuthenticationVerifyRequest14sp8()`` is used to authenticate a user either by
    userId/password, userId/sip username/sip password, dn/passcode or a token previously
    authorized with the ``ExternalAuthenticationAuthorizeTokenRequest()``.

    The phone number may be any DN associated with a user.

    The response is a ``AuthenticationVerifyResponse14sp8()`` or an ``ErrorResponse()``

    Attributes:
        user_id: userId
        password: password
        phone_number: phoneNumber
        passcode: passcode
        login_token: loginToken
        sip_authentication_user_name: sipAuthenticationUserName
        sip_authentication_password: sipAuthenticationPassword
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("password", "password", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("passcode", "passcode", str, is_required=True),
        E("login_token", "loginToken", str, is_required=True),
        E("sip_authentication_user_name", "sipAuthenticationUserName", str, is_required=True),
        E("sip_authentication_password", "sipAuthenticationPassword", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    passcode: str = Field(type=str, required=True, mutable=False)
    login_token: str = Field(type=str, required=True, mutable=False)
    sip_authentication_user_name: str = Field(type=str, required=True, mutable=False)
    sip_authentication_password: str = Field(type=str, required=True, mutable=False)


class AvailabilityTestRequest(OCIRequest):
    """
    ``AvailabilityTestRequest()`` is for high-availability support.

    Response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class DeviceManagementFileAuthLocationGetRequest(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a ``DeviceManagementFileAuthLocationGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        device_access_protocol: deviceAccessProtocol
        device_access_method: deviceAccessMethod
        device_access_uri: deviceAccessURI
        access_device_user_name: accessDeviceUserName
        access_device_user_password: accessDeviceUserPassword
        signed_password: signedPassword
        mac_address: macAddress
        realm_name: realmName
        digest_ha1_complement: digestHa1Complement
        digest_response: digestResponse
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    device_access_method: str = Field(type=str, required=True, mutable=False)
    device_access_uri: str = Field(type=str, required=True, mutable=False)
    access_device_user_name: str = Field(type=str, required=False, mutable=False)
    access_device_user_password: str = Field(type=str, required=False, mutable=False)
    signed_password: str = Field(type=str, required=False, mutable=False)
    mac_address: str = Field(type=str, required=False, mutable=False)
    realm_name: str = Field(type=str, required=False, mutable=False)
    digest_ha1_complement: str = Field(type=str, required=False, mutable=False)
    digest_response: str = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetRequest17(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a ``DeviceManagementFileAuthLocationGetResponse17()`` or an
    ``ErrorResponse()``. Replaced by: ``DeviceManagementFileAuthLocationGetRequest18()``

    Attributes:
        device_access_protocol: deviceAccessProtocol
        device_access_method: deviceAccessMethod
        device_access_uri: deviceAccessURI
        access_device_user_name: accessDeviceUserName
        access_device_user_password: accessDeviceUserPassword
        signed_password: signedPassword
        mac_address: macAddress
        realm_name: realmName
        digest_ha1_complement: digestHa1Complement
        digest_response: digestResponse
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    device_access_method: str = Field(type=str, required=True, mutable=False)
    device_access_uri: str = Field(type=str, required=True, mutable=False)
    access_device_user_name: str = Field(type=str, required=False, mutable=False)
    access_device_user_password: str = Field(type=str, required=False, mutable=False)
    signed_password: str = Field(type=str, required=False, mutable=False)
    mac_address: str = Field(type=str, required=False, mutable=False)
    realm_name: str = Field(type=str, required=False, mutable=False)
    digest_ha1_complement: str = Field(type=str, required=False, mutable=False)
    digest_response: str = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetRequest18(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either a ``DeviceManagementFileAuthLocationGetResponse18()`` or an
    ``ErrorResponse()``. Replaced by: ``DeviceManagementFileAuthLocationGetRequest21()``.

    Attributes:
        device_access_protocol: deviceAccessProtocol
        device_access_method: deviceAccessMethod
        device_access_uri: deviceAccessURI
        access_device_user_name: accessDeviceUserName
        access_device_user_password: accessDeviceUserPassword
        signed_password: signedPassword
        mac_address: macAddress
        realm_name: realmName
        digest_ha1_complement: digestHa1Complement
        digest_response: digestResponse
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    device_access_method: str = Field(type=str, required=True, mutable=False)
    device_access_uri: str = Field(type=str, required=True, mutable=False)
    access_device_user_name: str = Field(type=str, required=False, mutable=False)
    access_device_user_password: str = Field(type=str, required=False, mutable=False)
    signed_password: str = Field(type=str, required=False, mutable=False)
    mac_address: str = Field(type=str, required=False, mutable=False)
    realm_name: str = Field(type=str, required=False, mutable=False)
    digest_ha1_complement: str = Field(type=str, required=False, mutable=False)
    digest_response: str = Field(type=str, required=False, mutable=False)


class DeviceManagementFileAuthLocationGetRequest21(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested access
    device file.

    Also get the file name and path on the File Repository.

    The response is either ``DeviceManagementFileAuthLocationGetResponse21()`` or
    ``ErrorResponse()``. The following elements are only used in AS data mode and will
    fail in HSS data mode: deviceToken

    Attributes:
        device_access_protocol: deviceAccessProtocol
        device_access_method: deviceAccessMethod
        device_access_uri: deviceAccessURI
        access_device_user_name: accessDeviceUserName
        access_device_user_password: accessDeviceUserPassword
        device_token: deviceToken
        signed_password: signedPassword
        mac_address: macAddress
        realm_name: realmName
        digest_ha1_complement: digestHa1Complement
        digest_response: digestResponse
    """

    _ELEMENTS = (
        E("device_access_protocol", "deviceAccessProtocol", str, is_required=True),
        E("device_access_method", "deviceAccessMethod", str, is_required=True),
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("access_device_user_name", "accessDeviceUserName", str),
        E("access_device_user_password", "accessDeviceUserPassword", str),
        E("device_token", "deviceToken", str),
        E("signed_password", "signedPassword", str),
        E("mac_address", "macAddress", str),
        E("realm_name", "realmName", str),
        E("digest_ha1_complement", "digestHa1Complement", str),
        E("digest_response", "digestResponse", str),
    )

    device_access_protocol: str = Field(type=str, required=True, mutable=False)
    device_access_method: str = Field(type=str, required=True, mutable=False)
    device_access_uri: str = Field(type=str, required=True, mutable=False)
    access_device_user_name: str = Field(type=str, required=False, mutable=False)
    access_device_user_password: str = Field(type=str, required=False, mutable=False)
    device_token: str = Field(type=str, required=False, mutable=False)
    signed_password: str = Field(type=str, required=False, mutable=False)
    mac_address: str = Field(type=str, required=False, mutable=False)
    realm_name: str = Field(type=str, required=False, mutable=False)
    digest_ha1_complement: str = Field(type=str, required=False, mutable=False)
    digest_response: str = Field(type=str, required=False, mutable=False)


class DeviceManagementPutFileRequest(OCIRequest):
    """
    Informs BroadWorks that a file was uploaded to the repository.

    The response is always a ``SuccessResponse()``.

    Attributes:
        device_access_uri: deviceAccessURI
        ip_address: ipAddress
    """

    _ELEMENTS = (
        E("device_access_uri", "deviceAccessURI", str, is_required=True),
        E("ip_address", "ipAddress", str, is_required=True),
    )

    device_access_uri: str = Field(type=str, required=True, mutable=False)
    ip_address: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerActivationRequest(OCIRequest):
    """
    Activates or Deactivates the BroadWorks Mobile Manager.

    The deactivationReason is required when isActive is set to false.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        is_active: isActive
        deactivation_reason: deactivationReason
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    deactivation_reason: str = Field(type=str, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerAddHomeZoneRequest(OCIRequest):
    """
    Add a home zone to the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        home_zone_domain_name: homeZoneDomainName
        mobile_country_code: mobileCountryCode
        mobile_network_code: mobileNetworkCode
        location_area_code: locationAreaCode
        cell_identity: cellIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    home_zone_domain_name: str = Field(type=str, required=True, mutable=False)
    mobile_country_code: str = Field(type=str, required=True, mutable=False)
    mobile_network_code: str = Field(type=str, required=True, mutable=False)
    location_area_code: str = Field(type=str, required=True, mutable=False)
    cell_identity: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerAddRequest(OCIRequest):
    """
    Add the BroadWorks Mobile Manager.

    Only one BroadWorks Mobile Manager can be added per enterprise.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        information_file: informationFile
        certificate_file: certificateFile
        is_active: isActive
        local_to_carrier: localToCarrier
        max_tx_per_second_enabled: maxTxPerSecondEnabled
        max_tx_per_second: maxTxPerSecond
        tldn_enabled: tldnEnabled
        generic_number_enabled: genericNumberEnabled
        mobile_state_check_enabled: mobileStateCheckEnabled
        location_based_services_enabled: locationBasedServicesEnabled
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("information_file", "informationFile", str, is_required=True),
        E("certificate_file", "certificateFile", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    information_file: str = Field(type=str, required=True, mutable=False)
    certificate_file: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    local_to_carrier: bool = Field(type=bool, required=True, mutable=False)
    max_tx_per_second_enabled: bool = Field(type=bool, required=True, mutable=False)
    max_tx_per_second: int = Field(type=int, required=False, mutable=False)
    tldn_enabled: bool = Field(type=bool, required=True, mutable=False)
    generic_number_enabled: bool = Field(type=bool, required=True, mutable=False)
    mobile_state_check_enabled: bool = Field(type=bool, required=True, mutable=False)
    location_based_services_enabled: bool = Field(type=bool, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerDeleteHomeZoneListRequest(OCIRequest):
    """
    Delete a list of home zones from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        home_zone_id: homeZoneId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerDeleteHomeZoneRequest(OCIRequest):
    """
    Delete a home zone from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        home_zone_id: homeZoneId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerDeleteRequest(OCIRequest):
    """
    Delete the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetDomainListRequest(OCIRequest):
    """
    Get the list of domains of the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetDomainListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest(OCIRequest):
    """
    Get the list of home zones of the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetHomeZoneListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetHomeZoneRequest(OCIRequest):
    """
    Get a home zone from the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetHomeZoneResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        home_zone_id: homeZoneId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager.

    The response is either ``EnterpriseBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobileManagerModifyHomeZoneRequest(OCIRequest):
    """
    Modify an existing home zone in the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        home_zone_id: homeZoneId
        home_zone_domain_name: homeZoneDomainName
        mobile_country_code: mobileCountryCode
        mobile_network_code: mobileNetworkCode
        location_area_code: locationAreaCode
        cell_identity: cellIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str),
        E("mobile_country_code", "mobileCountryCode", str),
        E("mobile_network_code", "mobileNetworkCode", str),
        E("location_area_code", "locationAreaCode", str),
        E("cell_identity", "cellIdentity", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)
    home_zone_domain_name: str = Field(type=str, required=False, mutable=False)
    mobile_country_code: str = Field(type=str, required=False, mutable=False)
    mobile_network_code: str = Field(type=str, required=False, mutable=False)
    location_area_code: str = Field(type=str, required=False, mutable=False)
    cell_identity: str = Field(type=str, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        information_file: informationFile
        certificate_file: certificateFile
        local_to_carrier: localToCarrier
        max_tx_per_second_enabled: maxTxPerSecondEnabled
        max_tx_per_second: maxTxPerSecond
        tldn_enabled: tldnEnabled
        generic_number_enabled: genericNumberEnabled
        mobile_state_check_enabled: mobileStateCheckEnabled
        location_based_services_enabled: locationBasedServicesEnabled
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("information_file", "informationFile", str),
        E("certificate_file", "certificateFile", str),
        E("local_to_carrier", "localToCarrier", bool),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool),
        E("generic_number_enabled", "genericNumberEnabled", bool),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool),
        E("location_based_services_enabled", "locationBasedServicesEnabled", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    information_file: str = Field(type=str, required=False, mutable=False)
    certificate_file: str = Field(type=str, required=False, mutable=False)
    local_to_carrier: bool = Field(type=bool, required=False, mutable=False)
    max_tx_per_second_enabled: bool = Field(type=bool, required=False, mutable=False)
    max_tx_per_second: int = Field(type=int, required=False, mutable=False)
    tldn_enabled: bool = Field(type=bool, required=False, mutable=False)
    generic_number_enabled: bool = Field(type=bool, required=False, mutable=False)
    mobile_state_check_enabled: bool = Field(type=bool, required=False, mutable=False)
    location_based_services_enabled: bool = Field(type=bool, required=False, mutable=False)


class EnterpriseBroadWorksMobileManagerSendCarrierFilesRequest(OCIRequest):
    """
    Sends an email with the carrier information and certificate files.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        email_to: emailTo
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("email_to", "emailTo", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    email_to: str = Field(type=str, required=True, mutable=False)


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    The response is either
    ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.

    When an agent is assigned (added) to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        profile_name: profileName
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)
    agent_user_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in an Enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        profile_name: profileName
        profile_description: profileDescription
        threshold_current_call_state_idle_time_yellow:
            thresholdCurrentCallStateIdleTimeYellow
        threshold_current_call_state_idle_time_red: thresholdCurrentCallStateIdleTimeRed
        threshold_current_call_state_on_call_time_yellow:
            thresholdCurrentCallStateOnCallTimeYellow
        threshold_current_call_state_on_call_time_red:
            thresholdCurrentCallStateOnCallTimeRed
        threshold_current_agent_state_unavailable_time_yellow:
            thresholdCurrentAgentStateUnavailableTimeYellow
        threshold_current_agent_state_unavailable_time_red:
            thresholdCurrentAgentStateUnavailableTimeRed
        threshold_average_busy_in_time_yellow: thresholdAverageBusyInTimeYellow
        threshold_average_busy_in_time_red: thresholdAverageBusyInTimeRed
        threshold_average_busy_out_time_yellow: thresholdAverageBusyOutTimeYellow
        threshold_average_busy_out_time_red: thresholdAverageBusyOutTimeRed
        threshold_average_wrap_up_time_yellow: thresholdAverageWrapUpTimeYellow
        threshold_average_wrap_up_time_red: thresholdAverageWrapUpTimeRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_user_id", "agentUserId", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)
    profile_description: str = Field(type=str, required=False, mutable=False)
    threshold_current_call_state_idle_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_idle_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_busy_out_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_out_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_wrap_up_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_wrap_up_time_red: int = Field(type=int, required=False, mutable=False)
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)
    agent_user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.

    Agents cannot be unassigned (deleted) directly from the default profile, they need to
    be assigned (added) to a different profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        profile_name: profileName
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)
    agent_user_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in an Enterprise.

    The default profile cannot be deleted.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        profile_name: profileName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Enterprise.

    The response is either ``EnterpriseCallCenterAgentThresholdProfileGetListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in an Enterprise.

    The response is either a ``EnterpriseCallCenterAgentThresholdProfileGetResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        profile_name: profileName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        is_active: isActive
        code: code
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.

    The response is either ``EnterpriseCallCenterAgentUnavailableCodeGetListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.

    The response is either ``EnterpriseCallCenterAgentUnavailableCodeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an
    ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse()`` or an
    ``ErrorResponse()``. Replaced by
    ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an
    ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.

    The response is either ``EnterpriseCallCenterCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either ``EnterpriseCallCenterCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.

    The response is either
    ``EnterpriseCallCenterCallDispositionCodeGetUsageListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the enterprise.

    The response is either ``EnterpriseCallCenterCurrentAndPastDNISGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    service_user_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the enterprise branding information.

    The response is either ``EnterpriseCallCenterEnhancedReportingBrandingGetResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for an enterprise.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.

    The response is either an ``EnterpriseCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``. Replaced by
    ``EnterpriseCallCenterEnhancedReportingGetRequest19()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.

    The response is either an ``EnterpriseCallCenterEnhancedReportingGetResponse19()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``EnterpriseCallCenterEnhancedReportingModifyRequest19()``

    Attributes:
        service_provider_id: serviceProviderId
        reporting_server: reportingServer
        web_statistic_source: webStatisticSource
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
        E("web_statistic_source", "webStatisticSource", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    reporting_server: str = Field(type=str, required=False, mutable=False)
    web_statistic_source: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        reporting_server: reportingServer
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    reporting_server: str = Field(type=str, required=False, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center report template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get enterprise level call center report template list.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center report template.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center reporting scheduled report.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in an enterprise that
    uses a given enterprise level report template.

    The response is either a
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center reporting scheduled report.

    The response is either an
    ``EnterpriseCallCenterEnhancedReportingScheduledReportGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an ``EnterpriseCallCenterGetResponse()`` or an
    ``ErrorResponse()``. Replaced by ``EnterpriseCallCenterGetRequest17sp4()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.

    The response is either an ``EnterpriseCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the enterprise call center routing policy.

    The response is either an ``EnterpriseCallCenterGetRoutingPolicyResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseCallCenterModifyRequest(OCIRequest):
    """
    Modify the enterprise level data associated with Call Center The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.


    Attributes:
        service_provider_id: serviceProviderId
        use_system_default_guard_timer: useSystemDefaultGuardTimer
        enable_guard_timer: enableGuardTimer
        guard_timer_seconds: guardTimerSeconds
        use_system_default_unavailable_settings: useSystemDefaultUnavailableSettings
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool),
        E("enable_guard_timer", "enableGuardTimer", bool),
        E("guard_timer_seconds", "guardTimerSeconds", int),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_system_default_guard_timer: bool = Field(type=bool, required=False, mutable=False)
    enable_guard_timer: bool = Field(type=bool, required=False, mutable=False)
    guard_timer_seconds: int = Field(type=int, required=False, mutable=False)
    use_system_default_unavailable_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=False, mutable=False,
    )


class EnterpriseCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from an enterprise's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        entry_name: entryName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    entry_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in an enterprise's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        entry_name: entryName
        new_entry_name: newEntryName
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
        E("new_entry_name", "newEntryName", str),
        E("phone_number", "phoneNumber", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    entry_name: str = Field(type=str, required=True, mutable=False)
    new_entry_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class EnterpriseDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        enterprise_id: enterpriseId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("enterprise_id", "enterpriseId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    enterprise_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of enterprise level departments in an enterprise that could be the parent
    of the specified department.

    The department itself and all its decendents are not eligible to be the parent
    department.

    The response is either ``EnterpriseDepartmentGetAvailableParentListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        enterprise_id: enterpriseId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("enterprise_id", "enterpriseId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    enterprise_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in an enterprise.

    You may request only the list of departments defined at the enterprise-level, or you
    may request the list of all departments in the enterprise including all the
    departments defined within the groups inside the enterprise.

    The response is either ``EnterpriseDepartmentGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        enterprise_id: enterpriseId
        include_group_departments: includeGroupDepartments
    """

    _ELEMENTS = (
        E("enterprise_id", "enterpriseId", str, is_required=True),
        E("include_group_departments", "includeGroupDepartments", bool, is_required=True),
    )

    enterprise_id: str = Field(type=str, required=True, mutable=False)
    include_group_departments: bool = Field(type=bool, required=True, mutable=False)


class EnterpriseEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``EnterpriseEnterpriseTrunkAddRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)


class EnterpriseEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
        enable_capacity_management: enableCapacityManagement
        max_active_calls: maxActiveCalls
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)
    enable_capacity_management: bool = Field(type=bool, required=True, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)


class EnterpriseEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.

    If the user is already assigned to another enterprise trunk, it will be unassigned
    from the old enterprise trunk and assigned to the new enterprise trunk specified in
    this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in an enterprise.

    The response is either a ``EnterpriseEnterpriseTrunkGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``EnterpriseEnterpriseTrunkGetResponse()`` or an ``ErrorResponse()``.

    Replaced by: ``EnterpriseEnterpriseTrunkGetRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``EnterpriseEnterpriseTrunkGetResponse21()`` or an ``ErrorResponse()``.


    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)


class EnterpriseEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in an enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enterprise_trunk_name: enterpriseTrunkName
        new_enterprise_trunk_name: newEnterpriseTrunkName
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
        enable_capacity_management: enableCapacityManagement
        max_active_calls: maxActiveCalls
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("new_enterprise_trunk_name", "newEnterpriseTrunkName", str),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int),
        E("route_exhaustion_action", "routeExhaustionAction", str),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    new_enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    maximum_reroute_attempts: int = Field(type=int, required=False, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=False, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)
    enable_capacity_management: bool = Field(type=bool, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)


class EnterprisePreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the Enterprise pre-alerting service settings.

    The response is either a ``EnterprisePreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to an enterprise and still available
    for assignment to users within the enterprise.

    The response is either
    ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number ranges in the enterprise.

    The response is either
    ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the enterprise.

    The response is either an ``EnterpriseSessionAdmissionControlGroupGetListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an ``EnterpriseSessionAdmissionControlGroupGetResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.

    The response is either an ``EnterpriseSessionAdmissionControlGroupGetResponse19sp1()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNDeletePolicyRequest(OCIRequest):
    """
    Delete a enterprise voice VPN location.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        location_dialing_code: locationDialingCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("location_dialing_code", "locationDialingCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    location_dialing_code: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetDefaultRequest(OCIRequest):
    """
    Request the Voice VPN default settings for the enterprise.

    The response is ``EnterpriseVoiceVPNGetDefaultResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetPolicyRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN location code.

    The response is either a ``EnterpriseVoiceVPNGetPolicyResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        location_dialing_code: locationDialingCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("location_dialing_code", "locationDialingCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    location_dialing_code: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.

    The response is either a ``EnterpriseVoiceVPNGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``EnterpriseVoiceVPNGetRequest14sp3()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNGetRequest14sp3(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.

    The response is either a ``EnterpriseVoiceVPNGetResponse14sp3()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class EnterpriseVoiceVPNModifyRequest(OCIRequest):
    """
    Modify the enterprise voice VPN level data associated with voice VPN.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        is_active: isActive
        default_selection: defaultSelection
        e164_selection: e164Selection
        use_phone_context: usePhoneContext
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("default_selection", "defaultSelection", str),
        E("e164_selection", "e164Selection", str),
        E("use_phone_context", "usePhoneContext", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    default_selection: str = Field(type=str, required=False, mutable=False)
    e164_selection: str = Field(type=str, required=False, mutable=False)
    use_phone_context: bool = Field(type=bool, required=False, mutable=False)


class ExternalAuthenticationAuthorizeTokenRequest(OCIRequest):
    """
    This command is part of the Portal API.

    Sent when a Web or CLI user logs in using external authentication.  The password must
    be hashed.  The password hashing algorithm is: 1) The message digest of the user's
    plain password is calculated using the SHA algorithm.  2) For every four bits in the
    160-bit digest, starting from the first bit, it is converted into a character in ASCII
    Hex format (0 through 9, a through f). The result is a 40-character string, for
    example, f7a9e24777ec23212c54d7a350bc5bea5477fdbb.  3) The above string then is used
    to populate the password field in the request.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
        password: password
        login_token: loginToken
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("password", "password", str),
        E("login_token", "loginToken", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    login_token: str = Field(type=str, required=True, mutable=False)


class ExternalAuthenticationCreateLoginTokenRequest(OCIRequest):
    """
    This command allows a BroadWorks or Third-Party Client Application to create a Single
    Sign-On token for a user.

    The response is either ``ExternalAuthenticationCreateLoginTokenResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a group access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a group access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        tag_name: tagName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either ``GroupAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a group access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class GroupAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified group access device.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``GroupAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceFileGetListRequest14sp8()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``GroupAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceFileGetRequest14sp8()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        file_type: fileType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_type: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``GroupAccessDeviceFileGetRequest16sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a group device profile file.

    The response is either ``GroupAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetAvailableDetailListRequest14(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user within a group.

    The list includes devices created at the system, service provider, and group levels.

    The response is either ``GroupAccessDeviceGetAvailableDetailListResponse14()`` or
    ``ErrorResponse()``. Replaced by:
    ``GroupAccessDeviceGetAvailableDetailListRequest19()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_music_on_hold: isMusicOnHold
        only_video_capable: onlyVideoCapable
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_music_on_hold", "isMusicOnHold", bool, is_required=True),
        E("only_video_capable", "onlyVideoCapable", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_music_on_hold: bool = Field(type=bool, required=True, mutable=False)
    only_video_capable: bool = Field(type=bool, required=True, mutable=False)


class GroupAccessDeviceGetAvailableDetailListRequest19(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user within a group.

    The list includes devices created at the system, service provider, and group levels.

    The response is either ``GroupAccessDeviceGetAvailableDetailListResponse19()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_music_on_hold: isMusicOnHold
        only_video_capable: onlyVideoCapable
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_music_on_hold", "isMusicOnHold", bool, is_required=True),
        E("only_video_capable", "onlyVideoCapable", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_music_on_hold: bool = Field(type=bool, required=True, mutable=False)
    only_video_capable: bool = Field(type=bool, required=True, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeListRequest(OCIRequest):
    """
    Requests the list of configurable device types of devices that have already been added
    to the group.

    The response is either ``GroupAccessDeviceGetEnhancedConfigurationTypeListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetEnhancedConfigurationTypeRequest14(OCIRequest):
    """
    Requests the details of a specified configurable device type for a group.

    The response is either ``GroupAccessDeviceGetEnhancedConfigurationTypeResponse14()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse14()`` or ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceGetRequest14sp3()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse14sp3()`` or ``ErrorResponse()``.

    Replaced By: ``GroupAccessDeviceGetRequest14sp6()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse14sp6()`` or ``ErrorResponse()``.
    Replaced by: ``GroupAccessDeviceGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse16()`` or ``ErrorResponse()``.
    Replaced by: ``GroupAccessDeviceGetRequest18sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified group access device.

    The response is either ``GroupAccessDeviceGetResponse18sp1()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the group device profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode and ignored in AS data mode: privateIdentity

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        line_port: linePort
        private_identity: privateIdentity
        is_primary_line_port: isPrimaryLinePort
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("is_primary_line_port", "isPrimaryLinePort", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    private_identity: str = Field(type=str, required=False, mutable=False)
    is_primary_line_port: bool = Field(type=bool, required=False, mutable=False)


class GroupAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific group SIP device that supports the reset operation.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupAccountAuthorizationCodesDeleteListRequest(OCIRequest):
    """
    Delete a list of account/authorization codes from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetListRequest(OCIRequest):
    """
    Request the list of account/authorization codes for a group.

    The response is either a ``GroupAccountAuthorizationCodesGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupAccountAuthorizationCodesGetRequest(OCIRequest):
    """
    Request the group's account/authorization codes setting.

    The response is either a ``GroupAccountAuthorizationCodesGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminAddRequest(OCIRequest):
    """
    Add a group administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)


class GroupAdminDeleteRequest(OCIRequest):
    """
    Delete a group administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetListRequest(OCIRequest):
    """
    Get a list of group and department administrators within the group.

    The response is either a ``GroupAdminGetListResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest14sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse14sp1()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse16sp1()`` or ``ErrorResponse()``.
    Replaced by: ``GroupAdminGetPolicyRequest17()``

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse16sp2()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse17()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse17sp3()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse18()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest19sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse19sp1()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the Group administrator's policy settings.

    The response is either ``GroupAdminGetPolicyResponse20()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminGetRequest(OCIRequest):
    """
    Get a group administrators profile.

    The response is either a ``GroupAdminGetResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupAdminModifyPolicyRequest(OCIRequest):
    """
    Request to modify the group administrator's policy settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: dialableCallerIDAccess
    verifyTranslationAndRoutingAccess communicationBarringUserProfileAccess (only
    applicable to groups in an Enterprise)

    Attributes:
        user_id: userId
        profile_access: profileAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        enhanced_service_instance_access: enhancedServiceInstanceAccess
        feature_access_code_access: featureAccessCodeAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        trunk_group_access: trunkGroupAccess
        session_admission_control_access: sessionAdmissionControlAccess
        office_zone_access: officeZoneAccess
        dialable_caller_id_access: dialableCallerIDAccess
        number_activation_access: numberActivationAccess
        verify_translation_and_routing_access: verifyTranslationAndRoutingAccess
        communication_barring_user_profile_access: communicationBarringUserProfileAccess
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("profile_access", "profileAccess", str),
        E("user_access", "userAccess", str),
        E("admin_access", "adminAccess", str),
        E("department_access", "departmentAccess", str),
        E("access_device_access", "accessDeviceAccess", str),
        E("enhanced_service_instance_access", "enhancedServiceInstanceAccess", str),
        E("feature_access_code_access", "featureAccessCodeAccess", str),
        E("phone_number_extension_access", "phoneNumberExtensionAccess", str),
        E("calling_line_id_number_access", "callingLineIdNumberAccess", str),
        E("service_access", "serviceAccess", str),
        E("trunk_group_access", "trunkGroupAccess", str),
        E("session_admission_control_access", "sessionAdmissionControlAccess", str),
        E("office_zone_access", "officeZoneAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess", str),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess", str,
        ),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    profile_access: str = Field(type=str, required=False, mutable=False)
    user_access: str = Field(type=str, required=False, mutable=False)
    admin_access: str = Field(type=str, required=False, mutable=False)
    department_access: str = Field(type=str, required=False, mutable=False)
    access_device_access: str = Field(type=str, required=False, mutable=False)
    enhanced_service_instance_access: str = Field(type=str, required=False, mutable=False)
    feature_access_code_access: str = Field(type=str, required=False, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=False, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=False, mutable=False)
    service_access: str = Field(type=str, required=False, mutable=False)
    trunk_group_access: str = Field(type=str, required=False, mutable=False)
    session_admission_control_access: str = Field(type=str, required=False, mutable=False)
    office_zone_access: str = Field(type=str, required=False, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=False, mutable=False)
    number_activation_access: str = Field(type=str, required=False, mutable=False)
    verify_translation_and_routing_access: str = Field(
        type=str, required=False, mutable=False,
    )
    communication_barring_user_profile_access: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupAdminModifyRequest(OCIRequest):
    """
    Modify a group administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)


class GroupAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge group parameters.

    The response is either ``GroupAdviceOfChargeGetResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge group settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_group_level_ao_c_settings: useGroupLevelAoCSettings
        delay_between_notification_seconds: delayBetweenNotificationSeconds
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_level_ao_c_settings", "useGroupLevelAoCSettings", bool),
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_group_level_ao_c_settings: bool = Field(type=bool, required=False, mutable=False)
    delay_between_notification_seconds: int = Field(type=int, required=False, mutable=False)


class GroupApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a group.

    The response is either a ``GroupApplicationServerSetGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        application_server_set_name: applicationServerSetName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("application_server_set_name", "applicationServerSetName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    application_server_set_name: str = Field(type=str, required=False, mutable=False)


class GroupAutoAttendantDeleteInstanceRequest(OCIRequest):
    """
    Delete a Auto Attendant instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceListRequest(OCIRequest):
    """
    Get a list of Auto Attendant instances within a group.

    The response is either ``GroupAutoAttendantGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupAutoAttendantGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupAutoAttendantGetInstanceRequest16()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse16()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse17()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse17sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupAutoAttendantGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``. Replaced by: ``GroupAutoAttendantGetInstanceRequest20()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.

    The response is either ``GroupAutoAttendantGetInstanceResponse20()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuDeleteListRequest(OCIRequest):
    """
    Delete a submenu form an auto attendant.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. This request is
    only valid for Standard auto attendants.

    Attributes:
        service_user_id: serviceUserId
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    submenu_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Submenus.

    The response is either ``GroupAutoAttendantSubmenuGetListResponse()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetRequest(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.

    The response is either ``GroupAutoAttendantSubmenuGetResponse()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id: serviceUserId
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    submenu_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetRequest20(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.

    The response is either ``GroupAutoAttendantSubmenuGetResponse20()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id: serviceUserId
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    submenu_id: str = Field(type=str, required=True, mutable=False)


class GroupAutoAttendantSubmenuGetUsageListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Business Hours Menu,After Hours Menu,Holiday Menu and
    Submenus that use this submenu.

    The response is either ``GroupAutoAttendantSubmenuGetUsageListResponse()`` or
    ``ErrorResponse()``. This request is only valid for Standard auto attendants.

    Attributes:
        service_user_id: serviceUserId
        submenu_id: submenuId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("submenu_id", "submenuId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    submenu_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereDeleteInstanceRequest(OCIRequest):
    """
    Delete a BroadWorks Anywhere instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceListRequest(OCIRequest):
    """
    Get a list of BroadWorks Anywhere instances within a group.

    The response is either ``GroupBroadWorksAnywhereGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupBroadWorksAnywhereGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse17()`` or
    ``ErrorResponse()``. Replaced by: ``GroupBroadWorksAnywhereGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksAnywhereGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.

    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerActivationRequest(OCIRequest):
    """
    Activates or Deactivates the BroadWorks Mobile Manager.

    The deactivationReason is required when isActive is set to false.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_active: isActive
        deactivation_reason: deactivationReason
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("deactivation_reason", "deactivationReason", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    deactivation_reason: str = Field(type=str, required=False, mutable=False)


class GroupBroadWorksMobileManagerAddHomeZoneRequest(OCIRequest):
    """
    Add a home zone to the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        home_zone_domain_name: homeZoneDomainName
        mobile_country_code: mobileCountryCode
        mobile_network_code: mobileNetworkCode
        location_area_code: locationAreaCode
        cell_identity: cellIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str, is_required=True),
        E("mobile_country_code", "mobileCountryCode", str, is_required=True),
        E("mobile_network_code", "mobileNetworkCode", str, is_required=True),
        E("location_area_code", "locationAreaCode", str, is_required=True),
        E("cell_identity", "cellIdentity", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    home_zone_domain_name: str = Field(type=str, required=True, mutable=False)
    mobile_country_code: str = Field(type=str, required=True, mutable=False)
    mobile_network_code: str = Field(type=str, required=True, mutable=False)
    location_area_code: str = Field(type=str, required=True, mutable=False)
    cell_identity: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerAddRequest(OCIRequest):
    """
    Add the BroadWorks Mobile Manager.

    Only one BroadWorks Mobile Manager can be added per group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        information_file: informationFile
        certificate_file: certificateFile
        is_active: isActive
        local_to_carrier: localToCarrier
        max_tx_per_second_enabled: maxTxPerSecondEnabled
        max_tx_per_second: maxTxPerSecond
        tldn_enabled: tldnEnabled
        generic_number_enabled: genericNumberEnabled
        mobile_state_check_enabled: mobileStateCheckEnabled
        location_based_services_enabled: locationBasedServicesEnabled
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("information_file", "informationFile", str, is_required=True),
        E("certificate_file", "certificateFile", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("local_to_carrier", "localToCarrier", bool, is_required=True),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool, is_required=True),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool, is_required=True),
        E("generic_number_enabled", "genericNumberEnabled", bool, is_required=True),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool, is_required=True),
        E(
            "location_based_services_enabled", "locationBasedServicesEnabled", bool,
            is_required=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    information_file: str = Field(type=str, required=True, mutable=False)
    certificate_file: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    local_to_carrier: bool = Field(type=bool, required=True, mutable=False)
    max_tx_per_second_enabled: bool = Field(type=bool, required=True, mutable=False)
    max_tx_per_second: int = Field(type=int, required=False, mutable=False)
    tldn_enabled: bool = Field(type=bool, required=True, mutable=False)
    generic_number_enabled: bool = Field(type=bool, required=True, mutable=False)
    mobile_state_check_enabled: bool = Field(type=bool, required=True, mutable=False)
    location_based_services_enabled: bool = Field(type=bool, required=True, mutable=False)


class GroupBroadWorksMobileManagerDeleteHomeZoneListRequest(OCIRequest):
    """
    Delete a list of home zones from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        home_zone_id: homeZoneId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerDeleteHomeZoneRequest(OCIRequest):
    """
    Delete a home zone from the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        home_zone_id: homeZoneId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerDeleteRequest(OCIRequest):
    """
    Delete the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetDomainListRequest(OCIRequest):
    """
    Get the list of domains of the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetDomainListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneListRequest(OCIRequest):
    """
    Get the list of home zones of the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetHomeZoneListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetHomeZoneRequest(OCIRequest):
    """
    Get a home zone from the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetHomeZoneResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        home_zone_id: homeZoneId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager.

    The response is either ``GroupBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobileManagerModifyHomeZoneRequest(OCIRequest):
    """
    Modify an existing home zone in the BroadWorks Mobile Manager.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        home_zone_id: homeZoneId
        home_zone_domain_name: homeZoneDomainName
        mobile_country_code: mobileCountryCode
        mobile_network_code: mobileNetworkCode
        location_area_code: locationAreaCode
        cell_identity: cellIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("home_zone_id", "homeZoneId", str, is_required=True),
        E("home_zone_domain_name", "homeZoneDomainName", str),
        E("mobile_country_code", "mobileCountryCode", str),
        E("mobile_network_code", "mobileNetworkCode", str),
        E("location_area_code", "locationAreaCode", str),
        E("cell_identity", "cellIdentity", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    home_zone_id: str = Field(type=str, required=True, mutable=False)
    home_zone_domain_name: str = Field(type=str, required=False, mutable=False)
    mobile_country_code: str = Field(type=str, required=False, mutable=False)
    mobile_network_code: str = Field(type=str, required=False, mutable=False)
    location_area_code: str = Field(type=str, required=False, mutable=False)
    cell_identity: str = Field(type=str, required=False, mutable=False)


class GroupBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        information_file: informationFile
        certificate_file: certificateFile
        local_to_carrier: localToCarrier
        max_tx_per_second_enabled: maxTxPerSecondEnabled
        max_tx_per_second: maxTxPerSecond
        tldn_enabled: tldnEnabled
        generic_number_enabled: genericNumberEnabled
        mobile_state_check_enabled: mobileStateCheckEnabled
        location_based_services_enabled: locationBasedServicesEnabled
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("information_file", "informationFile", str),
        E("certificate_file", "certificateFile", str),
        E("local_to_carrier", "localToCarrier", bool),
        E("max_tx_per_second_enabled", "maxTxPerSecondEnabled", bool),
        E("max_tx_per_second", "maxTxPerSecond", int),
        E("tldn_enabled", "tldnEnabled", bool),
        E("generic_number_enabled", "genericNumberEnabled", bool),
        E("mobile_state_check_enabled", "mobileStateCheckEnabled", bool),
        E("location_based_services_enabled", "locationBasedServicesEnabled", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    information_file: str = Field(type=str, required=False, mutable=False)
    certificate_file: str = Field(type=str, required=False, mutable=False)
    local_to_carrier: bool = Field(type=bool, required=False, mutable=False)
    max_tx_per_second_enabled: bool = Field(type=bool, required=False, mutable=False)
    max_tx_per_second: int = Field(type=int, required=False, mutable=False)
    tldn_enabled: bool = Field(type=bool, required=False, mutable=False)
    generic_number_enabled: bool = Field(type=bool, required=False, mutable=False)
    mobile_state_check_enabled: bool = Field(type=bool, required=False, mutable=False)
    location_based_services_enabled: bool = Field(type=bool, required=False, mutable=False)


class GroupBroadWorksMobileManagerSendCarrierFilesRequest(OCIRequest):
    """
    Sends an email with the carrier information and certificate files.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        email_to: emailTo
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("email_to", "emailTo", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    email_to: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the groups BroadWorks Mobility settings.

    The response is either a ``GroupBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.

    The response is either a ``GroupBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberAssignListRequest(OCIRequest):
    """
    Assign Mobile Subscriber Directory Numbers to a group.

    It is possible to add a single DN,or a list of DNs.  . This command is applicable only
    for group in a service provider and will fail for a group in an enterprise.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        mobile_subscriber_directory_number: mobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any user.

    . This command is applicable only for group in a service provider and will fail for a
    group in an enterprise.

    The response is either
    ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberUnassignListRequest(OCIRequest):
    """
    Unassign Mobile Subscriber Directory Numbers from a group.

    It is possible to unassign either: a single DN, or a list of DNs.  . This command is
    applicable only for group in a service provider and will fail for a group in an
    enterprise.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        mobile_subscriber_directory_number: mobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class GroupBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the group level broadworks mobility service settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_setting_level: useSettingLevel
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        enable_announcement_suppression: enableAnnouncementSuppression
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_setting_level", "useSettingLevel", str),
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_setting_level: str = Field(type=str, required=False, mutable=False)
    enable_location_services: bool = Field(type=bool, required=False, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=False, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=False, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=False, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=False, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=False, mutable=False)


class GroupCPEConfigRebuildConfigFileRequest(OCIRequest):
    """
    Rebuild the group default config file for the specified device type.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        force: force
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("force", "force", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    force: bool = Field(type=bool, required=False, mutable=False)


class GroupCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        force: force
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    force: bool = Field(type=bool, required=False, mutable=False)


class GroupCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a group device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the
    ``GroupAccessDeviceGetRequest16()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
        ordered_line_port_list: orderedLinePortList
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("ordered_line_port_list", "orderedLinePortList", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    ordered_line_port_list: str = Field(type=str, required=True, mutable=False)


class GroupCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific group device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class GroupCPEConfigResetDeviceTypeRequest(OCIRequest):
    """
    Reset all the devices of the specified device type in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementAddInstanceRequest(OCIRequest):
    """
    Adds a Call Capacity Management group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        max_active_calls_allowed: maxActiveCallsAllowed
        max_incoming_active_calls_allowed: maxIncomingActiveCallsAllowed
        max_outgoing_active_calls_allowed: maxOutgoingActiveCallsAllowed
        become_default_group_for_new_users: becomeDefaultGroupForNewUsers
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("max_active_calls_allowed", "maxActiveCallsAllowed", int, is_required=True),
        E("max_incoming_active_calls_allowed", "maxIncomingActiveCallsAllowed", int),
        E("max_outgoing_active_calls_allowed", "maxOutgoingActiveCallsAllowed", int),
        E(
            "become_default_group_for_new_users", "becomeDefaultGroupForNewUsers", bool,
            is_required=True,
        ),
        E("user_id", "userId", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    max_active_calls_allowed: int = Field(type=int, required=True, mutable=False)
    max_incoming_active_calls_allowed: int = Field(type=int, required=False, mutable=False)
    max_outgoing_active_calls_allowed: int = Field(type=int, required=False, mutable=False)
    become_default_group_for_new_users: bool = Field(type=bool, required=True, mutable=False)
    user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallCapacityManagementAddUserListRequest(OCIRequest):
    """
    Adds one or more users to a Call Capacity Management group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementDeleteInstanceListRequest(OCIRequest):
    """
    Deletes one or more Call Capacity Management groups.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementDeleteUserListRequest(OCIRequest):
    """
    Deletes one or more users from a Call Capacity Management group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Capacity Management instances within a group.

    The response is either ``GroupCallCapacityManagementGetInstanceListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCapacityManagementGetInstanceRequest(OCIRequest):
    """
    Gets a Call Capacity Management group.

    The response is either ``GroupCallCapacityManagementGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAddSupervisorListRequest(OCIRequest):
    """
    Add supervisor(s) to a call center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        supervisor_user_id: supervisorUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("supervisor_user_id", "supervisorUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    supervisor_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.

    When an agent is assigned (added )to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        profile_name: profileName
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)
    agent_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in a Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        profile_name: profileName
        profile_description: profileDescription
        threshold_current_call_state_idle_time_yellow:
            thresholdCurrentCallStateIdleTimeYellow
        threshold_current_call_state_idle_time_red: thresholdCurrentCallStateIdleTimeRed
        threshold_current_call_state_on_call_time_yellow:
            thresholdCurrentCallStateOnCallTimeYellow
        threshold_current_call_state_on_call_time_red:
            thresholdCurrentCallStateOnCallTimeRed
        threshold_current_agent_state_unavailable_time_yellow:
            thresholdCurrentAgentStateUnavailableTimeYellow
        threshold_current_agent_state_unavailable_time_red:
            thresholdCurrentAgentStateUnavailableTimeRed
        threshold_average_busy_in_time_yellow: thresholdAverageBusyInTimeYellow
        threshold_average_busy_in_time_red: thresholdAverageBusyInTimeRed
        threshold_average_busy_out_time_yellow: thresholdAverageBusyOutTimeYellow
        threshold_average_busy_out_time_red: thresholdAverageBusyOutTimeRed
        threshold_average_wrap_up_time_yellow: thresholdAverageWrapUpTimeYellow
        threshold_average_wrap_up_time_red: thresholdAverageWrapUpTimeRed
        enable_notification_email: enableNotificationEmail
        notification_email_address: notificationEmailAddress
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("profile_description", "profileDescription", str),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow", int,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow", int,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed", int,
        ),
        E("threshold_average_busy_in_time_yellow", "thresholdAverageBusyInTimeYellow", int),
        E("threshold_average_busy_in_time_red", "thresholdAverageBusyInTimeRed", int),
        E("threshold_average_busy_out_time_yellow", "thresholdAverageBusyOutTimeYellow", int),
        E("threshold_average_busy_out_time_red", "thresholdAverageBusyOutTimeRed", int),
        E("threshold_average_wrap_up_time_yellow", "thresholdAverageWrapUpTimeYellow", int),
        E("threshold_average_wrap_up_time_red", "thresholdAverageWrapUpTimeRed", int),
        E("enable_notification_email", "enableNotificationEmail", bool, is_required=True),
        E("notification_email_address", "notificationEmailAddress", str),
        E("agent_user_id", "agentUserId", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)
    profile_description: str = Field(type=str, required=False, mutable=False)
    threshold_current_call_state_idle_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_idle_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_call_state_on_call_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_current_agent_state_unavailable_time_red: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_in_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_busy_out_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_busy_out_time_red: int = Field(type=int, required=False, mutable=False)
    threshold_average_wrap_up_time_yellow: int = Field(
        type=int, required=False, mutable=False,
    )
    threshold_average_wrap_up_time_red: int = Field(type=int, required=False, mutable=False)
    enable_notification_email: bool = Field(type=bool, required=True, mutable=False)
    notification_email_address: str = Field(type=str, required=False, mutable=False)
    agent_user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.

    Agents cannot be unassigned (deleted) directly from the default profile, they need to
    be assigned (added) to a different profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        profile_name: profileName
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)
    agent_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in a Group.

    The default profile cannot be deleted.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        profile_name: profileName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Group.

    The response is either ``GroupCallCenterAgentThresholdProfileGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in a Group.

    The response is either a ``GroupCallCenterAgentThresholdProfileGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        profile_name: profileName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("profile_name", "profileName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    profile_name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_active: isActive
        code: code
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("code", "code", str, is_required=True),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.

    The response is either ``GroupCallCenterAgentUnavailableCodeGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.

    The response is either ``GroupCallCenterAgentUnavailableCodeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either an ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse()``
    or an ``ErrorResponse()``. Replaced by
    ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code
    Settings.

    The response is either a
    ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterBouncedCallGetRequest(OCIRequest):
    """
    Get a call center's bounced call settings.

    The response is either a ``GroupCallCenterBouncedCallGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterBouncedCallGetRequest17()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterBouncedCallGetRequest17(OCIRequest):
    """
    Get a call center's bounced call settings.

    The response is either a ``GroupCallCenterBouncedCallGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterBouncedCallModifyRequest(OCIRequest):
    """
    Modify a call center's bounced call settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        is_active: isActive
        number_of_rings_before_bouncing_call: numberOfRingsBeforeBouncingCall
        enable_transfer: enableTransfer
        transfer_phone_number: transferPhoneNumber
        bounce_call_when_agent_unavailable: bounceCallWhenAgentUnavailable
        alert_call_center_call_on_hold: alertCallCenterCallOnHold
        alert_call_center_call_on_hold_seconds: alertCallCenterCallOnHoldSeconds
        bounce_call_center_call_on_hold: bounceCallCenterCallOnHold
        bounce_call_center_call_on_hold_seconds: bounceCallCenterCallOnHoldSeconds
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall", int),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool),
        E("alert_call_center_call_on_hold", "alertCallCenterCallOnHold", bool),
        E("alert_call_center_call_on_hold_seconds", "alertCallCenterCallOnHoldSeconds", int),
        E("bounce_call_center_call_on_hold", "bounceCallCenterCallOnHold", bool),
        E(
            "bounce_call_center_call_on_hold_seconds",
            "bounceCallCenterCallOnHoldSeconds", int,
        ),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    number_of_rings_before_bouncing_call: int = Field(type=int, required=False, mutable=False)
    enable_transfer: bool = Field(type=bool, required=False, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    bounce_call_when_agent_unavailable: bool = Field(type=bool, required=False, mutable=False)
    alert_call_center_call_on_hold: bool = Field(type=bool, required=False, mutable=False)
    alert_call_center_call_on_hold_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    bounce_call_center_call_on_hold: bool = Field(type=bool, required=False, mutable=False)
    bounce_call_center_call_on_hold_seconds: int = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.

    The response is either ``GroupCallCenterCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either ``GroupCallCenterCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.

    The response is either ``GroupCallCenterCallDispositionCodeGetUsageListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterComfortMessageBypassGetRequest(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterComfortMessageBypassGetRequest17(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterComfortMessageBypassGetRequest20(OCIRequest):
    """
    Get a call center's comfort message bypass settings.

    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the group.

    The response is either ``GroupCallCenterCurrentAndPastDNISGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a call center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        agent_user_id: agentUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("agent_user_id", "agentUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    agent_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterDeleteInstanceRequest(OCIRequest):
    """
    Delete a Call Center instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterDeleteSupervisorListRequest(OCIRequest):
    """
    Delete supervisor(s) from a call center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        supervisor_user_id: supervisorUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("supervisor_user_id", "supervisorUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    supervisor_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.

    The response is either a ``GroupCallCenterDistinctiveRingingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        distinctive_ringing_call_center_calls: distinctiveRingingCallCenterCalls
        distinctive_ringing_ring_pattern_for_call_center:
            distinctiveRingingRingPatternForCallCenter
        distinctive_ringing_force_delivery_ring_pattern:
            distinctiveRingingForceDeliveryRingPattern
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls", bool),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    distinctive_ringing_call_center_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    distinctive_ringing_ring_pattern_for_call_center: str = Field(
        type=str, required=False, mutable=False,
    )
    distinctive_ringing_force_delivery_ring_pattern: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterEnhancedGetRequest(OCIRequest):
    """
    Request to get the Call Center Enhanced configuration data for a Call Center.

    The response is either ``GroupCallCenterEnhancedGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceResponse16()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedModifyRequest(OCIRequest):
    """
    Modify the Call Center Enhanced configuration data for a Call Center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterModifyInstanceRequest16()``

    Attributes:
        service_user_id: serviceUserId
        override_agent_wrap_up_time: overrideAgentWrapUpTime
        wrap_up_seconds: wrapUpSeconds
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("override_agent_wrap_up_time", "overrideAgentWrapUpTime", bool),
        E("wrap_up_seconds", "wrapUpSeconds", int),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    override_agent_wrap_up_time: bool = Field(type=bool, required=False, mutable=False)
    wrap_up_seconds: int = Field(type=int, required=False, mutable=False)


class GroupCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the group branding information.

    The response is either ``GroupCallCenterEnhancedReportingBrandingGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for a group.

    The response is either a
    ``GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.

    The response is either a ``GroupCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``. Replaced by ``GroupCallCenterEnhancedReportingGetRequest19()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.

    The response is either a ``GroupCallCenterEnhancedReportingGetResponse19()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``GroupCallCenterEnhancedReportingModifyRequest19()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        reporting_server: reportingServer
        web_statistic_source: webStatisticSource
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
        E("web_statistic_source", "webStatisticSource", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    reporting_server: str = Field(type=str, required=False, mutable=False)
    web_statistic_source: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        reporting_server: reportingServer
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("reporting_server", "reportingServer", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    reporting_server: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center report template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get group level call center report template list.

    The response is either a
    ``GroupCallCenterEnhancedReportingReportTemplateGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get a group level call center report template.

    The response is either a
    ``GroupCallCenterEnhancedReportingReportTemplateGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center reporting scheduled report.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in a group that uses a
    given group level report template.

    The response is either a
    ``GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get a group level call center reporting scheduled report.

    The response is either a
    ``GroupCallCenterEnhancedReportingScheduledReportGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetRequest(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a ``GroupCallCenterForcedForwardingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetRequest17(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a ``GroupCallCenterForcedForwardingGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterForcedForwardingGetRequest20(OCIRequest):
    """
    Get a call center's forced forwarding settings.

    The response is either a ``GroupCallCenterForcedForwardingGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest14sp6(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse14sp6()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetAnnouncementRequest16()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest16(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest17(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse17()`` or an
    ``ErrorResponse()``. Replaced by ``GroupCallCenterGetAnnouncementRequest17sp4()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest17sp4(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse17sp4()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterGetAnnouncementRequest19()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest19(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse19()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetAnnouncementRequest20(OCIRequest):
    """
    Get a call center's announcement settings.

    The response is either a ``GroupCallCenterGetAnnouncementResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Call Center.

    The response is either ``GroupCallCenterGetDNISListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetDistinctiveRingingRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.

    The response is either a ``GroupCallCenterGetDistinctiveRingingResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceListRequest(OCIRequest):
    """
    Get a list of Call Center instances within a group.

    The response is either ``GroupCallCenterGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterGetInstanceQueueStatusRequest(OCIRequest):
    """
    Get Call Center queue status.

    The response is either ``GroupCallCenterGetInstanceQueueStatusResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse14()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceRequest14sp3()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest14sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse14sp3()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceRequest14sp9()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest14sp9(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse14sp9()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceRequest16()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse16()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse17()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse17sp1()`` or
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterGetInstanceRequest17sp3()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``. Replaced by ``GroupCallCenterGetInstanceRequest19()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupCallCenterGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.

    The response is either ``GroupCallCenterGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingRequest(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceStatisticsReportingRequest16()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingRequest16(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse16()``
    or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Request to get the call center statistics reporting settings.

    The response is either
    ``GroupCallCenterGetInstanceStatisticsReportingResponse17sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetInstanceStatisticsRequest13mp8(OCIRequest):
    """
    Get Call Center queue and agent statistics.

    The response is either ``GroupCallCenterGetInstanceStatisticsResponse13mp8()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetInstanceStatisticsRequest14sp9()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetRequest(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a ``GroupCallCenterGetResponse()`` or an ``ErrorResponse()``.
    Replaced by ``GroupCallCenterGetRequest17sp4()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the Group level data associated with Call Center.

    The response is either a ``GroupCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the group call center routing policy.

    The response is either a ``GroupCallCenterGetRoutingPolicyResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetSupervisorListRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    Only users in the same group or enterprise as this call center can successfully
    execute this request.

    The response is either a ``GroupCallCenterGetSupervisorListResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterSupervisorReportingGetRequest()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetSupervisorListRequest16(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    The response is either a ``GroupCallCenterGetSupervisorListResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterGetUnlicensedAgentListRequest(OCIRequest):
    """
    Get a list of unlicensed users who are preventing the Call Center from upgrading to
    another type.

    The response is either ``GroupCallCenterGetUnlicensedAgentListRequest()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        call_center_type: callCenterType
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("call_center_type", "callCenterType", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    call_center_type: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest17(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterHolidayServiceGetRequest20(OCIRequest):
    """
    Get a call center's holiday service settings.

    The response is either a ``GroupCallCenterHolidayServiceGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Call Center.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        display_dnis_number: displayDNISNumber
        display_dnis_name: displayDNISName
        promote_calls_from_priority1to0: promoteCallsFromPriority1to0
        promote_calls_from_priority2to1: promoteCallsFromPriority2to1
        promote_calls_from_priority3to2: promoteCallsFromPriority3to2
        promote_calls_from_priority1to0_seconds: promoteCallsFromPriority1to0Seconds
        promote_calls_from_priority2to1_seconds: promoteCallsFromPriority2to1Seconds
        promote_calls_from_priority3to2_seconds: promoteCallsFromPriority3to2Seconds
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("display_dnis_number", "displayDNISNumber", bool),
        E("display_dnis_name", "displayDNISName", bool),
        E("promote_calls_from_priority1to0", "promoteCallsFromPriority1to0", bool),
        E("promote_calls_from_priority2to1", "promoteCallsFromPriority2to1", bool),
        E("promote_calls_from_priority3to2", "promoteCallsFromPriority3to2", bool),
        E(
            "promote_calls_from_priority1to0_seconds",
            "promoteCallsFromPriority1to0Seconds", int,
        ),
        E(
            "promote_calls_from_priority2to1_seconds",
            "promoteCallsFromPriority2to1Seconds", int,
        ),
        E(
            "promote_calls_from_priority3to2_seconds",
            "promoteCallsFromPriority3to2Seconds", int,
        ),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    display_dnis_number: bool = Field(type=bool, required=False, mutable=False)
    display_dnis_name: bool = Field(type=bool, required=False, mutable=False)
    promote_calls_from_priority1to0: bool = Field(type=bool, required=False, mutable=False)
    promote_calls_from_priority2to1: bool = Field(type=bool, required=False, mutable=False)
    promote_calls_from_priority3to2: bool = Field(type=bool, required=False, mutable=False)
    promote_calls_from_priority1to0_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    promote_calls_from_priority2to1_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    promote_calls_from_priority3to2_seconds: int = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallCenterModifyDistinctiveRingingRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        distinctive_ringing_call_center_calls: distinctiveRingingCallCenterCalls
        distinctive_ringing_ring_pattern_for_call_center:
            distinctiveRingingRingPatternForCallCenter
        distinctive_ringing_force_delivery_ring_pattern:
            distinctiveRingingForceDeliveryRingPattern
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("distinctive_ringing_call_center_calls", "distinctiveRingingCallCenterCalls", bool),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter", str,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    distinctive_ringing_call_center_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    distinctive_ringing_ring_pattern_for_call_center: str = Field(
        type=str, required=False, mutable=False,
    )
    distinctive_ringing_force_delivery_ring_pattern: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupCallCenterModifyInstanceStatisticsReportingRequest(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9()``

    Attributes:
        service_user_id: serviceUserId
        clear_today_statistics: clearTodayStatistics
        generate_daily_report: generateDailyReport
        collection_period_minutes: collectionPeriodMinutes
        reporting_email_address1: reportingEmailAddress1
        reporting_email_address2: reportingEmailAddress2
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("clear_today_statistics", "clearTodayStatistics", bool),
        E("generate_daily_report", "generateDailyReport", bool),
        E("collection_period_minutes", "collectionPeriodMinutes", int),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    clear_today_statistics: bool = Field(type=bool, required=False, mutable=False)
    generate_daily_report: bool = Field(type=bool, required=False, mutable=False)
    collection_period_minutes: int = Field(type=int, required=False, mutable=False)
    reporting_email_address1: str = Field(type=str, required=False, mutable=False)
    reporting_email_address2: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        generate_daily_report: generateDailyReport
        collection_period_minutes: collectionPeriodMinutes
        reporting_email_address1: reportingEmailAddress1
        reporting_email_address2: reportingEmailAddress2
        statistics_source: statisticsSource
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("generate_daily_report", "generateDailyReport", bool),
        E("collection_period_minutes", "collectionPeriodMinutes", int),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    generate_daily_report: bool = Field(type=bool, required=False, mutable=False)
    collection_period_minutes: int = Field(type=int, required=False, mutable=False)
    reporting_email_address1: str = Field(type=str, required=False, mutable=False)
    reporting_email_address2: str = Field(type=str, required=False, mutable=False)
    statistics_source: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterModifyInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        generate_daily_report: generateDailyReport
        collection_period_minutes: collectionPeriodMinutes
        reporting_email_address1: reportingEmailAddress1
        reporting_email_address2: reportingEmailAddress2
        statistics_source: statisticsSource
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("generate_daily_report", "generateDailyReport", bool),
        E("collection_period_minutes", "collectionPeriodMinutes", int),
        E("reporting_email_address1", "reportingEmailAddress1", str),
        E("reporting_email_address2", "reportingEmailAddress2", str),
        E("statistics_source", "statisticsSource", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    generate_daily_report: bool = Field(type=bool, required=False, mutable=False)
    collection_period_minutes: int = Field(type=int, required=False, mutable=False)
    reporting_email_address1: str = Field(type=str, required=False, mutable=False)
    reporting_email_address2: str = Field(type=str, required=False, mutable=False)
    statistics_source: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Call Center and the active status of Call
    Center instances.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_system_default_guard_timer: useSystemDefaultGuardTimer
        enable_guard_timer: enableGuardTimer
        guard_timer_seconds: guardTimerSeconds
        use_system_default_unavailable_settings: useSystemDefaultUnavailableSettings
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_system_default_guard_timer", "useSystemDefaultGuardTimer", bool),
        E("enable_guard_timer", "enableGuardTimer", bool),
        E("guard_timer_seconds", "guardTimerSeconds", int),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings", bool,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_system_default_guard_timer: bool = Field(type=bool, required=False, mutable=False)
    enable_guard_timer: bool = Field(type=bool, required=False, mutable=False)
    guard_timer_seconds: int = Field(type=int, required=False, mutable=False)
    use_system_default_unavailable_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=False, mutable=False,
    )


class GroupCallCenterNightServiceGetRequest(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterNightServiceGetRequest17(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterNightServiceGetRequest20(OCIRequest):
    """
    Get a call center's night service settings.

    The response is either a ``GroupCallCenterNightServiceGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterOverflowGetRequest(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a ``GroupCallCenterOverflowGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterOverflowGetRequest17(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a ``GroupCallCenterOverflowGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterOverflowGetRequest20(OCIRequest):
    """
    Get a call center's overflow settings.

    The response is either a ``GroupCallCenterOverflowGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Level and Organization Level Call Disposition Codes.

    The response is either ``GroupCallCenterQueueCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.

    The response is either ``GroupCallCenterQueueCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupCallCenterQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the user level data associated with Call Center Call Disposition Code
    Settings.

    The response is either a
    ``GroupCallCenterQueueCallDispositionCodeSettingsGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueStatusNotificationGetRequest(OCIRequest):
    """
    Get the status configuration for a given call center.

    The response is either a ``GroupCallCenterQueueStatusNotificationGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterQueueStatusNotificationModifyRequest(OCIRequest):
    """
    Set the status configuration for a given call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        enable_queue_status_notification: enableQueueStatusNotification
        enable_queue_depth_threshold: enableQueueDepthThreshold
        enable_waiting_time_threshold: enableWaitingTimeThreshold
        number_of_calls_threshold: numberOfCallsThreshold
        waiting_time_of_calls_threshold: waitingTimeOfCallsThreshold
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_queue_status_notification", "enableQueueStatusNotification", bool),
        E("enable_queue_depth_threshold", "enableQueueDepthThreshold", bool),
        E("enable_waiting_time_threshold", "enableWaitingTimeThreshold", bool),
        E("number_of_calls_threshold", "numberOfCallsThreshold", int),
        E("waiting_time_of_calls_threshold", "waitingTimeOfCallsThreshold", int),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    enable_queue_status_notification: bool = Field(type=bool, required=False, mutable=False)
    enable_queue_depth_threshold: bool = Field(type=bool, required=False, mutable=False)
    enable_waiting_time_threshold: bool = Field(type=bool, required=False, mutable=False)
    number_of_calls_threshold: int = Field(type=int, required=False, mutable=False)
    waiting_time_of_calls_threshold: int = Field(type=int, required=False, mutable=False)


class GroupCallCenterQueueThresholdsGetRequest(OCIRequest):
    """
    Get a call center's queue Thresholds settings.

    The response is either a ``GroupCallCenterQueueThresholdsGetRequest()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallGetRequest(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a ``GroupCallCenterStrandedCallGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallGetRequest17(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a ``GroupCallCenterStrandedCallGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallGetRequest20(OCIRequest):
    """
    Get a call center's stranded call settings.

    The response is either a ``GroupCallCenterStrandedCallGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallUnavailableGetRequest(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.

    The response is either a ``GroupCallCenterStrandedCallUnavailableGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterStrandedCallUnavailableGetRequest20(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.

    The response is either a ``GroupCallCenterStrandedCallUnavailableGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallCenterSupervisorReportingGetRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.

    Only users in the same group or enterprise as this call center can successfully
    execute this request.

    The response is either a ``GroupCallCenterSupervisorReportingGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallCenterGetSupervisorListRequest16()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCallParkAddInstanceRequest(OCIRequest):
    """
    Adds a Call Park group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallParkAddInstanceRequest16sp2(OCIRequest):
    """
    Adds a Call Park group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: recallAlternateUserId recallTo, use value
    "Parking User Only" in HSS data mode

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
        recall_alternate_user_id: recallAlternateUserId
        recall_to: recallTo
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_to", "recallTo", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: "List[str]" = Field(type=list, required=False, mutable=False)
    recall_alternate_user_id: str = Field(type=str, required=False, mutable=False)
    recall_to: str = Field(type=str, required=True, mutable=False)


class GroupCallParkDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Park group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallParkGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Park group instances within a group.

    The response is either ``GroupCallParkGetInstanceListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallParkGetInstanceRequest(OCIRequest):
    """
    Gets a Call Park group.

    The response is either ``GroupCallParkGetInstanceResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallParkGetInstanceRequest16sp2(OCIRequest):
    """
    Gets a Call Park group.

    The response is either ``GroupCallParkGetInstanceResponse16sp2()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallParkGetRequest(OCIRequest):
    """
    Gets the Call Park Group settings.

    The response is either ``GroupCallParkGetResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallParkGetRequest16sp2(OCIRequest):
    """
    Gets the Call Park Group settings.

    The response is either ``GroupCallParkGetResponse16sp2()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallParkModifyRequest(OCIRequest):
    """
    Modifies the Group's Call Park settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: recallAlternateUserId recallRingPattern
    recallTo alternateUserRecallTimerSeconds

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        recall_timer_seconds: recallTimerSeconds
        display_timer_seconds: displayTimerSeconds
        enable_destination_announcement: enableDestinationAnnouncement
        recall_alternate_user_id: recallAlternateUserId
        recall_ring_pattern: recallRingPattern
        recall_to: recallTo
        alternate_user_recall_timer_seconds: alternateUserRecallTimerSeconds
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("recall_timer_seconds", "recallTimerSeconds", int),
        E("display_timer_seconds", "displayTimerSeconds", int),
        E("enable_destination_announcement", "enableDestinationAnnouncement", bool),
        E("recall_alternate_user_id", "recallAlternateUserId", str),
        E("recall_ring_pattern", "recallRingPattern", str),
        E("recall_to", "recallTo", str),
        E("alternate_user_recall_timer_seconds", "alternateUserRecallTimerSeconds", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    recall_timer_seconds: int = Field(type=int, required=False, mutable=False)
    display_timer_seconds: int = Field(type=int, required=False, mutable=False)
    enable_destination_announcement: bool = Field(type=bool, required=False, mutable=False)
    recall_alternate_user_id: str = Field(type=str, required=False, mutable=False)
    recall_ring_pattern: str = Field(type=str, required=False, mutable=False)
    recall_to: str = Field(type=str, required=False, mutable=False)
    alternate_user_recall_timer_seconds: int = Field(type=int, required=False, mutable=False)


class GroupCallPickupAddInstanceRequest(OCIRequest):
    """
    Adds a Call Pickup group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupCallPickupDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Pickup group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallPickupGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Pickup instances within a group.

    The response is either ``GroupCallPickupGetInstanceListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallPickupGetInstanceRequest(OCIRequest):
    """
    Gets a Call Pickup group.

    The response is either ``GroupCallPickupGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14sp4()`` or an
    ``ErrorResponse()``.

    Replaced By : ``GroupCallProcessingGetPolicyRequest15()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse14sp7()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By: ``GroupCallProcessingGetPolicyRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCallProcessingGetPolicyRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse15sp2()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse16sp2()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID)

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse17sp3()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName) The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting attribute
    controls the Call Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID) The following elements are only used in AS
    data mode: useGroupDCLIDSetting enableDialableCallerID Replaced by
    ``GroupCallProcessingGetPolicyRequest17sp4()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse17sp4()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowConfigurableCLIDForRedirectingIdentity) The useGroupMediaSetting
    attribute controls the Media settings (medisPolicySelection, supportedMediaSetName)
    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID Replaced by
    ``GroupCallProcessingGetPolicyRequest18()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest18(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse18()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute
    controls the Media settings (medisPolicySelection, supportedMediaSetName) The
    useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride

    Replaced By : ``GroupCallProcessingGetPolicyRequest18sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse18sp1()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy Replaced by:
    ``GroupCallProcessingGetPolicyRequest19sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.

    The response is either a ``GroupCallProcessingGetPolicyResponse19sp1()`` or an
    ``ErrorResponse()``. The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride) The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The following elements are only used in AS data
    mode: useGroupDCLIDSetting enableDialableCallerID allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By : ``GroupCallProcessingModifyPolicyRequest15()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_group_setting: useGroupSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_setting", "useGroupSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_group_setting: bool = Field(type=bool, required=False, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallProcessingModifyPolicyRequest14sp7(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    useGroupCLIDSetting attribute controls the CLID settings (clidPolicy,
    emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity, useGroupName) The
    useGroupMediaSetting attribute controls the Media settings (medisPolicySelection,
    supportedMediaSetName) The useGroupCallLimitsSetting attribute controls the Call
    Limits settings (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By: ``GroupCallProcessingModifyPolicyRequest15sp2()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_clid_setting", "useGroupCLIDSetting", bool),
        E("use_group_media_setting", "useGroupMediaSetting", bool),
        E("use_group_call_limits_setting", "useGroupCallLimitsSetting", bool),
        E("use_group_translation_routing_setting", "useGroupTranslationRoutingSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_group_clid_setting: bool = Field(type=bool, required=False, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=False, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=False, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )
    clid_policy: str = Field(type=str, required=False, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=False, mutable=False)


class GroupCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``GroupCallProcessingModifyPolicyRequest15sp2()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_group_setting: useGroupSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_setting", "useGroupSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_group_setting: bool = Field(type=bool, required=False, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )


class GroupCallProcessingModifyPolicyRequest15sp2(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowConfigurableCLIDForRedirectingIdentity, allowDepartmentCLIDNameOverride) The
    allowDepartmentCLID attribute is automatically set to false when the useGroupName
    attribute is set to false.  The useGroupMediaSetting attribute controls the Media
    settings (medisPolicySelection, supportedMediaSetName) The useGroupCallLimitsSetting
    attribute controls the Call Limits settings (useMaxSimultaneousCalls,
    maxSimultaneousCalls, useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations) The
    useGroupTranslationRoutingSetting attribute controls the routing and translation
    settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing) The useGroupDCLIDSetting controls the Dialable
    Caller ID settings (enableDialableCallerID) The following elements are only used in AS
    data mode: useGroupDCLIDSetting enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity allowDepartmentCLIDNameOverride
    allowConfigurableCLIDForRedirectingIdentity enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_group_clid_setting: useGroupCLIDSetting
        use_group_media_setting: useGroupMediaSetting
        use_group_call_limits_setting: useGroupCallLimitsSetting
        use_group_translation_routing_setting: useGroupTranslationRoutingSetting
        use_group_dclid_setting: useGroupDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        use_group_name: useGroupName
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        enable_dialable_caller_id: enableDialableCallerID
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        allow_department_clid_name_override: allowDepartmentCLIDNameOverride
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        group_calls_clid_policy: groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_clid_setting", "useGroupCLIDSetting", bool),
        E("use_group_media_setting", "useGroupMediaSetting", bool),
        E("use_group_call_limits_setting", "useGroupCallLimitsSetting", bool),
        E("use_group_translation_routing_setting", "useGroupTranslationRoutingSetting", bool),
        E("use_group_dclid_setting", "useGroupDCLIDSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_group_clid_setting: bool = Field(type=bool, required=False, mutable=False)
    use_group_media_setting: bool = Field(type=bool, required=False, mutable=False)
    use_group_call_limits_setting: bool = Field(type=bool, required=False, mutable=False)
    use_group_translation_routing_setting: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_group_dclid_setting: bool = Field(type=bool, required=False, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )
    clid_policy: str = Field(type=str, required=False, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=False, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=False, mutable=False)
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_department_clid_name_override: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    group_calls_clid_policy: str = Field(type=str, required=False, mutable=False)


class GroupCallRecordingGetRequest(OCIRequest):
    """
    Get the Call Recording platform for a group.

    The response is either a ``GroupCallRecordingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallRecordingModifyRequest(OCIRequest):
    """
    Modify the Call Recording platform assignment for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=False, mutable=False)


class GroupCallingLineIdGetRequest(OCIRequest):
    """
    Get the calling line id settings for a group.

    The response is either a ``GroupCallingLineIdGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallingLineIdModifyRequest(OCIRequest):
    """
    Modify the calling line id settings for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_group_number: useGroupNumber
        use_group_name: useGroupName
        calling_line_id_phone_number: callingLineIdPhoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_group_number", "useGroupNumber", bool),
        E("use_group_name", "useGroupName", bool),
        E("calling_line_id_phone_number", "callingLineIdPhoneNumber", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_group_number: bool = Field(type=bool, required=False, mutable=False)
    use_group_name: bool = Field(type=bool, required=False, mutable=False)
    calling_line_id_phone_number: str = Field(type=str, required=False, mutable=False)


class GroupCallingPlanAddDigitPatternRequest(OCIRequest):
    """
    Add a new calling plan digit string.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        digit_pattern: digitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    digit_pattern: str = Field(type=str, required=True, mutable=False)


class GroupCallingPlanDeleteDigitPatternListRequest(OCIRequest):
    """
    Delete one or more calling plan digit strings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCallingPlanGetDigitPatternListRequest(OCIRequest):
    """
    Get the list of calling plan digit strings for a group.

    The response is either a ``GroupCallingPlanGetDigitPatternListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCallingPlanModifyDigitPatternRequest(OCIRequest):
    """
    Modify a calling plan digit string.

    The name is a key; it cannot be changed.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        digit_pattern: digitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    digit_pattern: str = Field(type=str, required=False, mutable=False)


class GroupCollaborateBridgeDeleteInstanceRequest(OCIRequest):
    """
    Delete a collaborate bridge from a group.

    The request fails when attempting to delete the default collaborate bridge.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCollaborateBridgeGetInstanceListRequest(OCIRequest):
    """
    Get a list of collaborate bridges within a group.

    The response is either ``GroupCollaborateBridgeGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=False, mutable=False)


class GroupCollaborateBridgeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a collaborate bridge.

    The response is either ``GroupCollaborateBridgeGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupCommPilotCallManagerGetRequest(OCIRequest):
    """
    Request the group level data associated with CommPilot Call Manager.

    The response is either a ``GroupCommPilotCallManagerGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCommPilotCallManagerModifyRequest(OCIRequest):
    """
    Modify the group level data associated with CommPilot Call Manager.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_directory: groupDirectory
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_directory", "groupDirectory", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_directory: str = Field(type=str, required=False, mutable=False)


class GroupCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from a group's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        entry_name: entryName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    entry_name: str = Field(type=str, required=True, mutable=False)


class GroupCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in a group's common phone list.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        entry_name: entryName
        new_entry_name: newEntryName
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("entry_name", "entryName", str, is_required=True),
        E("new_entry_name", "newEntryName", str),
        E("phone_number", "phoneNumber", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    entry_name: str = Field(type=str, required=True, mutable=False)
    new_entry_name: str = Field(type=str, required=False, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)


class GroupCommunicationBarringAuthorizationCodeDeleteListRequest(OCIRequest):
    """
    Delete a list of Communication Barring Authorization codes from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        code: code
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringAuthorizationCodeGetListRequest(OCIRequest):
    """
    Get a list of Communication Barring Authorization Codes for a group.

    The response is either a
    ``GroupCommunicationBarringAuthorizationCodeGetListResponse()`` or an
    ``ErorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringGetRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.

    The response is either a ``GroupCommunicationBarringGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCommunicationBarringModifyRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_default_service_provider_profile: useDefaultServiceProviderProfile
        profile: profile
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_default_service_provider_profile", "useDefaultServiceProviderProfile", bool),
        E("profile", "profile", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_default_service_provider_profile: bool = Field(
        type=bool, required=False, mutable=False,
    )
    profile: str = Field(type=str, required=False, mutable=False)


class GroupCommunicationBarringProfileGetAssignedListRequest(OCIRequest):
    """
    Get the list of all communication barring profiles assigned to the group.

    The response is either a ``GroupCommunicationBarringProfileGetAssignedListResponse()``
    or an ``ErrorResponse()``. This command only applies to groups in an Enterprise.  This
    command will fail for groups in a Service Provider.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCustomContactDirectoryAddRequest(OCIRequest):
    """
    Adds a Custom Contact Directory to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replace by:
    ``GroupCustomContactDirectoryAddRequest17()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)


class GroupCustomContactDirectoryDeleteRequest(OCIRequest):
    """
    Deletes a Custom Contact Directory to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCustomContactDirectoryGetListRequest(OCIRequest):
    """
    Gets the list of Custom Contact Directories for a group.

    The response is either ``GroupCustomContactDirectoryGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCustomContactDirectoryGetRequest(OCIRequest):
    """
    Gets a Custom Contact Directory in a group.

    The response is either ``GroupCustomContactDirectoryGetResponse()`` or
    ``ErrorResponse()``. Replace by: ``GroupCustomContactDirectoryGetRequest17()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupCustomRingbackGroupGetRequest(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a ``GroupCustomRingbackGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupCustomRingbackGroupGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCustomRingbackGroupGetRequest16(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a ``GroupCustomRingbackGroupGetResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupCustomRingbackGroupGetRequest20(OCIRequest):
    """
    Get the group's custom ring back service settings.

    The response is either a ``GroupCustomRingbackGroupGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDeleteRequest(OCIRequest):
    """
    Delete a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDepartmentAdminDeleteRequest(OCIRequest):
    """
    Delete a group department administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupDepartmentAdminGetRequest(OCIRequest):
    """
    Get a group department administrators profile.

    The response is either a ``GroupDepartmentAdminGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class GroupDepartmentAdminModifyRequest(OCIRequest):
    """
    Modify a group department administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)


class GroupDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)


class GroupDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of departments that could be the parent department of the specified
    department.

    The department itself and all its descendents are not eligible to be the parent
    department.  If the group belongs to an enterprise, it also returns the departments
    defined in the enterprise it belongs to.

    The response is either ``GroupDepartmentGetAvailableParentListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)


class GroupDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in a group.

    You may request only the list of departments defined at the group-level, or you may
    request the list of all departments in the group including all the departments defined
    within the enterprise the group belongs to.

    The response is either ``GroupDepartmentGetListResponse()`` or ``ErrorResponse()``.
    Replaced by: ``GroupDepartmentGetListRequest18()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        include_enterprise_departments: includeEnterpriseDepartments
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "include_enterprise_departments", "includeEnterpriseDepartments", bool,
            is_required=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    include_enterprise_departments: bool = Field(type=bool, required=True, mutable=False)


class GroupDepartmentGetListRequest18(OCIRequest):
    """
    Request a list of departments in a group.

    You may request only the list of departments defined at the group-level, or you may
    request the list of all departments in the group including all the departments defined
    within the enterprise the group belongs to.

    The response is either ``GroupDepartmentGetListResponse18()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        include_enterprise_departments: includeEnterpriseDepartments
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "include_enterprise_departments", "includeEnterpriseDepartments", bool,
            is_required=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    include_enterprise_departments: bool = Field(type=bool, required=True, mutable=False)


class GroupDepartmentGetRequest(OCIRequest):
    """
    Request the attributes of a department.

    The response is either a ``GroupDepartmentGetResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=True, mutable=False)


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest(OCIRequest):
    """
    Request the number of access device of a particular device type and group.

    If countOnlyResetSupportedDevice is true, count only access devices if the device type
    supports reset.  Devices are counted only if their device type supports Device
    Management.  An error is returned if deviceType is specified but does not support
    device management.

    The response is either
    ``GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        count_only_reset_supported_device: countOnlyResetSupportedDevice
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("count_only_reset_supported_device", "countOnlyResetSupportedDevice", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    count_only_reset_supported_device: bool = Field(type=bool, required=False, mutable=False)


class GroupDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.

    A list of individual events can be canceled.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        event_id: eventId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("event_id", "eventId", int, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    event_id: int = Field(type=int, required=True, mutable=False)


class GroupDeviceTypeCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for an access device type used in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for an access device type used in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        tag_name: tagName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device type basis for a group.

    The response is either ``GroupDeviceTypeCustomTagGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for an access device type used in a
    group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class GroupDeviceTypeFileGetListRequest(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either ``GroupDeviceTypeFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupDeviceTypeFileGetListRequest14sp8()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either ``GroupDeviceTypeFileGetListResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``GroupDeviceTypeFileGetListRequest21()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetListRequest21(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management System,
    on a per-group basis.

    The response is either ``GroupDeviceTypeFileGetListResponse21()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetRequest(OCIRequest):
    """
    Request to get a group device type file.

    The response is either ``GroupDeviceTypeFileGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupDeviceTypeFileGetRequest14sp8()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        file_type: fileType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    file_type: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device type file.

    The response is either ``GroupDeviceTypeFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``GroupDeviceTypeFileGetRequest16sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class GroupDeviceTypeFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device type file.

    The response is either ``GroupDeviceTypeFileGetResponse16sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        device_type: deviceType
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("device_type", "deviceType", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    device_type: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Group level Dial Plan Access Code and its all attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        access_code: accessCode
        include_code_for_network_translations_and_routing:
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services: includeCodeForScreeningServices
        enable_secondary_dial_tone: enableSecondaryDialTone
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)
    include_code_for_network_translations_and_routing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_code_for_screening_services: bool = Field(type=bool, required=True, mutable=False)
    enable_secondary_dial_tone: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Group level Dial Plan Access Code and its all attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        access_code: accessCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a ``GroupDialPlanPolicyGetAccessCodeListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Group level Dial Plan Policy access codes.

    The response is either a ``GroupDialPlanPolicyGetAccessCodeResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        access_code: accessCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a ``GroupDialPlanPolicyGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupDialPlanPolicyGetRequest17()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.

    The response is either a ``GroupDialPlanPolicyGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Group level Dial Plan Access Code and its attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        access_code: accessCode
        include_code_for_network_translations_and_routing:
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services: includeCodeForScreeningServices
        enable_secondary_dial_tone: enableSecondaryDialTone
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool,
        ),
        E("include_code_for_screening_services", "includeCodeForScreeningServices", bool),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)
    include_code_for_network_translations_and_routing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    include_code_for_screening_services: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_secondary_dial_tone: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Group level data associated with Dial Plan Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_setting: useSetting
        requires_access_code_for_public_calls: requiresAccessCodeForPublicCalls
        allow_e164_public_calls: allowE164PublicCalls
        prefer_e164_number_format_for_callback_services:
            preferE164NumberFormatForCallbackServices
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_setting", "useSetting", str),
        E("requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls", bool),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_setting: str = Field(type=str, required=False, mutable=False)
    requires_access_code_for_public_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_e164_public_calls: bool = Field(type=bool, required=False, mutable=False)
    prefer_e164_number_format_for_callback_services: bool = Field(
        type=bool, required=False, mutable=False,
    )
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class GroupDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria.

    Criteria are added at the bottom of the list with the lowest priority.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        description: description
        prefix_digits: prefixDigits
        match_call_type: matchCallType
        match_alternate_call_indicator: matchAlternateCallIndicator
        match_local_category: matchLocalCategory
        match_national_category: matchNationalCategory
        match_interlata_category: matchInterlataCategory
        match_intralata_category: matchIntralataCategory
        match_international_category: matchInternationalCategory
        match_private_category: matchPrivateCategory
        match_emergency_category: matchEmergencyCategory
        match_other_category: matchOtherCategory
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    prefix_digits: str = Field(type=str, required=False, mutable=False)
    match_call_type: "List[str]" = Field(type=list, required=False, mutable=False)
    match_alternate_call_indicator: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    match_local_category: bool = Field(type=bool, required=True, mutable=False)
    match_national_category: bool = Field(type=bool, required=True, mutable=False)
    match_interlata_category: bool = Field(type=bool, required=True, mutable=False)
    match_intralata_category: bool = Field(type=bool, required=True, mutable=False)
    match_international_category: bool = Field(type=bool, required=True, mutable=False)
    match_private_category: bool = Field(type=bool, required=True, mutable=False)
    match_emergency_category: bool = Field(type=bool, required=True, mutable=False)
    match_other_category: bool = Field(type=bool, required=True, mutable=False)


class GroupDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.

    The response is either a ``GroupDialableCallerIDCriteriaGetRequest()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupDialableCallerIDGetRequest(OCIRequest):
    """
    Get the Group’s Dialable Caller ID settings and criteria list.

    The response is either a ``GroupDialableCallerIDGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the group's digit collection attributes.

    The response is either a ``GroupDigitCollectionGetResponse13mp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the group's digit collection attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_setting: useSetting
        access_code: accessCode
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_setting", "useSetting", str),
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_setting: str = Field(type=str, required=False, mutable=False)
    access_code: str = Field(type=str, required=False, mutable=False)
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class GroupDirectoryNumberHuntingGetAvailableUserListRequest(OCIRequest):
    """
    Request to get the agents of a call center or hunt group that are available to be
    assigned to a directory number hunting group.

    They are agents that are not already assigned to any other directory number hunting
    group.

    The response is either ``GroupDirectoryNumberHuntingGetAvailableUserListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetRequest(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.

    It gets the agents of a call center or hunt group that are members of a directory
    number hunting group.  They are agents that are not already assigned to any other
    directory number hunting group.

    The response is either ``GroupDirectoryNumberHuntingGetResponse()`` or
    ``ErrorResponse()``. Replaced by: ``GroupDirectoryNumberHuntingGetRequest17sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupDirectoryNumberHuntingGetRequest17sp1(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.

    It gets the agents of a call center or hunt group that are members of a directory
    number hunting group.  They are agents that are not already assigned to any other
    directory number hunting group.

    The response is either ``GroupDirectoryNumberHuntingGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupDnGetActivationListRequest(OCIRequest):
    """
    Get the list of activated and deactivated DNs in a group.

    Ranges of DNs with identical assignment and activation properties are coalesced to a
    single table row entry.  Only DNs assigned to a users are listed in the response when
    the number activation Mode is set to "User Activation Enabled" Dns assigned to the
    IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetActivationListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDnGetAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for assignment to
    users or service instances within the group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetAvailableListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDnGetAvailableRangesListRequest(OCIRequest):
    """
    Get a list of group DNs that are not assigned to user, service instances or IMRN pool.

    The Dns are returned in a list of DNs or DN ranges and formated in E164 format for
    display.

    The response is either a ``GroupDnGetAvailableRangeListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDnGetDetailedAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for assignment to
    users within the group with the department name, if the DN is assigned to the
    department.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetDetailedAvailableListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDnGetListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetListResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDnGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned DN ranges in a group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either a ``GroupDnGetSummaryListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        domain: domain
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    domain: str = Field(type=str, required=True, mutable=False)


class GroupDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a group.

    The response is either ``GroupDomainGetAssignedListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        domain: domain
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    domain: str = Field(type=str, required=True, mutable=False)


class GroupEmergencyZonesGetHomeZoneListRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.

    The response is either a ``GroupEmergencyZonesGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupEmergencyZonesGetRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.

    The response is either a ``GroupEmergencyZonesGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupEmergencyZonesModifyHomeZoneListRequest(OCIRequest):
    """
    Modify a list of home zones and/or home zone ranges.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        home_zone_ip_address_list: homeZoneIpAddressList
        home_zone_ip_address_range_list: homeZoneIpAddressRangeList
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "home_zone_ip_address_list", "homeZoneIpAddressList", str, is_complex=True,
            is_array=True,
        ),  # unknown
        E(
            "home_zone_ip_address_range_list", "homeZoneIpAddressRangeList", str,
            is_complex=True, is_array=True,
        ),  # unknown
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    home_zone_ip_address_list: "List[str]" = Field(type=list, required=False, mutable=False)
    home_zone_ip_address_range_list: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class GroupEmergencyZonesModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Emergency Zones.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_active: isActive
        emergency_zones_prohibition: emergencyZonesProhibition
        send_emergency_call_notify_email: sendEmergencyCallNotifyEmail
        emergency_call_notify_email_address: emergencyCallNotifyEmailAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("emergency_zones_prohibition", "emergencyZonesProhibition", str),
        E("send_emergency_call_notify_email", "sendEmergencyCallNotifyEmail", bool),
        E("emergency_call_notify_email_address", "emergencyCallNotifyEmailAddress", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    emergency_zones_prohibition: str = Field(type=str, required=False, mutable=False)
    send_emergency_call_notify_email: bool = Field(type=bool, required=False, mutable=False)
    emergency_call_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``GroupEnterpriseTrunkAddRequest21()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)


class GroupEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
        enable_capacity_management: enableCapacityManagement
        max_active_calls: maxActiveCalls
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int, is_required=True),
        E("route_exhaustion_action", "routeExhaustionAction", str, is_required=True),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool, is_required=True),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    maximum_reroute_attempts: int = Field(type=int, required=True, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=True, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)
    enable_capacity_management: bool = Field(type=bool, required=True, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)


class GroupEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.

    If the user is already assigned to another enterprise trunk, it will be unassigned
    from the old enterprise trunk and assigned to the new enterprise trunk specified in
    this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in a group.

    The response is either a ``GroupEnterpriseTrunkGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``GroupEnterpriseTrunkGetResponse()`` or an ``ErrorResponse()``.

    Replaced by: ``GroupEnterpriseTrunkGetRequest21()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk The response is either an
    ``GroupEnterpriseTrunkGetResponse21()`` or an ``ErrorResponse()``.


    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)


class GroupEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        enterprise_trunk_name: enterpriseTrunkName
        new_enterprise_trunk_name: newEnterpriseTrunkName
        maximum_reroute_attempts: maximumRerouteAttempts
        route_exhaustion_action: routeExhaustionAction
        route_exhaustion_forward_address: routeExhaustionForwardAddress
        ordered_routing: orderedRouting
        priority_weighted_routing: priorityWeightedRouting
        enable_capacity_management: enableCapacityManagement
        max_active_calls: maxActiveCalls
        capacity_exceeded_trap_initial_calls: capacityExceededTrapInitialCalls
        capacity_exceeded_trap_offset_calls: capacityExceededTrapOffsetCalls
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("enterprise_trunk_name", "enterpriseTrunkName", str, is_required=True),
        E("new_enterprise_trunk_name", "newEnterpriseTrunkName", str),
        E("maximum_reroute_attempts", "maximumRerouteAttempts", int),
        E("route_exhaustion_action", "routeExhaustionAction", str),
        E("route_exhaustion_forward_address", "routeExhaustionForwardAddress", str),
        E("ordered_routing", "orderedRouting", str, is_complex=True),  # unknown
        E(
            "priority_weighted_routing", "priorityWeightedRouting", str, is_complex=True,
        ),  # unknown
        E("enable_capacity_management", "enableCapacityManagement", bool),
        E("max_active_calls", "maxActiveCalls", int),
        E("capacity_exceeded_trap_initial_calls", "capacityExceededTrapInitialCalls", int),
        E("capacity_exceeded_trap_offset_calls", "capacityExceededTrapOffsetCalls", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    enterprise_trunk_name: str = Field(type=str, required=True, mutable=False)
    new_enterprise_trunk_name: str = Field(type=str, required=False, mutable=False)
    maximum_reroute_attempts: int = Field(type=int, required=False, mutable=False)
    route_exhaustion_action: str = Field(type=str, required=False, mutable=False)
    route_exhaustion_forward_address: str = Field(type=str, required=False, mutable=False)
    ordered_routing: str = Field(type=str, required=False, mutable=False)
    priority_weighted_routing: str = Field(type=str, required=False, mutable=False)
    enable_capacity_management: bool = Field(type=bool, required=False, mutable=False)
    max_active_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_initial_calls: int = Field(type=int, required=False, mutable=False)
    capacity_exceeded_trap_offset_calls: int = Field(type=int, required=False, mutable=False)


class GroupExchangeIntegrationGetRequest(OCIRequest):
    """
    Request the group level configuration for Exchange Integration.

    The response is either a ``GroupExchangeIntegrationGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupExistingUsersAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all existing users within the
    group.

    BroadSoft recommends using this command only for small groups with less than 100
    users.  This command will return an error if the group has over 500 users.  The
    recommended way to bulk assign/unassign services is Service Pack Migration.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupExistingUsersUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all existing users within
    the group.

    BroadSoft recommends using this command only for small groups with less than 100
    users.  This command will return an error if the group has over 500 users.  The
    recommended way to bulk assign/unassign services is Service Pack Migration.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupExtensionLengthGetRequest(OCIRequest):
    """
    Request the group's extension length.

    The response is either a ``GroupExtensionLengthGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupExtensionLengthGetRequest17(OCIRequest):
    """
    Request the group's extension length.

    The response is either a ``GroupExtensionLengthGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupExtensionLengthModifyRequest(OCIRequest):
    """
    Modify the group's extension length.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        extension_length: extensionLength
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("extension_length", "extensionLength", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    extension_length: int = Field(type=int, required=False, mutable=False)


class GroupExtensionLengthModifyRequest17(OCIRequest):
    """
    Modify the group's extension length range.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        min_extension_length: minExtensionLength
        max_extension_length: maxExtensionLength
        default_extension_length: defaultExtensionLength
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("min_extension_length", "minExtensionLength", int),
        E("max_extension_length", "maxExtensionLength", int),
        E("default_extension_length", "defaultExtensionLength", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    min_extension_length: int = Field(type=int, required=False, mutable=False)
    max_extension_length: int = Field(type=int, required=False, mutable=False)
    default_extension_length: int = Field(type=int, required=False, mutable=False)


class GroupFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetListResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupFeatureAccessCodeGetRequest()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupFeatureAccessCodeGetRequest(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetResponse()`` or an
    ``ErrorResponse()``. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupFeatureAccessCodeGetRequest20(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetResponse20()`` or an
    ``ErrorResponse()``. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  In release 20 the "Call
    Recording" FAC name is changed to "Call Recording - Start". Replaced by:
    ``GroupFeatureAccessCodeGetRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupFeatureAccessCodeGetRequest21(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.

    The response is either a ``GroupFeatureAccessCodeGetResponse20()`` or an
    ``ErrorResponse()``. Returned Feature Access Codes may be group specific, or Service
    Provider Feature Access Codes, depending on FAC code level.  In release 20 the "Call
    Recording" FAC name is changed to "Call Recording - Start".

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new group file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        file_repository_name: fileRepositoryName
        user_name: userName
        password: password
        allow_put: allowPut
        allow_delete: allowDelete
        allow_get: allowGet
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
        E("allow_put", "allowPut", bool, is_required=True),
        E("allow_delete", "allowDelete", bool, is_required=True),
        E("allow_get", "allowGet", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)
    allow_put: bool = Field(type=bool, required=True, mutable=False)
    allow_delete: bool = Field(type=bool, required=True, mutable=False)
    allow_get: bool = Field(type=bool, required=True, mutable=False)


class GroupFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a group file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        file_repository_name: fileRepositoryName
        user_name: userName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    user_name: str = Field(type=str, required=True, mutable=False)


class GroupFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of group users for a file repository in the system.

    The response is either a ``GroupFileRepositoryDeviceUserGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        file_repository_name: fileRepositoryName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)


class GroupFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a group file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        file_repository_name: fileRepositoryName
        user_name: userName
        password: password
        allow_put: allowPut
        allow_delete: allowDelete
        allow_get: allowGet
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str),
        E("allow_put", "allowPut", bool),
        E("allow_delete", "allowDelete", bool),
        E("allow_get", "allowGet", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    allow_put: bool = Field(type=bool, required=False, mutable=False)
    allow_delete: bool = Field(type=bool, required=False, mutable=False)
    allow_get: bool = Field(type=bool, required=False, mutable=False)


class GroupFindMeFollowMeAddAlertingGroupRequest(OCIRequest):
    """
    Add an alerting group to a Find-me/Follow-me instance.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
        alerting_group_description: alertingGroupDescription
        use_diversion_inhibitor: useDiversionInhibitor
        answer_confirmation_required: answerConfirmationRequired
        number_of_rings: numberOfRings
        phone_number: phoneNumber
        user_id: userId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("alerting_group_description", "alertingGroupDescription", str),
        E("use_diversion_inhibitor", "useDiversionInhibitor", bool, is_required=True),
        E(
            "answer_confirmation_required", "answerConfirmationRequired", bool,
            is_required=True,
        ),
        E("number_of_rings", "numberOfRings", int, is_required=True),
        E("phone_number", "phoneNumber", str),
        E("user_id", "userId", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=True, mutable=False)
    alerting_group_description: str = Field(type=str, required=False, mutable=False)
    use_diversion_inhibitor: bool = Field(type=bool, required=True, mutable=False)
    answer_confirmation_required: bool = Field(type=bool, required=True, mutable=False)
    number_of_rings: int = Field(type=int, required=True, mutable=False)
    phone_number: str = Field(type=str, required=False, mutable=False)
    user_id: str = Field(type=str, required=False, mutable=False)


class GroupFindMeFollowMeDeleteAlertingGroupRequest(OCIRequest):
    """
    Delete an alerting group from a Find-me/Follow-me instance.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeDeleteAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Delete a criteria from the Find-me/Follow-me alerting group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeDeleteInstanceRequest(OCIRequest):
    """
    Delete a Find-me/Follow-me instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me alerting groups within a group.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me alerting group.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse()`` or
    ``ErrorResponse()``. Replaced by:
    ``GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21()``

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.

    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse21()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetInstanceListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me instances within a group.

    The response is either ``GroupFindMeFollowMeGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupFindMeFollowMeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.

    The response is either ``GroupFindMeFollowMeGetInstanceResponse()`` or
    ``ErrorResponse()``. Replaced by: ``GroupFindMeFollowMeGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.

    The response is either ``GroupFindMeFollowMeGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFindMeFollowMeModifyAlertingGroupListRequest(OCIRequest):
    """
    Modify the priorities assigned to alerting groups The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.

    NOTE: The command fails if all the alerting groups defined for the user are not
    provided.

    Attributes:
        service_user_id: serviceUserId
        alerting_group_name: alertingGroupName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("alerting_group_name", "alertingGroupName", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    alerting_group_name: str = Field(type=str, required=False, mutable=False)


class GroupFlexibleSeatingAccessDeviceGetListRequest(OCIRequest):
    """
    Requests the list of access devices available for assignment to a flexible seating
    host or guest.

    The list includes devices created at the system, service provider, and group levels
    that support device management.

    The response is either ``GroupFlexibleSeatingAccessDeviceGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostDeleteInstanceRequest(OCIRequest):
    """
    Delete a flexible seating host instance from a group.

    Host cannot be deleted when a guest is associated to a host.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a flexible seating host instance.

    The response is either ``GroupFlexibleSeatingHostGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostGuestAssociationGetRequest(OCIRequest):
    """
    Request the flexible seating host guest association details.

    The response is either a ``GroupFlexibleSeatingHostGuestAssociationGetResponse()`` or
    an ``ErrorResponse()``. accessLevel is always set to Group for a Service Provider

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostGuestAssociationModifyRequest(OCIRequest):
    """
    Modify the flexible seating host’s guest association attributes.

    The request fails if enforceAssociationLimit or associationLimitHours are changed when
    the host is associated to a guest.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        enforce_association_limit: enforceAssociationLimit
        association_limit_hours: associationLimitHours
        access_level: accessLevel
        remove_guest_association: removeGuestAssociation
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enforce_association_limit", "enforceAssociationLimit", bool),
        E("association_limit_hours", "associationLimitHours", int),
        E("access_level", "accessLevel", str),
        E("remove_guest_association", "removeGuestAssociation", bool),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    enforce_association_limit: bool = Field(type=bool, required=False, mutable=False)
    association_limit_hours: int = Field(type=int, required=False, mutable=False)
    access_level: str = Field(type=str, required=False, mutable=False)
    remove_guest_association: bool = Field(type=bool, required=False, mutable=False)


class GroupFlexibleSeatingHostRoutingPoliciesGetRequest(OCIRequest):
    """
    Get a flexible seating host’s routing policies The response is either a
    ``GroupFlexibleSeatingHostRoutingPoliciesGetResponse()`` or an ``ErrorResponse()``.


    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupFlexibleSeatingHostRoutingPoliciesModifyRequest(OCIRequest):
    """
    Modify a flexible seating host’s routing policies The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.


    Attributes:
        service_user_id: serviceUserId
        allow_emergency_calls: allowEmergencyCalls
        allow_calls_to_voice_portal: allowCallsToVoicePortal
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("allow_emergency_calls", "allowEmergencyCalls", bool),
        E("allow_calls_to_voice_portal", "allowCallsToVoicePortal", bool),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    allow_emergency_calls: bool = Field(type=bool, required=False, mutable=False)
    allow_calls_to_voice_portal: bool = Field(type=bool, required=False, mutable=False)


class GroupGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a group.

    The response is either a ``GroupGetDefaultResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class GroupGetRequest(OCIRequest):
    """
    Get the profile for a group.

    The response is either a ``GroupGetResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``GroupGetRequest14sp7()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupGetRequest14sp7(OCIRequest):
    """
    Get the profile for a group.

    The response is either a ``GroupGetResponse14sp7()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupGetUserServiceAssignedUserListRequest(OCIRequest):
    """
    Get the list of users assigned the user service or service pack.

    The response is either a ``GroupGetUserServiceAssignedUserListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str),
        E("service_pack_name", "servicePackName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: str = Field(type=str, required=False, mutable=False)
    service_pack_name: str = Field(type=str, required=False, mutable=False)


class GroupGroupNightForwardingGetRequest(OCIRequest):
    """
    Request to get the Group Night Forwarding group parameters.

    The response is either ``GroupGroupNightForwardingGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingAddOriginatorListRequest(OCIRequest):
    """
    Add originator(s) to a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        originator_user_id: originatorUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("originator_user_id", "originatorUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    originator_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingAddTargetListRequest(OCIRequest):
    """
    Add target(s) to a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        target_user_id: targetUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("target_user_id", "targetUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    target_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Group Paging instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingDeleteOriginatorListRequest(OCIRequest):
    """
    Delete originator(s) from a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        originator_user_id: originatorUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("originator_user_id", "originatorUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    originator_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingDeleteTargetListRequest(OCIRequest):
    """
    Delete target(s) from a paging group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        target_user_id: targetUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("target_user_id", "targetUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    target_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Paging Groups instances within a group.

    The response is either ``GroupGroupPagingGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupGroupPagingGetInstanceRequest(OCIRequest):
    """
    Replaced By ``GroupGroupPagingGetInstanceRequest17sp3()`` Request to get all the
    information of a Group Paging instance.

    The response is either ``GroupGroupPagingGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.

    The response is either ``GroupGroupPagingGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``. Replaced by: ``GroupGroupPagingGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.

    The response is either ``GroupGroupPagingGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetOriginatorListRequest(OCIRequest):
    """
    Get a list of originators assigned to a paging group.

    The response is either a ``GroupGroupPagingGetOriginatorListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingGetTargetListRequest(OCIRequest):
    """
    Get a list of targets assigned to a paging group.

    The response is either a ``GroupGroupPagingGetTargetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a group.

    The response is either a ``GroupGroupPagingTargetsCapacityGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        maximum_target_users: maximumTargetUsers
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("maximum_target_users", "maximumTargetUsers", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    maximum_target_users: int = Field(type=int, required=False, mutable=False)


class GroupHolidayScheduleDeleteRequest(OCIRequest):
    """
    Delete a holiday schedule from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        holiday_schedule_name: holidayScheduleName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("holiday_schedule_name", "holidayScheduleName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    holiday_schedule_name: str = Field(type=str, required=True, mutable=False)


class GroupHolidayScheduleGetListRequest(OCIRequest):
    """
    Get a holiday schedule in a group.

    The response is either a ``GroupHolidayScheduleGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupHolidayScheduleGetRequest(OCIRequest):
    """
    Get a holiday schedule in a group.

    The response is either a ``GroupHolidayScheduleGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        holiday_schedule_name: holidayScheduleName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("holiday_schedule_name", "holidayScheduleName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    holiday_schedule_name: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Hunt Group instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceListRequest(OCIRequest):
    """
    Get a list of Hunt Group instances within a group.

    The response is either ``GroupHuntGroupGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupHuntGroupGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse14()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse17()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse17sp4()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupHuntGroupGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``. Replaced by: ``GroupHuntGroupGetInstanceRequest20()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupHuntGroupGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.

    The response is either ``GroupHuntGroupGetInstanceResponse20()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupIMRNGetListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a group IMRN pool.

    The response is either ``GroupIMRNGetListResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupIncomingCallingPlanGetListRequest(OCIRequest):
    """
    Request the group's incoming calling plan settings.

    The response is either a ``GroupIncomingCallingPlanGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallDeleteInstanceRequest(OCIRequest):
    """
    Request to delete an Instant Group Call service instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Instant Group Call service instances within a group.

    The response is either ``GroupInstantGroupCallGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the service instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupInstantGroupCallGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either ``GroupInstantGroupCallGetInstanceResponse14()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either ``GroupInstantGroupCallGetInstanceResponse17()`` or
    ``ErrorResponse()``. Replaced by: ``GroupInstantGroupCallGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupInstantGroupCallGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.

    The response is either ``GroupInstantGroupCallGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.

    The response is either ``GroupIntegratedIMPGetResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_service_provider_setting: useServiceProviderSetting
        service_domain: serviceDomain
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_service_provider_setting", "useServiceProviderSetting", bool),
        E("service_domain", "serviceDomain", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_service_provider_setting: bool = Field(type=bool, required=False, mutable=False)
    service_domain: str = Field(type=str, required=False, mutable=False)


class GroupInterceptGroupGetRequest(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a ``GroupInterceptGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupInterceptGroupGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupInterceptGroupGetRequest16(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a ``GroupInterceptGroupGetResponse16()`` or an
    ``ErrorResponse()``.

    Replaced By: ``GroupInterceptGroupGetRequest16sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupInterceptGroupGetRequest16sp1(OCIRequest):
    """
    Get the group's intercept group service settings.

    The response is either a ``GroupInterceptGroupGetResponse16sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupInventoryReportGetRequest(OCIRequest):
    """
    Request the group's inventory report.

    The response is either a ``GroupInventoryReportGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        include_users: includeUsers
        include_services: includeServices
        include_dns: includeDns
        include_access_devices: includeAccessDevices
        include_departments: includeDepartments
        report_delivery_email_address: reportDeliveryEmailAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("include_users", "includeUsers", bool, is_required=True),
        E("include_services", "includeServices", bool, is_required=True),
        E("include_dns", "includeDns", bool, is_required=True),
        E("include_access_devices", "includeAccessDevices", bool, is_required=True),
        E("include_departments", "includeDepartments", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    include_users: bool = Field(type=bool, required=True, mutable=False)
    include_services: bool = Field(type=bool, required=True, mutable=False)
    include_dns: bool = Field(type=bool, required=True, mutable=False)
    include_access_devices: bool = Field(type=bool, required=True, mutable=False)
    include_departments: bool = Field(type=bool, required=True, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)


class GroupLDAPIntegrationGetDirectoryRequest(OCIRequest):
    """
    Get the LDAP directory attributes for a group.

    The response is either a ``GroupLDAPIntegrationGetDirectoryResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupLDAPIntegrationGetRequest(OCIRequest):
    """
    Request the group level data associated with LDAP Integration.

    The response is either a ``GroupLDAPIntegrationGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupLDAPIntegrationModifyDirectoryRequest(OCIRequest):
    """
    Modify the LDAP directory attributes for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_level: useLevel
        server_net_address: serverNetAddress
        server_port: serverPort
        search_base: searchBase
        use_ssl: useSSL
        require_authentication: requireAuthentication
        authenticated_dn: authenticatedDN
        authenticated_password: authenticatedPassword
        is_sort_enabled: isSortEnabled
        is_paged_result_enabled: isPagedResultEnabled
        search_filter: searchFilter
        include_search_attribute_in_search_filter: includeSearchAttributeInSearchFilter
        column1_attribute_name: column1AttributeName
        column2_attribute_name: column2AttributeName
        column3_attribute_name: column3AttributeName
        column4_attribute_name: column4AttributeName
        column1_label: column1Label
        column2_label: column2Label
        column3_label: column3Label
        column4_label: column4Label
        search_column: searchColumn
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_level", "useLevel", str),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool),
        E("require_authentication", "requireAuthentication", bool),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool,
        ),
        E("column1_attribute_name", "column1AttributeName", str),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_level: str = Field(type=str, required=False, mutable=False)
    server_net_address: str = Field(type=str, required=False, mutable=False)
    server_port: int = Field(type=int, required=False, mutable=False)
    search_base: str = Field(type=str, required=False, mutable=False)
    use_ssl: bool = Field(type=bool, required=False, mutable=False)
    require_authentication: bool = Field(type=bool, required=False, mutable=False)
    authenticated_dn: str = Field(type=str, required=False, mutable=False)
    authenticated_password: str = Field(type=str, required=False, mutable=False)
    is_sort_enabled: bool = Field(type=bool, required=False, mutable=False)
    is_paged_result_enabled: bool = Field(type=bool, required=False, mutable=False)
    search_filter: str = Field(type=str, required=False, mutable=False)
    include_search_attribute_in_search_filter: bool = Field(
        type=bool, required=False, mutable=False,
    )
    column1_attribute_name: str = Field(type=str, required=False, mutable=False)
    column2_attribute_name: str = Field(type=str, required=False, mutable=False)
    column3_attribute_name: str = Field(type=str, required=False, mutable=False)
    column4_attribute_name: str = Field(type=str, required=False, mutable=False)
    column1_label: str = Field(type=str, required=False, mutable=False)
    column2_label: str = Field(type=str, required=False, mutable=False)
    column3_label: str = Field(type=str, required=False, mutable=False)
    column4_label: str = Field(type=str, required=False, mutable=False)
    search_column: int = Field(type=int, required=False, mutable=False)


class GroupLDAPIntegrationModifyRequest(OCIRequest):
    """
    Modify the group level data associated with LDAP Integration.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_active: isActive
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)


class GroupMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        language: language
        type: type
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    type: str = Field(type=str, required=True, mutable=False)


class GroupMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a
    ``GroupMWIDeliveryToMobileEndpointCustomTemplateGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        language: language
        type: type
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    type: str = Field(type=str, required=True, mutable=False)


class GroupMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Requests group MWI custom notifications settings.

    The response is either a ``GroupMWIDeliveryToMobileEndpointGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Meet-Me Conferencing bridge from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Meet-Me Conferencing instances within a group.

    The response is either ``GroupMeetMeConferencingGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        department_name: departmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("department_name", "departmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    department_name: str = Field(type=str, required=False, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse17sp4()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest18(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse18()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse19()`` or
    ``ErrorResponse()``. Replaced by: ``GroupMeetMeConferencingGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.

    The response is either ``GroupMeetMeConferencingGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the group level data associated with Meet-Me Conferencing functions.

    The response is either a ``GroupMeetMeConferencingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupMusicOnHoldGetDepartmentListRequest(OCIRequest):
    """
    Returns a list of all departments that have a Music On Hold instance.

    The response is either ``GroupMusicOnHoldGetDepartmentListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a group.

    The Element defaultNetworkClassOfService is required only for the first assignment,
    for subsequent assignments it is optional.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        network_class_of_service: networkClassOfService
        default_network_class_of_service: defaultNetworkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: "List[str]" = Field(type=list, required=False, mutable=False)
    default_network_class_of_service: str = Field(type=str, required=False, mutable=False)


class GroupNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a group.

    The Network Classes of Service must be currently assigned to the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        network_class_of_service: networkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: str = Field(type=str, required=True, mutable=False)


class GroupNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a group.

    The response is either a ``GroupNetworkClassOfServiceGetAssignedListResponse()`` or an
    ``ErorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        network_class_of_service: networkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: str = Field(type=str, required=True, mutable=False)


class GroupNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        network_class_of_service: networkClassOfService
        default_network_class_of_service: defaultNetworkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: "List[str]" = Field(type=list, required=False, mutable=False)
    default_network_class_of_service: str = Field(type=str, required=False, mutable=False)


class GroupNewUserTemplateAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all new users created within
    the group after the completion of this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupNewUserTemplateUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all new users created
    within the group after the completion of this request.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_array=True),
        E("service_pack_name", "servicePackName", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: "List[str]" = Field(type=list, required=False, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupOfficeZoneAssignListRequest(OCIRequest):
    """
    Assign a list of Office Zones to a group.

    The Element defaultOfficeZone is required only for the first assignment, for
    subsequent assignments it is optional.  Office Zones can only be assigned if the
    Location-Based Calling Restrictions has been authorized to the group otherwise the
    request will fail.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        office_zone_name: officeZoneName
        default_office_zone_name: defaultOfficeZoneName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    office_zone_name: "List[str]" = Field(type=list, required=False, mutable=False)
    default_office_zone_name: str = Field(type=str, required=False, mutable=False)


class GroupOfficeZoneGetAssignedListRequest(OCIRequest):
    """
    Get a list of Office Zones assigned to a group.

    The response is either a ``GroupOfficeZoneGetAssignedListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOfficeZoneUnassignListRequest(OCIRequest):
    """
    Unassign a list of OfficeZones from a group.

    Note: a new default must be provided if unassigning the current default.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        office_zone_name: officeZoneName
        default_office_zone_name: defaultOfficeZoneName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    office_zone_name: "List[str]" = Field(type=list, required=False, mutable=False)
    default_office_zone_name: str = Field(type=str, required=False, mutable=False)


class GroupOutgoingCallingPlanAuthorizationCodeGetListRequest(OCIRequest):
    """
    Request the list of authorization codes for a group default and it's departments.

    The response is either a
    ``GroupOutgoingCallingPlanAuthorizationCodeGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for a group default and it's departments.

    The response is either a ``GroupOutgoingCallingPlanCallMeNowGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for digit patterns for a group default and
    it's departments.

    The response is either a
    ``GroupOutgoingCallingPlanDigitPlanCallMeNowGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for digit patterns for a group default and it's
    departments.

    The response is either a
    ``GroupOutgoingCallingPlanDigitPlanOriginatingGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for digit patterns for a group default and it's
    departments.

    The response is either a
    ``GroupOutgoingCallingPlanDigitPlanRedirectingGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for a group default and it's departments.

    The response is either a ``GroupOutgoingCallingPlanOriginatingGetListResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternAddRequest(OCIRequest):
    """
    Add a new calling plan Pinhole digit string.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        digit_pattern: digitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    digit_pattern: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternDeleteListRequest(OCIRequest):
    """
    Delete one or more calling plan Pinhole digit strings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest(OCIRequest):
    """
    Get the list of calling plan Pinhole digit strings for a group.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPatternModifyRequest(OCIRequest):
    """
    Modify a calling plan Pinhole digit string.

    The name is a key; it cannot be changed.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        digit_pattern: digitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("digit_pattern", "digitPattern", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    digit_pattern: str = Field(type=str, required=False, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for Pinhole digit patterns for a group default and
    its departments.

    The response is either a
    ``GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanRedirectedGetListRequest(OCIRequest):
    """
    Request the call forwarded/transferred permissions for a group default and it's
    departments.

    The response is either a ``GroupOutgoingCallingPlanRedirectedGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the initiating call forwards/transfer permissions for a group default and it's
    departments.

    The response is either a ``GroupOutgoingCallingPlanRedirectingGetListResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupOutgoingCallingPlanTransferNumbersGetListRequest(OCIRequest):
    """
    Request the list of transfer numbers for a group default and it's departments.

    The response is either a ``GroupOutgoingCallingPlanTransferNumbersGetListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPasswordRulesGetRequest(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either ``GroupPasswordRulesGetResponse()`` or ``ErrorResponse()``.
    Repleced by: ``GroupPasswordRulesGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPasswordRulesGetRequest16(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to users within the
    group.

    The response is either ``GroupPasswordRulesGetResponse16()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's password rules setting that apply to the users within
    the group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_previous_passwords: disallowPreviousPasswords
        number_of_previous_passwords: numberOfPreviousPasswords
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("disallow_user_id", "disallowUserId", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("password_expires_days", "passwordExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    disallow_user_id: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=False, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=False, mutable=False)
    min_digits: int = Field(type=int, required=False, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=False, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=False, mutable=False)
    min_length: int = Field(type=int, required=False, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    password_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_previous_passwords: bool = Field(type=bool, required=False, mutable=False)
    number_of_previous_passwords: int = Field(type=int, required=False, mutable=False)


class GroupPolicyGetRequest(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest14sp1(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse14sp1()`` or ``ErrorResponse()``.

    Replaced By : ``GroupPolicyGetRequest14sp4()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest14sp4(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse14sp4()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest17(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse17()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPolicyGetRequest20(OCIRequest):
    """
    Requests the Group's policy settings.

    The response is either ``GroupPolicyGetResponse20()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPolicyModifyRequest(OCIRequest):
    """
    Request to modify the policies for a Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        calling_plan_access: callingPlanAccess
        extension_access: extensionAccess
        ldap_integration_access: ldapIntegrationAccess
        voice_messaging_access: voiceMessagingAccess
        department_admin_user_access: departmentAdminUserAccess
        department_admin_trunk_group_access: departmentAdminTrunkGroupAccess
        department_admin_phone_number_extension_access:
            departmentAdminPhoneNumberExtensionAccess
        department_admin_calling_line_id_number_access:
            departmentAdminCallingLineIdNumberAccess
        user_authentication_access: userAuthenticationAccess
        user_group_directory_access: userGroupDirectoryAccess
        user_profile_access: userProfileAccess
        user_enhanced_call_log_access: userEnhancedCallLogAccess
        user_auto_attendant_name_dialing_access: userAutoAttendantNameDialingAccess
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("calling_plan_access", "callingPlanAccess", str),
        E("extension_access", "extensionAccess", str),
        E("ldap_integration_access", "ldapIntegrationAccess", str),
        E("voice_messaging_access", "voiceMessagingAccess", str),
        E("department_admin_user_access", "departmentAdminUserAccess", str),
        E("department_admin_trunk_group_access", "departmentAdminTrunkGroupAccess", str),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess", str,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess", str,
        ),
        E("user_authentication_access", "userAuthenticationAccess", str),
        E("user_group_directory_access", "userGroupDirectoryAccess", str),
        E("user_profile_access", "userProfileAccess", str),
        E("user_enhanced_call_log_access", "userEnhancedCallLogAccess", str),
        E(
            "user_auto_attendant_name_dialing_access",
            "userAutoAttendantNameDialingAccess", str,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    calling_plan_access: str = Field(type=str, required=False, mutable=False)
    extension_access: str = Field(type=str, required=False, mutable=False)
    ldap_integration_access: str = Field(type=str, required=False, mutable=False)
    voice_messaging_access: str = Field(type=str, required=False, mutable=False)
    department_admin_user_access: str = Field(type=str, required=False, mutable=False)
    department_admin_trunk_group_access: str = Field(type=str, required=False, mutable=False)
    department_admin_phone_number_extension_access: str = Field(
        type=str, required=False, mutable=False,
    )
    department_admin_calling_line_id_number_access: str = Field(
        type=str, required=False, mutable=False,
    )
    user_authentication_access: str = Field(type=str, required=False, mutable=False)
    user_group_directory_access: str = Field(type=str, required=False, mutable=False)
    user_profile_access: str = Field(type=str, required=False, mutable=False)
    user_enhanced_call_log_access: str = Field(type=str, required=False, mutable=False)
    user_auto_attendant_name_dialing_access: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupPolycomPhoneServicesGetRequest(OCIRequest):
    """
    Request the group's Polycom Phone Services attributes.

    The response is either a ``GroupPolycomPhoneServicesGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPolycomPhoneServicesModifyRequest(OCIRequest):
    """
    Modify the group's Polycom Phone Services attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        include_group_common_phone_list_in_directory:
            includeGroupCommonPhoneListInDirectory
        include_group_custom_contact_directory_in_directory:
            includeGroupCustomContactDirectoryInDirectory
        group_custom_contact_directory: groupCustomContactDirectory
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E(
            "include_group_common_phone_list_in_directory",
            "includeGroupCommonPhoneListInDirectory", bool,
        ),
        E(
            "include_group_custom_contact_directory_in_directory",
            "includeGroupCustomContactDirectoryInDirectory", bool,
        ),
        E("group_custom_contact_directory", "groupCustomContactDirectory", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    include_group_common_phone_list_in_directory: bool = Field(
        type=bool, required=False, mutable=False,
    )
    include_group_custom_contact_directory_in_directory: bool = Field(
        type=bool, required=False, mutable=False,
    )
    group_custom_contact_directory: str = Field(type=str, required=False, mutable=False)


class GroupPortalPasscodeRulesGetRequest(OCIRequest):
    """
    Requests the group's passcode rules setting.

    The response is either ``GroupPortalPasscodeRulesGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPortalPasscodeRulesGetRequest19(OCIRequest):
    """
    Requests the group's passcode rules setting.

    The response is either ``GroupPortalPasscodeRulesGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPortalPasscodeRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: numberOfRepeatedDigits
    disallowRepeatedPatterns disallowContiguousSequences numberOfAscendingDigits
    numberOfDescendingDigits numberOfPreviousPasscodes

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_rule_level: useRuleLevel
        disallow_repeated_digits: disallowRepeatedDigits
        number_of_repeated_digits: numberOfRepeatedDigits
        disallow_repeated_patterns: disallowRepeatedPatterns
        disallow_contiguous_sequences: disallowContiguousSequences
        number_of_ascending_digits: numberOfAscendingDigits
        number_of_descending_digits: numberOfDescendingDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        number_of_previous_passcodes: numberOfPreviousPasscodes
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_rule_level", "useRuleLevel", str),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool),
        E("disallow_contiguous_sequences", "disallowContiguousSequences", bool),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int),
        E("number_of_descending_digits", "numberOfDescendingDigits", int),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_rule_level: str = Field(type=str, required=False, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=False, mutable=False)
    number_of_repeated_digits: int = Field(type=int, required=False, mutable=False)
    disallow_repeated_patterns: bool = Field(type=bool, required=False, mutable=False)
    disallow_contiguous_sequences: bool = Field(type=bool, required=False, mutable=False)
    number_of_ascending_digits: int = Field(type=int, required=False, mutable=False)
    number_of_descending_digits: int = Field(type=int, required=False, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    number_of_previous_passcodes: int = Field(type=int, required=False, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    min_code_length: int = Field(type=int, required=False, mutable=False)
    max_code_length: int = Field(type=int, required=False, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=False, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupPreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the group�s PreAlertingservice settings.

    The response is either a ``GroupPreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPreAlertingAnnouncementGetRequest20(OCIRequest):
    """
    Get the group’s PreAlertingservice settings.

    The response is either a ``GroupPreAlertingAnnouncementGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupPreferredCarrierGroupGetRequest(OCIRequest):
    """
    Requests the currently configured carriers for a group.

    The response is either a ``GroupPreferredCarrierGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeAssignListRequest(OCIRequest):
    """
    Assign a list of service provider number ranges to a group.

    The number ranges must have previously been added to the service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        number_range_start: numberRangeStart
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    number_range_start: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to a group and still available for
    assignment to users within the group.

    The response is either
    ``GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned enterprise trunknumber ranges in a group.

    The response is either
    ``GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupRouteListEnterpriseTrunkNumberRangeUnassignListRequest(OCIRequest):
    """
    Unassign a list of service provider number ranges from a group.

    The number ranges then become available for assignment to other groups.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        number_range_start: numberRangeStart
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    number_range_start: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupRoutePointBouncedCallGetRequest(OCIRequest):
    """
    Get a route point's bounced call settings.

    The response is either a ``GroupRoutePointBouncedCallGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointBouncedCallModifyRequest(OCIRequest):
    """
    Modify a route point's bounced call settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        is_active: isActive
        number_of_rings_before_bouncing_call: numberOfRingsBeforeBouncingCall
        enable_transfer: enableTransfer
        transfer_phone_number: transferPhoneNumber
        bounce_call_when_agent_unavailable: bounceCallWhenAgentUnavailable
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("number_of_rings_before_bouncing_call", "numberOfRingsBeforeBouncingCall", int),
        E("enable_transfer", "enableTransfer", bool),
        E("transfer_phone_number", "transferPhoneNumber", str),
        E("bounce_call_when_agent_unavailable", "bounceCallWhenAgentUnavailable", bool),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    number_of_rings_before_bouncing_call: int = Field(type=int, required=False, mutable=False)
    enable_transfer: bool = Field(type=bool, required=False, mutable=False)
    transfer_phone_number: str = Field(type=str, required=False, mutable=False)
    bounce_call_when_agent_unavailable: bool = Field(type=bool, required=False, mutable=False)


class GroupRoutePointDeleteInstanceRequest(OCIRequest):
    """
    Delete a Route Point instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for route point.

    The response is either a ``GroupRoutePointDistinctiveRingingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for route point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        enable_distinctive_ringing: enableDistinctiveRinging
        distinctive_ringing_ring_pattern: distinctiveRingingRingPattern
        distinctive_ringing_force_delivery_ring_pattern:
            distinctiveRingingForceDeliveryRingPattern
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_distinctive_ringing", "enableDistinctiveRinging", bool),
        E("distinctive_ringing_ring_pattern", "distinctiveRingingRingPattern", str),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern", str,
        ),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    enable_distinctive_ringing: bool = Field(type=bool, required=False, mutable=False)
    distinctive_ringing_ring_pattern: str = Field(type=str, required=False, mutable=False)
    distinctive_ringing_force_delivery_ring_pattern: str = Field(
        type=str, required=False, mutable=False,
    )


class GroupRoutePointExternalSystemAssignListRequest(OCIRequest):
    """
    Assign a list of route point external systems to a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        route_point_external_system: routePointExternalSystem
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    route_point_external_system: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupRoutePointExternalSystemGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all Route Point External Systems assigned to a group.

    The response is either ``GroupRoutePointExternalSystemGetAssignedListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointExternalSystemUnassignListRequest(OCIRequest):
    """
    Unassign a list of route point external systems from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        route_point_external_system: routePointExternalSystem
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    route_point_external_system: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupRoutePointForcedForwardingGetRequest(OCIRequest):
    """
    Get a route point's forced forwarding settings.

    The response is either a ``GroupRoutePointForcedForwardingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointForcedForwardingGetRequest20(OCIRequest):
    """
    Get a route point's forced forwarding settings.

    The response is either a ``GroupRoutePointForcedForwardingGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetAnnouncementRequest(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a ``GroupRoutePointGetAnnouncementResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``GroupRoutePointGetAnnouncementRequest19()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetAnnouncementRequest19(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a ``GroupRoutePointGetAnnouncementResponse19()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetAnnouncementRequest20(OCIRequest):
    """
    Get a route point's announcement settings.

    The response is either a ``GroupRoutePointGetAnnouncementResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Route Point.

    The response is either ``GroupRoutePointGetDNISListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetFailoverPolicyRequest(OCIRequest):
    """
    Get the route point failover policy.

    The response is either a ``GroupRoutePointGetFailoverPolicyResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either ``GroupRoutePointGetInstanceResponse()`` or
    ``ErrorResponse()``. Replaced by: ``GroupRoutePointGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Route Point instance.

    The response is either ``GroupRoutePointGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointHolidayServiceGetRequest(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a ``GroupRoutePointHolidayServiceGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a ``GroupRoutePointHolidayServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointHolidayServiceGetRequest20(OCIRequest):
    """
    Get a route point's holiday service settings.

    The response is either a ``GroupRoutePointHolidayServiceGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointManualFailoverRequest(OCIRequest):
    """
    Initiate manual failover for the Route Point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Route Point.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        display_dnis_number: displayDNISNumber
        display_dnis_name: displayDNISName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("display_dnis_number", "displayDNISNumber", bool),
        E("display_dnis_name", "displayDNISName", bool),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    display_dnis_number: bool = Field(type=bool, required=False, mutable=False)
    display_dnis_name: bool = Field(type=bool, required=False, mutable=False)


class GroupRoutePointModifyFailoverPolicyRequest(OCIRequest):
    """
    Modify the route point failover policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        enable_failover_support: enableFailoverSupport
        external_system: externalSystem
        failover_phone_number: failoverPhoneNumber
        per_call_enable_failover_support: perCallEnableFailoverSupport
        per_call_call_failure_timeout_seconds: perCallCallFailureTimeoutSeconds
        per_call_outbound_call_failure_timeout_seconds:
            perCallOutboundCallFailureTimeoutSeconds
        per_call_failover_phone_number: perCallFailoverPhoneNumber
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_failover_support", "enableFailoverSupport", bool),
        E("external_system", "externalSystem", str),
        E("failover_phone_number", "failoverPhoneNumber", str),
        E("per_call_enable_failover_support", "perCallEnableFailoverSupport", bool),
        E("per_call_call_failure_timeout_seconds", "perCallCallFailureTimeoutSeconds", int),
        E(
            "per_call_outbound_call_failure_timeout_seconds",
            "perCallOutboundCallFailureTimeoutSeconds", int,
        ),
        E("per_call_failover_phone_number", "perCallFailoverPhoneNumber", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    enable_failover_support: bool = Field(type=bool, required=False, mutable=False)
    external_system: str = Field(type=str, required=False, mutable=False)
    failover_phone_number: str = Field(type=str, required=False, mutable=False)
    per_call_enable_failover_support: bool = Field(type=bool, required=False, mutable=False)
    per_call_call_failure_timeout_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    per_call_outbound_call_failure_timeout_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    per_call_failover_phone_number: str = Field(type=str, required=False, mutable=False)


class GroupRoutePointNightServiceGetRequest(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a ``GroupRoutePointNightServiceGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a ``GroupRoutePointNightServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointNightServiceGetRequest20(OCIRequest):
    """
    Get a route point's night service settings.

    The response is either a ``GroupRoutePointNightServiceGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointOverflowGetRequest(OCIRequest):
    """
    Get a route point's overflow settings.

    The response is either a ``GroupRoutePointOverflowGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointOverflowGetRequest20(OCIRequest):
    """
    Get a route point's overflow settings.

    The response is either a ``GroupRoutePointOverflowGetResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Route Point Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool, is_required=True),
        E("description", "description", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupRoutePointQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Route Point Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Route Point Level and Organization Level Call Disposition Codes.

    The response is either ``GroupRoutePointQueueCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Route Point Call Disposition Code.

    The response is either ``GroupRoutePointQueueCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)


class GroupRoutePointQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Route Point Call Disposition Code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        code: code
        is_active: isActive
        description: description
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("code", "code", str, is_required=True),
        E("is_active", "isActive", bool),
        E("description", "description", str),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    code: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class GroupRoutePointQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the queue level data associated with Route Point Call Disposition Code
    Settings.

    The response is either an
    ``GroupRoutePointQueueCallDispositionCodeSettingsGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutingProfileGetRequest(OCIRequest):
    """
    Request the routing profile for the group.

    The response is either a ``GroupRoutingProfileGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupRoutingProfileModifyRequest(OCIRequest):
    """
    Requests to modify the routing profile for a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        routing_profile: routingProfile
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("routing_profile", "routingProfile", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    routing_profile: str = Field(type=str, required=False, mutable=False)


class GroupScheduleAddRequest(OCIRequest):
    """
    Add a group schedule.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        schedule_name: scheduleName
        schedule_type: scheduleType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("schedule_name", "scheduleName", str, is_required=True),
        E("schedule_type", "scheduleType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    schedule_name: str = Field(type=str, required=True, mutable=False)
    schedule_type: str = Field(type=str, required=True, mutable=False)


class GroupScheduleGetListRequest(OCIRequest):
    """
    Get the list of a group schedules.

    The list can be filtered by schedule type.

    The response is either a ``GroupScheduleGetListResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        schedule_type: scheduleType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("schedule_type", "scheduleType", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    schedule_type: str = Field(type=str, required=False, mutable=False)


class GroupScheduleGetListRequest17sp1(OCIRequest):
    """
    Get the list of schedules viewable by a group.

    The list can be filtered by schedule type.

    The response is either a ``GroupScheduleGetListResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        schedule_type: scheduleType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("schedule_type", "scheduleType", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    schedule_type: str = Field(type=str, required=False, mutable=False)


class GroupSeriesCompletionAddInstanceRequest(OCIRequest):
    """
    Adds a Series Completion group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
        user_id: userId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("user_id", "userId", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    user_id: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupSeriesCompletionDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Series Completion group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupSeriesCompletionGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Series Completion instances within a group.

    The response is either ``GroupSeriesCompletionGetInstanceListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupSeriesCompletionGetInstanceRequest(OCIRequest):
    """
    Gets a Series Completion group.

    The response is either ``GroupSeriesCompletionGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupServiceAssignListRequest(OCIRequest):
    """
    Assign one or more group services to the group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: str = Field(type=str, required=True, mutable=False)


class GroupServiceGetAuthorizationListRequest(OCIRequest):
    """
    Requests the group's service authorization status.

    The response is either ``GroupServiceGetAuthorizationListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceGetAuthorizedListRequest(OCIRequest):
    """
    Requests the list of services and service packs authorized to a group.

    The response is either ``GroupServiceGetAuthorizedListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceInstancePrivacyGetRequest(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.

    The response is either a ``GroupServiceInstancePrivacyGetResponse()``. Replaced by:
    ``GroupServiceInstancePrivacyGetRequest17sp4()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceInstancePrivacyGetRequest17sp4(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.

    The response is either a ``GroupServiceInstancePrivacyGetResponse17sp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceInstancePrivacyModifyRequest(OCIRequest):
    """
    Modify the data associated with Privacy for a service instance.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        enable_directory_privacy: enableDirectoryPrivacy
        enable_auto_attendant_extension_dialing_privacy:
            enableAutoAttendantExtensionDialingPrivacy
        enable_auto_attendant_name_dialing_privacy: enableAutoAttendantNameDialingPrivacy
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("enable_directory_privacy", "enableDirectoryPrivacy", bool),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy", bool,
        ),
        E(
            "enable_auto_attendant_name_dialing_privacy",
            "enableAutoAttendantNameDialingPrivacy", bool,
        ),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    enable_directory_privacy: bool = Field(type=bool, required=False, mutable=False)
    enable_auto_attendant_extension_dialing_privacy: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_auto_attendant_name_dialing_privacy: bool = Field(
        type=bool, required=False, mutable=False,
    )


class GroupServiceIsAssignedRequest(OCIRequest):
    """
    Request to determine if a GroupService is assigned to the group.


    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: str = Field(type=str, required=True, mutable=False)


class GroupServicePhoneNumberLookupRequest(OCIRequest):
    """
    Lookup if the given number is defined in the specified service in the group.

    The response is ``GroupServicePhoneNumberLookupResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_type: serviceType
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_type", "serviceType", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_type: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)


class GroupServiceScriptsGroupClearLogRequest(OCIRequest):
    """
    Clear the Service Script Group Log.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceScriptsGroupGetLogRequest(OCIRequest):
    """
    Request the group level data associated with Service Scripts Group Log.

    The response is either a ``GroupServiceScriptsGroupGetLogResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceScriptsGroupGetRequest(OCIRequest):
    """
    Request the group level data associated with Service Scripts Group Configuration.

    The response is either a ``GroupServiceScriptsGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupServiceUnassignListRequest(OCIRequest):
    """
    Unassign one or more of the group's assigned services.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_name: str = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGetRequest(OCIRequest):
    """
    Get the session admission control capacity for the group.

    The response is either a ``GroupSessionAdmissionControlGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the group.

    The response is either a ``GroupSessionAdmissionControlGroupGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a ``GroupSessionAdmissionControlGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the group.

    The response is either a ``GroupSessionAdmissionControlGroupGetResponse19sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class GroupSessionAdmissionControlModifyRequest(OCIRequest):
    """
    Request to modify session admission control capacity for the group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        restrict_aggregate_sessions: restrictAggregateSessions
        max_sessions: maxSessions
        max_user_originating_sessions: maxUserOriginatingSessions
        max_user_terminating_sessions: maxUserTerminatingSessions
        count_intra_group_sessions: countIntraGroupSessions
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E("count_intra_group_sessions", "countIntraGroupSessions", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    restrict_aggregate_sessions: bool = Field(type=bool, required=False, mutable=False)
    max_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_originating_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_terminating_sessions: int = Field(type=int, required=False, mutable=False)
    count_intra_group_sessions: bool = Field(type=bool, required=False, mutable=False)


class GroupShInterfaceGetUserListRequest(OCIRequest):
    """
    Returns a list of all Public User Identities and associated data in a group.

    The response is either a ``GroupShInterfaceGetUserListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100GetRequest(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.

    The response is either a ``GroupSpeedDial100GetResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100GetRequest17sp1(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.

    The response is either a ``GroupSpeedDial100GetResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupSpeedDial100ModifyRequest(OCIRequest):
    """
    Modify the speed dial 100 prefix setting for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        prefix: prefix
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("prefix", "prefix", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    prefix: str = Field(type=str, required=False, mutable=False)


class GroupThirdPartyVoiceMailSupportGetRequest(OCIRequest):
    """
    Request the group level data associated with Third-Party Voice Mail Support.

    The response is either a ``GroupThirdPartyVoiceMailSupportGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupThirdPartyVoiceMailSupportModifyRequest(OCIRequest):
    """
    Modify the Third Party Voice Mail Support settings for a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        is_active: isActive
        group_server: groupServer
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("is_active", "isActive", bool),
        E("group_server", "groupServer", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    is_active: bool = Field(type=bool, required=False, mutable=False)
    group_server: str = Field(type=str, required=False, mutable=False)


class GroupTimeScheduleDeleteRequest(OCIRequest):
    """
    Delete a time schedule from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        time_schedule_name: timeScheduleName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("time_schedule_name", "timeScheduleName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    time_schedule_name: str = Field(type=str, required=True, mutable=False)


class GroupTimeScheduleGetListRequest(OCIRequest):
    """
    Request a list of all time schedules in a group.

    The response is either a ``GroupTimeScheduleGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupTimeScheduleGetRequest(OCIRequest):
    """
    Request to get a group time schedule.

    The response is either a ``GroupTimeScheduleGetResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        time_schedule_name: timeScheduleName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("time_schedule_name", "timeScheduleName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    time_schedule_name: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Trunk Group Instance from a group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetAvailableDetailListRequest(OCIRequest):
    """
    Requests the list of available trunk groups within a group.

    The response is either ``GroupTrunkGroupGetAvailableDetailListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetInstanceListRequest14(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.

    It is possible to restrict the results to a particular department, or expand the list
    to the entire enterprise.

    The response is either a ``GroupTrunkGroupGetInstanceListResponse14()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
        include_enterprise_trunk_groups: includeEnterpriseTrunkGroups
        only_trunk_groups_with_device: onlyTrunkGroupsWithDevice
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
        E("include_enterprise_trunk_groups", "includeEnterpriseTrunkGroups", bool),
        E("only_trunk_groups_with_device", "onlyTrunkGroupsWithDevice", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)
    include_enterprise_trunk_groups: bool = Field(type=bool, required=False, mutable=False)
    only_trunk_groups_with_device: bool = Field(type=bool, required=False, mutable=False)


class GroupTrunkGroupGetInstanceListRequest14sp4(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.

    It is possible to restrict the results to a particular department, or expand the list
    to the entire enterprise.

    The response is either a ``GroupTrunkGroupGetInstanceListResponse14sp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
        include_enterprise_trunk_groups: includeEnterpriseTrunkGroups
        only_trunk_groups_with_device: onlyTrunkGroupsWithDevice
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
        E("include_enterprise_trunk_groups", "includeEnterpriseTrunkGroups", bool),
        E("only_trunk_groups_with_device", "onlyTrunkGroupsWithDevice", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)
    include_enterprise_trunk_groups: bool = Field(type=bool, required=False, mutable=False)
    only_trunk_groups_with_device: bool = Field(type=bool, required=False, mutable=False)


class GroupTrunkGroupGetInstanceRequest14(OCIRequest):
    """
    Get a Trunk Group Instance's profile.

    The response is either a ``GroupTrunkGroupGetInstanceResponse14()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetInstanceRequest14sp1(OCIRequest):
    """
    Get a Trunk Group Instance's profile.

    The response is either a ``GroupTrunkGroupGetInstanceResponse14sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetRequest(OCIRequest):
    """
    Get the maximum permissible active trunk group calls for the group.

    The response is either a ``GroupTrunkGroupGetResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetRequest14sp1(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a ``GroupTrunkGroupGetResponse14sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupGetRequest14sp9(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the
    group.

    The response is either a ``GroupTrunkGroupGetResponse14sp9()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskAddRequest(OCIRequest):
    """
    Add a user creation task for a trunk group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        task_name: taskName
        user_id_format: userIdFormat
        user_id_domain: userIdDomain
        populate_extension: populateExtension
        line_port_format: linePortFormat
        line_port_domain: linePortDomain
        populate_contact: populateContact
        contact_format: contactFormat
        contact_domain: contactDomain
        user_phone_numbers: userPhoneNumbers
        user_extensions: userExtensions
        service_pack_name: servicePackName
        user_service: userService
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("user_id_format", "userIdFormat", str, is_required=True),
        E("user_id_domain", "userIdDomain", str, is_required=True),
        E("populate_extension", "populateExtension", bool, is_required=True),
        E("line_port_format", "linePortFormat", str, is_required=True),
        E("line_port_domain", "linePortDomain", str, is_required=True),
        E("populate_contact", "populateContact", bool, is_required=True),
        E("contact_format", "contactFormat", str),
        E("contact_domain", "contactDomain", str),
        E("user_phone_numbers", "userPhoneNumbers", str, is_complex=True),  # unknown
        E("user_extensions", "userExtensions", str, is_complex=True),  # unknown
        E("service_pack_name", "servicePackName", str, is_array=True),
        E("user_service", "userService", str, is_array=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)
    user_id_format: str = Field(type=str, required=True, mutable=False)
    user_id_domain: str = Field(type=str, required=True, mutable=False)
    populate_extension: bool = Field(type=bool, required=True, mutable=False)
    line_port_format: str = Field(type=str, required=True, mutable=False)
    line_port_domain: str = Field(type=str, required=True, mutable=False)
    populate_contact: bool = Field(type=bool, required=True, mutable=False)
    contact_format: str = Field(type=str, required=False, mutable=False)
    contact_domain: str = Field(type=str, required=False, mutable=False)
    user_phone_numbers: str = Field(type=str, required=False, mutable=False)
    user_extensions: str = Field(type=str, required=False, mutable=False)
    service_pack_name: "List[str]" = Field(type=list, required=False, mutable=False)
    user_service: "List[str]" = Field(type=list, required=False, mutable=False)


class GroupTrunkGroupUserCreationTaskDeleteRequest(OCIRequest):
    """
    Delete a user creation task for a trunk group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetListRequest(OCIRequest):
    """
    Get the list of user creation tasks for a trunk group.

    The response is either ``GroupTrunkGroupUserCreationTaskGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupTrunkGroupUserCreationTaskGetRequest(OCIRequest):
    """
    Request the details of a specified user creation task for a trunk group.

    The response is either ``GroupTrunkGroupUserCreationTaskGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsDeleteUserRequest(OCIRequest):
    """
    Delete an existing Virtual On-Net user from a Group.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsGetUserRequest(OCIRequest):
    """
    Get an existing Virtual On-Net user from a Group.

    The response is either a ``GroupVirtualOnNetEnterpriseExtensionsGetUserResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)


class GroupVirtualOnNetEnterpriseExtensionsModifyUserRequest(OCIRequest):
    """
    Modify an existing Virtual On-Net user of a Group.

    The serviceProviderId, groupId and phoneNumber combination uniquely identifies a
    Virtual On-Net User.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        phone_number: phoneNumber
        extension: extension
        first_name: firstName
        last_name: lastName
        calling_line_id_first_name: callingLineIdFirstName
        calling_line_id_last_name: callingLineIdLastName
        virtual_on_net_call_type_name: virtualOnNetCallTypeName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
        E("extension", "extension", str),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("calling_line_id_first_name", "callingLineIdFirstName", str),
        E("calling_line_id_last_name", "callingLineIdLastName", str),
        E("virtual_on_net_call_type_name", "virtualOnNetCallTypeName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)
    extension: str = Field(type=str, required=False, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_first_name: str = Field(type=str, required=False, mutable=False)
    calling_line_id_last_name: str = Field(type=str, required=False, mutable=False)
    virtual_on_net_call_type_name: str = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupGetPasscodeRulesRequest(OCIRequest):
    """
    Requests the group's voice portal passcode rules setting.

    The response is either ``GroupVoiceMessagingGroupGetPasscodeRulesResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``GroupPortalPasscodeRulesGetRequest()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Requests the group's Voice Messaging settings.

    The response is either ``GroupVoiceMessagingGroupGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse()``
    or an ``ErrorResponse()``.

    Replaced By: ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a
    ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20(OCIRequest):
    """
    Get the group's voice portal branding settings.

    The response is either a
    ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse20()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest14(OCIRequest):
    """
    Requests the group's voice messaging settings The response is either
    ``GroupVoiceMessagingGroupGetVoicePortalResponse14()`` or ``ErrorResponse()``.

    Replaced by ``GroupVoiceMessagingGroupGetVoicePortalRequest15()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest15(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse15()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest17(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse17()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest17sp4(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse17sp4()`` or
    ``ErrorResponse()``. Replaced by:
    ``GroupVoiceMessagingGroupGetVoicePortalRequest19sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupGetVoicePortalRequest19sp1(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.

    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceMessagingGroupModifyPasscodeRulesRequest(OCIRequest):
    """
    Request to modify the group's voice portal passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``GroupPortalPasscodeRulesModifyRequest()``

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_rule_level: useRuleLevel
        disallow_repeated_digits: disallowRepeatedDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_rule_level", "useRuleLevel", str),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_rule_level: str = Field(type=str, required=False, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=False, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    min_code_length: int = Field(type=int, required=False, mutable=False)
    max_code_length: int = Field(type=int, required=False, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=False, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class GroupVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Request to modify the group's voice messaging settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        use_mail_server_setting: useMailServerSetting
        warn_caller_before_recording_voice_message: warnCallerBeforeRecordingVoiceMessage
        allow_users_configuring_advanced_settings: allowUsersConfiguringAdvancedSettings
        allow_compose_or_forward_message_to_entire_group:
            allowComposeOrForwardMessageToEntireGroup
        mail_server_net_address: mailServerNetAddress
        mail_server_protocol: mailServerProtocol
        real_delete_for_imap: realDeleteForImap
        max_mailbox_length_minutes: maxMailboxLengthMinutes
        does_message_age: doesMessageAge
        hold_period_days: holdPeriodDays
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("use_mail_server_setting", "useMailServerSetting", str),
        E(
            "warn_caller_before_recording_voice_message",
            "warnCallerBeforeRecordingVoiceMessage", bool,
        ),
        E(
            "allow_users_configuring_advanced_settings",
            "allowUsersConfiguringAdvancedSettings", bool,
        ),
        E(
            "allow_compose_or_forward_message_to_entire_group",
            "allowComposeOrForwardMessageToEntireGroup", bool,
        ),
        E("mail_server_net_address", "mailServerNetAddress", str),
        E("mail_server_protocol", "mailServerProtocol", str),
        E("real_delete_for_imap", "realDeleteForImap", bool),
        E("max_mailbox_length_minutes", "maxMailboxLengthMinutes", int),
        E("does_message_age", "doesMessageAge", bool),
        E("hold_period_days", "holdPeriodDays", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    use_mail_server_setting: str = Field(type=str, required=False, mutable=False)
    warn_caller_before_recording_voice_message: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_users_configuring_advanced_settings: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_compose_or_forward_message_to_entire_group: bool = Field(
        type=bool, required=False, mutable=False,
    )
    mail_server_net_address: str = Field(type=str, required=False, mutable=False)
    mail_server_protocol: str = Field(type=str, required=False, mutable=False)
    real_delete_for_imap: bool = Field(type=bool, required=False, mutable=False)
    max_mailbox_length_minutes: int = Field(type=int, required=False, mutable=False)
    does_message_age: bool = Field(type=bool, required=False, mutable=False)
    hold_period_days: int = Field(type=int, required=False, mutable=False)


class GroupVoiceXmlDeleteInstanceRequest(OCIRequest):
    """
    Delete a VoiceXML instance from a group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceXmlGetInstanceListRequest(OCIRequest):
    """
    Get a list of VoiceXML instances within a group.

    The response is either ``GroupVoiceXmlGetInstanceListResponse()`` or
    ``ErrorResponse()``. It is possible to get the instances within a specified
    department.

    Attributes:
        service_provider_id: serviceProviderId
        group_id: groupId
        group_department_name: groupDepartmentName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("group_id", "groupId", str, is_required=True),
        E("group_department_name", "groupDepartmentName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    group_id: str = Field(type=str, required=True, mutable=False)
    group_department_name: str = Field(type=str, required=False, mutable=False)


class GroupVoiceXmlGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either ``GroupVoiceXmlGetInstanceResponse()`` or ``ErrorResponse()``.
    Replaced by: ``GroupVoiceXmlGetInstanceRequest19sp1()``

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class GroupVoiceXmlGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.

    The response is either ``GroupVoiceXmlGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_user_id: serviceUserId
    """

    _ELEMENTS = (
        E("service_user_id", "serviceUserId", str, is_required=True),
    )

    service_user_id: str = Field(type=str, required=True, mutable=False)


class LoginRequest13mp10(OCIRequest):
    """
    ``LoginRequest13mp10()`` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL).

    Attributes:
        user_id: userId
        signed_password: signedPassword
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("signed_password", "signedPassword", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    signed_password: str = Field(type=str, required=False, mutable=False)


class LoginRequest14sp4(OCIRequest):
    """
    ``LoginRequest14sp4()`` is 2nd stage of the 2 stage OCI login process.

    The signedPassword is not required for external authentication login from a trusted
    host (ACL).

    Attributes:
        user_id: userId
        signed_password: signedPassword
        plain_text_password: plainTextPassword
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("signed_password", "signedPassword", str),
        E("plain_text_password", "plainTextPassword", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    signed_password: str = Field(type=str, required=False, mutable=False)
    plain_text_password: str = Field(type=str, required=False, mutable=False)


class LogoutRequest(OCIRequest):
    """
    ``LogoutRequest()`` is sent when an OCI user logs out or when connection is lost.

    This command can be sent either to the server, or to the client from OCS. Response is
    either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        user_id: userId
        reason: reason
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("reason", "reason", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    reason: str = Field(type=str, required=False, mutable=False)


class PasswordModifyRequest(OCIRequest):
    """
    Modify the password for a user/administrator.

    When oldPassword is specified, password rule applies.  If oldPassword in not
    specified, any password rule related to old password does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
        old_password: oldPassword
        new_password: newPassword
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("old_password", "oldPassword", str),
        E("new_password", "newPassword", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    old_password: str = Field(type=str, required=False, mutable=False)
    new_password: str = Field(type=str, required=True, mutable=False)


class PrimaryInfoGetRequest(OCIRequest):
    """
    Requests information about the primary server for high-availability support.


    Attributes:
        is_private: isPrivate
        is_address_info_requested: isAddressInfoRequested
    """

    _ELEMENTS = (
        E("is_private", "isPrivate", bool, is_required=True),
        E("is_address_info_requested", "isAddressInfoRequested", bool, is_required=True),
    )

    is_private: bool = Field(type=bool, required=True, mutable=False)
    is_address_info_requested: bool = Field(type=bool, required=True, mutable=False)


class PublicClusterGetFullyQualifiedDomainNameRequest(OCIRequest):
    """
    Get the public cluster fully qualified domain name (FQDN).

    The response is either a ``PublicClusterGetFullyQualifiedDomainNameResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class ServiceProviderAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a service provider access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a service provider access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        tag_name: tagName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either ``ServiceProviderAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a service provider access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified service provider access device.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``ServiceProviderAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceFileGetListRequest14sp8()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``ServiceProviderAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceFileGetRequest14sp8()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        file_type: fileType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_type: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAccessDeviceFileGetRequest16sp1()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a service provider device profile file.

    The response is either ``ServiceProviderAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse14()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceGetRequest14sp3()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse14sp3()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAccessDeviceGetRequest14sp6()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse14sp6()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAccessDeviceGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse16()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAccessDeviceGetRequest19()``

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.

    The response is either ``ServiceProviderAccessDeviceGetResponse18sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the service provider device
    profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode and ignored in AS data mode: privateIdentity

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        line_port: linePort
        private_identity: privateIdentity
        is_primary_line_port: isPrimaryLinePort
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("is_primary_line_port", "isPrimaryLinePort", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    private_identity: str = Field(type=str, required=False, mutable=False)
    is_primary_line_port: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific service provider SIP device that supports the reset operation.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminAddRequest14(OCIRequest):
    """
    Add a service provider administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
        administrator_type: administratorType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
        E("administrator_type", "administratorType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    administrator_type: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminDeleteRequest(OCIRequest):
    """
    Delete a service provider administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetListRequest14(OCIRequest):
    """
    Get a list of service provider administrators.

    The response is either a ``ServiceProviderAdminGetListResponse14()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest14(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse14()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse16sp1()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderAdminGetPolicyRequest17()``

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse16sp2()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse17()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest17sp1(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse17sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse17sp3()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse18()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the service provider administrator's policy settings.

    The response is either ``ServiceProviderAdminGetPolicyResponse20()`` or
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminGetRequest14(OCIRequest):
    """
    Get a service provider administrators profile.

    The response is either a ``ServiceProviderAdminGetResponse14()`` or an
    ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdminModifyPolicyRequest14(OCIRequest):
    """
    Request to modify the service provider administrator's policy settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The
    networkPolicyAccess is only modified for the enterprise administrator.  The following
    elements are only used in AS data mode: dialableCallerIDAccess
    verifyTranslationAndroutingAccess

    Attributes:
        user_id: userId
        profile_access: profileAccess
        group_access: groupAccess
        user_access: userAccess
        admin_access: adminAccess
        department_access: departmentAccess
        access_device_access: accessDeviceAccess
        phone_number_extension_access: phoneNumberExtensionAccess
        calling_line_id_number_access: callingLineIdNumberAccess
        service_access: serviceAccess
        service_pack_access: servicePackAccess
        session_admission_control_access: sessionAdmissionControlAccess
        web_branding_access: webBrandingAccess
        office_zone_access: officeZoneAccess
        communication_barring_access: communicationBarringAccess
        network_policy_access: networkPolicyAccess
        number_activation_access: numberActivationAccess
        dialable_caller_id_access: dialableCallerIDAccess
        verify_translation_and_routing_access: verifyTranslationAndRoutingAccess
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("profile_access", "profileAccess", str),
        E("group_access", "groupAccess", str),
        E("user_access", "userAccess", str),
        E("admin_access", "adminAccess", str),
        E("department_access", "departmentAccess", str),
        E("access_device_access", "accessDeviceAccess", str),
        E("phone_number_extension_access", "phoneNumberExtensionAccess", str),
        E("calling_line_id_number_access", "callingLineIdNumberAccess", str),
        E("service_access", "serviceAccess", str),
        E("service_pack_access", "servicePackAccess", str),
        E("session_admission_control_access", "sessionAdmissionControlAccess", str),
        E("web_branding_access", "webBrandingAccess", str),
        E("office_zone_access", "officeZoneAccess", str),
        E("communication_barring_access", "communicationBarringAccess", str),
        E("network_policy_access", "networkPolicyAccess", str),
        E("number_activation_access", "numberActivationAccess", str),
        E("dialable_caller_id_access", "dialableCallerIDAccess", str),
        E("verify_translation_and_routing_access", "verifyTranslationAndRoutingAccess", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    profile_access: str = Field(type=str, required=False, mutable=False)
    group_access: str = Field(type=str, required=False, mutable=False)
    user_access: str = Field(type=str, required=False, mutable=False)
    admin_access: str = Field(type=str, required=False, mutable=False)
    department_access: str = Field(type=str, required=False, mutable=False)
    access_device_access: str = Field(type=str, required=False, mutable=False)
    phone_number_extension_access: str = Field(type=str, required=False, mutable=False)
    calling_line_id_number_access: str = Field(type=str, required=False, mutable=False)
    service_access: str = Field(type=str, required=False, mutable=False)
    service_pack_access: str = Field(type=str, required=False, mutable=False)
    session_admission_control_access: str = Field(type=str, required=False, mutable=False)
    web_branding_access: str = Field(type=str, required=False, mutable=False)
    office_zone_access: str = Field(type=str, required=False, mutable=False)
    communication_barring_access: str = Field(type=str, required=False, mutable=False)
    network_policy_access: str = Field(type=str, required=False, mutable=False)
    number_activation_access: str = Field(type=str, required=False, mutable=False)
    dialable_caller_id_access: str = Field(type=str, required=False, mutable=False)
    verify_translation_and_routing_access: str = Field(
        type=str, required=False, mutable=False,
    )


class ServiceProviderAdminModifyRequest(OCIRequest):
    """
    Modify a service provider administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)


class ServiceProviderAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge service provider parameters.

    The response is either ``ServiceProviderAdviceOfChargeGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge service provider settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_sp_level_ao_c_settings: useSPLevelAoCSettings
        delay_between_notification_seconds: delayBetweenNotificationSeconds
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_sp_level_ao_c_settings", "useSPLevelAoCSettings", bool),
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_sp_level_ao_c_settings: bool = Field(type=bool, required=False, mutable=False)
    delay_between_notification_seconds: int = Field(type=int, required=False, mutable=False)


class ServiceProviderAnswerConfirmationGetRequest(OCIRequest):
    """
    Get a service provider or enterprise's answer confirmation settings.

    The response is either a ``ServiceProviderAnswerConfirmationGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderAnswerConfirmationGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderAnswerConfirmationGetRequest16(OCIRequest):
    """
    Get a service provider or enterprise's answer confirmation settings.

    The response is either a ``ServiceProviderAnswerConfirmationGetResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a service provider or enterprise.

    The response is either a ``ServiceProviderApplicationServerSetGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set assigned to the service provider or enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        application_server_set_name: applicationServerSetName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("application_server_set_name", "applicationServerSetName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    application_server_set_name: str = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksCommunicatorGetRequest(OCIRequest):
    """
    Request to get Configuration Server for a specified service provider.

    The response is either a ``ServiceProviderBroadWorksCommunicatorGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksCommunicatorModifyRequest(OCIRequest):
    """
    Request to modify the Configuration URL.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        configuration_server_url: configurationServerURL
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str),
        E("configuration_server_url", "configurationServerURL", str),
    )

    service_provider_id: str = Field(type=str, required=False, mutable=False)
    configuration_server_url: str = Field(type=str, required=False, mutable=False)


class ServiceProviderBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the service provider BroadWorks Mobility service settings.

    The response is either a ``ServiceProviderBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``. Replaced by:
    ``ServiceProviderBroadWorksMobilityGetRequest19sp1()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the service provider BroadWorks Mobility service settings.

    The response is either a ``ServiceProviderBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest(OCIRequest):
    """
    Adds Mobile Subscriber Directory Numbers to a service provider.

    It is possible to add a single DN, or a list of DNs.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest21()``.

    Attributes:
        service_provider_id: serviceProviderId
        mobile_subscriber_directory_number: mobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest21(OCIRequest):
    """
    Adds Mobile Subscriber Directory Numbers to a service provider-mobile network
    combination.

    It is possible to add a single DN, or a list of DNs.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        mobile_network_name: mobileNetworkName
        mobile_subscriber_directory_number: mobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("mobile_network_name", "mobileNetworkName", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    mobile_network_name: str = Field(type=str, required=True, mutable=False)
    mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberDeleteListRequest(OCIRequest):
    """
    Deletes Mobile Subscriber Directory Numbers from a service provider.

    It is possible to delete either: a single number, or a list of numbers.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        mobile_subscriber_directory_number: mobileSubscriberDirectoryNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "mobile_subscriber_directory_number", "mobileSubscriberDirectoryNumber", str,
            is_array=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    mobile_subscriber_directory_number: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(OCIRequest):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned to
    any group.

    This command is applicable only for service providers and will fail for enterprises.

    The response is either
    ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the service provider level BroadWorks Mobility service settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_setting_level: useSettingLevel
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        enable_announcement_suppression: enableAnnouncementSuppression
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_setting_level", "useSettingLevel", str),
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_setting_level: str = Field(type=str, required=False, mutable=False)
    enable_location_services: bool = Field(type=bool, required=False, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=False, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=False, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=False, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=False, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        force: force
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    force: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a Service Provider device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the
    ``ServiceProviderAccessDeviceGetRequest()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        ordered_line_port_list: orderedLinePortList
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("ordered_line_port_list", "orderedLinePortList", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    ordered_line_port_list: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific service provider or enterprise device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        device_name: deviceName
        force: force
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    device_name: str = Field(type=str, required=True, mutable=False)
    force: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14sp1()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14sp4()`` or
    an ``ErrorResponse()``.

    Replaced By : ``ServiceProviderCallProcessingGetPolicyRequest15()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse14sp7()`` or
    an ``ErrorResponse()``.

    Replaced By: ``ServiceProviderCallProcessingGetPolicyRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderCallProcessingGetPolicyRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse15sp2()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse16sp2()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse17sp3()`` or
    an ``ErrorResponse()``. Replaced by
    ``ServiceProviderCallProcessingGetPolicyResponse17sp4()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse17sp4()`` or
    an ``ErrorResponse()``.

    Replaced By : ``ServiceProviderCallProcessingGetPolicyRequest18sp1()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse18sp1()`` or
    an ``ErrorResponse()``. Replaced by:
    ``ServiceProviderCallProcessingGetPolicyRequest19sp1()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing Policy.

    The response is either a ``ServiceProviderCallProcessingGetPolicyResponse18sp1()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the service provider level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E("use_setting_level", "useSettingLevel", str),
        E("conference_uri", "conferenceURI", str),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=False, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )
    clid_policy: str = Field(type=str, required=False, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )


class ServiceProviderCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the service provider level data associated with Call Procesing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    following elements are only used in AS data mode: useServiceProviderDCLIDSetting
    enableDialableCallerID allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy groupCallsCLIDPolicy

    Attributes:
        service_provider_id: serviceProviderId
        use_service_provider_dclid_setting: useServiceProviderDCLIDSetting
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        use_setting_level: useSettingLevel
        conference_uri: conferenceURI
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        enable_dialable_caller_id: enableDialableCallerID
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        group_calls_clid_policy: groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_service_provider_dclid_setting", "useServiceProviderDCLIDSetting", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E("use_setting_level", "useSettingLevel", str),
        E("conference_uri", "conferenceURI", str),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("group_calls_clid_policy", "groupCallsCLIDPolicy", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_service_provider_dclid_setting: bool = Field(type=bool, required=False, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_setting_level: str = Field(type=str, required=False, mutable=False)
    conference_uri: str = Field(type=str, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )
    clid_policy: str = Field(type=str, required=False, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=False, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    group_calls_clid_policy: str = Field(type=str, required=False, mutable=False)


class ServiceProviderCommunicationBarringCriteriaAssignListRequest(OCIRequest):
    """
    Assign a list of Communication Barring Criteria to a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    criteria_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest(OCIRequest):
    """
    Get a list of Communication Barring Criteria assigned to a service provider.

    The response is either a
    ``ServiceProviderCommunicationBarringCriteriaGetAssignedListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringCriteriaUnassignListRequest(OCIRequest):
    """
    Unassign a list of Communication Barring Criteria from a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    criteria_name: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaAddRequest(OCIRequest):
    """
    Add a new Communication Barring Digit Pattern Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
        description: description
        match_digit_pattern: matchDigitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("match_digit_pattern", "matchDigitPattern", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    match_digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaDeleteRequest(OCIRequest):
    """
    Delete an existing Communication Barring Digit Pattern Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest(OCIRequest):
    """
    Get the list of all Digit Pattern Criteria defined for the service provider.

    The response is either a
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest(OCIRequest):
    """
    Get an existing Digit Pattern Criteria.

    The response is either a
    ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringDigitPatternCriteriaModifyRequest(OCIRequest):
    """
    Modify an existing Communication Barring Digit Pattern Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
        new_name: newName
        description: description
        add_match_digit_pattern: addMatchDigitPattern
        delete_match_digit_pattern: deleteMatchDigitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("new_name", "newName", str),
        E("description", "description", str),
        E("add_match_digit_pattern", "addMatchDigitPattern", str, is_array=True),
        E("delete_match_digit_pattern", "deleteMatchDigitPattern", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    new_name: str = Field(type=str, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    add_match_digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)
    delete_match_digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaAssignListRequest(OCIRequest):
    """
    Assign a list of Communication Barring Incoming Criteria to a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest(OCIRequest):
    """
    Get a list of Communication Barring Incoming Criteria assigned to a service provider.

    The response is either a
    ``ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringIncomingCriteriaUnassignListRequest(OCIRequest):
    """
    Unassign a list of Communication Barring Incoming Criteria from a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Communication Barring Profile.

    Optionally, a new default profile can be chosen if the current default profile is
    being deleted.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
        default_profile: defaultProfile
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("default_profile", "defaultProfile", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    default_profile: str = Field(type=str, required=False, mutable=False)


class ServiceProviderCommunicationBarringProfileGetCriteriaUsageListRequest(OCIRequest):
    """
    Get a list of Communication Barring profiles within a service provider that have a
    given Communication Barring Criteria assigned.

    The response is either a ServiceProviderCommunicationBarring
    ``ProfileGetCriteriaUsageListResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest(OCIRequest):
    """
    Get the list of Profiles that use a specific Digit Pattern Criteria.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest(OCIRequest):
    """
    Get a list of Communication Barring profiles within a service provider that have a
    given Communication Barring Incoming Criteria assigned.

    The response is either a ServiceProviderCommunicationBarring
    ``ProfileGetIncomingCriteriaUsageListResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        criteria_name: criteriaName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("criteria_name", "criteriaName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    criteria_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetListRequest(OCIRequest):
    """
    Get the list of all Communication Barring Profiles.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest(OCIRequest):
    """
    Get an existing Communication Barring Profile.

    The response is either a ``ServiceProviderCommunicationBarringProfileGetResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest17sp3(OCIRequest):
    """
    Get an existing Communication Barring Profile.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetResponse17sp3()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileGetRequest19sp1(OCIRequest):
    """
    Get an existing Communication Barring Profile.

    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetResponse19sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderCommunicationBarringProfileModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Communication Barring Profile of a Service Provider.

    If a default has been previously selected, this command will swap the default profile
    with the profile provided.  Selecting a nil profile will cause the service provider to
    not have a default Communicaton Barring Profile.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDeleteRequest(OCIRequest):
    """
    Delete a service provider or enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.

    A list of individual events can be canceled.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        event_id: eventId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("event_id", "eventId", int, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    event_id: int = Field(type=int, required=True, mutable=False)


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest(OCIRequest):
    """
    Request to get the service provider level device profile authentication password rule
    settings.

    The response is either a
    ``ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDeviceProfileAuthenticationPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider level device profile authentication password
    rule settings.

    The useServiceProviderSettings element can only be modified by a system administrator
    or a provisioning administrator.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_service_provider_settings: useServiceProviderSettings
        disallow_authentication_name: disallowAuthenticationName
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        send_permanent_lockout_notification: sendPermanentLockoutNotification
        permanent_lockout_notify_email_address: permanentLockoutNotifyEmailAddress
        device_profile_authentication_lockout_type: deviceProfileAuthenticationLockoutType
        device_profile_temporary_lockout_threshold: deviceProfileTemporaryLockoutThreshold
        device_profile_wait_algorithm: deviceProfileWaitAlgorithm
        device_profile_lockout_fixed_minutes: deviceProfileLockoutFixedMinutes
        device_profile_permanent_lockout_threshold: deviceProfilePermanentLockoutThreshold
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_service_provider_settings", "useServiceProviderSettings", bool),
        E("disallow_authentication_name", "disallowAuthenticationName", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("send_permanent_lockout_notification", "sendPermanentLockoutNotification", bool),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E(
            "device_profile_authentication_lockout_type",
            "deviceProfileAuthenticationLockoutType", str,
        ),
        E(
            "device_profile_temporary_lockout_threshold",
            "deviceProfileTemporaryLockoutThreshold", int,
        ),
        E("device_profile_wait_algorithm", "deviceProfileWaitAlgorithm", str),
        E("device_profile_lockout_fixed_minutes", "deviceProfileLockoutFixedMinutes", str),
        E(
            "device_profile_permanent_lockout_threshold",
            "deviceProfilePermanentLockoutThreshold", int,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_service_provider_settings: bool = Field(type=bool, required=False, mutable=False)
    disallow_authentication_name: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=False, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=False, mutable=False)
    min_digits: int = Field(type=int, required=False, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=False, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=False, mutable=False)
    min_length: int = Field(type=int, required=False, mutable=False)
    send_permanent_lockout_notification: bool = Field(
        type=bool, required=False, mutable=False,
    )
    permanent_lockout_notify_email_address: str = Field(
        type=str, required=False, mutable=False,
    )
    device_profile_authentication_lockout_type: str = Field(
        type=str, required=False, mutable=False,
    )
    device_profile_temporary_lockout_threshold: int = Field(
        type=int, required=False, mutable=False,
    )
    device_profile_wait_algorithm: str = Field(type=str, required=False, mutable=False)
    device_profile_lockout_fixed_minutes: str = Field(type=str, required=False, mutable=False)
    device_profile_permanent_lockout_threshold: int = Field(
        type=int, required=False, mutable=False,
    )


class ServiceProviderDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Service Provider level Dial Plan Access Code and its all attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        access_code: accessCode
        include_code_for_network_translations_and_routing:
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services: includeCodeForScreeningServices
        enable_secondary_dial_tone: enableSecondaryDialTone
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool, is_required=True,
        ),
        E(
            "include_code_for_screening_services", "includeCodeForScreeningServices",
            bool, is_required=True,
        ),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool, is_required=True),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)
    include_code_for_network_translations_and_routing: bool = Field(
        type=bool, required=True, mutable=False,
    )
    include_code_for_screening_services: bool = Field(type=bool, required=True, mutable=False)
    enable_secondary_dial_tone: bool = Field(type=bool, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Service Provider level Dial Plan Access Code and its all
    attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        access_code: accessCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``ServiceProviderDialPlanPolicyGetAccessCodeListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Service Provider level Dial Plan Policy
    access codes.

    The response is either a ``ServiceProviderDialPlanPolicyGetAccessCodeResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        access_code: accessCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``ServiceProviderDialPlanPolicyGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``ServiceProviderDialPlanPolicyGetRequest17()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``ServiceProviderDialPlanPolicyGetResponse17()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Service Provider level Dial Plan Access Code and its attribues.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        access_code: accessCode
        include_code_for_network_translations_and_routing:
            includeCodeForNetworkTranslationsAndRouting
        include_code_for_screening_services: includeCodeForScreeningServices
        enable_secondary_dial_tone: enableSecondaryDialTone
        description: description
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str, is_required=True),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting", bool,
        ),
        E("include_code_for_screening_services", "includeCodeForScreeningServices", bool),
        E("enable_secondary_dial_tone", "enableSecondaryDialTone", bool),
        E("description", "description", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=True, mutable=False)
    include_code_for_network_translations_and_routing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    include_code_for_screening_services: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_secondary_dial_tone: bool = Field(type=bool, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Service Provider level data associated with Dial Plan Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        requires_access_code_for_public_calls: requiresAccessCodeForPublicCalls
        allow_e164_public_calls: allowE164PublicCalls
        prefer_e164_number_format_for_callback_services:
            preferE164NumberFormatForCallbackServices
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("requires_access_code_for_public_calls", "requiresAccessCodeForPublicCalls", bool),
        E("allow_e164_public_calls", "allowE164PublicCalls", bool),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices", bool,
        ),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    requires_access_code_for_public_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_e164_public_calls: bool = Field(type=bool, required=False, mutable=False)
    prefer_e164_number_format_for_callback_services: bool = Field(
        type=bool, required=False, mutable=False,
    )
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria.

    Criteria are added at the bottom of the list with the lowest priority.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
        description: description
        prefix_digits: prefixDigits
        match_call_type: matchCallType
        match_alternate_call_indicator: matchAlternateCallIndicator
        match_local_category: matchLocalCategory
        match_national_category: matchNationalCategory
        match_interlata_category: matchInterlataCategory
        match_intralata_category: matchIntralataCategory
        match_international_category: matchInternationalCategory
        match_private_category: matchPrivateCategory
        match_emergency_category: matchEmergencyCategory
        match_other_category: matchOtherCategory
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("prefix_digits", "prefixDigits", str),
        E("match_call_type", "matchCallType", str, is_array=True),
        E(
            "match_alternate_call_indicator", "matchAlternateCallIndicator", str,
            is_array=True,
        ),
        E("match_local_category", "matchLocalCategory", bool, is_required=True),
        E("match_national_category", "matchNationalCategory", bool, is_required=True),
        E("match_interlata_category", "matchInterlataCategory", bool, is_required=True),
        E("match_intralata_category", "matchIntralataCategory", bool, is_required=True),
        E(
            "match_international_category", "matchInternationalCategory", bool,
            is_required=True,
        ),
        E("match_private_category", "matchPrivateCategory", bool, is_required=True),
        E("match_emergency_category", "matchEmergencyCategory", bool, is_required=True),
        E("match_other_category", "matchOtherCategory", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    prefix_digits: str = Field(type=str, required=False, mutable=False)
    match_call_type: "List[str]" = Field(type=list, required=False, mutable=False)
    match_alternate_call_indicator: "List[str]" = Field(
        type=list, required=False, mutable=False,
    )
    match_local_category: bool = Field(type=bool, required=True, mutable=False)
    match_national_category: bool = Field(type=bool, required=True, mutable=False)
    match_interlata_category: bool = Field(type=bool, required=True, mutable=False)
    match_intralata_category: bool = Field(type=bool, required=True, mutable=False)
    match_international_category: bool = Field(type=bool, required=True, mutable=False)
    match_private_category: bool = Field(type=bool, required=True, mutable=False)
    match_emergency_category: bool = Field(type=bool, required=True, mutable=False)
    match_other_category: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.

    The response is either a ``ServiceProviderDialableCallerIDCriteriaGetRequest()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        name: name
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("name", "name", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDialableCallerIDGetRequest(OCIRequest):
    """
    Get the service provider?s Dialable Caller ID settings and criteria list.

    The response is either a ``ServiceProviderDialableCallerIDGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the service provider's digit collection attributes.

    The response is either a ``ServiceProviderDigitCollectionGetResponse13mp4()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the service provider's digit collection attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        access_code: accessCode
        public_digit_map: publicDigitMap
        private_digit_map: privateDigitMap
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("access_code", "accessCode", str),
        E("public_digit_map", "publicDigitMap", str),
        E("private_digit_map", "privateDigitMap", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    access_code: str = Field(type=str, required=False, mutable=False)
    public_digit_map: str = Field(type=str, required=False, mutable=False)
    private_digit_map: str = Field(type=str, required=False, mutable=False)


class ServiceProviderDnGetAvailableListRequest(OCIRequest):
    """
    Request a list of available DNs not yet assigned to any group.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either ``ServiceProviderDnGetAvailableListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDnGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a service provider.

    Dns assigned to the IMRN pool are not listed in the response.

    The response is either ``ServiceProviderDnGetSummaryListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        domain: domain
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    domain: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a service provider.

    The response is either ``ServiceProviderDomainGetAssignedListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        domain: domain
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("domain", "domain", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    domain: str = Field(type=str, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetRequest(OCIRequest):
    """
    Get the service provider's enhanced call log settings.

    The response is either a ``ServiceProviderEnhancedCallLogsGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsGetRequest17sp4(OCIRequest):
    """
    Get the service provider's enhanced call log settings.

    The response is either a ``ServiceProviderEnhancedCallLogsGetResponse17sp4()`` or an
    ``ErrorResponse()``. This command will return an ``ErrorResponse()`` if DBS is used as
    the call log server.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderEnhancedCallLogsModifyRequest(OCIRequest):
    """
    Modify the Service Provider level data associated with Enhanced Call Logs.

    Configures the maximum number of logged calls and maximum age of your user's call
    logs.  Log entries are deleted when either of the two limits is reached.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        max_logged_calls: maxLoggedCalls
        call_expiration_days: callExpirationDays
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("max_logged_calls", "maxLoggedCalls", int),
        E("call_expiration_days", "callExpirationDays", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    max_logged_calls: int = Field(type=int, required=False, mutable=False)
    call_expiration_days: int = Field(type=int, required=False, mutable=False)


class ServiceProviderExternalCustomRingbackGetRequest(OCIRequest):
    """
    Request the service provider level data associated with External Custom Ringback.

    The response is either a ``ServiceProviderExternalCustomRingbackGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderExternalCustomRingbackModifyRequest(OCIRequest):
    """
    Modify the service provider level data associated with External Custom Ringback.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        prefix_digits: prefixDigits
        server_net_address: serverNetAddress
        server_port: serverPort
        timeout_seconds: timeoutSeconds
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("prefix_digits", "prefixDigits", str),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("timeout_seconds", "timeoutSeconds", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    prefix_digits: str = Field(type=str, required=False, mutable=False)
    server_net_address: str = Field(type=str, required=False, mutable=False)
    server_port: int = Field(type=int, required=False, mutable=False)
    timeout_seconds: int = Field(type=int, required=False, mutable=False)


class ServiceProviderFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.

    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderFeatureAccessCodeGetListRequest20(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.

    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse20()`` or an
    ``ErrorResponse()``. In release 20 the "Call Recording" FAC name is changed to "Call
    Recording - Start". Replaced by:
    ``ServiceProviderFeatureAccessCodeGetListRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderFeatureAccessCodeGetListRequest21(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.

    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse21()`` or an
    ``ErrorResponse()``. In release 20 the "Call Recording" FAC name is changed to "Call
    Recording - Start".

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new service provider file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        file_repository_name: fileRepositoryName
        user_name: userName
        password: password
        allow_put: allowPut
        allow_delete: allowDelete
        allow_get: allowGet
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str, is_required=True),
        E("allow_put", "allowPut", bool, is_required=True),
        E("allow_delete", "allowDelete", bool, is_required=True),
        E("allow_get", "allowGet", bool, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)
    allow_put: bool = Field(type=bool, required=True, mutable=False)
    allow_delete: bool = Field(type=bool, required=True, mutable=False)
    allow_get: bool = Field(type=bool, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a service provider file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        file_repository_name: fileRepositoryName
        user_name: userName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    user_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of service provider users for a file repository in the system.

    The response is either a ``ServiceProviderFileRepositoryDeviceUserGetListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        file_repository_name: fileRepositoryName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a service provider file repository user.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        file_repository_name: fileRepositoryName
        user_name: userName
        password: password
        allow_put: allowPut
        allow_delete: allowDelete
        allow_get: allowGet
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("user_name", "userName", str, is_required=True),
        E("password", "password", str),
        E("allow_put", "allowPut", bool),
        E("allow_delete", "allowDelete", bool),
        E("allow_get", "allowGet", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    user_name: str = Field(type=str, required=True, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    allow_put: bool = Field(type=bool, required=False, mutable=False)
    allow_delete: bool = Field(type=bool, required=False, mutable=False)
    allow_get: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a service provider or enterprise.

    The response is either a ``ServiceProviderGetDefaultResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class ServiceProviderGetRequest13mp2(OCIRequest):
    """
    Get the profile for a service provider or enterprise.

    The response is either a ``ServiceProviderGetResponse13mp2()`` or an
    ``ErrorResponse()``. Replaced by: ``ServiceProviderGetRequest17sp1()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderGetRequest17sp1(OCIRequest):
    """
    Get the profile for a service provider or enterprise.

    The response is either a ``ServiceProviderGetResponse17sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a service
    provider.

    The response is either a ``ServiceProviderGroupPagingTargetsCapacityGetResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a service
    provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        maximum_target_users: maximumTargetUsers
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("maximum_target_users", "maximumTargetUsers", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    maximum_target_users: int = Field(type=int, required=False, mutable=False)


class ServiceProviderIMRNGetListRequest(OCIRequest):
    """
    Returns a list of dns or dn ranges in a service provider IMRN pool.

    The response is either ``ServiceProviderIMRNGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationGetRequest(OCIRequest):
    """
    Request the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``ServiceProviderInCallServiceActivationGetResponse()`` or an
    ``ErrorResponse()``. Replaced by:
    ``ServiceProviderInCallServiceActivationGetRequest17()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationGetRequest17(OCIRequest):
    """
    Request the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``ServiceProviderInCallServiceActivationGetResponse17()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderInCallServiceActivationModifyRequest(OCIRequest):
    """
    Modifies the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``ServiceProviderInCallServiceActivationModifyRequest17()``

    Attributes:
        service_provider_id: serviceProviderId
        activation_digits: activationDigits
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("activation_digits", "activationDigits", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    activation_digits: str = Field(type=str, required=False, mutable=False)


class ServiceProviderInCallServiceActivationModifyRequest17(OCIRequest):
    """
    Modifies the service provider's DTMF based in-call service activation trigger
    attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        flash_activation_digits: flashActivationDigits
        call_transfer_activation_digits: callTransferActivationDigits
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("flash_activation_digits", "flashActivationDigits", str),
        E("call_transfer_activation_digits", "callTransferActivationDigits", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    flash_activation_digits: str = Field(type=str, required=False, mutable=False)
    call_transfer_activation_digits: str = Field(type=str, required=False, mutable=False)


class ServiceProviderIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the service provider.

    The response is either ``ServiceProviderIntegratedIMPGetResponse()`` or
    ``ErrorResponse()``. Replaced by: ``ServiceProviderIntegratedIMPGetRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderIntegratedIMPGetRequest21(OCIRequest):
    """
    Get the Integrated IMP service attributes for the service provider.

    The response is either ``ServiceProviderIntegratedIMPGetResponse21()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_system_service_domain: useSystemServiceDomain
        service_domain: serviceDomain
        service_port: servicePort
        use_system_messaging_server: useSystemMessagingServer
        provisioning_url: provisioningUrl
        provisioning_user_id: provisioningUserId
        provisioning_password: provisioningPassword
        bosh_url: boshURL
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_system_service_domain", "useSystemServiceDomain", bool),
        E("service_domain", "serviceDomain", str),
        E("service_port", "servicePort", int),
        E("use_system_messaging_server", "useSystemMessagingServer", bool),
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("provisioning_password", "provisioningPassword", str),
        E("bosh_url", "boshURL", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_system_service_domain: bool = Field(type=bool, required=False, mutable=False)
    service_domain: str = Field(type=str, required=False, mutable=False)
    service_port: int = Field(type=int, required=False, mutable=False)
    use_system_messaging_server: bool = Field(type=bool, required=False, mutable=False)
    provisioning_url: str = Field(type=str, required=False, mutable=False)
    provisioning_user_id: str = Field(type=str, required=False, mutable=False)
    provisioning_password: str = Field(type=str, required=False, mutable=False)
    bosh_url: str = Field(type=str, required=False, mutable=False)


class ServiceProviderLDAPIntegrationGetDirectoryRequest(OCIRequest):
    """
    Get the LDAP directory attributes for a service provider.

    The response is either a ``ServiceProviderLDAPIntegrationGetDirectoryResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderLDAPIntegrationModifyDirectoryRequest(OCIRequest):
    """
    Modify the LDAP directory attributes for a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        server_net_address: serverNetAddress
        server_port: serverPort
        search_base: searchBase
        use_ssl: useSSL
        require_authentication: requireAuthentication
        authenticated_dn: authenticatedDN
        authenticated_password: authenticatedPassword
        is_sort_enabled: isSortEnabled
        is_paged_result_enabled: isPagedResultEnabled
        search_filter: searchFilter
        include_search_attribute_in_search_filter: includeSearchAttributeInSearchFilter
        column1_attribute_name: column1AttributeName
        column2_attribute_name: column2AttributeName
        column3_attribute_name: column3AttributeName
        column4_attribute_name: column4AttributeName
        column1_label: column1Label
        column2_label: column2Label
        column3_label: column3Label
        column4_label: column4Label
        search_column: searchColumn
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("server_net_address", "serverNetAddress", str),
        E("server_port", "serverPort", int),
        E("search_base", "searchBase", str),
        E("use_ssl", "useSSL", bool),
        E("require_authentication", "requireAuthentication", bool),
        E("authenticated_dn", "authenticatedDN", str),
        E("authenticated_password", "authenticatedPassword", str),
        E("is_sort_enabled", "isSortEnabled", bool),
        E("is_paged_result_enabled", "isPagedResultEnabled", bool),
        E("search_filter", "searchFilter", str),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter", bool,
        ),
        E("column1_attribute_name", "column1AttributeName", str),
        E("column2_attribute_name", "column2AttributeName", str),
        E("column3_attribute_name", "column3AttributeName", str),
        E("column4_attribute_name", "column4AttributeName", str),
        E("column1_label", "column1Label", str),
        E("column2_label", "column2Label", str),
        E("column3_label", "column3Label", str),
        E("column4_label", "column4Label", str),
        E("search_column", "searchColumn", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    server_net_address: str = Field(type=str, required=False, mutable=False)
    server_port: int = Field(type=int, required=False, mutable=False)
    search_base: str = Field(type=str, required=False, mutable=False)
    use_ssl: bool = Field(type=bool, required=False, mutable=False)
    require_authentication: bool = Field(type=bool, required=False, mutable=False)
    authenticated_dn: str = Field(type=str, required=False, mutable=False)
    authenticated_password: str = Field(type=str, required=False, mutable=False)
    is_sort_enabled: bool = Field(type=bool, required=False, mutable=False)
    is_paged_result_enabled: bool = Field(type=bool, required=False, mutable=False)
    search_filter: str = Field(type=str, required=False, mutable=False)
    include_search_attribute_in_search_filter: bool = Field(
        type=bool, required=False, mutable=False,
    )
    column1_attribute_name: str = Field(type=str, required=False, mutable=False)
    column2_attribute_name: str = Field(type=str, required=False, mutable=False)
    column3_attribute_name: str = Field(type=str, required=False, mutable=False)
    column4_attribute_name: str = Field(type=str, required=False, mutable=False)
    column1_label: str = Field(type=str, required=False, mutable=False)
    column2_label: str = Field(type=str, required=False, mutable=False)
    column3_label: str = Field(type=str, required=False, mutable=False)
    column4_label: str = Field(type=str, required=False, mutable=False)
    search_column: int = Field(type=int, required=False, mutable=False)


class ServiceProviderLanguageAddRequest(OCIRequest):
    """
    Request to add a language for a service provder.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        language: language
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageDeleteRequest(OCIRequest):
    """
    Request to delete a language from a service provider supported languages.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        language: language
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageGetAvailableListRequest(OCIRequest):
    """
    Request the list of languages that a user or admin in a service provider is allowed to
    use.

    The list will either be the system or service provider languages list, depending on
    the useServiceProviderLanguages flag.

    The response is either a ``ServiceProviderLanguageGetAvailableListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageGetListRequest(OCIRequest):
    """
    Request the defined languages for a service provider.

    The response is either a ``ServiceProviderLanguageGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderLanguageModifyRequest(OCIRequest):
    """
    Request to modify a language properties for a service provider/enterprise.

    If the becomeDefaultLanguage element is present, the language in this request Becomes
    the default language for the service provider/enterprise.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        language: language
        become_default_language: becomeDefaultLanguage
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("become_default_language", "becomeDefaultLanguage", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    become_default_language: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        language: language
        type: type
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    type: str = Field(type=str, required=True, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.

    The response is either a
    ``ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        language: language
        type: type
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("language", "language", str, is_required=True),
        E("type", "type", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=True, mutable=False)
    type: str = Field(type=str, required=True, mutable=False)


class ServiceProviderMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Request the service provider level data associated with MWI Delivery to Mobile
    Endpoint service.

    The response is either a ``ServiceProviderMWIDeliveryToMobileEndpointGetResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderMaliciousCallTraceGetRequest(OCIRequest):
    """
    Get the service provider's Malicious Call Trace settings.

    The response is either a ``ServiceProviderMaliciousCallTraceGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderMaliciousCallTraceModifyRequest(OCIRequest):
    """
    Modify the service provider's Malicious Call Trace settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_system_play_mct_warning_announcement: useSystemPlayMCTWarningAnnouncement
        play_mct_warning_announcement: playMCTWarningAnnouncement
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "use_system_play_mct_warning_announcement",
            "useSystemPlayMCTWarningAnnouncement", bool,
        ),
        E("play_mct_warning_announcement", "playMCTWarningAnnouncement", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_system_play_mct_warning_announcement: bool = Field(
        type=bool, required=False, mutable=False,
    )
    play_mct_warning_announcement: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the service provider/enterprise level data associated with Meet-Me
    Conferencing functions.

    The response is either a ``ServiceProviderMeetMeConferencingGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a service provider.

    The Element defaultNetworkClassOfService is required only for the first assignment,
    for subsequent assignments it is optional.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        network_class_of_service: networkClassOfService
        default_network_class_of_service: defaultNetworkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: "List[str]" = Field(type=list, required=False, mutable=False)
    default_network_class_of_service: str = Field(type=str, required=False, mutable=False)


class ServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to all groups with in a service provider.

    If it is the first assigned Network Class of Service in the group, it will be set as
    the default one.  The Network Classes of Service must be currently assigned to the
    service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        network_class_of_service: networkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: str = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a service provider.

    This will also assign the Network Class of Service to all the groups in the service
    provider if it is not assigned yet.  If it is the first assigned Network Class of
    Service in the group, it will be set as the default one.  However, the Network Classes
    of Service must be currently assigned to the service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        network_class_of_service: networkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: str = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a service provider.

    The response is either a
    ``ServiceProviderNetworkClassOfServiceGetAssignedListResponse()`` or an
    ``ErorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a Service Provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        network_class_of_service: networkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: str = Field(type=str, required=True, mutable=False)


class ServiceProviderNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        network_class_of_service: networkClassOfService
        default_network_class_of_service: defaultNetworkClassOfService
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("network_class_of_service", "networkClassOfService", str, is_array=True),
        E("default_network_class_of_service", "defaultNetworkClassOfService", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    network_class_of_service: "List[str]" = Field(type=list, required=False, mutable=False)
    default_network_class_of_service: str = Field(type=str, required=False, mutable=False)


class ServiceProviderNumberPortabilityQueryAddListRequest(OCIRequest):
    """
    Add a list of the Service Provider Number Portability Query Digit Patterns.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        digit_pattern: digitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("digit_pattern", "digitPattern", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    digit_pattern: str = Field(type=str, required=True, mutable=False)


class ServiceProviderNumberPortabilityQueryModifyRequest(OCIRequest):
    """
    Modify the Service Provider Number Portability Query information.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enable_number_portability_query_for_outgoing_calls:
            enableNumberPortabilityQueryForOutgoingCalls
        enable_number_portability_query_for_incoming_calls:
            enableNumberPortabilityQueryForIncomingCalls
        enable_number_portability_query_for_network_calls_only:
            enableNumberPortabilityQueryForNetworkCallsOnly
        delete_digit_pattern: deleteDigitPattern
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E(
            "enable_number_portability_query_for_outgoing_calls",
            "enableNumberPortabilityQueryForOutgoingCalls", bool,
        ),
        E(
            "enable_number_portability_query_for_incoming_calls",
            "enableNumberPortabilityQueryForIncomingCalls", bool,
        ),
        E(
            "enable_number_portability_query_for_network_calls_only",
            "enableNumberPortabilityQueryForNetworkCallsOnly", bool,
        ),
        E("delete_digit_pattern", "deleteDigitPattern", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enable_number_portability_query_for_outgoing_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_number_portability_query_for_incoming_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_number_portability_query_for_network_calls_only: bool = Field(
        type=bool, required=False, mutable=False,
    )
    delete_digit_pattern: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderOfficeZoneAssignListRequest(OCIRequest):
    """
    Assign a list of Office Zones to a service provider.

    The Element defaultOfficeZone is required only for the first assignment, for
    subsequent assignments it is optional.  Office Zones can only be assigned if the
    Location-Based Calling Restrictions has been authorized to the service provider
    otherwise the request will fail.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        office_zone_name: officeZoneName
        default_office_zone_name: defaultOfficeZoneName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    office_zone_name: "List[str]" = Field(type=list, required=False, mutable=False)
    default_office_zone_name: str = Field(type=str, required=False, mutable=False)


class ServiceProviderOfficeZoneGetAssignedListRequest(OCIRequest):
    """
    Get a list of Office Zones assigned to a service provider.

    The response is either a ``ServiceProviderOfficeZoneGetAssignedListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderOfficeZoneUnassignListRequest(OCIRequest):
    """
    Unassign a list of OfficeZones from a service provider.

    Note: a new default must be provided if unassigning the current default.  Office Zones
    can only be unassigned if the Location-Based Calling Restrictions has been authorized
    to the service provider otherwise the request will fail.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        office_zone_name: officeZoneName
        default_office_zone_name: defaultOfficeZoneName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("office_zone_name", "officeZoneName", str, is_array=True),
        E("default_office_zone_name", "defaultOfficeZoneName", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    office_zone_name: "List[str]" = Field(type=list, required=False, mutable=False)
    default_office_zone_name: str = Field(type=str, required=False, mutable=False)


class ServiceProviderPasswordRulesGetRequest13mp2(OCIRequest):
    """
    Requests the service provider's password rules setting applicable to Administrators
    (Group and Department) and Users.

    The response is either ``ServiceProviderPasswordRulesGetResponse13mp2()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPasswordRulesGetRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPasswordRulesGetRequest16(OCIRequest):
    """
    Requests the service provider's password rules setting applicable to Administrators
    (Group and Department) and Users.

    The response is either ``ServiceProviderPasswordRulesGetResponse16()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider's password rules settings setting applicable to
    Administrators (Group and Department) and Users.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPasswordRulesModifyRequest14sp3()``

    Attributes:
        service_provider_id: serviceProviderId
        rules_apply_to: rulesApplyTo
        allow_web_add_external_authentication_users:
            allowWebAddExternalAuthenticationUsers
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_rules_modification: disallowRulesModification
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("rules_apply_to", "rulesApplyTo", str),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool,
        ),
        E("disallow_user_id", "disallowUserId", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("password_expires_days", "passwordExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_rules_modification", "disallowRulesModification", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    rules_apply_to: str = Field(type=str, required=False, mutable=False)
    allow_web_add_external_authentication_users: bool = Field(
        type=bool, required=False, mutable=False,
    )
    disallow_user_id: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=False, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=False, mutable=False)
    min_digits: int = Field(type=int, required=False, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=False, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=False, mutable=False)
    min_length: int = Field(type=int, required=False, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    password_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_rules_modification: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderPasswordRulesModifyRequest14sp3(OCIRequest):
    """
    Request to modify the service provider's password rules settings setting applicable to
    Administrators (Group and Department) and Users.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        rules_apply_to: rulesApplyTo
        allow_web_add_external_authentication_users:
            allowWebAddExternalAuthenticationUsers
        disallow_user_id: disallowUserId
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        max_failed_login_attempts: maxFailedLoginAttempts
        password_expires_days: passwordExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
        disallow_previous_passwords: disallowPreviousPasswords
        number_of_previous_passwords: numberOfPreviousPasswords
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("rules_apply_to", "rulesApplyTo", str),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers", bool,
        ),
        E("disallow_user_id", "disallowUserId", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("password_expires_days", "passwordExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
        E("disallow_previous_passwords", "disallowPreviousPasswords", bool),
        E("number_of_previous_passwords", "numberOfPreviousPasswords", int),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    rules_apply_to: str = Field(type=str, required=False, mutable=False)
    allow_web_add_external_authentication_users: bool = Field(
        type=bool, required=False, mutable=False,
    )
    disallow_user_id: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=False, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=False, mutable=False)
    min_digits: int = Field(type=int, required=False, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=False, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=False, mutable=False)
    min_length: int = Field(type=int, required=False, mutable=False)
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    password_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)
    disallow_previous_passwords: bool = Field(type=bool, required=False, mutable=False)
    number_of_previous_passwords: int = Field(type=int, required=False, mutable=False)


class ServiceProviderPortalPasscodeRulesGetRequest(OCIRequest):
    """
    Requests the service provider's passcode rules setting.

    The response is either ``ServiceProviderPortalPasscodeRulesGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPortalPasscodeRulesGetRequest19(OCIRequest):
    """
    Requests the service provider's passcode rules setting.

    The response is either ``ServiceProviderPortalPasscodeRulesGetResponse19()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPortalPasscodeRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider's passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in AS data mode: numberOfRepeatedDigits
    disallowRepeatedPatterns disallowContiguousSequences numberOfAscendingDigits
    numberOfDescendingDigits numberOfPreviousPasscodes

    Attributes:
        service_provider_id: serviceProviderId
        disallow_repeated_digits: disallowRepeatedDigits
        number_of_repeated_digits: numberOfRepeatedDigits
        disallow_repeated_patterns: disallowRepeatedPatterns
        disallow_contiguous_sequences: disallowContiguousSequences
        number_of_ascending_digits: numberOfAscendingDigits
        number_of_descending_digits: numberOfDescendingDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        number_of_previous_passcodes: numberOfPreviousPasscodes
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("number_of_repeated_digits", "numberOfRepeatedDigits", int),
        E("disallow_repeated_patterns", "disallowRepeatedPatterns", bool),
        E("disallow_contiguous_sequences", "disallowContiguousSequences", bool),
        E("number_of_ascending_digits", "numberOfAscendingDigits", int),
        E("number_of_descending_digits", "numberOfDescendingDigits", int),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("number_of_previous_passcodes", "numberOfPreviousPasscodes", int),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=False, mutable=False)
    number_of_repeated_digits: int = Field(type=int, required=False, mutable=False)
    disallow_repeated_patterns: bool = Field(type=bool, required=False, mutable=False)
    disallow_contiguous_sequences: bool = Field(type=bool, required=False, mutable=False)
    number_of_ascending_digits: int = Field(type=int, required=False, mutable=False)
    number_of_descending_digits: int = Field(type=int, required=False, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    number_of_previous_passcodes: int = Field(type=int, required=False, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    min_code_length: int = Field(type=int, required=False, mutable=False)
    max_code_length: int = Field(type=int, required=False, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=False, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class ServiceProviderPreferredCarrierAddRequest(OCIRequest):
    """
    Add the country code preferred carriers for a service provider or enterprise.

    For each combination of service provider and country code, you can assign an intra-
    lata, inter-lata, and international carrier.  Each of the three types of carriers is
    optional.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Note: At the
    system level, more than one carrier may be assigned to each country code.  At the
    service provider level, you must choose from the carriers assigned at the system
    level.

    Attributes:
        service_provider_id: serviceProviderId
        country_code: countryCode
        intra_lata_carrier: intraLataCarrier
        inter_lata_carrier: interLataCarrier
        international_carrier: internationalCarrier
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("intra_lata_carrier", "intraLataCarrier", str),
        E("inter_lata_carrier", "interLataCarrier", str),
        E("international_carrier", "internationalCarrier", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    intra_lata_carrier: str = Field(type=str, required=False, mutable=False)
    inter_lata_carrier: str = Field(type=str, required=False, mutable=False)
    international_carrier: str = Field(type=str, required=False, mutable=False)


class ServiceProviderPreferredCarrierDeleteRequest(OCIRequest):
    """
    Delete the country code preferred carriers for a service provider or enterprise.

    Note that this is different from unassigning all 3 types of carriers with the
    ``ServiceProviderPreferredCarrierModifyRequest()``.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. An
    ``ErrorResponse()`` will be returned if the country code preferred carriers were never
    added or were already deleted.

    Attributes:
        service_provider_id: serviceProviderId
        country_code: countryCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest(OCIRequest):
    """
    Requests the default country code and the list of unused country codes for a service
    provider / enterprise.

    The response is either a
    ``ServiceProviderPreferredCarrierGetAvailableCountryCodeListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetCarrierListRequest(OCIRequest):
    """
    Requests the lists of carriers for a specified country code for a service provider /
    enterprise.

    The response is either a ``ServiceProviderPreferredCarrierGetCarrierListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        country_code: countryCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetListRequest(OCIRequest):
    """
    Requests a table of all the carriers defined in a specified service provider or
    enterprise.

    The response is either a ``ServiceProviderPreferredCarrierGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierGetRequest(OCIRequest):
    """
    Requests the currently configured carriers for a specified country code for a service
    provider / enterprise.

    The response is either a ``ServiceProviderPreferredCarrierGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        country_code: countryCode
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)


class ServiceProviderPreferredCarrierModifyRequest(OCIRequest):
    """
    Modify the country code preferred carriers for a service provider or enterprise.

    For each combination of service provider and country code, you can assign an intra-
    lata, inter-lata, and international carrier.  Each of the 3 types of carriers is
    optional.  If an optional carrier is not specified, the assignment will not change.
    To clear a preferred carrier, set the value to an empty string.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Note: At the
    system level, more than one carrier may be assigned to each country code.  At the
    service provider level, you must choose from the carriers assigned at the system
    level.

    Attributes:
        service_provider_id: serviceProviderId
        country_code: countryCode
        intra_lata_carrier: intraLataCarrier
        inter_lata_carrier: interLataCarrier
        international_carrier: internationalCarrier
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("intra_lata_carrier", "intraLataCarrier", str),
        E("inter_lata_carrier", "interLataCarrier", str),
        E("international_carrier", "internationalCarrier", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    intra_lata_carrier: str = Field(type=str, required=False, mutable=False)
    inter_lata_carrier: str = Field(type=str, required=False, mutable=False)
    international_carrier: str = Field(type=str, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeActivateListRequest(OCIRequest):
    """
    Activate number ranges in a service provider.

    It is not an error to activate an already activated number range.  The command fails
    if executed when system level enterprise trunk number range activation is disabled.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        number_range_start: numberRangeStart
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    number_range_start: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeDeactivateListRequest(OCIRequest):
    """
    Deactivate number ranges in a service provider.

    It is not an error to deactivate an already deactivated number range.  The command
    fails if executed when system level enterprise trunk number range activation is
    disabled.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        number_range_start: numberRangeStart
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    number_range_start: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeDeleteListRequest(OCIRequest):
    """
    Delete number ranges from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        number_range_start: numberRangeStart
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("number_range_start", "numberRangeStart", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    number_range_start: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of available number ranges not yet assigned to any group.

    The response is either
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number ranges in the service provider.

    The response is either
    ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemAssignListRequest(OCIRequest):
    """
    Assign a list of route point external systems to a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        route_point_external_system: routePointExternalSystem
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    route_point_external_system: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderRoutePointExternalSystemGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all Route Point External Systems assigned to a service provider.

    The response is either
    ``ServiceProviderRoutePointExternalSystemGetAssignedListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderRoutePointExternalSystemUnassignListRequest(OCIRequest):
    """
    Unassign a list of route point external systems from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        route_point_external_system: routePointExternalSystem
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("route_point_external_system", "routePointExternalSystem", str, is_array=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    route_point_external_system: "List[str]" = Field(type=list, required=False, mutable=False)


class ServiceProviderRoutingProfileGetRequest(OCIRequest):
    """
    Request the routing profile for the service provider/enterprise.

    The response is either a ``ServiceProviderRoutingProfileGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderRoutingProfileModifyRequest(OCIRequest):
    """
    Requests to modify the routing profile for a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        routing_profile: routingProfile
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("routing_profile", "routingProfile", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    routing_profile: str = Field(type=str, required=False, mutable=False)


class ServiceProviderSIPAuthenticationPasswordRulesGetRequest(OCIRequest):
    """
    Request to get the service provider level SIP authentication password rule settings.

    The response is either a
    ``ServiceProviderSIPAuthenticationPasswordRulesGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderSIPAuthenticationPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider level SIP authentication password rule
    settings.

    The useServiceProviderSettings element can only be modified by a system administrator
    or a provisioning administrator.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        use_service_provider_settings: useServiceProviderSettings
        disallow_authentication_name: disallowAuthenticationName
        disallow_old_password: disallowOldPassword
        disallow_reversed_old_password: disallowReversedOldPassword
        restrict_min_digits: restrictMinDigits
        min_digits: minDigits
        restrict_min_upper_case_letters: restrictMinUpperCaseLetters
        min_upper_case_letters: minUpperCaseLetters
        restrict_min_lower_case_letters: restrictMinLowerCaseLetters
        min_lower_case_letters: minLowerCaseLetters
        restrict_min_non_alphanumeric_characters: restrictMinNonAlphanumericCharacters
        min_non_alphanumeric_characters: minNonAlphanumericCharacters
        min_length: minLength
        send_permanent_lockout_notification: sendPermanentLockoutNotification
        permanent_lockout_notify_email_address: permanentLockoutNotifyEmailAddress
        endpoint_authentication_lockout_type: endpointAuthenticationLockoutType
        endpoint_temporary_lockout_threshold: endpointTemporaryLockoutThreshold
        endpoint_wait_algorithm: endpointWaitAlgorithm
        endpoint_lockout_fixed_minutes: endpointLockoutFixedMinutes
        endpoint_permanent_lockout_threshold: endpointPermanentLockoutThreshold
        trunk_group_authentication_lockout_type: trunkGroupAuthenticationLockoutType
        trunk_group_temporary_lockout_threshold: trunkGroupTemporaryLockoutThreshold
        trunk_group_wait_algorithm: trunkGroupWaitAlgorithm
        trunk_group_lockout_fixed_minutes: trunkGroupLockoutFixedMinutes
        trunk_group_permanent_lockout_threshold: trunkGroupPermanentLockoutThreshold
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("use_service_provider_settings", "useServiceProviderSettings", bool),
        E("disallow_authentication_name", "disallowAuthenticationName", bool),
        E("disallow_old_password", "disallowOldPassword", bool),
        E("disallow_reversed_old_password", "disallowReversedOldPassword", bool),
        E("restrict_min_digits", "restrictMinDigits", bool),
        E("min_digits", "minDigits", int),
        E("restrict_min_upper_case_letters", "restrictMinUpperCaseLetters", bool),
        E("min_upper_case_letters", "minUpperCaseLetters", int),
        E("restrict_min_lower_case_letters", "restrictMinLowerCaseLetters", bool),
        E("min_lower_case_letters", "minLowerCaseLetters", int),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters", bool,
        ),
        E("min_non_alphanumeric_characters", "minNonAlphanumericCharacters", int),
        E("min_length", "minLength", int),
        E("send_permanent_lockout_notification", "sendPermanentLockoutNotification", bool),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress", str,
        ),
        E("endpoint_authentication_lockout_type", "endpointAuthenticationLockoutType", str),
        E("endpoint_temporary_lockout_threshold", "endpointTemporaryLockoutThreshold", int),
        E("endpoint_wait_algorithm", "endpointWaitAlgorithm", str),
        E("endpoint_lockout_fixed_minutes", "endpointLockoutFixedMinutes", str),
        E("endpoint_permanent_lockout_threshold", "endpointPermanentLockoutThreshold", int),
        E(
            "trunk_group_authentication_lockout_type",
            "trunkGroupAuthenticationLockoutType", str,
        ),
        E(
            "trunk_group_temporary_lockout_threshold",
            "trunkGroupTemporaryLockoutThreshold", int,
        ),
        E("trunk_group_wait_algorithm", "trunkGroupWaitAlgorithm", str),
        E("trunk_group_lockout_fixed_minutes", "trunkGroupLockoutFixedMinutes", str),
        E(
            "trunk_group_permanent_lockout_threshold",
            "trunkGroupPermanentLockoutThreshold", int,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    use_service_provider_settings: bool = Field(type=bool, required=False, mutable=False)
    disallow_authentication_name: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_password: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_password: bool = Field(type=bool, required=False, mutable=False)
    restrict_min_digits: bool = Field(type=bool, required=False, mutable=False)
    min_digits: int = Field(type=int, required=False, mutable=False)
    restrict_min_upper_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_upper_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_lower_case_letters: bool = Field(type=bool, required=False, mutable=False)
    min_lower_case_letters: int = Field(type=int, required=False, mutable=False)
    restrict_min_non_alphanumeric_characters: bool = Field(
        type=bool, required=False, mutable=False,
    )
    min_non_alphanumeric_characters: int = Field(type=int, required=False, mutable=False)
    min_length: int = Field(type=int, required=False, mutable=False)
    send_permanent_lockout_notification: bool = Field(
        type=bool, required=False, mutable=False,
    )
    permanent_lockout_notify_email_address: str = Field(
        type=str, required=False, mutable=False,
    )
    endpoint_authentication_lockout_type: str = Field(type=str, required=False, mutable=False)
    endpoint_temporary_lockout_threshold: int = Field(type=int, required=False, mutable=False)
    endpoint_wait_algorithm: str = Field(type=str, required=False, mutable=False)
    endpoint_lockout_fixed_minutes: str = Field(type=str, required=False, mutable=False)
    endpoint_permanent_lockout_threshold: int = Field(type=int, required=False, mutable=False)
    trunk_group_authentication_lockout_type: str = Field(
        type=str, required=False, mutable=False,
    )
    trunk_group_temporary_lockout_threshold: int = Field(
        type=int, required=False, mutable=False,
    )
    trunk_group_wait_algorithm: str = Field(type=str, required=False, mutable=False)
    trunk_group_lockout_fixed_minutes: str = Field(type=str, required=False, mutable=False)
    trunk_group_permanent_lockout_threshold: int = Field(
        type=int, required=False, mutable=False,
    )


class ServiceProviderScheduleAddRequest(OCIRequest):
    """
    Add a service provider schedule.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        schedule_name: scheduleName
        schedule_type: scheduleType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("schedule_name", "scheduleName", str, is_required=True),
        E("schedule_type", "scheduleType", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    schedule_name: str = Field(type=str, required=True, mutable=False)
    schedule_type: str = Field(type=str, required=True, mutable=False)


class ServiceProviderScheduleGetListRequest(OCIRequest):
    """
    Get the list of a service provider schedules.

    The list can be filtered by schedule type.

    The response is either a ``ServiceProviderScheduleGetListResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        schedule_type: scheduleType
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("schedule_type", "scheduleType", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    schedule_type: str = Field(type=str, required=False, mutable=False)


class ServiceProviderServiceGetAuthorizationListRequest(OCIRequest):
    """
    Requests the service provider's service authorization status.

    The response is either ``ServiceProviderServiceGetAuthorizationListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServiceGetUserAssignableListRequest(OCIRequest):
    """
    Requests the list of all user services assignable to users in the specified service
    provider.

    The response is either ``ServiceProviderServiceGetUserAssignableListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackAddServiceListRequest(OCIRequest):
    """
    Request to add services to a service pack if the pack has not been authorized to a
    group.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        service_pack_name: servicePackName
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_pack_name", "servicePackName", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    service_pack_name: str = Field(type=str, required=True, mutable=False)
    service_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackDeleteRequest(OCIRequest):
    """
    Request to delete a service pack from a service provider.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_pack_name", "servicePackName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    service_pack_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetDetailListRequest(OCIRequest):
    """
    Request to get a service pack details.

    The response is either ``ServiceProviderServicePackGetDetailListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        service_pack_name: servicePackName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_pack_name", "servicePackName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    service_pack_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetListRequest(OCIRequest):
    """
    Request to get a list of defined service packs for a service provider.

    The response is either ``ServiceProviderServicePackGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetServiceUsageListRequest(OCIRequest):
    """
    Request to get the list of service packs containing a specified service.

    The response is either ``ServiceProviderServicePackGetServiceUsageListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        service_name: serviceName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_name", "serviceName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    service_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackGetUtilizationListRequest(OCIRequest):
    """
    Request to get the service pack utilization for a service provider.

    For each service pack, a table of groups utilizing the pack is returned.

    The response is either ``ServiceProviderServicePackGetUtilizationListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskAddRequest(OCIRequest):
    """
    Create a service pack migration task.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskAddRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
        start_timestamp: startTimestamp
        max_duration_hours: maxDurationHours
        send_report_email: sendReportEmail
        report_delivery_email_address: reportDeliveryEmailAddress
        abort_on_error: abortOnError
        abort_error_threshold: abortErrorThreshold
        report_all_users: reportAllUsers
        automatically_increment_service_quantity: automaticallyIncrementServiceQuantity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str, is_required=True),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)
    start_timestamp: str = Field(type=str, required=True, mutable=False)
    max_duration_hours: int = Field(type=int, required=True, mutable=False)
    send_report_email: bool = Field(type=bool, required=True, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)
    abort_on_error: bool = Field(type=bool, required=True, mutable=False)
    abort_error_threshold: int = Field(type=int, required=False, mutable=False)
    report_all_users: bool = Field(type=bool, required=True, mutable=False)
    automatically_increment_service_quantity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderServicePackMigrationTaskAddRequest21(OCIRequest):
    """
    Create a service pack migration task.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
        start_timestamp: startTimestamp
        expire_after_num_hours: expireAfterNumHours
        max_duration_hours: maxDurationHours
        send_report_email: sendReportEmail
        report_delivery_email_address: reportDeliveryEmailAddress
        abort_on_error: abortOnError
        abort_error_threshold: abortErrorThreshold
        report_all_users: reportAllUsers
        automatically_increment_service_quantity: automaticallyIncrementServiceQuantity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("start_timestamp", "startTimestamp", str, is_required=True),
        E("expire_after_num_hours", "expireAfterNumHours", int, is_required=True),
        E("max_duration_hours", "maxDurationHours", int, is_required=True),
        E("send_report_email", "sendReportEmail", bool, is_required=True),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool, is_required=True),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool, is_required=True),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool, is_required=True,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)
    start_timestamp: str = Field(type=str, required=True, mutable=False)
    expire_after_num_hours: int = Field(type=int, required=True, mutable=False)
    max_duration_hours: int = Field(type=int, required=True, mutable=False)
    send_report_email: bool = Field(type=bool, required=True, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)
    abort_on_error: bool = Field(type=bool, required=True, mutable=False)
    abort_error_threshold: int = Field(type=int, required=False, mutable=False)
    report_all_users: bool = Field(type=bool, required=True, mutable=False)
    automatically_increment_service_quantity: bool = Field(
        type=bool, required=True, mutable=False,
    )


class ServiceProviderServicePackMigrationTaskCopyRequest(OCIRequest):
    """
    Makes a copy of one or more existing service pack migration tasks.

    A copied task can be edited with other commands and scheduled for future execution.
    The name of the new task is chosen automatically.  The name will be "Copy (number) of
    taskName".

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskDeleteRequest(OCIRequest):
    """
    Deletes a service pack migration task.

    It is not possible to delete a task while it is currently executing.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListRequest(OCIRequest):
    """
    Requests a list of all service pack migration task for a service provider.

    The response is either ``ServiceProviderServicePackMigrationTaskGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetListRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetListRequest21(OCIRequest):
    """
    Requests a list of all service pack migration tasks for a service provider.

    The response is either ``ServiceProviderServicePackMigrationTaskGetListResponse21()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetRequest(OCIRequest):
    """
    Requests the details of a specified service pack migration task.

    The response is either ``ServiceProviderServicePackMigrationTaskGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetRequest14sp4()``

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetRequest14sp4(OCIRequest):
    """
    Requests the details of a specified service pack migration task.

    The response is either ``ServiceProviderServicePackMigrationTaskGetResponse14sp4()``
    or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderServicePackMigrationTaskGetRequest21()``

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskGetRequest21(OCIRequest):
    """
    Requests the details of a specified service pack migration task.

    The response is either ``ServiceProviderServicePackMigrationTaskGetResponse21()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePackMigrationTaskModifyGroupListRequest(OCIRequest):
    """
    Replace the list of groups to be migrated for a specified service pack migration task.

    Modification is only allowed prior to task execution.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
        migrate_all_groups: migrateAllGroups
        group_id_list: groupIdList
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("migrate_all_groups", "migrateAllGroups", bool),
        E("group_id_list", "groupIdList", str, is_complex=True),  # unknown
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)
    migrate_all_groups: bool = Field(type=bool, required=False, mutable=False)
    group_id_list: str = Field(type=str, required=False, mutable=False)


class ServiceProviderServicePackMigrationTaskModifyRequest(OCIRequest):
    """
    Modify the properties of a specified service pack migration task.

    Modification is only allowed prior to task execution.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
        new_task_name: newTaskName
        start_timestamp: startTimestamp
        expire_after_num_hours: expireAfterNumHours
        max_duration_hours: maxDurationHours
        send_report_email: sendReportEmail
        report_delivery_email_address: reportDeliveryEmailAddress
        abort_on_error: abortOnError
        abort_error_threshold: abortErrorThreshold
        report_all_users: reportAllUsers
        automatically_increment_service_quantity: automaticallyIncrementServiceQuantity
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
        E("new_task_name", "newTaskName", str),
        E("start_timestamp", "startTimestamp", str),
        E("expire_after_num_hours", "expireAfterNumHours", int),
        E("max_duration_hours", "maxDurationHours", int),
        E("send_report_email", "sendReportEmail", bool),
        E("report_delivery_email_address", "reportDeliveryEmailAddress", str),
        E("abort_on_error", "abortOnError", bool),
        E("abort_error_threshold", "abortErrorThreshold", int),
        E("report_all_users", "reportAllUsers", bool),
        E(
            "automatically_increment_service_quantity",
            "automaticallyIncrementServiceQuantity", bool,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)
    new_task_name: str = Field(type=str, required=False, mutable=False)
    start_timestamp: str = Field(type=str, required=False, mutable=False)
    expire_after_num_hours: int = Field(type=int, required=False, mutable=False)
    max_duration_hours: int = Field(type=int, required=False, mutable=False)
    send_report_email: bool = Field(type=bool, required=False, mutable=False)
    report_delivery_email_address: str = Field(type=str, required=False, mutable=False)
    abort_on_error: bool = Field(type=bool, required=False, mutable=False)
    abort_error_threshold: int = Field(type=int, required=False, mutable=False)
    report_all_users: bool = Field(type=bool, required=False, mutable=False)
    automatically_increment_service_quantity: bool = Field(
        type=bool, required=False, mutable=False,
    )


class ServiceProviderServicePackMigrationTaskTerminateRequest(OCIRequest):
    """
    Terminates a service pack migration task that is currently executing.

    Modification is only allowed prior to task execution.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        task_name: taskName
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("task_name", "taskName", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    task_name: str = Field(type=str, required=True, mutable=False)


class ServiceProviderServicePhoneNumberLookupRequest(OCIRequest):
    """
    Lookup if the given number is defined in the specified service in the service
    provider.

    The response is ``ServiceProviderServicePhoneNumberLookupResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        service_type: serviceType
        phone_number: phoneNumber
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("service_type", "serviceType", str, is_required=True),
        E("phone_number", "phoneNumber", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    service_type: str = Field(type=str, required=True, mutable=False)
    phone_number: str = Field(type=str, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlGetRequest(OCIRequest):
    """
    Get the session admission control capacity for the service provider.

    The response is either a ``ServiceProviderSessionAdmissionControlGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlModifyRequest(OCIRequest):
    """
    Request to modify session admission control capacity for the service provider.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        restrict_aggregate_sessions: restrictAggregateSessions
        max_sessions: maxSessions
        max_user_originating_sessions: maxUserOriginatingSessions
        max_user_terminating_sessions: maxUserTerminatingSessions
        count_intra_service_provider_sessions: countIntraServiceProviderSessions
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("restrict_aggregate_sessions", "restrictAggregateSessions", bool),
        E("max_sessions", "maxSessions", int),
        E("max_user_originating_sessions", "maxUserOriginatingSessions", int),
        E("max_user_terminating_sessions", "maxUserTerminatingSessions", int),
        E("count_intra_service_provider_sessions", "countIntraServiceProviderSessions", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    restrict_aggregate_sessions: bool = Field(type=bool, required=False, mutable=False)
    max_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_originating_sessions: int = Field(type=int, required=False, mutable=False)
    max_user_terminating_sessions: int = Field(type=int, required=False, mutable=False)
    count_intra_service_provider_sessions: bool = Field(
        type=bool, required=False, mutable=False,
    )


class ServiceProviderSessionAdmissionControlWhiteListGetRequest(OCIRequest):
    """
    Request to get the Service Provider Session Admission White List information.

    The response is either a
    ``ServiceProviderSessionAdmissionControlWhiteListGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderSessionAdmissionControlWhiteListModifyRequest(OCIRequest):
    """
    Modify the Service Provider Session Admission Control White List information.

    The number of digit pattern entries is limited to 100.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        add_match_digit_pattern: addMatchDigitPattern
        delete_match_digit_pattern: deleteMatchDigitPattern
        enable_white_list: enableWhiteList
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("add_match_digit_pattern", "addMatchDigitPattern", str),
        E("delete_match_digit_pattern", "deleteMatchDigitPattern", str),
        E("enable_white_list", "enableWhiteList", bool),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    add_match_digit_pattern: str = Field(type=str, required=False, mutable=False)
    delete_match_digit_pattern: str = Field(type=str, required=False, mutable=False)
    enable_white_list: bool = Field(type=bool, required=False, mutable=False)


class ServiceProviderTrunkGroupGetRequest(OCIRequest):
    """
    Get the maximum permissible active Trunk Group calls for the service provider.

    The response is either a ``ServiceProviderTrunkGroupGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderTrunkGroupGetRequest14sp1(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active Trunk Group calls for the
    service provider.

    The response is either a ``ServiceProviderTrunkGroupGetResponse14sp1()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetPasscodeRulesRequest(OCIRequest):
    """
    Requests the service provider's voice portal passcode rules setting.

    The response is either
    ``ServiceProviderVoiceMessagingGroupGetPasscodeRulesResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPortalPasscodeRulesGetRequest()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Requests the service provider's or enterprise's voice messaging settings.

    The response is either ``ServiceProviderVoiceMessagingGroupGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest(OCIRequest):
    """
    Get the service provider's voice portal branding settings.

    The response is either a
    ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16()``

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16(OCIRequest):
    """
    Get the service provider's voice portal branding settings.

    The response is either a
    ``ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingResponse16()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupGetVoicePortalRequest(OCIRequest):
    """
    Requests the service provider's or enterprise's voice portal settings.

    The response is either ``ServiceProviderVoiceMessagingGroupGetVoicePortalResponse()``
    or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderVoiceMessagingGroupModifyPasscodeRulesRequest(OCIRequest):
    """
    Request to modify the service provider's voice portal passcode rules setting.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``ServiceProviderPortalPasscodeRulesModifyRequest()``

    Attributes:
        service_provider_id: serviceProviderId
        disallow_repeated_digits: disallowRepeatedDigits
        disallow_user_number: disallowUserNumber
        disallow_reversed_user_number: disallowReversedUserNumber
        disallow_old_passcode: disallowOldPasscode
        disallow_reversed_old_passcode: disallowReversedOldPasscode
        min_code_length: minCodeLength
        max_code_length: maxCodeLength
        disable_login_after_max_failed_login_attempts:
            disableLoginAfterMaxFailedLoginAttempts
        max_failed_login_attempts: maxFailedLoginAttempts
        expire_password: expirePassword
        passcode_expires_days: passcodeExpiresDays
        send_login_disabled_notify_email: sendLoginDisabledNotifyEmail
        login_disabled_notify_email_address: loginDisabledNotifyEmailAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("disallow_repeated_digits", "disallowRepeatedDigits", bool),
        E("disallow_user_number", "disallowUserNumber", bool),
        E("disallow_reversed_user_number", "disallowReversedUserNumber", bool),
        E("disallow_old_passcode", "disallowOldPasscode", bool),
        E("disallow_reversed_old_passcode", "disallowReversedOldPasscode", bool),
        E("min_code_length", "minCodeLength", int),
        E("max_code_length", "maxCodeLength", int),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts", bool,
        ),
        E("max_failed_login_attempts", "maxFailedLoginAttempts", int),
        E("expire_password", "expirePassword", bool),
        E("passcode_expires_days", "passcodeExpiresDays", int),
        E("send_login_disabled_notify_email", "sendLoginDisabledNotifyEmail", bool),
        E("login_disabled_notify_email_address", "loginDisabledNotifyEmailAddress", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    disallow_repeated_digits: bool = Field(type=bool, required=False, mutable=False)
    disallow_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_user_number: bool = Field(type=bool, required=False, mutable=False)
    disallow_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    disallow_reversed_old_passcode: bool = Field(type=bool, required=False, mutable=False)
    min_code_length: int = Field(type=int, required=False, mutable=False)
    max_code_length: int = Field(type=int, required=False, mutable=False)
    disable_login_after_max_failed_login_attempts: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_failed_login_attempts: int = Field(type=int, required=False, mutable=False)
    expire_password: bool = Field(type=bool, required=False, mutable=False)
    passcode_expires_days: int = Field(type=int, required=False, mutable=False)
    send_login_disabled_notify_email: bool = Field(type=bool, required=False, mutable=False)
    login_disabled_notify_email_address: str = Field(type=str, required=False, mutable=False)


class ServiceProviderVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Request to modify a service provider's or enterprise's voice messaging settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        delivery_from_address: deliveryFromAddress
        notification_from_address: notificationFromAddress
        voice_portal_lockout_from_address: voicePortalLockoutFromAddress
        use_system_default_delivery_from_address: useSystemDefaultDeliveryFromAddress
        use_system_default_notification_from_address:
            useSystemDefaultNotificationFromAddress
        use_system_default_voice_portal_lockout_from_address:
            useSystemDefaultVoicePortalLockoutFromAddress
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("delivery_from_address", "deliveryFromAddress", str),
        E("notification_from_address", "notificationFromAddress", str),
        E("voice_portal_lockout_from_address", "voicePortalLockoutFromAddress", str),
        E(
            "use_system_default_delivery_from_address",
            "useSystemDefaultDeliveryFromAddress", bool,
        ),
        E(
            "use_system_default_notification_from_address",
            "useSystemDefaultNotificationFromAddress", bool,
        ),
        E(
            "use_system_default_voice_portal_lockout_from_address",
            "useSystemDefaultVoicePortalLockoutFromAddress", bool,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    delivery_from_address: str = Field(type=str, required=False, mutable=False)
    notification_from_address: str = Field(type=str, required=False, mutable=False)
    voice_portal_lockout_from_address: str = Field(type=str, required=False, mutable=False)
    use_system_default_delivery_from_address: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_system_default_notification_from_address: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_system_default_voice_portal_lockout_from_address: bool = Field(
        type=bool, required=False, mutable=False,
    )


class ServiceProviderVoiceMessagingGroupModifyVoicePortalRequest(OCIRequest):
    """
    Request to change the service provider's or enterprise's voice portal settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        voice_portal_scope: voicePortalScope
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("voice_portal_scope", "voicePortalScope", str),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    voice_portal_scope: str = Field(type=str, required=False, mutable=False)


class ServiceProviderZoneCallingRestrictionsGetRequest(OCIRequest):
    """
    Gets the Service Provider/Enterprise level Zone Calling Restrictions Policies.

    The response is ``ServiceProviderZoneCallingRestrictionsGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)


class ServiceProviderZoneCallingRestrictionsModifyRequest(OCIRequest):
    """
    Modifies the Service Provider/Enterprise level Zone Calling Restrictions Policies.

    The response is ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        service_provider_id: serviceProviderId
        enable_zone_calling_restrictions: enableZoneCallingRestrictions
        enable_origination_roaming_restrictions: enableOriginationRoamingRestrictions
        enable_emergency_origination_roaming_restrictions:
            enableEmergencyOriginationRoamingRestrictions
        enable_termination_roaming_restrictions: enableTerminationRoamingRestrictions
    """

    _ELEMENTS = (
        E("service_provider_id", "serviceProviderId", str, is_required=True),
        E("enable_zone_calling_restrictions", "enableZoneCallingRestrictions", bool),
        E(
            "enable_origination_roaming_restrictions",
            "enableOriginationRoamingRestrictions", bool,
        ),
        E(
            "enable_emergency_origination_roaming_restrictions",
            "enableEmergencyOriginationRoamingRestrictions", bool,
        ),
        E(
            "enable_termination_roaming_restrictions",
            "enableTerminationRoamingRestrictions", bool,
        ),
    )

    service_provider_id: str = Field(type=str, required=True, mutable=False)
    enable_zone_calling_restrictions: bool = Field(type=bool, required=False, mutable=False)
    enable_origination_roaming_restrictions: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_emergency_origination_roaming_restrictions: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_termination_roaming_restrictions: bool = Field(
        type=bool, required=False, mutable=False,
    )


class SystemASRParametersGetRequest(OCIRequest):
    """
    Request to get the list of Application Server Registration system parameters.

    The response is either ``SystemASRParametersGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemASRParametersGetRequest14sp5()``
    """

    _ELEMENTS = ()


class SystemASRParametersGetRequest14sp5(OCIRequest):
    """
    Request to get the list of Application Server Registration system parameters.

    The response is either ``SystemASRParametersGetResponse14sp5()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemASRParametersGetRequest14sp7(OCIRequest):
    """
    Request to get the list of Application Server Registration system parameters.

    The response is either ``SystemASRParametersGetResponse14sp7()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemASRParametersModifyRequest(OCIRequest):
    """
    Request to modify Application Server Registration system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        max_transmissions: maxTransmissions
        retransmission_delay_milli_seconds: retransmissionDelayMilliSeconds
        listening_port: listeningPort
        source_address: sourceAddress
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int),
        E("retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int),
        E("listening_port", "listeningPort", int),
        E("source_address", "sourceAddress", str),
    )

    max_transmissions: int = Field(type=int, required=False, mutable=False)
    retransmission_delay_milli_seconds: int = Field(type=int, required=False, mutable=False)
    listening_port: int = Field(type=int, required=False, mutable=False)
    source_address: str = Field(type=str, required=False, mutable=False)


class SystemASRParametersModifyRequest14sp7(OCIRequest):
    """
    Request to modify Application Server Registration system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        max_transmissions: maxTransmissions
        retransmission_delay_milli_seconds: retransmissionDelayMilliSeconds
        listening_port: listeningPort
    """

    _ELEMENTS = (
        E("max_transmissions", "maxTransmissions", int),
        E("retransmission_delay_milli_seconds", "retransmissionDelayMilliSeconds", int),
        E("listening_port", "listeningPort", int),
    )

    max_transmissions: int = Field(type=int, required=False, mutable=False)
    retransmission_delay_milli_seconds: int = Field(type=int, required=False, mutable=False)
    listening_port: int = Field(type=int, required=False, mutable=False)


class SystemAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a system access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a system access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        tag_name: tagName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device Management
    System, on a per-device profile basis.

    The response is either ``SystemAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a system access device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        tag_name: tagName
        tag_value: tagValue
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("tag_name", "tagName", str, is_required=True),
        E("tag_value", "tagValue", str),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    tag_name: str = Field(type=str, required=True, mutable=False)
    tag_value: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified system access device.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``SystemAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceFileGetListRequest14sp8()``

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System, on a
    per-device profile basis.

    The response is either ``SystemAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceFileGetRequest14sp8()``

    Attributes:
        device_name: deviceName
        file_type: fileType
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_type", "fileType", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    file_type: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``. Replaced by: ``SystemAccessDeviceFileGetRequest16sp1()``

    Attributes:
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a device profile file.

    The response is either ``SystemAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        file_format: fileFormat
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("file_format", "fileFormat", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    file_format: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceGetRequest14sp3()``

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse14sp3()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemAccessDeviceGetRequest14sp6()``

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse14sp6()`` or
    ``ErrorResponse()``. Replaced by: ``SystemAccessDeviceGetRequest16()``

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse16()`` or ``ErrorResponse()``.
    Replaced by: ``SystemAccessDeviceGetRequest19()``

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified system access device.

    The response is either ``SystemAccessDeviceGetResponse18sp1()`` or
    ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the system device profile.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. The following
    elements are only used in HSS data mode and ignored in AS data mode: privateIdentity

    Attributes:
        device_name: deviceName
        line_port: linePort
        private_identity: privateIdentity
        is_primary_line_port: isPrimaryLinePort
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("line_port", "linePort", str, is_required=True),
        E("private_identity", "privateIdentity", str),
        E("is_primary_line_port", "isPrimaryLinePort", bool),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    line_port: str = Field(type=str, required=True, mutable=False)
    private_identity: str = Field(type=str, required=False, mutable=False)
    is_primary_line_port: bool = Field(type=bool, required=False, mutable=False)


class SystemAccessDeviceMonitorAddDeviceTypeRequest(OCIRequest):
    """
    Add a device type to be monitored.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        add_all_device_types: addAllDeviceTypes
        device_type: deviceType
    """

    _ELEMENTS = (
        E("add_all_device_types", "addAllDeviceTypes", bool),
        E("device_type", "deviceType", str),
    )

    add_all_device_types: bool = Field(type=bool, required=False, mutable=False)
    device_type: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceMonitorDeleteDeviceTypeRequest(OCIRequest):
    """
    Remove a device type to be monitored.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        delete_all_device_types: deleteAllDeviceTypes
        device_type: deviceType
    """

    _ELEMENTS = (
        E("delete_all_device_types", "deleteAllDeviceTypes", bool),
        E("device_type", "deviceType", str),
    )

    delete_all_device_types: bool = Field(type=bool, required=False, mutable=False)
    device_type: str = Field(type=str, required=False, mutable=False)


class SystemAccessDeviceMonitorGetDeviceTypeListRequest(OCIRequest):
    """
    Get a list of monitored device types.

    The response is either a ``SystemAccessDeviceMonitorGetDeviceTypeListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccessDeviceMonitorParametersGetRequest(OCIRequest):
    """
    Request to get the list of Access Device Monitor system parameters.

    The response is either ``SystemAccessDeviceMonitorParametersGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccessDeviceMonitorParametersModifyRequest(OCIRequest):
    """
    Request to modify Access Device Monitor system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        polling_interval_minutes: pollingIntervalMinutes
    """

    _ELEMENTS = (
        E("polling_interval_minutes", "pollingIntervalMinutes", int),
    )

    polling_interval_minutes: int = Field(type=int, required=False, mutable=False)


class SystemAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific system SIP device that supports the reset operation.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemAccessDeviceTypeGetEnhancedConfigurableListRequest(OCIRequest):
    """
    Requests the list of device types supporting enhanced configuration.

    The response is either ``SystemAccessDeviceTypeGetEnhancedConfigurableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccessDeviceTypeGetListRequest(OCIRequest):
    """
    Requests the list of access device types.

    The response is either ``SystemAccessDeviceTypeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingAddChargingFunctionElementServerRequest(OCIRequest):
    """
    Request to add a ChargingFunctionElement Server to the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        address: address
        is_net_address_extended: isNetAddressExtended
        type: type
        description: description
    """

    _ELEMENTS = (
        E("address", "address", str, is_required=True),
        E("is_net_address_extended", "isNetAddressExtended", bool, is_required=True),
        E("type", "type", str, is_required=True),
        E("description", "description", str),
    )

    address: str = Field(type=str, required=True, mutable=False)
    is_net_address_extended: bool = Field(type=bool, required=True, mutable=False)
    type: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemAccountingAddRadiusServerRequest(OCIRequest):
    """
    Request to add a Radius Server to the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        net_address: netAddress
        port: port
        description: description
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("port", "port", int, is_required=True),
        E("description", "description", str),
    )

    net_address: str = Field(type=str, required=True, mutable=False)
    port: int = Field(type=int, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemAccountingDeleteChargingFunctionElementServerRequest(OCIRequest):
    """
    Request to delete a ChargingFunctionElementServer from the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        address: address
    """

    _ELEMENTS = (
        E("address", "address", str, is_required=True),
    )

    address: str = Field(type=str, required=True, mutable=False)


class SystemAccountingDeleteRadiusServerRequest(OCIRequest):
    """
    Request to delete a Radius Server from the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        net_address: netAddress
        port: port
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("port", "port", int, is_required=True),
    )

    net_address: str = Field(type=str, required=True, mutable=False)
    port: int = Field(type=int, required=True, mutable=False)


class SystemAccountingGetChargingFunctionElementServerListRequest(OCIRequest):
    """
    Request to get a list of ChargingFunctionElementServers defined in the system.

    The response is either a
    ``SystemAccountingGetChargingFunctionElementServerListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingGetRadiusServerListRequest(OCIRequest):
    """
    Request to get a list of Radius Servers defined in the system.

    The response is either a ``SystemAccountingGetRadiusServerListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingInhibitedAttributeValuePairCodeAddRequest(OCIRequest):
    """
    Add an Attribute Value Pair (AVP) combination to disable.

    The AVP combination includes a diameter AVP and a vendor ID.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        attribute_value_pair_code: attributeValuePairCode
        vendor_id: vendorId
    """

    _ELEMENTS = (
        E("attribute_value_pair_code", "attributeValuePairCode", int, is_required=True),
        E("vendor_id", "vendorId", int, is_required=True),
    )

    attribute_value_pair_code: int = Field(type=int, required=True, mutable=False)
    vendor_id: int = Field(type=int, required=True, mutable=False)


class SystemAccountingInhibitedAttributeValuePairCodeDeleteRequest(OCIRequest):
    """
    Remove an Attribute Value Pair (AVP) combination from the list of disabled AVP codes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        attribute_value_pair_code: attributeValuePairCode
        vendor_id: vendorId
    """

    _ELEMENTS = (
        E("attribute_value_pair_code", "attributeValuePairCode", int, is_required=True),
        E("vendor_id", "vendorId", int, is_required=True),
    )

    attribute_value_pair_code: int = Field(type=int, required=True, mutable=False)
    vendor_id: int = Field(type=int, required=True, mutable=False)


class SystemAccountingInhibitedAttributeValuePairCodeGetListRequest(OCIRequest):
    """
    Get a list of Attribute Value Pair (AVP) combinations that are disabled.

    The response is either a
    ``SystemAccountingInhibitedAttributeValuePairCodeGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAccountingModifyChargingFunctionElementServerRequest(OCIRequest):
    """
    Request to modify a ChargingFunctionElementServer in the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        address: address
        type: type
        description: description
    """

    _ELEMENTS = (
        E("address", "address", str, is_required=True),
        E("type", "type", str),
        E("description", "description", str),
    )

    address: str = Field(type=str, required=True, mutable=False)
    type: str = Field(type=str, required=False, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemAccountingModifyRadiusServerRequest(OCIRequest):
    """
    Request to modify a Radius Server in the system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        net_address: netAddress
        port: port
        description: description
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("port", "port", int, is_required=True),
        E("description", "description", str),
    )

    net_address: str = Field(type=str, required=True, mutable=False)
    port: int = Field(type=int, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemAccountingReorderChargingFunctionElementServerRequest(OCIRequest):
    """
    Reorder the charging function element servers.

    You can not add or delete addresses, only re-ordering the list is allowed.  The
    ordered list of addresses can be obtained with the
    ``SystemAccountingGetChargingFunctionElementServerListRequest()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        ordered_address_list: orderedAddressList
    """

    _ELEMENTS = (
        E("ordered_address_list", "orderedAddressList", str, is_required=True),
    )

    ordered_address_list: str = Field(type=str, required=True, mutable=False)


class SystemAdminAddRequest(OCIRequest):
    """
    Add a system or provisioning administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
        admin_type: adminType
        read_only: readOnly
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str, is_required=True),
        E("language", "language", str),
        E("admin_type", "adminType", str, is_required=True),
        E("read_only", "readOnly", bool, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=True, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)
    admin_type: str = Field(type=str, required=True, mutable=False)
    read_only: bool = Field(type=bool, required=True, mutable=False)


class SystemAdminDeleteRequest(OCIRequest):
    """
    Delete a system or provisioning administrator.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class SystemAdminGetListRequest(OCIRequest):
    """
    Get a list of system administrators.

    The response is either a ``SystemAdminGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdminGetRequest(OCIRequest):
    """
    Get a system or provisioning administrators profile.

    The response is either a ``SystemAdminGetResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
    )

    user_id: str = Field(type=str, required=True, mutable=False)


class SystemAdminModifyRequest(OCIRequest):
    """
    Modify a system or provisioning administrator.

    Since old password is not specified here, any password rule related to old password
    does not apply.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        user_id: userId
        first_name: firstName
        last_name: lastName
        password: password
        language: language
    """

    _ELEMENTS = (
        E("user_id", "userId", str, is_required=True),
        E("first_name", "firstName", str),
        E("last_name", "lastName", str),
        E("password", "password", str),
        E("language", "language", str),
    )

    user_id: str = Field(type=str, required=True, mutable=False)
    first_name: str = Field(type=str, required=False, mutable=False)
    last_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    language: str = Field(type=str, required=False, mutable=False)


class SystemAdviceOfChargeCostInformationSourceAddRequest(OCIRequest):
    """
    Add a cost information source.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        peer_identity: peerIdentity
        priority: priority
    """

    _ELEMENTS = (
        E("peer_identity", "peerIdentity", str, is_required=True),
        E("priority", "priority", int, is_required=True),
    )

    peer_identity: str = Field(type=str, required=True, mutable=False)
    priority: int = Field(type=int, required=True, mutable=False)


class SystemAdviceOfChargeCostInformationSourceDeleteRequest(OCIRequest):
    """
    Delete a cost information source.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        peer_identity: peerIdentity
    """

    _ELEMENTS = (
        E("peer_identity", "peerIdentity", str, is_required=True),
    )

    peer_identity: str = Field(type=str, required=True, mutable=False)


class SystemAdviceOfChargeCostInformationSourceGetListRequest(OCIRequest):
    """
    Get a list of cost information sources.

    The response is either ``SystemAdviceOfChargeCostInformationSourceGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdviceOfChargeCostInformationSourceModifyRequest(OCIRequest):
    """
    Modify a cost information source.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        peer_identity: peerIdentity
        priority: priority
    """

    _ELEMENTS = (
        E("peer_identity", "peerIdentity", str, is_required=True),
        E("priority", "priority", int, is_required=True),
    )

    peer_identity: str = Field(type=str, required=True, mutable=False)
    priority: int = Field(type=int, required=True, mutable=False)


class SystemAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge system parameters.

    The response is either ``SystemAdviceOfChargeGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdviceOfChargeGetRequest19sp1(OCIRequest):
    """
    Request to get the list of Advice of Charge system parameters.

    The response is either ``SystemAdviceOfChargeGetResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAdviceOfChargeModifyRequest(OCIRequest):
    """
    Request to modify Advice of Charge system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        delay_between_notification_seconds: delayBetweenNotificationSeconds
        incoming_aoc_handling: incomingAocHandling
        cost_information_source: costInformationSource
    """

    _ELEMENTS = (
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
        E("incoming_aoc_handling", "incomingAocHandling", str),
        E("cost_information_source", "costInformationSource", str),
    )

    delay_between_notification_seconds: int = Field(type=int, required=False, mutable=False)
    incoming_aoc_handling: str = Field(type=str, required=False, mutable=False)
    cost_information_source: str = Field(type=str, required=False, mutable=False)


class SystemAdviceOfChargeModifyRequest19sp1(OCIRequest):
    """
    Request to modify Advice of Charge system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        delay_between_notification_seconds: delayBetweenNotificationSeconds
        incoming_aoc_handling: incomingAocHandling
        use_ocs_enquiry: useOCSEnquiry
        ocs_enquiry_type: OCSEnquiryType
    """

    _ELEMENTS = (
        E("delay_between_notification_seconds", "delayBetweenNotificationSeconds", int),
        E("incoming_aoc_handling", "incomingAocHandling", str),
        E("use_ocs_enquiry", "useOCSEnquiry", bool),
        E("ocs_enquiry_type", "OCSEnquiryType", str),
    )

    delay_between_notification_seconds: int = Field(type=int, required=False, mutable=False)
    incoming_aoc_handling: str = Field(type=str, required=False, mutable=False)
    use_ocs_enquiry: bool = Field(type=bool, required=False, mutable=False)
    ocs_enquiry_type: str = Field(type=str, required=False, mutable=False)


class SystemAliasAddRequest(OCIRequest):
    """
    Add a system-level Application Server alias to the system.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        alias_net_address: aliasNetAddress
    """

    _ELEMENTS = (
        E("alias_net_address", "aliasNetAddress", str, is_required=True),
    )

    alias_net_address: str = Field(type=str, required=True, mutable=False)


class SystemAliasDeleteRequest(OCIRequest):
    """
    Delete a system-level Application Server alias from the system.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        alias_net_address: aliasNetAddress
    """

    _ELEMENTS = (
        E("alias_net_address", "aliasNetAddress", str, is_required=True),
    )

    alias_net_address: str = Field(type=str, required=True, mutable=False)


class SystemAliasGetListRequest(OCIRequest):
    """
    Requests the list of all system-level Application Server aliases.

    The response is either ``SystemAliasGetListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAnonymousCallRejectionGetRequest(OCIRequest):
    """
    Get Anonymous Call Rejection system parameters.

    The response is either a ``SystemAnonymousCallRejectionGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAnonymousCallRejectionModifyRequest(OCIRequest):
    """
    Modify a system Anonymous Call Rejection parameter.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        pai_required: paiRequired
        screen_only_local_calls: screenOnlyLocalCalls
    """

    _ELEMENTS = (
        E("pai_required", "paiRequired", bool),
        E("screen_only_local_calls", "screenOnlyLocalCalls", bool),
    )

    pai_required: bool = Field(type=bool, required=False, mutable=False)
    screen_only_local_calls: bool = Field(type=bool, required=False, mutable=False)


class SystemApplicationControllerAddRequest(OCIRequest):
    """
    Add an application controller, which is a server where remote application resides and
    controls the Route Point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        name: name
        subscriber_id: subscriberId
        channel_set_id: channelSetId
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("subscriber_id", "subscriberId", str, is_required=True),
        E("channel_set_id", "channelSetId", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    subscriber_id: str = Field(type=str, required=True, mutable=False)
    channel_set_id: str = Field(type=str, required=True, mutable=False)


class SystemApplicationControllerDeleteRequest(OCIRequest):
    """
    Delete an application controller.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemApplicationControllerGetListRequest(OCIRequest):
    """
    Get a list of application controllers that are configured for the system.

    The response is either ``SystemApplicationControllerGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAttendantConsoleGetRequest(OCIRequest):
    """
    Request to get the list of Attendant Console parameters.

    The response is either ``SystemAttendantConsoleGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAttendantConsoleModifyRequest(OCIRequest):
    """
    Modify Attendant Console settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        max_monitored_users: maxMonitoredUsers
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int),
    )

    max_monitored_users: int = Field(type=int, required=False, mutable=False)


class SystemAuthenticationLockoutExportDataGetRequest(OCIRequest):
    """
    Request to export system wide authentication lockout data to a file.

    All locked out device profiles, sip endpoints, and sip trunk groups are returned.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        file_name: fileName
    """

    _ELEMENTS = (
        E("file_name", "fileName", str, is_required=True),
    )

    file_name: str = Field(type=str, required=True, mutable=False)


class SystemAuthenticationLockoutSettingsGetRequest(OCIRequest):
    """
    Request to get the authentication lockout settings in the system.

    The response is either a ``SystemAuthenticationLockoutSettingsResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAuthenticationLockoutSettingsModifyRequest(OCIRequest):
    """
    Request to modify the system level device password lockout settings The response is
    either ``SuccessResponse()`` or ``ErrorResponse()``.


    Attributes:
        counter_reset_interval_days: counterResetIntervalDays
        counter_reset_hour: counterResetHour
        counter_reset_minute: counterResetMinute
        emergency_sip_bypass_allowed: emergencySIPBypassAllowed
    """

    _ELEMENTS = (
        E("counter_reset_interval_days", "counterResetIntervalDays", int),
        E("counter_reset_hour", "counterResetHour", int),
        E("counter_reset_minute", "counterResetMinute", int),
        E("emergency_sip_bypass_allowed", "emergencySIPBypassAllowed", bool),
    )

    counter_reset_interval_days: int = Field(type=int, required=False, mutable=False)
    counter_reset_hour: int = Field(type=int, required=False, mutable=False)
    counter_reset_minute: int = Field(type=int, required=False, mutable=False)
    emergency_sip_bypass_allowed: bool = Field(type=bool, required=False, mutable=False)


class SystemAutomaticCallbackAddReleaseCauseListRequest(OCIRequest):
    """
    Adds automatic callback release cause to the releaseCause attribute.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        release_cause: releaseCause
    """

    _ELEMENTS = (
        E("release_cause", "releaseCause", str, is_array=True),
    )

    release_cause: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemAutomaticCallbackDeleteReleaseCauseListRequest(OCIRequest):
    """
    Deletes automatic callback release causes from the release cause attribute.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        release_cause: releaseCause
    """

    _ELEMENTS = (
        E("release_cause", "releaseCause", str, is_array=True),
    )

    release_cause: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemAutomaticCallbackGetReleaseCauseListRequest(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetReleaseCauseListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemAutomaticCallbackGetRequest15()``
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest15(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemAutomaticCallbackGetRequest15sp2()``
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest15sp2(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse15sp2()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemAutomaticCallbackGetRequest17()``
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackGetRequest17(OCIRequest):
    """
    Request the system's automatic callback attributes.

    The response is either a ``SystemAutomaticCallbackGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemAutomaticCallbackModifyRequest(OCIRequest):
    """
    Modifies the system's automatic callback attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``SystemAutomaticCallbackModifyRequest15()``

    Attributes:
        monitor_minutes: monitorMinutes
        wait_between_retry_originator_minutes: waitBetweenRetryOriginatorMinutes
        max_monitors_per_originator: maxMonitorsPerOriginator
        max_callback_rings: maxCallbackRings
        max_retry_originator_minutes: maxRetryOriginatorMinutes
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int),
        E("wait_between_retry_originator_minutes", "waitBetweenRetryOriginatorMinutes", int),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int),
        E("max_callback_rings", "maxCallbackRings", int),
        E("max_retry_originator_minutes", "maxRetryOriginatorMinutes", int),
    )

    monitor_minutes: int = Field(type=int, required=False, mutable=False)
    wait_between_retry_originator_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    max_monitors_per_originator: int = Field(type=int, required=False, mutable=False)
    max_callback_rings: int = Field(type=int, required=False, mutable=False)
    max_retry_originator_minutes: int = Field(type=int, required=False, mutable=False)


class SystemAutomaticCallbackModifyRequest15(OCIRequest):
    """
    Modifies the system's automatic callback attributes.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        monitor_minutes: monitorMinutes
        max_monitors_per_originator: maxMonitorsPerOriginator
        max_callback_rings: maxCallbackRings
        max_monitors_per_terminator: maxMonitorsPerTerminator
        terminator_idle_guard_seconds: terminatorIdleGuardSeconds
        callback_method: callbackMethod
        polling_interval_seconds: pollingIntervalSeconds
        activation_digit: activationDigit
    """

    _ELEMENTS = (
        E("monitor_minutes", "monitorMinutes", int),
        E("max_monitors_per_originator", "maxMonitorsPerOriginator", int),
        E("max_callback_rings", "maxCallbackRings", int),
        E("max_monitors_per_terminator", "maxMonitorsPerTerminator", int),
        E("terminator_idle_guard_seconds", "terminatorIdleGuardSeconds", int),
        E("callback_method", "callbackMethod", str),
        E("polling_interval_seconds", "pollingIntervalSeconds", int),
        E("activation_digit", "activationDigit", int),
    )

    monitor_minutes: int = Field(type=int, required=False, mutable=False)
    max_monitors_per_originator: int = Field(type=int, required=False, mutable=False)
    max_callback_rings: int = Field(type=int, required=False, mutable=False)
    max_monitors_per_terminator: int = Field(type=int, required=False, mutable=False)
    terminator_idle_guard_seconds: int = Field(type=int, required=False, mutable=False)
    callback_method: str = Field(type=str, required=False, mutable=False)
    polling_interval_seconds: int = Field(type=int, required=False, mutable=False)
    activation_digit: int = Field(type=int, required=False, mutable=False)


class SystemBCCTAddOCIInterfaceAddressRequest(OCIRequest):
    """
    Add an OCI entry to the Broadworks Common Communication Transport (BCCT) protocol to
    interface mapping table.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        interface_net_address: interfaceNetAddress
    """

    _ELEMENTS = (
        E("interface_net_address", "interfaceNetAddress", str, is_required=True),
    )

    interface_net_address: str = Field(type=str, required=True, mutable=False)


class SystemBCCTDeleteOCIInterfaceAddressRequest(OCIRequest):
    """
    Delete an OCI entry in the Broadworks Common Communication Transport (BCCT) protocol
    to interface mapping table.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        interface_net_address: interfaceNetAddress
    """

    _ELEMENTS = (
        E("interface_net_address", "interfaceNetAddress", str, is_required=True),
    )

    interface_net_address: str = Field(type=str, required=True, mutable=False)


class SystemBCCTGetOCIInterfaceAddressListRequest(OCIRequest):
    """
    Get the OCI entries from the Broadworks Common Communication Transport (BCCT) protocol
    to interface mapping list.

    The response is ``SystemBCCTGetOCIInterfaceAddressListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadCloudGetRequest(OCIRequest):
    """
    Get the system interface attributes for Messaging Server.

    The response is either ``SystemBroadCloudGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadCloudModifyRequest(OCIRequest):
    """
    Modify the system interface attributes for Messaging Server.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        provisioning_url: provisioningUrl
        provisioning_user_id: provisioningUserId
        provisioning_password: provisioningPassword
        enable_synchronization: enableSynchronization
    """

    _ELEMENTS = (
        E("provisioning_url", "provisioningUrl", str),
        E("provisioning_user_id", "provisioningUserId", str),
        E("provisioning_password", "provisioningPassword", str),
        E("enable_synchronization", "enableSynchronization", bool),
    )

    provisioning_url: str = Field(type=str, required=False, mutable=False)
    provisioning_user_id: str = Field(type=str, required=False, mutable=False)
    provisioning_password: str = Field(type=str, required=False, mutable=False)
    enable_synchronization: bool = Field(type=bool, required=False, mutable=False)


class SystemBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager service system settings.

    The response is either ``SystemBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager service system settings.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        scf_api_net_address1: scfApiNetAddress1
        scf_api_net_address2: scfApiNetAddress2
        user_name: userName
        password: password
        email_from_address: emailFromAddress
        scf_ims_only: scfIMSOnly
        signaling_ip_address: signalingIPAddress
        signaling_port: signalingPort
    """

    _ELEMENTS = (
        E("scf_api_net_address1", "scfApiNetAddress1", str),
        E("scf_api_net_address2", "scfApiNetAddress2", str),
        E("user_name", "userName", str),
        E("password", "password", str),
        E("email_from_address", "emailFromAddress", str),
        E("scf_ims_only", "scfIMSOnly", bool),
        E("signaling_ip_address", "signalingIPAddress", str),
        E("signaling_port", "signalingPort", int),
    )

    scf_api_net_address1: str = Field(type=str, required=False, mutable=False)
    scf_api_net_address2: str = Field(type=str, required=False, mutable=False)
    user_name: str = Field(type=str, required=False, mutable=False)
    password: str = Field(type=str, required=False, mutable=False)
    email_from_address: str = Field(type=str, required=False, mutable=False)
    scf_ims_only: bool = Field(type=bool, required=False, mutable=False)
    signaling_ip_address: str = Field(type=str, required=False, mutable=False)
    signaling_port: int = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityDeleteIMRNListRequest(OCIRequest):
    """
    Removes a BroadWorks Mobility IMRN number from the system.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        imrn_number: imrnNumber
    """

    _ELEMENTS = (
        E("imrn_number", "imrnNumber", str, is_required=True),
    )

    imrn_number: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityDeleteMobileNetworkIMRNListRequest(OCIRequest):
    """
    Remove BroadWorks Mobility IMRN numbers from a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        mobile_network_name: mobileNetworkName
        imrn_number: imrnNumber
    """

    _ELEMENTS = (
        E("mobile_network_name", "mobileNetworkName", str, is_required=True),
        E("imrn_number", "imrnNumber", str, is_required=True),
    )

    mobile_network_name: str = Field(type=str, required=True, mutable=False)
    imrn_number: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemBroadWorksMobilityGetRequest17sp4()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityGetRequest17sp4(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse17sp4()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemBroadWorksMobilityGetRequest19sp1()``
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``. Replaced by ``SystemBroadWorksMobilityGetRequest21()``
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityGetRequest21(OCIRequest):
    """
    Get the broadworks mobility system parameters.

    The response is either a ``SystemBroadWorksMobilityGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityMobileNetworkAddRequest(OCIRequest):
    """
    Add a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        name: name
        scf_signaling_net_address: scfSignalingNetAddress
        scf_signaling_port: scfSignalingPort
        refresh_period_seconds: refreshPeriodSeconds
        max_consecutive_failures: maxConsecutiveFailures
        max_response_wait_time_milliseconds: maxResponseWaitTimeMilliseconds
        enable_announcement_suppression: enableAnnouncementSuppression
        service_access_code_list_name: serviceAccessCodeListName
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int, is_required=True),
        E("max_consecutive_failures", "maxConsecutiveFailures", int, is_required=True),
        E(
            "max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int,
            is_required=True,
        ),
        E(
            "enable_announcement_suppression", "enableAnnouncementSuppression", bool,
            is_required=True,
        ),
        E("service_access_code_list_name", "serviceAccessCodeListName", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    scf_signaling_net_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)
    refresh_period_seconds: int = Field(type=int, required=True, mutable=False)
    max_consecutive_failures: int = Field(type=int, required=True, mutable=False)
    max_response_wait_time_milliseconds: int = Field(type=int, required=True, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=True, mutable=False)
    service_access_code_list_name: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityMobileNetworkDeleteRequest(OCIRequest):
    """
    Delete a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkGetListRequest(OCIRequest):
    """
    Get the list of Mobile Networks.

    The response is either ``SystemBroadWorksMobilityMobileNetworkGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityMobileNetworkGetRequest(OCIRequest):
    """
    Get a Mobile Network.

    The response is either ``SystemBroadWorksMobilityMobileNetworkGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityMobileNetworkModifyRequest(OCIRequest):
    """
    Modify a Mobile Network.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        name: name
        new_name: newName
        scf_signaling_net_address: scfSignalingNetAddress
        scf_signaling_port: scfSignalingPort
        refresh_period_seconds: refreshPeriodSeconds
        max_consecutive_failures: maxConsecutiveFailures
        max_response_wait_time_milliseconds: maxResponseWaitTimeMilliseconds
        enable_announcement_suppression: enableAnnouncementSuppression
        service_access_code_list_name: serviceAccessCodeListName
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("new_name", "newName", str),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int),
        E("max_consecutive_failures", "maxConsecutiveFailures", int),
        E("max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
        E("service_access_code_list_name", "serviceAccessCodeListName", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    new_name: str = Field(type=str, required=False, mutable=False)
    scf_signaling_net_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)
    refresh_period_seconds: int = Field(type=int, required=False, mutable=False)
    max_consecutive_failures: int = Field(type=int, required=False, mutable=False)
    max_response_wait_time_milliseconds: int = Field(type=int, required=False, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=False, mutable=False)
    service_access_code_list_name: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobility system parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by:
    ``SystemBroadWorksMobilityModifyRequest17sp4()``.

    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_milliseconds: imrnTimeoutMilliseconds
        scf_signaling_ip_address: scfSignalingIPAddress
        scf_signaling_port: scfSignalingPort
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("imrn_timeout_milliseconds", "imrnTimeoutMilliseconds", int),
        E("scf_signaling_ip_address", "scfSignalingIPAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
    )

    enable_location_services: bool = Field(type=bool, required=False, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=False, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=False, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=False, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=False, mutable=False)
    imrn_timeout_milliseconds: int = Field(type=int, required=False, mutable=False)
    scf_signaling_ip_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityModifyRequest17sp4(OCIRequest):
    """
    Modify the BroadWorks Mobility system parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityModifyRequest21()``.

    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_milliseconds: imrnTimeoutMilliseconds
        scf_signaling_net_address: scfSignalingNetAddress
        scf_signaling_port: scfSignalingPort
        refresh_period_seconds: refreshPeriodSeconds
        max_consecutive_failures: maxConsecutiveFailures
        max_response_wait_time_milliseconds: maxResponseWaitTimeMilliseconds
        enable_announcement_suppression: enableAnnouncementSuppression
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("imrn_timeout_milliseconds", "imrnTimeoutMilliseconds", int),
        E("scf_signaling_net_address", "scfSignalingNetAddress", str),
        E("scf_signaling_port", "scfSignalingPort", int),
        E("refresh_period_seconds", "refreshPeriodSeconds", int),
        E("max_consecutive_failures", "maxConsecutiveFailures", int),
        E("max_response_wait_time_milliseconds", "maxResponseWaitTimeMilliseconds", int),
        E("enable_announcement_suppression", "enableAnnouncementSuppression", bool),
    )

    enable_location_services: bool = Field(type=bool, required=False, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=False, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=False, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=False, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=False, mutable=False)
    imrn_timeout_milliseconds: int = Field(type=int, required=False, mutable=False)
    scf_signaling_net_address: str = Field(type=str, required=False, mutable=False)
    scf_signaling_port: int = Field(type=int, required=False, mutable=False)
    refresh_period_seconds: int = Field(type=int, required=False, mutable=False)
    max_consecutive_failures: int = Field(type=int, required=False, mutable=False)
    max_response_wait_time_milliseconds: int = Field(type=int, required=False, mutable=False)
    enable_announcement_suppression: bool = Field(type=bool, required=False, mutable=False)


class SystemBroadWorksMobilityModifyRequest21(OCIRequest):
    """
    Modify the BroadWorks Mobility system parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        enable_location_services: enableLocationServices
        enable_msrn_lookup: enableMSRNLookup
        enable_mobile_state_checking: enableMobileStateChecking
        deny_call_originations: denyCallOriginations
        deny_call_terminations: denyCallTerminations
        imrn_timeout_milliseconds: imrnTimeoutMilliseconds
    """

    _ELEMENTS = (
        E("enable_location_services", "enableLocationServices", bool),
        E("enable_msrn_lookup", "enableMSRNLookup", bool),
        E("enable_mobile_state_checking", "enableMobileStateChecking", bool),
        E("deny_call_originations", "denyCallOriginations", bool),
        E("deny_call_terminations", "denyCallTerminations", bool),
        E("imrn_timeout_milliseconds", "imrnTimeoutMilliseconds", int),
    )

    enable_location_services: bool = Field(type=bool, required=False, mutable=False)
    enable_msrn_lookup: bool = Field(type=bool, required=False, mutable=False)
    enable_mobile_state_checking: bool = Field(type=bool, required=False, mutable=False)
    deny_call_originations: bool = Field(type=bool, required=False, mutable=False)
    deny_call_terminations: bool = Field(type=bool, required=False, mutable=False)
    imrn_timeout_milliseconds: int = Field(type=int, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeAddRequest(OCIRequest):
    """
    Add a system service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeAddRequest21()``.

    Attributes:
        service_access_code: serviceAccessCode
        country_code: countryCode
        description: description
    """

    _ELEMENTS = (
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("country_code", "countryCode", str, is_required=True),
        E("description", "description", str),
    )

    service_access_code: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeAddRequest21(OCIRequest):
    """
    Add a service access code to a list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_access_code_list_name: serviceAccessCodeListName
        country_code: countryCode
        service_access_code: serviceAccessCode
        description: description
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("description", "description", str),
    )

    service_access_code_list_name: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    service_access_code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeDeleteRequest(OCIRequest):
    """
    Delete a system service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeDeleteRequest21()``.

    Attributes:
        country_code: countryCode
        service_access_code: serviceAccessCode
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
    )

    country_code: str = Field(type=str, required=True, mutable=False)
    service_access_code: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeDeleteRequest21(OCIRequest):
    """
    Delete a service access code from a list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_access_code_list_name: serviceAccessCodeListName
        country_code: countryCode
        service_access_code: serviceAccessCode
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
    )

    service_access_code_list_name: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    service_access_code: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeGetListRequest(OCIRequest):
    """
    Get a list of system service access codes.

    The response is either ``SystemBroadWorksMobilityServiceAccessCodeGetListResponse()``
    or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeGetListRequest21()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityServiceAccessCodeGetListRequest21(OCIRequest):
    """
    Get a list of system service access codes.

    The response is either
    ``SystemBroadWorksMobilityServiceAccessCodeGetListResponse21()`` or
    ``ErrorResponse()``.

    Attributes:
        service_access_code_list_name: serviceAccessCodeListName
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
    )

    service_access_code_list_name: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListAddRequest(OCIRequest):
    """
    Add a Service Access Code list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListDeleteRequest(OCIRequest):
    """
    Delete a Service Access Code list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListGetListRequest(OCIRequest):
    """
    Get the list of Service Access Code lists.

    The response is either
    ``SystemBroadWorksMobilityServiceAccessCodeListGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksMobilityServiceAccessCodeListModifyRequest(OCIRequest):
    """
    Modify a Service Access Code list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        name: name
        new_name: newName
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("new_name", "newName", str),
    )

    name: str = Field(type=str, required=True, mutable=False)
    new_name: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeListUsageGetRequest(OCIRequest):
    """
    Get all the Mobile Networks using a given Service Access Code list.

    The response is either
    ``SystemBroadWorksMobilityServiceAccessCodeListUsageGetResponse()`` or
    ``ErrorResponse()``.

    Attributes:
        service_access_code_list_name: serviceAccessCodeListName
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
    )

    service_access_code_list_name: str = Field(type=str, required=True, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeModifyRequest(OCIRequest):
    """
    Modify a system service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemBroadWorksMobilityServiceAccessCodeModifyRequest21()``.

    Attributes:
        country_code: countryCode
        service_access_code: serviceAccessCode
        description: description
    """

    _ELEMENTS = (
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("description", "description", str),
    )

    country_code: str = Field(type=str, required=True, mutable=False)
    service_access_code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksMobilityServiceAccessCodeModifyRequest21(OCIRequest):
    """
    Modify a service access code.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        service_access_code_list_name: serviceAccessCodeListName
        country_code: countryCode
        service_access_code: serviceAccessCode
        description: description
    """

    _ELEMENTS = (
        E(
            "service_access_code_list_name", "serviceAccessCodeListName", str,
            is_required=True,
        ),
        E("country_code", "countryCode", str, is_required=True),
        E("service_access_code", "serviceAccessCode", str, is_required=True),
        E("description", "description", str),
    )

    service_access_code_list_name: str = Field(type=str, required=True, mutable=False)
    country_code: str = Field(type=str, required=True, mutable=False)
    service_access_code: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemBroadWorksReceptionistEnterpriseGetRequest(OCIRequest):
    """
    Request to get the list of BroadWorks Receptionist - Enterprise parameters.

    The response is either ``SystemBroadWorksReceptionistEnterpriseGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBroadWorksReceptionistEnterpriseModifyRequest(OCIRequest):
    """
    Request to modify BroadWorks Receptionist - Enterprise settings.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        max_monitored_users: maxMonitoredUsers
    """

    _ELEMENTS = (
        E("max_monitored_users", "maxMonitoredUsers", int),
    )

    max_monitored_users: int = Field(type=int, required=False, mutable=False)


class SystemBusyLampFieldGetRequest(OCIRequest):
    """
    Request the system level data associated with the Busy Lamp Field service.

    The response is either a ``SystemBusyLampFieldGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBusyLampFieldGetRequest18(OCIRequest):
    """
    Request the system level data associated with the Busy Lamp Field service.

    The response is either a ``SystemBusyLampFieldGetResponse18()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBusyLampFieldModifyRequest(OCIRequest):
    """
    Modify the system level data associated with the Busy Lamp Field Service.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    following elements are only used in AS data mode: forceUseOfTCP

    Attributes:
        display_local_user_identity_last_name_first: displayLocalUserIdentityLastNameFirst
        force_use_of_tcp: forceUseOfTCP
    """

    _ELEMENTS = (
        E(
            "display_local_user_identity_last_name_first",
            "displayLocalUserIdentityLastNameFirst", bool,
        ),
        E("force_use_of_tcp", "forceUseOfTCP", bool),
    )

    display_local_user_identity_last_name_first: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_use_of_tcp: bool = Field(type=bool, required=False, mutable=False)


class SystemBwDiameterBaseDataGetRequest(OCIRequest):
    """
    Requests the list of System Diameter base parameters.

    The response is either ``SystemBwDiameterBaseDataGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterBaseDataGetRequest17sp3(OCIRequest):
    """
    Requests the list of System Diameter base parameters.

    The response is either ``SystemBwDiameterBaseDataGetResponse17sp3()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterBaseDataModifyRequest(OCIRequest):
    """
    Modifies the System Diameter base parameters.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        xs_realm: xsRealm
        xs_listening_port: xsListeningPort
        ps_realm: psRealm
        ps_listening_port: psListeningPort
        ps_relay_through_xs: psRelayThroughXs
        xs_relay_listening_port: xsRelayListeningPort
        tc_timer_seconds: tcTimerSeconds
        tw_timer_seconds: twTimerSeconds
        request_timer_seconds: requestTimerSeconds
        busy_peer_detection_outstanding_txn_count: busyPeerDetectionOutstandingTxnCount
        busy_peer_restore_outstanding_txn_count: busyPeerRestoreOutstandingTxnCount
        dynamic_entry_inactivity_timer_hours: dynamicEntryInactivityTimerHours
        advertised_offline_billing_application: advertisedOfflineBillingApplication
        advertised_online_billing_application: advertisedOnlineBillingApplication
    """

    _ELEMENTS = (
        E("xs_realm", "xsRealm", str),
        E("xs_listening_port", "xsListeningPort", int),
        E("ps_realm", "psRealm", str),
        E("ps_listening_port", "psListeningPort", int),
        E("ps_relay_through_xs", "psRelayThroughXs", bool),
        E("xs_relay_listening_port", "xsRelayListeningPort", int),
        E("tc_timer_seconds", "tcTimerSeconds", int),
        E("tw_timer_seconds", "twTimerSeconds", int),
        E("request_timer_seconds", "requestTimerSeconds", int),
        E(
            "busy_peer_detection_outstanding_txn_count",
            "busyPeerDetectionOutstandingTxnCount", int,
        ),
        E(
            "busy_peer_restore_outstanding_txn_count",
            "busyPeerRestoreOutstandingTxnCount", int,
        ),
        E("dynamic_entry_inactivity_timer_hours", "dynamicEntryInactivityTimerHours", int),
        E(
            "advertised_offline_billing_application",
            "advertisedOfflineBillingApplication", str,
        ),
        E("advertised_online_billing_application", "advertisedOnlineBillingApplication", str),
    )

    xs_realm: str = Field(type=str, required=False, mutable=False)
    xs_listening_port: int = Field(type=int, required=False, mutable=False)
    ps_realm: str = Field(type=str, required=False, mutable=False)
    ps_listening_port: int = Field(type=int, required=False, mutable=False)
    ps_relay_through_xs: bool = Field(type=bool, required=False, mutable=False)
    xs_relay_listening_port: int = Field(type=int, required=False, mutable=False)
    tc_timer_seconds: int = Field(type=int, required=False, mutable=False)
    tw_timer_seconds: int = Field(type=int, required=False, mutable=False)
    request_timer_seconds: int = Field(type=int, required=False, mutable=False)
    busy_peer_detection_outstanding_txn_count: int = Field(
        type=int, required=False, mutable=False,
    )
    busy_peer_restore_outstanding_txn_count: int = Field(
        type=int, required=False, mutable=False,
    )
    dynamic_entry_inactivity_timer_hours: int = Field(type=int, required=False, mutable=False)
    advertised_offline_billing_application: str = Field(
        type=str, required=False, mutable=False,
    )
    advertised_online_billing_application: str = Field(
        type=str, required=False, mutable=False,
    )


class SystemBwDiameterPeerAddRequest(OCIRequest):
    """
    Add a static entry in the Diameter Peer Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        identity: identity
        ip_address: ipAddress
        port: port
        enabled: enabled
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("ip_address", "ipAddress", str),
        E("port", "port", int, is_required=True),
        E("enabled", "enabled", bool, is_required=True),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    identity: str = Field(type=str, required=True, mutable=False)
    ip_address: str = Field(type=str, required=False, mutable=False)
    port: int = Field(type=int, required=True, mutable=False)
    enabled: bool = Field(type=bool, required=True, mutable=False)


class SystemBwDiameterPeerDeleteRequest(OCIRequest):
    """
    Remove a Diameter peer.

    A peer cannot be removed if is referenced by a Realm Routing Table entry.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        identity: identity
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("identity", "identity", str, is_required=True),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    identity: str = Field(type=str, required=True, mutable=False)


class SystemBwDiameterPeerGetListRequest(OCIRequest):
    """
    Requests the list of Diameter peers.

    The response is either ``SystemBwDiameterPeerGetListResponse()`` or
    ``ErrorResponse()``
    """

    _ELEMENTS = ()


class SystemBwDiameterPeerModifyRequest(OCIRequest):
    """
    Modifies the attributes of an entry in the Diameter Peer Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        identity: identity
        ip_address: ipAddress
        port: port
        enabled: enabled
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("ip_address", "ipAddress", str),
        E("port", "port", int),
        E("enabled", "enabled", bool),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    identity: str = Field(type=str, required=True, mutable=False)
    ip_address: str = Field(type=str, required=False, mutable=False)
    port: int = Field(type=int, required=False, mutable=False)
    enabled: bool = Field(type=bool, required=False, mutable=False)


class SystemBwDiameterRoutingPeerAddRequest(OCIRequest):
    """
    Add a Diameter routing peer.

    The realm must refer to a Diameter routing realm whose action is relay.  The
    destinationPeerIdentity must refer to an existing Diameter peer whose mode is active.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        realm: realm
        application_id: applicationId
        identity: identity
        priority: priority
        weight: weight
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("priority", "priority", int, is_required=True),
        E("weight", "weight", int, is_required=True),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    realm: str = Field(type=str, required=True, mutable=False)
    application_id: str = Field(type=str, required=True, mutable=False)
    identity: str = Field(type=str, required=True, mutable=False)
    priority: int = Field(type=int, required=True, mutable=False)
    weight: int = Field(type=int, required=True, mutable=False)


class SystemBwDiameterRoutingPeerDeleteRequest(OCIRequest):
    """
    Remove a Diameter routing peer.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        realm: realm
        application_id: applicationId
        identity: identity
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("identity", "identity", str, is_required=True),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    realm: str = Field(type=str, required=True, mutable=False)
    application_id: str = Field(type=str, required=True, mutable=False)
    identity: str = Field(type=str, required=True, mutable=False)


class SystemBwDiameterRoutingPeerGetListRequest(OCIRequest):
    """
    Requests the list of Diameter routing peers associated with the specified realm.

    The response is either ``SystemBwDiameterRoutingPeerGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterRoutingPeerModifyRequest(OCIRequest):
    """
    Modify a Diameter routing peer.

    The realm must refer to a Diameter routing realm whose action is relay.  The
    destinationPeerIdentity must refer to an existing Diameter peer whose mode is active.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        realm: realm
        application_id: applicationId
        identity: identity
        priority: priority
        weight: weight
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("identity", "identity", str, is_required=True),
        E("priority", "priority", int),
        E("weight", "weight", int),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    realm: str = Field(type=str, required=True, mutable=False)
    application_id: str = Field(type=str, required=True, mutable=False)
    identity: str = Field(type=str, required=True, mutable=False)
    priority: int = Field(type=int, required=False, mutable=False)
    weight: int = Field(type=int, required=False, mutable=False)


class SystemBwDiameterRoutingRealmAddRequest(OCIRequest):
    """
    Add a static entry in the Realm Routing Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        realm: realm
        application_id: applicationId
        default: default
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("default", "default", bool, is_required=True),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    realm: str = Field(type=str, required=True, mutable=False)
    application_id: str = Field(type=str, required=True, mutable=False)
    default: bool = Field(type=bool, required=True, mutable=False)


class SystemBwDiameterRoutingRealmDeleteRequest(OCIRequest):
    """
    Delete a static entry in the Realm Routing Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        realm: realm
        application_id: applicationId
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    realm: str = Field(type=str, required=True, mutable=False)
    application_id: str = Field(type=str, required=True, mutable=False)


class SystemBwDiameterRoutingRealmGetListRequest(OCIRequest):
    """
    Requests the list of Diameter routing realms.

    The response is either ``SystemBwDiameterRoutingRealmGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemBwDiameterRoutingRealmModifyRequest(OCIRequest):
    """
    Modify a static entry in the Realm Routing Table.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        instance: instance
        realm: realm
        application_id: applicationId
        default: default
    """

    _ELEMENTS = (
        E("instance", "instance", str, is_required=True),
        E("realm", "realm", str, is_required=True),
        E("application_id", "applicationId", str, is_required=True),
        E("default", "default", bool),
    )

    instance: str = Field(type=str, required=True, mutable=False)
    realm: str = Field(type=str, required=True, mutable=False)
    application_id: str = Field(type=str, required=True, mutable=False)
    default: bool = Field(type=bool, required=False, mutable=False)


class SystemCAPAddACLEntryRequest14(OCIRequest):
    """
    Add an entry to the CAP access control list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        net_address: netAddress
        description: description
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("description", "description", str),
    )

    net_address: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemCAPDeleteACLEntryRequest(OCIRequest):
    """
    Delete an entry from the CAP access control list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        net_address: netAddress
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
    )

    net_address: str = Field(type=str, required=True, mutable=False)


class SystemCAPGetACLListRequest14(OCIRequest):
    """
    Get the CAP access control list.

    The response is either ``SystemCAPGetACLListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCAPModifyACLEntryRequest14(OCIRequest):
    """
    Modify an entry from the CAP access control list.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        net_address: netAddress
        description: description
    """

    _ELEMENTS = (
        E("net_address", "netAddress", str, is_required=True),
        E("description", "description", str),
    )

    net_address: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)


class SystemCAPParametersGetRequest(OCIRequest):
    """
    Request to get the list of CAP system parameters.

    The response is either ``SystemCAPParametersGetResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemCAPParametersGetRequest14sp3()``
    """

    _ELEMENTS = ()


class SystemCAPParametersGetRequest14sp3(OCIRequest):
    """
    Request to get the list of CAP system parameters.

    The response is either ``SystemCAPParametersGetResponse14sp3()`` or
    ``ErrorResponse()``. Replaced by ``SystemCAPParametersGetRequest19()``
    """

    _ELEMENTS = ()


class SystemCAPParametersGetRequest19(OCIRequest):
    """
    Request to get the list of CAP system parameters.

    The response is either ``SystemCAPParametersGetResponse19()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCAPParametersModifyRequest(OCIRequest):
    """
    Request to modify CAP system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``. Replaced by
    ``SystemCAPParametersModifyRequest19()``

    Attributes:
        server_port: serverPort
        max_client_connections: maxClientConnections
        enable_connection_ping: enableConnectionPing
        connection_ping_interval_minutes: connectionPingIntervalMinutes
        ccc2_server_port: CCC2ServerPort
        ccc2_max_client_connections: CCC2MaxClientConnections
        cap_server_call_center_port: capServerCallCenterPort
        cap_server_call_center_max_client_connections:
            capServerCallCenterMaxClientConnections
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int),
        E("max_client_connections", "maxClientConnections", int),
        E("enable_connection_ping", "enableConnectionPing", bool),
        E("connection_ping_interval_minutes", "connectionPingIntervalMinutes", int),
        E("ccc2_server_port", "CCC2ServerPort", int),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int),
        E("cap_server_call_center_port", "capServerCallCenterPort", int),
        E(
            "cap_server_call_center_max_client_connections",
            "capServerCallCenterMaxClientConnections", int,
        ),
    )

    server_port: int = Field(type=int, required=False, mutable=False)
    max_client_connections: int = Field(type=int, required=False, mutable=False)
    enable_connection_ping: bool = Field(type=bool, required=False, mutable=False)
    connection_ping_interval_minutes: int = Field(type=int, required=False, mutable=False)
    ccc2_server_port: int = Field(type=int, required=False, mutable=False)
    ccc2_max_client_connections: int = Field(type=int, required=False, mutable=False)
    cap_server_call_center_port: int = Field(type=int, required=False, mutable=False)
    cap_server_call_center_max_client_connections: int = Field(
        type=int, required=False, mutable=False,
    )


class SystemCAPParametersModifyRequest19(OCIRequest):
    """
    Request to modify CAP system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        server_port: serverPort
        max_client_connections: maxClientConnections
        enable_connection_ping: enableConnectionPing
        connection_ping_interval_minutes: connectionPingIntervalMinutes
        ccc2_server_port: CCC2ServerPort
        ccc2_max_client_connections: CCC2MaxClientConnections
    """

    _ELEMENTS = (
        E("server_port", "serverPort", int),
        E("max_client_connections", "maxClientConnections", int),
        E("enable_connection_ping", "enableConnectionPing", bool),
        E("connection_ping_interval_minutes", "connectionPingIntervalMinutes", int),
        E("ccc2_server_port", "CCC2ServerPort", int),
        E("ccc2_max_client_connections", "CCC2MaxClientConnections", int),
    )

    server_port: int = Field(type=int, required=False, mutable=False)
    max_client_connections: int = Field(type=int, required=False, mutable=False)
    enable_connection_ping: bool = Field(type=bool, required=False, mutable=False)
    connection_ping_interval_minutes: int = Field(type=int, required=False, mutable=False)
    ccc2_server_port: int = Field(type=int, required=False, mutable=False)
    ccc2_max_client_connections: int = Field(type=int, required=False, mutable=False)


class SystemCPEConfigAddFileServerRequest(OCIRequest):
    """
    Add a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigAddFileServerRequest14sp6()``

    Attributes:
        device_type: deviceType
        ftp_host_net_address: ftpHostNetAddress
        ftp_user_id: ftpUserId
        ftp_user_password: ftpUserPassword
        cpe_file_directory: cpeFileDirectory
        passive_ftp: passiveFTP
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("ftp_host_net_address", "ftpHostNetAddress", str, is_required=True),
        E("ftp_user_id", "ftpUserId", str, is_required=True),
        E("ftp_user_password", "ftpUserPassword", str, is_required=True),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("passive_ftp", "passiveFTP", bool),
    )

    device_type: str = Field(type=str, required=True, mutable=False)
    ftp_host_net_address: str = Field(type=str, required=True, mutable=False)
    ftp_user_id: str = Field(type=str, required=True, mutable=False)
    ftp_user_password: str = Field(type=str, required=True, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    passive_ftp: bool = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigAddFileServerRequest14sp6(OCIRequest):
    """
    Add a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        device_type: deviceType
        file_repository_name: fileRepositoryName
        cpe_file_directory: cpeFileDirectory
        extended_capture_file_repository_name: extendedCaptureFileRepositoryName
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str, is_required=True),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("extended_capture_file_repository_name", "extendedCaptureFileRepositoryName", str),
    )

    device_type: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=True, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    extended_capture_file_repository_name: str = Field(
        type=str, required=False, mutable=False,
    )


class SystemCPEConfigDeleteFileServerRequest(OCIRequest):
    """
    Delete a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
    )

    device_type: str = Field(type=str, required=True, mutable=False)


class SystemCPEConfigGetFileServerListRequest(OCIRequest):
    """
    Requests the list of device CPE config file servers.

    The response is either ``SystemCPEConfigGetFileServerListResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigGetFileServerListRequest14sp6()``
    """

    _ELEMENTS = ()


class SystemCPEConfigGetFileServerListRequest14sp6(OCIRequest):
    """
    Requests the list of device CPE config file servers.

    The response is either ``SystemCPEConfigGetFileServerListResponse14sp6()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigModifyFileServerRequest(OCIRequest):
    """
    Modify a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigModifyFileServerRequest14sp6()``

    Attributes:
        device_type: deviceType
        ftp_host_net_address: ftpHostNetAddress
        ftp_user_id: ftpUserId
        ftp_user_password: ftpUserPassword
        cpe_file_directory: cpeFileDirectory
        passive_ftp: passiveFTP
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("ftp_host_net_address", "ftpHostNetAddress", str),
        E("ftp_user_id", "ftpUserId", str),
        E("ftp_user_password", "ftpUserPassword", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("passive_ftp", "passiveFTP", bool),
    )

    device_type: str = Field(type=str, required=True, mutable=False)
    ftp_host_net_address: str = Field(type=str, required=False, mutable=False)
    ftp_user_id: str = Field(type=str, required=False, mutable=False)
    ftp_user_password: str = Field(type=str, required=False, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    passive_ftp: bool = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigModifyFileServerRequest14sp6(OCIRequest):
    """
    Modify a device CPE config file server.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        device_type: deviceType
        file_repository_name: fileRepositoryName
        cpe_file_directory: cpeFileDirectory
        extended_capture_file_repository_name: extendedCaptureFileRepositoryName
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("file_repository_name", "fileRepositoryName", str),
        E("cpe_file_directory", "cpeFileDirectory", str),
        E("extended_capture_file_repository_name", "extendedCaptureFileRepositoryName", str),
    )

    device_type: str = Field(type=str, required=True, mutable=False)
    file_repository_name: str = Field(type=str, required=False, mutable=False)
    cpe_file_directory: str = Field(type=str, required=False, mutable=False)
    extended_capture_file_repository_name: str = Field(
        type=str, required=False, mutable=False,
    )


class SystemCPEConfigParametersGetRequest(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By: ``SystemCPEConfigParametersGetRequest14sp6()``
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersGetRequest14sp6(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse14sp6()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersGetRequest20(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersGetRequest21(OCIRequest):
    """
    Request to get the list of CPE Config system parameters.

    The response is either ``SystemCPEConfigParametersGetResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCPEConfigParametersModifyRequest(OCIRequest):
    """
    Request to modify CPE Config system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
        pause_between_file_rebuild_milliseconds: pauseBetweenFileRebuildMilliseconds
        max_busy_time_minutes: maxBusyTimeMinutes
        device_access_app_server_cluster_name: deviceAccessAppServerClusterName
        file_rebuild_immediate: fileRebuildImmediate
        file_rebuild_daily: fileRebuildDaily
        file_rebuild_hourly: fileRebuildHourly
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int),
        E("ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E("file_rebuild_immediate", "fileRebuildImmediate", str, is_complex=True),  # unknown
        E("file_rebuild_daily", "fileRebuildDaily", str, is_complex=True),  # unknown
        E("file_rebuild_hourly", "fileRebuildHourly", str, is_complex=True),  # unknown
    )

    enable_ip_device_management: bool = Field(type=bool, required=False, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    pause_between_file_rebuild_milliseconds: int = Field(
        type=int, required=False, mutable=False,
    )
    max_busy_time_minutes: int = Field(type=int, required=False, mutable=False)
    device_access_app_server_cluster_name: str = Field(
        type=str, required=False, mutable=False,
    )
    file_rebuild_immediate: str = Field(type=str, required=False, mutable=False)
    file_rebuild_daily: str = Field(type=str, required=False, mutable=False)
    file_rebuild_hourly: str = Field(type=str, required=False, mutable=False)


class SystemCPEConfigParametersModifyRequest20(OCIRequest):
    """
    Request to modify CPE Config system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
        pause_between_file_rebuild_milliseconds: pauseBetweenFileRebuildMilliseconds
        max_busy_time_minutes: maxBusyTimeMinutes
        device_access_app_server_cluster_name: deviceAccessAppServerClusterName
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int),
        E("ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int,
        ),
        E("max_busy_time_minutes", "maxBusyTimeMinutes", int),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
    )

    enable_ip_device_management: bool = Field(type=bool, required=False, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    pause_between_file_rebuild_milliseconds: int = Field(
        type=int, required=False, mutable=False,
    )
    max_busy_time_minutes: int = Field(type=int, required=False, mutable=False)
    device_access_app_server_cluster_name: str = Field(
        type=str, required=False, mutable=False,
    )


class SystemCPEConfigParametersModifyRequest21(OCIRequest):
    """
    Request to modify CPE Config system parameters.

    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Attributes:
        enable_ip_device_management: enableIPDeviceManagement
        ftp_connect_timeout_seconds: ftpConnectTimeoutSeconds
        ftp_file_transfer_timeout_seconds: ftpFileTransferTimeoutSeconds
        pause_between_file_rebuild_milliseconds: pauseBetweenFileRebuildMilliseconds
        device_access_app_server_cluster_name: deviceAccessAppServerClusterName
        min_time_between_reset_milliseconds: minTimeBetweenResetMilliseconds
        always_push_files_on_rebuild: alwaysPushFilesOnRebuild
        max_file_operation_retry_attempts: maxFileOperationRetryAttempts
        enable_auto_rebuild_config: enableAutoRebuildConfig
        event_queue_size: eventQueueSize
        allow_device_credentials_retrieval: allowDeviceCredentialsRetrieval
    """

    _ELEMENTS = (
        E("enable_ip_device_management", "enableIPDeviceManagement", bool),
        E("ftp_connect_timeout_seconds", "ftpConnectTimeoutSeconds", int),
        E("ftp_file_transfer_timeout_seconds", "ftpFileTransferTimeoutSeconds", int),
        E(
            "pause_between_file_rebuild_milliseconds",
            "pauseBetweenFileRebuildMilliseconds", int,
        ),
        E("device_access_app_server_cluster_name", "deviceAccessAppServerClusterName", str),
        E("min_time_between_reset_milliseconds", "minTimeBetweenResetMilliseconds", int),
        E("always_push_files_on_rebuild", "alwaysPushFilesOnRebuild", bool),
        E("max_file_operation_retry_attempts", "maxFileOperationRetryAttempts", int),
        E("enable_auto_rebuild_config", "enableAutoRebuildConfig", bool),
        E("event_queue_size", "eventQueueSize", int),
        E("allow_device_credentials_retrieval", "allowDeviceCredentialsRetrieval", bool),
    )

    enable_ip_device_management: bool = Field(type=bool, required=False, mutable=False)
    ftp_connect_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    ftp_file_transfer_timeout_seconds: int = Field(type=int, required=False, mutable=False)
    pause_between_file_rebuild_milliseconds: int = Field(
        type=int, required=False, mutable=False,
    )
    device_access_app_server_cluster_name: str = Field(
        type=str, required=False, mutable=False,
    )
    min_time_between_reset_milliseconds: int = Field(type=int, required=False, mutable=False)
    always_push_files_on_rebuild: bool = Field(type=bool, required=False, mutable=False)
    max_file_operation_retry_attempts: int = Field(type=int, required=False, mutable=False)
    enable_auto_rebuild_config: bool = Field(type=bool, required=False, mutable=False)
    event_queue_size: int = Field(type=int, required=False, mutable=False)
    allow_device_credentials_retrieval: bool = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigRebuildConfigFileRequest(OCIRequest):
    """
    Rebuild the system default config file for the specified device type.

    If the device type is not specified, all files for all device types in the system are
    rebuilt.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_type: deviceType
        rebuild_type: rebuildType
        force: force
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str),
        E("rebuild_type", "rebuildType", str),
        E("force", "force", bool),
    )

    device_type: str = Field(type=str, required=False, mutable=False)
    rebuild_type: str = Field(type=str, required=False, mutable=False)
    force: bool = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        force: force
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("force", "force", bool),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    force: bool = Field(type=bool, required=False, mutable=False)


class SystemCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a System device.

    You can not add or delete line ports, only re-ordering the list is allowed.  The
    ordered list of line ports can be obtained with the
    ``SystemAccessDeviceGetRequest16()`` command.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
        ordered_line_port_list: orderedLinePortList
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
        E("ordered_line_port_list", "orderedLinePortList", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)
    ordered_line_port_list: str = Field(type=str, required=True, mutable=False)


class SystemCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific system device.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_name: deviceName
    """

    _ELEMENTS = (
        E("device_name", "deviceName", str, is_required=True),
    )

    device_name: str = Field(type=str, required=True, mutable=False)


class SystemCPEConfigResetDeviceTypeRequest(OCIRequest):
    """
    Reset all the devices of the specified device type in the system.

    If the device type is not specified, all device in the system are reset.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_type: deviceType
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str),
    )

    device_type: str = Field(type=str, required=False, mutable=False)


class SystemCPEConfigSetConfigFileRequest(OCIRequest):
    """
    Request to set a new system default configuration file for a device type.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        device_type: deviceType
        config_file: configFile
    """

    _ELEMENTS = (
        E("device_type", "deviceType", str, is_required=True),
        E("config_file", "configFile", str, is_required=True),
    )

    device_type: str = Field(type=str, required=True, mutable=False)
    config_file: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the system branding information.

    The response is either ``SystemCallCenterEnhancedReportingBrandingGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingDataTemplateGetListRequest(OCIRequest):
    """
    Request to get the list of data template and the corresponding information in the
    system.

    The response is either a
    ``SystemCallCenterEnhancedReportingDataTemplateGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get the call center enhanced reporting system settings.

    The response is either a ``SystemCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Modify the system settings for call center enhanced reporting.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        archive_reports: archiveReports
        report_application_url: reportApplicationURL
        repository_application_url: repositoryApplicationURL
    """

    _ELEMENTS = (
        E("archive_reports", "archiveReports", bool),
        E("report_application_url", "reportApplicationURL", str),
        E("repository_application_url", "repositoryApplicationURL", str),
    )

    archive_reports: bool = Field(type=bool, required=False, mutable=False)
    report_application_url: str = Field(type=str, required=False, mutable=False)
    repository_application_url: str = Field(type=str, required=False, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete a system level call center report template.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get system level call center report template list.

    The response is either a
    ``SystemCallCenterEnhancedReportingReportTemplateGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get a system level call center report template.

    The response is either a
    ``SystemCallCenterEnhancedReportingReportTemplateGetResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(OCIRequest):
    """
    Request to get all the call center reporting scheduled report in the system that uses
    a given system level report template.

    The response is either a
    ``SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.

    Attributes:
        name: name
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
    )

    name: str = Field(type=str, required=True, mutable=False)


class SystemCallCenterEnhancedReportingScheduledTaskParametersGetRequest(OCIRequest):
    """
    Request to get the system settings for the call center enhanced reporting scheduling
    tasks.

    The response is either a
    ``SystemCallCenterEnhancedReportingScheduledTaskParametersGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterEnhancedReportingScheduledTaskParametersModifyRequest(OCIRequest):
    """
    Modify the system settings for the call center enhanced reporting scheduling tasks.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        scheduled_report_search_interval_minutes: scheduledReportSearchIntervalMinutes
        maximum_scheduled_reports_per_interval: maximumScheduledReportsPerInterval
        delete_scheduled_report_days_after_completion:
            deleteScheduledReportDaysAfterCompletion
    """

    _ELEMENTS = (
        E(
            "scheduled_report_search_interval_minutes",
            "scheduledReportSearchIntervalMinutes", int,
        ),
        E(
            "maximum_scheduled_reports_per_interval",
            "maximumScheduledReportsPerInterval", int,
        ),
        E(
            "delete_scheduled_report_days_after_completion",
            "deleteScheduledReportDaysAfterCompletion", int,
        ),
    )

    scheduled_report_search_interval_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    maximum_scheduled_reports_per_interval: int = Field(
        type=int, required=False, mutable=False,
    )
    delete_scheduled_report_days_after_completion: int = Field(
        type=int, required=False, mutable=False,
    )


class SystemCallCenterGetRequest(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse()`` or an ``ErrorResponse()``.

    Replaced By: ``SystemCallCenterGetRequest14sp9()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest14sp9(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse14sp9()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemCallCenterGetRequest16()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest16(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse16()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemCallCenterGetRequest17()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest17(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse17()`` or an
    ``ErrorResponse()``. Replaced by ``SystemCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``. Replaced by: ``SystemCallCenterGetRequest19()``
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest19(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse19()`` or an
    ``ErrorResponse()``. Replaced by ``SystemCallCenterGetRequest21()``.
    """

    _ELEMENTS = ()


class SystemCallCenterGetRequest21(OCIRequest):
    """
    Request the system level data associated with Call Center.

    The response is either a ``SystemCallCenterGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallCenterModifyRequest(OCIRequest):
    """
    Modify the system level data associated with Call Center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        default_from_address: defaultFromAddress
        statistics_sampling_period_minutes: statisticsSamplingPeriodMinutes
        default_enable_guard_timer: defaultEnableGuardTimer
        default_guard_timer_seconds: defaultGuardTimerSeconds
        force_agent_unavailable_on_dnd_activation: forceAgentUnavailableOnDNDActivation
        force_agent_unavailable_on_personal_calls: forceAgentUnavailableOnPersonalCalls
        force_agent_unavailable_on_bounced_call_limit:
            forceAgentUnavailableOnBouncedCallLimit
        number_consecutive_bounced_calls_to_force_agent_unavailable:
            numberConsecutiveBouncedCallsToForceAgentUnavailable
        force_agent_unavailable_on_not_reachable: forceAgentUnavailableOnNotReachable
        default_play_ring_when_offer_call: defaultPlayRingWhenOfferCall
        uniform_call_distribution_policy_scope: uniformCallDistributionPolicyScope
        call_handling_sampling_period_minutes: callHandlingSamplingPeriodMinutes
        call_handling_minimum_sampling_size: callHandlingMinimumSamplingSize
        play_tone_to_agent_for_emergency_call: playToneToAgentForEmergencyCall
        emergency_call_clid_prefix: emergencyCallCLIDPrefix
        threshold_crossing_notification_email_guard_timer_seconds:
            thresholdCrossingNotificationEmailGuardTimerSeconds
        allow_agent_device_initiated_forward: allowAgentDeviceInitiatedForward
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str),
        E("statistics_sampling_period_minutes", "statisticsSamplingPeriodMinutes", int),
        E("default_enable_guard_timer", "defaultEnableGuardTimer", bool),
        E("default_guard_timer_seconds", "defaultGuardTimerSeconds", int),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation", bool,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls", bool,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit", bool,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable", int,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable", bool,
        ),
        E("default_play_ring_when_offer_call", "defaultPlayRingWhenOfferCall", bool),
        E(
            "uniform_call_distribution_policy_scope",
            "uniformCallDistributionPolicyScope", str,
        ),
        E("call_handling_sampling_period_minutes", "callHandlingSamplingPeriodMinutes", int),
        E("call_handling_minimum_sampling_size", "callHandlingMinimumSamplingSize", int),
        E("play_tone_to_agent_for_emergency_call", "playToneToAgentForEmergencyCall", bool),
        E("emergency_call_clid_prefix", "emergencyCallCLIDPrefix", str),
        E(
            "threshold_crossing_notification_email_guard_timer_seconds",
            "thresholdCrossingNotificationEmailGuardTimerSeconds", int,
        ),
        E("allow_agent_device_initiated_forward", "allowAgentDeviceInitiatedForward", bool),
    )

    default_from_address: str = Field(type=str, required=False, mutable=False)
    statistics_sampling_period_minutes: int = Field(type=int, required=False, mutable=False)
    default_enable_guard_timer: bool = Field(type=bool, required=False, mutable=False)
    default_guard_timer_seconds: int = Field(type=int, required=False, mutable=False)
    force_agent_unavailable_on_dnd_activation: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_personal_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    force_agent_unavailable_on_bounced_call_limit: bool = Field(
        type=bool, required=False, mutable=False,
    )
    number_consecutive_bounced_calls_to_force_agent_unavailable: int = Field(
        type=int, required=False, mutable=False,
    )
    force_agent_unavailable_on_not_reachable: bool = Field(
        type=bool, required=False, mutable=False,
    )
    default_play_ring_when_offer_call: bool = Field(type=bool, required=False, mutable=False)
    uniform_call_distribution_policy_scope: str = Field(
        type=str, required=False, mutable=False,
    )
    call_handling_sampling_period_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    call_handling_minimum_sampling_size: int = Field(type=int, required=False, mutable=False)
    play_tone_to_agent_for_emergency_call: bool = Field(
        type=bool, required=False, mutable=False,
    )
    emergency_call_clid_prefix: str = Field(type=str, required=False, mutable=False)
    threshold_crossing_notification_email_guard_timer_seconds: int = Field(
        type=int, required=False, mutable=False,
    )
    allow_agent_device_initiated_forward: bool = Field(
        type=bool, required=False, mutable=False,
    )


class SystemCallCenterReportingServerGetListRequest(OCIRequest):
    """
    Request to get a list of Call Center Reporting Server.

    The response is either ``SystemCallCenterReportingServerGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallMeNowGetRequest(OCIRequest):
    """
    Request the system level data associated with Call Me Now service.

    The response is either a ``SystemCallMeNowGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallMeNowModifyRequest(OCIRequest):
    """
    Modify the system level data associated with Call me now service.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        passcode_length: passcodeLength
        passcode_timeout_seconds: passcodeTimeoutSeconds
    """

    _ELEMENTS = (
        E("passcode_length", "passcodeLength", int),
        E("passcode_timeout_seconds", "passcodeTimeoutSeconds", int),
    )

    passcode_length: int = Field(type=int, required=False, mutable=False)
    passcode_timeout_seconds: int = Field(type=int, required=False, mutable=False)


class SystemCallNotifyGetRequest(OCIRequest):
    """
    Request the system level data associated with Call Notify.

    The response is either a ``SystemCallNotifyGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallNotifyModifyRequest(OCIRequest):
    """
    Modify the system level data associated with Call Notify.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        default_from_address: defaultFromAddress
        use_short_subject_line: useShortSubjectLine
        use_dn_in_mail_body: useDnInMailBody
    """

    _ELEMENTS = (
        E("default_from_address", "defaultFromAddress", str),
        E("use_short_subject_line", "useShortSubjectLine", bool),
        E("use_dn_in_mail_body", "useDnInMailBody", bool),
    )

    default_from_address: str = Field(type=str, required=False, mutable=False)
    use_short_subject_line: bool = Field(type=bool, required=False, mutable=False)
    use_dn_in_mail_body: bool = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14sp4()`` or an
    ``ErrorResponse()``.

    Replaced By : ``SystemCallProcessingGetPolicyRequest15()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse14sp7()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.

    Replaced By: ``SystemCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse15sp2()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse16sp2()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest17(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``.

    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the system level data associated with Call Processing Policy.

    The response is either a ``SystemCallProcessingGetPolicyResponse17sp3()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse17sp4()`` or an
    ``ErrorResponse()``.

    Replaced By : ``SystemCallProcessingGetPolicyRequest18sp1()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse18sp1()`` or an
    ``ErrorResponse()``.

    Replaced by: ``SystemCallProcessingGetPolicyRequest19sp1()``
    """

    _ELEMENTS = ()


class SystemCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    The response is either a ``SystemCallProcessingGetPolicyResponse19sp1()`` or an
    ``ErrorResponse()``.

    """

    _ELEMENTS = ()


class SystemCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the system level data associated with Call Processing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By : ``SystemCallProcessingModifyPolicyRequest15()``

    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_external_calls_via_private_dialing_plan:
            overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_external_calls_via_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )
    clid_policy: str = Field(type=str, required=False, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )


class SystemCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the system level data associated with Call Processing Policy.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. The
    following elements are only used in AS data mode: enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity enterpriseCallsCLIDPolicy
    enterpriseGroupCallsCLIDPolicy serviceProviderGroupCallsCLIDPolicy

    Attributes:
        use_max_simultaneous_calls: useMaxSimultaneousCalls
        max_simultaneous_calls: maxSimultaneousCalls
        use_max_simultaneous_video_calls: useMaxSimultaneousVideoCalls
        max_simultaneous_video_calls: maxSimultaneousVideoCalls
        use_max_call_time_for_answered_calls: useMaxCallTimeForAnsweredCalls
        max_call_time_for_answered_calls_minutes: maxCallTimeForAnsweredCallsMinutes
        use_max_call_time_for_unanswered_calls: useMaxCallTimeForUnansweredCalls
        max_call_time_for_unanswered_calls_minutes: maxCallTimeForUnansweredCallsMinutes
        media_policy_selection: mediaPolicySelection
        supported_media_set_name: supportedMediaSetName
        network_usage_selection: networkUsageSelection
        enforce_group_calling_line_identity_restriction:
            enforceGroupCallingLineIdentityRestriction
        enforce_enterprise_calling_line_identity_restriction:
            enforceEnterpriseCallingLineIdentityRestriction
        allow_enterprise_group_call_typing_for_private_dialing_plan:
            allowEnterpriseGroupCallTypingForPrivateDialingPlan
        allow_enterprise_group_call_typing_for_public_dialing_plan:
            allowEnterpriseGroupCallTypingForPublicDialingPlan
        override_clid_restriction_for_private_call_category:
            overrideCLIDRestrictionForPrivateCallCategory
        use_enterprise_clid_for_private_call_category:
            useEnterpriseCLIDForPrivateCallCategory
        enable_enterprise_extension_dialing: enableEnterpriseExtensionDialing
        conference_uri: conferenceURI
        max_conference_parties: maxConferenceParties
        use_max_concurrent_redirected_calls: useMaxConcurrentRedirectedCalls
        max_concurrent_redirected_calls: maxConcurrentRedirectedCalls
        use_max_find_me_follow_me_depth: useMaxFindMeFollowMeDepth
        max_find_me_follow_me_depth: maxFindMeFollowMeDepth
        max_redirection_depth: maxRedirectionDepth
        use_max_concurrent_find_me_follow_me_invocations:
            useMaxConcurrentFindMeFollowMeInvocations
        max_concurrent_find_me_follow_me_invocations:
            maxConcurrentFindMeFollowMeInvocations
        clid_policy: clidPolicy
        emergency_clid_policy: emergencyClidPolicy
        allow_alternate_numbers_for_redirecting_identity:
            allowAlternateNumbersForRedirectingIdentity
        enable_dialable_caller_id: enableDialableCallerID
        block_calling_name_for_external_calls: blockCallingNameForExternalCalls
        allow_configurable_clid_for_redirecting_identity:
            allowConfigurableCLIDForRedirectingIdentity
        enterprise_calls_clid_policy: enterpriseCallsCLIDPolicy
        enterprise_group_calls_clid_policy: enterpriseGroupCallsCLIDPolicy
        service_provider_group_calls_clid_policy: serviceProviderGroupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_call_time_for_unanswered_calls", "useMaxCallTimeForUnansweredCalls", bool),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes", int,
        ),
        E("media_policy_selection", "mediaPolicySelection", str),
        E("supported_media_set_name", "supportedMediaSetName", str),
        E("network_usage_selection", "networkUsageSelection", str),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E("conference_uri", "conferenceURI", str),
        E("max_conference_parties", "maxConferenceParties", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("clid_policy", "clidPolicy", str),
        E("emergency_clid_policy", "emergencyClidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
    )

    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_call_time_for_unanswered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_unanswered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    media_policy_selection: str = Field(type=str, required=False, mutable=False)
    supported_media_set_name: str = Field(type=str, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    conference_uri: str = Field(type=str, required=False, mutable=False)
    max_conference_parties: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    use_max_find_me_follow_me_depth: bool = Field(type=bool, required=False, mutable=False)
    max_find_me_follow_me_depth: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_find_me_follow_me_invocations: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_find_me_follow_me_invocations: int = Field(
        type=int, required=False, mutable=False,
    )
    clid_policy: str = Field(type=str, required=False, mutable=False)
    emergency_clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enable_dialable_caller_id: bool = Field(type=bool, required=False, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    enterprise_group_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    service_provider_group_calls_clid_policy: str = Field(
        type=str, required=False, mutable=False,
    )


class SystemCallProcessingPolicyProfileAddRequest(OCIRequest):
    """
    Add a call processing policy profile to system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``. Replaced by
    ``SystemCallProcessingPolicyProfileAddRequest20()``.

    Attributes:
        name: name
        description: description
        assigned_subscriber_type: assignedSubscriberType
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("assigned_subscriber_type", "assignedSubscriberType", str, is_array=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    assigned_subscriber_type: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAddRequest20(OCIRequest):
    """
    Add a call processing policy profile to system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        name: name
        description: description
        assigned_subscriber_type: assignedSubscriberType
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("assigned_subscriber_type", "assignedSubscriberType", str, is_array=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    assigned_subscriber_type: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAddRequest21(OCIRequest):
    """
    Add a call processing policy profile to system.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Attributes:
        name: name
        description: description
        assigned_subscriber_type: assignedSubscriberType
    """

    _ELEMENTS = (
        E("name", "name", str, is_required=True),
        E("description", "description", str),
        E("assigned_subscriber_type", "assignedSubscriberType", str, is_array=True),
    )

    name: str = Field(type=str, required=True, mutable=False)
    description: str = Field(type=str, required=False, mutable=False)
    assigned_subscriber_type: "List[str]" = Field(type=list, required=False, mutable=False)


class SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Auto Attendant
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequestResponse()`` or an
    ``ErrorResponse()``. The response contains the call processing policy profile setting
    for Auto Attendant.

    Attributes:
        call_processing_policy_profile_name: callProcessingPolicyProfileName
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    call_processing_policy_profile_name: str = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileAutoAttendantProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_call_time_for_answered_calls", "useMaxCallTimeForAnsweredCalls", bool),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes", int,
        ),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    call_processing_policy_profile_name: str = Field(type=str, required=True, mutable=False)
    use_clid_policy: bool = Field(type=bool, required=False, mutable=False)
    clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=False, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_department_clid_name_override: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    enterprise_group_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    service_provider_group_calls_clid_policy: str = Field(
        type=str, required=False, mutable=False,
    )
    use_call_limits_policy: bool = Field(type=bool, required=False, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_call_time_for_answered_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_call_time_for_answered_calls_minutes: int = Field(
        type=int, required=False, mutable=False,
    )
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_translation_routing_policy: bool = Field(type=bool, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_incoming_clid_policy: bool = Field(type=bool, required=False, mutable=False)
    enable_dialable_caller_id: bool = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile BroadWorks
    Anywhere subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileGetRequestResponse()`` or
    an ``ErrorResponse()``.

    Attributes:
        call_processing_policy_profile_name: callProcessingPolicyProfileName
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    call_processing_policy_profile_name: str = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan", bool,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan", bool,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory", bool,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory", bool,
        ),
        E("use_incoming_clid_policy", "useIncomingCLIDPolicy", bool),
        E("enable_dialable_caller_id", "enableDialableCallerID", bool),
    )

    call_processing_policy_profile_name: str = Field(type=str, required=True, mutable=False)
    use_clid_policy: bool = Field(type=bool, required=False, mutable=False)
    clid_policy: str = Field(type=str, required=False, mutable=False)
    allow_alternate_numbers_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_group_name: bool = Field(type=bool, required=False, mutable=False)
    block_calling_name_for_external_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_configurable_clid_for_redirecting_identity: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_department_clid_name_override: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enterprise_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    enterprise_group_calls_clid_policy: str = Field(type=str, required=False, mutable=False)
    service_provider_group_calls_clid_policy: str = Field(
        type=str, required=False, mutable=False,
    )
    use_call_limits_policy: bool = Field(type=bool, required=False, mutable=False)
    use_max_simultaneous_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_calls: int = Field(type=int, required=False, mutable=False)
    use_max_simultaneous_video_calls: bool = Field(type=bool, required=False, mutable=False)
    max_simultaneous_video_calls: int = Field(type=int, required=False, mutable=False)
    use_max_concurrent_redirected_calls: bool = Field(
        type=bool, required=False, mutable=False,
    )
    max_concurrent_redirected_calls: int = Field(type=int, required=False, mutable=False)
    max_redirection_depth: int = Field(type=int, required=False, mutable=False)
    use_translation_routing_policy: bool = Field(type=bool, required=False, mutable=False)
    network_usage_selection: str = Field(type=str, required=False, mutable=False)
    enable_enterprise_extension_dialing: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_group_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    enforce_enterprise_calling_line_identity_restriction: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_private_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    allow_enterprise_group_call_typing_for_public_dialing_plan: bool = Field(
        type=bool, required=False, mutable=False,
    )
    override_clid_restriction_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_enterprise_clid_for_private_call_category: bool = Field(
        type=bool, required=False, mutable=False,
    )
    use_incoming_clid_policy: bool = Field(type=bool, required=False, mutable=False)
    enable_dialable_caller_id: bool = Field(type=bool, required=False, mutable=False)


class SystemCallProcessingPolicyProfileCallCenterProfileGetRequest(OCIRequest):
    """
    Request to get the configuration for a call processing policy profile Call Center
    subscriber type profile.

    The response is either a
    ``SystemCallProcessingPolicyProfileCallCenterProfileGetRequestResponse()`` or an
    ``ErrorResponse()``.

    Attributes:
        call_processing_policy_profile_name: callProcessingPolicyProfileName
    """

    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
    )

    call_processing_policy_profile_name: str = Field(type=str, required=True, mutable=False)


class SystemCallProcessingPolicyProfileCallCenterProfileModifyRequest(OCIRequest):
    _ELEMENTS = (
        E(
            "call_processing_policy_profile_name", "callProcessingPolicyProfileName", str,
            is_required=True,
        ),
        E("use_clid_policy", "useCLIDPolicy", bool),
        E("clid_policy", "clidPolicy", str),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity", bool,
        ),
        E("use_group_name", "useGroupName", bool),
        E("block_calling_name_for_external_calls", "blockCallingNameForExternalCalls", bool),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity", bool,
        ),
        E("allow_department_clid_name_override", "allowDepartmentCLIDNameOverride", bool),
        E("enterprise_calls_clid_policy", "enterpriseCallsCLIDPolicy", str),
        E("enterprise_group_calls_clid_policy", "enterpriseGroupCallsCLIDPolicy", str),
        E(
            "service_provider_group_calls_clid_policy",
            "serviceProviderGroupCallsCLIDPolicy", str,
        ),
        E("use_call_limits_policy", "useCallLimitsPolicy", bool),
        E("use_max_simultaneous_calls", "useMaxSimultaneousCalls", bool),
        E("max_simultaneous_calls", "maxSimultaneousCalls", int),
        E("use_max_simultaneous_video_calls", "useMaxSimultaneousVideoCalls", bool),
        E("max_simultaneous_video_calls", "maxSimultaneousVideoCalls", int),
        E("use_max_concurrent_redirected_calls", "useMaxConcurrentRedirectedCalls", bool),
        E("max_concurrent_redirected_calls", "maxConcurrentRedirectedCalls", int),
        E("use_max_find_me_follow_me_depth", "useMaxFindMeFollowMeDepth", bool),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations", bool,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations", int,
        ),
        E("max_find_me_follow_me_depth", "maxFindMeFollowMeDepth", int),
        E("max_redirection_depth", "maxRedirectionDepth", int),
        E("use_translation_routing_policy", "useTranslationRoutingPolicy", bool),
        E("network_usage_selection", "networkUsageSelection", str),
        E("enable_enterprise_extension_dialing", "enableEnterpriseExtensionDialing", bool),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction", bool,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",