"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("assert");
const lib_1 = require("../lib");
test.each([
    [lib_1.Weekday.SUNDAY, 0, 0, '0:00:00'],
    [lib_1.Weekday.SATURDAY, 0, 0, '6:00:00'],
    [lib_1.Weekday.SUNDAY, 24, 0, '0:24:00'],
    [lib_1.Weekday.SUNDAY, 0, 59, '0:00:59'],
])('valid maintenance time %s:%d:%d returns %s', (day, hour, minute, expected) => {
    assert_1.strictEqual(new lib_1.LustreMaintenanceTime({ day, hour, minute }).toTimestamp(), expected);
});
test.each([
    [lib_1.Weekday.TUESDAY, -1, 0],
    [lib_1.Weekday.TUESDAY, 25, 0],
    [lib_1.Weekday.TUESDAY, 1.2, 0],
])('invalid maintenance time hour %s:%d:%d', (day, hour, minute) => {
    expect(() => {
        new lib_1.LustreMaintenanceTime({ day, hour, minute });
    }).toThrowError('Maintenance time hour must be an integer between 0 and 24');
});
test.each([
    [lib_1.Weekday.TUESDAY, 0, -1],
    [lib_1.Weekday.TUESDAY, 0, 60],
    [lib_1.Weekday.TUESDAY, 0, 1.2],
])('invalid maintenance time minute %s:%d:%d', (day, hour, minute) => {
    expect(() => {
        new lib_1.LustreMaintenanceTime({ day, hour, minute });
    }).toThrowError('Maintenance time minute must be an integer between 0 and 59');
});
//# sourceMappingURL=data:application/json;base64,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