# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

# `myst-alpha` package

The following release notes pertain to the `myst-alpha` package, where development is ongoing while the API is unstable.

## [0.1.3](https://pypi.org/project/myst-alpha/0.1.3/) - 2021-09-10

### Changed

- Loosened version restrictions on several dependencies.
- Service account authentication has correct audience specified.
- Dependency on numpy.typing module removed.

## [0.1.2](https://pypi.org/project/myst-alpha/0.1.2/) - 2021-09-02

### Changed

- API host is now configurable via `myst.settings.MYST_API_HOST`.
- Bugfix: Validation errors (HTTP 422) handled properly.
- Bugfix: Specifying the environment variable `MYST_APPLICATION_CREDENTIALS` no longer causes `import myst` to fail.
- Bugfix: Don't assume that the directory `~/.config` already exists.

### Added

- Added py.typed file per PEP 561.

## [0.1.1](https://pypi.org/project/myst-alpha/0.1.1/) - 2021-08-16

### Changed

- Default API host set to production instance rather than dev.

## [0.1.0](https://pypi.org/project/myst-alpha/0.1.0/) - 2021-08-12

### Changed

- Client handwritten rather than auto-generated.
- Only non-auth methods are `TimeSeries.get`, `TimeSeries.query_time_array`, and `TimeSeries.insert_time_array`.

## [0.0.1](https://pypi.org/project/myst-alpha/0.0.1/) - 2021-07-09

### Added

- New API routes and endpoints for deletion
- API routes and endpoints for policies and project results

### Changed

- Re-factored client generation to be compatible with python packaging

This is the initial `myst-alpha` release.

### Added

- Authentication via Google credentials
- Interact with [Myst's](https://myst.ai) `v1alpha2` API via auto-generated OpenAPI client
- Initial (concealed) CLI via `typer`
- Tested using `pytest` and matrix tests via Github Actions

# `myst` package

Prior to the interim period of development of the `myst-alpha` project, releases were under `myst` (and will be again).

## [1.0.4](https://pypi.org/project/myst/1.0.4/) - 2020-12-01

### Added

- Switched to using soft dependency matching in `requirements.txt` to play nicely with `pip` version 20.3's (see
  [`pip` changelog](https://pip.pypa.io/en/stable/news/) for details) new strict dependency resolution.

## [1.0.3](https://pypi.org/project/myst/1.0.3/) - 2020-08-27

### Added

- Improved authentication logic that only refreshes Google OAuth credentials when they expire, which reduces
  authentication rate limiting.

## [1.0.2](https://pypi.org/project/myst/1.0.2/) - 2020-03-30

### Added

- Improved retry logic that retries native Python errors, including network-related errors like `ConnectionError`.

### Changed

- Upgraded `google-auth` dependency to version 1.11.0.

## [1.0.1](https://pypi.org/project/myst/1.0.1/) - 2020-01-06

### Added

- Basic retry logic.
- Support for passing the `service_account_key_file_path` to `myst.authenticate` without having to also specify the `use_service_account` flag.

### Changed

- Renamed `TimeSeries.fetch_data` to `TimeSeries.fetch_data_series`.

## [1.0.0](https://pypi.org/project/myst/1.0.0/) - 2020-01-06 [YANKED]

### Added

- Basic retry logic.
- Support for passing the `service_account_key_file_path` to `myst.authenticate` without having to also specify the `use_service_account` flag.

## [0.1.1](https://pypi.org/project/myst/0.1.1/) - 2019-09-17

### Added

- First official `myst` release
- Support for authenticating using a Google User Account
- Support for authenticating with a Myst AI Service Account
- Support for listing, getting, and fetching data for `TimeSeries`
- Support for caching and clearing credentials locally

## [0.0.1](https://pypi.org/project/myst/0.0.1/) - 2019-05-01

### Added

- Initial empty `myst` release
