# Copyright 2025 KTTC AI (https://github.com/kttc-ai)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Training and adaptation modules for KTTC.

Provides domain adaptation and fine-tuning capabilities:
- Domain-specific agent customization
- Prompt adaptation based on training data
- Pattern extraction from domain corpora
"""

from __future__ import annotations

from kttc.training.domain_adapter import DomainAdapter, DomainPatterns

__all__ = ["DomainAdapter", "DomainPatterns"]
