# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ContainerRecipeComponentConfigurationArgs',
    'ContainerRecipeEbsInstanceBlockDeviceSpecificationArgs',
    'ContainerRecipeInstanceBlockDeviceMappingArgs',
    'ContainerRecipeInstanceConfigurationArgs',
    'ContainerRecipeTargetContainerRepositoryArgs',
    'DistributionConfigurationAmiDistributionConfigurationArgs',
    'DistributionConfigurationContainerDistributionConfigurationArgs',
    'DistributionConfigurationDistributionArgs',
    'DistributionConfigurationLaunchPermissionConfigurationArgs',
    'DistributionConfigurationLaunchTemplateConfigurationArgs',
    'DistributionConfigurationTargetContainerRepositoryArgs',
    'ImagePipelineImageTestsConfigurationArgs',
    'ImagePipelineScheduleArgs',
    'ImageRecipeAdditionalInstanceConfigurationArgs',
    'ImageRecipeComponentConfigurationArgs',
    'ImageRecipeComponentParameterArgs',
    'ImageRecipeEbsInstanceBlockDeviceSpecificationArgs',
    'ImageRecipeInstanceBlockDeviceMappingArgs',
    'ImageRecipeSystemsManagerAgentArgs',
    'ImageTestsConfigurationArgs',
    'InfrastructureConfigurationInstanceMetadataOptionsArgs',
    'InfrastructureConfigurationLoggingArgs',
    'InfrastructureConfigurationS3LogsArgs',
]

@pulumi.input_type
class ContainerRecipeComponentConfigurationArgs:
    def __init__(__self__, *,
                 component_arn: Optional[pulumi.Input[str]] = None):
        """
        Configuration details of the component.
        :param pulumi.Input[str] component_arn: The Amazon Resource Name (ARN) of the component.
        """
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the component.
        """
        return pulumi.get(self, "component_arn")

    @component_arn.setter
    def component_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_arn", value)


@pulumi.input_type
class ContainerRecipeEbsInstanceBlockDeviceSpecificationArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType']] = None):
        """
        Amazon EBS-specific block device mapping specifications. 
        :param pulumi.Input[bool] delete_on_termination: Use to configure delete on termination of the associated device.
        :param pulumi.Input[bool] encrypted: Use to configure device encryption.
        :param pulumi.Input[int] iops: Use to configure device IOPS.
        :param pulumi.Input[str] kms_key_id: Use to configure the KMS key to use when encrypting the device.
        :param pulumi.Input[str] snapshot_id: The snapshot that defines the device contents.
        :param pulumi.Input[int] throughput: For GP3 volumes only – The throughput in MiB/s that the volume supports.
        :param pulumi.Input[int] volume_size: Use to override the device's volume size.
        :param pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType'] volume_type: Use to override the device's volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Use to configure delete on termination of the associated device.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Use to configure device encryption.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Use to configure device IOPS.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Use to configure the KMS key to use when encrypting the device.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot that defines the device contents.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        For GP3 volumes only – The throughput in MiB/s that the volume supports.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Use to override the device's volume size.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType']]:
        """
        Use to override the device's volume type.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationVolumeType']]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ContainerRecipeInstanceBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[str]] = None,
                 ebs: Optional[pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationArgs']] = None,
                 no_device: Optional[pulumi.Input[str]] = None,
                 virtual_name: Optional[pulumi.Input[str]] = None):
        """
        Defines block device mappings for the instance used to configure your image. 
        :param pulumi.Input[str] device_name: The device to which these mappings apply.
        :param pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationArgs'] ebs: Use to manage Amazon EBS-specific configuration for this mapping.
        :param pulumi.Input[str] no_device: Use to remove a mapping from the parent image.
        :param pulumi.Input[str] virtual_name: Use to manage instance ephemeral devices.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        The device to which these mappings apply.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationArgs']]:
        """
        Use to manage Amazon EBS-specific configuration for this mapping.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['ContainerRecipeEbsInstanceBlockDeviceSpecificationArgs']]):
        pulumi.set(self, "ebs", value)

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[str]]:
        """
        Use to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_device", value)

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[str]]:
        """
        Use to manage instance ephemeral devices.
        """
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_name", value)


@pulumi.input_type
class ContainerRecipeInstanceConfigurationArgs:
    def __init__(__self__, *,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceBlockDeviceMappingArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None):
        """
        A group of options that can be used to configure an instance for building and testing container images.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceBlockDeviceMappingArgs']]] block_device_mappings: Defines the block devices to attach for building an instance from this Image Builder AMI.
        :param pulumi.Input[str] image: The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceBlockDeviceMappingArgs']]]]:
        """
        Defines the block devices to attach for building an instance from this Image Builder AMI.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class ContainerRecipeTargetContainerRepositoryArgs:
    def __init__(__self__, *,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input['ContainerRecipeTargetContainerRepositoryService']] = None):
        """
        The container repository where the output container image is stored.
        :param pulumi.Input[str] repository_name: The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        :param pulumi.Input['ContainerRecipeTargetContainerRepositoryService'] service: Specifies the service in which this image was registered.
        """
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['ContainerRecipeTargetContainerRepositoryService']]:
        """
        Specifies the service in which this image was registered.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['ContainerRecipeTargetContainerRepositoryService']]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class DistributionConfigurationAmiDistributionConfigurationArgs:
    def __init__(__self__, *,
                 ami_tags: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 launch_permission_configuration: Optional[pulumi.Input['DistributionConfigurationLaunchPermissionConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The specific AMI settings (for example, launch permissions, AMI tags).
        :param Any ami_tags: The tags to apply to AMIs distributed to this Region.
        :param pulumi.Input[str] description: The description of the AMI distribution configuration.
        :param pulumi.Input[str] kms_key_id: The KMS key identifier used to encrypt the distributed image.
        :param pulumi.Input[str] name: The name of the AMI distribution configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_account_ids: The ID of accounts to which you want to distribute an image.
        """
        if ami_tags is not None:
            pulumi.set(__self__, "ami_tags", ami_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if launch_permission_configuration is not None:
            pulumi.set(__self__, "launch_permission_configuration", launch_permission_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_account_ids is not None:
            pulumi.set(__self__, "target_account_ids", target_account_ids)

    @property
    @pulumi.getter(name="amiTags")
    def ami_tags(self) -> Optional[Any]:
        """
        The tags to apply to AMIs distributed to this Region.
        """
        return pulumi.get(self, "ami_tags")

    @ami_tags.setter
    def ami_tags(self, value: Optional[Any]):
        pulumi.set(self, "ami_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the AMI distribution configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key identifier used to encrypt the distributed image.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="launchPermissionConfiguration")
    def launch_permission_configuration(self) -> Optional[pulumi.Input['DistributionConfigurationLaunchPermissionConfigurationArgs']]:
        return pulumi.get(self, "launch_permission_configuration")

    @launch_permission_configuration.setter
    def launch_permission_configuration(self, value: Optional[pulumi.Input['DistributionConfigurationLaunchPermissionConfigurationArgs']]):
        pulumi.set(self, "launch_permission_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the AMI distribution configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetAccountIds")
    def target_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of accounts to which you want to distribute an image.
        """
        return pulumi.get(self, "target_account_ids")

    @target_account_ids.setter
    def target_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_account_ids", value)


@pulumi.input_type
class DistributionConfigurationContainerDistributionConfigurationArgs:
    def __init__(__self__, *,
                 container_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 target_repository: Optional[pulumi.Input['DistributionConfigurationTargetContainerRepositoryArgs']] = None):
        """
        Container distribution settings for encryption, licensing, and sharing in a specific Region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_tags: Tags that are attached to the container distribution configuration.
        :param pulumi.Input[str] description: The description of the container distribution configuration.
        :param pulumi.Input['DistributionConfigurationTargetContainerRepositoryArgs'] target_repository: The destination repository for the container distribution configuration.
        """
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if target_repository is not None:
            pulumi.set(__self__, "target_repository", target_repository)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags that are attached to the container distribution configuration.
        """
        return pulumi.get(self, "container_tags")

    @container_tags.setter
    def container_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the container distribution configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> Optional[pulumi.Input['DistributionConfigurationTargetContainerRepositoryArgs']]:
        """
        The destination repository for the container distribution configuration.
        """
        return pulumi.get(self, "target_repository")

    @target_repository.setter
    def target_repository(self, value: Optional[pulumi.Input['DistributionConfigurationTargetContainerRepositoryArgs']]):
        pulumi.set(self, "target_repository", value)


@pulumi.input_type
class DistributionConfigurationDistributionArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 ami_distribution_configuration: Optional[pulumi.Input['DistributionConfigurationAmiDistributionConfigurationArgs']] = None,
                 container_distribution_configuration: Optional[pulumi.Input['DistributionConfigurationContainerDistributionConfigurationArgs']] = None,
                 launch_template_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationLaunchTemplateConfigurationArgs']]]] = None,
                 license_configuration_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The distributions of the distribution configuration.
        :param pulumi.Input[str] region: region
        :param pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationLaunchTemplateConfigurationArgs']]] launch_template_configurations: A group of launchTemplateConfiguration settings that apply to image distribution.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] license_configuration_arns: The License Manager Configuration to associate with the AMI in the specified Region.
        """
        pulumi.set(__self__, "region", region)
        if ami_distribution_configuration is not None:
            pulumi.set(__self__, "ami_distribution_configuration", ami_distribution_configuration)
        if container_distribution_configuration is not None:
            pulumi.set(__self__, "container_distribution_configuration", container_distribution_configuration)
        if launch_template_configurations is not None:
            pulumi.set(__self__, "launch_template_configurations", launch_template_configurations)
        if license_configuration_arns is not None:
            pulumi.set(__self__, "license_configuration_arns", license_configuration_arns)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="amiDistributionConfiguration")
    def ami_distribution_configuration(self) -> Optional[pulumi.Input['DistributionConfigurationAmiDistributionConfigurationArgs']]:
        return pulumi.get(self, "ami_distribution_configuration")

    @ami_distribution_configuration.setter
    def ami_distribution_configuration(self, value: Optional[pulumi.Input['DistributionConfigurationAmiDistributionConfigurationArgs']]):
        pulumi.set(self, "ami_distribution_configuration", value)

    @property
    @pulumi.getter(name="containerDistributionConfiguration")
    def container_distribution_configuration(self) -> Optional[pulumi.Input['DistributionConfigurationContainerDistributionConfigurationArgs']]:
        return pulumi.get(self, "container_distribution_configuration")

    @container_distribution_configuration.setter
    def container_distribution_configuration(self, value: Optional[pulumi.Input['DistributionConfigurationContainerDistributionConfigurationArgs']]):
        pulumi.set(self, "container_distribution_configuration", value)

    @property
    @pulumi.getter(name="launchTemplateConfigurations")
    def launch_template_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationLaunchTemplateConfigurationArgs']]]]:
        """
        A group of launchTemplateConfiguration settings that apply to image distribution.
        """
        return pulumi.get(self, "launch_template_configurations")

    @launch_template_configurations.setter
    def launch_template_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationLaunchTemplateConfigurationArgs']]]]):
        pulumi.set(self, "launch_template_configurations", value)

    @property
    @pulumi.getter(name="licenseConfigurationArns")
    def license_configuration_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The License Manager Configuration to associate with the AMI in the specified Region.
        """
        return pulumi.get(self, "license_configuration_arns")

    @license_configuration_arns.setter
    def license_configuration_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "license_configuration_arns", value)


@pulumi.input_type
class DistributionConfigurationLaunchPermissionConfigurationArgs:
    def __init__(__self__, *,
                 organization_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organizational_unit_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Launch permissions can be used to configure which AWS accounts can use the AMI to launch instances.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] organization_arns: The ARN for an Amazon Web Services Organization that you want to share your AMI with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] organizational_unit_arns: The ARN for an Organizations organizational unit (OU) that you want to share your AMI with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: The name of the group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_ids: The AWS account ID.
        """
        if organization_arns is not None:
            pulumi.set(__self__, "organization_arns", organization_arns)
        if organizational_unit_arns is not None:
            pulumi.set(__self__, "organizational_unit_arns", organizational_unit_arns)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="organizationArns")
    def organization_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ARN for an Amazon Web Services Organization that you want to share your AMI with.
        """
        return pulumi.get(self, "organization_arns")

    @organization_arns.setter
    def organization_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "organization_arns", value)

    @property
    @pulumi.getter(name="organizationalUnitArns")
    def organizational_unit_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ARN for an Organizations organizational unit (OU) that you want to share your AMI with.
        """
        return pulumi.get(self, "organizational_unit_arns")

    @organizational_unit_arns.setter
    def organizational_unit_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "organizational_unit_arns", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The name of the group.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_groups", value)

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AWS account ID.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.input_type
class DistributionConfigurationLaunchTemplateConfigurationArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 set_default_version: Optional[pulumi.Input[bool]] = None):
        """
        launchTemplateConfiguration settings that apply to image distribution.
        :param pulumi.Input[str] account_id: The account ID that this configuration applies to.
        :param pulumi.Input[str] launch_template_id: Identifies the EC2 launch template to use.
        :param pulumi.Input[bool] set_default_version: Set the specified EC2 launch template as the default launch template for the specified account.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if set_default_version is not None:
            pulumi.set(__self__, "set_default_version", set_default_version)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID that this configuration applies to.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the EC2 launch template to use.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="setDefaultVersion")
    def set_default_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Set the specified EC2 launch template as the default launch template for the specified account.
        """
        return pulumi.get(self, "set_default_version")

    @set_default_version.setter
    def set_default_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "set_default_version", value)


@pulumi.input_type
class DistributionConfigurationTargetContainerRepositoryArgs:
    def __init__(__self__, *,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input['DistributionConfigurationTargetContainerRepositoryService']] = None):
        """
        The destination repository for the container image.
        :param pulumi.Input[str] repository_name: The repository name of target container repository.
        :param pulumi.Input['DistributionConfigurationTargetContainerRepositoryService'] service: The service of target container repository.
        """
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        The repository name of target container repository.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['DistributionConfigurationTargetContainerRepositoryService']]:
        """
        The service of target container repository.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['DistributionConfigurationTargetContainerRepositoryService']]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class ImagePipelineImageTestsConfigurationArgs:
    def __init__(__self__, *,
                 image_tests_enabled: Optional[pulumi.Input[bool]] = None,
                 timeout_minutes: Optional[pulumi.Input[int]] = None):
        """
        Image tests configuration.
        :param pulumi.Input[bool] image_tests_enabled: Defines if tests should be executed when building this image.
        :param pulumi.Input[int] timeout_minutes: The maximum time in minutes that tests are permitted to run.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines if tests should be executed when building this image.
        """
        return pulumi.get(self, "image_tests_enabled")

    @image_tests_enabled.setter
    def image_tests_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_tests_enabled", value)

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum time in minutes that tests are permitted to run.
        """
        return pulumi.get(self, "timeout_minutes")

    @timeout_minutes.setter
    def timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_minutes", value)


@pulumi.input_type
class ImagePipelineScheduleArgs:
    def __init__(__self__, *,
                 pipeline_execution_start_condition: Optional[pulumi.Input['ImagePipelineSchedulePipelineExecutionStartCondition']] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None):
        """
        The schedule of the image pipeline.
        :param pulumi.Input['ImagePipelineSchedulePipelineExecutionStartCondition'] pipeline_execution_start_condition: The condition configures when the pipeline should trigger a new image build.
        :param pulumi.Input[str] schedule_expression: The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
        """
        if pipeline_execution_start_condition is not None:
            pulumi.set(__self__, "pipeline_execution_start_condition", pipeline_execution_start_condition)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="pipelineExecutionStartCondition")
    def pipeline_execution_start_condition(self) -> Optional[pulumi.Input['ImagePipelineSchedulePipelineExecutionStartCondition']]:
        """
        The condition configures when the pipeline should trigger a new image build.
        """
        return pulumi.get(self, "pipeline_execution_start_condition")

    @pipeline_execution_start_condition.setter
    def pipeline_execution_start_condition(self, value: Optional[pulumi.Input['ImagePipelineSchedulePipelineExecutionStartCondition']]):
        pulumi.set(self, "pipeline_execution_start_condition", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)


@pulumi.input_type
class ImageRecipeAdditionalInstanceConfigurationArgs:
    def __init__(__self__, *,
                 systems_manager_agent: Optional[pulumi.Input['ImageRecipeSystemsManagerAgentArgs']] = None,
                 user_data_override: Optional[pulumi.Input[str]] = None):
        """
        Specify additional settings and launch scripts for your build instances.
        :param pulumi.Input['ImageRecipeSystemsManagerAgentArgs'] systems_manager_agent: Contains settings for the SSM agent on your build instance.
        :param pulumi.Input[str] user_data_override: Use this property to provide commands or a command script to run when you launch your build instance.
        """
        if systems_manager_agent is not None:
            pulumi.set(__self__, "systems_manager_agent", systems_manager_agent)
        if user_data_override is not None:
            pulumi.set(__self__, "user_data_override", user_data_override)

    @property
    @pulumi.getter(name="systemsManagerAgent")
    def systems_manager_agent(self) -> Optional[pulumi.Input['ImageRecipeSystemsManagerAgentArgs']]:
        """
        Contains settings for the SSM agent on your build instance.
        """
        return pulumi.get(self, "systems_manager_agent")

    @systems_manager_agent.setter
    def systems_manager_agent(self, value: Optional[pulumi.Input['ImageRecipeSystemsManagerAgentArgs']]):
        pulumi.set(self, "systems_manager_agent", value)

    @property
    @pulumi.getter(name="userDataOverride")
    def user_data_override(self) -> Optional[pulumi.Input[str]]:
        """
        Use this property to provide commands or a command script to run when you launch your build instance.
        """
        return pulumi.get(self, "user_data_override")

    @user_data_override.setter
    def user_data_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data_override", value)


@pulumi.input_type
class ImageRecipeComponentConfigurationArgs:
    def __init__(__self__, *,
                 component_arn: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]]] = None):
        """
        Configuration details of the component.
        :param pulumi.Input[str] component_arn: The Amazon Resource Name (ARN) of the component.
        :param pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]] parameters: A group of parameter settings that are used to configure the component for a specific recipe.
        """
        if component_arn is not None:
            pulumi.set(__self__, "component_arn", component_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the component.
        """
        return pulumi.get(self, "component_arn")

    @component_arn.setter
    def component_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_arn", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]]]:
        """
        A group of parameter settings that are used to configure the component for a specific recipe.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class ImageRecipeComponentParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Contains a key/value pair that sets the named component parameter.
        :param pulumi.Input[str] name: The name of the component parameter to set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] value: Sets the value for the named component parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component parameter to set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Sets the value for the named component parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ImageRecipeEbsInstanceBlockDeviceSpecificationArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType']] = None):
        """
        Amazon EBS-specific block device mapping specifications. 
        :param pulumi.Input[bool] delete_on_termination: Use to configure delete on termination of the associated device.
        :param pulumi.Input[bool] encrypted: Use to configure device encryption.
        :param pulumi.Input[int] iops: Use to configure device IOPS.
        :param pulumi.Input[str] kms_key_id: Use to configure the KMS key to use when encrypting the device.
        :param pulumi.Input[str] snapshot_id: The snapshot that defines the device contents.
        :param pulumi.Input[int] throughput: For GP3 volumes only – The throughput in MiB/s that the volume supports.
        :param pulumi.Input[int] volume_size: Use to override the device's volume size.
        :param pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType'] volume_type: Use to override the device's volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Use to configure delete on termination of the associated device.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Use to configure device encryption.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Use to configure device IOPS.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Use to configure the KMS key to use when encrypting the device.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The snapshot that defines the device contents.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        For GP3 volumes only – The throughput in MiB/s that the volume supports.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Use to override the device's volume size.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType']]:
        """
        Use to override the device's volume type.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationVolumeType']]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ImageRecipeInstanceBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[str]] = None,
                 ebs: Optional[pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationArgs']] = None,
                 no_device: Optional[pulumi.Input[str]] = None,
                 virtual_name: Optional[pulumi.Input[str]] = None):
        """
        Defines block device mappings for the instance used to configure your image. 
        :param pulumi.Input[str] device_name: The device to which these mappings apply.
        :param pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationArgs'] ebs: Use to manage Amazon EBS-specific configuration for this mapping.
        :param pulumi.Input[str] no_device: Use to remove a mapping from the parent image.
        :param pulumi.Input[str] virtual_name: Use to manage instance ephemeral devices.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        The device to which these mappings apply.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationArgs']]:
        """
        Use to manage Amazon EBS-specific configuration for this mapping.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['ImageRecipeEbsInstanceBlockDeviceSpecificationArgs']]):
        pulumi.set(self, "ebs", value)

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[str]]:
        """
        Use to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_device", value)

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[str]]:
        """
        Use to manage instance ephemeral devices.
        """
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_name", value)


@pulumi.input_type
class ImageRecipeSystemsManagerAgentArgs:
    def __init__(__self__, *,
                 uninstall_after_build: Optional[pulumi.Input[bool]] = None):
        """
        Contains settings for the SSM agent on your build instance.
        :param pulumi.Input[bool] uninstall_after_build: Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.
        """
        if uninstall_after_build is not None:
            pulumi.set(__self__, "uninstall_after_build", uninstall_after_build)

    @property
    @pulumi.getter(name="uninstallAfterBuild")
    def uninstall_after_build(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls whether the SSM agent is removed from your final build image, prior to creating the new AMI. If this is set to true, then the agent is removed from the final image. If it's set to false, then the agent is left in, so that it is included in the new AMI. The default value is false.
        """
        return pulumi.get(self, "uninstall_after_build")

    @uninstall_after_build.setter
    def uninstall_after_build(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "uninstall_after_build", value)


@pulumi.input_type
class ImageTestsConfigurationArgs:
    def __init__(__self__, *,
                 image_tests_enabled: Optional[pulumi.Input[bool]] = None,
                 timeout_minutes: Optional[pulumi.Input[int]] = None):
        """
        The image tests configuration used when creating this image.
        :param pulumi.Input[bool] image_tests_enabled: ImageTestsEnabled
        :param pulumi.Input[int] timeout_minutes: TimeoutMinutes
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        ImageTestsEnabled
        """
        return pulumi.get(self, "image_tests_enabled")

    @image_tests_enabled.setter
    def image_tests_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_tests_enabled", value)

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        TimeoutMinutes
        """
        return pulumi.get(self, "timeout_minutes")

    @timeout_minutes.setter
    def timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_minutes", value)


@pulumi.input_type
class InfrastructureConfigurationInstanceMetadataOptionsArgs:
    def __init__(__self__, *,
                 http_put_response_hop_limit: Optional[pulumi.Input[int]] = None,
                 http_tokens: Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsHttpTokens']] = None):
        """
        The instance metadata option settings for the infrastructure configuration.
        :param pulumi.Input[int] http_put_response_hop_limit: Limit the number of hops that an instance metadata request can traverse to reach its destination.
        :param pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsHttpTokens'] http_tokens: Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows: 
        """
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Limit the number of hops that an instance metadata request can traverse to reach its destination.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsHttpTokens']]:
        """
        Indicates whether a signed token header is required for instance metadata retrieval requests. The values affect the response as follows: 
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input['InfrastructureConfigurationInstanceMetadataOptionsHttpTokens']]):
        pulumi.set(self, "http_tokens", value)


@pulumi.input_type
class InfrastructureConfigurationLoggingArgs:
    def __init__(__self__, *,
                 s3_logs: Optional[pulumi.Input['InfrastructureConfigurationS3LogsArgs']] = None):
        """
        The logging configuration of the infrastructure configuration.
        """
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional[pulumi.Input['InfrastructureConfigurationS3LogsArgs']]:
        return pulumi.get(self, "s3_logs")

    @s3_logs.setter
    def s3_logs(self, value: Optional[pulumi.Input['InfrastructureConfigurationS3LogsArgs']]):
        pulumi.set(self, "s3_logs", value)


@pulumi.input_type
class InfrastructureConfigurationS3LogsArgs:
    def __init__(__self__, *,
                 s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 s3_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        The S3 path in which to store the logs.
        :param pulumi.Input[str] s3_bucket_name: S3BucketName
        :param pulumi.Input[str] s3_key_prefix: S3KeyPrefix
        """
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        S3BucketName
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        S3KeyPrefix
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_prefix", value)


