"""
    Security API reference

       # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.api_label import ApiLabel
from pensando_dss.psm.model.api_status import ApiStatus
from pensando_dss.psm.model.security_app import SecurityApp
from pensando_dss.psm.model.security_app_list import SecurityAppList
from pensando_dss.psm.model.security_auto_msg_app_watch_helper import SecurityAutoMsgAppWatchHelper
from pensando_dss.psm.model.security_auto_msg_firewall_profile_watch_helper import SecurityAutoMsgFirewallProfileWatchHelper
from pensando_dss.psm.model.security_auto_msg_ip_sec_policy_watch_helper import SecurityAutoMsgIPSecPolicyWatchHelper
from pensando_dss.psm.model.security_auto_msg_network_security_policy_watch_helper import SecurityAutoMsgNetworkSecurityPolicyWatchHelper
from pensando_dss.psm.model.security_auto_msg_security_group_watch_helper import SecurityAutoMsgSecurityGroupWatchHelper
from pensando_dss.psm.model.security_firewall_profile import SecurityFirewallProfile
from pensando_dss.psm.model.security_firewall_profile_list import SecurityFirewallProfileList
from pensando_dss.psm.model.security_ip_sec_policy import SecurityIPSecPolicy
from pensando_dss.psm.model.security_ip_sec_policy_list import SecurityIPSecPolicyList
from pensando_dss.psm.model.security_network_security_policy import SecurityNetworkSecurityPolicy
from pensando_dss.psm.model.security_network_security_policy_list import SecurityNetworkSecurityPolicyList
from pensando_dss.psm.model.security_security_group import SecuritySecurityGroup
from pensando_dss.psm.model.security_security_group_list import SecuritySecurityGroupList


class SecurityV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_app(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_app(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (SecurityApp):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_app = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/apps',
                'operation_id': 'add_app',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (SecurityApp,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_app
        )

        def __add_app1(
            self,
            body,
            **kwargs
        ):
            """Create App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_app1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (SecurityApp):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_app1 = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/apps',
                'operation_id': 'add_app1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (SecurityApp,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_app1
        )

        def __add_ip_sec_policy(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_ip_sec_policy(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (SecurityIPSecPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/ipsecpolicies',
                'operation_id': 'add_ip_sec_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (SecurityIPSecPolicy,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_ip_sec_policy
        )

        def __add_ip_sec_policy1(
            self,
            body,
            **kwargs
        ):
            """Create IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_ip_sec_policy1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (SecurityIPSecPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/ipsecpolicies',
                'operation_id': 'add_ip_sec_policy1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (SecurityIPSecPolicy,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_ip_sec_policy1
        )

        def __add_network_security_policy(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_network_security_policy(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (SecurityNetworkSecurityPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/networksecuritypolicies',
                'operation_id': 'add_network_security_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (SecurityNetworkSecurityPolicy,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_network_security_policy
        )

        def __add_network_security_policy1(
            self,
            body,
            **kwargs
        ):
            """Create NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_network_security_policy1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (SecurityNetworkSecurityPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/networksecuritypolicies',
                'operation_id': 'add_network_security_policy1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (SecurityNetworkSecurityPolicy,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_network_security_policy1
        )

        def __add_security_group(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Create SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_security_group(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (SecuritySecurityGroup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_security_group = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/security-groups',
                'operation_id': 'add_security_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (SecuritySecurityGroup,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_security_group
        )

        def __add_security_group1(
            self,
            body,
            **kwargs
        ):
            """Create SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_security_group1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (SecuritySecurityGroup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_security_group1 = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/security-groups',
                'operation_id': 'add_security_group1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (SecuritySecurityGroup,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_security_group1
        )

        def __delete_app(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Delete App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_app(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_app = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/apps/{O.Name}',
                'operation_id': 'delete_app',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_app
        )

        def __delete_app1(
            self,
            o_name,
            **kwargs
        ):
            """Delete App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_app1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_app1 = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/apps/{O.Name}',
                'operation_id': 'delete_app1',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_app1
        )

        def __delete_ip_sec_policy(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Delete IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ip_sec_policy(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/ipsecpolicies/{O.Name}',
                'operation_id': 'delete_ip_sec_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_ip_sec_policy
        )

        def __delete_ip_sec_policy1(
            self,
            o_name,
            **kwargs
        ):
            """Delete IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_ip_sec_policy1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/ipsecpolicies/{O.Name}',
                'operation_id': 'delete_ip_sec_policy1',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_ip_sec_policy1
        )

        def __delete_network_security_policy(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Delete NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_network_security_policy(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/networksecuritypolicies/{O.Name}',
                'operation_id': 'delete_network_security_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_network_security_policy
        )

        def __delete_network_security_policy1(
            self,
            o_name,
            **kwargs
        ):
            """Delete NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_network_security_policy1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/networksecuritypolicies/{O.Name}',
                'operation_id': 'delete_network_security_policy1',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_network_security_policy1
        )

        def __delete_security_group(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Delete SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_security_group(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_security_group = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/security-groups/{O.Name}',
                'operation_id': 'delete_security_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_security_group
        )

        def __delete_security_group1(
            self,
            o_name,
            **kwargs
        ):
            """Delete SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_security_group1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_security_group1 = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/security-groups/{O.Name}',
                'operation_id': 'delete_security_group1',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_security_group1
        )

        def __get_app(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Get App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_app(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_timeout (str): Timeout specifies for how long the connection be kept before removing the flow entry, specified in string as '200s', '5m', etc. Should be a valid time duration.. [optional]
                alg_type (str): [optional]
                icmp_type (str): ICMP Type.. [optional]
                icmp_code (str): ICMP Code is sub-command for a given ICMP Type.. [optional]
                dns_drop_multi_question_packets (bool): Drop packet if number of questions is more than one.. [optional]
                dns_drop_large_domain_name_packets (bool): Drop if domain name size is > 255 bytes.. [optional]
                dns_drop_long_label_packets (bool): Drop if label length is 64 bytes or higher.. [optional]
                dns_max_message_length (int): Maximum message length, default value is 512, maximum specified user value is 8129.. [optional]
                dns_query_response_timeout (str): Timeout for DNS Query, default 60s. Should be a valid time duration.. [optional]
                ftp_allow_mismatch_ip_address (bool): Allow Mismatch IP Address in the payload compared to what is present in the IP header.. [optional]
                status_attached_policies ([str]): List of security group policies attached to the app.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_app = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/apps/{O.Name}',
                'operation_id': 'get_app',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_timeout',
                    'alg_type',
                    'icmp_type',
                    'icmp_code',
                    'dns_drop_multi_question_packets',
                    'dns_drop_large_domain_name_packets',
                    'dns_drop_long_label_packets',
                    'dns_max_message_length',
                    'dns_query_response_timeout',
                    'ftp_allow_mismatch_ip_address',
                    'status_attached_policies',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_timeout':
                        (str,),
                    'alg_type':
                        (str,),
                    'icmp_type':
                        (str,),
                    'icmp_code':
                        (str,),
                    'dns_drop_multi_question_packets':
                        (bool,),
                    'dns_drop_large_domain_name_packets':
                        (bool,),
                    'dns_drop_long_label_packets':
                        (bool,),
                    'dns_max_message_length':
                        (int,),
                    'dns_query_response_timeout':
                        (str,),
                    'ftp_allow_mismatch_ip_address':
                        (bool,),
                    'status_attached_policies':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_timeout': 'spec.timeout',
                    'alg_type': 'alg.type',
                    'icmp_type': 'icmp.type',
                    'icmp_code': 'icmp.code',
                    'dns_drop_multi_question_packets': 'dns.drop-multi-question-packets',
                    'dns_drop_large_domain_name_packets': 'dns.drop-large-domain-name-packets',
                    'dns_drop_long_label_packets': 'dns.drop-long-label-packets',
                    'dns_max_message_length': 'dns.max-message-length',
                    'dns_query_response_timeout': 'dns.query-response-timeout',
                    'ftp_allow_mismatch_ip_address': 'ftp.allow-mismatch-ip-address',
                    'status_attached_policies': 'status.attached-policies',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_timeout': 'query',
                    'alg_type': 'query',
                    'icmp_type': 'query',
                    'icmp_code': 'query',
                    'dns_drop_multi_question_packets': 'query',
                    'dns_drop_large_domain_name_packets': 'query',
                    'dns_drop_long_label_packets': 'query',
                    'dns_max_message_length': 'query',
                    'dns_query_response_timeout': 'query',
                    'ftp_allow_mismatch_ip_address': 'query',
                    'status_attached_policies': 'query',
                },
                'collection_format_map': {
                    'status_attached_policies': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_app
        )

        def __get_app1(
            self,
            o_name,
            **kwargs
        ):
            """Get App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_app1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_timeout (str): Timeout specifies for how long the connection be kept before removing the flow entry, specified in string as '200s', '5m', etc. Should be a valid time duration.. [optional]
                alg_type (str): [optional]
                icmp_type (str): ICMP Type.. [optional]
                icmp_code (str): ICMP Code is sub-command for a given ICMP Type.. [optional]
                dns_drop_multi_question_packets (bool): Drop packet if number of questions is more than one.. [optional]
                dns_drop_large_domain_name_packets (bool): Drop if domain name size is > 255 bytes.. [optional]
                dns_drop_long_label_packets (bool): Drop if label length is 64 bytes or higher.. [optional]
                dns_max_message_length (int): Maximum message length, default value is 512, maximum specified user value is 8129.. [optional]
                dns_query_response_timeout (str): Timeout for DNS Query, default 60s. Should be a valid time duration.. [optional]
                ftp_allow_mismatch_ip_address (bool): Allow Mismatch IP Address in the payload compared to what is present in the IP header.. [optional]
                status_attached_policies ([str]): List of security group policies attached to the app.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_app1 = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/apps/{O.Name}',
                'operation_id': 'get_app1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_timeout',
                    'alg_type',
                    'icmp_type',
                    'icmp_code',
                    'dns_drop_multi_question_packets',
                    'dns_drop_large_domain_name_packets',
                    'dns_drop_long_label_packets',
                    'dns_max_message_length',
                    'dns_query_response_timeout',
                    'ftp_allow_mismatch_ip_address',
                    'status_attached_policies',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_timeout':
                        (str,),
                    'alg_type':
                        (str,),
                    'icmp_type':
                        (str,),
                    'icmp_code':
                        (str,),
                    'dns_drop_multi_question_packets':
                        (bool,),
                    'dns_drop_large_domain_name_packets':
                        (bool,),
                    'dns_drop_long_label_packets':
                        (bool,),
                    'dns_max_message_length':
                        (int,),
                    'dns_query_response_timeout':
                        (str,),
                    'ftp_allow_mismatch_ip_address':
                        (bool,),
                    'status_attached_policies':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_timeout': 'spec.timeout',
                    'alg_type': 'alg.type',
                    'icmp_type': 'icmp.type',
                    'icmp_code': 'icmp.code',
                    'dns_drop_multi_question_packets': 'dns.drop-multi-question-packets',
                    'dns_drop_large_domain_name_packets': 'dns.drop-large-domain-name-packets',
                    'dns_drop_long_label_packets': 'dns.drop-long-label-packets',
                    'dns_max_message_length': 'dns.max-message-length',
                    'dns_query_response_timeout': 'dns.query-response-timeout',
                    'ftp_allow_mismatch_ip_address': 'ftp.allow-mismatch-ip-address',
                    'status_attached_policies': 'status.attached-policies',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_timeout': 'query',
                    'alg_type': 'query',
                    'icmp_type': 'query',
                    'icmp_code': 'query',
                    'dns_drop_multi_question_packets': 'query',
                    'dns_drop_large_domain_name_packets': 'query',
                    'dns_drop_long_label_packets': 'query',
                    'dns_max_message_length': 'query',
                    'dns_query_response_timeout': 'query',
                    'ftp_allow_mismatch_ip_address': 'query',
                    'status_attached_policies': 'query',
                },
                'collection_format_map': {
                    'status_attached_policies': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_app1
        )

        def __get_firewall_profile(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Get FirewallProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_firewall_profile(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_session_idle_timeout (str): Session idle timeout removes/deletes the session/flow if there is inactivity; this value is superceded by any value specified in App object. Should be a valid time duration between 30s and 48h0m0s.. [optional]
                spec_tcp_connection_setup_timeout (str): TCP Connection Setup Timeout is the period TCP session is kept to see the response of a SYN. Should be a valid time duration between 1s and 1m0s.. [optional]
                spec_tcp_close_timeout (str): TCP Close Timeout is the time for which TCP session is kept after a FIN is seen. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_tcp_half_closed_timeout (str): TCP Half Closed Timeout is the time for which tCP session is kept when connection is half closed i.e. FIN sent by FIN_Ack not received. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_tcp_drop_timeout (str): TCP Drop Timeout is the period for which a drop entry is installed for a denied TCP flow. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_udp_drop_timeout (str): UDP Drop Timeout is the period for which a drop entry is installed for a denied UDP flow. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_icmp_drop_timeout (str): ICMP Drop Timeout is the period for which a drop entry is installed for a denied ICMP flow. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_drop_timeout (str): Drop Timeout is the period for which a drop entry is installed for a denied non tcp/udp/icmp flow. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_tcp_timeout (str): Tcp Timeout is the period for which a TCP session is kept alive during inactivity. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_udp_timeout (str): Udp Timeout is the period for which a UDP session is kept alive during inactivity. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_icmp_timeout (str): Icmp Timeout is the period for which a ICMP session is kept alive during inactivity. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_tcp_half_open_session_limit (int): Tcp half open session limit config after which new open requests will be dropped. Value should be between 0 and 32768.. [optional]
                spec_udp_active_session_limit (int): Udp active session limit config after which new requests will be dropped. Value should be between 0 and 32768.. [optional]
                spec_icmp_active_session_limit (int): Icmp active session limit config after which new requests will be dropped. Value should be between 0 and 32768.. [optional]
                spec_detect_app (bool): Set the Application Identification Detection config for DSCs.. [optional]
                spec_connection_tracking (bool): Enable/disable Connection Tracking.. [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_firewall_profile = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfile,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/firewallprofiles/{O.Name}',
                'operation_id': 'get_firewall_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_session_idle_timeout',
                    'spec_tcp_connection_setup_timeout',
                    'spec_tcp_close_timeout',
                    'spec_tcp_half_closed_timeout',
                    'spec_tcp_drop_timeout',
                    'spec_udp_drop_timeout',
                    'spec_icmp_drop_timeout',
                    'spec_drop_timeout',
                    'spec_tcp_timeout',
                    'spec_udp_timeout',
                    'spec_icmp_timeout',
                    'spec_tcp_half_open_session_limit',
                    'spec_udp_active_session_limit',
                    'spec_icmp_active_session_limit',
                    'spec_detect_app',
                    'spec_connection_tracking',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_session_idle_timeout':
                        (str,),
                    'spec_tcp_connection_setup_timeout':
                        (str,),
                    'spec_tcp_close_timeout':
                        (str,),
                    'spec_tcp_half_closed_timeout':
                        (str,),
                    'spec_tcp_drop_timeout':
                        (str,),
                    'spec_udp_drop_timeout':
                        (str,),
                    'spec_icmp_drop_timeout':
                        (str,),
                    'spec_drop_timeout':
                        (str,),
                    'spec_tcp_timeout':
                        (str,),
                    'spec_udp_timeout':
                        (str,),
                    'spec_icmp_timeout':
                        (str,),
                    'spec_tcp_half_open_session_limit':
                        (int,),
                    'spec_udp_active_session_limit':
                        (int,),
                    'spec_icmp_active_session_limit':
                        (int,),
                    'spec_detect_app':
                        (bool,),
                    'spec_connection_tracking':
                        (bool,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_session_idle_timeout': 'spec.session-idle-timeout',
                    'spec_tcp_connection_setup_timeout': 'spec.tcp-connection-setup-timeout',
                    'spec_tcp_close_timeout': 'spec.tcp-close-timeout',
                    'spec_tcp_half_closed_timeout': 'spec.tcp-half-closed-timeout',
                    'spec_tcp_drop_timeout': 'spec.tcp-drop-timeout',
                    'spec_udp_drop_timeout': 'spec.udp-drop-timeout',
                    'spec_icmp_drop_timeout': 'spec.icmp-drop-timeout',
                    'spec_drop_timeout': 'spec.drop-timeout',
                    'spec_tcp_timeout': 'spec.tcp-timeout',
                    'spec_udp_timeout': 'spec.udp-timeout',
                    'spec_icmp_timeout': 'spec.icmp-timeout',
                    'spec_tcp_half_open_session_limit': 'spec.tcp-half-open-session-limit',
                    'spec_udp_active_session_limit': 'spec.udp-active-session-limit',
                    'spec_icmp_active_session_limit': 'spec.icmp-active-session-limit',
                    'spec_detect_app': 'spec.detect-app',
                    'spec_connection_tracking': 'spec.connection-tracking',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_session_idle_timeout': 'query',
                    'spec_tcp_connection_setup_timeout': 'query',
                    'spec_tcp_close_timeout': 'query',
                    'spec_tcp_half_closed_timeout': 'query',
                    'spec_tcp_drop_timeout': 'query',
                    'spec_udp_drop_timeout': 'query',
                    'spec_icmp_drop_timeout': 'query',
                    'spec_drop_timeout': 'query',
                    'spec_tcp_timeout': 'query',
                    'spec_udp_timeout': 'query',
                    'spec_icmp_timeout': 'query',
                    'spec_tcp_half_open_session_limit': 'query',
                    'spec_udp_active_session_limit': 'query',
                    'spec_icmp_active_session_limit': 'query',
                    'spec_detect_app': 'query',
                    'spec_connection_tracking': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                },
                'collection_format_map': {
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_firewall_profile
        )

        def __get_firewall_profile1(
            self,
            o_name,
            **kwargs
        ):
            """Get FirewallProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_firewall_profile1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_session_idle_timeout (str): Session idle timeout removes/deletes the session/flow if there is inactivity; this value is superceded by any value specified in App object. Should be a valid time duration between 30s and 48h0m0s.. [optional]
                spec_tcp_connection_setup_timeout (str): TCP Connection Setup Timeout is the period TCP session is kept to see the response of a SYN. Should be a valid time duration between 1s and 1m0s.. [optional]
                spec_tcp_close_timeout (str): TCP Close Timeout is the time for which TCP session is kept after a FIN is seen. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_tcp_half_closed_timeout (str): TCP Half Closed Timeout is the time for which tCP session is kept when connection is half closed i.e. FIN sent by FIN_Ack not received. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_tcp_drop_timeout (str): TCP Drop Timeout is the period for which a drop entry is installed for a denied TCP flow. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_udp_drop_timeout (str): UDP Drop Timeout is the period for which a drop entry is installed for a denied UDP flow. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_icmp_drop_timeout (str): ICMP Drop Timeout is the period for which a drop entry is installed for a denied ICMP flow. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_drop_timeout (str): Drop Timeout is the period for which a drop entry is installed for a denied non tcp/udp/icmp flow. Should be a valid time duration between 1s and 5m0s.. [optional]
                spec_tcp_timeout (str): Tcp Timeout is the period for which a TCP session is kept alive during inactivity. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_udp_timeout (str): Udp Timeout is the period for which a UDP session is kept alive during inactivity. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_icmp_timeout (str): Icmp Timeout is the period for which a ICMP session is kept alive during inactivity. Should be a valid time duration between 1s and 48h0m0s.. [optional]
                spec_tcp_half_open_session_limit (int): Tcp half open session limit config after which new open requests will be dropped. Value should be between 0 and 32768.. [optional]
                spec_udp_active_session_limit (int): Udp active session limit config after which new requests will be dropped. Value should be between 0 and 32768.. [optional]
                spec_icmp_active_session_limit (int): Icmp active session limit config after which new requests will be dropped. Value should be between 0 and 32768.. [optional]
                spec_detect_app (bool): Set the Application Identification Detection config for DSCs.. [optional]
                spec_connection_tracking (bool): Enable/disable Connection Tracking.. [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_firewall_profile1 = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfile,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/firewallprofiles/{O.Name}',
                'operation_id': 'get_firewall_profile1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_session_idle_timeout',
                    'spec_tcp_connection_setup_timeout',
                    'spec_tcp_close_timeout',
                    'spec_tcp_half_closed_timeout',
                    'spec_tcp_drop_timeout',
                    'spec_udp_drop_timeout',
                    'spec_icmp_drop_timeout',
                    'spec_drop_timeout',
                    'spec_tcp_timeout',
                    'spec_udp_timeout',
                    'spec_icmp_timeout',
                    'spec_tcp_half_open_session_limit',
                    'spec_udp_active_session_limit',
                    'spec_icmp_active_session_limit',
                    'spec_detect_app',
                    'spec_connection_tracking',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_session_idle_timeout':
                        (str,),
                    'spec_tcp_connection_setup_timeout':
                        (str,),
                    'spec_tcp_close_timeout':
                        (str,),
                    'spec_tcp_half_closed_timeout':
                        (str,),
                    'spec_tcp_drop_timeout':
                        (str,),
                    'spec_udp_drop_timeout':
                        (str,),
                    'spec_icmp_drop_timeout':
                        (str,),
                    'spec_drop_timeout':
                        (str,),
                    'spec_tcp_timeout':
                        (str,),
                    'spec_udp_timeout':
                        (str,),
                    'spec_icmp_timeout':
                        (str,),
                    'spec_tcp_half_open_session_limit':
                        (int,),
                    'spec_udp_active_session_limit':
                        (int,),
                    'spec_icmp_active_session_limit':
                        (int,),
                    'spec_detect_app':
                        (bool,),
                    'spec_connection_tracking':
                        (bool,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_session_idle_timeout': 'spec.session-idle-timeout',
                    'spec_tcp_connection_setup_timeout': 'spec.tcp-connection-setup-timeout',
                    'spec_tcp_close_timeout': 'spec.tcp-close-timeout',
                    'spec_tcp_half_closed_timeout': 'spec.tcp-half-closed-timeout',
                    'spec_tcp_drop_timeout': 'spec.tcp-drop-timeout',
                    'spec_udp_drop_timeout': 'spec.udp-drop-timeout',
                    'spec_icmp_drop_timeout': 'spec.icmp-drop-timeout',
                    'spec_drop_timeout': 'spec.drop-timeout',
                    'spec_tcp_timeout': 'spec.tcp-timeout',
                    'spec_udp_timeout': 'spec.udp-timeout',
                    'spec_icmp_timeout': 'spec.icmp-timeout',
                    'spec_tcp_half_open_session_limit': 'spec.tcp-half-open-session-limit',
                    'spec_udp_active_session_limit': 'spec.udp-active-session-limit',
                    'spec_icmp_active_session_limit': 'spec.icmp-active-session-limit',
                    'spec_detect_app': 'spec.detect-app',
                    'spec_connection_tracking': 'spec.connection-tracking',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_session_idle_timeout': 'query',
                    'spec_tcp_connection_setup_timeout': 'query',
                    'spec_tcp_close_timeout': 'query',
                    'spec_tcp_half_closed_timeout': 'query',
                    'spec_tcp_drop_timeout': 'query',
                    'spec_udp_drop_timeout': 'query',
                    'spec_icmp_drop_timeout': 'query',
                    'spec_drop_timeout': 'query',
                    'spec_tcp_timeout': 'query',
                    'spec_udp_timeout': 'query',
                    'spec_icmp_timeout': 'query',
                    'spec_tcp_half_open_session_limit': 'query',
                    'spec_udp_active_session_limit': 'query',
                    'spec_icmp_active_session_limit': 'query',
                    'spec_detect_app': 'query',
                    'spec_connection_tracking': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                },
                'collection_format_map': {
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_firewall_profile1
        )

        def __get_ip_sec_policy(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Get IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ip_sec_policy(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                config_sa_lifetime (str): How long a particular instance of a connection should last, from successful negotiation to expiry The connection will be re-negotiated before it expires. Post succesful re-negotation, the new connection will have new(different) keys and a new SPI Default 8h, Max 24h, set it to an empty string to disable rekeying. Should be a valid time duration between 1h0m0s and 24h0m0s.. [optional]
                config_ike_lifetime (str): Time to schedule Internet Key Exchange (IKE) reauthentication. IKE reauthentication recreates the IKE SA from scratch and re-evaluates the credentials Default 24h, set it to an empty string to disable reauthentication. Should be a valid time duration between 1h0m0s and 24h0m0s.. [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                status_ike_params (str): Encryption and Algorithm details used for IKEv2 key exchange.. [optional]
                status_esp_params (str): Encryption and Algorithm details used for encrypting data traffic (ESP).. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/ipsecpolicies/{O.Name}',
                'operation_id': 'get_ip_sec_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'config_sa_lifetime',
                    'config_ike_lifetime',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                    'status_ike_params',
                    'status_esp_params',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'config_sa_lifetime':
                        (str,),
                    'config_ike_lifetime':
                        (str,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                    'status_ike_params':
                        (str,),
                    'status_esp_params':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'config_sa_lifetime': 'config.sa-lifetime',
                    'config_ike_lifetime': 'config.ike-lifetime',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                    'status_ike_params': 'status.ike-params',
                    'status_esp_params': 'status.esp-params',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'config_sa_lifetime': 'query',
                    'config_ike_lifetime': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                    'status_ike_params': 'query',
                    'status_esp_params': 'query',
                },
                'collection_format_map': {
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ip_sec_policy
        )

        def __get_ip_sec_policy1(
            self,
            o_name,
            **kwargs
        ):
            """Get IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ip_sec_policy1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                config_sa_lifetime (str): How long a particular instance of a connection should last, from successful negotiation to expiry The connection will be re-negotiated before it expires. Post succesful re-negotation, the new connection will have new(different) keys and a new SPI Default 8h, Max 24h, set it to an empty string to disable rekeying. Should be a valid time duration between 1h0m0s and 24h0m0s.. [optional]
                config_ike_lifetime (str): Time to schedule Internet Key Exchange (IKE) reauthentication. IKE reauthentication recreates the IKE SA from scratch and re-evaluates the credentials Default 24h, set it to an empty string to disable reauthentication. Should be a valid time duration between 1h0m0s and 24h0m0s.. [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                status_ike_params (str): Encryption and Algorithm details used for IKEv2 key exchange.. [optional]
                status_esp_params (str): Encryption and Algorithm details used for encrypting data traffic (ESP).. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/ipsecpolicies/{O.Name}',
                'operation_id': 'get_ip_sec_policy1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'config_sa_lifetime',
                    'config_ike_lifetime',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                    'status_ike_params',
                    'status_esp_params',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'config_sa_lifetime':
                        (str,),
                    'config_ike_lifetime':
                        (str,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                    'status_ike_params':
                        (str,),
                    'status_esp_params':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'config_sa_lifetime': 'config.sa-lifetime',
                    'config_ike_lifetime': 'config.ike-lifetime',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                    'status_ike_params': 'status.ike-params',
                    'status_esp_params': 'status.esp-params',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'config_sa_lifetime': 'query',
                    'config_ike_lifetime': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                    'status_ike_params': 'query',
                    'status_esp_params': 'query',
                },
                'collection_format_map': {
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ip_sec_policy1
        )

        def __get_network_security_policy(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Get NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_network_security_policy(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_attach_groups ([str]): list of security groups this policy is attached to.. [optional]
                spec_attach_tenant (bool): specifies if the set of rules need to be attached globally to a tenant.. [optional]
                spec_priority (int): Policy priority. If not specified, it will be assigned automatically in increments of 1000.. [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/networksecuritypolicies/{O.Name}',
                'operation_id': 'get_network_security_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_attach_groups',
                    'spec_attach_tenant',
                    'spec_priority',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_attach_groups':
                        ([str],),
                    'spec_attach_tenant':
                        (bool,),
                    'spec_priority':
                        (int,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_attach_groups': 'spec.attach-groups',
                    'spec_attach_tenant': 'spec.attach-tenant',
                    'spec_priority': 'spec.priority',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_attach_groups': 'query',
                    'spec_attach_tenant': 'query',
                    'spec_priority': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                },
                'collection_format_map': {
                    'spec_attach_groups': 'csv',
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_network_security_policy
        )

        def __get_network_security_policy1(
            self,
            o_name,
            **kwargs
        ):
            """Get NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_network_security_policy1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_attach_groups ([str]): list of security groups this policy is attached to.. [optional]
                spec_attach_tenant (bool): specifies if the set of rules need to be attached globally to a tenant.. [optional]
                spec_priority (int): Policy priority. If not specified, it will be assigned automatically in increments of 1000.. [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/networksecuritypolicies/{O.Name}',
                'operation_id': 'get_network_security_policy1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_attach_groups',
                    'spec_attach_tenant',
                    'spec_priority',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_attach_groups':
                        ([str],),
                    'spec_attach_tenant':
                        (bool,),
                    'spec_priority':
                        (int,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_attach_groups': 'spec.attach-groups',
                    'spec_attach_tenant': 'spec.attach-tenant',
                    'spec_priority': 'spec.priority',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_attach_groups': 'query',
                    'spec_attach_tenant': 'query',
                    'spec_priority': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                },
                'collection_format_map': {
                    'spec_attach_groups': 'csv',
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_network_security_policy1
        )

        def __get_security_group(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """Get SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_security_group(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_service_labels ([str]): Service object selector.. [optional]
                spec_match_prefixes ([str]): list of CIDRs that are part of this security group.. [optional]
                status_workloads ([str]): list of workloads that are part of this security group.. [optional]
                status_policies ([str]): list of all policies attached to this security group.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_security_group = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/security-groups/{O.Name}',
                'operation_id': 'get_security_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_service_labels',
                    'spec_match_prefixes',
                    'status_workloads',
                    'status_policies',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_service_labels':
                        ([str],),
                    'spec_match_prefixes':
                        ([str],),
                    'status_workloads':
                        ([str],),
                    'status_policies':
                        ([str],),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_service_labels': 'spec.service-labels',
                    'spec_match_prefixes': 'spec.match-prefixes',
                    'status_workloads': 'status.workloads',
                    'status_policies': 'status.Policies',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_service_labels': 'query',
                    'spec_match_prefixes': 'query',
                    'status_workloads': 'query',
                    'status_policies': 'query',
                },
                'collection_format_map': {
                    'spec_service_labels': 'csv',
                    'spec_match_prefixes': 'csv',
                    'status_workloads': 'csv',
                    'status_policies': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_security_group
        )

        def __get_security_group1(
            self,
            o_name,
            **kwargs
        ):
            """Get SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_security_group1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_service_labels ([str]): Service object selector.. [optional]
                spec_match_prefixes ([str]): list of CIDRs that are part of this security group.. [optional]
                status_workloads ([str]): list of workloads that are part of this security group.. [optional]
                status_policies ([str]): list of all policies attached to this security group.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_security_group1 = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/security-groups/{O.Name}',
                'operation_id': 'get_security_group1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_service_labels',
                    'spec_match_prefixes',
                    'status_workloads',
                    'status_policies',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_service_labels':
                        ([str],),
                    'spec_match_prefixes':
                        ([str],),
                    'status_workloads':
                        ([str],),
                    'status_policies':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_service_labels': 'spec.service-labels',
                    'spec_match_prefixes': 'spec.match-prefixes',
                    'status_workloads': 'status.workloads',
                    'status_policies': 'status.Policies',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_service_labels': 'query',
                    'spec_match_prefixes': 'query',
                    'status_workloads': 'query',
                    'status_policies': 'query',
                },
                'collection_format_map': {
                    'spec_service_labels': 'csv',
                    'spec_match_prefixes': 'csv',
                    'status_workloads': 'csv',
                    'status_policies': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_security_group1
        )

        def __label_app(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Label App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_app(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_app = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/apps/{O.Name}/label',
                'operation_id': 'label_app',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_app
        )

        def __label_app1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_app1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_app1 = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/apps/{O.Name}/label',
                'operation_id': 'label_app1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_app1
        )

        def __label_firewall_profile(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Label FirewallProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_firewall_profile(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_firewall_profile = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfile,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/firewallprofiles/{O.Name}/label',
                'operation_id': 'label_firewall_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_firewall_profile
        )

        def __label_firewall_profile1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label FirewallProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_firewall_profile1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_firewall_profile1 = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfile,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/firewallprofiles/{O.Name}/label',
                'operation_id': 'label_firewall_profile1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_firewall_profile1
        )

        def __label_ip_sec_policy(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Label IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_ip_sec_policy(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/ipsecpolicies/{O.Name}/label',
                'operation_id': 'label_ip_sec_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_ip_sec_policy
        )

        def __label_ip_sec_policy1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_ip_sec_policy1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/ipsecpolicies/{O.Name}/label',
                'operation_id': 'label_ip_sec_policy1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_ip_sec_policy1
        )

        def __label_network_security_policy(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Label NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_network_security_policy(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/networksecuritypolicies/{O.Name}/label',
                'operation_id': 'label_network_security_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_network_security_policy
        )

        def __label_network_security_policy1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_network_security_policy1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/networksecuritypolicies/{O.Name}/label',
                'operation_id': 'label_network_security_policy1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_network_security_policy1
        )

        def __label_security_group(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Label SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_security_group(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_security_group = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/security-groups/{O.Name}/label',
                'operation_id': 'label_security_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_security_group
        )

        def __label_security_group1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_security_group1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_security_group1 = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/security-groups/{O.Name}/label',
                'operation_id': 'label_security_group1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_security_group1
        )

        def __list_app(
            self,
            o_tenant,
            **kwargs
        ):
            """List App objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_app(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAppList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_app = _Endpoint(
            settings={
                'response_type': (SecurityAppList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/apps',
                'operation_id': 'list_app',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_app
        )

        def __list_app1(
            self,
            **kwargs
        ):
            """List App objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_app1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAppList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_app1 = _Endpoint(
            settings={
                'response_type': (SecurityAppList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/apps',
                'operation_id': 'list_app1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_app1
        )

        def __list_firewall_profile(
            self,
            o_tenant,
            **kwargs
        ):
            """List FirewallProfile objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_firewall_profile(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfileList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_firewall_profile = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfileList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/firewallprofiles',
                'operation_id': 'list_firewall_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_firewall_profile
        )

        def __list_firewall_profile1(
            self,
            **kwargs
        ):
            """List FirewallProfile objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_firewall_profile1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfileList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_firewall_profile1 = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfileList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/firewallprofiles',
                'operation_id': 'list_firewall_profile1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_firewall_profile1
        )

        def __list_ip_sec_policy(
            self,
            o_tenant,
            **kwargs
        ):
            """List IPSecPolicy objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ip_sec_policy(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicyList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicyList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/ipsecpolicies',
                'operation_id': 'list_ip_sec_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_ip_sec_policy
        )

        def __list_ip_sec_policy1(
            self,
            **kwargs
        ):
            """List IPSecPolicy objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_ip_sec_policy1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicyList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicyList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/ipsecpolicies',
                'operation_id': 'list_ip_sec_policy1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_ip_sec_policy1
        )

        def __list_network_security_policy(
            self,
            o_tenant,
            **kwargs
        ):
            """List NetworkSecurityPolicy objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_network_security_policy(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicyList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicyList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/networksecuritypolicies',
                'operation_id': 'list_network_security_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_network_security_policy
        )

        def __list_network_security_policy1(
            self,
            **kwargs
        ):
            """List NetworkSecurityPolicy objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_network_security_policy1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicyList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicyList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/networksecuritypolicies',
                'operation_id': 'list_network_security_policy1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_network_security_policy1
        )

        def __list_security_group(
            self,
            o_tenant,
            **kwargs
        ):
            """List SecurityGroup objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_security_group(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroupList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.list_security_group = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroupList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/security-groups',
                'operation_id': 'list_security_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_security_group
        )

        def __list_security_group1(
            self,
            **kwargs
        ):
            """List SecurityGroup objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_security_group1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroupList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_security_group1 = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroupList,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/security-groups',
                'operation_id': 'list_security_group1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_security_group1
        )

        def __update_app(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Update App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_app(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (SecurityApp):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_app = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/apps/{O.Name}',
                'operation_id': 'update_app',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (SecurityApp,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_app
        )

        def __update_app1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update App object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_app1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (SecurityApp):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityApp
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_app1 = _Endpoint(
            settings={
                'response_type': (SecurityApp,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/apps/{O.Name}',
                'operation_id': 'update_app1',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (SecurityApp,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_app1
        )

        def __update_firewall_profile(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Update FirewallProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_firewall_profile(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (SecurityFirewallProfile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_firewall_profile = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfile,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/firewallprofiles/{O.Name}',
                'operation_id': 'update_firewall_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (SecurityFirewallProfile,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_firewall_profile
        )

        def __update_firewall_profile1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update FirewallProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_firewall_profile1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (SecurityFirewallProfile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityFirewallProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_firewall_profile1 = _Endpoint(
            settings={
                'response_type': (SecurityFirewallProfile,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/firewallprofiles/{O.Name}',
                'operation_id': 'update_firewall_profile1',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (SecurityFirewallProfile,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_firewall_profile1
        )

        def __update_ip_sec_policy(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Update IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_ip_sec_policy(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (SecurityIPSecPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/ipsecpolicies/{O.Name}',
                'operation_id': 'update_ip_sec_policy',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (SecurityIPSecPolicy,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_ip_sec_policy
        )

        def __update_ip_sec_policy1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update IPSecPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_ip_sec_policy1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (SecurityIPSecPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityIPSecPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityIPSecPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/ipsecpolicies/{O.Name}',
                'operation_id': 'update_ip_sec_policy1',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (SecurityIPSecPolicy,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_ip_sec_policy1
        )

        def __update_network_security_policy(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Update NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_network_security_policy(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (SecurityNetworkSecurityPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/networksecuritypolicies/{O.Name}',
                'operation_id': 'update_network_security_policy',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (SecurityNetworkSecurityPolicy,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_network_security_policy
        )

        def __update_network_security_policy1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update NetworkSecurityPolicy object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_network_security_policy1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (SecurityNetworkSecurityPolicy):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityNetworkSecurityPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityNetworkSecurityPolicy,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/networksecuritypolicies/{O.Name}',
                'operation_id': 'update_network_security_policy1',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (SecurityNetworkSecurityPolicy,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_network_security_policy1
        )

        def __update_security_group(
            self,
            o_tenant,
            o_name,
            body,
            **kwargs
        ):
            """Update SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_security_group(o_tenant, o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):
                body (SecuritySecurityGroup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_security_group = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/tenant/{O.Tenant}/security-groups/{O.Name}',
                'operation_id': 'update_security_group',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'body':
                        (SecuritySecurityGroup,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_security_group
        )

        def __update_security_group1(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update SecurityGroup object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_security_group1(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (SecuritySecurityGroup):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecuritySecurityGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_security_group1 = _Endpoint(
            settings={
                'response_type': (SecuritySecurityGroup,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/security-groups/{O.Name}',
                'operation_id': 'update_security_group1',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (SecuritySecurityGroup,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_security_group1
        )

        def __watch_app(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch App objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_app(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgAppWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_app = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgAppWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/tenant/{O.Tenant}/apps',
                'operation_id': 'watch_app',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_app
        )

        def __watch_app1(
            self,
            **kwargs
        ):
            """Watch App objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_app1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgAppWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_app1 = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgAppWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/apps',
                'operation_id': 'watch_app1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_app1
        )

        def __watch_firewall_profile(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch FirewallProfile objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_firewall_profile(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgFirewallProfileWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_firewall_profile = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgFirewallProfileWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/tenant/{O.Tenant}/firewallprofiles',
                'operation_id': 'watch_firewall_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_firewall_profile
        )

        def __watch_firewall_profile1(
            self,
            **kwargs
        ):
            """Watch FirewallProfile objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_firewall_profile1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgFirewallProfileWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_firewall_profile1 = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgFirewallProfileWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/firewallprofiles',
                'operation_id': 'watch_firewall_profile1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_firewall_profile1
        )

        def __watch_ip_sec_policy(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch IPSecPolicy objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_ip_sec_policy(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgIPSecPolicyWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_ip_sec_policy = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgIPSecPolicyWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/tenant/{O.Tenant}/ipsecpolicies',
                'operation_id': 'watch_ip_sec_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_ip_sec_policy
        )

        def __watch_ip_sec_policy1(
            self,
            **kwargs
        ):
            """Watch IPSecPolicy objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_ip_sec_policy1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgIPSecPolicyWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_ip_sec_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgIPSecPolicyWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/ipsecpolicies',
                'operation_id': 'watch_ip_sec_policy1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_ip_sec_policy1
        )

        def __watch_network_security_policy(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch NetworkSecurityPolicy objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_network_security_policy(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgNetworkSecurityPolicyWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_network_security_policy = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgNetworkSecurityPolicyWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/tenant/{O.Tenant}/networksecuritypolicies',
                'operation_id': 'watch_network_security_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_network_security_policy
        )

        def __watch_network_security_policy1(
            self,
            **kwargs
        ):
            """Watch NetworkSecurityPolicy objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_network_security_policy1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgNetworkSecurityPolicyWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_network_security_policy1 = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgNetworkSecurityPolicyWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/networksecuritypolicies',
                'operation_id': 'watch_network_security_policy1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_network_security_policy1
        )

        def __watch_security_group(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch SecurityGroup objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_security_group(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgSecurityGroupWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_security_group = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgSecurityGroupWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/tenant/{O.Tenant}/security-groups',
                'operation_id': 'watch_security_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_security_group
        )

        def __watch_security_group1(
            self,
            **kwargs
        ):
            """Watch SecurityGroup objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_security_group1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SecurityAutoMsgSecurityGroupWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_security_group1 = _Endpoint(
            settings={
                'response_type': (SecurityAutoMsgSecurityGroupWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/security/v1/watch/security-groups',
                'operation_id': 'watch_security_group1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_security_group1
        )
