"""
    Preferences API reference

    Service name    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.api_label import ApiLabel
from pensando_dss.psm.model.api_status import ApiStatus
from pensando_dss.psm.model.preferences_auto_msg_ui_global_settings_watch_helper import PreferencesAutoMsgUIGlobalSettingsWatchHelper
from pensando_dss.psm.model.preferences_ui_global_settings import PreferencesUIGlobalSettings


class PreferencesV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_ui_global_settings(
            self,
            o_tenant,
            **kwargs
        ):
            """Get UIGlobalSettings object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ui_global_settings(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_style_options (str): Can contain any UI style preferences. Provide typing through UI code.. [optional]
                idle_timeout_duration (str): Time of inactivity after which user logout countdown warning pops up. Should be a valid time duration.. [optional]
                idle_timeout_warning_time (str): Warning duration before logout and after system idle time. Should be a valid time duration of at most 5m0s.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesUIGlobalSettings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.get_ui_global_settings = _Endpoint(
            settings={
                'response_type': (PreferencesUIGlobalSettings,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/tenant/{O.Tenant}/uiglobalsettings',
                'operation_id': 'get_ui_global_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_style_options',
                    'idle_timeout_duration',
                    'idle_timeout_warning_time',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_style_options':
                        (str,),
                    'idle_timeout_duration':
                        (str,),
                    'idle_timeout_warning_time':
                        (str,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_style_options': 'spec.style-options',
                    'idle_timeout_duration': 'idle-timeout.duration',
                    'idle_timeout_warning_time': 'idle-timeout.warning-time',
                },
                'location_map': {
                    'o_tenant': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_style_options': 'query',
                    'idle_timeout_duration': 'query',
                    'idle_timeout_warning_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ui_global_settings
        )

        def __get_ui_global_settings1(
            self,
            **kwargs
        ):
            """Get UIGlobalSettings object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ui_global_settings1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_style_options (str): Can contain any UI style preferences. Provide typing through UI code.. [optional]
                idle_timeout_duration (str): Time of inactivity after which user logout countdown warning pops up. Should be a valid time duration.. [optional]
                idle_timeout_warning_time (str): Warning duration before logout and after system idle time. Should be a valid time duration of at most 5m0s.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesUIGlobalSettings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_ui_global_settings1 = _Endpoint(
            settings={
                'response_type': (PreferencesUIGlobalSettings,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/uiglobalsettings',
                'operation_id': 'get_ui_global_settings1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_style_options',
                    'idle_timeout_duration',
                    'idle_timeout_warning_time',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_style_options':
                        (str,),
                    'idle_timeout_duration':
                        (str,),
                    'idle_timeout_warning_time':
                        (str,),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_style_options': 'spec.style-options',
                    'idle_timeout_duration': 'idle-timeout.duration',
                    'idle_timeout_warning_time': 'idle-timeout.warning-time',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_style_options': 'query',
                    'idle_timeout_duration': 'query',
                    'idle_timeout_warning_time': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ui_global_settings1
        )

        def __label_ui_global_settings(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Label UIGlobalSettings object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_ui_global_settings(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesUIGlobalSettings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_ui_global_settings = _Endpoint(
            settings={
                'response_type': (PreferencesUIGlobalSettings,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/tenant/{O.Tenant}/uiglobalsettings/label',
                'operation_id': 'label_ui_global_settings',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_ui_global_settings
        )

        def __label_ui_global_settings1(
            self,
            body,
            **kwargs
        ):
            """Label UIGlobalSettings object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_ui_global_settings1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesUIGlobalSettings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_ui_global_settings1 = _Endpoint(
            settings={
                'response_type': (PreferencesUIGlobalSettings,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/uiglobalsettings/label',
                'operation_id': 'label_ui_global_settings1',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_ui_global_settings1
        )

        def __update_ui_global_settings(
            self,
            o_tenant,
            body,
            **kwargs
        ):
            """Update UIGlobalSettings object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_ui_global_settings(o_tenant, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                body (PreferencesUIGlobalSettings):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesUIGlobalSettings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_ui_global_settings = _Endpoint(
            settings={
                'response_type': (PreferencesUIGlobalSettings,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/tenant/{O.Tenant}/uiglobalsettings',
                'operation_id': 'update_ui_global_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'body',
                ],
                'required': [
                    'o_tenant',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'body':
                        (PreferencesUIGlobalSettings,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_ui_global_settings
        )

        def __update_ui_global_settings1(
            self,
            body,
            **kwargs
        ):
            """Update UIGlobalSettings object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_ui_global_settings1(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (PreferencesUIGlobalSettings):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesUIGlobalSettings
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_ui_global_settings1 = _Endpoint(
            settings={
                'response_type': (PreferencesUIGlobalSettings,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/uiglobalsettings',
                'operation_id': 'update_ui_global_settings1',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (PreferencesUIGlobalSettings,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_ui_global_settings1
        )

        def __watch_ui_global_settings(
            self,
            o_tenant,
            **kwargs
        ):
            """Watch UIGlobalSettings objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_ui_global_settings(o_tenant, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):

            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesAutoMsgUIGlobalSettingsWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            return self.call_with_http_info(**kwargs)

        self.watch_ui_global_settings = _Endpoint(
            settings={
                'response_type': (PreferencesAutoMsgUIGlobalSettingsWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/watch/tenant/{O.Tenant}/uiglobalsettings',
                'operation_id': 'watch_ui_global_settings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_ui_global_settings
        )

        def __watch_ui_global_settings1(
            self,
            **kwargs
        ):
            """Watch UIGlobalSettings objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_ui_global_settings1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PreferencesAutoMsgUIGlobalSettingsWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_ui_global_settings1 = _Endpoint(
            settings={
                'response_type': (PreferencesAutoMsgUIGlobalSettingsWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/preferences/v1/watch/uiglobalsettings',
                'operation_id': 'watch_ui_global_settings1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_ui_global_settings1
        )
