"""
    Fwlog API reference

    Service name    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.fwlog_fw_log_list import FwlogFwLogList
from pensando_dss.psm.model.fwlog_fw_log_query import FwlogFwLogQuery


class FwlogV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_download_fw_log_file_content(
            self,
            o_tenant,
            o_name,
            **kwargs
        ):
            """fwlog/v1/tenants/default/objects/<objectName>  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download_fw_log_file_content(o_tenant, o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_tenant (str):
                o_name (str):

            Keyword Args:
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FwlogFwLogList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_tenant'] = \
                o_tenant
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_download_fw_log_file_content = _Endpoint(
            settings={
                'response_type': (FwlogFwLogList,),
                'auth': [],
                'endpoint_path': '/fwlog/v1/tenants/{O.Tenant}/objects/{O.Name}',
                'operation_id': 'get_download_fw_log_file_content',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_tenant',
                    'o_name',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_tenant',
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_tenant':
                        (str,),
                    'o_name':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_tenant': 'O.Tenant',
                    'o_name': 'O.Name',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_tenant': 'path',
                    'o_name': 'path',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_download_fw_log_file_content
        )

        def __get_download_fw_log_file_content1(
            self,
            o_name,
            **kwargs
        ):
            """fwlog/v1/tenants/default/objects/<objectName>  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_download_fw_log_file_content1(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FwlogFwLogList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_download_fw_log_file_content1 = _Endpoint(
            settings={
                'response_type': (FwlogFwLogList,),
                'auth': [],
                'endpoint_path': '/fwlog/v1/objects/{O.Name}',
                'operation_id': 'get_download_fw_log_file_content1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'path',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_download_fw_log_file_content1
        )

        def __get_get_logs1(
            self,
            **kwargs
        ):
            """Queries firewall logs  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_get_logs1(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                source_ips ([str]): OR of sources IPs to be matched. Only one source IP is allowed. Should be a valid v4 or v6 IP address.. [optional]
                destination_ips ([str]): OR of destination IPs to be matched. Only one destination IP is allowed. Should be a valid v4 or v6 IP address.. [optional]
                source_ports ([int]): OR of source ports to be matched. Only one port can be specified and if present, source IP must also be specified. Value should be between 0 and 65535.. [optional]
                destination_ports ([int]): OR of destination ports to be matched. Only one port can be specified and if present, destination IP must also be specified. Value should be between 0 and 65535.. [optional]
                protocols ([str]): OR of protocols to be matched. Only one protocol can be specified and can only be specified if either source IP or destination IP is present.. [optional]
                actions ([str]): OR of actions to be matched. Only one action can be specified and can only be specified if either source IP or destination IP is present.. [optional]
                reporter_ids ([str]): OR of reporter names to be matched. Only one reporter ID can be specified.. [optional]
                start_time (datetime): StartTime selects all logs with timestamp greater than the StartTime, example 2018-10-18T00:12:00Z.. [optional]
                end_time (datetime): EndTime selects all logs with timestamp less than the EndTime, example 2018-09-18T00:12:00Z.. [optional]
                sort_order (str): SortOrder specifies time ordering of results.. [optional]
                max_results (int): MaxResults is the max-count of search results Default value is 50 and valid range is 0..8192. Value should be between 0 and 8192.. [optional]
                tenants ([str]): OR of tenants within the scope of which search needs to be performed. If not specified, it will be set to tenant of the logged in user. Also users in non default tenant can search fwlogs in their tenant scope only.. [optional]
                scroll_id (str): ScrollID to scroll through results fetched by an earlier query.. [optional]
                scroll_expiry (str): ScrollExpiry is time duration after which scroll id expires. Default is 5 min. A duration string is a sequence of decimal number and a unit suffix, such as \"300ms\" or \"2h45m\". Valid time units are \"ns\", \"us\" (or \"µs\"), \"ms\", \"s\", \"m\", \"h\". Subsequent requests with a scroll id resets the timer for expiry. Should be a valid time duration.. [optional]
                batch_size (int): BatchSize is the number of results returned in one batch while scrolling.. [optional]
                scroll_action (str): ScrollAction specifies actions related to scroll if its duration needs to be extended or scroll needs to be deleted.. [optional]
                count_only (bool): if set, returns only number of hits for the search query and not flow logs. Number of hits are greater than or equal to TotalCount value returned in list-meta.. [optional]
                encryption_status (str): if set, search logs that match the specified encryption status.. [optional]
                vpc_names ([str]): OR of vpc names to be matched. Only one vpc name is allowed.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FwlogFwLogList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_get_logs1 = _Endpoint(
            settings={
                'response_type': (FwlogFwLogList,),
                'auth': [],
                'endpoint_path': '/fwlog/v1/query',
                'operation_id': 'get_get_logs1',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_ips',
                    'destination_ips',
                    'source_ports',
                    'destination_ports',
                    'protocols',
                    'actions',
                    'reporter_ids',
                    'start_time',
                    'end_time',
                    'sort_order',
                    'max_results',
                    'tenants',
                    'scroll_id',
                    'scroll_expiry',
                    'batch_size',
                    'scroll_action',
                    'count_only',
                    'encryption_status',
                    'vpc_names',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_ips':
                        ([str],),
                    'destination_ips':
                        ([str],),
                    'source_ports':
                        ([int],),
                    'destination_ports':
                        ([int],),
                    'protocols':
                        ([str],),
                    'actions':
                        ([str],),
                    'reporter_ids':
                        ([str],),
                    'start_time':
                        (datetime,),
                    'end_time':
                        (datetime,),
                    'sort_order':
                        (str,),
                    'max_results':
                        (int,),
                    'tenants':
                        ([str],),
                    'scroll_id':
                        (str,),
                    'scroll_expiry':
                        (str,),
                    'batch_size':
                        (int,),
                    'scroll_action':
                        (str,),
                    'count_only':
                        (bool,),
                    'encryption_status':
                        (str,),
                    'vpc_names':
                        ([str],),
                },
                'attribute_map': {
                    'source_ips': 'source-ips',
                    'destination_ips': 'destination-ips',
                    'source_ports': 'source-ports',
                    'destination_ports': 'destination-ports',
                    'protocols': 'protocols',
                    'actions': 'actions',
                    'reporter_ids': 'reporter-ids',
                    'start_time': 'start-time',
                    'end_time': 'end-time',
                    'sort_order': 'sort-order',
                    'max_results': 'max-results',
                    'tenants': 'tenants',
                    'scroll_id': 'scroll-id',
                    'scroll_expiry': 'scroll-expiry',
                    'batch_size': 'batch-size',
                    'scroll_action': 'scroll-action',
                    'count_only': 'count-only',
                    'encryption_status': 'encryption-status',
                    'vpc_names': 'vpc-names',
                },
                'location_map': {
                    'source_ips': 'query',
                    'destination_ips': 'query',
                    'source_ports': 'query',
                    'destination_ports': 'query',
                    'protocols': 'query',
                    'actions': 'query',
                    'reporter_ids': 'query',
                    'start_time': 'query',
                    'end_time': 'query',
                    'sort_order': 'query',
                    'max_results': 'query',
                    'tenants': 'query',
                    'scroll_id': 'query',
                    'scroll_expiry': 'query',
                    'batch_size': 'query',
                    'scroll_action': 'query',
                    'count_only': 'query',
                    'encryption_status': 'query',
                    'vpc_names': 'query',
                },
                'collection_format_map': {
                    'source_ips': 'csv',
                    'destination_ips': 'csv',
                    'source_ports': 'csv',
                    'destination_ports': 'csv',
                    'protocols': 'csv',
                    'actions': 'csv',
                    'reporter_ids': 'csv',
                    'tenants': 'csv',
                    'vpc_names': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_get_logs1
        )

        def __get_watch_logs(
            self,
            **kwargs
        ):
            """get_watch_logs  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_watch_logs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                source_ips ([str]): OR of sources IPs to be matched. Only one source IP is allowed. Should be a valid v4 or v6 IP address.. [optional]
                destination_ips ([str]): OR of destination IPs to be matched. Only one destination IP is allowed. Should be a valid v4 or v6 IP address.. [optional]
                source_ports ([int]): OR of source ports to be matched. Only one port can be specified and if present, source IP must also be specified. Value should be between 0 and 65535.. [optional]
                destination_ports ([int]): OR of destination ports to be matched. Only one port can be specified and if present, destination IP must also be specified. Value should be between 0 and 65535.. [optional]
                protocols ([str]): OR of protocols to be matched. Only one protocol can be specified and can only be specified if either source IP or destination IP is present.. [optional]
                actions ([str]): OR of actions to be matched. Only one action can be specified and can only be specified if either source IP or destination IP is present.. [optional]
                reporter_ids ([str]): OR of reporter names to be matched. Only one reporter ID can be specified.. [optional]
                start_time (datetime): StartTime selects all logs with timestamp greater than the StartTime, example 2018-10-18T00:12:00Z.. [optional]
                end_time (datetime): EndTime selects all logs with timestamp less than the EndTime, example 2018-09-18T00:12:00Z.. [optional]
                sort_order (str): SortOrder specifies time ordering of results.. [optional]
                max_results (int): MaxResults is the max-count of search results Default value is 50 and valid range is 0..8192. Value should be between 0 and 8192.. [optional]
                tenants ([str]): OR of tenants within the scope of which search needs to be performed. If not specified, it will be set to tenant of the logged in user. Also users in non default tenant can search fwlogs in their tenant scope only.. [optional]
                scroll_id (str): ScrollID to scroll through results fetched by an earlier query.. [optional]
                scroll_expiry (str): ScrollExpiry is time duration after which scroll id expires. Default is 5 min. A duration string is a sequence of decimal number and a unit suffix, such as \"300ms\" or \"2h45m\". Valid time units are \"ns\", \"us\" (or \"µs\"), \"ms\", \"s\", \"m\", \"h\". Subsequent requests with a scroll id resets the timer for expiry. Should be a valid time duration.. [optional]
                batch_size (int): BatchSize is the number of results returned in one batch while scrolling.. [optional]
                scroll_action (str): ScrollAction specifies actions related to scroll if its duration needs to be extended or scroll needs to be deleted.. [optional]
                count_only (bool): if set, returns only number of hits for the search query and not flow logs. Number of hits are greater than or equal to TotalCount value returned in list-meta.. [optional]
                encryption_status (str): if set, search logs that match the specified encryption status.. [optional]
                vpc_names ([str]): OR of vpc names to be matched. Only one vpc name is allowed.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FwlogFwLogList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_watch_logs = _Endpoint(
            settings={
                'response_type': (FwlogFwLogList,),
                'auth': [],
                'endpoint_path': '/fwlog/v1/watch/query',
                'operation_id': 'get_watch_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_ips',
                    'destination_ips',
                    'source_ports',
                    'destination_ports',
                    'protocols',
                    'actions',
                    'reporter_ids',
                    'start_time',
                    'end_time',
                    'sort_order',
                    'max_results',
                    'tenants',
                    'scroll_id',
                    'scroll_expiry',
                    'batch_size',
                    'scroll_action',
                    'count_only',
                    'encryption_status',
                    'vpc_names',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_ips':
                        ([str],),
                    'destination_ips':
                        ([str],),
                    'source_ports':
                        ([int],),
                    'destination_ports':
                        ([int],),
                    'protocols':
                        ([str],),
                    'actions':
                        ([str],),
                    'reporter_ids':
                        ([str],),
                    'start_time':
                        (datetime,),
                    'end_time':
                        (datetime,),
                    'sort_order':
                        (str,),
                    'max_results':
                        (int,),
                    'tenants':
                        ([str],),
                    'scroll_id':
                        (str,),
                    'scroll_expiry':
                        (str,),
                    'batch_size':
                        (int,),
                    'scroll_action':
                        (str,),
                    'count_only':
                        (bool,),
                    'encryption_status':
                        (str,),
                    'vpc_names':
                        ([str],),
                },
                'attribute_map': {
                    'source_ips': 'source-ips',
                    'destination_ips': 'destination-ips',
                    'source_ports': 'source-ports',
                    'destination_ports': 'destination-ports',
                    'protocols': 'protocols',
                    'actions': 'actions',
                    'reporter_ids': 'reporter-ids',
                    'start_time': 'start-time',
                    'end_time': 'end-time',
                    'sort_order': 'sort-order',
                    'max_results': 'max-results',
                    'tenants': 'tenants',
                    'scroll_id': 'scroll-id',
                    'scroll_expiry': 'scroll-expiry',
                    'batch_size': 'batch-size',
                    'scroll_action': 'scroll-action',
                    'count_only': 'count-only',
                    'encryption_status': 'encryption-status',
                    'vpc_names': 'vpc-names',
                },
                'location_map': {
                    'source_ips': 'query',
                    'destination_ips': 'query',
                    'source_ports': 'query',
                    'destination_ports': 'query',
                    'protocols': 'query',
                    'actions': 'query',
                    'reporter_ids': 'query',
                    'start_time': 'query',
                    'end_time': 'query',
                    'sort_order': 'query',
                    'max_results': 'query',
                    'tenants': 'query',
                    'scroll_id': 'query',
                    'scroll_expiry': 'query',
                    'batch_size': 'query',
                    'scroll_action': 'query',
                    'count_only': 'query',
                    'encryption_status': 'query',
                    'vpc_names': 'query',
                },
                'collection_format_map': {
                    'source_ips': 'csv',
                    'destination_ips': 'csv',
                    'source_ports': 'csv',
                    'destination_ports': 'csv',
                    'protocols': 'csv',
                    'actions': 'csv',
                    'reporter_ids': 'csv',
                    'tenants': 'csv',
                    'vpc_names': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_watch_logs
        )

        def __post_get_logs(
            self,
            body,
            **kwargs
        ):
            """Queries firewall logs  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_get_logs(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (FwlogFwLogQuery):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                FwlogFwLogList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.post_get_logs = _Endpoint(
            settings={
                'response_type': (FwlogFwLogList,),
                'auth': [],
                'endpoint_path': '/fwlog/v1/query',
                'operation_id': 'post_get_logs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (FwlogFwLogQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_get_logs
        )
