"""
    Cluster API reference

    Service name    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pensando_dss.psm.api_client import ApiClient, Endpoint as _Endpoint
from pensando_dss.psm.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
import pensando_dss.psm as psm
from pensando_dss.psm.model.api_label import ApiLabel
from pensando_dss.psm.model.api_status import ApiStatus
from pensando_dss.psm.model.cluster_auto_msg_cluster_profile_watch_helper import ClusterAutoMsgClusterProfileWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_cluster_watch_helper import ClusterAutoMsgClusterWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_configuration_snapshot_watch_helper import ClusterAutoMsgConfigurationSnapshotWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_dsc_profile_watch_helper import ClusterAutoMsgDSCProfileWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_distributed_service_card_watch_helper import ClusterAutoMsgDistributedServiceCardWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_host_watch_helper import ClusterAutoMsgHostWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_node_watch_helper import ClusterAutoMsgNodeWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_tenant_watch_helper import ClusterAutoMsgTenantWatchHelper
from pensando_dss.psm.model.cluster_auto_msg_version_watch_helper import ClusterAutoMsgVersionWatchHelper
from pensando_dss.psm.model.cluster_cluster import ClusterCluster
from pensando_dss.psm.model.cluster_cluster_auth_bootstrap_request import ClusterClusterAuthBootstrapRequest
from pensando_dss.psm.model.cluster_cluster_profile import ClusterClusterProfile
from pensando_dss.psm.model.cluster_configuration_snapshot import ClusterConfigurationSnapshot
from pensando_dss.psm.model.cluster_configuration_snapshot_request import ClusterConfigurationSnapshotRequest
from pensando_dss.psm.model.cluster_dsc_profile import ClusterDSCProfile
from pensando_dss.psm.model.cluster_dsc_profile_list import ClusterDSCProfileList
from pensando_dss.psm.model.cluster_distributed_service_card import ClusterDistributedServiceCard
from pensando_dss.psm.model.cluster_distributed_service_card_list import ClusterDistributedServiceCardList
from pensando_dss.psm.model.cluster_host import ClusterHost
from pensando_dss.psm.model.cluster_host_list import ClusterHostList
from pensando_dss.psm.model.cluster_license import ClusterLicense
from pensando_dss.psm.model.cluster_node import ClusterNode
from pensando_dss.psm.model.cluster_node_list import ClusterNodeList
from pensando_dss.psm.model.cluster_snapshot_restore import ClusterSnapshotRestore
from pensando_dss.psm.model.cluster_tenant import ClusterTenant
from pensando_dss.psm.model.cluster_tenant_list import ClusterTenantList
from pensando_dss.psm.model.cluster_update_tls_config_request import ClusterUpdateTLSConfigRequest
from pensando_dss.psm.model.cluster_version import ClusterVersion


class ClusterV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_configuration_snapshot(
            self,
            body,
            **kwargs
        ):
            """Create ConfigurationSnapshot object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_configuration_snapshot(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterConfigurationSnapshot):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterConfigurationSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_configuration_snapshot = _Endpoint(
            settings={
                'response_type': (ClusterConfigurationSnapshot,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-snapshot',
                'operation_id': 'add_configuration_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterConfigurationSnapshot,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_configuration_snapshot
        )

        def __add_dsc_profile(
            self,
            body,
            **kwargs
        ):
            """Create DSCProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_dsc_profile(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterDSCProfile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDSCProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterDSCProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/dscprofiles',
                'operation_id': 'add_dsc_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterDSCProfile,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_dsc_profile
        )

        def __add_host(
            self,
            body,
            **kwargs
        ):
            """Create Host object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_host(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterHost):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterHost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_host = _Endpoint(
            settings={
                'response_type': (ClusterHost,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/hosts',
                'operation_id': 'add_host',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterHost,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_host
        )

        def __add_license(
            self,
            body,
            **kwargs
        ):
            """Create License object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_license(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterLicense):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterLicense
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_license = _Endpoint(
            settings={
                'response_type': (ClusterLicense,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/licenses',
                'operation_id': 'add_license',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterLicense,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_license
        )

        def __add_node(
            self,
            body,
            **kwargs
        ):
            """Create Node object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_node(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterNode):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterNode
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_node = _Endpoint(
            settings={
                'response_type': (ClusterNode,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/nodes',
                'operation_id': 'add_node',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterNode,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_node
        )

        def __add_tenant(
            self,
            body,
            **kwargs
        ):
            """Create Tenant object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_tenant(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterTenant):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterTenant
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.add_tenant = _Endpoint(
            settings={
                'response_type': (ClusterTenant,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/tenants',
                'operation_id': 'add_tenant',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterTenant,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_tenant
        )

        def __auth_bootstrap_complete(
            self,
            body,
            **kwargs
        ):
            """Mark bootstrapping as complete for the cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.auth_bootstrap_complete(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterClusterAuthBootstrapRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.auth_bootstrap_complete = _Endpoint(
            settings={
                'response_type': (ClusterCluster,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/cluster/AuthBootstrapComplete',
                'operation_id': 'auth_bootstrap_complete',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterClusterAuthBootstrapRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__auth_bootstrap_complete
        )

        def __delete_configuration_snapshot(
            self,
            **kwargs
        ):
            """Delete ConfigurationSnapshot object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_configuration_snapshot(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterConfigurationSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.delete_configuration_snapshot = _Endpoint(
            settings={
                'response_type': (ClusterConfigurationSnapshot,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-snapshot',
                'operation_id': 'delete_configuration_snapshot',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_configuration_snapshot
        )

        def __delete_distributed_service_card(
            self,
            o_name,
            **kwargs
        ):
            """Delete DistributedServiceCard object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_distributed_service_card(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDistributedServiceCard
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_distributed_service_card = _Endpoint(
            settings={
                'response_type': (ClusterDistributedServiceCard,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/distributedservicecards/{O.Name}',
                'operation_id': 'delete_distributed_service_card',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_distributed_service_card
        )

        def __delete_dsc_profile(
            self,
            o_name,
            **kwargs
        ):
            """Delete DSCProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_dsc_profile(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDSCProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterDSCProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/dscprofiles/{O.Name}',
                'operation_id': 'delete_dsc_profile',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_dsc_profile
        )

        def __delete_host(
            self,
            o_name,
            **kwargs
        ):
            """Delete Host object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_host(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterHost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_host = _Endpoint(
            settings={
                'response_type': (ClusterHost,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/hosts/{O.Name}',
                'operation_id': 'delete_host',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_host
        )

        def __delete_node(
            self,
            o_name,
            **kwargs
        ):
            """Delete Node object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_node(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterNode
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_node = _Endpoint(
            settings={
                'response_type': (ClusterNode,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/nodes/{O.Name}',
                'operation_id': 'delete_node',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_node
        )

        def __delete_tenant(
            self,
            o_name,
            **kwargs
        ):
            """Delete Tenant object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_tenant(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterTenant
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.delete_tenant = _Endpoint(
            settings={
                'response_type': (ClusterTenant,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/tenants/{O.Name}',
                'operation_id': 'delete_tenant',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_tenant
        )

        def __get_cluster(
            self,
            **kwargs
        ):
            """Get Cluster object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_cluster(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_quorum_nodes ([str]): QuorumNodes contains the list of hostnames for nodes configured to be quorum nodes in the cluster.. [optional]
                spec_virtual_ip (str): VirtualIP is the IP address for managing the cluster. It will be hosted by the winner of election between quorum nodes.. [optional]
                spec_ntp_servers ([str]): NTPServers contains the list of NTP servers for the cluster.. [optional]
                spec_auto_admit_dscs (bool): AutoAdmitDSCs when enabled auto-admits DSCs that are validated into Venice Cluster. When it is disabled, DSCs validated by CMD are set to Pending state and it requires Manual approval to be admitted into the cluster.. [optional]
                spec_certs (str): Certs is the pem encoded certificate bundle used for API Gateway TLS.. [optional]
                spec_key (str): Key is the pem encoded private key used for API Gateway TLS. We support RSA or ECDSA.. [optional]
                recovery_keys_psm_version (str): PsmVersion is the version of the PSM SW corresponding to the recovery keys.. [optional]
                recovery_keys_private_key (str): PrivateKey is the private key generated at cluster bootstrap.. [optional]
                recovery_keys_trust_chain ([str]): TrustChain is the chain of intermediate certificates that are needed to establish the validity of the public key.. [optional]
                recovery_keys_trust_roots ([str]): TrustRoot is the certificate of an entity used as a root CA.. [optional]
                status_leader (str): Leader contains the node name of the cluster leader.. [optional]
                status_last_leader_transition_time (datetime): LastLeaderTransitionTime is when the leadership changed last time.. [optional]
                status_auth_bootstrapped (bool): AuthBootstrapped indicates whether the Cluster has Completed BootStrap of Auth.. [optional]
                status_current_time (datetime): CurrentTime is current time of a cluster.. [optional]
                status_recovery_keys_downloaded (bool): RecoveryKeysDownloaded indicates whether keys have been downloaded since the cluster has been bootstrapped.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_cluster = _Endpoint(
            settings={
                'response_type': (ClusterCluster,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/cluster',
                'operation_id': 'get_cluster',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_quorum_nodes',
                    'spec_virtual_ip',
                    'spec_ntp_servers',
                    'spec_auto_admit_dscs',
                    'spec_certs',
                    'spec_key',
                    'recovery_keys_psm_version',
                    'recovery_keys_private_key',
                    'recovery_keys_trust_chain',
                    'recovery_keys_trust_roots',
                    'status_leader',
                    'status_last_leader_transition_time',
                    'status_auth_bootstrapped',
                    'status_current_time',
                    'status_recovery_keys_downloaded',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_quorum_nodes':
                        ([str],),
                    'spec_virtual_ip':
                        (str,),
                    'spec_ntp_servers':
                        ([str],),
                    'spec_auto_admit_dscs':
                        (bool,),
                    'spec_certs':
                        (str,),
                    'spec_key':
                        (str,),
                    'recovery_keys_psm_version':
                        (str,),
                    'recovery_keys_private_key':
                        (str,),
                    'recovery_keys_trust_chain':
                        ([str],),
                    'recovery_keys_trust_roots':
                        ([str],),
                    'status_leader':
                        (str,),
                    'status_last_leader_transition_time':
                        (datetime,),
                    'status_auth_bootstrapped':
                        (bool,),
                    'status_current_time':
                        (datetime,),
                    'status_recovery_keys_downloaded':
                        (bool,),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_quorum_nodes': 'spec.quorum-nodes',
                    'spec_virtual_ip': 'spec.virtual-ip',
                    'spec_ntp_servers': 'spec.ntp-servers',
                    'spec_auto_admit_dscs': 'spec.auto-admit-dscs',
                    'spec_certs': 'spec.certs',
                    'spec_key': 'spec.key',
                    'recovery_keys_psm_version': 'recovery-keys.psm-version',
                    'recovery_keys_private_key': 'recovery-keys.private-key',
                    'recovery_keys_trust_chain': 'recovery-keys.trust-chain',
                    'recovery_keys_trust_roots': 'recovery-keys.trust-roots',
                    'status_leader': 'status.leader',
                    'status_last_leader_transition_time': 'status.last-leader-transition-time',
                    'status_auth_bootstrapped': 'status.auth-bootstrapped',
                    'status_current_time': 'status.current-time',
                    'status_recovery_keys_downloaded': 'status.recovery-keys-downloaded',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_quorum_nodes': 'query',
                    'spec_virtual_ip': 'query',
                    'spec_ntp_servers': 'query',
                    'spec_auto_admit_dscs': 'query',
                    'spec_certs': 'query',
                    'spec_key': 'query',
                    'recovery_keys_psm_version': 'query',
                    'recovery_keys_private_key': 'query',
                    'recovery_keys_trust_chain': 'query',
                    'recovery_keys_trust_roots': 'query',
                    'status_leader': 'query',
                    'status_last_leader_transition_time': 'query',
                    'status_auth_bootstrapped': 'query',
                    'status_current_time': 'query',
                    'status_recovery_keys_downloaded': 'query',
                },
                'collection_format_map': {
                    'spec_quorum_nodes': 'csv',
                    'spec_ntp_servers': 'csv',
                    'recovery_keys_trust_chain': 'csv',
                    'recovery_keys_trust_roots': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_cluster
        )

        def __get_cluster_profile(
            self,
            **kwargs
        ):
            """Get ClusterProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_cluster_profile(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                search_options_enable_fwlog_search (bool): EnableFwlogSearch when enabled peforms reverse indexing of fwlogs getting ingested into PSM. The reverse indexed logs can be queried using the fwlog query/search API.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterClusterProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_cluster_profile = _Endpoint(
            settings={
                'response_type': (ClusterClusterProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/clusterprofile',
                'operation_id': 'get_cluster_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'search_options_enable_fwlog_search',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'search_options_enable_fwlog_search':
                        (bool,),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'search_options_enable_fwlog_search': 'search-options.enable-fwlog-search',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'search_options_enable_fwlog_search': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_cluster_profile
        )

        def __get_configuration_snapshot(
            self,
            **kwargs
        ):
            """Get ConfigurationSnapshot object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_configuration_snapshot(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                destination_type (str): [optional]
                last_snapshot_dest_type (str): [optional]
                last_snapshot_uri (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterConfigurationSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_configuration_snapshot = _Endpoint(
            settings={
                'response_type': (ClusterConfigurationSnapshot,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-snapshot',
                'operation_id': 'get_configuration_snapshot',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'destination_type',
                    'last_snapshot_dest_type',
                    'last_snapshot_uri',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'destination_type':
                        (str,),
                    'last_snapshot_dest_type':
                        (str,),
                    'last_snapshot_uri':
                        (str,),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'destination_type': 'destination.Type',
                    'last_snapshot_dest_type': 'last-snapshot.dest-type',
                    'last_snapshot_uri': 'last-snapshot.uri',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'destination_type': 'query',
                    'last_snapshot_dest_type': 'query',
                    'last_snapshot_uri': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_configuration_snapshot
        )

        def __get_distributed_service_card(
            self,
            o_name,
            **kwargs
        ):
            """Get DistributedServiceCard object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_distributed_service_card(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_admit (bool): Admit allows a DistributedServiceCard to join the cluster.. [optional]
                spec_id (str): ID is used as a user friendly identifier in logs/events.. [optional]
                ip_config_ip_address (str): IPAddress contains the Management IP address of the DistributedServiceCard in CIDR format. Should be a valid v4 or v6 CIDR block.. [optional]
                ip_config_default_gw (str): DefaultGW contains the default gateway's IP address. Should be a valid v4 or v6 IP address.. [optional]
                ip_config_dns_servers ([str]): DNSServers contains a list of DNS Servers that can be used on DistributedServiceCard.. [optional]
                spec_mgmt_mode (str): MgmtMode defines the management mode of the DistributedServiceCard.. [optional]
                spec_network_mode (str): MgmtMode defines the management mode of the DistributedServiceCard.. [optional]
                spec_mgmt_vlan (int): MgmtVlan defines the vlan to be used in network managed mode. The default of 0 means we use untagged-vlan for doing inband management. Value should be between 0 and 4095.. [optional]
                spec_controllers ([str]): Controllers contains the list of remote controllers IP addresses or hostnames.. [optional]
                spec_routing_config (str): RoutingConfig is the routing configuration for the underlay routed network that this DSC participates in.. [optional]
                spec_dscprofile (str): [optional]
                policer_tenant (str): Tenant is the tenant to which policerprofile belongs to.. [optional]
                policer_tx_policer (str): TxPolicer is the name of the policerprofile to be applied in Tx direction.. [optional]
                fwlog_policy_tenant (str): Tenant of FwlogPolicy.. [optional]
                fwlog_policy_name (str): Name of FwlogPolicy.. [optional]
                spec_enable_fw_logging (bool): EnableFwLogging enables flow logging on the device.. [optional]
                spec_enable_secure_boot (bool): EnableSecureBoot a true value indicates, set lifecycle fuse to enable secure boot.. [optional]
                status_admission_phase (str): Current admission phase of the DistributedServiceCard. When auto-admission is enabled, AdmissionPhase will be set to NIC_ADMITTED by CMD for validated NICs. When auto-admission is not enabled, AdmissionPhase will be set to NIC_PENDING by CMD for validated NICs since it requires manual approval. To admit the NIC as a part of manual admission, user is expected to set Spec.Admit to true for the NICs that are in NIC_PENDING state. Note : Whitelist mode is not supported yet.. [optional]
                status_serial_num (str): Serial number.. [optional]
                status_primary_mac (str): PrimaryMAC is the MAC address of the primary PF exposed by DistributedServiceCard. Should be a valid MAC address.. [optional]
                ip_config_ip_address2 (str): IPAddress contains the Management IP address of the DistributedServiceCard in CIDR format. Should be a valid v4 or v6 CIDR block.. [optional]
                ip_config_default_gw2 (str): DefaultGW contains the default gateway's IP address. Should be a valid v4 or v6 IP address.. [optional]
                ip_config_dns_servers2 ([str]): DNSServers contains a list of DNS Servers that can be used on DistributedServiceCard.. [optional]
                bios_info_vendor (str): Vendor name.. [optional]
                bios_info_version (str): BIOS version.. [optional]
                bios_info_fw_major_ver (str): Firmware major release info.. [optional]
                bios_info_fw_minor_ver (str): Firmware minor release info.. [optional]
                os_info_type (str): OS Name Eg: GNU/Linux.. [optional]
                os_info_kernel_release (str): Kernel release Eg: 3.10.0-514.10.2.el7.x86_64.. [optional]
                os_info_kernel_version (str): Kernel version Eg: #1 SMP Fri Mar 3 00:04:05 UTC 2017.. [optional]
                os_info_processor (str): Processor Info Eg: x86_64.. [optional]
                cpu_info_speed (str): CPU speed per core, eg: 2099998101.. [optional]
                cpu_info_num_sockets (int): Number of CPU sockets, eg: 2, 4.. [optional]
                cpu_info_num_cores (int): Number of physical CPU cores per socket, eg: 36.. [optional]
                cpu_info_num_threads (int): Number of threads per core, eg: 2.. [optional]
                memory_info_type (str): Type.. [optional]
                memory_info_size (str): Memory size in bytes, eg: 274760318976.. [optional]
                status_interfaces ([str]): Network Interfaces.. [optional]
                status_dsc_version (str): DSC Version.. [optional]
                status_dsc_sku (str): DSC SKU.. [optional]
                status_host (str): The name of the host this DistributedServiceCard is plugged into.. [optional]
                status_adm_phase_reason (str): The reason why the DistributedServiceCard is not in ADMITTED state.. [optional]
                status_version_mismatch (bool): Set to true if venice and dsc versions are incompatible.. [optional]
                control_plane_status_last_updated_time (str): The last time the control plane was updated.. [optional]
                control_plane_status_message (str): A message indicating details about the control plane status.. [optional]
                status_is_connected_to_psm (bool): IsConnectedToPSM is set to true if connected to PSM.. [optional]
                status_unhealthy_services ([str]): Lists the unhealthy services of a distributed service card.. [optional]
                status_num_mac_address (int): NumMacAddress has the number of mac addresses that is available on this DSC. Value should be between 0 and 256.. [optional]
                inband_ip_config_ip_address (str): IPAddress contains the Management IP address of the DistributedServiceCard in CIDR format. Should be a valid v4 or v6 CIDR block.. [optional]
                inband_ip_config_default_gw (str): DefaultGW contains the default gateway's IP address. Should be a valid v4 or v6 IP address.. [optional]
                inband_ip_config_dns_servers ([str]): DNSServers contains a list of DNS Servers that can be used on DistributedServiceCard.. [optional]
                status_secure_booted (bool): SecureBooted a true value indicates, secure boot is enabled.. [optional]
                status_alom_present (bool): ALOMPresent true value indicates ALOM cable is present.. [optional]
                status_package_type (str): Type of DSC.. [optional]
                dss_info_host_name (str): Hostname of the switch.. [optional]
                dss_info_version (str): switch software version.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDistributedServiceCard
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_distributed_service_card = _Endpoint(
            settings={
                'response_type': (ClusterDistributedServiceCard,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/distributedservicecards/{O.Name}',
                'operation_id': 'get_distributed_service_card',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_admit',
                    'spec_id',
                    'ip_config_ip_address',
                    'ip_config_default_gw',
                    'ip_config_dns_servers',
                    'spec_mgmt_mode',
                    'spec_network_mode',
                    'spec_mgmt_vlan',
                    'spec_controllers',
                    'spec_routing_config',
                    'spec_dscprofile',
                    'policer_tenant',
                    'policer_tx_policer',
                    'fwlog_policy_tenant',
                    'fwlog_policy_name',
                    'spec_enable_fw_logging',
                    'spec_enable_secure_boot',
                    'status_admission_phase',
                    'status_serial_num',
                    'status_primary_mac',
                    'ip_config_ip_address2',
                    'ip_config_default_gw2',
                    'ip_config_dns_servers2',
                    'bios_info_vendor',
                    'bios_info_version',
                    'bios_info_fw_major_ver',
                    'bios_info_fw_minor_ver',
                    'os_info_type',
                    'os_info_kernel_release',
                    'os_info_kernel_version',
                    'os_info_processor',
                    'cpu_info_speed',
                    'cpu_info_num_sockets',
                    'cpu_info_num_cores',
                    'cpu_info_num_threads',
                    'memory_info_type',
                    'memory_info_size',
                    'status_interfaces',
                    'status_dsc_version',
                    'status_dsc_sku',
                    'status_host',
                    'status_adm_phase_reason',
                    'status_version_mismatch',
                    'control_plane_status_last_updated_time',
                    'control_plane_status_message',
                    'status_is_connected_to_psm',
                    'status_unhealthy_services',
                    'status_num_mac_address',
                    'inband_ip_config_ip_address',
                    'inband_ip_config_default_gw',
                    'inband_ip_config_dns_servers',
                    'status_secure_booted',
                    'status_alom_present',
                    'status_package_type',
                    'dss_info_host_name',
                    'dss_info_version',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_admit':
                        (bool,),
                    'spec_id':
                        (str,),
                    'ip_config_ip_address':
                        (str,),
                    'ip_config_default_gw':
                        (str,),
                    'ip_config_dns_servers':
                        ([str],),
                    'spec_mgmt_mode':
                        (str,),
                    'spec_network_mode':
                        (str,),
                    'spec_mgmt_vlan':
                        (int,),
                    'spec_controllers':
                        ([str],),
                    'spec_routing_config':
                        (str,),
                    'spec_dscprofile':
                        (str,),
                    'policer_tenant':
                        (str,),
                    'policer_tx_policer':
                        (str,),
                    'fwlog_policy_tenant':
                        (str,),
                    'fwlog_policy_name':
                        (str,),
                    'spec_enable_fw_logging':
                        (bool,),
                    'spec_enable_secure_boot':
                        (bool,),
                    'status_admission_phase':
                        (str,),
                    'status_serial_num':
                        (str,),
                    'status_primary_mac':
                        (str,),
                    'ip_config_ip_address2':
                        (str,),
                    'ip_config_default_gw2':
                        (str,),
                    'ip_config_dns_servers2':
                        ([str],),
                    'bios_info_vendor':
                        (str,),
                    'bios_info_version':
                        (str,),
                    'bios_info_fw_major_ver':
                        (str,),
                    'bios_info_fw_minor_ver':
                        (str,),
                    'os_info_type':
                        (str,),
                    'os_info_kernel_release':
                        (str,),
                    'os_info_kernel_version':
                        (str,),
                    'os_info_processor':
                        (str,),
                    'cpu_info_speed':
                        (str,),
                    'cpu_info_num_sockets':
                        (int,),
                    'cpu_info_num_cores':
                        (int,),
                    'cpu_info_num_threads':
                        (int,),
                    'memory_info_type':
                        (str,),
                    'memory_info_size':
                        (str,),
                    'status_interfaces':
                        ([str],),
                    'status_dsc_version':
                        (str,),
                    'status_dsc_sku':
                        (str,),
                    'status_host':
                        (str,),
                    'status_adm_phase_reason':
                        (str,),
                    'status_version_mismatch':
                        (bool,),
                    'control_plane_status_last_updated_time':
                        (str,),
                    'control_plane_status_message':
                        (str,),
                    'status_is_connected_to_psm':
                        (bool,),
                    'status_unhealthy_services':
                        ([str],),
                    'status_num_mac_address':
                        (int,),
                    'inband_ip_config_ip_address':
                        (str,),
                    'inband_ip_config_default_gw':
                        (str,),
                    'inband_ip_config_dns_servers':
                        ([str],),
                    'status_secure_booted':
                        (bool,),
                    'status_alom_present':
                        (bool,),
                    'status_package_type':
                        (str,),
                    'dss_info_host_name':
                        (str,),
                    'dss_info_version':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_admit': 'spec.admit',
                    'spec_id': 'spec.id',
                    'ip_config_ip_address': 'ip-config.ip-address',
                    'ip_config_default_gw': 'ip-config.default-gw',
                    'ip_config_dns_servers': 'ip-config.dns-servers',
                    'spec_mgmt_mode': 'spec.mgmt-mode',
                    'spec_network_mode': 'spec.network-mode',
                    'spec_mgmt_vlan': 'spec.mgmt-vlan',
                    'spec_controllers': 'spec.controllers',
                    'spec_routing_config': 'spec.routing-config',
                    'spec_dscprofile': 'spec.dscprofile',
                    'policer_tenant': 'policer.tenant',
                    'policer_tx_policer': 'policer.tx-policer',
                    'fwlog_policy_tenant': 'fwlog-policy.tenant',
                    'fwlog_policy_name': 'fwlog-policy.name',
                    'spec_enable_fw_logging': 'spec.enable-fw-logging',
                    'spec_enable_secure_boot': 'spec.enable-secure-boot',
                    'status_admission_phase': 'status.admission-phase',
                    'status_serial_num': 'status.serial-num',
                    'status_primary_mac': 'status.primary-mac',
                    'ip_config_ip_address2': 'ip-config.ip-address',
                    'ip_config_default_gw2': 'ip-config.default-gw',
                    'ip_config_dns_servers2': 'ip-config.dns-servers',
                    'bios_info_vendor': 'bios-info.vendor',
                    'bios_info_version': 'bios-info.version',
                    'bios_info_fw_major_ver': 'bios-info.fw-major-ver',
                    'bios_info_fw_minor_ver': 'bios-info.fw-minor-ver',
                    'os_info_type': 'os-info.type',
                    'os_info_kernel_release': 'os-info.kernel-release',
                    'os_info_kernel_version': 'os-info.kernel-version',
                    'os_info_processor': 'os-info.processor',
                    'cpu_info_speed': 'cpu-info.speed',
                    'cpu_info_num_sockets': 'cpu-info.num-sockets',
                    'cpu_info_num_cores': 'cpu-info.num-cores',
                    'cpu_info_num_threads': 'cpu-info.num-threads',
                    'memory_info_type': 'memory-info.type',
                    'memory_info_size': 'memory-info.size',
                    'status_interfaces': 'status.interfaces',
                    'status_dsc_version': 'status.DSCVersion',
                    'status_dsc_sku': 'status.DSCSku',
                    'status_host': 'status.host',
                    'status_adm_phase_reason': 'status.adm-phase-reason',
                    'status_version_mismatch': 'status.version-mismatch',
                    'control_plane_status_last_updated_time': 'control-plane-status.last-updated-time',
                    'control_plane_status_message': 'control-plane-status.message',
                    'status_is_connected_to_psm': 'status.is-connected-to-psm',
                    'status_unhealthy_services': 'status.unhealthy-services',
                    'status_num_mac_address': 'status.num-mac-address',
                    'inband_ip_config_ip_address': 'inband-ip-config.ip-address',
                    'inband_ip_config_default_gw': 'inband-ip-config.default-gw',
                    'inband_ip_config_dns_servers': 'inband-ip-config.dns-servers',
                    'status_secure_booted': 'status.secure-booted',
                    'status_alom_present': 'status.alom-present',
                    'status_package_type': 'status.package-type',
                    'dss_info_host_name': 'dss-info.host-name',
                    'dss_info_version': 'dss-info.version',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_admit': 'query',
                    'spec_id': 'query',
                    'ip_config_ip_address': 'query',
                    'ip_config_default_gw': 'query',
                    'ip_config_dns_servers': 'query',
                    'spec_mgmt_mode': 'query',
                    'spec_network_mode': 'query',
                    'spec_mgmt_vlan': 'query',
                    'spec_controllers': 'query',
                    'spec_routing_config': 'query',
                    'spec_dscprofile': 'query',
                    'policer_tenant': 'query',
                    'policer_tx_policer': 'query',
                    'fwlog_policy_tenant': 'query',
                    'fwlog_policy_name': 'query',
                    'spec_enable_fw_logging': 'query',
                    'spec_enable_secure_boot': 'query',
                    'status_admission_phase': 'query',
                    'status_serial_num': 'query',
                    'status_primary_mac': 'query',
                    'ip_config_ip_address2': 'query',
                    'ip_config_default_gw2': 'query',
                    'ip_config_dns_servers2': 'query',
                    'bios_info_vendor': 'query',
                    'bios_info_version': 'query',
                    'bios_info_fw_major_ver': 'query',
                    'bios_info_fw_minor_ver': 'query',
                    'os_info_type': 'query',
                    'os_info_kernel_release': 'query',
                    'os_info_kernel_version': 'query',
                    'os_info_processor': 'query',
                    'cpu_info_speed': 'query',
                    'cpu_info_num_sockets': 'query',
                    'cpu_info_num_cores': 'query',
                    'cpu_info_num_threads': 'query',
                    'memory_info_type': 'query',
                    'memory_info_size': 'query',
                    'status_interfaces': 'query',
                    'status_dsc_version': 'query',
                    'status_dsc_sku': 'query',
                    'status_host': 'query',
                    'status_adm_phase_reason': 'query',
                    'status_version_mismatch': 'query',
                    'control_plane_status_last_updated_time': 'query',
                    'control_plane_status_message': 'query',
                    'status_is_connected_to_psm': 'query',
                    'status_unhealthy_services': 'query',
                    'status_num_mac_address': 'query',
                    'inband_ip_config_ip_address': 'query',
                    'inband_ip_config_default_gw': 'query',
                    'inband_ip_config_dns_servers': 'query',
                    'status_secure_booted': 'query',
                    'status_alom_present': 'query',
                    'status_package_type': 'query',
                    'dss_info_host_name': 'query',
                    'dss_info_version': 'query',
                },
                'collection_format_map': {
                    'ip_config_dns_servers': 'csv',
                    'spec_controllers': 'csv',
                    'ip_config_dns_servers2': 'csv',
                    'status_interfaces': 'csv',
                    'status_unhealthy_services': 'csv',
                    'inband_ip_config_dns_servers': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_distributed_service_card
        )

        def __get_dsc_profile(
            self,
            o_name,
            **kwargs
        ):
            """Get DSCProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsc_profile(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_deployment_target (str): [optional]
                spec_feature_set (str): [optional]
                interface_profile_num_pfs (int): [optional]
                interface_profile_num_vfs (int): [optional]
                spec_apply_policies_to_encapsulated_traffic (str): [optional]
                propagation_status_generation_id (str): The Generation ID this status is for.. [optional]
                propagation_status_updated (int): The number of Naples that this version has already been pushed to.. [optional]
                propagation_status_pending (int): Number of Naples pending. If this is 0 it can be assumed that everything is up to date.. [optional]
                propagation_status_min_version (str): The Version running on the slowest Naples.. [optional]
                propagation_status_status (str): Textual description of propagation status.. [optional]
                propagation_status_pending_dscs ([str]): list of DSCs where propagation did not complete.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDSCProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterDSCProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/dscprofiles/{O.Name}',
                'operation_id': 'get_dsc_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_deployment_target',
                    'spec_feature_set',
                    'interface_profile_num_pfs',
                    'interface_profile_num_vfs',
                    'spec_apply_policies_to_encapsulated_traffic',
                    'propagation_status_generation_id',
                    'propagation_status_updated',
                    'propagation_status_pending',
                    'propagation_status_min_version',
                    'propagation_status_status',
                    'propagation_status_pending_dscs',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_deployment_target':
                        (str,),
                    'spec_feature_set':
                        (str,),
                    'interface_profile_num_pfs':
                        (int,),
                    'interface_profile_num_vfs':
                        (int,),
                    'spec_apply_policies_to_encapsulated_traffic':
                        (str,),
                    'propagation_status_generation_id':
                        (str,),
                    'propagation_status_updated':
                        (int,),
                    'propagation_status_pending':
                        (int,),
                    'propagation_status_min_version':
                        (str,),
                    'propagation_status_status':
                        (str,),
                    'propagation_status_pending_dscs':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_deployment_target': 'spec.deployment-target',
                    'spec_feature_set': 'spec.feature-set',
                    'interface_profile_num_pfs': 'interface-profile.num-pfs',
                    'interface_profile_num_vfs': 'interface-profile.num-vfs',
                    'spec_apply_policies_to_encapsulated_traffic': 'spec.apply-policies-to-encapsulated-traffic',
                    'propagation_status_generation_id': 'propagation-status.generation-id',
                    'propagation_status_updated': 'propagation-status.updated',
                    'propagation_status_pending': 'propagation-status.pending',
                    'propagation_status_min_version': 'propagation-status.min-version',
                    'propagation_status_status': 'propagation-status.status',
                    'propagation_status_pending_dscs': 'propagation-status.pending-dscs',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_deployment_target': 'query',
                    'spec_feature_set': 'query',
                    'interface_profile_num_pfs': 'query',
                    'interface_profile_num_vfs': 'query',
                    'spec_apply_policies_to_encapsulated_traffic': 'query',
                    'propagation_status_generation_id': 'query',
                    'propagation_status_updated': 'query',
                    'propagation_status_pending': 'query',
                    'propagation_status_min_version': 'query',
                    'propagation_status_status': 'query',
                    'propagation_status_pending_dscs': 'query',
                },
                'collection_format_map': {
                    'propagation_status_pending_dscs': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsc_profile
        )

        def __get_host(
            self,
            o_name,
            **kwargs
        ):
            """Get Host object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_host(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                status_admitted_dscs ([str]): AdmittedDSCs contains a list of admitted DistributedServiceCards that are on this host.. [optional]
                status_mirror_sessions ([str]): MirrorSessions list of mirror sessions enabled on this host.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterHost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_host = _Endpoint(
            settings={
                'response_type': (ClusterHost,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/hosts/{O.Name}',
                'operation_id': 'get_host',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'status_admitted_dscs',
                    'status_mirror_sessions',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'status_admitted_dscs':
                        ([str],),
                    'status_mirror_sessions':
                        ([str],),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'status_admitted_dscs': 'status.admitted-dscs',
                    'status_mirror_sessions': 'status.mirror-sessions',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'status_admitted_dscs': 'query',
                    'status_mirror_sessions': 'query',
                },
                'collection_format_map': {
                    'status_admitted_dscs': 'csv',
                    'status_mirror_sessions': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_host
        )

        def __get_license(
            self,
            **kwargs
        ):
            """Get License object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_license(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                status_unknown ([str]): Licenses that are not understood by the current running version of software.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterLicense
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_license = _Endpoint(
            settings={
                'response_type': (ClusterLicense,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/licenses',
                'operation_id': 'get_license',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'status_unknown',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'status_unknown':
                        ([str],),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'status_unknown': 'status.unknown',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'status_unknown': 'query',
                },
                'collection_format_map': {
                    'status_unknown': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_license
        )

        def __get_node(
            self,
            o_name,
            **kwargs
        ):
            """Get Node object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_node(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_routing_config (str): RoutingConfig the routing configuration.. [optional]
                status_phase (str): Current lifecycle phase of the node.. [optional]
                status_quorum (bool): Quorum node or not.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterNode
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_node = _Endpoint(
            settings={
                'response_type': (ClusterNode,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/nodes/{O.Name}',
                'operation_id': 'get_node',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_routing_config',
                    'status_phase',
                    'status_quorum',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_routing_config':
                        (str,),
                    'status_phase':
                        (str,),
                    'status_quorum':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_routing_config': 'spec.routing-config',
                    'status_phase': 'status.phase',
                    'status_quorum': 'status.quorum',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_routing_config': 'query',
                    'status_phase': 'query',
                    'status_quorum': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_node
        )

        def __get_snapshot_restore(
            self,
            **kwargs
        ):
            """Get SnapshotRestore object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_snapshot_restore(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_path (str): [optional]
                status_status (str): [optional]
                status_start_time (datetime): [optional]
                status_end_time (datetime): [optional]
                status_backup_snapshot_path (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterSnapshotRestore
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_snapshot_restore = _Endpoint(
            settings={
                'response_type': (ClusterSnapshotRestore,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-restore',
                'operation_id': 'get_snapshot_restore',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_path',
                    'status_status',
                    'status_start_time',
                    'status_end_time',
                    'status_backup_snapshot_path',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_path':
                        (str,),
                    'status_status':
                        (str,),
                    'status_start_time':
                        (datetime,),
                    'status_end_time':
                        (datetime,),
                    'status_backup_snapshot_path':
                        (str,),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_path': 'spec.path',
                    'status_status': 'status.status',
                    'status_start_time': 'status.start-time',
                    'status_end_time': 'status.end-time',
                    'status_backup_snapshot_path': 'status.backup-snapshot-path',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_path': 'query',
                    'status_status': 'query',
                    'status_start_time': 'query',
                    'status_end_time': 'query',
                    'status_backup_snapshot_path': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_snapshot_restore
        )

        def __get_tenant(
            self,
            o_name,
            **kwargs
        ):
            """Get Tenant object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tenant(o_name, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):

            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_admin_user (str): Tenant admin user.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterTenant
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            return self.call_with_http_info(**kwargs)

        self.get_tenant = _Endpoint(
            settings={
                'response_type': (ClusterTenant,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/tenants/{O.Name}',
                'operation_id': 'get_tenant',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    't_kind',
                    't_api_version',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_admin_user',
                ],
                'required': [
                    'o_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_admin_user':
                        (str,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_admin_user': 'spec.admin-user',
                },
                'location_map': {
                    'o_name': 'path',
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_admin_user': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tenant
        )

        def __get_version(
            self,
            **kwargs
        ):
            """Get Version object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_version(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                t_kind (str): Kind represents the type of the API object.. [optional]
                t_api_version (str): APIVersion defines the version of the API object. This can only be set by the server.. [optional]
                meta_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                meta_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                meta_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                meta_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                meta_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                meta_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                meta_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                meta_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                spec_auto_rollout_dsc_version (str): AutoRolloutDSCVersion indicates the version DSCs will be automatically upgraded upon admission. Empty value indicates no auto-rollout.. [optional]
                status_build_version (str): Human friendly build version.. [optional]
                status_vcs_commit (str): Representation of ommit in version control system - e.g: hash in git.. [optional]
                status_build_date (str): Date and Time at which the source code was built.. [optional]
                status_rollout_build_version (str): RolloutBuildVersion shows in progress rollout version.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_version = _Endpoint(
            settings={
                'response_type': (ClusterVersion,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/version',
                'operation_id': 'get_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    't_kind',
                    't_api_version',
                    'meta_name',
                    'meta_tenant',
                    'meta_namespace',
                    'meta_generation_id',
                    'meta_resource_version',
                    'meta_uuid',
                    'meta_creation_time',
                    'meta_mod_time',
                    'meta_self_link',
                    'spec_auto_rollout_dsc_version',
                    'status_build_version',
                    'status_vcs_commit',
                    'status_build_date',
                    'status_rollout_build_version',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    't_kind':
                        (str,),
                    't_api_version':
                        (str,),
                    'meta_name':
                        (str,),
                    'meta_tenant':
                        (str,),
                    'meta_namespace':
                        (str,),
                    'meta_generation_id':
                        (str,),
                    'meta_resource_version':
                        (str,),
                    'meta_uuid':
                        (str,),
                    'meta_creation_time':
                        (datetime,),
                    'meta_mod_time':
                        (datetime,),
                    'meta_self_link':
                        (str,),
                    'spec_auto_rollout_dsc_version':
                        (str,),
                    'status_build_version':
                        (str,),
                    'status_vcs_commit':
                        (str,),
                    'status_build_date':
                        (str,),
                    'status_rollout_build_version':
                        (str,),
                },
                'attribute_map': {
                    't_kind': 'T.kind',
                    't_api_version': 'T.api-version',
                    'meta_name': 'meta.name',
                    'meta_tenant': 'meta.tenant',
                    'meta_namespace': 'meta.namespace',
                    'meta_generation_id': 'meta.generation-id',
                    'meta_resource_version': 'meta.resource-version',
                    'meta_uuid': 'meta.uuid',
                    'meta_creation_time': 'meta.creation-time',
                    'meta_mod_time': 'meta.mod-time',
                    'meta_self_link': 'meta.self-link',
                    'spec_auto_rollout_dsc_version': 'spec.auto-rollout-dsc-version',
                    'status_build_version': 'status.build-version',
                    'status_vcs_commit': 'status.vcs-commit',
                    'status_build_date': 'status.build-date',
                    'status_rollout_build_version': 'status.rollout-build-version',
                },
                'location_map': {
                    't_kind': 'query',
                    't_api_version': 'query',
                    'meta_name': 'query',
                    'meta_tenant': 'query',
                    'meta_namespace': 'query',
                    'meta_generation_id': 'query',
                    'meta_resource_version': 'query',
                    'meta_uuid': 'query',
                    'meta_creation_time': 'query',
                    'meta_mod_time': 'query',
                    'meta_self_link': 'query',
                    'spec_auto_rollout_dsc_version': 'query',
                    'status_build_version': 'query',
                    'status_vcs_commit': 'query',
                    'status_build_date': 'query',
                    'status_rollout_build_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_version
        )

        def __label_cluster(
            self,
            body,
            **kwargs
        ):
            """Label Cluster object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_cluster(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_cluster = _Endpoint(
            settings={
                'response_type': (ClusterCluster,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/cluster/label',
                'operation_id': 'label_cluster',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_cluster
        )

        def __label_cluster_profile(
            self,
            body,
            **kwargs
        ):
            """Label ClusterProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_cluster_profile(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterClusterProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_cluster_profile = _Endpoint(
            settings={
                'response_type': (ClusterClusterProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/clusterprofile/label',
                'operation_id': 'label_cluster_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_cluster_profile
        )

        def __label_configuration_snapshot(
            self,
            body,
            **kwargs
        ):
            """Label ConfigurationSnapshot object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_configuration_snapshot(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterConfigurationSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_configuration_snapshot = _Endpoint(
            settings={
                'response_type': (ClusterConfigurationSnapshot,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-snapshot/label',
                'operation_id': 'label_configuration_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_configuration_snapshot
        )

        def __label_distributed_service_card(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label DistributedServiceCard object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_distributed_service_card(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDistributedServiceCard
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_distributed_service_card = _Endpoint(
            settings={
                'response_type': (ClusterDistributedServiceCard,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/distributedservicecards/{O.Name}/label',
                'operation_id': 'label_distributed_service_card',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_distributed_service_card
        )

        def __label_dsc_profile(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label DSCProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_dsc_profile(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDSCProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterDSCProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/dscprofiles/{O.Name}/label',
                'operation_id': 'label_dsc_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_dsc_profile
        )

        def __label_host(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label Host object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_host(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterHost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_host = _Endpoint(
            settings={
                'response_type': (ClusterHost,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/hosts/{O.Name}/label',
                'operation_id': 'label_host',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_host
        )

        def __label_license(
            self,
            body,
            **kwargs
        ):
            """Label License object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_license(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterLicense
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_license = _Endpoint(
            settings={
                'response_type': (ClusterLicense,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/licenses/label',
                'operation_id': 'label_license',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_license
        )

        def __label_node(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label Node object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_node(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterNode
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_node = _Endpoint(
            settings={
                'response_type': (ClusterNode,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/nodes/{O.Name}/label',
                'operation_id': 'label_node',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_node
        )

        def __label_tenant(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Label Tenant object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.label_tenant(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ApiLabel):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterTenant
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.label_tenant = _Endpoint(
            settings={
                'response_type': (ClusterTenant,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/tenants/{O.Name}/label',
                'operation_id': 'label_tenant',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ApiLabel,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__label_tenant
        )

        def __list_distributed_service_card(
            self,
            **kwargs
        ):
            """List DistributedServiceCard objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_distributed_service_card(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDistributedServiceCardList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_distributed_service_card = _Endpoint(
            settings={
                'response_type': (ClusterDistributedServiceCardList,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/distributedservicecards',
                'operation_id': 'list_distributed_service_card',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_distributed_service_card
        )

        def __list_dsc_profile(
            self,
            **kwargs
        ):
            """List DSCProfile objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_dsc_profile(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDSCProfileList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterDSCProfileList,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/dscprofiles',
                'operation_id': 'list_dsc_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_dsc_profile
        )

        def __list_host(
            self,
            **kwargs
        ):
            """List Host objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_host(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterHostList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_host = _Endpoint(
            settings={
                'response_type': (ClusterHostList,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/hosts',
                'operation_id': 'list_host',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_host
        )

        def __list_node(
            self,
            **kwargs
        ):
            """List Node objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_node(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterNodeList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_node = _Endpoint(
            settings={
                'response_type': (ClusterNodeList,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/nodes',
                'operation_id': 'list_node',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_node
        )

        def __list_tenant(
            self,
            **kwargs
        ):
            """List Tenant objects  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_tenant(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterTenantList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_tenant = _Endpoint(
            settings={
                'response_type': (ClusterTenantList,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/tenants',
                'operation_id': 'list_tenant',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_tenant
        )

        def __restore(
            self,
            body,
            **kwargs
        ):
            """Restore Configuration  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.restore(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterSnapshotRestore):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterSnapshotRestore
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.restore = _Endpoint(
            settings={
                'response_type': (ClusterSnapshotRestore,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-restore/restore',
                'operation_id': 'restore',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterSnapshotRestore,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__restore
        )

        def __save(
            self,
            body,
            **kwargs
        ):
            """Perform a Configuation Snapshot  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.save(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterConfigurationSnapshotRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterConfigurationSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.save = _Endpoint(
            settings={
                'response_type': (ClusterConfigurationSnapshot,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-snapshot/save',
                'operation_id': 'save',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterConfigurationSnapshotRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__save
        )

        def __update_cluster(
            self,
            body,
            **kwargs
        ):
            """Update Cluster object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_cluster(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterCluster):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_cluster = _Endpoint(
            settings={
                'response_type': (ClusterCluster,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/cluster',
                'operation_id': 'update_cluster',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterCluster,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_cluster
        )

        def __update_cluster_profile(
            self,
            body,
            **kwargs
        ):
            """Update ClusterProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_cluster_profile(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterClusterProfile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterClusterProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_cluster_profile = _Endpoint(
            settings={
                'response_type': (ClusterClusterProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/clusterprofile',
                'operation_id': 'update_cluster_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterClusterProfile,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_cluster_profile
        )

        def __update_configuration_snapshot(
            self,
            body,
            **kwargs
        ):
            """Update ConfigurationSnapshot object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_configuration_snapshot(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterConfigurationSnapshot):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterConfigurationSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_configuration_snapshot = _Endpoint(
            settings={
                'response_type': (ClusterConfigurationSnapshot,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/config-snapshot',
                'operation_id': 'update_configuration_snapshot',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterConfigurationSnapshot,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_configuration_snapshot
        )

        def __update_distributed_service_card(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update DistributedServiceCard object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_distributed_service_card(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ClusterDistributedServiceCard):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDistributedServiceCard
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_distributed_service_card = _Endpoint(
            settings={
                'response_type': (ClusterDistributedServiceCard,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/distributedservicecards/{O.Name}',
                'operation_id': 'update_distributed_service_card',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ClusterDistributedServiceCard,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_distributed_service_card
        )

        def __update_dsc_profile(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update DSCProfile object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_dsc_profile(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ClusterDSCProfile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterDSCProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterDSCProfile,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/dscprofiles/{O.Name}',
                'operation_id': 'update_dsc_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ClusterDSCProfile,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_dsc_profile
        )

        def __update_host(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update Host object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_host(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ClusterHost):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterHost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_host = _Endpoint(
            settings={
                'response_type': (ClusterHost,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/hosts/{O.Name}',
                'operation_id': 'update_host',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ClusterHost,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_host
        )

        def __update_license(
            self,
            body,
            **kwargs
        ):
            """Update License object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_license(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterLicense):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterLicense
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_license = _Endpoint(
            settings={
                'response_type': (ClusterLicense,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/licenses',
                'operation_id': 'update_license',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterLicense,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_license
        )

        def __update_node(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update Node object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_node(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ClusterNode):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterNode
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_node = _Endpoint(
            settings={
                'response_type': (ClusterNode,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/nodes/{O.Name}',
                'operation_id': 'update_node',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ClusterNode,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_node
        )

        def __update_tenant(
            self,
            o_name,
            body,
            **kwargs
        ):
            """Update Tenant object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_tenant(o_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                o_name (str):
                body (ClusterTenant):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterTenant
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['o_name'] = \
                o_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_tenant = _Endpoint(
            settings={
                'response_type': (ClusterTenant,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/tenants/{O.Name}',
                'operation_id': 'update_tenant',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'body',
                ],
                'required': [
                    'o_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'body':
                        (ClusterTenant,),
                },
                'attribute_map': {
                    'o_name': 'O.Name',
                },
                'location_map': {
                    'o_name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_tenant
        )

        def __update_tls_config(
            self,
            body,
            **kwargs
        ):
            """Update TLS Configuration for cluster  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_tls_config(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterUpdateTLSConfigRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_tls_config = _Endpoint(
            settings={
                'response_type': (ClusterCluster,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/cluster/UpdateTLSConfig',
                'operation_id': 'update_tls_config',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterUpdateTLSConfigRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_tls_config
        )

        def __update_version(
            self,
            body,
            **kwargs
        ):
            """Update Version object  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_version(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (ClusterVersion):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_version = _Endpoint(
            settings={
                'response_type': (ClusterVersion,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/version',
                'operation_id': 'update_version',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (ClusterVersion,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_version
        )

        def __watch_cluster(
            self,
            **kwargs
        ):
            """Watch Cluster objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_cluster(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgClusterWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_cluster = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgClusterWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/cluster',
                'operation_id': 'watch_cluster',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_cluster
        )

        def __watch_cluster_profile(
            self,
            **kwargs
        ):
            """Watch ClusterProfile objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_cluster_profile(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgClusterProfileWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_cluster_profile = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgClusterProfileWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/clusterprofile',
                'operation_id': 'watch_cluster_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_cluster_profile
        )

        def __watch_configuration_snapshot(
            self,
            **kwargs
        ):
            """Watch ConfigurationSnapshot objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_configuration_snapshot(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgConfigurationSnapshotWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_configuration_snapshot = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgConfigurationSnapshotWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/config-snapshot',
                'operation_id': 'watch_configuration_snapshot',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_configuration_snapshot
        )

        def __watch_distributed_service_card(
            self,
            **kwargs
        ):
            """Watch DistributedServiceCard objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_distributed_service_card(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgDistributedServiceCardWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_distributed_service_card = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgDistributedServiceCardWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/distributedservicecards',
                'operation_id': 'watch_distributed_service_card',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_distributed_service_card
        )

        def __watch_dsc_profile(
            self,
            **kwargs
        ):
            """Watch DSCProfile objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_dsc_profile(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgDSCProfileWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_dsc_profile = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgDSCProfileWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/dscprofiles',
                'operation_id': 'watch_dsc_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_dsc_profile
        )

        def __watch_host(
            self,
            **kwargs
        ):
            """Watch Host objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_host(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgHostWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_host = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgHostWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/hosts',
                'operation_id': 'watch_host',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_host
        )

        def __watch_node(
            self,
            **kwargs
        ):
            """Watch Node objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_node(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgNodeWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_node = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgNodeWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/nodes',
                'operation_id': 'watch_node',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_node
        )

        def __watch_tenant(
            self,
            **kwargs
        ):
            """Watch Tenant objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_tenant(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgTenantWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_tenant = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgTenantWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/tenants',
                'operation_id': 'watch_tenant',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_tenant
        )

        def __watch_version(
            self,
            **kwargs
        ):
            """Watch Version objects. Supports WebSockets or HTTP long poll  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.watch_version(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                o_name (str): Name of the object, unique within a Namespace for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_tenant (str): Tenant to which the object belongs to. This can be automatically filled in many cases based on the tenant the user, who created the object, belongs to. Must be alpha-numerics. Length of string should be between 1 and 48.. [optional]
                o_namespace (str): Namespace of the object, for scoped objects. Must start and end with alpha numeric and can have alphanumeric, -, _, . Length of string should be between 2 and 64.. [optional]
                o_generation_id (str): GenerationID is the generation Id for the object. This is incremented anytime there is an update to the user intent, including Spec update and any update to ObjectMeta. System generated and updated, not updatable by user.. [optional]
                o_resource_version (str): Resource version in the object store. This is updated anytime there is any change to the object. System generated and updated, not updatable by user.. [optional]
                o_uuid (str): UUID is the unique identifier for the object. This is generated on creation of the object. System generated, not updatable by user.. [optional]
                o_creation_time (datetime): CreationTime is the creation time of the object. System generated and updated, not updatable by user.. [optional]
                o_mod_time (datetime): ModTime is the Last Modification time of the object. System generated and updated, not updatable by user.. [optional]
                o_self_link (str): SelfLink is a link for accessing this object. When the object is served from the API-GW it is the URI path. Example: - \"/v1/tenants/tenants/tenant2\" System generated and updated, not updatable by user.. [optional]
                label_selector (str): LabelSelector to select on labels in list or watch results.. [optional]
                field_selector (str): FieldSelector to select on field values in list or watch results.. [optional]
                field_change_selector ([str]): FieldChangeSelector specifies to generate a watch notification on change in field(s) specified.. [optional]
                _from (int): From represents the start index number (1 based - first object starts from index 1), of the results list. The results returned would be in the range [from ... (from + (max-results - 1))]. If From = 0, the server will attempt to return all the results in the list without pagination.. [optional]
                max_results (int): MaxResults is the maximum number of results to be returned as part of the response, per page If MaxResults is more than the maximum number of results per page supported by the server, the server will return an err If MaxResults is 0, the server will return all the results without pagination.. [optional]
                sort_order (str): order to sort List results in.. [optional]
                meta_only (bool): If MetaOnly is set to true, the watch event notification that matches the watch criteria will not contain the full object. It will only contain the information about the object that changed, i.e. which object and what changed. MetaOnly is not set by default.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ClusterAutoMsgVersionWatchHelper
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.watch_version = _Endpoint(
            settings={
                'response_type': (ClusterAutoMsgVersionWatchHelper,),
                'auth': [],
                'endpoint_path': '/configs/cluster/v1/watch/version',
                'operation_id': 'watch_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'o_name',
                    'o_tenant',
                    'o_namespace',
                    'o_generation_id',
                    'o_resource_version',
                    'o_uuid',
                    'o_creation_time',
                    'o_mod_time',
                    'o_self_link',
                    'label_selector',
                    'field_selector',
                    'field_change_selector',
                    '_from',
                    'max_results',
                    'sort_order',
                    'meta_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'o_name':
                        (str,),
                    'o_tenant':
                        (str,),
                    'o_namespace':
                        (str,),
                    'o_generation_id':
                        (str,),
                    'o_resource_version':
                        (str,),
                    'o_uuid':
                        (str,),
                    'o_creation_time':
                        (datetime,),
                    'o_mod_time':
                        (datetime,),
                    'o_self_link':
                        (str,),
                    'label_selector':
                        (str,),
                    'field_selector':
                        (str,),
                    'field_change_selector':
                        ([str],),
                    '_from':
                        (int,),
                    'max_results':
                        (int,),
                    'sort_order':
                        (str,),
                    'meta_only':
                        (bool,),
                },
                'attribute_map': {
                    'o_name': 'O.name',
                    'o_tenant': 'O.tenant',
                    'o_namespace': 'O.namespace',
                    'o_generation_id': 'O.generation-id',
                    'o_resource_version': 'O.resource-version',
                    'o_uuid': 'O.uuid',
                    'o_creation_time': 'O.creation-time',
                    'o_mod_time': 'O.mod-time',
                    'o_self_link': 'O.self-link',
                    'label_selector': 'label-selector',
                    'field_selector': 'field-selector',
                    'field_change_selector': 'field-change-selector',
                    '_from': 'from',
                    'max_results': 'max-results',
                    'sort_order': 'sort-order',
                    'meta_only': 'meta-only',
                },
                'location_map': {
                    'o_name': 'query',
                    'o_tenant': 'query',
                    'o_namespace': 'query',
                    'o_generation_id': 'query',
                    'o_resource_version': 'query',
                    'o_uuid': 'query',
                    'o_creation_time': 'query',
                    'o_mod_time': 'query',
                    'o_self_link': 'query',
                    'label_selector': 'query',
                    'field_selector': 'query',
                    'field_change_selector': 'query',
                    '_from': 'query',
                    'max_results': 'query',
                    'sort_order': 'query',
                    'meta_only': 'query',
                },
                'collection_format_map': {
                    'field_change_selector': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__watch_version
        )
