---
authors:
  MerlinDumeur: "[Merlin Dumeur](https://github.com/MerlinDumeur)"
  agramfort: "[Alex Gramfort](https://github.com/agramfort)"
  hoechenberger: "[Richard Höchenberger](https://github.com/hoechenberger)"
  guiomar: "[Julia Guiomar Niso Galán](https://github.com/guiomar)"
  robluke: "[Robert Luke](https://github.com/rob-luke)"
  crsegerie: "[Charbel-Raphaël Segerie](https://github.com/crsegerie)"
  dengemann: "[Denis A. Engemann](https://github.com/dengemann)"
  apmellot: "[Apolline Mellot](https://github.com/apmellot)"
  mathiassm: "[Mathias Sablé-Meyer](https://github.com/mathias-sm)"
  larsoner: "[Eric Larson](https://github.com/larsoner)"
---


## Changes since April 15, 2021

### New features & enhancements

- An official [project governance](governance.md) structure has officially
  been adopted.
- The peak-to-peak (PTP) amplitude rejection thresholds for epochs can now
  optionally be determined automatically using
  [`autoreject`](https://autoreject.github.io) by setting the
  [`reject`][mne_bids_pipeline._config.reject] parameter to `'autoreject_global'`.
  ({{ gh(306) }} by {{ authors.agramfort }} and {{ authors.hoechenberger }})
- The new configuration option [`ica_reject`][mne_bids_pipeline._config.ica_reject] allows to
  exclude epochs from the ICA fit based on peak-to-peak (PTP) amplitude.
  ({{ gh(302) }} by {{ authors.hoechenberger }})
- Drastically reduces memory usage when creating epochs from datasets with
  multiple runs.
  ({{ gh(355) }} by {{ authors.hoechenberger }})
- Add time-frequency plot to report.
  ({{ gh(367) }} by {{ authors.robluke }})
- Add possibility to exclude runs from the analysis via the new
  [`exclude_runs`][mne_bids_pipeline._config.exclude_runs] setting.
  ({{ gh(370) }} by {{ authors.crsegerie }})
- Add possibility to process resting-state data via
  [`rest_epochs_duration`][mne_bids_pipeline._config.rest_epochs_duration] and
  [`rest_epochs_overlap`][mne_bids_pipeline._config.rest_epochs_overlap].
  ({{ gh(393) }} by {{ authors.apmellot}}, {{ authors.dengemann }},
   {{ authors.agramfort }}, and {{ authors.hoechenberger }})
- We now create high-resolution scalp surfaces for visualization of the
  coregistration in the reports. Existing surfaces can be force-regenerated by
  setting the new [`recreate_scalp_surface`][mne_bids_pipeline._config.recreate_scalp_surface]
  to `True`.
  ({{ gh(378) }} by {{ authors.hoechenberger }})
- When not applying Maxwell-filter (i.e., when
  [`use_maxwell_filter`][mne_bids_pipeline._config.use_maxwell_filter] is set to `False`, e.g.
  when processing EEG data), we skip the initial data import that would
  essentially just copy the input data to the derivatives root without doing
  any processing. Now, in such situations, the Maxwell-filtering step is
  skipped entirely, and we start with frequency filtering right away. This
  speeds up processing by avoiding unnecessary disk I/O and can help preserve
  large quantities of storage space for big datasets.
  ({{ gh(378) }} by {{ authors.dengemann }} and {{ authors.hoechenberger }})
- Break periods in the continuous data can now be automatically detected and
  annotated as "bad" segments, which will be ignored during subsequent
  processing. This feature is disabled by default and can be switched on via
  the [`find_breaks`][mne_bids_pipeline._config.find_breaks] setting.
  ({{ gh(386) }} by {{ authors.hoechenberger }})
- You can now use the FreeSurfer `fsaverage` template MRI for source estimation
  in cases where you don't have participant-specific MR scans available, as is
  often the case in EEG studies. The behavior can be enabled using the new
  configuration option [`use_template_mri`][mne_bids_pipeline._config.use_template_mri].
  ({{ gh(387), gh(526) }} by {{ authors.agramfort }} and {{ authors.hoechenberger }})
- You can now specify rejection parameters and the number of projection
  vectors per channel type for SSP via
  [`n_proj_eog`][mne_bids_pipeline._config.n_proj_eog], [`n_proj_ecg`][mne_bids_pipeline._config.n_proj_ecg],
  [`ssp_reject_eog`][mne_bids_pipeline._config.ssp_reject_eog] and
  [`ssp_reject_ecg`][mne_bids_pipeline._config.ssp_reject_ecg].
  ({{ gh(392) }} by {{ authors.agramfort }}, {{ authors.dengemann }},
   {{ authors.apmellot }} and {{ authors.hoechenberger }})
- You can now use autoreject for exclusing artifacts before SSP estimation via
  the `autoreject_global` option in [`ssp_reject_eog`][mne_bids_pipeline._config.ssp_reject_eog]
  and [`ssp_reject_ecg`][mne_bids_pipeline._config.ssp_reject_ecg].
  ({{ gh(396) }} by {{ authors.agramfort }}, {{ authors.dengemann }},
   {{ authors.apmellot }} and {{ authors.hoechenberger }})
- You can now specify a custom
  [`eeg_template_montage`][mne_bids_pipeline._config.eeg_template_montage] from any
  `mne.channels.montage.DigMontage` object.
  ({{ gh(407) }} by {{ authors.dengemann }}, {{ authors.hoechenberger }} and
   {{ authors.agramfort }})
- Certain BIDS file system operations are now being cached, which should
  significantly reduce start-up times in situations where many participants
  are being processed with data from a network-attached storage (NAS).
  ({{ gh(405) }} by {{ authors.agramfort}} and {{ authors.hoechenberger }})
- Files docstrings in the preprocessing steps were updated.
  ({{ gh(409) }} by {{ authors.crsegerie }})
- Do not crash when concatenating epochs or raws with different measurement
  info (like the dev_head_t when using EEG only data).
  ({{ gh(416) }} by {{ authors.agramfort }})
- The ``run.py`` command line interface gained a new parameter ``--n_jobs`` to
  specify the number of processes to run in parallel.
  ({{ gh(417) }} by {{ authors.hoechenberger }})
- Great improvements to our logging system produce more readable output on the
  terminal. We also generate an Excel file containing useful debugging info
  for all participants at each processing step to help you spot problematic
  participants more easily.
  ({{ gh(429), gh(441) }} by {{ authors.agramfort }} {{ authors.hoechenberger }})
- It is now possible to specify from which file to load the `mne.Info` object
  during forward and inverse computation via
  [`source_info_path_update`][mne_bids_pipeline._config.source_info_path_update].
  ({{ gh(452) }} by {{ authors.apmellot }})
- The `run.py` command line interface gained a new parameter, `--interactive`,
  allowing you to override the interactive mode setting from the configuration
  file.
  ({{ gh(456), gh(457) }} by {{ authors.hoechenberger }})
- Add a new configuration setting [`freesurfer_verbose`][mne_bids_pipeline._config.freesurfer_verbose]
  to control whether to display of FreeSurfer output.
  ({{ gh(459) }} by {{ authors.hoechenberger }})
- The [`noise_cov`][mne_bids_pipeline._config.noise_cov] option can now be set to `ad-hoc` to use
  a fixed and data-independent diagonal noise covariance matrix for source
  imaging.
  ({{ gh(460) }} by {{ authors.agramfort }} and  {{ authors.apmellot }})
- Processing can now be parallelized using [Dask](https://dask.org). To use
  Dask, set the new configuration setting [`parallel_backend`][mne_bids_pipeline._config.parallel_backend]
  to `'dask'`.
  ({{ gh(472) }} by {{ authors.agramfort }} and  {{ authors.hoechenberger }})
- Drastically reduce memory usage during the epoching and ICA steps.
  ({{ gh(477) }} by {{ authors.hoechenberger }} and {{ authors.agramfort }})
- The new [`plot_psd_for_runs`][mne_bids_pipeline._config.plot_psd_for_runs] setting can be used
  to control for which runs to add PSD plots of the raw data to the reports.
  ({{ gh(482) }} by {{ authors.hoechenberger }})
- Speed up report generation.
  ({{ gh(487) }} by {{ authors.hoechenberger }})
- The new [`epochs_metadata_query][mne_bids_pipeline._config.epochs_metadata_query] setting
  allows to select epochs based on metadata query strings.
  ({{ gh(495) }} by {{ authors.hoechenberger }} and {{ authors.agramfort }})
- The new [`time_frequency_cycles`][mne_bids_pipeline._config.time_frequency_cycles] setting
  allows for customization of the number of Morlet wavelet cycles used in
  time-frequency analysis.
  ({{ gh(516) }} by {{ authors.hoechenberger }})
- To analyze induced (as opposed to evoked) activity in the time-frequency
  domain, the new setting
  [`time_frequency_subtract_evoked`][mne_bids_pipeline._config.time_frequency_subtract_evoked]
  has been added, allowing to subtract the evoked signal from the epochs
  before performing time-frequency analysis.
  ({{ gh(516) }} by {{ authors.hoechenberger }})
- The covariance matrix and corresponding SVD figures, as well as whitened
  evoked data plots are now added to the reports.
  ({{ gh(532) }} by {{ authors.hoechenberger }})
- The [`noise_cov`][mne_bids_pipeline._config.noise_cov] option can now be set to a function to
  allow working with arbitrarily-generated covariance matrices.
  ({{ gh(535) }} by {{ authors.hoechenberger }} and {{ authors.agramfort }}
- Arbitrary contrasts can be used in [`contrasts`][mne_bids_pipeline._config.contrasts]. The list
  now accepts as valid items, in addition to tuples which kept their behavior,
  dicts specifying a name, a condition list and a weights list to use to
  `combine_evoked`. Decoding steps ignores contrasts with more than two
  elements.
  ({{ gh(536) }} by {{ authors.mathiassm }})
- The pipeline configuration and MNE system information are now automatically
  added to the report.
  ({{ gh(544) }} by {{ authors.hoechenberger }})
- More robust empty-room data processing for use with Maxwell filter. We are
  now relying on `mne.preprocessing.maxwell_filter_prepare_emptyroom`.
  ({{ gh(550) }} by {{ authors.hoechenberger }})
- Maxwell filtering now also parallelizes across runs (previously only across
  subjects and sessions).
  ({{ gh(550) }} by {{ authors.hoechenberger }})
- It is now possible to estimate the noise covariance matrix based on a
  resting-state recording and use it for inverse modeling, just like one could
  previously do with empty-room recordings.
  ({{ gh(554) }} by {{ authors.hoechenberger }})
- Added full-epochs decoding.
  ({{ gh(558) }} by {{ authors.hoechenberger }})
- Generalization across time can now be enabled for the time-by-time decoding
  scheme via the new configuration option
  [`decoding_time_generalization`][mne_bids_pipeline._config.decoding_time_generalization].
  ({{ gh(559) }} by {{ authors.hoechenberger }})
- Generalization across time additional decimation can be configured using
  [`decoding_time_generalization_decim`][mne_bids_pipeline._config.decoding_time_generalization_decim].
  ({{ gh(603) }} by {{ authors.larsoner }})
- Caching of pipeline enabled for many pipeline steps
  by default using [`memory_location=True'`][mne_bids_pipeline._config.memory_location]
  ({{ gh(563) }}, {{ gh (600) }}, {{ gh(608) }}, {{ gh(615) }}, {{ gh(618) }},
  {{ gh(644) }}
  by {{ authors.agramfort }} and {{ authors.larsoner }})
- Basic testing of infant MEG data with movement was added to CI testing
  ({{ gh(582) }} by {{ authors.larsoner }})
- The `loose` and `depth` configuration parameters were re-enabled
  ({{ gh(592) }}) by {{ authors.larsoner }}
- Add the example [MIND DATA dataset (ds004107)](https://openneuro.org/datasets/ds004107)
  (({{ gh(600) }}) by {{ authors.larsoner }})
- Simultaneous MEG+EEG can now be processed jointly
  ({{ gh(606) }} by {{ authors.larsoner }})
- Spatial filtering using SSP is now supported for EEG data
  ({{ gh(606) }} by {{ authors.larsoner }})
- Add SSP joint plots to generated reports
- ({{ gh(614) }} by {{ authors.larsoner }})
- It is now possible to specify baseline and cropping parameters for
  plotting time-frequency results via
  [`time_frequency_baseline`][mne_bids_pipeline._config.time_frequency_baseline],
  [`time_frequency_baseline_mode`][mne_bids_pipeline._config.time_frequency_baseline_mode]
  and [`time_frequency_crop`][mne_bids_pipeline._config.time_frequency_crop].
  ({{ gh(641) }} by {{ authors.agramfort }})
- Add time-frequency decoding based on [common spatial patterns](https://mne.tools/stable/auto_examples/decoding/decoding_csp_timefreq.html)
  (CSP).
  ({{ gh(625) }} by {{ authors.crsegerie }}, {{ authors.agramfort }},
  {{ authors.hoechenberger }}, and {{ authors.larsoner }})
- Add progress bar for time-by-time decoding
  ({{ gh(647) }} by {{ authors.larsoner }})
- A template configuration file can now be created via `mne_bids_pipeline --create-config`
  ({{ gh(653) }} by {{ authors.hoechenberger }})
- Make report generation happen within relevant steps instead of at the end
  of all steps
  ({{ gh(652) }} by {{ authors.larsoner }})
- Initial raw data plots are now added to reports and bad channel detection
  is executed in a dedicated step
  ({{ gh(666) }} by {{ authors.larsoner }})

### Behavior changes

- The [`conditions`][mne_bids_pipeline._config.conditions] setting will now be `None` by default.
  It is a required setting so it will raise an error if left as `None`.
  ({{ gh(348) }} by {{ authors.guiomar }} and {{ authors.hoechenberger }})
- When creating epochs, only those epochs are kept that belong to the specified
  [`conditions`][mne_bids_pipeline._config.conditions]. This means that only this subset of epochs
  will be passed to ICA and SSP (if used). Previously, we would created epochs
  based on all events found in the data, and only subset them to the requested
  conditions at the epoching stage.
  ({{ gh(449) }} by {{ authors.agramfort }})
- Epochs rejection based on peak-to-peak amplitude, as controlled via the
  [`reject`][mne_bids_pipeline._config.reject] setting, will now take place **after** ICA or SSP.
  In previous versions of the Pipeline, rejection was carried out before ICA
  and SSP. To exclude epochs from ICA fitting, use the new
  [`ica_reject`][mne_bids_pipeline._config.ica_reject] setting.
- We don't apply SSP by default anymore.
  ({{ gh(315) }} by {{ authors.hoechenberger }})
- The `use_ssp` and `use_ica` settings have been removed. Please use the new
  [`spatial_filter`][mne_bids_pipeline._config.spatial_filter] setting instead.
  ({{ gh(315) }} by {{ authors.hoechenberger }})
- The `allow_maxshield` setting has been removed. The Pipeline now
  automatically ensures that FIFF files of recordings with active
  shielding (MaxShield) can be imported. Later stages of the Pipeline will fail
  if Maxwell filtering of such data is disabled via `use_maxwell_filter=False`.
  ({{ gh(318) }} by {{ authors.hoechenberger }})
- The overlay plots that show the effects of ICA cleaning are now based on the
  baseline-corrected data to make it easier to spot the differences.
  ({{ gh(320) }} by {{ authors.hoechenberger }})
- `bids_root` and `deriv_root` are now converted to absolute paths to avoid
  running into issues caused by relative path specifications.
  ({{ gh(322) }} by {{ authors.hoechenberger }})
- Warn if using ICA and no EOG- or ECG-related ICs were detected.
  ({{ gh(351) }} by {{ authors.crsegerie }})
- Added the possibility to have different runs for different subjects.
  ({{ gh(353) }} by {{ authors.crsegerie }}))
- Check that the baseline interval falls into `[epochs_tmin, epochs_tmax]`.
  ({{ gh(361) }} by {{ authors.crsegerie }})
- `config.crop` has been renamed to the more explicit
  [`config.crop_runs`][mne_bids_pipeline._config.crop_runs], as it only applies to individual
  runs and not the concatenated data.
  ({{ gh(358) }} by {{ authors.hoechenberger }})
- [`ica_reject`][mne_bids_pipeline._config.ica_reject] now also applies to ECG and EOG epochs.
  ({{ gh(373) }} by {{ authors.crsegerie }})
- Added a new step `freesurfer/coreg_surfaces` that creates the scalp surfaces
  required for coregistration in MNE-Python.
  ({{ gh(422) }} by {{ authors.hoechenberger }})
- Enabling interactive mode by setting [`interactive`][mne_bids_pipeline._config.interactive] to
  `True` now deactivates parallel processing.
  ({{ gh(473) }} by {{ authors.hoechenberger }})
- The resolution of the MRI slices for BEM visualalization has been reduced to
  256 by 256 pixels (was 512 by 512 before), we now only plot every 8th slice
  (was ever 2nd before). This greatly speeds up BEM rendering and reduces the
  size of the generated report, while maintaining a sufficiently detailed
  visualization.
  ({{ gh(488) }} by {{ authors.hoechenberger }})
- In [`interactive`][mne_bids_pipeline._config.interactive] mode, the Matplotlib `Agg` backend
  will be used.
  ({{ gh(497) }} by {{ authors.hoechenberger }})
- We added new configuration options to control the number of time points to
  use when creating topographic maps of evoked signals and brain plots for
  source estimates:
  [`report_evoked_n_time_points`][mne_bids_pipeline._config.report_evoked_n_time_points] and
  [`report_stc_n_time_points`][mne_bids_pipeline._config.report_stc_n_time_points], respectively.
  ({{ gh(542) }} by {{ authors.agramfort }})
- Add [`reader_extra_params`][mne_bids_pipeline._config.reader_extra_params] parameter to pass
  parameters to read_raw_bids.
  ({{ gh(585) }} by {{ authors.agramfort }})
- Add [`task_is_rest`][mne_bids_pipeline._config.task_is_rest] parameter to be explicit that
  the data must be analyzed as resting state.
  ({{ gh(585) }} by {{ authors.agramfort }})
- Patch information is now incorporated when computing surface source spaces,
  which should slightly improve the surface normals
  ({{ gh(588) }} by {{ authors.larsoner }})
- Add [`ssp_meg`][mne_bids_pipeline._config.ssp_meg] option for MEG SSP computation. This
  defaults to `'auto'`, which will use `ssp_meg='combined'` for SSP computation
  when Maxwell filtering is used.
  ({{ gh(595) }} by {{ authors.larsoner }})
- Empty-room and resting-state data are processed by default if present,
  regardless of [`config.noise_cov`][mne_bids_pipeline._config.noise_cov] value.
  This can be controlled by changing the default values from
  [`config.process_empty_room = True`][mne_bids_pipeline._config.process_empty_room] and
  [`config.process_rest = True`][mne_bids_pipeline._config.process_rest]
  ({{ gh(633) }} by {{ authors.larsoner }})
- Environment variables are no longer used to control execution and variables,
  use command-line switches instead
  ({{ gh(663) }} by {{ authors.larsoner}} )
- Misspellings are now checked in config
- ({{ gh(665) }} by {{ authors.larsoner }} )

### Code health

- Each processing script now extracts the required subset of configuration
  options from the user config and operates solely on these. This helps make it
  clear which settings an individual script depends on.
  ({{ gh(383) }} by {{ authors.agramfort }} and {{ authors.hoechenberger }})
- We laid the groundwork for applying the inverse operator on other data types
  than just `mne.Evoked` by introducing
  [`inverse_targets`][mne_bids_pipeline._config.inverse_targets].
  ({{ gh(452) }} by {{ authors.apmellot }})
- All processing scripts have been renamed and turned into submodules, and the 
  pipeline is now organized like a standard Python package with a command-line
  interface `mne_bids_pipeline ...`
  ({{ gh(470) }}, {{ gh(611) }}, {{ gh(664) }} by {{ authors.agramfort }}, 
   {{ authors.hoechenberger }}, and {{ authors.larsoner }})
- For storing configuration values, we switched from using `BunchConst` to
  Python's built-in `SimpleNamespace`.
  ({{ gh(472) }} by {{ authors.agramfort }})
- The `config.process_er` variable was renamed
  [`config.process_empty_room`][mne_bids_pipeline._config.process_empty_room]
  for readability, and the default was changed to `True` for consistency
  ({{ gh(633) }} by {{ authors.larsoner }})

### Bug fixes

- The FreeSurfer script could only be run if `--n_jobs` was passed explicitly
  ({{ gh(287) }} by {{ authors.MerlinDumeur }})
- Fix a problem with the FreeSurfer processing step that caused the error
  message `Could not consume arg` after completion ({{ gh(301) }} by
  {{ authors.hoechenberger }})
- Selecting the `extended_infomax` ICA algorithm caused a crash
  ({{ gh(308) }} by {{ authors.hoechenberger }})
- Correctly handle `eog_channels = None` setting after creation of bipolar EEG
  channels
  ({{ gh(311) }} by {{ authors.hoechenberger }})
- Added instructions on how to handle `FileNotFoundError` when loading the BEM
  model in the source steps ({{ gh(304) }}  by {{ authors.MerlinDumeur }})
- When using [`find_noisy_channels_meg`][mne_bids_pipeline._config.find_noisy_channels_meg] or
  [`find_flat_channels_meg`][mne_bids_pipeline._config.find_flat_channels_meg], we now pass
  [`mf_head_origin`][mne_bids_pipeline._config.mf_head_origin] to the respective bad channel
  detection algorithm to achieve better performance
  ({{ gh(319) }} by {{ authors.agramfort }})
- Baseline was not applied to epochs if neither ICA nor SSP was used
  ({{ gh(319) }} by {{ authors.hoechenberger }})
- Ensure we always use the cleaned epochs for constructing evoked data
  ({{ gh(319) }} by {{ authors.agramfort }})
- The summary report didn't use the cleaned epochs for showing the effects of
  ICA.
  ({{ gh(320) }} by {{ authors.hoechenberger }})
- The sanity check comparing the rank of the experimental data and the rank of
   the empty-room after Maxwell-filtering did not use the maxfiltered data.
  ({{ gh(336) }} by {{ authors.agramfort }}, {{ authors.hoechenberger }},
  and {{ authors.crsegerie }})
- `epochs_tmin` and `epochs_tmax` were named incorrectly in some test config
  files.
  ({{ gh(340) }} by {{ authors.crsegerie }})
- We now reject bad epochs by using [`ica_reject`][mne_bids_pipeline._config.ica_reject] before
  producing the "overlay" plots that show the evoked data before and after
  ICA cleaning in the `proc-ica_report`.
  ({{ gh(385) }} by {{ authors.crsegerie }}).
- Passing subject, session, task, and run names to `run.py` the consist only of
  numbers doesn't throw an exception anymore, even if the values weren't
  double-quoted and hence converted to strings by the command-line interface
  toolkit we are using, Fire.
  ({{ gh(375) }} by {{ authors.hoechenberger }})
- Setting [`eeg_reference`][mne_bids_pipeline._config.eeg_reference] to a string (name of the
  reference channel) caused us to crash.
  ({{ gh(391) }} by {{ authors.hoechenberger }})
- Parameters retrieved from the BIDS dataset were not limited to the modality
  ("data type") we meant to process, sometimes leading to crashes.
  ({{ gh(391) }} by {{ authors.hoechenberger }})
- Fix forward computation for CTF data.
  ({{ gh(427) }} by {{ authors.agramfort }})
- Generated derivative epochs split files now follow the BIDS naming scheme.
  ({{ gh(463)}} by {{ authors.dengemann }})
- Report tags are now better sanitized.
  ({{ gh(471) }} by {{ authors.hoechenberger }})
- When creating epochs, we now ensure that the trigger codes provided via the
  `*_events.tsv` file are retained; previously, new trigger codes were
  generated in certain situations.
  ({{ gh(471) }} by {{ authors.hoechenberger }})
- ICA overlay plots in the report used the cleaned epochs, resulting in no
  visible ICA cleaning effects. This has been corrected.
  ({{ gh(478) }} by {{ authors.hoechenberger }})
- Ensure we don't over-estimate the rank of Maxwell-filtered data consisting
  of multiple runs.
  ({{ gh(530) }} by {{ authors.hoechenberger }} and {{ authors.agramfort }})
- Don't drop bad channels from empty-room data on import.
  ({{ gh(532) }} by {{ authors.hoechenberger }})
- Time-by-time decoding now respects the
  [`decoding_n_splits`][mne_bids_pipeline._config.decoding_n_splits] setting.
  ({{ gh(558) }} by {{ authors.hoechenberger }})
- Time-by-time decoding now respects the random seed specified via
  [`random_state`][mne_bids_pipeline._config.random_state] when generating the cross-validation
  splits.
  ({{ gh(558) }} by {{ authors.hoechenberger }})
- When automatically finding flat or noisy MEG channels was enabled, the data
  would always be 40-Hz-lowpass-filtered even if not explicitly requested by
  the user. This is now fixed.
  ({{ gh(558) }} by {{ authors.apmellot }} and {{ authors.hoechenberger }})
- EEG channels couldn't be used as "virtual" EOG channels during ICA artifact
  detection. Reported by "fraenni" on the forum. Thank you! 🌻
  ({{ gh(572) }} by {{ authors.hoechenberger }})
- Fix bug with handling of split files during preprocessing
  ({{ gh(597) }} by {{ authors.larsoner }})
- Fix bug where wrong command-line arguments to ``run.py`` were just ignored
  instead of raising an error
  ({{ gh(605) }}) by {{ authors.larsoner }})
- During the Maxwell filtering step, all channels are now kept rather than
  being restricted to just MEG channels
  ({{ gh(606) }} by {{ authors.larsoner }})
- The default for `analyze_channels` is now `'ch_types'` which restricts to the
  data channels of interest rather than `'all'`, which included all channels,
  and hence could include things like stimulus channels
  ({{ gh(606) }} by {{ authors.larsoner }})
- Fix bug where only the first run was used to compute SSP
  ({{ gh(607) }} by {{ authors.larsoner }})
- Fix bug with CPU oversubscription when using the Dask backend on macOS M1
  ({{ gh(638) }} by {{ authors.larsoner }})
