"""
create_time: 2023/2/4 14:03
author: TsangHans
"""
import os
import ddtcv

import numpy as np

from ddtcv.onnx import ONNXModel

_static_dir = os.path.join(ddtcv.__path__[0], "static")
_default_onnx_model_fp = os.path.join(_static_dir, "model/angle_1_rec_en_number_lite/angle_1_rec_en_number_lite.onnx")
_default_character_dict_fp = os.path.join(_static_dir, "model/angle_1_rec_en_number_lite/angle_dict.txt")
_default_wind_rec_model = ONNXModel(_default_onnx_model_fp, _default_character_dict_fp)
default_x_slice = slice(555, 576)
default_y_slice = slice(29, 73)


def Angle(image: np.ndarray, rec_model: ONNXModel = _default_wind_rec_model, x_slice: slice = default_x_slice,
         y_slice: slice = default_y_slice):
    x = image[x_slice, y_slice]
    res = rec_model.predict(x)
    return int(res)