import numpy as np

"""
{'p_gauss_1': array([ 0.07349721, -0.60647022,  1.97806105, -3.22994084,  2.72007585,
        -0.92812989]),
 'p_gauss_2': array([ 0.08434813, -0.69694429,  2.28047526, -3.73821453,  3.15612997,
        -0.99158461]),
 'p_q': array([ 0.05712779, -0.47050592,  1.56888875, -2.75649024,  2.71900493,
        -0.28637106]),
 'p_std': array([ 0.08344418, -0.68630504,  2.21084202, -3.50529186,  2.77854093,
         0.08576048])}
"""


def eval_xi_1(n):
    """ convert to MAD """
    p = np.array([0.07349721, -0.60647022, 1.97806105, -3.22994084, 2.72007585, -0.92812989])
    return 10. ** np.polyval(p, np.log10(n))


def eval_xi_2(n):
    """ convert to MAD """
    p = np.array([0.08434813, -0.69694429, 2.28047526, -3.73821453, 3.15612997, -0.99158461])
    return 10. ** np.polyval(p, np.log10(n))


def eval_zeta_q(n):
    """ convert to std """
    p = np.array([0.05712779, -0.47050592, 1.56888875, -2.75649024, 2.71900493, -0.28637106])
    return np.polyval(p, np.log10(n))


def eval_zeta_std(n):
    """ convert to std """
    p = np.array([0.08344418, -0.68630504, 2.21084202, -3.50529186, 2.77854093, 0.08576048])
    return np.polyval(p, np.log10(n))
