"""Created on Monday March 15 19:27:14 2021

In this module, you will find all functions and data structures related to
EEG and MEG signals. Enjoy!

References:
    https://stefanappelhoff.com/eeg_positions
    https://github.com/sappelhoff/eeg_positions
    https://mne.tools/dev/auto_tutorials/intro/40_sensor_locations.html
@author: Eduardo Santamaría-Vázquez
"""

# Built-in imports
import math

# External imports
import scipy.io
import numpy as np

# Medusa imports
from medusa import components

# Synonyms
eeg_channel_synonyms = {
    'I1': 'O9',
    'I2': 'O10',
    'T3': 'T7',
    'T4': 'T8'
}

# EEG standards
eeg_1020 = {'C3': {'X2D': -0.3249, 'Y2D': 0.0, 'X3D': -0.5878, 'Y3D': 0.0,
                   'Z3D': 0.809},
            'C4': {'X2D': 0.3249, 'Y2D': 0.0, 'X3D': 0.5878, 'Y3D': 0.0,
                   'Z3D': 0.809},
            'CZ': {'X2D': 0.0, 'Y2D': 0.0, 'X3D': 0.0, 'Y3D': 0.0, 'Z3D': 1.0},
            'F3': {'X2D': -0.2744, 'Y2D': 0.3467, 'X3D': -0.4591, 'Y3D': 0.58,
                   'Z3D': 0.673},
            'F4': {'X2D': 0.2744, 'Y2D': 0.3467, 'X3D': 0.4591, 'Y3D': 0.58,
                   'Z3D': 0.673},
            'F7': {'X2D': -0.5879, 'Y2D': 0.427, 'X3D': -0.7695, 'Y3D': 0.559,
                   'Z3D': 0.309},
            'F8': {'X2D': 0.5879, 'Y2D': 0.427, 'X3D': 0.7695, 'Y3D': 0.559,
                   'Z3D': 0.309},
            'FP1': {'X2D': -0.2245, 'Y2D': 0.691, 'X3D': -0.2939, 'Y3D': 0.9045,
                    'Z3D': 0.309},
            'FP2': {'X2D': 0.2245, 'Y2D': 0.691, 'X3D': 0.2939, 'Y3D': 0.9045,
                    'Z3D': 0.309},
            'FPZ': {'X2D': 0.0, 'Y2D': 0.7266, 'X3D': 0.0, 'Y3D': 0.9511,
                    'Z3D': 0.309},
            'FZ': {'X2D': 0.0, 'Y2D': 0.3249, 'X3D': 0.0, 'Y3D': 0.5878,
                   'Z3D': 0.809},
            'LPA': {'X2D': -1.0, 'Y2D': 0.0, 'X3D': -1.0, 'Y3D': 0.0,
                    'Z3D': 0.0},
            'NAS': {'X2D': 0.0, 'Y2D': 1.0, 'X3D': 0.0, 'Y3D': 1.0, 'Z3D': 0.0},
            'O1': {'X2D': -0.2245, 'Y2D': -0.691, 'X3D': -0.2939,
                   'Y3D': -0.9045, 'Z3D': 0.309},
            'O2': {'X2D': 0.2245, 'Y2D': -0.691, 'X3D': 0.2939, 'Y3D': -0.9045,
                   'Z3D': 0.309},
            'OZ': {'X2D': 0.0, 'Y2D': -0.7266, 'X3D': 0.0, 'Y3D': -0.9511,
                   'Z3D': 0.309},
            'P3': {'X2D': -0.2744, 'Y2D': -0.3467, 'X3D': -0.4591, 'Y3D': -0.58,
                   'Z3D': 0.673},
            'P4': {'X2D': 0.2744, 'Y2D': -0.3467, 'X3D': 0.4591, 'Y3D': -0.58,
                   'Z3D': 0.673},
            'P7': {'X2D': -0.5879, 'Y2D': -0.427, 'X3D': -0.7695, 'Y3D': -0.559,
                   'Z3D': 0.309},
            'P8': {'X2D': 0.5879, 'Y2D': -0.427, 'X3D': 0.7695, 'Y3D': -0.559,
                   'Z3D': 0.309},
            'PZ': {'X2D': 0.0, 'Y2D': -0.3249, 'X3D': 0.0, 'Y3D': -0.5878,
                   'Z3D': 0.809},
            'RPA': {'X2D': 1.0, 'Y2D': 0.0, 'X3D': 1.0, 'Y3D': 0.0, 'Z3D': 0.0},
            'T7': {'X2D': -0.7266, 'Y2D': 0.0, 'X3D': -0.9511, 'Y3D': 0.0,
                   'Z3D': 0.309},
            'T8': {'X2D': 0.7266, 'Y2D': 0.0, 'X3D': 0.9511, 'Y3D': 0.0,
                   'Z3D': 0.309}}
eeg_1010 = {'AF7': {'X2D': -0.427, 'Y2D': 0.5879, 'X3D': -0.559, 'Y3D': 0.7695,
                    'Z3D': 0.309},
            'AF8': {'X2D': 0.427, 'Y2D': 0.5879, 'X3D': 0.559, 'Y3D': 0.7695,
                    'Z3D': 0.309},
            'AFZ': {'X2D': 0.0, 'Y2D': 0.5095, 'X3D': 0.0, 'Y3D': 0.809,
                    'Z3D': 0.5878},
            'C1': {'X2D': -0.1584, 'Y2D': 0.0, 'X3D': -0.309, 'Y3D': 0.0,
                   'Z3D': 0.9511},
            'C2': {'X2D': 0.1584, 'Y2D': 0.0, 'X3D': 0.309, 'Y3D': 0.0,
                   'Z3D': 0.9511},
            'C3': {'X2D': -0.3249, 'Y2D': 0.0, 'X3D': -0.5878, 'Y3D': 0.0,
                   'Z3D': 0.809},
            'C4': {'X2D': 0.3249, 'Y2D': 0.0, 'X3D': 0.5878, 'Y3D': 0.0,
                   'Z3D': 0.809},
            'C5': {'X2D': -0.5095, 'Y2D': 0.0, 'X3D': -0.809, 'Y3D': 0.0,
                   'Z3D': 0.5878},
            'C6': {'X2D': 0.5095, 'Y2D': 0.0, 'X3D': 0.809, 'Y3D': 0.0,
                   'Z3D': 0.5878},
            'CP1': {'X2D': -0.1527, 'Y2D': -0.1616, 'X3D': -0.2911,
                    'Y3D': -0.3079, 'Z3D': 0.9058},
            'CP2': {'X2D': 0.1527, 'Y2D': -0.1616, 'X3D': 0.2911,
                    'Y3D': -0.3079, 'Z3D': 0.9058},
            'CP3': {'X2D': -0.3126, 'Y2D': -0.1718, 'X3D': -0.5547,
                    'Y3D': -0.3048, 'Z3D': 0.7742},
            'CP4': {'X2D': 0.3126, 'Y2D': -0.1718, 'X3D': 0.5547,
                    'Y3D': -0.3048, 'Z3D': 0.7742},
            'CP5': {'X2D': -0.4881, 'Y2D': -0.1912, 'X3D': -0.7658, 'Y3D': -0.3,
                    'Z3D': 0.5688},
            'CP6': {'X2D': 0.4881, 'Y2D': -0.1912, 'X3D': 0.7658, 'Y3D': -0.3,
                    'Z3D': 0.5688},
            'CPZ': {'X2D': 0.0, 'Y2D': -0.1584, 'X3D': 0.0, 'Y3D': -0.309,
                    'Z3D': 0.9511},
            'CZ': {'X2D': 0.0, 'Y2D': 0.0, 'X3D': 0.0, 'Y3D': 0.0, 'Z3D': 1.0},
            'F1': {'X2D': -0.1349, 'Y2D': 0.3302, 'X3D': -0.2394, 'Y3D': 0.5858,
                   'Z3D': 0.7743},
            'F10': {'X2D': 0.809, 'Y2D': 0.5878, 'X3D': 0.809, 'Y3D': 0.5878,
                    'Z3D': 0.0},
            'F2': {'X2D': 0.1349, 'Y2D': 0.3302, 'X3D': 0.2394, 'Y3D': 0.5858,
                   'Z3D': 0.7743},
            'F3': {'X2D': -0.2744, 'Y2D': 0.3467, 'X3D': -0.4591, 'Y3D': 0.58,
                   'Z3D': 0.673},
            'F4': {'X2D': 0.2744, 'Y2D': 0.3467, 'X3D': 0.4591, 'Y3D': 0.58,
                   'Z3D': 0.673},
            'F5': {'X2D': -0.4234, 'Y2D': 0.3771, 'X3D': -0.6408, 'Y3D': 0.5708,
                   'Z3D': 0.5135},
            'F6': {'X2D': 0.4234, 'Y2D': 0.3771, 'X3D': 0.6408, 'Y3D': 0.5708,
                   'Z3D': 0.5135},
            'F7': {'X2D': -0.5879, 'Y2D': 0.427, 'X3D': -0.7695, 'Y3D': 0.559,
                   'Z3D': 0.309},
            'F8': {'X2D': 0.5879, 'Y2D': 0.427, 'X3D': 0.7695, 'Y3D': 0.559,
                   'Z3D': 0.309},
            'F9': {'X2D': -0.809, 'Y2D': 0.5878, 'X3D': -0.809, 'Y3D': 0.5878,
                   'Z3D': 0.0},
            'FC1': {'X2D': -0.1527, 'Y2D': 0.1616, 'X3D': -0.2911,
                    'Y3D': 0.3079, 'Z3D': 0.9058},
            'FC2': {'X2D': 0.1527, 'Y2D': 0.1616, 'X3D': 0.2911, 'Y3D': 0.3079,
                    'Z3D': 0.9058},
            'FC3': {'X2D': -0.3126, 'Y2D': 0.1718, 'X3D': -0.5547,
                    'Y3D': 0.3048, 'Z3D': 0.7742},
            'FC4': {'X2D': 0.3126, 'Y2D': 0.1718, 'X3D': 0.5547, 'Y3D': 0.3048,
                    'Z3D': 0.7742},
            'FC5': {'X2D': -0.4881, 'Y2D': 0.1912, 'X3D': -0.7658, 'Y3D': 0.3,
                    'Z3D': 0.5688},
            'FC6': {'X2D': 0.4881, 'Y2D': 0.1912, 'X3D': 0.7658, 'Y3D': 0.3,
                    'Z3D': 0.5688},
            'FCZ': {'X2D': 0.0, 'Y2D': 0.1584, 'X3D': 0.0, 'Y3D': 0.309,
                    'Z3D': 0.9511},
            'FT10': {'X2D': 0.9511, 'Y2D': 0.309, 'X3D': 0.9511, 'Y3D': 0.309,
                     'Z3D': 0.0},
            'FT7': {'X2D': -0.691, 'Y2D': 0.2245, 'X3D': -0.9045, 'Y3D': 0.2939,
                    'Z3D': 0.309},
            'FT8': {'X2D': 0.691, 'Y2D': 0.2245, 'X3D': 0.9045, 'Y3D': 0.2939,
                    'Z3D': 0.309},
            'FT9': {'X2D': -0.9511, 'Y2D': 0.309, 'X3D': -0.9511, 'Y3D': 0.309,
                    'Z3D': 0.0},
            'FP1': {'X2D': -0.2245, 'Y2D': 0.691, 'X3D': -0.2939, 'Y3D': 0.9045,
                    'Z3D': 0.309},
            'FP2': {'X2D': 0.2245, 'Y2D': 0.691, 'X3D': 0.2939, 'Y3D': 0.9045,
                    'Z3D': 0.309},
            'FPZ': {'X2D': 0.0, 'Y2D': 0.7266, 'X3D': 0.0, 'Y3D': 0.9511,
                    'Z3D': 0.309},
            'FZ': {'X2D': 0.0, 'Y2D': 0.3249, 'X3D': 0.0, 'Y3D': 0.5878,
                   'Z3D': 0.809},
            'I1': {'X2D': -0.309, 'Y2D': -0.9511, 'X3D': -0.309, 'Y3D': -0.9511,
                   'Z3D': 0.0},
            'I2': {'X2D': 0.309, 'Y2D': -0.9511, 'X3D': 0.309, 'Y3D': -0.9511,
                   'Z3D': 0.0},
            'IZ': {'X2D': 0.0, 'Y2D': -1.0, 'X3D': 0.0, 'Y3D': -1.0,
                   'Z3D': 0.0},
            'LPA': {'X2D': -1.0, 'Y2D': 0.0, 'X3D': -1.0, 'Y3D': 0.0,
                    'Z3D': 0.0},
            'NAS': {'X2D': 0.0, 'Y2D': 1.0, 'X3D': 0.0, 'Y3D': 1.0, 'Z3D': 0.0},
            'NZ': {'X2D': 0.0, 'Y2D': 1.0, 'X3D': 0.0, 'Y3D': 1.0, 'Z3D': 0.0},
            'O1': {'X2D': -0.2245, 'Y2D': -0.691, 'X3D': -0.2939,
                   'Y3D': -0.9045, 'Z3D': 0.309},
            'O2': {'X2D': 0.2245, 'Y2D': -0.691, 'X3D': 0.2939, 'Y3D': -0.9045,
                   'Z3D': 0.309},
            'OZ': {'X2D': 0.0, 'Y2D': -0.7266, 'X3D': 0.0, 'Y3D': -0.9511,
                   'Z3D': 0.309},
            'P1': {'X2D': -0.1349, 'Y2D': -0.3302, 'X3D': -0.2394,
                   'Y3D': -0.5858, 'Z3D': 0.7743},
            'P10': {'X2D': 0.809, 'Y2D': -0.5878, 'X3D': 0.809, 'Y3D': -0.5878,
                    'Z3D': 0.0},
            'P2': {'X2D': 0.1349, 'Y2D': -0.3302, 'X3D': 0.2394, 'Y3D': -0.5858,
                   'Z3D': 0.7743},
            'P3': {'X2D': -0.2744, 'Y2D': -0.3467, 'X3D': -0.4591, 'Y3D': -0.58,
                   'Z3D': 0.673},
            'P4': {'X2D': 0.2744, 'Y2D': -0.3467, 'X3D': 0.4591, 'Y3D': -0.58,
                   'Z3D': 0.673},
            'P5': {'X2D': -0.4234, 'Y2D': -0.3771, 'X3D': -0.6408,
                   'Y3D': -0.5708, 'Z3D': 0.5135},
            'P6': {'X2D': 0.4234, 'Y2D': -0.3771, 'X3D': 0.6408, 'Y3D': -0.5708,
                   'Z3D': 0.5135},
            'P7': {'X2D': -0.5879, 'Y2D': -0.427, 'X3D': -0.7695, 'Y3D': -0.559,
                   'Z3D': 0.309},
            'P8': {'X2D': 0.5879, 'Y2D': -0.427, 'X3D': 0.7695, 'Y3D': -0.559,
                   'Z3D': 0.309},
            'P9': {'X2D': -0.809, 'Y2D': -0.5878, 'X3D': -0.809, 'Y3D': -0.5878,
                   'Z3D': 0.0},
            'PO10': {'X2D': 0.5878, 'Y2D': -0.809, 'X3D': 0.5878, 'Y3D': -0.809,
                     'Z3D': 0.0},
            'PO7': {'X2D': -0.427, 'Y2D': -0.5879, 'X3D': -0.559,
                    'Y3D': -0.7695, 'Z3D': 0.309},
            'PO8': {'X2D': 0.427, 'Y2D': -0.5879, 'X3D': 0.559, 'Y3D': -0.7695,
                    'Z3D': 0.309},
            'PO9': {'X2D': -0.5878, 'Y2D': -0.809, 'X3D': -0.5878,
                    'Y3D': -0.809, 'Z3D': 0.0},
            'POZ': {'X2D': 0.0, 'Y2D': -0.5095, 'X3D': 0.0, 'Y3D': -0.809,
                    'Z3D': 0.5878},
            'PZ': {'X2D': 0.0, 'Y2D': -0.3249, 'X3D': 0.0, 'Y3D': -0.5878,
                   'Z3D': 0.809},
            'RPA': {'X2D': 1.0, 'Y2D': 0.0, 'X3D': 1.0, 'Y3D': 0.0, 'Z3D': 0.0},
            'T10': {'X2D': 1.0, 'Y2D': 0.0, 'X3D': 1.0, 'Y3D': 0.0, 'Z3D': 0.0},
            'T7': {'X2D': -0.7266, 'Y2D': 0.0, 'X3D': -0.9511, 'Y3D': 0.0,
                   'Z3D': 0.309},
            'T8': {'X2D': 0.7266, 'Y2D': 0.0, 'X3D': 0.9511, 'Y3D': 0.0,
                   'Z3D': 0.309},
            'T9': {'X2D': -1.0, 'Y2D': 0.0, 'X3D': -1.0, 'Y3D': 0.0,
                   'Z3D': 0.0},
            'TP7': {'X2D': -0.691, 'Y2D': -0.2245, 'X3D': -0.9045,
                    'Y3D': -0.2939, 'Z3D': 0.309},
            'TP8': {'X2D': 0.691, 'Y2D': -0.2245, 'X3D': 0.9045, 'Y3D': -0.2939,
                    'Z3D': 0.309}}
eeg_1005 = {
    'AF1': {'X2D': -0.1025, 'Y2D': 0.5139, 'X3D': -0.1608, 'Y3D': 0.8064,
            'Z3D': 0.5692},
    'AF10': {'X2D': 0.5878, 'Y2D': 0.809, 'X3D': 0.5878, 'Y3D': 0.809,
             'Z3D': 0.0},
    'AF10H': {'X2D': 0.5021, 'Y2D': 0.691, 'X3D': 0.5806, 'Y3D': 0.7991,
              'Z3D': 0.1564},
    'AF1H': {'X2D': -0.0512, 'Y2D': 0.5105, 'X3D': -0.081, 'Y3D': 0.8083,
             'Z3D': 0.5832},
    'AF2': {'X2D': 0.1025, 'Y2D': 0.5139, 'X3D': 0.1608, 'Y3D': 0.8064,
            'Z3D': 0.5692},
    'AF2H': {'X2D': 0.0512, 'Y2D': 0.5105, 'X3D': 0.081, 'Y3D': 0.8083,
             'Z3D': 0.5832},
    'AF3': {'X2D': -0.2067, 'Y2D': 0.5274, 'X3D': -0.313, 'Y3D': 0.7986,
            'Z3D': 0.5142},
    'AF3H': {'X2D': -0.1543, 'Y2D': 0.5194, 'X3D': -0.2385, 'Y3D': 0.8031,
             'Z3D': 0.5461},
    'AF4': {'X2D': 0.2067, 'Y2D': 0.5274, 'X3D': 0.313, 'Y3D': 0.7986,
            'Z3D': 0.5142},
    'AF4H': {'X2D': 0.1543, 'Y2D': 0.5194, 'X3D': 0.2385, 'Y3D': 0.8031,
             'Z3D': 0.5461},
    'AF5': {'X2D': -0.3143, 'Y2D': 0.5513, 'X3D': -0.4481, 'Y3D': 0.7861,
            'Z3D': 0.4259},
    'AF5H': {'X2D': -0.26, 'Y2D': 0.5379, 'X3D': -0.3832, 'Y3D': 0.7929,
             'Z3D': 0.474},
    'AF6': {'X2D': 0.3143, 'Y2D': 0.5513, 'X3D': 0.4481, 'Y3D': 0.7861,
            'Z3D': 0.4259},
    'AF6H': {'X2D': 0.26, 'Y2D': 0.5379, 'X3D': 0.3832, 'Y3D': 0.7929,
             'Z3D': 0.474},
    'AF7': {'X2D': -0.427, 'Y2D': 0.5879, 'X3D': -0.559, 'Y3D': 0.7695,
            'Z3D': 0.309},
    'AF7H': {'X2D': -0.3699, 'Y2D': 0.5678, 'X3D': -0.507, 'Y3D': 0.7782,
             'Z3D': 0.3706},
    'AF8': {'X2D': 0.427, 'Y2D': 0.5879, 'X3D': 0.559, 'Y3D': 0.7695,
            'Z3D': 0.309},
    'AF8H': {'X2D': 0.3699, 'Y2D': 0.5678, 'X3D': 0.507, 'Y3D': 0.7782,
             'Z3D': 0.3706},
    'AF9': {'X2D': -0.5878, 'Y2D': 0.809, 'X3D': -0.5878, 'Y3D': 0.809,
            'Z3D': 0.0},
    'AF9H': {'X2D': -0.5021, 'Y2D': 0.691, 'X3D': -0.5806, 'Y3D': 0.7991,
             'Z3D': 0.1564},
    'AFF1': {'X2D': -0.1207, 'Y2D': 0.4195, 'X3D': -0.2028, 'Y3D': 0.7047,
             'Z3D': 0.6799},
    'AFF10': {'X2D': 0.7071, 'Y2D': 0.7071, 'X3D': 0.7071, 'Y3D': 0.7071,
              'Z3D': 0.0},
    'AFF10H': {'X2D': 0.6039, 'Y2D': 0.6039, 'X3D': 0.6984, 'Y3D': 0.6984,
               'Z3D': 0.1564},
    'AFF1H': {'X2D': -0.0602, 'Y2D': 0.4155, 'X3D': -0.1023, 'Y3D': 0.7065,
              'Z3D': 0.7003},
    'AFF2': {'X2D': 0.1207, 'Y2D': 0.4195, 'X3D': 0.2028, 'Y3D': 0.7047,
             'Z3D': 0.6799},
    'AFF2H': {'X2D': 0.0602, 'Y2D': 0.4155, 'X3D': 0.1023, 'Y3D': 0.7065,
              'Z3D': 0.7003},
    'AFF3': {'X2D': -0.2444, 'Y2D': 0.4361, 'X3D': -0.3911, 'Y3D': 0.6978,
             'Z3D': 0.6001},
    'AFF3H': {'X2D': -0.182, 'Y2D': 0.4263, 'X3D': -0.2997, 'Y3D': 0.7018,
              'Z3D': 0.6463},
    'AFF4': {'X2D': 0.2444, 'Y2D': 0.4361, 'X3D': 0.3911, 'Y3D': 0.6978,
             'Z3D': 0.6001},
    'AFF4H': {'X2D': 0.182, 'Y2D': 0.4263, 'X3D': 0.2997, 'Y3D': 0.7018,
              'Z3D': 0.6463},
    'AFF5': {'X2D': -0.3743, 'Y2D': 0.4661, 'X3D': -0.5515, 'Y3D': 0.6868,
             'Z3D': 0.4734},
    'AFF5H': {'X2D': -0.3084, 'Y2D': 0.4493, 'X3D': -0.4756, 'Y3D': 0.6928,
              'Z3D': 0.5421},
    'AFF6': {'X2D': 0.3743, 'Y2D': 0.4661, 'X3D': 0.5515, 'Y3D': 0.6868,
             'Z3D': 0.4734},
    'AFF6H': {'X2D': 0.3084, 'Y2D': 0.4493, 'X3D': 0.4756, 'Y3D': 0.6928,
              'Z3D': 0.5421},
    'AFF7': {'X2D': -0.5138, 'Y2D': 0.5138, 'X3D': -0.6725, 'Y3D': 0.6725,
             'Z3D': 0.309},
    'AFF7H': {'X2D': -0.4426, 'Y2D': 0.4874, 'X3D': -0.6175, 'Y3D': 0.68,
              'Z3D': 0.3953},
    'AFF8': {'X2D': 0.5138, 'Y2D': 0.5138, 'X3D': 0.6725, 'Y3D': 0.6725,
             'Z3D': 0.309},
    'AFF8H': {'X2D': 0.4426, 'Y2D': 0.4874, 'X3D': 0.6175, 'Y3D': 0.68,
              'Z3D': 0.3953},
    'AFF9': {'X2D': -0.7071, 'Y2D': 0.7071, 'X3D': -0.7071, 'Y3D': 0.7071,
             'Z3D': 0.0},
    'AFF9H': {'X2D': -0.6039, 'Y2D': 0.6039, 'X3D': -0.6984, 'Y3D': 0.6984,
              'Z3D': 0.1564},
    'AFFZ': {'X2D': 0.0, 'Y2D': 0.4142, 'X3D': 0.0, 'Y3D': 0.7071,
             'Z3D': 0.7071},
    'AFP1': {'X2D': -0.0803, 'Y2D': 0.6148, 'X3D': -0.116, 'Y3D': 0.8882,
             'Z3D': 0.4446},
    'AFP10': {'X2D': 0.454, 'Y2D': 0.891, 'X3D': 0.454, 'Y3D': 0.891,
              'Z3D': 0.0},
    'AFP10H': {'X2D': 0.3878, 'Y2D': 0.761, 'X3D': 0.4484, 'Y3D': 0.88,
               'Z3D': 0.1564},
    'AFP1H': {'X2D': -0.0401, 'Y2D': 0.6133, 'X3D': -0.0582, 'Y3D': 0.8903,
              'Z3D': 0.4517},
    'AFP2': {'X2D': 0.0803, 'Y2D': 0.6148, 'X3D': 0.116, 'Y3D': 0.8882,
             'Z3D': 0.4446},
    'AFP2H': {'X2D': 0.0401, 'Y2D': 0.6133, 'X3D': 0.0582, 'Y3D': 0.8903,
              'Z3D': 0.4517},
    'AFP3': {'X2D': -0.1615, 'Y2D': 0.621, 'X3D': -0.2288, 'Y3D': 0.8798,
             'Z3D': 0.4167},
    'AFP3H': {'X2D': -0.1207, 'Y2D': 0.6174, 'X3D': -0.173, 'Y3D': 0.8847,
              'Z3D': 0.4329},
    'AFP4': {'X2D': 0.1615, 'Y2D': 0.621, 'X3D': 0.2288, 'Y3D': 0.8798,
             'Z3D': 0.4167},
    'AFP4H': {'X2D': 0.1207, 'Y2D': 0.6174, 'X3D': 0.173, 'Y3D': 0.8847,
              'Z3D': 0.4329},
    'AFP5': {'X2D': -0.2443, 'Y2D': 0.6317, 'X3D': -0.335, 'Y3D': 0.8661,
             'Z3D': 0.3711},
    'AFP5H': {'X2D': -0.2027, 'Y2D': 0.6258, 'X3D': -0.2829, 'Y3D': 0.8736,
              'Z3D': 0.396},
    'AFP6': {'X2D': 0.2443, 'Y2D': 0.6317, 'X3D': 0.335, 'Y3D': 0.8661,
             'Z3D': 0.3711},
    'AFP6H': {'X2D': 0.2027, 'Y2D': 0.6258,
              'X3D': 0.2829, 'Y3D': 0.8736, 'Z3D': 0.396},
    'AFP7': {'X2D': -0.3299, 'Y2D': 0.6474, 'X3D': -0.4318, 'Y3D': 0.8474,
             'Z3D': 0.309},
    'AFP7H': {'X2D': -0.2867, 'Y2D': 0.6388, 'X3D': -0.3848, 'Y3D': 0.8573,
              'Z3D': 0.342},
    'AFP8': {'X2D': 0.3299, 'Y2D': 0.6474, 'X3D': 0.4318, 'Y3D': 0.8474,
             'Z3D': 0.309},
    'AFP8H': {'X2D': 0.2867, 'Y2D': 0.6388, 'X3D': 0.3848, 'Y3D': 0.8573,
              'Z3D': 0.342},
    'AFP9': {'X2D': -0.454, 'Y2D': 0.891, 'X3D': -0.454, 'Y3D': 0.891,
             'Z3D': 0.0},
    'AFP9H': {'X2D': -0.3878, 'Y2D': 0.761, 'X3D': -0.4484, 'Y3D': 0.88,
              'Z3D': 0.1564},
    'AFPZ': {'X2D': 0.0, 'Y2D': 0.6128, 'X3D': 0.0, 'Y3D': 0.891, 'Z3D': 0.454},
    'AFZ': {'X2D': 0.0, 'Y2D': 0.5095, 'X3D': 0.0, 'Y3D': 0.809, 'Z3D': 0.5878},
    'C1': {'X2D': -0.1584, 'Y2D': 0.0, 'X3D': -0.309, 'Y3D': 0.0,
           'Z3D': 0.9511},
    'C1H': {'X2D': -0.0787, 'Y2D': 0.0, 'X3D': -0.1564, 'Y3D': 0.0,
            'Z3D': 0.9877},
    'C2': {'X2D': 0.1584, 'Y2D': 0.0, 'X3D': 0.309, 'Y3D': 0.0, 'Z3D': 0.9511},
    'C2H': {'X2D': 0.0787, 'Y2D': 0.0, 'X3D': 0.1564, 'Y3D': 0.0,
            'Z3D': 0.9877},
    'C3': {'X2D': -0.3249, 'Y2D': 0.0, 'X3D': -0.5878, 'Y3D': 0.0,
           'Z3D': 0.809},
    'C3H': {'X2D': -0.2401, 'Y2D': 0.0, 'X3D': -0.454, 'Y3D': 0.0,
            'Z3D': 0.891},
    'C4': {'X2D': 0.3249, 'Y2D': 0.0, 'X3D': 0.5878, 'Y3D': 0.0, 'Z3D': 0.809},
    'C4H': {'X2D': 0.2401, 'Y2D': 0.0, 'X3D': 0.454, 'Y3D': 0.0, 'Z3D': 0.891},
    'C5': {'X2D': -0.5095, 'Y2D': 0.0, 'X3D': -0.809, 'Y3D': 0.0,
           'Z3D': 0.5878},
    'C5H': {'X2D': -0.4142, 'Y2D': 0.0, 'X3D': -0.7071, 'Y3D': 0.0,
            'Z3D': 0.7071},
    'C6': {'X2D': 0.5095, 'Y2D': 0.0, 'X3D': 0.809, 'Y3D': 0.0, 'Z3D': 0.5878},
    'C6H': {'X2D': 0.4142, 'Y2D': 0.0, 'X3D': 0.7071, 'Y3D': 0.0,
            'Z3D': 0.7071},
    'CCP1': {'X2D': -0.157, 'Y2D': -0.0804, 'X3D': -0.3045, 'Y3D': -0.1559,
             'Z3D': 0.9397},
    'CCP1H': {'X2D': -0.078, 'Y2D': -0.0791, 'X3D': -0.1541, 'Y3D': -0.1563,
              'Z3D': 0.9757},
    'CCP2': {'X2D': 0.157, 'Y2D': -0.0804, 'X3D': 0.3045, 'Y3D': -0.1559,
             'Z3D': 0.9397},
    'CCP2H': {'X2D': 0.078, 'Y2D': -0.0791, 'X3D': 0.1541, 'Y3D': -0.1563,
              'Z3D': 0.9757},
    'CCP3': {'X2D': -0.3219, 'Y2D': -0.0857, 'X3D': -0.5795, 'Y3D': -0.1543,
             'Z3D': 0.8003},
    'CCP3H': {'X2D': -0.2379, 'Y2D': -0.0825, 'X3D': -0.4475, 'Y3D': -0.1552,
              'Z3D': 0.8808},
    'CCP4': {'X2D': 0.3219, 'Y2D': -0.0857, 'X3D': 0.5795, 'Y3D': -0.1543,
             'Z3D': 0.8003},
    'CCP4H': {'X2D': 0.2379, 'Y2D': -0.0825, 'X3D': 0.4475, 'Y3D': -0.1552,
              'Z3D': 0.8808},
    'CCP5': {'X2D': -0.5042, 'Y2D': -0.096, 'X3D': -0.7982, 'Y3D': -0.1519,
             'Z3D': 0.583},
    'CCP5H': {'X2D': -0.4102, 'Y2D': -0.0901, 'X3D': -0.6974, 'Y3D': -0.1532,
              'Z3D': 0.7002},
    'CCP6': {'X2D': 0.5042, 'Y2D': -0.096, 'X3D': 0.7982, 'Y3D': -0.1519,
             'Z3D': 0.583},
    'CCP6H': {'X2D': 0.4102, 'Y2D': -0.0901, 'X3D': 0.6974, 'Y3D': -0.1532,
              'Z3D': 0.7002},
    'CCPZ': {'X2D': 0.0, 'Y2D': -0.0787, 'X3D': 0.0, 'Y3D': -0.1564,
             'Z3D': 0.9877},
    'CP1': {'X2D': -0.1527, 'Y2D': -0.1616, 'X3D': -0.2911, 'Y3D': -0.3079,
            'Z3D': 0.9058},
    'CP1H': {'X2D': -0.0759, 'Y2D': -0.1591, 'X3D': -0.1473, 'Y3D': -0.3087,
             'Z3D': 0.9397},
    'CP2': {'X2D': 0.1527, 'Y2D': -0.1616, 'X3D': 0.2911, 'Y3D': -0.3079,
            'Z3D': 0.9058},
    'CP2H': {'X2D': 0.0759, 'Y2D': -0.1591, 'X3D': 0.1473, 'Y3D': -0.3087,
             'Z3D': 0.9397},
    'CP3': {'X2D': -0.3126, 'Y2D': -0.1718, 'X3D': -0.5547, 'Y3D': -0.3048,
            'Z3D': 0.7742},
    'CP3H': {'X2D': -0.2313, 'Y2D': -0.1657, 'X3D': -0.428, 'Y3D': -0.3066,
             'Z3D': 0.8502},
    'CP4': {'X2D': 0.3126, 'Y2D': -0.1718, 'X3D': 0.5547, 'Y3D': -0.3048,
            'Z3D': 0.7742},
    'CP4H': {'X2D': 0.2313, 'Y2D': -0.1657, 'X3D': 0.428, 'Y3D': -0.3066,
             'Z3D': 0.8502},
    'CP5': {'X2D': -0.4881, 'Y2D': -0.1912, 'X3D': -0.7658, 'Y3D': -0.3,
            'Z3D': 0.5688},
    'CP5H': {'X2D': -0.3978, 'Y2D': -0.1802, 'X3D': -0.6682, 'Y3D': -0.3026,
             'Z3D': 0.6797},
    'CP6': {'X2D': 0.4881, 'Y2D': -0.1912, 'X3D': 0.7658, 'Y3D': -0.3,
            'Z3D': 0.5688},
    'CP6H': {'X2D': 0.3978, 'Y2D': -0.1802, 'X3D': 0.6682, 'Y3D': -0.3026,
             'Z3D': 0.6797},
    'CPP1': {'X2D': -0.1455, 'Y2D': -0.2445, 'X3D': -0.2692, 'Y3D': -0.4524,
             'Z3D': 0.8502},
    'CPP1H': {'X2D': -0.0724, 'Y2D': -0.2412, 'X3D': -0.1361, 'Y3D': -0.4536,
              'Z3D': 0.8808},
    'CPP2': {'X2D': 0.1455, 'Y2D': -0.2445, 'X3D': 0.2692, 'Y3D': -0.4524,
             'Z3D': 0.8502},
    'CPP2H': {'X2D': 0.0724, 'Y2D': -0.2412, 'X3D': 0.1361, 'Y3D': -0.4536,
              'Z3D': 0.8808},
    'CPP3': {'X2D': -0.2969, 'Y2D': -0.2587, 'X3D': -0.5141, 'Y3D': -0.4479,
             'Z3D': 0.7315},
    'CPP3H': {'X2D': -0.22, 'Y2D': -0.2503, 'X3D': -0.3961, 'Y3D': -0.4505,
              'Z3D': 0.8001},
    'CPP4': {'X2D': 0.2969, 'Y2D': -0.2587, 'X3D': 0.5141, 'Y3D': -0.4479,
             'Z3D': 0.7315},
    'CPP4H': {'X2D': 0.22, 'Y2D': -0.2503, 'X3D': 0.3961, 'Y3D': -0.4505,
              'Z3D': 0.8001},
    'CPP5': {'X2D': -0.4612, 'Y2D': -0.2852, 'X3D': -0.7128, 'Y3D': -0.4408,
             'Z3D': 0.5455},
    'CPP5H': {'X2D': -0.377, 'Y2D': -0.2702, 'X3D': -0.6205, 'Y3D': -0.4447,
              'Z3D': 0.646},
    'CPP6': {'X2D': 0.4612, 'Y2D': -0.2852, 'X3D': 0.7128, 'Y3D': -0.4408,
             'Z3D': 0.5455},
    'CPP6H': {'X2D': 0.377, 'Y2D': -0.2702, 'X3D': 0.6205, 'Y3D': -0.4447,
              'Z3D': 0.646},
    'CPPZ': {'X2D': 0.0, 'Y2D': -0.2401, 'X3D': 0.0, 'Y3D': -0.454,
             'Z3D': 0.891},
    'CPZ': {'X2D': 0.0, 'Y2D': -0.1584, 'X3D': 0.0, 'Y3D': -0.309,
            'Z3D': 0.9511},
    'CZ': {'X2D': 0.0, 'Y2D': 0.0, 'X3D': 0.0, 'Y3D': 0.0, 'Z3D': 1.0},
    'F1': {'X2D': -0.1349, 'Y2D': 0.3302, 'X3D': -0.2394, 'Y3D': 0.5858,
           'Z3D': 0.7743},
    'F10': {'X2D': 0.809, 'Y2D': 0.5878, 'X3D': 0.809, 'Y3D': 0.5878,
            'Z3D': 0.0},
    'F10H': {'X2D': 0.691, 'Y2D': 0.5021, 'X3D': 0.7991, 'Y3D': 0.5806,
             'Z3D': 0.1564},
    'F1H': {'X2D': -0.0672, 'Y2D': 0.3262, 'X3D': -0.121, 'Y3D': 0.5873,
            'Z3D': 0.8003},
    'F2': {'X2D': 0.1349, 'Y2D': 0.3302, 'X3D': 0.2394, 'Y3D': 0.5858,
           'Z3D': 0.7743},
    'F2H': {'X2D': 0.0672, 'Y2D': 0.3262, 'X3D': 0.121, 'Y3D': 0.5873,
            'Z3D': 0.8003},
    'F3': {'X2D': -0.2744, 'Y2D': 0.3467, 'X3D': -0.4591, 'Y3D': 0.58,
           'Z3D': 0.673},
    'F3H': {'X2D': -0.2038, 'Y2D': 0.3369, 'X3D': -0.3529, 'Y3D': 0.5833,
            'Z3D': 0.7316},
    'F4': {'X2D': 0.2744, 'Y2D': 0.3467, 'X3D': 0.4591, 'Y3D': 0.58,
           'Z3D': 0.673},
    'F4H': {'X2D': 0.2038, 'Y2D': 0.3369, 'X3D': 0.3529, 'Y3D': 0.5833,
            'Z3D': 0.7316},
    'F5': {'X2D': -0.4234, 'Y2D': 0.3771, 'X3D': -0.6408, 'Y3D': 0.5708,
           'Z3D': 0.5135},
    'F5H': {'X2D': -0.3474, 'Y2D': 0.3599, 'X3D': -0.5557, 'Y3D': 0.5758,
            'Z3D': 0.5998},
    'F6': {'X2D': 0.4234, 'Y2D': 0.3771, 'X3D': 0.6408, 'Y3D': 0.5708,
           'Z3D': 0.5135},
    'F6H': {'X2D': 0.3474, 'Y2D': 0.3599, 'X3D': 0.5557, 'Y3D': 0.5758,
            'Z3D': 0.5998},
    'F7': {'X2D': -0.5879, 'Y2D': 0.427, 'X3D': -0.7695, 'Y3D': 0.559,
           'Z3D': 0.309},
    'F7H': {'X2D': -0.5032, 'Y2D': 0.3992, 'X3D': -0.7125, 'Y3D': 0.5652,
            'Z3D': 0.4159},
    'F8': {'X2D': 0.5879, 'Y2D': 0.427, 'X3D': 0.7695, 'Y3D': 0.559,
           'Z3D': 0.309},
    'F8H': {'X2D': 0.5032, 'Y2D': 0.3992, 'X3D': 0.7125, 'Y3D': 0.5652,
            'Z3D': 0.4159},
    'F9': {'X2D': -0.809, 'Y2D': 0.5878, 'X3D': -0.809, 'Y3D': 0.5878,
           'Z3D': 0.0},
    'F9H': {'X2D': -0.691, 'Y2D': 0.5021, 'X3D': -0.7991, 'Y3D': 0.5806,
            'Z3D': 0.1564},
    'FC1': {'X2D': -0.1527, 'Y2D': 0.1616, 'X3D': -0.2911, 'Y3D': 0.3079,
            'Z3D': 0.9058},
    'FC1H': {'X2D': -0.0759, 'Y2D': 0.1591, 'X3D': -0.1473, 'Y3D': 0.3087,
             'Z3D': 0.9397},
    'FC2': {'X2D': 0.1527, 'Y2D': 0.1616, 'X3D': 0.2911, 'Y3D': 0.3079,
            'Z3D': 0.9058},
    'FC2H': {'X2D': 0.0759, 'Y2D': 0.1591, 'X3D': 0.1473, 'Y3D': 0.3087,
             'Z3D': 0.9397},
    'FC3': {'X2D': -0.3126, 'Y2D': 0.1718, 'X3D': -0.5547, 'Y3D': 0.3048,
            'Z3D': 0.7742},
    'FC3H': {'X2D': -0.2313, 'Y2D': 0.1657, 'X3D': -0.428, 'Y3D': 0.3066,
             'Z3D': 0.8502},
    'FC4': {'X2D': 0.3126, 'Y2D': 0.1718, 'X3D': 0.5547, 'Y3D': 0.3048,
            'Z3D': 0.7742},
    'FC4H': {'X2D': 0.2313, 'Y2D': 0.1657, 'X3D': 0.428, 'Y3D': 0.3066,
             'Z3D': 0.8502},
    'FC5': {'X2D': -0.4881, 'Y2D': 0.1912, 'X3D': -0.7658, 'Y3D': 0.3,
            'Z3D': 0.5688},
    'FC5H': {'X2D': -0.3978, 'Y2D': 0.1802, 'X3D': -0.6682, 'Y3D': 0.3026,
             'Z3D': 0.6797},
    'FC6': {'X2D': 0.4881, 'Y2D': 0.1912, 'X3D': 0.7658, 'Y3D': 0.3,
            'Z3D': 0.5688},
    'FC6H': {'X2D': 0.3978, 'Y2D': 0.1802, 'X3D': 0.6682, 'Y3D': 0.3026,
             'Z3D': 0.6797},
    'FCC1': {'X2D': -0.157, 'Y2D': 0.0804, 'X3D': -0.3045, 'Y3D': 0.1559,
             'Z3D': 0.9397},
    'FCC1H': {'X2D': -0.078, 'Y2D': 0.0791, 'X3D': -0.1541, 'Y3D': 0.1563,
              'Z3D': 0.9757},
    'FCC2': {'X2D': 0.157, 'Y2D': 0.0804, 'X3D': 0.3045, 'Y3D': 0.1559,
             'Z3D': 0.9397},
    'FCC2H': {'X2D': 0.078, 'Y2D': 0.0791, 'X3D': 0.1541, 'Y3D': 0.1563,
              'Z3D': 0.9757},
    'FCC3': {'X2D': -0.3219, 'Y2D': 0.0857, 'X3D': -0.5795, 'Y3D': 0.1543,
             'Z3D': 0.8003},
    'FCC3H': {'X2D': -0.2379, 'Y2D': 0.0825, 'X3D': -0.4475, 'Y3D': 0.1552,
              'Z3D': 0.8808},
    'FCC4': {'X2D': 0.3219, 'Y2D': 0.0857, 'X3D': 0.5795, 'Y3D': 0.1543,
             'Z3D': 0.8003},
    'FCC4H': {'X2D': 0.2379, 'Y2D': 0.0825, 'X3D': 0.4475, 'Y3D': 0.1552,
              'Z3D': 0.8808},
    'FCC5': {'X2D': -0.5042, 'Y2D': 0.096, 'X3D': -0.7982, 'Y3D': 0.1519,
             'Z3D': 0.583},
    'FCC5H': {'X2D': -0.4102, 'Y2D': 0.0901, 'X3D': -0.6974, 'Y3D': 0.1532,
              'Z3D': 0.7002},
    'FCC6': {'X2D': 0.5042, 'Y2D': 0.096, 'X3D': 0.7982, 'Y3D': 0.1519,
             'Z3D': 0.583},
    'FCC6H': {'X2D': 0.4102, 'Y2D': 0.0901, 'X3D': 0.6974, 'Y3D': 0.1532,
              'Z3D': 0.7002},
    'FCCZ': {'X2D': 0.0, 'Y2D': 0.0787, 'X3D': 0.0, 'Y3D': 0.1564,
             'Z3D': 0.9877},
    'FCZ': {'X2D': 0.0, 'Y2D': 0.1584, 'X3D': 0.0, 'Y3D': 0.309, 'Z3D': 0.9511},
    'FFC1': {'X2D': -0.1455, 'Y2D': 0.2445, 'X3D': -0.2692, 'Y3D': 0.4524,
             'Z3D': 0.8502},
    'FFC1H': {'X2D': -0.0724, 'Y2D': 0.2412, 'X3D': -0.1361, 'Y3D': 0.4536,
              'Z3D': 0.8808},
    'FFC2': {'X2D': 0.1455, 'Y2D': 0.2445, 'X3D': 0.2692, 'Y3D': 0.4524,
             'Z3D': 0.8502},
    'FFC2H': {'X2D': 0.0724, 'Y2D': 0.2412, 'X3D': 0.1361, 'Y3D': 0.4536,
              'Z3D': 0.8808},
    'FFC3': {'X2D': -0.2969, 'Y2D': 0.2587, 'X3D': -0.5141, 'Y3D': 0.4479,
             'Z3D': 0.7315},
    'FFC3H': {'X2D': -0.22, 'Y2D': 0.2503, 'X3D': -0.3961, 'Y3D': 0.4505,
              'Z3D': 0.8001},
    'FFC4': {'X2D': 0.2969, 'Y2D': 0.2587, 'X3D': 0.5141, 'Y3D': 0.4479,
             'Z3D': 0.7315},
    'FFC4H': {'X2D': 0.22, 'Y2D': 0.2503, 'X3D': 0.3961, 'Y3D': 0.4505,
              'Z3D': 0.8001},
    'FFC5': {'X2D': -0.4612, 'Y2D': 0.2852, 'X3D': -0.7128, 'Y3D': 0.4408,
             'Z3D': 0.5455},
    'FFC5H': {'X2D': -0.377, 'Y2D': 0.2702, 'X3D': -0.6205, 'Y3D': 0.4447,
              'Z3D': 0.646},
    'FFC6': {'X2D': 0.4612, 'Y2D': 0.2852, 'X3D': 0.7128, 'Y3D': 0.4408,
             'Z3D': 0.5455},
    'FFC6H': {'X2D': 0.377, 'Y2D': 0.2702, 'X3D': 0.6205, 'Y3D': 0.4447,
              'Z3D': 0.646},
    'FFCZ': {'X2D': 0.0, 'Y2D': 0.2401, 'X3D': 0.0, 'Y3D': 0.454, 'Z3D': 0.891},
    'FFT10': {'X2D': 0.891, 'Y2D': 0.454, 'X3D': 0.891, 'Y3D': 0.454,
              'Z3D': 0.0},
    'FFT10H': {'X2D': 0.761, 'Y2D': 0.3878, 'X3D': 0.88, 'Y3D': 0.4484,
               'Z3D': 0.1564},
    'FFT7': {'X2D': -0.6474, 'Y2D': 0.3299, 'X3D': -0.8474, 'Y3D': 0.4318,
             'Z3D': 0.309},
    'FFT7H': {'X2D': -0.5509, 'Y2D': 0.3048, 'X3D': -0.789, 'Y3D': 0.4365,
              'Z3D': 0.4323},
    'FFT8': {'X2D': 0.6474, 'Y2D': 0.3299, 'X3D': 0.8474, 'Y3D': 0.4318,
             'Z3D': 0.309},
    'FFT8H': {'X2D': 0.5509, 'Y2D': 0.3048, 'X3D': 0.789, 'Y3D': 0.4365,
              'Z3D': 0.4323},
    'FFT9': {'X2D': -0.891, 'Y2D': 0.454, 'X3D': -0.891, 'Y3D': 0.454,
             'Z3D': 0.0},
    'FFT9H': {'X2D': -0.761, 'Y2D': 0.3878, 'X3D': -0.88, 'Y3D': 0.4484,
              'Z3D': 0.1564},
    'FT10': {'X2D': 0.9511, 'Y2D': 0.309, 'X3D': 0.9511, 'Y3D': 0.309,
             'Z3D': 0.0},
    'FT10H': {'X2D': 0.8123, 'Y2D': 0.2639, 'X3D': 0.9394, 'Y3D': 0.3052,
              'Z3D': 0.1564},
    'FT7': {'X2D': -0.691, 'Y2D': 0.2245, 'X3D': -0.9045, 'Y3D': 0.2939,
            'Z3D': 0.309},
    'FT7H': {'X2D': -0.5852, 'Y2D': 0.2057, 'X3D': -0.8452, 'Y3D': 0.2971,
             'Z3D': 0.4443},
    'FT8': {'X2D': 0.691, 'Y2D': 0.2245, 'X3D': 0.9045, 'Y3D': 0.2939,
            'Z3D': 0.309},
    'FT8H': {'X2D': 0.5852, 'Y2D': 0.2057, 'X3D': 0.8452, 'Y3D': 0.2971,
             'Z3D': 0.4443},
    'FT9': {'X2D': -0.9511, 'Y2D': 0.309, 'X3D': -0.9511, 'Y3D': 0.309,
            'Z3D': 0.0},
    'FT9H': {'X2D': -0.8123, 'Y2D': 0.2639, 'X3D': -0.9394, 'Y3D': 0.3052,
             'Z3D': 0.1564},
    'FTT10': {'X2D': 0.9877, 'Y2D': 0.1564, 'X3D': 0.9877, 'Y3D': 0.1564,
              'Z3D': 0.0},
    'FTT10H': {'X2D': 0.8436, 'Y2D': 0.1336, 'X3D': 0.9755, 'Y3D': 0.1545,
               'Z3D': 0.1564},
    'FTT7': {'X2D': -0.7176, 'Y2D': 0.1137, 'X3D': -0.9394, 'Y3D': 0.1488,
             'Z3D': 0.309},
    'FTT7H': {'X2D': -0.6059, 'Y2D': 0.1036, 'X3D': -0.8795, 'Y3D': 0.1504,
              'Z3D': 0.4515},
    'FTT8': {'X2D': 0.7176, 'Y2D': 0.1137, 'X3D': 0.9394, 'Y3D': 0.1488,
             'Z3D': 0.309},
    'FTT8H': {'X2D': 0.6059, 'Y2D': 0.1036, 'X3D': 0.8795, 'Y3D': 0.1504,
              'Z3D': 0.4515},
    'FTT9': {'X2D': -0.9877, 'Y2D': 0.1564, 'X3D': -0.9877, 'Y3D': 0.1564,
             'Z3D': 0.0},
    'FTT9H': {'X2D': -0.8436, 'Y2D': 0.1336, 'X3D': -0.9755, 'Y3D': 0.1545,
              'Z3D': 0.1564},
    'FP1': {'X2D': -0.2245, 'Y2D': 0.691, 'X3D': -0.2939, 'Y3D': 0.9045,
            'Z3D': 0.309},
    'FP1H': {'X2D': -0.1137, 'Y2D': 0.7176, 'X3D': -0.1488, 'Y3D': 0.9394,
             'Z3D': 0.309},
    'FP2': {'X2D': 0.2245, 'Y2D': 0.691, 'X3D': 0.2939, 'Y3D': 0.9045,
            'Z3D': 0.309},
    'FP2H': {'X2D': 0.1137, 'Y2D': 0.7176, 'X3D': 0.1488, 'Y3D': 0.9394,
             'Z3D': 0.309},
    'FPZ': {'X2D': 0.0, 'Y2D': 0.7266, 'X3D': 0.0, 'Y3D': 0.9511, 'Z3D': 0.309},
    'FZ': {'X2D': 0.0, 'Y2D': 0.3249, 'X3D': 0.0, 'Y3D': 0.5878, 'Z3D': 0.809},
    'I1': {'X2D': -0.309, 'Y2D': -0.9511, 'X3D': -0.309, 'Y3D': -0.9511,
           'Z3D': 0.0},
    'I1H': {'X2D': -0.1564, 'Y2D': -0.9877, 'X3D': -0.1564, 'Y3D': -0.9877,
            'Z3D': 0.0},
    'I2': {'X2D': 0.309, 'Y2D': -0.9511, 'X3D': 0.309, 'Y3D': -0.9511,
           'Z3D': 0.0},
    'I2H': {'X2D': 0.1564, 'Y2D': -0.9877, 'X3D': 0.1564, 'Y3D': -0.9877,
            'Z3D': 0.0},
    'IZ': {'X2D': 0.0, 'Y2D': -1.0, 'X3D': 0.0, 'Y3D': -1.0, 'Z3D': 0.0},
    'LPA': {'X2D': -1.0, 'Y2D': 0.0, 'X3D': -1.0, 'Y3D': 0.0, 'Z3D': 0.0},
    'N1': {'X2D': -0.309, 'Y2D': 0.9511, 'X3D': -0.309, 'Y3D': 0.9511,
           'Z3D': 0.0},
    'N1H': {'X2D': -0.1564, 'Y2D': 0.9877, 'X3D': -0.1564, 'Y3D': 0.9877,
            'Z3D': 0.0},
    'N2': {'X2D': 0.309, 'Y2D': 0.9511, 'X3D': 0.309, 'Y3D': 0.9511,
           'Z3D': 0.0},
    'N2H': {'X2D': 0.1564, 'Y2D': 0.9877, 'X3D': 0.1564, 'Y3D': 0.9877,
            'Z3D': 0.0},
    'NAS': {'X2D': 0.0, 'Y2D': 1.0, 'X3D': 0.0, 'Y3D': 1.0, 'Z3D': 0.0},
    'NFP1': {'X2D': -0.2639, 'Y2D': 0.8123, 'X3D': -0.3052, 'Y3D': 0.9394,
             'Z3D': 0.1564},
    'NFP1H': {'X2D': -0.1336, 'Y2D': 0.8436, 'X3D': -0.1545, 'Y3D': 0.9755,
              'Z3D': 0.1564},
    'NFP2': {'X2D': 0.2639, 'Y2D': 0.8123, 'X3D': 0.3052, 'Y3D': 0.9394,
             'Z3D': 0.1564},
    'NFP2H': {'X2D': 0.1336, 'Y2D': 0.8436, 'X3D': 0.1545, 'Y3D': 0.9755,
              'Z3D': 0.1564},
    'NFPZ': {'X2D': 0.0, 'Y2D': 0.8541, 'X3D': 0.0, 'Y3D': 0.9877,
             'Z3D': 0.1564},
    'NZ': {'X2D': 0.0, 'Y2D': 1.0, 'X3D': 0.0, 'Y3D': 1.0, 'Z3D': 0.0},
    'O1': {'X2D': -0.2245, 'Y2D': -0.691, 'X3D': -0.2939, 'Y3D': -0.9045,
           'Z3D': 0.309},
    'O1H': {'X2D': -0.1137, 'Y2D': -0.7176, 'X3D': -0.1488, 'Y3D': -0.9394,
            'Z3D': 0.309},
    'O2': {'X2D': 0.2245, 'Y2D': -0.691, 'X3D': 0.2939, 'Y3D': -0.9045,
           'Z3D': 0.309},
    'O2H': {'X2D': 0.1137, 'Y2D': -0.7176, 'X3D': 0.1488, 'Y3D': -0.9394,
            'Z3D': 0.309},
    'OI1': {'X2D': -0.2639, 'Y2D': -0.8123, 'X3D': -0.3052, 'Y3D': -0.9394,
            'Z3D': 0.1564},
    'OI1H': {'X2D': -0.1336, 'Y2D': -0.8436, 'X3D': -0.1545, 'Y3D': -0.9755,
             'Z3D': 0.1564},
    'OI2': {'X2D': 0.2639, 'Y2D': -0.8123, 'X3D': 0.3052, 'Y3D': -0.9394,
            'Z3D': 0.1564},
    'OI2H': {'X2D': 0.1336, 'Y2D': -0.8436, 'X3D': 0.1545, 'Y3D': -0.9755,
             'Z3D': 0.1564},
    'OIZ': {'X2D': 0.0, 'Y2D': -0.8541, 'X3D': 0.0, 'Y3D': -0.9877,
            'Z3D': 0.1564},
    'OZ': {'X2D': 0.0, 'Y2D': -0.7266, 'X3D': 0.0, 'Y3D': -0.9511,
           'Z3D': 0.309},
    'P1': {'X2D': -0.1349, 'Y2D': -0.3302, 'X3D': -0.2394, 'Y3D': -0.5858,
           'Z3D': 0.7743},
    'P10': {'X2D': 0.809, 'Y2D': -0.5878, 'X3D': 0.809, 'Y3D': -0.5878,
            'Z3D': 0.0},
    'P10H': {'X2D': 0.691, 'Y2D': -0.5021, 'X3D': 0.7991, 'Y3D': -0.5806,
             'Z3D': 0.1564},
    'P1H': {'X2D': -0.0672, 'Y2D': -0.3262, 'X3D': -0.121, 'Y3D': -0.5873,
            'Z3D': 0.8003},
    'P2': {'X2D': 0.1349, 'Y2D': -0.3302, 'X3D': 0.2394, 'Y3D': -0.5858,
           'Z3D': 0.7743},
    'P2H': {'X2D': 0.0672, 'Y2D': -0.3262, 'X3D': 0.121, 'Y3D': -0.5873,
            'Z3D': 0.8003},
    'P3': {'X2D': -0.2744, 'Y2D': -0.3467, 'X3D': -0.4591, 'Y3D': -0.58,
           'Z3D': 0.673},
    'P3H': {'X2D': -0.2038, 'Y2D': -0.3369, 'X3D': -0.3529, 'Y3D': -0.5833,
            'Z3D': 0.7316},
    'P4': {'X2D': 0.2744, 'Y2D': -0.3467, 'X3D': 0.4591, 'Y3D': -0.58,
           'Z3D': 0.673},
    'P4H': {'X2D': 0.2038, 'Y2D': -0.3369, 'X3D': 0.3529, 'Y3D': -0.5833,
            'Z3D': 0.7316},
    'P5': {'X2D': -0.4234, 'Y2D': -0.3771, 'X3D': -0.6408, 'Y3D': -0.5708,
           'Z3D': 0.5135},
    'P5H': {'X2D': -0.3474, 'Y2D': -0.3599, 'X3D': -0.5557, 'Y3D': -0.5758,
            'Z3D': 0.5998},
    'P6': {'X2D': 0.4234, 'Y2D': -0.3771, 'X3D': 0.6408, 'Y3D': -0.5708,
           'Z3D': 0.5135},
    'P6H': {'X2D': 0.3474, 'Y2D': -0.3599, 'X3D': 0.5557, 'Y3D': -0.5758,
            'Z3D': 0.5998},
    'P7': {'X2D': -0.5879, 'Y2D': -0.427, 'X3D': -0.7695, 'Y3D': -0.559,
           'Z3D': 0.309},
    'P7H': {'X2D': -0.5032, 'Y2D': -0.3992, 'X3D': -0.7125, 'Y3D': -0.5652,
            'Z3D': 0.4159},
    'P8': {'X2D': 0.5879, 'Y2D': -0.427, 'X3D': 0.7695, 'Y3D': -0.559,
           'Z3D': 0.309},
    'P8H': {'X2D': 0.5032, 'Y2D': -0.3992, 'X3D': 0.7125, 'Y3D': -0.5652,
            'Z3D': 0.4159},
    'P9': {'X2D': -0.809, 'Y2D': -0.5878, 'X3D': -0.809, 'Y3D': -0.5878,
           'Z3D': 0.0},
    'P9H': {'X2D': -0.691, 'Y2D': -0.5021, 'X3D': -0.7991, 'Y3D': -0.5806,
            'Z3D': 0.1564},
    'PO1': {'X2D': -0.1025, 'Y2D': -0.5139, 'X3D': -0.1608, 'Y3D': -0.8064,
            'Z3D': 0.5692},
    'PO10': {'X2D': 0.5878, 'Y2D': -0.809, 'X3D': 0.5878, 'Y3D': -0.809,
             'Z3D': 0.0},
    'PO10H': {'X2D': 0.5021, 'Y2D': -0.691, 'X3D': 0.5806, 'Y3D': -0.7991,
              'Z3D': 0.1564},
    'PO1H': {'X2D': -0.0512, 'Y2D': -0.5105, 'X3D': -0.081, 'Y3D': -0.8083,
             'Z3D': 0.5832},
    'PO2': {'X2D': 0.1025, 'Y2D': -0.5139, 'X3D': 0.1608, 'Y3D': -0.8064,
            'Z3D': 0.5692},
    'PO2H': {'X2D': 0.0512, 'Y2D': -0.5105, 'X3D': 0.081, 'Y3D': -0.8083,
             'Z3D': 0.5832},
    'PO3': {'X2D': -0.2067, 'Y2D': -0.5274, 'X3D': -0.313, 'Y3D': -0.7986,
            'Z3D': 0.5142},
    'PO3H': {'X2D': -0.1543, 'Y2D': -0.5194, 'X3D': -0.2385, 'Y3D': -0.8031,
             'Z3D': 0.5461},
    'PO4': {'X2D': 0.2067, 'Y2D': -0.5274, 'X3D': 0.313, 'Y3D': -0.7986,
            'Z3D': 0.5142},
    'PO4H': {'X2D': 0.1543, 'Y2D': -0.5194, 'X3D': 0.2385, 'Y3D': -0.8031,
             'Z3D': 0.5461},
    'PO5': {'X2D': -0.3143, 'Y2D': -0.5513, 'X3D': -0.4481, 'Y3D': -0.7861,
            'Z3D': 0.4259},
    'PO5H': {'X2D': -0.26, 'Y2D': -0.5379, 'X3D': -0.3832, 'Y3D': -0.7929,
             'Z3D': 0.474},
    'PO6': {'X2D': 0.3143, 'Y2D': -0.5513, 'X3D': 0.4481, 'Y3D': -0.7861,
            'Z3D': 0.4259},
    'PO6H': {'X2D': 0.26, 'Y2D': -0.5379, 'X3D': 0.3832, 'Y3D': -0.7929,
             'Z3D': 0.474},
    'PO7': {'X2D': -0.427, 'Y2D': -0.5879, 'X3D': -0.559, 'Y3D': -0.7695,
            'Z3D': 0.309},
    'PO7H': {'X2D': -0.3699, 'Y2D': -0.5678, 'X3D': -0.507, 'Y3D': -0.7782,
             'Z3D': 0.3706},
    'PO8': {'X2D': 0.427, 'Y2D': -0.5879, 'X3D': 0.559, 'Y3D': -0.7695,
            'Z3D': 0.309},
    'PO8H': {'X2D': 0.3699, 'Y2D': -0.5678, 'X3D': 0.507, 'Y3D': -0.7782,
             'Z3D': 0.3706},
    'PO9': {'X2D': -0.5878, 'Y2D': -0.809, 'X3D': -0.5878, 'Y3D': -0.809,
            'Z3D': 0.0},
    'PO9H': {'X2D': -0.5021, 'Y2D': -0.691, 'X3D': -0.5806, 'Y3D': -0.7991,
             'Z3D': 0.1564},
    'POO1': {'X2D': -0.0803, 'Y2D': -0.6148, 'X3D': -0.116, 'Y3D': -0.8882,
             'Z3D': 0.4446},
    'POO10': {'X2D': 0.454, 'Y2D': -0.891, 'X3D': 0.454, 'Y3D': -0.891,
              'Z3D': 0.0},
    'POO10H': {'X2D': 0.3878, 'Y2D': -0.761, 'X3D': 0.4484, 'Y3D': -0.88,
               'Z3D': 0.1564},
    'POO1H': {'X2D': -0.0401, 'Y2D': -0.6133, 'X3D': -0.0582, 'Y3D': -0.8903,
              'Z3D': 0.4517},
    'POO2': {'X2D': 0.0803, 'Y2D': -0.6148, 'X3D': 0.116, 'Y3D': -0.8882,
             'Z3D': 0.4446},
    'POO2H': {'X2D': 0.0401, 'Y2D': -0.6133, 'X3D': 0.0582, 'Y3D': -0.8903,
              'Z3D': 0.4517},
    'POO3': {'X2D': -0.1615, 'Y2D': -0.621, 'X3D': -0.2288, 'Y3D': -0.8798,
             'Z3D': 0.4167},
    'POO3H': {'X2D': -0.1207, 'Y2D': -0.6174, 'X3D': -0.173, 'Y3D': -0.8847,
              'Z3D': 0.4329},
    'POO4': {'X2D': 0.1615, 'Y2D': -0.621, 'X3D': 0.2288, 'Y3D': -0.8798,
             'Z3D': 0.4167},
    'POO4H': {'X2D': 0.1207, 'Y2D': -0.6174, 'X3D': 0.173, 'Y3D': -0.8847,
              'Z3D': 0.4329},
    'POO5': {'X2D': -0.2443, 'Y2D': -0.6317, 'X3D': -0.335, 'Y3D': -0.8661,
             'Z3D': 0.3711},
    'POO5H': {'X2D': -0.2027, 'Y2D': -0.6258, 'X3D': -0.2829, 'Y3D': -0.8736,
              'Z3D': 0.396},
    'POO6': {'X2D': 0.2443, 'Y2D': -0.6317, 'X3D': 0.335, 'Y3D': -0.8661,
             'Z3D': 0.3711},
    'POO6H': {'X2D': 0.2027, 'Y2D': -0.6258, 'X3D': 0.2829, 'Y3D': -0.8736,
              'Z3D': 0.396},
    'POO7': {'X2D': -0.3299, 'Y2D': -0.6474, 'X3D': -0.4318, 'Y3D': -0.8474,
             'Z3D': 0.309},
    'POO7H': {'X2D': -0.2867, 'Y2D': -0.6388, 'X3D': -0.3848, 'Y3D': -0.8573,
              'Z3D': 0.342},
    'POO8': {'X2D': 0.3299, 'Y2D': -0.6474, 'X3D': 0.4318, 'Y3D': -0.8474,
             'Z3D': 0.309},
    'POO8H': {'X2D': 0.2867, 'Y2D': -0.6388, 'X3D': 0.3848, 'Y3D': -0.8573,
              'Z3D': 0.342},
    'POO9': {'X2D': -0.454, 'Y2D': -0.891, 'X3D': -0.454, 'Y3D': -0.891,
             'Z3D': 0.0},
    'POO9H': {'X2D': -0.3878, 'Y2D': -0.761, 'X3D': -0.4484, 'Y3D': -0.88,
              'Z3D': 0.1564},
    'POOZ': {'X2D': 0.0, 'Y2D': -0.6128, 'X3D': 0.0, 'Y3D': -0.891,
             'Z3D': 0.454},
    'POZ': {'X2D': 0.0, 'Y2D': -0.5095, 'X3D': 0.0, 'Y3D': -0.809,
            'Z3D': 0.5878},
    'PPO1': {'X2D': -0.1207, 'Y2D': -0.4195, 'X3D': -0.2028, 'Y3D': -0.7047,
             'Z3D': 0.6799},
    'PPO10': {'X2D': 0.7071, 'Y2D': -0.7071, 'X3D': 0.7071, 'Y3D': -0.7071,
              'Z3D': 0.0},
    'PPO10H': {'X2D': 0.6039, 'Y2D': -0.6039, 'X3D': 0.6984, 'Y3D': -0.6984,
               'Z3D': 0.1564},
    'PPO1H': {'X2D': -0.0602, 'Y2D': -0.4155, 'X3D': -0.1023, 'Y3D': -0.7065,
              'Z3D': 0.7003},
    'PPO2': {'X2D': 0.1207, 'Y2D': -0.4195, 'X3D': 0.2028, 'Y3D': -0.7047,
             'Z3D': 0.6799},
    'PPO2H': {'X2D': 0.0602, 'Y2D': -0.4155, 'X3D': 0.1023, 'Y3D': -0.7065,
              'Z3D': 0.7003},
    'PPO3': {'X2D': -0.2444, 'Y2D': -0.4361, 'X3D': -0.3911, 'Y3D': -0.6978,
             'Z3D': 0.6001},
    'PPO3H': {'X2D': -0.182, 'Y2D': -0.4263, 'X3D': -0.2997, 'Y3D': -0.7018,
              'Z3D': 0.6463},
    'PPO4': {'X2D': 0.2444, 'Y2D': -0.4361, 'X3D': 0.3911, 'Y3D': -0.6978,
             'Z3D': 0.6001},
    'PPO4H': {'X2D': 0.182, 'Y2D': -0.4263, 'X3D': 0.2997, 'Y3D': -0.7018,
              'Z3D': 0.6463},
    'PPO5': {'X2D': -0.3743, 'Y2D': -0.4661, 'X3D': -0.5515, 'Y3D': -0.6868,
             'Z3D': 0.4734},
    'PPO5H': {'X2D': -0.3084, 'Y2D': -0.4493, 'X3D': -0.4756, 'Y3D': -0.6928,
              'Z3D': 0.5421},
    'PPO6': {'X2D': 0.3743, 'Y2D': -0.4661, 'X3D': 0.5515, 'Y3D': -0.6868,
             'Z3D': 0.4734},
    'PPO6H': {'X2D': 0.3084, 'Y2D': -0.4493, 'X3D': 0.4756, 'Y3D': -0.6928,
              'Z3D': 0.5421},
    'PPO7': {'X2D': -0.5138, 'Y2D': -0.5138, 'X3D': -0.6725, 'Y3D': -0.6725,
             'Z3D': 0.309},
    'PPO7H': {'X2D': -0.4426, 'Y2D': -0.4874, 'X3D': -0.6175, 'Y3D': -0.68,
              'Z3D': 0.3953},
    'PPO8': {'X2D': 0.5138, 'Y2D': -0.5138, 'X3D': 0.6725, 'Y3D': -0.6725,
             'Z3D': 0.309},
    'PPO8H': {'X2D': 0.4426, 'Y2D': -0.4874, 'X3D': 0.6175, 'Y3D': -0.68,
              'Z3D': 0.3953},
    'PPO9': {'X2D': -0.7071, 'Y2D': -0.7071, 'X3D': -0.7071, 'Y3D': -0.7071,
             'Z3D': 0.0},
    'PPO9H': {'X2D': -0.6039, 'Y2D': -0.6039, 'X3D': -0.6984, 'Y3D': -0.6984,
              'Z3D': 0.1564},
    'PPOZ': {'X2D': 0.0, 'Y2D': -0.4142, 'X3D': 0.0, 'Y3D': -0.7071,
             'Z3D': 0.7071},
    'PZ': {'X2D': 0.0, 'Y2D': -0.3249, 'X3D': 0.0, 'Y3D': -0.5878,
           'Z3D': 0.809},
    'RPA': {'X2D': 1.0, 'Y2D': 0.0, 'X3D': 1.0, 'Y3D': 0.0, 'Z3D': 0.0},
    'T10': {'X2D': 1.0, 'Y2D': 0.0, 'X3D': 1.0, 'Y3D': 0.0, 'Z3D': 0.0},
    'T10H': {'X2D': 0.8541, 'Y2D': 0.0, 'X3D': 0.9877, 'Y3D': 0.0,
             'Z3D': 0.1564},
    'T7': {'X2D': -0.7266, 'Y2D': 0.0, 'X3D': -0.9511, 'Y3D': 0.0,
           'Z3D': 0.309},
    'T7H': {'X2D': -0.6128, 'Y2D': 0.0, 'X3D': -0.891, 'Y3D': 0.0,
            'Z3D': 0.454},
    'T8': {'X2D': 0.7266, 'Y2D': 0.0, 'X3D': 0.9511, 'Y3D': 0.0, 'Z3D': 0.309},
    'T8H': {'X2D': 0.6128, 'Y2D': 0.0, 'X3D': 0.891, 'Y3D': 0.0, 'Z3D': 0.454},
    'T9': {'X2D': -1.0, 'Y2D': 0.0, 'X3D': -1.0, 'Y3D': 0.0, 'Z3D': 0.0},
    'T9H': {'X2D': -0.8541, 'Y2D': 0.0, 'X3D': -0.9877, 'Y3D': 0.0,
            'Z3D': 0.1564},
    'TP10': {'X2D': 0.9511, 'Y2D': -0.309, 'X3D': 0.9511, 'Y3D': -0.309,
             'Z3D': 0.0},
    'TP10H': {'X2D': 0.8123, 'Y2D': -0.2639, 'X3D': 0.9394, 'Y3D': -0.3052,
              'Z3D': 0.1564},
    'TP7': {'X2D': -0.691, 'Y2D': -0.2245, 'X3D': -0.9045, 'Y3D': -0.2939,
            'Z3D': 0.309},
    'TP7H': {'X2D': -0.5852, 'Y2D': -0.2057, 'X3D': -0.8452, 'Y3D': -0.2971,
             'Z3D': 0.4443},
    'TP8': {'X2D': 0.691, 'Y2D': -0.2245, 'X3D': 0.9045, 'Y3D': -0.2939,
            'Z3D': 0.309},
    'TP8H': {'X2D': 0.5852, 'Y2D': -0.2057, 'X3D': 0.8452, 'Y3D': -0.2971,
             'Z3D': 0.4443},
    'TP9': {'X2D': -0.9511, 'Y2D': -0.309, 'X3D': -0.9511, 'Y3D': -0.309,
            'Z3D': 0.0},
    'TP9H': {'X2D': -0.8123, 'Y2D': -0.2639, 'X3D': -0.9394, 'Y3D': -0.3052,
             'Z3D': 0.1564},
    'TPP10': {'X2D': 0.891, 'Y2D': -0.454, 'X3D': 0.891, 'Y3D': -0.454,
              'Z3D': 0.0},
    'TPP10H': {'X2D': 0.761, 'Y2D': -0.3878, 'X3D': 0.88, 'Y3D': -0.4484,
               'Z3D': 0.1564},
    'TPP7': {'X2D': -0.6474, 'Y2D': -0.3299, 'X3D': -0.8474, 'Y3D': -0.4318,
             'Z3D': 0.309},
    'TPP7H': {'X2D': -0.5509, 'Y2D': -0.3048, 'X3D': -0.789, 'Y3D': -0.4365,
              'Z3D': 0.4323},
    'TPP8': {'X2D': 0.6474, 'Y2D': -0.3299, 'X3D': 0.8474, 'Y3D': -0.4318,
             'Z3D': 0.309},
    'TPP8H': {'X2D': 0.5509, 'Y2D': -0.3048, 'X3D': 0.789, 'Y3D': -0.4365,
              'Z3D': 0.4323},
    'TPP9': {'X2D': -0.891, 'Y2D': -0.454, 'X3D': -0.891, 'Y3D': -0.454,
             'Z3D': 0.0},
    'TPP9H': {'X2D': -0.761, 'Y2D': -0.3878, 'X3D': -0.88, 'Y3D': -0.4484,
              'Z3D': 0.1564},
    'TTP10': {'X2D': 0.9877, 'Y2D': -0.1564, 'X3D': 0.9877, 'Y3D': -0.1564,
              'Z3D': 0.0},
    'TTP10H': {'X2D': 0.8436, 'Y2D': -0.1336, 'X3D': 0.9755, 'Y3D': -0.1545,
               'Z3D': 0.1564},
    'TTP7': {'X2D': -0.7176, 'Y2D': -0.1137, 'X3D': -0.9394, 'Y3D': -0.1488,
             'Z3D': 0.309},
    'TTP7H': {'X2D': -0.6059, 'Y2D': -0.1036, 'X3D': -0.8795, 'Y3D': -0.1504,
              'Z3D': 0.4515},
    'TTP8': {'X2D': 0.7176, 'Y2D': -0.1137, 'X3D': 0.9394, 'Y3D': -0.1488,
             'Z3D': 0.309},
    'TTP8H': {'X2D': 0.6059, 'Y2D': -0.1036, 'X3D': 0.8795, 'Y3D': -0.1504,
              'Z3D': 0.4515},
    'TTP9': {'X2D': -0.9877, 'Y2D': -0.1564, 'X3D': -0.9877, 'Y3D': -0.1564,
             'Z3D': 0.0},
    'TTP9H': {'X2D': -0.8436, 'Y2D': -0.1336, 'X3D': -0.9755, 'Y3D': -0.1545,
              'Z3D': 0.1564}}


class EEGChannelSet(components.SerializableComponent):
    """Class to represent an EEG montage with ordered channels in specific
    coordinates. It also provides functionality to load channels from EEG
    standards 10-20, 10-10 and 10-5 directly from the labels.
    """

    def __init__(self, reference_method='common', dim='2D',
                 coord_system='spherical'):
        """Constructor of class EEGChannelSet

        Parameters
        ----------
        reference_method: str {'common'|'average'|'bipolar'}
            Reference method. Recordings with common reference are referenced
            to the same channel (e.g., ear lobe, mastoid). Recordings with
            average reference are referenced to the average of all or several
            channels. Finally, bipolar reference is the subtraction of 2
            channels.
        dim: str {'2D'|'3D'}
            Dimensions of the coordinates plane.
        coord_system: str {'cartesian'|'spherical'}
            Coordinates system. Take into account that, if dim = '2D' spherical
            refers to polar coordinates
        """

        # Check errors
        if reference_method not in ('common', 'average', 'bipolar'):
            raise ValueError('Unknown reference method %s' % reference_method)
        if dim not in ('2D', '3D'):
            raise ValueError('Unknown number of dimensions %s' % dim)
        if coord_system not in ('cartesian', 'spherical'):
            raise ValueError('Unknown coordinates system %s' % coord_system)

        # Set attributes
        self.reference_method = reference_method
        self.dim = dim
        self.coord_system = coord_system
        self.channels = None
        self.n_cha = None
        self.l_cha = None
        self.ground = None

    def get_standard_channel_data_from_label(self, label, standard='10-5'):
        """Returns the channel data given the label and an EEG standard

        Parameters
        ----------
        label: str
            Channel label
        standard: str or dict, optional
            EEG standard with the channel coordinates. Included standards are
            {'10-20'|'10-10'|'10-05'}, but you can use a custom one.
        """
        # Select standard
        if isinstance(standard, str):
            if standard == '10-20':
                standard_data = eeg_1020.copy()
            elif standard == '10-10':
                standard_data = eeg_1010.copy()
            else:
                standard_data = eeg_1005.copy()
        else:
            standard_data = standard
        # Check error
        if label not in standard_data:
            raise UnknownStandardChannel(
                'Unkown standard channel with label %s' % label)
        cha_data = {'label': label}
        if self.dim == '2D':
            if self.coord_system == 'cartesian':
                cha_data['x'] = standard_data[label]['X2D']
                cha_data['y'] = standard_data[label]['Y2D']
            else:
                cha_data['r'] = math.sqrt(
                    math.pow(standard_data[label]['X2D'], 2) +
                    math.pow(standard_data[label]['Y2D'], 2))
                cha_data['theta'] = math.atan2(standard_data[label]['Y2D'],
                                               standard_data[label]['X2D'])
        else:
            if self.coord_system == 'cartesian':
                cha_data['x'] = standard_data[label]['X3D']
                cha_data['y'] = standard_data[label]['Y3D']
                cha_data['z'] = standard_data[label]['Z3D']
            else:
                cha_data['r'] = math.sqrt(
                    math.pow(standard_data[label]['X3D'], 2) +
                    math.pow(standard_data[label]['Y3D'], 2) +
                    math.pow(standard_data[label]['Z3D'], 2))
                cha_data['theta'] = math.atan2(
                    math.sqrt(math.pow(standard_data[label]['X3D'], 2) +
                              math.pow(standard_data[label]['Y3D'], 2)),
                    standard_data[label]['Z3D']
                )
                cha_data['phi'] = math.atan2(standard_data[label]['Y2D'],
                                             standard_data[label]['X2D'])
        return cha_data

    def set_ground(self, ground):
        """Sets the ground of the montage

        Parameters
        ----------
        ground: dict
            Dict with the ground data. The easiest way to calculate it is using
            function get_standard_channel_data_from_label. Keys:
                - label: channel label
                - coordinates: depends on the coordinate system and dimensions:
                        - Dim = 2D:
                            - Cartesian coordinates. Ex: {'x': 0.5, 'y': 0}
                            - Spherical coordinates Ex: {'r': 0.5,
                                'theta': np.pi/2}
                        - Dim = 3D:
                            - Cartesian coordinates. Ex: {'x': 0.5,
                                'y': 0, 'z': 0.8}
                            - Spherical coordinates. Ex: {'r': 0.5,
                                'theta': np.pi/2, 'phi': np.pi/4}
        """
        self.ground = ground

    def add_channel(self, channel, reference):
        """Function to add a channel to the end of the current montage.
        Take into account that the order of the channels is important!

        Parameters
        ----------
        channel: dict
            Dict with the channel data. The easiest way to calculate it is using
            function get_standard_channel_data_from_label. Keys:
                - label: channel label
                - coordinates: depends on the coordinate system and dimensions:
                        - Dim = 2D:
                            - Cartesian coordinates. Ex: {'x': 0.5, 'y': 0}
                            - Spherical coordinates Ex: {'r': 0.5,
                                'theta': np.pi/2}
                        - Dim = 3D:
                            - Cartesian coordinates. Ex: {'x': 0.5,
                                'y': 0, 'z': 0.8}
                            - Spherical coordinates. Ex: {'r': 0.5,
                                'theta': np.pi/2, 'phi': np.pi/4}
        reference: dict, list of dicts or str, optional
            For common and bipolar reference modes, reference must be a dict
            with the label and coordinates of the reference. For average
            reference, it can be 'all' to indicate a common average
            reference, or a list of dicts (with label and coordinates) of the
            averaged reference for each channel

        See Also
        --------
        get_standard_channel_data_from_label: returns channel data given the
            channel label and the standard. It can also be used to get the
            reference data
        """
        # TODO: check input
        channel['reference'] = reference
        channels = list() if self.channels is None else self.channels
        channels.append(channel)
        # Check channels
        self.__check_channels(channels)
        # Store attributes
        self.channels = channels
        self.n_cha = len(self.channels)
        self.l_cha = [cha['label'] for cha in self.channels]

    def set_custom_montage(self, channels, ground=None):
        """Sets a custom montage, overwriting the previous one. Add single
        channels more easily using function add_custom_channel and
        add_standard_channel.

        Parameters
        ----------
        channels : list
            List of dicts, each of them representing a channel. The dict must
            contain the label, coordinates according to parameters dim an
            coord_system, and reference. For common reference mode,
            the reference must be a single channel with label and
            coordinates. For average reference mode, reference can be a list
            of dicts with the channels (label and coordinates) or "all",
            to specify common average reference. For bipolar reference mode, the
            reference must be a single channel with label and coordinates. In
            all cases you can set the reference to None, but this is not
            recommended.
        ground : dict
            Dict containing the label and coordinates of the ground electrode

        See Also
        --------
        set_standard_montage: preferred choice in most cases
        """
        # Check errors
        self.__check_channels(channels, ground)
        # Set attributes
        self.channels = channels
        self.ground = ground
        self.n_cha = len(self.channels)
        self.l_cha = [cha['label'] for cha in self.channels]

    def set_standard_montage(self, l_cha=None, l_reference=None, l_ground=None,
                             standard='10-05', drop_landmarks=True):

        """Set standard EEG channels with common reference. In 3 dimensions,
        the equator is taken a Nz-T10-Iz-T9.

        Parameters
        ----------
        l_cha : list, optional
            List of channels labels. The data will be returned keeping the
            same order. If None, all system channels will be returned in
            standard order
        l_reference : str, optional
            Label of the reference. Usual choices are left preauricular point
            (LPA) and right preauricular point (RPA). Leave to None if you do
            not want to specify the reference (not recommended)
        l_ground : str, optional
            Label of the ground. Usual choices are AFz or FPz.
        standard : str {'10-20'|'10-10'|'10-05'}
            EEG standard
        drop_landmarks : bool
            Drop landmarks: nasion (NAS), left preauricular point (LPA) and
            right preauricular point (RPA)
        """
        # Check errors
        if self.reference_method != 'common':
            raise ValueError('Function set_standard_channels is available '
                             'only for recordings with common reference. For '
                             'custom montages use set_custom_channels')
        # Some stupid comment
        assert standard == '10-20' or \
               standard == '10-10' or \
               standard == '10-05', \
            'Incorrect input on standard parameter'
        assert self.dim == '2D' or self.dim == '3D', \
            'Incorrect input on dim parameter'
        assert self.coord_system == 'cartesian' or \
               self.coord_system == 'spherical', \
            'Incorrect input on coord_system parameter'
        # Select standard
        if standard == '10-20':
            standard_data = eeg_1020.copy()
        elif standard == '10-10':
            standard_data = eeg_1010.copy()
        else:
            standard_data = eeg_1005.copy()
        # Get list of labels to get
        l_cha = standard_data.keys() if l_cha is None \
            else [l.upper() for l in l_cha]
        # Reference
        if l_reference is not None:
            reference = self.get_standard_channel_data_from_label(
                l_reference, standard_data)
        else:
            reference = None
        # Get channels
        channels = list()
        for l_channel in l_cha:
            # Drop landmarks
            if drop_landmarks:
                if l_channel in ('NAS', 'LPA', 'RPA'):
                    continue
            # Append info
            channel_data = self.get_standard_channel_data_from_label(
                l_channel, standard_data)
            channel_data['reference'] = reference
            channels.append(channel_data)
        # Ground
        if l_ground is not None:
            ground = self.get_standard_channel_data_from_label(
                l_ground, standard_data)
        else:
            ground = None
        # Check channels
        self.__check_channels(channels, ground)
        # Store attributes
        self.channels = channels
        self.ground = ground
        self.n_cha = len(self.channels)
        self.l_cha = [cha['label'] for cha in self.channels]

    def __check_channels(self, channels, ground=None):
        # Get mandatory keys for each dim and coord_system
        if self.dim == '2D':
            if self.coord_system == 'cartesian':
                keys = ['label', 'x', 'y']
            else:
                keys = ['label', 'r', 'theta']
        else:
            if self.coord_system == 'cartesian':
                keys = ['label', 'x', 'y', 'z']
            else:
                keys = ['label', 'r', 'theta', 'phi']
        # Check keys
        references = list()
        for cha in channels:
            # Check channel keys
            cha_keys = keys + ['reference']
            if not all(k in cha for k in keys):
                raise ValueError('Malformed channel %s. Dict keys must be %s' %
                                 (str(cha), str(cha_keys)))

            # Check reference
            reference = cha['reference']
            references.append(reference)
            if reference is not None:
                if self.reference_method == 'common':
                    # Single reference
                    assert isinstance(reference, dict), \
                        'Reference must be of type dict'
                    if not all(k in reference for k in keys):
                        raise ValueError('Malformed reference in channel %s. '
                                         'Reference keys must be %s' %
                                         (str(cha), str(keys)))
                    # All references must be identical
                    if not all(ref == references[0] for ref in references):
                        raise ValueError('All references must be identical '
                                         'in common reference mode')
                elif self.reference_method == 'average':
                    # Average reference
                    assert isinstance(reference, list), \
                        'Reference must be None or list of dicts'
                    if isinstance(reference, list):
                        for r in reference:
                            if not all(k in r for k in keys):
                                raise ValueError('Malformed reference in '
                                                 'channel %s. Reference keys '
                                                 'must be %s' %
                                                 (str(cha), str(keys)))
                elif self.reference_method == 'bipolar':
                    # Single reference
                    assert isinstance(reference, dict), \
                        'Reference must be of type dict'
                    if not all(k in reference for k in keys):
                        raise ValueError('Malformed reference in channel %s. '
                                         'Reference keys must be %s' %
                                         (str(cha), str(keys)))

        if ground is not None:
            if not all(k in ground for k in keys):
                raise ValueError('Malformed ground. Dict keys must be %s' %
                                 (str(keys)))

    def get_cha_idx_from_labels(self, labels):
        """Returns the position of the channels given the labels

        Parameters
        ----------
         labels : list
            Labels to check. The order matters

        Returns
        -------
        indexes : np.ndarray
            Indexes of the channels in the set
        """
        return [self.l_cha.index(l) for l in labels]

    def check_channels_labels(self, labels, strict=False):
        """Checks the order and labels of the channels

        Parameters
        ----------
        labels : list
            Labels to check. The order matters
        strict : bool
            If True, comparison is strict. The function will check that the
            channel set contains the channels given by parameter labels and
            in the same order. If false, the function checks that the
            channels are contained in the channel set, but they could be in
            different order and the set could contain more channels

        Returns
        -------
        check : bool
            True if the labels and order are the same. False otherwise
        """
        if strict:
            check = True
            for i in range(len(labels)):
                if self.l_cha[i] != labels[i]:
                    check = False
        else:
            check = True
            for l in labels:
                if l not in self.l_cha:
                    check = False
        return check

    def subset(self, cha_idx):
        """Selects the channels given the indexes, creating a subset. The
        order of the channels will be updated

        Parameters
        ----------
        cha_idx : np.ndarray
            Indexes of the channels to select. The order matters
        """
        self.channels = [self.channels[idx] for idx in cha_idx]
        self.n_cha = len(self.channels)
        self.l_cha = [cha['label'] for cha in self.channels]

    def sort_nearest_channels(self):
        """ Sorts the nearest channels for each possible channel
        Return
        ----------
        sorted_dist_ch: dict()
            Dictionary that includes, for each channel (as a key), the rest
            of channels sorted by its closeness to that channel.
        """
        # TODO: Añadir la opción de hacer un sort de una coordenada específica, o en otra función
        if not self.channels:
            raise Exception(
                'Cannot compute the nearest channels if channel set '
                'is not initialized!')

        # Compute distance matrix
        dist_matrix = self.compute_dist_matrix()

        # Create the dictionary and format it
        sorted_dist_ch = dict()
        for i, label in enumerate(self.l_cha):
            d_sorted = np.sort(dist_matrix[i, :])
            idx_sorted = np.argsort(dist_matrix[i, :])
            if d_sorted[0] != 0:
                raise Exception('[meeg/EEGChannelSet/sort_nearest_channels] '
                                'Something ocurred, distance between the same '
                                'channel is not zero!')
            sorted_dist_ch[label] = []
            for j in range(1, len(d_sorted)):
                sorted_dist_ch[label].append({
                    "dist": d_sorted[j],
                    "channel": self.channels[idx_sorted[j]]
                })
        return sorted_dist_ch

    def compute_dist_matrix(self):
        """ This function computes the distances between all channels in the
        channel set and stores them into a matrix.

        Returns
        -------------
        dist_matrix:    ndarray of dimensions [ncha x ncha]
            Distances between all the channels.
        """
        if not self.channels:
            raise Exception(
                'Cannot compute the distance matrix if channel set '
                'is not initialized!')
        # Instantiate matrix of distances
        dist_matrix = np.empty((self.n_cha, self.n_cha))

        # For 2D coordinates
        if self.dim == '2D':
            if self.coord_system == 'cartesian':
                for i, cha in enumerate(self.channels):
                    # Find location of channel
                    cha_pos = np.array([cha['x'], cha['y']])
                    # Find the location of the rest of the channels
                    for j, temp_cha in enumerate(self.channels):
                        temp_cha_pos = np.array(
                            [temp_cha['x'], temp_cha['y']]
                        )
                        d = np.sqrt(np.sum(np.power(temp_cha_pos - cha_pos, 2)))
                        dist_matrix[i, j] = d
            elif self.coord_system == 'spherical':
                for i, cha in enumerate(self.channels):
                    # Find location of channel
                    r_cha, theta_cha = cha['r'], cha['theta']
                    # Find the location of the rest of the channels
                    for j, temp_cha in enumerate(self.channels):
                        r_temp_cha, theta_temp_cha = temp_cha['r'], temp_cha['theta']
                        d = np.abs(np.sqrt(r_cha ** 2 + r_temp_cha ** 2 -
                                           2 * r_cha * r_temp_cha *
                                           np.cos(theta_temp_cha -
                                                  theta_cha)))
                        dist_matrix[i, j] = d
        # For 3D coordinates
        elif self.dim == '3D':
            if self.coord_system == 'cartesian':
                for i, cha in enumerate(self.channels):
                    # Find location of channel
                    cha_pos = np.array([cha['x'], cha['y'], cha['z']])
                    # Find the location of the rest of the channels
                    for j, temp_cha in enumerate(self.channels):
                        temp_cha_pos = np.array(
                            [temp_cha['x'], temp_cha['y'], temp_cha['z']]
                        )
                        d = np.sqrt(np.sum(np.power(temp_cha_pos - cha_pos, 2)))
                        dist_matrix[i, j] = d
            elif self.coord_system == 'spherical':
                for i, cha in enumerate(self.channels):
                    # Find location of channel
                    r_cha, theta_cha, phi_cha = cha['r'], cha['theta'], cha['phi']
                    # Find the location of the rest of the channels
                    for j, temp_cha in enumerate(self.channels):
                        r_temp_cha, theta_temp_cha, phi_temp_cha = temp_cha['r'], temp_cha['theta'], \
                                                                   temp_cha['phi']
                        d = np.abs(np.sqrt(r_cha ** 2 + r_temp_cha ** 2 -
                                           2 * r_cha * r_temp_cha * (
                                                   np.sin(theta_cha) * np.sin(theta_temp_cha) *
                                                   np.cos(phi_cha - phi_temp_cha) +
                                                   np.cos(theta_temp_cha) * np.cos(theta_cha))
                                           )
                                   )
                        dist_matrix[i, j] = d
        return dist_matrix


    def to_dict(self):
        """Converts the class in a serializable dict

        Returns
        -------
        eeg_channel_set : dict
            Serializable dict with the class attributes
        """
        return self.__dict__

    @staticmethod
    def from_dict(dict_data):
        """Instantiates the class from a serializable dict

        Returns
        -------
        eeg_channel_set : EEGChannelSet
            EEGChannelSet instance
        """
        channel_set = EEGChannelSet(dim=dict_data['dim'],
                                    coord_system=dict_data['coord_system'])

        channel_set.set_custom_montage(channels=dict_data['channels'],
                                       ground=dict_data['ground'])

        return channel_set

    def to_serializable_obj(self):
        return self.__dict__

    @classmethod
    def from_serializable_obj(cls, dict_data):
        inst = cls()
        inst.__dict__.update(dict_data)
        return inst


class MEGChannelSet(components.SerializableComponent):

    # TODO
    def __init__(self):
        self.channels = None
        self.n_cha = None
        self.l_cha = None

    def to_serializable_obj(self):
        return self.__dict__

    @classmethod
    def from_serializable_obj(cls, dict_data):
        inst = cls()
        inst.__dict__.update(dict_data)
        return inst


class EEG(components.Biosignal):
    """Electroencephalography (EEG) biosignal
    """

    def __init__(self, times, signal, fs, channel_set, **kwargs):
        """EEG constructor

        Parameters
        ----------
        times : list or numpy.ndarray
            1D numpy array [n_samples]. Timestamps of each sample. If they are
            not available, generate them
            artificially. Nevertheless, all signals and events must have the
            same temporal origin
        signal : list or numpy.ndarray
            2D numpy array [n_samples x n_channels]. EEG samples (the units
            should be defined using kwargs)
        fs : int or float
            Sample rate of the recording.
        channel_set : meeg_standards.EEGChannelSet
            EEG channel set
        kwargs: kwargs
            Any other parameter provided will be saved in the class (e.g.,
            equipment description)
        """
        # To numpy arrays
        times = np.array(times)
        signal = np.array(signal)
        # Check errors
        if signal.shape[1] != channel_set.n_cha:
            raise Exception("Signal with shape [samples x channels] does not "
                            "match with the number of channels")
        if times.shape[0] != signal.shape[0]:
            raise Exception("Parameters times (shape: %s) and signal (shape: "
                            "%s) must have the same length" % (
                                str(times.shape), str(signal.shape))
                            )

        # Standard attributes
        self.times = times
        self.signal = signal
        self.fs = fs
        self.channel_set = channel_set

        # Optional attributes
        for key, value in kwargs.items():
            setattr(self, key, value)

    def change_channel_set(self, channel_set):
        """Smart change of channel set, updating the signal and all related
        attributes

        Parameters
        ----------
        channel_set : meeg_standards.EEGChannelSet
            EEG channel set
        """
        # Get the index of the channels
        cha_idx = self.channel_set.get_cha_idx_from_labels(channel_set.l_cha)
        # Select and reorganize channels channels
        self.channel_set.subset(cha_idx)
        # Reorganize signal
        self.signal = self.signal[:, cha_idx]

    def to_serializable_obj(self):
        rec_dict = self.__dict__
        for key in rec_dict.keys():
            if type(rec_dict[key]) == np.ndarray:
                rec_dict[key] = rec_dict[key].tolist()
            if type(rec_dict[key]) == EEGChannelSet:
                rec_dict[key] = rec_dict[key].to_serializable_obj()
        return rec_dict

    @classmethod
    def from_serializable_obj(cls, dict_data):
        # Load channel set dict
        dict_data['channel_set'] = EEGChannelSet.from_dict(
            dict_data['channel_set']
        )
        return cls(**dict_data)


class MEG(components.Biosignal):
    # TODO check everything

    """Magnetoencephalography (MEG) biosignal
    """

    def __init__(self, times, signal, fs, channel_set, **kwargs):
        """MEG constructor

        Parameters
        ----------
        times : list or numpy.ndarray
            1D numpy array [n_samples]. Timestamps of each sample. If they are
            not available, generate them
            artificially. Nevertheless, all signals and events must have the
            same temporal origin
        signal : list or numpy.ndarray
            2D numpy array [n_samples x n_channels]. MEG samples (the units
            should be defined using kwargs)
        fs : int or float
            Sample rate of the recording.
        channel_set : list or meeg_standards.MEGChannelSet
            MEG channel set.
        kwargs: kwargs
            Any other parameter provided will be saved in the class (e.g.,
            equipment description)
        """
        # To numpy arrays
        times = np.array(times)
        signal = np.array(signal)
        # Check errors
        if signal.shape[1] != channel_set.n_cha:
            raise Exception("Signal with shape [samples x channels] does not "
                            "match with the number of channels")
        if times.shape[0] != signal.shape[0]:
            raise Exception("Parameters times and signal must have the same "
                            "length")

        # Standard attributes
        self.times = times
        self.signal = signal
        self.fs = fs
        self.channel_set = channel_set

        # Optional attributes
        for key, value in kwargs.items():
            setattr(self, key, value)

    def change_channel_set(self, channel_set):
        """Smart change of channel set, updating the signal and all related
        attributes

        Parameters
        ----------
        channel_set : meeg_standards.MEGChannelSet
            MEG channel set
        """
        raise NotImplementedError

    def to_serializable_obj(self):
        rec_dict = self.__dict__
        for key in rec_dict.keys():
            if type(rec_dict[key]) == np.ndarray:
                rec_dict[key] = rec_dict[key].tolist()
        return rec_dict

    @classmethod
    def from_serializable_obj(cls, dict_data):
        return cls(**dict_data)

    @staticmethod
    def load_meg_signal_from_spm_file(path, fs):
        # TODO check everything

        """Function to load a MEG recording from a spm file

        Parameters
        ----------
        path : str
            Path of the file
        fs : int or float
            Sample rate of the recording
        """
        data = scipy.io.loadmat(path)
        info = data['D'][0, 0]

        datatype = info['datatype'][0]
        num_chan = np.size(info['channels'])
        num_samples = info['Nsamples'][0, 0]

        raw = np.fromfile(path[0:len(path) - 3] + 'dat',
                          datatype[0:len(datatype) - 3])
        signal = np.reshape(raw, [num_chan, num_samples], order='F')
        times = np.linspace(0, signal[0] / fs, signal[0])
        channels = None
        return MEG(times, signal, fs, channels)


class Connecitivity:
    # TODO: check everything

    """Customizable class with connectivity info from EEG/MEG recordings
    """

    def __init__(self, data, trial_len, parameter, filt_mode, **kwargs):
        """Class constructor

        Parameters
        ----------
        data : bla bla
            Bla bla
        trial_len : bla bla
            Bla bla
        parameter : bla bla
            Bla bla
        filt_mode : bla bla
            Bla bla
        kwargs
            Optional information of the EEG recording (e.g. subject, amplifier,
            etc)
        """
        # Params
        data = np.array(data)

        if not (filt_mode == 'all' or
                filt_mode == 'bands' or
                filt_mode == 'win'):
            raise ValueError("Unknown filtering mode")

        self.data = data
        self.trial_len = trial_len
        self.parameter = parameter
        self.filt_mode = filt_mode

        # Optional attributes
        for key, value in kwargs.items():
            setattr(self, key, value)


class UnknownStandardChannel(Exception):

    def __init__(self, msg=None):
        """Class constructor

        Parameters
        ----------
        msg: string or None
            Custom message
        """
        if msg is None:
            msg = 'Unknown standard channel'
        super().__init__(msg)


if __name__ == "__main__":
    # # LOAD COORDINATES FILES
    # import csv
    # data = dict()
    # # 2D coordinates
    # with open("E:/Eduardo/PythonProjects/medusa/eeg-standards/
    # NZ-T10-IZ-T9/standard_1005_2D.tsv") as tsvfile:
    #     tsvreader = csv.reader(tsvfile, delimiter="\t")
    #     for line in tsvreader:
    #         lcha = line[0].upper()
    #         if lcha == 'LABEL':
    #             continue
    #         data[lcha] = dict()
    #         data[lcha]['X2D'] = float(line[1])
    #         data[lcha]['Y2D'] = float(line[2])
    # # 3D coordinates
    # with open("E:/Eduardo/PythonProjects/medusa/eeg-standards/
    # NZ-T10-IZ-T9/standard_1005_3D.tsv") as tsvfile:
    #     tsvreader = csv.reader(tsvfile, delimiter="\t")
    #     for line in tsvreader:
    #         lcha = line[0].upper()
    #         if lcha == 'LABEL':
    #             continue
    #         data[lcha]['X3D'] = float(line[1])
    #         data[lcha]['Y3D'] = float(line[2])
    #         data[lcha]['Z3D'] = float(line[3])
    # print(str(data))

    # TOPOGRAPHIC PLOT DEMO
    import numpy as np
    from plots import topographic_plots

    cha_set = EEGChannelSet()
    cha_set.set_standard_montage(l_reference='RPA', standard='10-05')
    values = np.random.rand(len(cha_set.channels))
    topographic_plots.plot_topography(cha_set, values, plot_clabels=True)
