# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Switch(pulumi.CustomResource):
    bridge_id: pulumi.Output[str]
    """
    The bridge id attached to the Switch
    """
    description: pulumi.Output[str]
    """
    The description of the Switch. The length of this value must be in the range [`1`-`512`]
    """
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the Switch
    """
    name: pulumi.Output[str]
    """
    The name of the Switch. The length of this value must be in the range [`1`-`64`]
    """
    server_ids: pulumi.Output[list]
    """
    A list of server id connected to the switch
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the Switch
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the Switch will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, bridge_id=None, description=None, icon_id=None, name=None, tags=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Switch resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bridge_id: The bridge id attached to the Switch
        :param pulumi.Input[str] description: The description of the Switch. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] icon_id: The icon id to attach to the Switch
        :param pulumi.Input[str] name: The name of the Switch. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[list] tags: Any tags to assign to the Switch
        :param pulumi.Input[str] zone: The name of zone that the Switch will be created (e.g. `is1a`, `tk1a`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['bridge_id'] = bridge_id
            __props__['description'] = description
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['tags'] = tags
            __props__['zone'] = zone
            __props__['server_ids'] = None
        super(Switch, __self__).__init__(
            'sakuracloud:index/switch:Switch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, bridge_id=None, description=None, icon_id=None, name=None, server_ids=None, tags=None, zone=None):
        """
        Get an existing Switch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bridge_id: The bridge id attached to the Switch
        :param pulumi.Input[str] description: The description of the Switch. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] icon_id: The icon id to attach to the Switch
        :param pulumi.Input[str] name: The name of the Switch. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[list] server_ids: A list of server id connected to the switch
        :param pulumi.Input[list] tags: Any tags to assign to the Switch
        :param pulumi.Input[str] zone: The name of zone that the Switch will be created (e.g. `is1a`, `tk1a`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["bridge_id"] = bridge_id
        __props__["description"] = description
        __props__["icon_id"] = icon_id
        __props__["name"] = name
        __props__["server_ids"] = server_ids
        __props__["tags"] = tags
        __props__["zone"] = zone
        return Switch(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

