# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ProxyLBACME(pulumi.CustomResource):
    accept_tos: pulumi.Output[bool]
    """
    The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be
    set `true` explicitly
    """
    certificates: pulumi.Output[list]
    common_name: pulumi.Output[str]
    """
    The FQDN used by ACME. This must set resolvable value
    """
    proxylb_id: pulumi.Output[str]
    """
    The id of the ProxyLB that set ACME settings to
    """
    update_delay_sec: pulumi.Output[float]
    """
    The wait time in seconds. This typically used for waiting for a DNS propagation
    """
    def __init__(__self__, resource_name, opts=None, accept_tos=None, common_name=None, proxylb_id=None, update_delay_sec=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a ProxyLBACME resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accept_tos: The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be
               set `true` explicitly
        :param pulumi.Input[str] common_name: The FQDN used by ACME. This must set resolvable value
        :param pulumi.Input[str] proxylb_id: The id of the ProxyLB that set ACME settings to
        :param pulumi.Input[float] update_delay_sec: The wait time in seconds. This typically used for waiting for a DNS propagation
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if accept_tos is None:
                raise TypeError("Missing required property 'accept_tos'")
            __props__['accept_tos'] = accept_tos
            if common_name is None:
                raise TypeError("Missing required property 'common_name'")
            __props__['common_name'] = common_name
            if proxylb_id is None:
                raise TypeError("Missing required property 'proxylb_id'")
            __props__['proxylb_id'] = proxylb_id
            __props__['update_delay_sec'] = update_delay_sec
            __props__['certificates'] = None
        super(ProxyLBACME, __self__).__init__(
            'sakuracloud:index/proxyLBACME:ProxyLBACME',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, accept_tos=None, certificates=None, common_name=None, proxylb_id=None, update_delay_sec=None):
        """
        Get an existing ProxyLBACME resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accept_tos: The flag to accept the current Let's Encrypt terms of service(see: https://letsencrypt.org/repository/). This must be
               set `true` explicitly
        :param pulumi.Input[str] common_name: The FQDN used by ACME. This must set resolvable value
        :param pulumi.Input[str] proxylb_id: The id of the ProxyLB that set ACME settings to
        :param pulumi.Input[float] update_delay_sec: The wait time in seconds. This typically used for waiting for a DNS propagation

        The **certificates** object supports the following:

          * `additionalCertificates` (`pulumi.Input[list]`)
            * `intermediateCert` (`pulumi.Input[str]`)
            * `private_key` (`pulumi.Input[str]`)
            * `serverCert` (`pulumi.Input[str]`)

          * `intermediateCert` (`pulumi.Input[str]`)
          * `private_key` (`pulumi.Input[str]`)
          * `serverCert` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accept_tos"] = accept_tos
        __props__["certificates"] = certificates
        __props__["common_name"] = common_name
        __props__["proxylb_id"] = proxylb_id
        __props__["update_delay_sec"] = update_delay_sec
        return ProxyLBACME(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

