# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Disk(pulumi.CustomResource):
    connector: pulumi.Output[str]
    """
    The name of the disk connector. This must be one of [`virtio`/`ide`]
    """
    description: pulumi.Output[str]
    """
    The description of the disk. The length of this value must be in the range [`1`-`512`]
    """
    distant_froms: pulumi.Output[list]
    """
    A list of disk id. The disk will be located to different storage from these disks
    """
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the disk
    """
    name: pulumi.Output[str]
    """
    The name of the disk. The length of this value must be in the range [`1`-`64`]
    """
    plan: pulumi.Output[str]
    """
    The plan name of the disk. This must be one of [`ssd`/`hdd`]
    """
    server_id: pulumi.Output[str]
    """
    The id of the Server connected to the disk
    """
    size: pulumi.Output[float]
    """
    The size of disk in GiB
    """
    source_archive_id: pulumi.Output[str]
    """
    The id of the source archive. This conflicts with [`source_disk_id`]
    """
    source_disk_id: pulumi.Output[str]
    """
    The id of the source disk. This conflicts with [`source_archive_id`]
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the disk
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the disk will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, connector=None, description=None, distant_froms=None, icon_id=None, name=None, plan=None, size=None, source_archive_id=None, source_disk_id=None, tags=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Disk resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connector: The name of the disk connector. This must be one of [`virtio`/`ide`]
        :param pulumi.Input[str] description: The description of the disk. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[list] distant_froms: A list of disk id. The disk will be located to different storage from these disks
        :param pulumi.Input[str] icon_id: The icon id to attach to the disk
        :param pulumi.Input[str] name: The name of the disk. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] plan: The plan name of the disk. This must be one of [`ssd`/`hdd`]
        :param pulumi.Input[float] size: The size of disk in GiB
        :param pulumi.Input[str] source_archive_id: The id of the source archive. This conflicts with [`source_disk_id`]
        :param pulumi.Input[str] source_disk_id: The id of the source disk. This conflicts with [`source_archive_id`]
        :param pulumi.Input[list] tags: Any tags to assign to the disk
        :param pulumi.Input[str] zone: The name of zone that the disk will be created (e.g. `is1a`, `tk1a`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['connector'] = connector
            __props__['description'] = description
            __props__['distant_froms'] = distant_froms
            __props__['icon_id'] = icon_id
            __props__['name'] = name
            __props__['plan'] = plan
            __props__['size'] = size
            __props__['source_archive_id'] = source_archive_id
            __props__['source_disk_id'] = source_disk_id
            __props__['tags'] = tags
            __props__['zone'] = zone
            __props__['server_id'] = None
        super(Disk, __self__).__init__(
            'sakuracloud:index/disk:Disk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, connector=None, description=None, distant_froms=None, icon_id=None, name=None, plan=None, server_id=None, size=None, source_archive_id=None, source_disk_id=None, tags=None, zone=None):
        """
        Get an existing Disk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connector: The name of the disk connector. This must be one of [`virtio`/`ide`]
        :param pulumi.Input[str] description: The description of the disk. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[list] distant_froms: A list of disk id. The disk will be located to different storage from these disks
        :param pulumi.Input[str] icon_id: The icon id to attach to the disk
        :param pulumi.Input[str] name: The name of the disk. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[str] plan: The plan name of the disk. This must be one of [`ssd`/`hdd`]
        :param pulumi.Input[str] server_id: The id of the Server connected to the disk
        :param pulumi.Input[float] size: The size of disk in GiB
        :param pulumi.Input[str] source_archive_id: The id of the source archive. This conflicts with [`source_disk_id`]
        :param pulumi.Input[str] source_disk_id: The id of the source disk. This conflicts with [`source_archive_id`]
        :param pulumi.Input[list] tags: Any tags to assign to the disk
        :param pulumi.Input[str] zone: The name of zone that the disk will be created (e.g. `is1a`, `tk1a`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["connector"] = connector
        __props__["description"] = description
        __props__["distant_froms"] = distant_froms
        __props__["icon_id"] = icon_id
        __props__["name"] = name
        __props__["plan"] = plan
        __props__["server_id"] = server_id
        __props__["size"] = size
        __props__["source_archive_id"] = source_archive_id
        __props__["source_disk_id"] = source_disk_id
        __props__["tags"] = tags
        __props__["zone"] = zone
        return Disk(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

