# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class AutoBackup(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    The description of the AutoBackup. The length of this value must be in the range [`1`-`512`]
    """
    disk_id: pulumi.Output[str]
    """
    The disk id to backed up
    """
    icon_id: pulumi.Output[str]
    """
    The icon id to attach to the AutoBackup
    """
    max_backup_num: pulumi.Output[float]
    """
    The number backup files to keep. This must be in the range [`1`-`10`]
    """
    name: pulumi.Output[str]
    """
    The name of the AutoBackup. The length of this value must be in the range [`1`-`64`]
    """
    tags: pulumi.Output[list]
    """
    Any tags to assign to the AutoBackup
    """
    weekdays: pulumi.Output[list]
    """
    A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`]
    """
    zone: pulumi.Output[str]
    """
    The name of zone that the AutoBackup will be created (e.g. `is1a`, `tk1a`)
    """
    def __init__(__self__, resource_name, opts=None, description=None, disk_id=None, icon_id=None, max_backup_num=None, name=None, tags=None, weekdays=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a AutoBackup resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the AutoBackup. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] disk_id: The disk id to backed up
        :param pulumi.Input[str] icon_id: The icon id to attach to the AutoBackup
        :param pulumi.Input[float] max_backup_num: The number backup files to keep. This must be in the range [`1`-`10`]
        :param pulumi.Input[str] name: The name of the AutoBackup. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[list] tags: Any tags to assign to the AutoBackup
        :param pulumi.Input[list] weekdays: A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`]
        :param pulumi.Input[str] zone: The name of zone that the AutoBackup will be created (e.g. `is1a`, `tk1a`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            if disk_id is None:
                raise TypeError("Missing required property 'disk_id'")
            __props__['disk_id'] = disk_id
            __props__['icon_id'] = icon_id
            __props__['max_backup_num'] = max_backup_num
            __props__['name'] = name
            __props__['tags'] = tags
            if weekdays is None:
                raise TypeError("Missing required property 'weekdays'")
            __props__['weekdays'] = weekdays
            __props__['zone'] = zone
        super(AutoBackup, __self__).__init__(
            'sakuracloud:index/autoBackup:AutoBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, disk_id=None, icon_id=None, max_backup_num=None, name=None, tags=None, weekdays=None, zone=None):
        """
        Get an existing AutoBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the AutoBackup. The length of this value must be in the range [`1`-`512`]
        :param pulumi.Input[str] disk_id: The disk id to backed up
        :param pulumi.Input[str] icon_id: The icon id to attach to the AutoBackup
        :param pulumi.Input[float] max_backup_num: The number backup files to keep. This must be in the range [`1`-`10`]
        :param pulumi.Input[str] name: The name of the AutoBackup. The length of this value must be in the range [`1`-`64`]
        :param pulumi.Input[list] tags: Any tags to assign to the AutoBackup
        :param pulumi.Input[list] weekdays: A list of weekdays to backed up. The values in the list must be in [`sun`/`mon`/`tue`/`wed`/`thu`/`fri`/`sat`]
        :param pulumi.Input[str] zone: The name of zone that the AutoBackup will be created (e.g. `is1a`, `tk1a`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["disk_id"] = disk_id
        __props__["icon_id"] = icon_id
        __props__["max_backup_num"] = max_backup_num
        __props__["name"] = name
        __props__["tags"] = tags
        __props__["weekdays"] = weekdays
        __props__["zone"] = zone
        return AutoBackup(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

