"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlpsSpecRestApi = void 0;
// import * as fs from 'fs';
const apigw = require("@aws-cdk/aws-apigateway");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const alps_unified_ts_1 = require("alps-unified-ts");
/**
 * @stability stable
 */
class AlpsSpecRestApi extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.operationIdLambdaMapping = props === null || props === void 0 ? void 0 : props.operationIdLambdaMapping;
        const apiRole = new iam.Role(scope, 'apiRole', {
            assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
            managedPolicies: [iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonAPIGatewayPushToCloudWatchLogs')],
        });
        apiRole.addToPolicy(new iam.PolicyStatement({
            resources: ['*'],
            actions: ['lambda:InvokeFunction'],
        }));
        const specFile = props.alpsSpecFile;
        // const specFile = 'src/todo-alps.yaml';
        const oasSpecJSON = JSON.parse(alps_unified_ts_1.Alps.unified(alps_unified_ts_1.Alps.loadYaml(specFile), { formatType: alps_unified_ts_1.FormatType.OPENAPI_JSON }));
        const region = cdk.Stack.of(this).region;
        const accountId = cdk.Stack.of(this).account;
        const endpointsJson = oasSpecJSON.paths;
        for (const endpoint of Object.keys(endpointsJson)) {
            console.log(`endpoint: ${JSON.stringify(endpoint)}`);
            for (const method of Object.values(endpointsJson[endpoint])) {
                console.log(`method ${JSON.stringify(method)}`);
                // validate OpenApi Spec
                const methodKey = Object.keys(method)[0];
                if (method.operationId === undefined || method.operationId === null) {
                    throw new Error(`Endpoint ${endpoint} with Method ${methodKey}`);
                }
                let methodExt = method;
                let lambdaName = method.operationId;
                // override lambdaName if specified in operationIdLambdaMapping
                if (this.operationIdLambdaMapping && this.operationIdLambdaMapping[method.operationId] !== undefined) {
                    lambdaName = this.operationIdLambdaMapping[method.operationId];
                }
                methodExt['x-amazon-apigateway-integration'] = {
                    uri: `arn:aws:apigateway:${region}:lambda:path/2015-03-31/functions/arn:aws:lambda:${region}:${accountId}:function:${lambdaName}/invocations`,
                    passthroughBehavior: 'when_no_match',
                    httpMethod: 'POST',
                    type: 'aws_proxy',
                    credentials: apiRole.roleArn,
                };
                console.log(`methodExt: ${JSON.stringify(methodExt)}`);
            }
        }
        console.log(`specJson after edit: ${JSON.stringify(oasSpecJSON)}`);
        new apigw.SpecRestApi(this, 'SpecRestApi', {
            // restApiName: 'Alps Rest Api Gw',
            apiDefinition: apigw.ApiDefinition.fromInline(oasSpecJSON),
        });
    }
}
exports.AlpsSpecRestApi = AlpsSpecRestApi;
//# sourceMappingURL=data:application/json;base64,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