# Generated by Django 2.2.7 on 2019-12-04 19:34
# pylint: disable=invalid-name,missing-docstring
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("small_small_hr", "0007_auto_20190625_2111"),
        ("locations", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Requisition",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("reason", models.TextField(default="", verbose_name="Reason")),
                (
                    "status",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("1", "Approved"),
                            ("3", "Pending"),
                            ("2", "Rejected"),
                        ],
                        db_index=True,
                        default="3",
                        max_length=1,
                        verbose_name="Status",
                    ),
                ),
                (
                    "comments",
                    models.TextField(blank=True, default="", verbose_name="Comments"),
                ),
                ("date_placed", models.DateField(verbose_name="Date Placed")),
                ("date_required", models.DateField(verbose_name="Date Required")),
                (
                    "total",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        default=0,
                        max_digits=64,
                        verbose_name="Total",
                    ),
                ),
                (
                    "business",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="locations.Business",
                        verbose_name="Business",
                    ),
                ),
                (
                    "department",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="locations.Department",
                        verbose_name="Department",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="locations.Location",
                        verbose_name="Location",
                    ),
                ),
                (
                    "staff",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="small_small_hr.StaffProfile",
                        verbose_name="Staff Member",
                    ),
                ),
            ],
            options={
                "verbose_name": "Requisition",
                "verbose_name_plural": "Requisitions",
            },
        ),
        migrations.CreateModel(
            name="RequisitionLineItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, default="", verbose_name="Description"
                    ),
                ),
                (
                    "quantity",
                    models.DecimalField(
                        decimal_places=2,
                        default=1,
                        max_digits=64,
                        verbose_name="Quantity",
                    ),
                ),
                (
                    "currency",
                    models.CharField(
                        choices=[("KES", "Kenya Shilling")],
                        db_index=True,
                        default="KES",
                        max_length=3,
                        verbose_name="Currency",
                    ),
                ),
                (
                    "internal_price",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="The price per item",
                        max_digits=64,
                        verbose_name="Price",
                    ),
                ),
                ("item", models.TextField(verbose_name="Item")),
                (
                    "requisition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="purchases.Requisition",
                        verbose_name="Requisition",
                    ),
                ),
            ],
            options={
                "verbose_name": "Requisition Line Item",
                "verbose_name_plural": "Requisition Line Items",
                "abstract": False,
            },
        ),
    ]
