"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
function base62Encode(int) {
    const characterSet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    if (int === 0)
        return '0';
    let s = '';
    while (int > 0) {
        s = characterSet[int % 62] + s;
        int = Math.floor(int / 62);
    }
    return s;
}
;
function getEnv(name) {
    const value = process.env[name];
    if (!value) {
        throw new Error(`The environment variable ${name} is not defined`);
    }
    return value;
}
const documentClient = new aws_sdk_1.DynamoDB.DocumentClient({ apiVersion: '2012-08-10' });
const s3 = new aws_sdk_1.S3({ apiVersion: '2006-03-01' });
async function handler(event) {
    var _a, _b;
    console.log('Event: %j', event);
    const response = {
        statusCode: 201,
        body: '',
        headers: process.env.CORS_ALLOW_ORIGINS
            ? { 'Access-Control-Allow-Origin': process.env.CORS_ALLOW_ORIGINS }
            : undefined,
    };
    try {
        const body = JSON.parse((_a = event.body) !== null && _a !== void 0 ? _a : '{}');
        if (!body.url) {
            return {
                ...response,
                statusCode: 400,
            };
        }
        // Get next counter value
        const update = await documentClient.update({
            TableName: getEnv('TABLE_NAME'),
            Key: { key: 'counter' },
            UpdateExpression: 'ADD #value :incr',
            ExpressionAttributeNames: { '#value': 'value' },
            ExpressionAttributeValues: { ':incr': 1 },
            ReturnValues: 'UPDATED_NEW',
        }).promise();
        const value = (_b = update.Attributes) === null || _b === void 0 ? void 0 : _b.value;
        if (!value) {
            throw new Error('Cannot get next counter value');
        }
        const key = base62Encode(value);
        console.log('Key: %j', key);
        // Put zero-byte object with redirection on S3
        const putObject = await s3.putObject({
            Bucket: getEnv('BUCKET_NAME'),
            Key: key,
            WebsiteRedirectLocation: body.url,
            ACL: 'public-read',
        }).promise();
        console.log('Put object: %j', putObject);
        // Return short url
        return {
            ...response,
            body: JSON.stringify({
                url: body.url,
                shortUrl: `https://${getEnv('DOMAIN_NAME')}/${key}`,
            }),
        };
    }
    catch (err) {
        console.log(err);
        return {
            ...response,
            statusCode: 500,
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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