"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ],
        }
    ],
    defaultRootObject: ''
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2xvdWRmcm9udC1lbXB0eS1yb290LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuY2xvdWRmcm9udC1lbXB0eS1yb290LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0EscUNBQXFDO0FBQ3JDLHFDQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFFOUQsSUFBSSxVQUFVLENBQUMseUJBQXlCLENBQUMsS0FBSyxFQUFFLDBCQUEwQixFQUFFO0lBQzFFLGFBQWEsRUFBRTtRQUNiO1lBQ0UsYUFBYSxFQUFFO2dCQUNiLGlCQUFpQixFQUFFLFdBQVc7YUFDL0I7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsVUFBVSxFQUFFLGtCQUFrQjthQUMvQjtZQUNELFNBQVMsRUFBRTtnQkFDVDtvQkFDQSxpQkFBaUIsRUFBRSxJQUFJO2lCQUN0QjthQUNGO1NBQ0Y7S0FDRjtJQUNELGlCQUFpQixFQUFFLEVBQUU7Q0FDdEIsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiXG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdhd3MtY2RrLWNsb3VkZnJvbnQtY3VzdG9tJyk7XG5cbm5ldyBjbG91ZGZyb250LkNsb3VkRnJvbnRXZWJEaXN0cmlidXRpb24oc3RhY2ssICdBbkFtYXppbmdXZWJzaXRlUHJvYmFibHknLCB7XG4gIG9yaWdpbkNvbmZpZ3M6IFtcbiAgICB7XG4gICAgICBvcmlnaW5IZWFkZXJzOiB7XG4gICAgICAgIFwiWC1DdXN0b20tSGVhZGVyXCI6IFwic29tZXZhbHVlXCIsXG4gICAgICB9LFxuICAgICAgY3VzdG9tT3JpZ2luU291cmNlOiB7XG4gICAgICAgIGRvbWFpbk5hbWU6IFwiYnJlbGFuZG0uYTJ6LmNvbVwiLFxuICAgICAgfSxcbiAgICAgIGJlaGF2aW9yczogW1xuICAgICAgICB7XG4gICAgICAgIGlzRGVmYXVsdEJlaGF2aW9yOiB0cnVlLFxuICAgICAgICB9XG4gICAgICBdLFxuICAgIH1cbiAgXSxcbiAgZGVmYXVsdFJvb3RPYmplY3Q6ICcnXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=