"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
const loggingBucket = new s3.Bucket(stack, 'Bucket', {
    removalPolicy: cdk.RemovalPolicy.DESTROY
});
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ]
        }
    ],
    loggingConfig: {
        bucket: loggingBucket,
        includeCookies: true,
        prefix: 'test-prefix'
    }
});
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably2', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ]
        }
    ],
    loggingConfig: {}
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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