# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03c_multi_core.callback.ipynb (unless otherwise specified).

__all__ = ['maybe_item']

# Internal Cell
from ..utils import xla_imported
from ..misc_utils import *
from .base import *
# from fastai_xla_extensions.multi_core.learner import *

# Internal Cell
try:
    import torch_xla
except:
    pass

# Internal Cell
if xla_imported():
    import torch_xla.core.xla_model as xm
    import torch_xla.distributed.xla_multiprocessing as xmp

# Internal Cell
# from fastai.vision.all import *


# Cell
import torch
from fastcore.xtras import is_listy
def maybe_item(o):
    '''extract scalar values from a tensor, lists and dicts of tensors
    (and pulling it out of gpu/tpu into cpu) else if not tensor just
    use orig value'''
    if isinstance(o,torch.Tensor): return o.item()
    if is_listy(o):
        kls = o.__class__
        k = [maybe_item(i) for i in o]
        return kls(k)
    if isinstance(o,dict):
        return {k:maybe_item(v) for k,v in o.items()}
    # maybe scalar or object
    return o


# Cell
from fastai.learner import Recorder
from fastcore.basics import patch

@patch
def get_extra_attrs(self:Recorder):
    'Extract state attrs of Recorder into a dict (suitable for pickling)'
    # state_attrs = lrs','iters','losses','values'
    d = {}
    for attr in self._stateattrs:
        if hasattr(self,attr):
            value = getattr(self,attr)
            d[attr] = maybe_item(value)
    return d


# Cell
import pickle
from fastai.learner import Recorder
from fastcore.basics import patch

@patch
def dump_attrs(self:Recorder, fn='_rec_attr.pkl'):
    'dump state attrs to a file'
    d = self.get_extra_attrs()
    with open(fn,'wb') as f:
        pickle.dump(d,f)


# Cell
import pickle
from fastai.learner import Recorder
from fastcore.basics import patch
from pathlib import Path

@patch
def reload_attrs(self:Recorder, fn='_rec_attr.pkl'):
    'reload attrs from file `fn`'
    if isinstance(fn,str):
        fn = Path(fn)
    if not fn.is_file():
        return
    with open(fn,'rb') as f:
        d = pickle.load(f)
        for k,v in d.items():
            setattr(self,k,v)
    fn.unlink()

# Cell
from fastai.learner import Recorder
from fastcore.basics import patch

@patch
def after_fit(self: Recorder):
    'after fit dump extra attrs to file'
    if getattr(self.learn,'inner_xla',False) and self.learn.xla_rank == 0:
        self.dump_attrs()


# Cell
from fastai.callback.schedule import ParamScheduler
from fastcore.basics import patch
from pathlib import Path
import pickle

@patch
def dump_hps(self:ParamScheduler, fn='_paramsched_hps.pkl'):
    'dump `hps` to a file `fn`'
    if not hasattr(self, 'hps'):
        return

    if isinstance(fn,str):
        fn = Path(fn)

    d = maybe_item(self.hps)
    with open(fn,'wb') as f:
        pickle.dump(d,f)


# Cell
from fastai.learner import Recorder
from fastcore.basics import patch
from pathlib import Path

@patch
def reload_hps(self:Recorder, fn='_paramsched_hps.pkl'):
    'Load hyperparameters saved by ParamScheduler to recorder'
    if isinstance(fn,str):
        fn = Path(fn)
    if not fn.is_file():
        return
    with open(fn,'rb') as f:
        d = pickle.load(f)
        setattr(self,'hps',d)
    fn.unlink()

# Cell
from fastai.callback.schedule import ParamScheduler
from fastcore.basics import patch

@patch
def after_fit(self:ParamScheduler):
    "save hps to file"
    if not hasattr(self,'hps'):
        return

    if hasattr(self.learn, 'recorder'):
        self.recorder.hps = self.hps

    if getattr(self.learn,'inner_xla',False) and self.learn.xla_rank == 0:
        self.dump_hps()
