import * as iot from '@aws-cdk/aws-iot-alpha';
import * as iotevents from '@aws-cdk/aws-iotevents-alpha';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for the IoT Events.
 */
export interface IotEventsPutMessageActionProps extends CommonActionProps {
    /**
     * Whether to process the event actions as a batch.
     *
     * When batchMode is true, you can't specify a messageId.
     *
     * When batchMode is true and the rule SQL statement evaluates to an Array,
     * each Array element is treated as a separate message when Events by calling BatchPutMessage.
     * The resulting array can't have more than 10 messages.
     *
     * @default false
     */
    readonly batchMode?: boolean;
    /**
     * The ID of the message.
     *
     * When batchMode is true, you can't specify a messageId--a new UUID value will be assigned.
     * Assign a value to this property to ensure that only one input (message) with a given messageId will be processed by an AWS IoT Events detector.
     *
     * @default - none -- a new UUID value will be assigned
     */
    readonly messageId?: string;
}
/**
 * The action to put the message from an MQTT message to the IoT Events input.
 */
export declare class IotEventsPutMessageAction implements iot.IAction {
    private readonly input;
    private readonly batchMode?;
    private readonly messageId?;
    private readonly role?;
    /**
     * @param input The IoT Events input to put messages.
     * @param props Optional properties to not use default
     */
    constructor(input: iotevents.IInput, props?: IotEventsPutMessageActionProps);
    /**
     * @internal
     */
    _bind(rule: iot.ITopicRule): iot.ActionConfig;
}
