"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolClientRedirects = void 0;
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
class UserPoolClientRedirects extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new custom_resources_1.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'updateUserPoolClient',
                parameters: {
                    UserPoolId: props.userPool.userPoolId,
                    ClientId: props.userPoolClient.userPoolClientId,
                    AllowedOAuthFlows: ['code'],
                    AllowedOAuthFlowsUserPoolClient: true,
                    SupportedIdentityProviders: ['COGNITO'],
                    AllowedOAuthScopes: props.oauthScopes.map((scope) => scope.scopeName),
                    CallbackURLs: props.callbackUrls,
                    LogoutURLs: props.logoutUrls,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${props.userPool.userPoolId}-${props.userPoolClient.userPoolClientId}-updated-client`),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.userPool.userPoolArn],
            }),
        });
    }
}
exports.UserPoolClientRedirects = UserPoolClientRedirects;
//# sourceMappingURL=data:application/json;base64,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