"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretGenerator = void 0;
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class SecretGenerator extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _a, _b;
        super(scope, id);
        const secretGenerator = new aws_lambda_1.SingletonFunction(this, 'Function', {
            uuid: 'cloudcomponents-cdk-cloudfront-authorization-secret-generator',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'secret-generator')),
        });
        const cr = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: secretGenerator.functionArn,
            resourceType: 'Custom::GenerateSecret',
            properties: {
                Length: (_a = props.length) !== null && _a !== void 0 ? _a : 16,
                AllowedCharacters: (_b = props.allowedCharacters) !== null && _b !== void 0 ? _b : 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~',
            },
        });
        this.secret = cr.ref;
    }
}
exports.SecretGenerator = SecretGenerator;
//# sourceMappingURL=data:application/json;base64,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