"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class BaseDistribution extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const removalPolicy = (_a = props.removalPolicy) !== null && _a !== void 0 ? _a : core_1.RemovalPolicy.DESTROY;
        const origin = (_b = props.origin) !== null && _b !== void 0 ? _b : this.defaultOrigin(removalPolicy === core_1.RemovalPolicy.DESTROY);
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            enabled: (_c = props.enabled) !== null && _c !== void 0 ? _c : true,
            enableIpv6: (_d = props.enableIpv6) !== null && _d !== void 0 ? _d : true,
            comment: props.comment,
            enableLogging: props.enableLogging,
            logBucket: props.logBucket,
            logIncludesCookies: props.logIncludesCookies,
            logFilePrefix: props.logFilePrefix,
            priceClass: (_e = props.priceClass) !== null && _e !== void 0 ? _e : aws_cloudfront_1.PriceClass.PRICE_CLASS_100,
            geoRestriction: props.geoRestriction,
            httpVersion: (_f = props.httpVersion) !== null && _f !== void 0 ? _f : aws_cloudfront_1.HttpVersion.HTTP2,
            webAclId: props.webAclId,
            errorResponses: props.errorResponses,
            domainNames: props.domainNames,
            certificate: props.certificate,
            defaultBehavior: props.authorization.createDefaultBehavior(origin),
            additionalBehaviors: props.authorization.createAdditionalBehaviors(origin),
            defaultRootObject: (_g = props.defaultRootObject) !== null && _g !== void 0 ? _g : 'index.html',
        });
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`],
            logoutUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`],
        });
    }
    defaultOrigin(forceDelete) {
        const bucket = new cdk_deletable_bucket_1.DeletableBucket(this, 'DeletableBucket', {
            forceDelete,
        });
        return new aws_cloudfront_origins_1.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: (_a = props.ttl) !== null && _a !== void 0 ? _a : core_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
//# sourceMappingURL=data:application/json;base64,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