import numpy as np
import statistics as stat
import scipy.stats as scistats
import math,sys,os,inspect
import shutil

import pickle 
import matplotlib.pyplot as plt

import actynf

from tools import dist_kl_dir,js_dir # A tool to qualify subject learning

#!/usr/bin/python
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
parentdir = os.path.dirname(currentdir)
sys.path.insert(0, parentdir) 


def extract_training_data(savepath):
    # EXTRACT TRAINING CURVES    
    with open(savepath, 'rb') as handle:
        saved_data = pickle.load(handle)
    stms = saved_data["stms"]
    weights = saved_data["matrices"]

    Nsubj = len(stms)
    Ntrials = len(weights[0])-1 # One off because we save the initial weights (= trial 0)
    return stms,weights,Nsubj,Ntrials

def initialize_3darray(Ns,Ny,Nz):
    L = []
    for x in range(Ns):
        L.append([])
        for y in range(Ny):
            L[-1].append([])
            for z in range(Nz):
                L[-1][-1].append([])
    return L

def save_object_to(obj,savepath,override=True):
    if not os.path.exists(os.path.dirname(savepath)):
        os.makedirs(os.path.dirname(savepath))

    exists = os.path.isfile(savepath)
    if (not(exists)) or (override):
        print("Saving to " + savepath)
            
        with open(savepath, 'wb') as handle:
            pickle.dump(obj, handle, protocol=pickle.HIGHEST_PROTOCOL)
        print("Saved to :   " + savepath)

def save_performances():
    """
    Change the format of the save
    """
    save_folder_name = os.path.join(os.path.abspath(os.sep),"mnt","data","Come_A","results","new_sims","io_001")
    all_files = [os.path.join(save_folder_name, f) for f in os.listdir(save_folder_name) if os.path.isfile(os.path.join(save_folder_name, f))]
    
    K = 20
    Kw = 10

    simulation_min_value = 0.001
    simulation_max_value = 3.0
    io_min_value = 0.001
    io_max_value = 2.0

    key_array = initialize_3darray(K,K,Kw)
    results_states = initialize_3darray(K,K,Kw)
    extract_this_models_a_io = initialize_3darray(K,K,Kw)
    extract_this_models_b = initialize_3darray(K,K,Kw)

    Nfiles = len(all_files)
    for k,file in enumerate(all_files):

        filename = os.path.basename(file)
        print(str(k) + "  / " + str(Nfiles) + "  -- "  +filename)
        
        param_val = filename.split("_")
        
        value_1 = float(param_val[-4])  # True feedback noise
        value_2 = float(param_val[-3])  # Belief feedback noise
        value_3 = float(param_val[-2])  # True IO noise
        
        kA = (int(K*(value_1-simulation_min_value)/simulation_max_value))
        ka = (int(K*(value_2-simulation_min_value)/simulation_max_value))
        kio = (int(Kw*(value_3-io_min_value)/io_max_value))

        parameter_values = np.array([value_1,value_2,value_3])
        key_array[kA][ka][kio] = parameter_values
                
        _stm,_weight,_Nsubj,_Ntrials = extract_training_data(file)

        state_perfs = [[_stm[subj][idx][0].x[0] for idx in range(1,_Ntrials+1)] for subj in range(_Nsubj)]
        state_perfs_array = np.array(state_perfs)
        results_states[kA][ka][kio] = state_perfs_array

        true_A = _weight[0][0][0]["a"][1]
        # a_dists =  [[dist_kl_dir(_weight[subj][trial][1]["a"][1],true_A) for trial in range(1,_Ntrials+1)] for subj in range(_Nsubj)]
        a_dists =  [[js_dir(_weight[subj][trial][1]["a"][1],true_A) for trial in range(1,_Ntrials+1)] for subj in range(_Nsubj)]
        a_dists_array = np.array(a_dists)
        extract_this_models_a_io[kA][ka][kio] = a_dists_array
        

        true_B = _weight[0][0][0]["b"][0]
        # b_dists = [[dist_kl_dir(_weight[subj][trial][1]["b"][0],true_B) for trial in range(1,_Ntrials+1)] for subj in range(_Nsubj)]
        b_dists = [[js_dir(_weight[subj][trial][1]["b"][0],true_B) for trial in range(1,_Ntrials+1)] for subj in range(_Nsubj)]
        b_dists_array = np.array(b_dists)
        extract_this_models_b[kA][ka][kio] = b_dists_array


    save_folder_name_arrayed = os.path.join(save_folder_name,"compressed")
    
    key_array = np.array(key_array) # array of size K x K x Kw x 3
    save_object_to(key_array,os.path.join(save_folder_name_arrayed,"KEYS"))
    subject_performances = {
        "s":np.array(results_states),
        "a":np.array(extract_this_models_a_io),
        "b":np.array(extract_this_models_b)
    }
    save_object_to(subject_performances,os.path.join(save_folder_name_arrayed,"PERFS_js"))
    
def save_interoceptive_matrices():
    """
    Change the format of the save
    """
    save_folder_name = os.path.join(os.path.abspath(os.sep),"mnt","data","Come_A","results","new_sims","io_001")
    all_files = [os.path.join(save_folder_name, f) for f in os.listdir(save_folder_name) if os.path.isfile(os.path.join(save_folder_name, f))]
    
    K = 20
    Kw = 10

    simulation_min_value = 0.001
    simulation_max_value = 3.0
    io_min_value = 0.001
    io_max_value = 2.0

    all_io_matrices = initialize_3darray(K,K,Kw)

    Nfiles = len(all_files)
    for k,file in enumerate(all_files):

        filename = os.path.basename(file)
        print(str(k) + "  / " + str(Nfiles) + "  -- "  +filename)
        
        param_val = filename.split("_")
        
        value_1 = float(param_val[-4])  # True feedback noise
        value_2 = float(param_val[-3])  # Belief feedback noise
        value_3 = float(param_val[-2])  # True IO noise
        
        kA = (int(K*(value_1-simulation_min_value)/simulation_max_value))
        ka = (int(K*(value_2-simulation_min_value)/simulation_max_value))
        kio = (int(Kw*(value_3-io_min_value)/io_max_value))

        _stm,_weight,_Nsubj,_Ntrials = extract_training_data(file)

        io_matrices =  [[_weight[subj][trial][1]["a"][1] for trial in range(1,_Ntrials+1)] for subj in range(_Nsubj)]
        all_io_matrices[kA][ka][kio] = np.array(io_matrices)

    save_folder_name_arrayed = os.path.join(save_folder_name,"compressed")
    save_object_to(np.array(all_io_matrices),os.path.join(save_folder_name_arrayed,"IO_MATRICES"))

if __name__ == "__main__":
    save_performances() # Transform the names of the file into array coordinates !        
    save_interoceptive_matrices()