# -*- coding: utf-8 -*-

"""
Data client 数据访问客户端
Created on 2020/08/07
@author: Xinqi Yang
@group : https://chaininout.com
"""

import pandas as pd
import json
from functools import partial
import requests


class DataApi:

    __token = ''
    __http_url = 'https://chaininout.com/api/v1/messagehub'
    # get http url
    # __http_url = 'http://localhost:8080/api/v1/messagehub'

    def __init__(self, token, timeout=15):
        """
        Parameters
        ----------
        token: str
        API接口TOKEN，用于用户认证
        """
        self.__token = token
        self.__timeout = timeout

    def query(self, api_name, fields='', **kwargs):
        req_params = {
            'api_name': api_name,
            'token': self.__token,
            'params': kwargs,
            'fields': fields
        }
        ##
        # print(self.__http_url)
        # print(req_params)
        #
        # 提供这4个字段:
        # api_name, token, params, fields
        # {'api_name': 'coinbar', 'token': 'b3a30846b8061441ece4ee397c62304c212337ddade4c89db61bf236',
        # 'params':
        # {'exchange':
        # 'huobi',
        # 'symbol': 'btcusdt',
        # 'freq': 'daily',
        # 'start_date': '20200301',
        # 'end_date': '20200728'},
        # 'fields': ''}
        # {'fields': ['ts_code', 'trade_date', 'bid_open', 'bid_close', 'bid_high', 'bid_low', 'ask_open', 'ask_close', 'ask_high', 'ask_low', 'tick_qty'], 'items': [['USDCNH.FXCM', '20200727', 7.01462, 7.00238, 7.0178, 6.99617, 7.02538, 7.00288, 7.02538, 6.99671, 183374], ['USDCNH.FXCM', '20200726', 7.01487, 7.01462, 7.01487, 7.01462, 7.02513, 7.02538, 7.02538, 7.02513, 2], ['USDCNH.FXCM', '20200724', 7.00982, 7.01424, 7.03, 7.00281, 7.01551, 7.01759, 7.03052, 7.00353, 309550], ['USDCNH.FXCM', '20200724', 7.01194, 7.01424, 7.03, 7.00281, 7.01673, 7.01759, 7.03052, 7.00353, 318819], ['USDCNH.FXCM', '20200723', 7.01468, 7.00621, 7.01631, 7.00576, 7.02057, 7.00687, 7.02059, 7.00641, 17404], ['USDCNH.FXCM', '20200723', 7.01468, 7.00982, 7.01631, 6.99272, 7.02057, 7.01551, 7.02059, 6.99324, 276440], ['USDCNH.FXCM', '20200723', 7.017, 7.01194, 7.01631, 6.99272, 7.01811, 7.01673, 7.02059, 6.99324, 276439], ['USDCNH.FXCM', '20200722', 6.96925, 7.01468, 7.01766, 6.96392, 6.97998, 7.02057, 7.02057, 6.96455, 305689], ['USDCNH.FXCM', '20200722', 6.96925, 7.01468, 7.01766, 6.96392, 6.97998, 7.02057, 7.02057, 6.96455, 305689], ['USDCNH.FXCM', '20200722', 6.96859, 7.017, 7.01766, 6.96392, 6.97708, 7.01811, 7.01848, 6.96455, 305689], ['USDCNH.FXCM', '20200721', 6.98655, 6.96925, 6.99457, 6.96852, 6.9889, 6.97998, 6.99514, 6.96947, 190701], ['USDCNH.FXCM', '20200721', 6.98655, 6.96925, 6.99457, 6.96852, 6.9889, 6.97998, 6.99514, 6.96947, 190701], ['USDCNH.FXCM', '20200721', 6.98655, 6.96859, 6.99457, 6.96852, 6.98887, 6.97708, 6.99514, 6.96947, 190699], ['USDCNH.FXCM', '20200720', 6.98999, 6.99425, 6.99604, 6.98829, 6.99451, 6.99476, 6.9966, 6.98937, 9146], ['USDCNH.FXCM', '20200720', 6.98999, 6.98655, 6.99951, 6.98242, 6.99451, 6.9889, 7.00003, 6.98285, 168666], ['USDCNH.FXCM', '20200720', 6.98999, 6.98655, 6.99951, 6.98242, 6.99451, 6.9889, 7.00003, 6.98285, 168666], ['USDCNH.FXCM', '20200720', 6.98999, 6.98655, 6.99951, 6.98242, 6.99451, 6.98887, 7.00003, 6.98285, 168665], ['USDCNH.FXCM', '20200719', 6.98695, 6.98999, 6.98999, 6.98695, 6.99596, 6.99451, 6.99596, 6.99451, 13], ['USDCNH.FXCM', '20200719', 6.98695, 6.98999, 6.98999, 6.98695, 6.99596, 6.99451, 6.99596, 6.99451, 13], ['USDCNH.FXCM', '20200719', 6.98695, 6.98999, 6.98999, 6.98695, 6.99596, 6.99451, 6.99596, 6.99451, 13], ['USDCNH.FXCM', '20200719', 6.98871, 6.98999, 6.98999, 6.98695, 6.99296, 6.99451, 6.99596, 6.99451, 13], ['USDCNH.FXCM', '20200717', 6.99228, 6.99365, 6.99793, 6.99228, 6.99644, 6.99493, 6.99943, 6.99357, 9088], ['USDCNH.FXCM', '20200717', 6.99255, 6.98871, 7.00287, 6.98763, 6.99642, 6.99296, 7.00344, 6.98928, 155386], ['USDCNH.FXCM', '20200717', 6.99255, 6.98871, 7.00287, 6.98763, 6.99642, 6.99296, 7.00344, 6.98928, 155386], ['USDCNH.FXCM', '20200717', 6.99255, 6.98871, 7.00287, 6.98763, 6.99642, 6.99296, 7.00344, 6.98928, 149460], ['USDCNH.FXCM', '20200716', 6.98179, 6.99228, 7.00258, 6.98051, 6.98259, 6.99644, 7.00314, 6.98161, 210448], ['USDCNH.FXCM', '20200716', 6.98176, 6.99255, 7.00258, 6.98051, 6.9826, 6.99642, 7.00314, 6.98161, 210447], ['USDCNH.FXCM', '20200716', 6.98176, 6.99255, 7.00258, 6.98051, 6.9826, 6.99642, 7.00314, 6.98161, 210447], ['USDCNH.FXCM', '20200716', 6.98176, 6.99255, 7.00258, 6.98051, 6.9826, 6.99642, 7.00314, 6.98161, 210447], ['USDCNH.FXCM', '20200715', 7.00781, 6.98179, 7.00989, 6.98046, 7.01298, 6.98259, 7.01441, 6.98093, 215093], ['USDCNH.FXCM', '20200715', 7.00781, 6.98176, 7.00989, 6.98046, 7.01298, 6.9826, 7.01441, 6.98093, 215092], ['USDCNH.FXCM', '20200715', 7.00781, 6.98176, 7.00989, 6.98046, 7.01298, 6.9826, 7.01441, 6.98093, 215092], ['USDCNH.FXCM', '20200715', 7.00781, 6.98176, 7.00989, 6.98046, 7.01298, 6.9826, 7.01441, 6.98093, 215092], ['USDCNH.FXCM', '20200714', 6.99539, 7.00798, 7.00932, 6.99539, 7.00491, 7.00864, 7.01003, 7.00222, 19721], ['USDCNH.FXCM', '20200714', 6.99539, 7.00781, 7.02546, 6.99539, 7.00447, 7.01298, 7.0259, 7.00222, 216848], ['USDCNH.FXCM', '20200714', 6.99539, 7.00781, 7.02546, 6.99539, 7.00447, 7.01298, 7.0259, 7.00222, 216848], ['USDCNH.FXCM', '20200714', 6.99539, 7.00781, 7.02546, 6.99539, 7.00447, 7.01298, 7.0259, 7.00222, 216848], ['USDCNH.FXCM', '20200713', 7.00439, 6.99539, 7.01269, 6.99359, 7.01302, 7.00491, 7.01372, 6.99404, 212747], ['USDCNH.FXCM', '20200713', 7.00499, 6.99539, 7.01269, 6.99359, 7.01251, 7.00447, 7.01372, 6.99404, 212747], ['USDCNH.FXCM', '20200713', 7.00499, 6.99539, 7.01269, 6.99359, 7.01251, 7.00447, 7.01372, 6.99404, 212747], ['USDCNH.FXCM', '20200713', 7.00499, 6.99539, 7.01269, 6.99359, 7.01251, 7.00447, 7.01372, 6.99404, 212747], ['USDCNH.FXCM', '20200712', 7.00379, 7.00439, 7.00499, 7.00152, 7.0131, 7.01302, 7.0131, 7.01188, 47], ['USDCNH.FXCM', '20200712', 7.00812, 7.00499, 7.00499, 7.00152, 7.01408, 7.01251, 7.0131, 7.01188, 46], ['USDCNH.FXCM', '20200712', 7.00812, 7.00499, 7.00499, 7.00152, 7.01408, 7.01251, 7.0131, 7.01188, 46], ['USDCNH.FXCM', '20200712', 7.00812, 7.00499, 7.00499, 7.00152, 7.01408, 7.01251, 7.0131, 7.01188, 46], ['USDCNH.FXCM', '20200710', 6.99472, 7.00812, 7.01665, 6.99321, 6.99987, 7.01408, 7.0172, 6.99522, 225180], ['USDCNH.FXCM', '20200710', 6.99439, 7.00812, 7.01665, 6.99321, 6.99978, 7.01408, 7.0172, 6.99522, 225181], ['USDCNH.FXCM', '20200710', 6.99439, 7.00812, 7.01665, 6.99321, 6.99978, 7.01408, 7.0172, 6.99522, 225181], ['USDCNH.FXCM', '20200710', 6.99439, 7.00812, 7.01665, 6.99321, 6.99978, 7.01408, 7.0172, 6.99522, 225181], ['USDCNH.FXCM', '20200709', 6.99808, 6.99472, 7.00093, 6.98056, 6.99894, 6.99987, 7.00182, 6.98112, 251355], ['USDCNH.FXCM', '20200709', 6.99808, 6.99439, 7.00093, 6.98056, 6.99894, 6.99978, 7.00182, 6.98112, 251354], ['USDCNH.FXCM', '20200709', 6.99808, 6.99439, 7.00093, 6.98056, 6.99894, 6.99978, 7.00182, 6.98112, 251354], ['USDCNH.FXCM', '20200709', 6.99808, 6.99439, 7.00093, 6.98056, 6.99894, 6.99978, 7.00182, 6.98112, 251354], ['USDCNH.FXCM', '20200708', 7.01977, 7.01352, 7.02931, 7.01287, 7.02528, 7.01407, 7.02994, 7.01321, 27250], ['USDCNH.FXCM', '20200708', 7.01979, 6.99808, 7.02931, 6.99794, 7.02574, 6.99894, 7.02994, 6.99852, 194094], ['USDCNH.FXCM', '20200708', 7.01979, 6.99808, 7.02931, 6.99794, 7.02574, 6.99894, 7.02994, 6.99852, 194094], ['USDCNH.FXCM', '20200708', 7.01979, 6.99808, 7.02931, 6.99794, 7.02574, 6.99894, 7.02994, 6.99852, 194094], ['USDCNH.FXCM', '20200707', 7.01193, 7.01977, 7.02685, 6.99623, 7.01467, 7.02528, 7.02785, 6.99694, 235824], ['USDCNH.FXCM', '20200707', 7.01193, 7.01979, 7.02685, 6.99623, 7.01482, 7.02574, 7.02785, 6.99694, 235824], ['USDCNH.FXCM', '20200707', 7.01193, 7.01979, 7.02685, 6.99623, 7.01482, 7.02574, 7.02785, 6.99694, 235824], ['USDCNH.FXCM', '20200707', 7.01193, 7.01979, 7.02685, 6.99623, 7.01482, 7.02574, 7.02785, 6.99694, 235824], ['USDCNH.FXCM', '20200706', 7.06622, 7.01193, 7.06847, 7.01, 7.07178, 7.01467, 7.07178, 7.01053, 215266], ['USDCNH.FXCM', '20200706', 7.06649, 7.01193, 7.06847, 7.01, 7.07001, 7.01482, 7.07178, 7.01053, 215266], ['USDCNH.FXCM', '20200706', 7.06649, 7.01193, 7.06847, 7.01, 7.07001, 7.01482, 7.07178, 7.01053, 215266], ['USDCNH.FXCM', '20200706', 7.06649, 7.01193, 7.06847, 7.01, 7.07001, 7.01482, 7.07178, 7.01053, 215266], ['USDCNH.FXCM', '20200705', 7.06165, 7.06622, 7.06649, 7.06165, 7.07178, 7.07178, 7.07239, 7.07001, 47], ['USDCNH.FXCM', '20200705', 7.06478, 7.06649, 7.06649, 7.06165, 7.06998, 7.07001, 7.07239, 7.07001, 46], ['USDCNH.FXCM', '20200705', 7.06478, 7.06649, 7.06649, 7.06165, 7.06998, 7.07001, 7.07239, 7.07001, 46], ['USDCNH.FXCM', '20200705', 7.06478, 7.06649, 7.06649, 7.06165, 7.06998, 7.07001, 7.07239, 7.07001, 46], ['USDCNH.FXCM', '20200703', 7.06572, 7.06478, 7.07114, 7.06259, 7.06979, 7.06998, 7.07171, 7.0632, 105739], ['USDCNH.FXCM', '20200703', 7.0665, 7.06478, 7.07114, 7.06259, 7.07014, 7.06998, 7.07171, 7.0632, 105741], ['USDCNH.FXCM', '20200703', 7.0665, 7.06478, 7.07114, 7.06259, 7.07014, 7.06998, 7.07171, 7.0632, 105741], ['USDCNH.FXCM', '20200703', 7.0665, 7.06478, 7.07114, 7.06259, 7.07014, 7.06998, 7.07171, 7.0632, 105741], ['USDCNH.FXCM', '20200702', 7.065, 7.06518, 7.06933, 7.06379, 7.07208, 7.06562, 7.07208, 7.06499, 11833], ['USDCNH.FXCM', '20200702', 7.065, 7.0665, 7.07463, 7.06228, 7.07186, 7.07014, 7.07512, 7.06281, 178639], ['USDCNH.FXCM', '20200702', 7.065, 7.0665, 7.07463, 7.06228, 7.07186, 7.07014, 7.07512, 7.06281, 178639], ['USDCNH.FXCM', '20200702', 7.065, 7.0665, 7.07463, 7.06228, 7.07186, 7.07014, 7.07512, 7.06281, 178639], ['USDCNH.FXCM', '20200701', 7.0675, 7.065, 7.07622, 7.05822, 7.07221, 7.07208, 7.07677, 7.05869, 170822], ['USDCNH.FXCM', '20200701', 7.0675, 7.065, 7.07622, 7.05822, 7.07221, 7.07186, 7.07677, 7.05869, 170821], ['USDCNH.FXCM', '20200701', 7.0675, 7.065, 7.07622, 7.05822, 7.07221, 7.07186, 7.07677, 7.05869, 170821], ['USDCNH.FXCM', '20200701', 7.0675, 7.065, 7.07622, 7.05822, 7.07221, 7.07186, 7.07677, 7.05869, 170821], ['USDCNH.FXCM', '20200630', 7.07415, 7.0675, 7.07983, 7.06268, 7.07808, 7.07221, 7.08246, 7.06311, 198097], ['USDCNH.FXCM', '20200630', 7.07432, 7.0675, 7.07983, 7.06268, 7.07808, 7.07221, 7.08246, 7.06311, 198098], ['USDCNH.FXCM', '20200630', 7.07432, 7.0675, 7.07983, 7.06268, 7.07808, 7.07221, 7.08246, 7.06311, 198098], ['USDCNH.FXCM', '20200630', 7.07432, 7.0675, 7.07983, 7.06268, 7.07808, 7.07221, 7.08246, 7.06311, 198098], ['USDCNH.FXCM', '20200629', 7.08502, 7.08271, 7.08651, 7.08068, 7.0877, 7.08339, 7.09041, 7.0819, 21351], ['USDCNH.FXCM', '20200629', 7.08519, 7.07432, 7.08651, 7.06859, 7.08751, 7.07808, 7.09041, 7.06908, 187972], ['USDCNH.FXCM', '20200629', 7.08519, 7.07432, 7.08651, 7.06859, 7.08751, 7.07808, 7.09041, 7.06908, 187972], ['USDCNH.FXCM', '20200629', 7.08519, 7.07432, 7.08651, 7.06859, 7.08751, 7.07808, 7.09041, 7.06908, 187972], ['USDCNH.FXCM', '20200628', 7.08151, 7.08502, 7.08522, 7.08151, 7.09061, 7.0877, 7.09249, 7.08751, 47], ['USDCNH.FXCM', '20200628', 7.0851, 7.08519, 7.08522, 7.08151, 7.08917, 7.08751, 7.09249, 7.08751, 46], ['USDCNH.FXCM', '20200628', 7.0851, 7.08519, 7.08522, 7.08151, 7.08917, 7.08751, 7.09249, 7.08751, 46], ['USDCNH.FXCM', '20200628', 7.0851, 7.08519, 7.08522, 7.08151, 7.08917, 7.08751, 7.09249, 7.08751, 46], ['USDCNH.FXCM', '20200626', 7.07876, 7.08064, 7.08308, 7.07866, 7.08791, 7.08156, 7.08802, 7.07979, 12021], ['USDCNH.FXCM', '20200626', 7.07876, 7.0851, 7.08961, 7.07554, 7.08791, 7.08917, 7.09024, 7.07601, 175655], ['USDCNH.FXCM', '20200626', 7.07876, 7.0851, 7.08961, 7.07554, 7.08791, 7.08917, 7.09024, 7.07601, 175655], ['USDCNH.FXCM', '20200626', 7.07876, 7.0851, 7.08961, 7.07554, 7.08791, 7.08917, 7.09024, 7.07601, 175655], ['USDCNH.FXCM', '20200625', 7.07483, 7.07876, 7.08906, 7.07476, 7.0848, 7.08791, 7.08961, 7.07564, 234639], ['USDCNH.FXCM', '20200625', 7.07559, 7.07876, 7.08906, 7.07476, 7.08295, 7.08791, 7.08961, 7.07564, 234642], ['USDCNH.FXCM', '20200625', 7.07559, 7.07876, 7.08906, 7.07476, 7.08295, 7.08791, 7.08961, 7.07564, 234642], ['USDCNH.FXCM', '20200625', 7.07559, 7.07876, 7.08906, 7.07476, 7.08295, 7.08791, 7.08961, 7.07564, 234642], ['USDCNH.FXCM', '20200624', 7.05849, 7.07483, 7.08295, 7.04517, 7.06192, 7.0848, 7.0848, 7.04573, 293110], ['USDCNH.FXCM', '20200624', 7.05862, 7.07559, 7.08295, 7.04517, 7.06264, 7.08295, 7.08353, 7.04573, 293109], ['USDCNH.FXCM', '20200624', 7.05862, 7.07559, 7.08295, 7.04517, 7.06264, 7.08295, 7.08353, 7.04573, 293109], ['USDCNH.FXCM', '20200624', 7.05862, 7.07559, 7.08295, 7.04517, 7.06264, 7.08295, 7.08353, 7.04573, 293109], ['USDCNH.FXCM', '20200623', 7.05697, 7.06011, 7.06123, 7.05506, 7.05946, 7.06063, 7.06195, 7.05658, 10531], ['USDCNH.FXCM', '20200623', 7.05711, 7.05862, 7.08761, 7.05088, 7.0596, 7.06264, 7.08904, 7.05141, 254522], ['USDCNH.FXCM', '20200623', 7.05711, 7.05862, 7.08761, 7.05088, 7.0596, 7.06264, 7.08904, 7.05141, 254522], ['USDCNH.FXCM', '20200623', 7.05711, 7.05862, 7.08761, 7.05088, 7.0596, 7.06264, 7.08904, 7.05141, 254522], ['USDCNH.FXCM', '20200622', 7.07899, 7.05697, 7.08122, 7.05543, 7.08051, 7.05946, 7.08192, 7.05586, 216880], ['USDCNH.FXCM', '20200622', 7.07899, 7.05711, 7.08122, 7.05543, 7.08051, 7.0596, 7.08192, 7.05586, 219790], ['USDCNH.FXCM', '20200622', 7.07899, 7.05711, 7.08122, 7.05543, 7.08051, 7.0596, 7.08192, 7.05586, 219790], ['USDCNH.FXCM', '20200622', 7.07899, 7.05711, 7.08122, 7.05543, 7.08051, 7.0596, 7.08192, 7.05586, 219790], ['USDCNH.FXCM', '20200621', 7.07513, 7.07899, 7.07977, 7.07447, 7.08028, 7.08051, 7.08466, 7.08001, 156], ['USDCNH.FXCM', '20200621', 7.07694, 7.07899, 7.07977, 7.07447, 7.08021, 7.08051, 7.08466, 7.08001, 156], ['USDCNH.FXCM', '20200621', 7.07694, 7.07899, 7.07977, 7.07447, 7.08021, 7.08051, 7.08466, 7.08001, 156], ['USDCNH.FXCM', '20200621', 7.07694, 7.07899, 7.07977, 7.07447, 7.08021, 7.08051, 7.08466, 7.08001, 156], ['USDCNH.FXCM', '20200619', 7.07873, 7.07694, 7.08373, 7.06389, 7.08416, 7.08021, 7.08605, 7.06456, 234079], ['USDCNH.FXCM', '20200619', 7.07873, 7.07694, 7.08373, 7.06389, 7.08416, 7.08021, 7.08605, 7.06456, 235488], ['USDCNH.FXCM', '20200619', 7.07873, 7.07694, 7.08373, 7.06389, 7.08416, 7.08021, 7.08605, 7.06456, 235488], ['USDCNH.FXCM', '20200619', 7.07873, 7.07694, 7.08373, 7.06389, 7.08416, 7.08021, 7.08605, 7.06456, 235488], ['USDCNH.FXCM', '20200618', 7.07172, 7.07873, 7.08746, 7.06149, 7.08011, 7.08416, 7.08796, 7.06204, 275825], ['USDCNH.FXCM', '20200618', 7.07172, 7.07873, 7.08746, 7.06149, 7.08011, 7.08416, 7.08796, 7.06204, 282899], ['USDCNH.FXCM', '20200618', 7.07172, 7.07873, 7.08746, 7.06149, 7.08011, 7.08416, 7.08796, 7.06204, 282899], ['USDCNH.FXCM', '20200618', 7.07172, 7.07873, 7.08746, 7.06149, 7.08011, 7.08416, 7.08796, 7.06204, 282899], ['USDCNH.FXCM', '20200617', 7.07989, 7.08352, 7.08457, 7.07752, 7.08447, 7.08408, 7.08643, 7.07808, 29370], ['USDCNH.FXCM', '20200617', 7.07963, 7.07172, 7.09032, 7.06874, 7.08428, 7.08011, 7.09084, 7.06933, 296707], ['USDCNH.FXCM', '20200617', 7.07963, 7.07172, 7.09032, 7.06874, 7.08428, 7.08011, 7.09084, 7.06933, 296707], ['USDCNH.FXCM', '20200617', 7.07963, 7.07172, 7.09032, 7.06874, 7.08428, 7.08011, 7.09084, 7.06933, 296707], ['USDCNH.FXCM', '20200616', 7.06993, 7.07989, 7.09029, 7.0596, 7.07453, 7.08447, 7.09098, 7.06047, 376296], ['USDCNH.FXCM', '20200616', 7.06993, 7.07963, 7.09029, 7.0596, 7.07379, 7.08428, 7.09098, 7.06047, 390476], ['USDCNH.FXCM', '20200616', 7.06993, 7.07963, 7.09029, 7.0596, 7.07379, 7.08428, 7.09098, 7.06047, 390476], ['USDCNH.FXCM', '20200616', 7.06993, 7.07963, 7.09029, 7.0596, 7.07379, 7.08428, 7.09098, 7.06047, 390476], ['USDCNH.FXCM', '20200615', 7.08432, 7.06993, 7.09717, 7.06825, 7.08771, 7.07453, 7.09775, 7.06878, 362664], ['USDCNH.FXCM', '20200615', 7.08449, 7.06993, 7.09717, 7.06825, 7.08751, 7.07379, 7.09775, 7.06878, 368663], ['USDCNH.FXCM', '20200615', 7.08449, 7.06993, 7.09717, 7.06825, 7.08751, 7.07379, 7.09775, 7.06878, 368663], ['USDCNH.FXCM', '20200615', 7.08449, 7.06993, 7.09717, 7.06825, 7.08751, 7.07379, 7.09775, 7.06878, 368663], ['USDCNH.FXCM', '20200614', 7.0794, 7.08432, 7.08531, 7.07774, 7.0891, 7.08771, 7.0891, 7.08218, 181], ['USDCNH.FXCM', '20200614', 7.0739, 7.08449, 7.08531, 7.07774, 7.07817, 7.08751, 7.0891, 7.08218, 180], ['USDCNH.FXCM', '20200614', 7.0739, 7.08449, 7.08531, 7.07774, 7.07817, 7.08751, 7.0891, 7.08218, 180], ['USDCNH.FXCM', '20200614', 7.0739, 7.08449, 7.08531, 7.07774, 7.07817, 7.08751, 7.0891, 7.08218, 180], ['USDCNH.FXCM', '20200612', 7.07772, 7.0739, 7.08749, 7.0666, 7.0836, 7.07817, 7.08804, 7.0671, 334166], ['USDCNH.FXCM', '20200612', 7.078, 7.0739, 7.08749, 7.0666, 7.08326, 7.07817, 7.08804, 7.0671, 334168], ['USDCNH.FXCM', '20200612', 7.078, 7.0739, 7.08749, 7.0666, 7.08326, 7.07817, 7.08804, 7.0671, 334168], ['USDCNH.FXCM', '20200612', 7.078, 7.0739, 7.08749, 7.0666, 7.08326, 7.07817, 7.08804, 7.0671, 334168], ['USDCNH.FXCM', '20200611', 7.05006, 7.05206, 7.06203, 7.04407, 7.05889, 7.05264, 7.06298, 7.05041, 24851], ['USDCNH.FXCM', '20200611', 7.05245, 7.078, 7.08318, 7.04407, 7.05408, 7.08326, 7.08382, 7.05041, 377948], ['USDCNH.FXCM', '20200611', 7.05245, 7.078, 7.08318, 7.04407, 7.05408, 7.08326, 7.08382, 7.05041, 377948], ['USDCNH.FXCM', '20200611', 7.05245, 7.078, 7.08318, 7.04407, 7.05408, 7.08326, 7.08382, 7.05041, 377948], ['USDCNH.FXCM', '20200610', 7.07332, 7.05006, 7.08244, 7.03984, 7.08037, 7.05889, 7.08345, 7.04036, 290409], ['USDCNH.FXCM', '20200610', 7.07332, 7.05245, 7.08244, 7.03984, 7.08037, 7.05408, 7.08345, 7.04036, 290407], ['USDCNH.FXCM', '20200610', 7.07332, 7.05245, 7.08244, 7.03984, 7.08037, 7.05408, 7.08345, 7.04036, 290407], ['USDCNH.FXCM', '20200610', 7.07332, 7.05245, 7.08244, 7.03984, 7.08037, 7.05408, 7.08345, 7.04036, 290407], ['USDCNH.FXCM', '20200609', 7.05405, 7.07332, 7.09153, 7.05405, 7.05828, 7.08037, 7.09211, 7.0569, 275831], ['USDCNH.FXCM', '20200609', 7.05414, 7.07332, 7.09153, 7.05405, 7.05751, 7.08037, 7.09211, 7.0569, 275833], ['USDCNH.FXCM', '20200609', 7.05414, 7.07332, 7.09153, 7.05405, 7.05751, 7.08037, 7.09211, 7.0569, 275833], ['USDCNH.FXCM', '20200609', 7.05414, 7.07332, 7.09153, 7.05405, 7.05751, 7.08037, 7.09211, 7.0569, 275833], ['USDCNH.FXCM', '20200608', 7.06702, 7.07452, 7.07562, 7.06464, 7.07018, 7.07506, 7.07627, 7.06534, 12697], ['USDCNH.FXCM', '20200608', 7.06721, 7.05414, 7.08709, 7.0541, 7.06999, 7.05751, 7.08757, 7.05468, 239572], ['USDCNH.FXCM', '20200608', 7.06721, 7.05414, 7.08709, 7.0541, 7.06999, 7.05751, 7.08757, 7.05468, 239572], ['USDCNH.FXCM', '20200608', 7.06721, 7.05414, 7.08709, 7.0541, 7.06999, 7.05751, 7.08757, 7.05468, 239572], ['USDCNH.FXCM', '20200607', 7.06771, 7.06702, 7.06774, 7.06498, 7.07592, 7.07018, 7.07804, 7.06999, 172], ['USDCNH.FXCM', '20200607', 7.06492, 7.06721, 7.06774, 7.06498, 7.07505, 7.06999, 7.07804, 7.06999, 171], ['USDCNH.FXCM', '20200607', 7.06492, 7.06721, 7.06774, 7.06498, 7.07505, 7.06999, 7.07804, 7.06999, 171], ['USDCNH.FXCM', '20200607', 7.06492, 7.06721, 7.06774, 7.06498, 7.07505, 7.06999, 7.07804, 7.06999, 171], ['USDCNH.FXCM', '20200605', 7.10756, 7.11158, 7.11443, 7.10305, 7.11006, 7.11221, 7.11496, 7.10737, 47974], ['USDCNH.FXCM', '20200605', 7.10748, 7.06492, 7.11746, 7.06469, 7.10978, 7.07505, 7.118, 7.06789, 371400], ['USDCNH.FXCM', '20200605', 7.10748, 7.06492, 7.11746, 7.06469, 7.10978, 7.07505, 7.118, 7.06789, 371400], ['USDCNH.FXCM', '20200605', 7.10748, 7.06492, 7.11746, 7.06469, 7.10978, 7.07505, 7.118, 7.06789, 371400], ['USDCNH.FXCM', '20200604', 7.11319, 7.10756, 7.13347, 7.10332, 7.12018, 7.11006, 7.13401, 7.10375, 293097], ['USDCNH.FXCM', '20200604', 7.11319, 7.10748, 7.13347, 7.10332, 7.12018, 7.10978, 7.13401, 7.10375, 293096], ['USDCNH.FXCM', '20200604', 7.11319, 7.10748, 7.13347, 7.10332, 7.12018, 7.10978, 7.13401, 7.10375, 293096], ['USDCNH.FXCM', '20200604', 7.11319, 7.10748, 7.13347, 7.10332, 7.12018, 7.10978, 7.13401, 7.10375, 293096], ['USDCNH.FXCM', '20200603', 7.10464, 7.11319, 7.12704, 7.08763, 7.10907, 7.12018, 7.12773, 7.0884, 329890], ['USDCNH.FXCM', '20200603', 7.10464, 7.11319, 7.12704, 7.08763, 7.10907, 7.12018, 7.12773, 7.0884, 329890], ['USDCNH.FXCM', '20200603', 7.10464, 7.11319, 7.12704, 7.08763, 7.10907, 7.12018, 7.12773, 7.0884, 329890], ['USDCNH.FXCM', '20200603', 7.10464, 7.11319, 7.12704, 7.08763, 7.10907, 7.12018, 7.12773, 7.0884, 329890], ['USDCNH.FXCM', '20200602', 7.12466, 7.12429, 7.13161, 7.12285, 7.12829, 7.12538, 7.13324, 7.1236, 10870], ['USDCNH.FXCM', '20200602', 7.12483, 7.10464, 7.13312, 7.10139, 7.12833, 7.10907, 7.13366, 7.10189, 237113], ['USDCNH.FXCM', '20200602', 7.12483, 7.10464, 7.13312, 7.10139, 7.12833, 7.10907, 7.13366, 7.10189, 237113], ['USDCNH.FXCM', '20200602', 7.12483, 7.10464, 7.13312, 7.10139, 7.12833, 7.10907, 7.13366, 7.10189, 237113], ['USDCNH.FXCM', '20200601', 7.13601, 7.12466, 7.15159, 7.12287, 7.13909, 7.12829, 7.15211, 7.12339, 273440], ['USDCNH.FXCM', '20200601', 7.13601, 7.12483, 7.15159, 7.12287, 7.13909, 7.12833, 7.15211, 7.12339, 273439], ['USDCNH.FXCM', '20200601', 7.13601, 7.12483, 7.15159, 7.12287, 7.13909, 7.12833, 7.15211, 7.12339, 273439], ['USDCNH.FXCM', '20200601', 7.13601, 7.12483, 7.15159, 7.12287, 7.13909, 7.12833, 7.15211, 7.12339, 273439], ['USDCNH.FXCM', '20200531', 7.13113, 7.13601, 7.13601, 7.13113, 7.14075, 7.13909, 7.14136, 7.13518, 103], ['USDCNH.FXCM', '20200531', 7.13154, 7.13601, 7.13601, 7.13113, 7.13625, 7.13909, 7.14136, 7.13518, 103], ['USDCNH.FXCM', '20200531', 7.13154, 7.13601, 7.13601, 7.13113, 7.13625, 7.13909, 7.14136, 7.13518, 103], ['USDCNH.FXCM', '20200531', 7.13154, 7.13601, 7.13601, 7.13113, 7.13625, 7.13909, 7.14136, 7.13518, 103], ['USDCNH.FXCM', '20200529', 7.16902, 7.13154, 7.17684, 7.13073, 7.17721, 7.13625, 7.17739, 7.13176, 304350], ['USDCNH.FXCM', '20200529', 7.16902, 7.13154, 7.17684, 7.13073, 7.17721, 7.13625, 7.17739, 7.13176, 304350], ['USDCNH.FXCM', '20200529', 7.16902, 7.13154, 7.17684, 7.13073, 7.17721, 7.13625, 7.17739, 7.13176, 304350], ['USDCNH.FXCM', '20200529', 7.16902, 7.13154, 7.17684, 7.13073, 7.17721, 7.13625, 7.17739, 7.13176, 304350], ['USDCNH.FXCM', '20200528', 7.17469, 7.16902, 7.18731, 7.15372, 7.17778, 7.17721, 7.1882, 7.15425, 297213], ['USDCNH.FXCM', '20200528', 7.17507, 7.16902, 7.18731, 7.15372, 7.17849, 7.17721, 7.1882, 7.15425, 297215], ['USDCNH.FXCM', '20200528', 7.17507, 7.16902, 7.18731, 7.15372, 7.17849, 7.17721, 7.1882, 7.15425, 297215], ['USDCNH.FXCM', '20200528', 7.17507, 7.16902, 7.18731, 7.15372, 7.17849, 7.17721, 7.1882, 7.15425, 297215], ['USDCNH.FXCM', '20200527', 7.14172, 7.17469, 7.19626, 7.14172, 7.14754, 7.17778, 7.19677, 7.14309, 317796], ['USDCNH.FXCM', '20200527', 7.14127, 7.17507, 7.19626, 7.14127, 7.14665, 7.17849, 7.19677, 7.14309, 324385], ['USDCNH.FXCM', '20200527', 7.14127, 7.17507, 7.19626, 7.14127, 7.14665, 7.17849, 7.19677, 7.14309, 324385], ['USDCNH.FXCM', '20200527', 7.14127, 7.17507, 7.19626, 7.14127, 7.14665, 7.17849, 7.19677, 7.14309, 324385], ['USDCNH.FXCM', '20200526', 7.14698, 7.14162, 7.15047, 7.13955, 7.14916, 7.14229, 7.15289, 7.14007, 49000], ['USDCNH.FXCM', '20200526', 7.14713, 7.14127, 7.15047, 7.13539, 7.14945, 7.14665, 7.15289, 7.13586, 261661], ['USDCNH.FXCM', '20200526', 7.14713, 7.14127, 7.15047, 7.13539, 7.14945, 7.14665, 7.15289, 7.13586, 261661], ['USDCNH.FXCM', '20200526', 7.14713, 7.14127, 7.15047, 7.13539, 7.14945, 7.14665, 7.15289, 7.13586, 261661], ['USDCNH.FXCM', '20200525', 7.15204, 7.14698, 7.15832, 7.14489, 7.15496, 7.14916, 7.15887, 7.14571, 164561], ['USDCNH.FXCM', '20200525', 7.15204, 7.14713, 7.15832, 7.14489, 7.15496, 7.14945, 7.15887, 7.14571, 164560], ['USDCNH.FXCM', '20200525', 7.15204, 7.14713, 7.15832, 7.14489, 7.15496, 7.14945, 7.15887, 7.14571, 164560], ['USDCNH.FXCM', '20200525', 7.15204, 7.14713, 7.15832, 7.14489, 7.15496, 7.14945, 7.15887, 7.14571, 164560], ['USDCNH.FXCM', '20200524', 7.15102, 7.15204, 7.1534, 7.1476, 7.16031, 7.15496, 7.16031, 7.15268, 103], ['USDCNH.FXCM', '20200524', 7.1453, 7.15204, 7.1534, 7.1476, 7.15112, 7.15496, 7.16031, 7.15268, 103], ['USDCNH.FXCM', '20200524', 7.1453, 7.15204, 7.1534, 7.1476, 7.15112, 7.15496, 7.16031, 7.15268, 103], ['USDCNH.FXCM', '20200524', 7.1453, 7.15204, 7.1534, 7.1476, 7.15112, 7.15496, 7.16031, 7.15268, 103], ['USDCNH.FXCM', '20200522', 7.13061, 7.1453, 7.1643, 7.12631, 7.13938, 7.15112, 7.16467, 7.127, 268242], ['USDCNH.FXCM', '20200522', 7.12939, 7.1453, 7.1643, 7.12631, 7.13621, 7.15112, 7.16467, 7.127, 268244], ['USDCNH.FXCM', '20200522', 7.12939, 7.1453, 7.1643, 7.12631, 7.13621, 7.15112, 7.16467, 7.127, 268244], ['USDCNH.FXCM', '20200522', 7.12939, 7.1453, 7.1643, 7.12631, 7.13621, 7.15112, 7.16467, 7.127, 268244], ['USDCNH.FXCM', '20200521', 7.10244, 7.13061, 7.13616, 7.10225, 7.11078, 7.13938, 7.13938, 7.10439, 235811], ['USDCNH.FXCM', '20200521', 7.10254, 7.12939, 7.13616, 7.10225, 7.10778, 7.13621, 7.13705, 7.10439, 238988], ['USDCNH.FXCM', '20200521', 7.10254, 7.12939, 7.13616, 7.10225, 7.10778, 7.13621, 7.13705, 7.10439, 238988], ['USDCNH.FXCM', '20200521', 7.10254, 7.12939, 7.13616, 7.10225, 7.10778, 7.13621, 7.13705, 7.10439, 238988], ['USDCNH.FXCM', '20200520', 7.11691, 7.10244, 7.12471, 7.09834, 7.1203, 7.11078, 7.12513, 7.09881, 194621], ['USDCNH.FXCM', '20200520', 7.11691, 7.10254, 7.12471, 7.09834, 7.1203, 7.10778, 7.12513, 7.09881, 200442], ['USDCNH.FXCM', '20200520', 7.11691, 7.10254, 7.12471, 7.09834, 7.1203, 7.10778, 7.12513, 7.09881, 200442], ['USDCNH.FXCM', '20200520', 7.11691, 7.10254, 7.12471, 7.09834, 7.1203, 7.10778, 7.12513, 7.09881, 200442], ['USDCNH.FXCM', '20200519', 7.11613, 7.11691, 7.12674, 7.10882, 7.11961, 7.1203, 7.12727, 7.10939, 201102], ['USDCNH.FXCM', '20200519', 7.11661, 7.11691, 7.12674, 7.10882, 7.12009, 7.1203, 7.12727, 7.10939, 209366], ['USDCNH.FXCM', '20200519', 7.11661, 7.11691, 7.12674, 7.10882, 7.12009, 7.1203, 7.12727, 7.10939, 209366], ['USDCNH.FXCM', '20200519', 7.11661, 7.11691, 7.12674, 7.10882, 7.12009, 7.1203, 7.12727, 7.10939, 209366], ['USDCNH.FXCM', '20200518', 7.12928, 7.11613, 7.14461, 7.11613, 7.13232, 7.11961, 7.14515, 7.11678, 225824], ['USDCNH.FXCM', '20200518', 7.12928, 7.11661, 7.14461, 7.11615, 7.13232, 7.12009, 7.14515, 7.11678, 225823], ['USDCNH.FXCM', '20200518', 7.12928, 7.11661, 7.14461, 7.11615, 7.13232, 7.12009, 7.14515, 7.11678, 225823], ['USDCNH.FXCM', '20200518', 7.12928, 7.11661, 7.14461, 7.11615, 7.13232, 7.12009, 7.14515, 7.11678, 225823], ['USDCNH.FXCM', '20200517', 7.13164, 7.12928, 7.13173, 7.126, 7.13681, 7.13232, 7.13856, 7.13218, 147], ['USDCNH.FXCM', '20200517', 7.13038, 7.12928, 7.13173, 7.126, 7.13758, 7.13232, 7.13856, 7.13218, 147], ['USDCNH.FXCM', '20200517', 7.13038, 7.12928, 7.13173, 7.126, 7.13758, 7.13232, 7.13856, 7.13218, 147], ['USDCNH.FXCM', '20200517', 7.13038, 7.12928, 7.13173, 7.126, 7.13758, 7.13232, 7.13856, 7.13218, 147], ['USDCNH.FXCM', '20200515', 7.10837, 7.11214, 7.11247, 7.10732, 7.11408, 7.11276, 7.11411, 7.10846, 14964], ['USDCNH.FXCM', '20200514', 7.10991, 7.11015, 7.11261, 7.10712, 7.11415, 7.11083, 7.11417, 7.10864, 16354], ['USDCNH.FXCM', '20200513', 7.10192, 7.10385, 7.10955, 7.10076, 7.11238, 7.10443, 7.11243, 7.10437, 20593], ['USDCNH.FXCM', '20200512', 7.10297, 7.11071, 7.11359, 7.10202, 7.11273, 7.11137, 7.11457, 7.10576, 17940], ['USDCNH.FXCM', '20200511', 7.09311, 7.09098, 7.09632, 7.08881, 7.09499, 7.09197, 7.10017, 7.09026, 14404], ['USDCNH.FXCM', '20200510', 7.0902, 7.09311, 7.09312, 7.08895, 7.09957, 7.09499, 7.09966, 7.09488, 84], ['USDCNH.FXCM', '20200508', 7.08972, 7.08477, 7.09192, 7.08191, 7.09546, 7.08584, 7.09546, 7.08274, 16543], ['USDCNH.FXCM', '20200507', 7.12805, 7.1287, 7.13687, 7.12356, 7.13202, 7.12958, 7.13784, 7.12522, 19161], ['USDCNH.FXCM', '20200506', 7.11953, 7.11887, 7.12464, 7.11403, 7.12591, 7.11991, 7.12881, 7.11649, 42244], ['USDCNH.FXCM', '20200505', 7.12877, 7.11953, 7.13197, 7.11077, 7.13173, 7.12591, 7.1348, 7.11135, 235364], ['USDCNH.FXCM', '20200504', 7.1312, 7.12877, 7.15583, 7.12198, 7.14056, 7.13173, 7.15875, 7.12265, 275679], ['USDCNH.FXCM', '20200503', 7.13864, 7.1312, 7.13931, 7.13096, 7.14071, 7.14056, 7.14183, 7.13627, 139], ['USDCNH.FXCM', '20200501', 7.07871, 7.10376, 7.10454, 7.07323, 7.08428, 7.10519, 7.1055, 7.07907, 36163], ['USDCNH.FXCM', '20200430', 7.07055, 7.0749, 7.07608, 7.07031, 7.07612, 7.07568, 7.07722, 7.07212, 42846], ['USDCNH.FXCM', '20200429', 7.08758, 7.08086, 7.08888, 7.08007, 7.08924, 7.08164, 7.09042, 7.08096, 15137], ['USDCNH.FXCM', '20200428', 7.08912, 7.08884, 7.0942, 7.08835, 7.09571, 7.08956, 7.09571, 7.08922, 15393], ['USDCNH.FXCM', '20200427', 7.08782, 7.08801, 7.09013, 7.08585, 7.09699, 7.08874, 7.09721, 7.08665, 51520], ['USDCNH.FXCM', '20200426', 7.08707, 7.08782, 7.09002, 7.08687, 7.09726, 7.09699, 7.09733, 7.09675, 71], ['USDCNH.FXCM', '20200424', 7.09271, 7.09479, 7.09557, 7.08959, 7.09588, 7.09531, 7.09672, 7.09179, 15958], ['USDCNH.FXCM', '20200423', 7.09791, 7.09911, 7.10296, 7.0956, 7.10497, 7.09996, 7.10568, 7.09903, 75532], ['USDCNH.FXCM', '20200422', 7.09825, 7.10395, 7.1045, 7.09806, 7.10516, 7.10485, 7.10579, 7.09991, 28112], ['USDCNH.FXCM', '20200421', 7.08895, 7.08971, 7.09202, 7.08278, 7.09325, 7.09052, 7.09395, 7.08406, 32195], ['USDCNH.FXCM', '20200420', 7.07712, 7.07625, 7.08284, 7.07589, 7.08398, 7.07908, 7.08556, 7.07819, 49027], ['USDCNH.FXCM', '20200419', 7.07671, 7.07712, 7.07712, 7.07555, 7.08487, 7.08398, 7.08712, 7.08398, 46], ['USDCNH.FXCM', '20200417', 7.08706, 7.07482, 7.08807, 7.07118, 7.08858, 7.07581, 7.09191, 7.07307, 32709], ['USDCNH.FXCM', '20200416', 7.06977, 7.07995, 7.08037, 7.06877, 7.07258, 7.08067, 7.08136, 7.07089, 36587], ['USDCNH.FXCM', '20200415', 7.04585, 7.0457, 7.04804, 7.04298, 7.04853, 7.04671, 7.05041, 7.04601, 24890], ['USDCNH.FXCM', '20200414', 7.05239, 7.05244, 7.05677, 7.05066, 7.05771, 7.05394, 7.06141, 7.05173, 36089], ['USDCNH.FXCM', '20200413', 7.04363, 7.05477, 7.05481, 7.04274, 7.04487, 7.05675, 7.05689, 7.04487, 10176], ['USDCNH.FXCM', '20200412', 7.04241, 7.04363, 7.04387, 7.04075, 7.04891, 7.04487, 7.05026, 7.04458, 115], ['USDCNH.FXCM', '20200410', 7.05844, 7.05745, 7.06079, 7.0514, 7.06026, 7.05905, 7.06227, 7.05729, 3330], ['USDCNH.FXCM', '20200409', 7.06789, 7.06645, 7.06859, 7.06492, 7.06909, 7.06751, 7.07069, 7.06614, 4923], ['USDCNH.FXCM', '20200408', 7.06395, 7.0734, 7.07611, 7.05961, 7.07015, 7.07427, 7.07695, 7.06333, 15117], ['USDCNH.FXCM', '20200407', 7.10448, 7.10323, 7.10783, 7.10065, 7.10922, 7.10386, 7.11228, 7.10163, 10125], ['USDCNH.FXCM', '20200406', 7.10682, 7.10392, 7.11895, 7.10261, 7.11623, 7.10475, 7.12049, 7.10419, 20099], ['USDCNH.FXCM', '20200403', 7.08965, 7.10647, 7.11965, 7.08198, 7.09795, 7.11499, 7.12015, 7.08938, 319936], ['USDCNH.FXCM', '20200402', 7.12234, 7.08965, 7.14208, 7.08965, 7.12286, 7.09795, 7.14273, 7.09242, 233315], ['USDCNH.FXCM', '20200401', 7.09174, 7.08909, 7.09655, 7.08625, 7.09603, 7.09013, 7.09862, 7.08904, 14429], ['USDCNH.FXCM', '20200331', 7.10932, 7.10572, 7.11661, 7.10521, 7.1186, 7.10678, 7.12185, 7.10648, 39929], ['USDCNH.FXCM', '20200330', 7.08514, 7.10342, 7.10579, 7.08514, 7.09091, 7.10491, 7.10743, 7.08863, 19500], ['USDCNH.FXCM', '20200329', 7.08442, 7.08514, 7.08514, 7.08442, 7.09109, 7.09091, 7.09109, 7.09091, 2], ['USDCNH.FXCM', '20200327', 7.07724, 7.08165, 7.08634, 7.0739, 7.08521, 7.08346, 7.09066, 7.07976, 39594], ['USDCNH.FXCM', '20200326', 7.12381, 7.12303, 7.13817, 7.11983, 7.13026, 7.12456, 7.1407, 7.12331, 27108], ['USDCNH.FXCM', '20200325', 7.08008, 7.08386, 7.08705, 7.06895, 7.08922, 7.08639, 7.09139, 7.07146, 15648], ['USDCNH.FXCM', '20200324', 7.11439, 7.10455, 7.12328, 7.10234, 7.12271, 7.1081, 7.12915, 7.10544, 40972], ['USDCNH.FXCM', '20200323', 7.1237, 7.14094, 7.14647, 7.12174, 7.13318, 7.1419, 7.14749, 7.13107, 79165], ['USDCNH.FXCM', '20200320', 7.15442, 7.15275, 7.16239, 7.14865, 7.16038, 7.15394, 7.1649, 7.15088, 46156], ['USDCNH.FXCM', '20200319', 7.07063, 7.07459, 7.07721, 7.05791, 7.07781, 7.07742, 7.08226, 7.06116, 55549], ['USDCNH.FXCM', '20200318', 7.02744, 7.02217, 7.03193, 7.01956, 7.03523, 7.02506, 7.03824, 7.02083, 30720], ['USDCNH.FXCM', '20200317', 7.01209, 7.01508, 7.01617, 7.00474, 7.01368, 7.01616, 7.01727, 7.00847, 175455], ['USDCNH.FXCM', '20200316', 7.02991, 7.01209, 7.02991, 6.98342, 7.03369, 7.01368, 7.03589, 6.98541, 496355], ['USDCNH.FXCM', '20200315', 7.0291, 7.02991, 7.02992, 7.0282, 7.03501, 7.03369, 7.03616, 7.03364, 40], ['USDCNH.FXCM', '20200313', 7.02465, 7.04474, 7.05213, 7.02, 7.03034, 7.04668, 7.05334, 7.02449, 65605], ['USDCNH.FXCM', '20200312', 6.96772, 6.97499, 6.98009, 6.96475, 6.97, 6.97577, 6.98118, 6.96778, 32658], ['USDCNH.FXCM', '20200311', 6.96297, 6.95734, 6.96368, 6.95609, 6.96578, 6.95848, 6.96869, 6.9576, 5399], ['USDCNH.FXCM', '20200310', 6.95005, 6.94907, 6.95472, 6.94221, 6.95615, 6.95026, 6.95771, 6.94485, 100576], ['USDCNH.FXCM', '20200309', 6.93151, 6.92619, 6.93492, 6.91811, 6.93728, 6.92818, 6.93828, 6.91917, 25254], ['USDCNH.FXCM', '20200308', 6.93288, 6.93151, 6.934, 6.92808, 6.94103, 6.93728, 6.94103, 6.93526, 111], ['USDCNH.FXCM', '20200306', 6.94014, 6.93759, 6.94076, 6.93675, 6.94206, 6.93826, 6.94308, 6.93758, 18159], ['USDCNH.FXCM', '20200305', 6.92142, 6.92528, 6.92838, 6.92126, 6.92495, 6.92609, 6.92937, 6.92313, 15564], ['USDCNH.FXCM', '20200304', 6.94599, 6.93959, 6.95067, 6.935, 6.9523, 6.94059, 6.95379, 6.93609, 31033], ['USDCNH.FXCM', '20200303', 6.95658, 6.96073, 6.96228, 6.94966, 6.96529, 6.96154, 6.96529, 6.95561, 25387], ['USDCNH.FXCM', '20200302', 6.99148, 6.98641, 6.99228, 6.98224, 6.99454, 6.98761, 6.99483, 6.98396, 8814], ['USDCNH.FXCM', '20200301', 6.9936, 6.99148, 6.99431, 6.9906, 6.99871, 6.99454, 6.99871, 6.9933, 164], ['USDCNH.FXCM', '20200228', 7.0086, 6.97722, 7.02054, 6.97442, 7.0117, 6.98208, 7.02105, 6.97817, 511579], ['USDCNH.FXCM', '20200227', 7.0189, 7.02255, 7.02544, 7.0188, 7.02298, 7.02317, 7.02604, 7.02064, 14498], ['USDCNH.FXCM', '20200226', 7.02248, 7.03324, 7.03739, 7.02248, 7.03003, 7.03387, 7.03815, 7.02464, 55032], ['USDCNH.FXCM', '20200225', 7.0341, 7.02248, 7.03632, 7.01278, 7.03745, 7.03003, 7.03859, 7.01324, 302214], ['USDCNH.FXCM', '20200224', 7.04822, 7.0341, 7.05613, 7.02745, 7.05098, 7.03745, 7.05699, 7.02792, 303041], ['USDCNH.FXCM', '20200223', 7.04001, 7.04822, 7.05243, 7.04001, 7.04456, 7.05098, 7.05292, 7.04456, 168], ['USDCNH.FXCM', '20200221', 7.04384, 7.03012, 7.05692, 7.03012, 7.04885, 7.03961, 7.05755, 7.03445, 291532], ['USDCNH.FXCM', '20200220', 7.01255, 7.04384, 7.05462, 7.00733, 7.01393, 7.04885, 7.05515, 7.00808, 277857], ['USDCNH.FXCM', '20200219', 7.00395, 7.01255, 7.01704, 6.99329, 7.00988, 7.01393, 7.0175, 6.99381, 380628], ['USDCNH.FXCM', '20200218', 6.98878, 7.00395, 7.01081, 6.98764, 6.98943, 7.00988, 7.01132, 6.9881, 173471], ['USDCNH.FXCM', '20200214', 6.98761, 6.98946, 6.99653, 6.98082, 6.99073, 6.99568, 6.99695, 6.98125, 179278], ['USDCNH.FXCM', '20200213', 6.97334, 6.98761, 6.99189, 6.97158, 6.97488, 6.99073, 6.99315, 6.9723, 235509], ['USDCNH.FXCM', '20200212', 6.96988, 6.97334, 6.9766, 6.95725, 6.97147, 6.97488, 6.97717, 6.95772, 200273], ['USDCNH.FXCM', '20200211', 6.9824, 6.96988, 6.98423, 6.96253, 6.98665, 6.97147, 6.98698, 6.96306, 195427], ['USDCNH.FXCM', '20200210', 7.00622, 6.9824, 7.01201, 6.97708, 7.01008, 6.98665, 7.01395, 6.97766, 232707], ['USDCNH.FXCM', '20200209', 7.00074, 7.00622, 7.00622, 7.00074, 7.00528, 7.01008, 7.01028, 7.00524, 101], ['USDCNH.FXCM', '20200208', 6.9778, 7.00522, 7.00946, 6.97163, 6.9795, 7.0102, 7.0102, 6.97596, 246186], ['USDCNH.FXCM', '20200206', 6.9739, 6.9778, 6.9803, 6.95706, 6.978, 6.9795, 6.98075, 6.95752, 259158], ['USDCNH.FXCM', '20200205', 6.98828, 6.9739, 7.01011, 6.96298, 6.98954, 6.978, 7.01063, 6.96355, 331730], ['USDCNH.FXCM', '20200204', 7.01043, 6.98828, 7.02284, 6.98558, 7.01768, 6.98954, 7.0235, 6.98598, 265896], ['USDCNH.FXCM', '20200203', 6.99052, 7.01043, 7.02273, 6.98396, 6.99458, 7.01768, 7.02332, 6.9847, 292150], ['USDCNH.FXCM', '20200202', 6.99707, 6.99052, 6.99138, 6.98489, 7.00231, 6.99458, 6.99756, 6.98998, 177], ['USDCNH.FXCM', '20200131', 6.98055, 6.99707, 7.00679, 6.97155, 6.98551, 7.00231, 7.00724, 6.97205, 266068], ['USDCNH.FXCM', '20200130', 6.96864, 6.98055, 7.00355, 6.96531, 6.97027, 6.98551, 7.00404, 6.96831, 275968], ['USDCNH.FXCM', '20200129', 6.96456, 6.96864, 6.96982, 6.95286, 6.96749, 6.97027, 6.97239, 6.95333, 218548], ['USDCNH.FXCM', '20200128', 6.98413, 6.96456, 6.98803, 6.96447, 6.98778, 6.96749, 6.98975, 6.96621, 328958], ['USDCNH.FXCM', '20200127', 6.94511, 6.98413, 6.98954, 6.94435, 6.94843, 6.98778, 6.99015, 6.94818, 344640], ['USDCNH.FXCM', '20200126', 6.92636, 6.94511, 6.94881, 6.94022, 6.93388, 6.94843, 6.95011, 6.94389, 375], ['USDCNH.FXCM', '20200124', 6.92834, 6.92636, 6.93863, 6.92097, 6.93026, 6.93388, 6.93909, 6.92149, 244986], ['USDCNH.FXCM', '20200123', 6.9085, 6.92834, 6.94218, 6.90788, 6.9126, 6.93026, 6.94274, 6.90948, 247558], ['USDCNH.FXCM', '20200122', 6.90829, 6.9085, 6.9179, 6.89574, 6.91, 6.9126, 6.91837, 6.89618, 234499], ['USDCNH.FXCM', '20200121', 6.86603, 6.90829, 6.91262, 6.8637, 6.86852, 6.91, 6.91315, 6.86735, 264744], ['USDCNH.FXCM', '20200120', 6.85891, 6.86603, 6.87353, 6.84545, 6.86499, 6.86852, 6.87411, 6.84591, 183330], ['USDCNH.FXCM', '20200119', 6.86561, 6.85891, 6.85921, 6.85822, 6.87024, 6.86499, 6.86806, 6.86499, 53], ['USDCNH.FXCM', '20200117', 6.8749, 6.86561, 6.88251, 6.85776, 6.87814, 6.87024, 6.88317, 6.85825, 221796], ['USDCNH.FXCM', '20200116', 6.89004, 6.8749, 6.8946, 6.87218, 6.89505, 6.87814, 6.89579, 6.87263, 205324], ['USDCNH.FXCM', '20200115', 6.88768, 6.89004, 6.90532, 6.88469, 6.88943, 6.89505, 6.90643, 6.88563, 220223], ['USDCNH.FXCM', '20200114', 6.88052, 6.88768, 6.89233, 6.86602, 6.88447, 6.88943, 6.89302, 6.86663, 271451], ['USDCNH.FXCM', '20200113', 6.91051, 6.88052, 6.91573, 6.88006, 6.91749, 6.88447, 6.91756, 6.88051, 253118], ['USDCNH.FXCM', '20200112', 6.91038, 6.91051, 6.91051, 6.90964, 6.91945, 6.91749, 6.91859, 6.91749, 18], ['USDCNH.FXCM', '20200110', 6.92417, 6.91038, 6.93344, 6.90982, 6.92544, 6.91945, 6.93395, 6.91041, 171879], ['USDCNH.FXCM', '20200109', 6.93583, 6.92417, 6.93737, 6.91704, 6.93721, 6.92544, 6.94078, 6.91756, 211169], ['USDCNH.FXCM', '20200108', 6.96882, 6.94316, 6.96946, 6.92901, 6.97012, 6.94368, 6.97024, 6.92961, 191682], ['USDCNH.FXCM', '20200107', 6.9422, 6.94039, 6.94536, 6.94018, 6.9428, 6.94491, 6.9463, 6.94109, 6841], ['USDCNH.FXCM', '20200106', 6.96816, 6.96882, 6.97758, 6.96219, 6.97406, 6.97012, 6.97811, 6.96291, 193460], ['USDCNH.FXCM', '20200105', 6.96892, 6.96816, 6.96892, 6.96816, 6.97406, 6.97406, 6.97406, 6.97406, 2], ['USDCNH.FXCM', '20200104', 6.95724, 6.96511, 6.9744, 6.9562, 6.96135, 6.96966, 6.9748, 6.95734, 236833], ['USDCNH.FXCM', '20200102', 6.96438, 6.95724, 6.9647, 6.95628, 6.9655, 6.96135, 6.9655, 6.95697, 112419]], 'has_more': False}
        #
        res = requests.post(self.__http_url, json=req_params, timeout=self.__timeout, headers={'Connection': 'close'})
        if res:
            result = json.loads(res.text)
            if result['code'] != 200:
                raise Exception(result['message'])
            data = result['data']

            # 返回数据的字段，以及数据的items
            # print("------------")
            # print(data)
            # print("------------")
            columns = data['fields']
            items = data['items']
            # 构造一个pandas对象
            return pd.DataFrame(items, columns=columns)
        else:
            raise Exception(res.text)

    def __getattr__(self, name):
        return partial(self.query, name)
