import * as asg from '@aws-cdk/aws-autoscaling';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as sns from '@aws-cdk/aws-sns';
import * as cdk from '@aws-cdk/core';
import { DockerVolumes } from './gitlab-runner-interfaces';
/**
 * (experimental) GitlabRunnerAutoscaling Props.
 *
 * @experimental
 */
export interface GitlabRunnerAutoscalingProps {
    /**
     * (experimental) Gitlab token.
     *
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN' });
     */
    readonly gitlabToken: string;
    /**
     * (experimental) Image URL of Gitlab Runner.
     *
     * @default public.ecr.aws/gitlab/gitlab-runner:alpine
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', gitlabRunnerImage: 'gitlab/gitlab-runner:alpine' });
     */
    readonly gitlabRunnerImage?: string;
    /**
     * (experimental) Runner default EC2 instance type.
     *
     * @default - t3.micro
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', instanceType: 't3.small' });
     */
    readonly instanceType?: string;
    /**
     * (experimental) VPC for the Gitlab Runner .
     *
     * @default - A new VPC will be created.
     * @experimental
     * @example
     *
     * const newVpc = new Vpc(stack, 'NewVPC', {
     *   cidr: '10.1.0.0/16',
     *   maxAzs: 2,
     *   subnetConfiguration: [{
     *     cidrMask: 26,
     *     name: 'RunnerVPC',
     *     subnetType: SubnetType.PUBLIC,
     *   }],
     *   natGateways: 0,
     * });
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', vpc: newVpc });
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) IAM role for the Gitlab Runner Instance .
     *
     * @default - new Role for Gitlab Runner Instance , attach AmazonSSMManagedInstanceCore Policy .
     * @experimental
     * @example
     *
     * const role = new Role(stack, 'runner-role', {
     *   assumedBy: new ServicePrincipal('ec2.amazonaws.com'),
     *   description: 'For Gitlab Runner Test Role',
     *   roleName: 'Runner-Role',
     * });
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', instanceRole: role });
     */
    readonly instanceRole?: iam.IRole;
    /**
     * (experimental) Run worker nodes as EC2 Spot.
     *
     * @default - false
     * @experimental
     */
    readonly spotInstance?: boolean;
    /**
     * (experimental) Minimum capacity limit for autoscaling group.
     *
     * @default - minCapacity: 1
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', minCapacity: 2 });
     */
    readonly minCapacity?: number;
    /**
     * (experimental) Maximum capacity limit for autoscaling group.
     *
     * @default - desiredCapacity
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', maxCapacity: 4 });
     */
    readonly maxCapacity?: number;
    /**
     * (experimental) Desired capacity limit for autoscaling group.
     *
     * @default - minCapacity, and leave unchanged during deployment
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', desiredCapacity: 2 });
     */
    readonly desiredCapacity?: number;
    /**
     * (experimental) tags for the runner.
     *
     * @default - ['runner', 'gitlab', 'awscdk']
     * @experimental
     */
    readonly tags?: string[];
    /**
     * (experimental) Gitlab Runner register url .
     *
     * @default - https://gitlab.com/ , The trailing slash is mandatory.
     * @experimental
     * @example
     *
     * const runner = new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN',gitlabUrl: 'https://gitlab.com/'});
     */
    readonly gitlabUrl?: string;
    /**
     * (experimental) Gitlab Runner instance EBS size .
     *
     * @default - ebsSize=60
     * @experimental
     * @example
     *
     * const runner = new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', ebsSize: 100});
     */
    readonly ebsSize?: number;
    /**
     * (experimental) VPC subnet.
     *
     * @default - private subnet
     * @experimental
     * @example
     *
     * const vpc = new Vpc(stack, 'nat', {
     * natGateways: 1,
     * maxAzs: 2,
     * });
     * const runner = new GitlabRunnerAutoscaling(stack, 'testing', {
     *   gitlabToken: 'GITLAB_TOKEN',
     *   instanceType: 't3.large',
     *   instanceRole: role,
     *   ebsSize: 100,
     *   vpc: vpc,
     *   vpcSubnet: {
     *     subnetType: SubnetType.PUBLIC,
     *   },
     * });
     */
    readonly vpcSubnet?: ec2.SubnetSelection;
    /**
     * (experimental) add another Gitlab Container Runner Docker Volumes Path at job runner runtime.
     *
     * more detail see https://docs.gitlab.com/runner/configuration/advanced-configuration.html#the-runnersdocker-section
     *
     * @default - already mount "/var/run/docker.sock:/var/run/docker.sock"
     * @experimental
     * @example
     *
     * dockerVolumes: [
     *   {
     *     hostPath: '/tmp/cache',
     *     containerPath: '/tmp/cache',
     *   },
     * ],
     */
    readonly dockerVolumes?: DockerVolumes[];
    /**
     * (experimental) Parameters of put_metric_alarm function.
     *
     * https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/cloudwatch.html#CloudWatch.Client.put_metric_alarm
     *
     * @default - [{
     * AlarmName: 'GitlabRunnerDiskUsage',
     * MetricName: 'disk_used_percent',
     * }]
     * @experimental
     */
    readonly alarms?: object[];
}
/**
 * (experimental) GitlabRunnerAutoscaling Construct for create Autoscaling Gitlab Runner.
 *
 * @experimental
 */
export declare class GitlabRunnerAutoscaling extends cdk.Construct {
    /**
     * (experimental) The IAM role assumed by the Runner instance.
     *
     * @experimental
     */
    readonly instanceRole: iam.IRole;
    /**
     * (experimental) This represents a Runner Auto Scaling Group.
     *
     * @experimental
     */
    readonly autoscalingGroup: asg.AutoScalingGroup;
    /**
     * (experimental) The EC2 runner's VPC.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The EC2 runner's default SecurityGroup.
     *
     * @experimental
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * (experimental) The SNS topic to suscribe alarms for EC2 runner's metrics.
     *
     * @experimental
     */
    readonly topicAlarm: sns.ITopic;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: GitlabRunnerAutoscalingProps);
    private dockerVolumesList;
    /**
     * @returns Array.
     * @experimental
     */
    createUserData(props: GitlabRunnerAutoscalingProps): string[];
}
