# coding: utf-8

"""
    STACKL

    stackl  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from stackl_client.api_client import ApiClient
from stackl_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class StackInfrastructureTemplatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_stack_infrastructure_template(self, document_name, type_name, **kwargs):  # noqa: E501
        """Delete Stack Infrastructure Template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_stack_infrastructure_template(document_name, type_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str document_name: (required)
        :param str type_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_stack_infrastructure_template_with_http_info(document_name, type_name, **kwargs)  # noqa: E501

    def delete_stack_infrastructure_template_with_http_info(self, document_name, type_name, **kwargs):  # noqa: E501
        """Delete Stack Infrastructure Template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_stack_infrastructure_template_with_http_info(document_name, type_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str document_name: (required)
        :param str type_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_name',
            'type_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_stack_infrastructure_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_name' is set
        if self.api_client.client_side_validation and ('document_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_name` when calling `delete_stack_infrastructure_template`")  # noqa: E501
        # verify the required parameter 'type_name' is set
        if self.api_client.client_side_validation and ('type_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['type_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type_name` when calling `delete_stack_infrastructure_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_name' in local_var_params:
            path_params['document_name'] = local_var_params['document_name']  # noqa: E501

        query_params = []
        if 'type_name' in local_var_params and local_var_params['type_name'] is not None:  # noqa: E501
            query_params.append(('type_name', local_var_params['type_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stack_infrastructure_templates/{document_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stack_infrastructure_template_by_name(self, document_name, **kwargs):  # noqa: E501
        """Get Stack Infrastructure Template By Name  # noqa: E501

        Returns a functional requirement  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stack_infrastructure_template_by_name(document_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str document_name: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StackInfrastructureTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_stack_infrastructure_template_by_name_with_http_info(document_name, **kwargs)  # noqa: E501

    def get_stack_infrastructure_template_by_name_with_http_info(self, document_name, **kwargs):  # noqa: E501
        """Get Stack Infrastructure Template By Name  # noqa: E501

        Returns a functional requirement  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stack_infrastructure_template_by_name_with_http_info(document_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str document_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StackInfrastructureTemplate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stack_infrastructure_template_by_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_name' is set
        if self.api_client.client_side_validation and ('document_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_name` when calling `get_stack_infrastructure_template_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_name' in local_var_params:
            path_params['document_name'] = local_var_params['document_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stack_infrastructure_templates/{document_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StackInfrastructureTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stack_infrastructure_templates(self, **kwargs):  # noqa: E501
        """Get Stack Infrastructure Templates  # noqa: E501

        Returns all functional requirements with a specific type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stack_infrastructure_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[StackInfrastructureTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_stack_infrastructure_templates_with_http_info(**kwargs)  # noqa: E501

    def get_stack_infrastructure_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Get Stack Infrastructure Templates  # noqa: E501

        Returns all functional requirements with a specific type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stack_infrastructure_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[StackInfrastructureTemplate], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stack_infrastructure_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stack_infrastructure_templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StackInfrastructureTemplate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_stack_infrastructure_template(self, stack_infrastructure_template, **kwargs):  # noqa: E501
        """Post Stack Infrastructure Template  # noqa: E501

        Create the document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_stack_infrastructure_template(stack_infrastructure_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StackInfrastructureTemplate stack_infrastructure_template: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StackInfrastructureTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_stack_infrastructure_template_with_http_info(stack_infrastructure_template, **kwargs)  # noqa: E501

    def post_stack_infrastructure_template_with_http_info(self, stack_infrastructure_template, **kwargs):  # noqa: E501
        """Post Stack Infrastructure Template  # noqa: E501

        Create the document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_stack_infrastructure_template_with_http_info(stack_infrastructure_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StackInfrastructureTemplate stack_infrastructure_template: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StackInfrastructureTemplate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stack_infrastructure_template'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_stack_infrastructure_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stack_infrastructure_template' is set
        if self.api_client.client_side_validation and ('stack_infrastructure_template' not in local_var_params or  # noqa: E501
                                                        local_var_params['stack_infrastructure_template'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stack_infrastructure_template` when calling `post_stack_infrastructure_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stack_infrastructure_template' in local_var_params:
            body_params = local_var_params['stack_infrastructure_template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stack_infrastructure_templates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StackInfrastructureTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_stack_infrastructure_template(self, stack_infrastructure_template, **kwargs):  # noqa: E501
        """Put Stack Infrastructure Template  # noqa: E501

        Create the document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_stack_infrastructure_template(stack_infrastructure_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StackInfrastructureTemplate stack_infrastructure_template: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StackInfrastructureTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_stack_infrastructure_template_with_http_info(stack_infrastructure_template, **kwargs)  # noqa: E501

    def put_stack_infrastructure_template_with_http_info(self, stack_infrastructure_template, **kwargs):  # noqa: E501
        """Put Stack Infrastructure Template  # noqa: E501

        Create the document with a specific type and an optional name given in the payload  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_stack_infrastructure_template_with_http_info(stack_infrastructure_template, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StackInfrastructureTemplate stack_infrastructure_template: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StackInfrastructureTemplate, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stack_infrastructure_template'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_stack_infrastructure_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stack_infrastructure_template' is set
        if self.api_client.client_side_validation and ('stack_infrastructure_template' not in local_var_params or  # noqa: E501
                                                        local_var_params['stack_infrastructure_template'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stack_infrastructure_template` when calling `put_stack_infrastructure_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stack_infrastructure_template' in local_var_params:
            body_params = local_var_params['stack_infrastructure_template']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/stack_infrastructure_templates', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StackInfrastructureTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
