import math
import random
from typing import List, Callable


class RandomInsert:
    def __init__(
        self,
        synonym_func: Callable[[str], List[str]],
        alpha: float,
        max_num_per_doc: int,
    ):
        self.synonym_func = synonym_func
        self.alpha = alpha
        self.max_num_per_doc = max_num_per_doc

    def __call__(self, corpus: List[List[str]]) -> List[List[str]]:
        result_doc_list = []
        for doc in corpus:
            for _ in range(self.max_num_per_doc):
                new_doc = self._insert_doc(doc)
                result_doc_list.append(new_doc)

        result_corpus = list(result_doc_list)
        return result_corpus

    def _insert_doc(self, doc):
        # TODO: random_token and random_idx should be generated by one function (not truly random)
        replace_times = max(1, int(math.ceil(self.alpha * len(doc))))
        new_doc = doc.copy()

        num_replaced = 0
        while True:  # TODO: infinite loop
            if num_replaced >= replace_times:
                break

            random_token = new_doc[random.randint(0, len(new_doc) - 1)]
            candidate_synonym_list = self.synonym_func(random_token)
            if len(candidate_synonym_list):
                synonym = random.choice(candidate_synonym_list)
                random_idx = random.randint(0, len(new_doc))
                new_doc.insert(random_idx, synonym)
                num_replaced += 1

        return new_doc


if __name__ == "__main__":

    def faked_synoym_func(input):
        data = {"北京": ["上海", "杭州"], "读书": ["上学"], "清华大学": ["北京大学"]}
        return data.get(input, [])

    sr = RandomInsert(faked_synoym_func, 0.1, 4)
    result = sr([["王小明", "在", "北京", "的", "清华大学", "读书", "。"]])
    assert len(result) == 4
