# botoplus

## Getting Started

| Notebook | Description |
| -------- | ----------- |
| [start](start.ipynb) | IAM Identity Center (SSO) Login & Logout |

## Threat Detection

### Cloud Development Kit (CDK)

| Notebook | Description |
| -------- | ----------- |
| [identify-cdk-bootstraps](notebooks/cdk/identify-cdk-bootstraps.ipynb) | Identify CDK Bootstraps with Versions for All Accounts & Regions |

### Organizations

| Notebook | Description |
| -------- | ----------- |
| [identify-privileged-accounts](notebooks/organizations/identify-privileged-accounts.ipynb) | List of Delegated Administration Accounts & Services |

### Virtual Private Cloud (VPC)

| Notebook | Description |
| -------- | ----------- |
| [identify-default-vpcs](notebooks/vpc/identify-default-vpcs.ipynb) | Identify Default VPCs Across All Regions |

## Threat Response

### Elastic Compute Cloud (EC2)

| Notebook | Description |
| -------- | ----------- |
| [disable-serial-console-access](notebooks/ec2/disable-serial-console-access.ipynb) | Disable Serial Console Access |
| [enable-image-block-public-access](notebooks/ec2/enable-image-block-public-access.ipynb) | Enable Image Block Public Access |
| [enable-snapshot-block-public-access](notebooks/ec2/enable-snapshot-block-public-access.ipynb) | Enable Snapshot Block Public Access |

## Threat Utilities

### Analysis

| Notebook | Description |
| -------- | ----------- |
| [deflation](notebooks/analysis/deflation.ipynb) | Deflation of Data Structures |

### Control Tower

| Notebook | Description |
| -------- | ----------- |
| [periodic-daily-config-recordings](notebooks/controltower/periodic-daily-config-recordings.ipynb) | Setup or Stop Config Periodic Daily Recordings |
