# coding: utf-8
from enum import Enum

from qfluentwidgets import StyleSheetBase, Theme, qconfig


class StyleSheet(StyleSheetBase, Enum):
    """ Style sheet  """

    LINK_CARD = "link_card"
    CARD = "card"
    STATUS_BAR = "status_bar"
    TAB = "tab"
    MESSAGE_WINDOW = "message_window"
    SETTING_INTERFACE = "setting_interface"

    def path(self, theme=Theme.DARK):
        theme = qconfig.theme if theme == Theme.AUTO else theme
        return f":/qss/{theme.value.lower()}/{self.value}.qss"
