import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::ImageBuilder::Component`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html
 * @external
 */
export interface CfnComponentProps {
    /**
     * `AWS::ImageBuilder::Component.Platform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-platform
     * @external
     */
    readonly platform: string;
    /**
     * `AWS::ImageBuilder::Component.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-version
     * @external
     */
    readonly version: string;
    /**
     * `AWS::ImageBuilder::Component.ChangeDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-changedescription
     * @external
     */
    readonly changeDescription?: string;
    /**
     * `AWS::ImageBuilder::Component.Data`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-data
     * @external
     */
    readonly data?: string;
    /**
     * `AWS::ImageBuilder::Component.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::Component.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::ImageBuilder::Component.SupportedOsVersions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-supportedosversions
     * @external
     */
    readonly supportedOsVersions?: string[];
    /**
     * `AWS::ImageBuilder::Component.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::Component.Uri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-uri
     * @external
     */
    readonly uri?: string;
}
/**
 * A CloudFormation `AWS::ImageBuilder::Component`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::Component
 */
export declare class CfnComponent extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::Component";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Encrypted
     */
    readonly attrEncrypted: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::ImageBuilder::Component.Platform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-platform
     * @external
     */
    platform: string;
    /**
     * `AWS::ImageBuilder::Component.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-version
     * @external
     */
    version: string;
    /**
     * `AWS::ImageBuilder::Component.ChangeDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-changedescription
     * @external
     */
    changeDescription: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.Data`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-data
     * @external
     */
    data: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::ImageBuilder::Component.SupportedOsVersions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-supportedosversions
     * @external
     */
    supportedOsVersions: string[] | undefined;
    /**
     * `AWS::ImageBuilder::Component.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::Component.Uri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-component.html#cfn-imagebuilder-component-uri
     * @external
     */
    uri: string | undefined;
    /**
     * Create a new `AWS::ImageBuilder::Component`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComponentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 * @external
 */
export interface CfnDistributionConfigurationProps {
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Distributions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-distributions
     * @external
     */
    readonly distributions: Array<CfnDistributionConfiguration.DistributionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::DistributionConfiguration
 */
export declare class CfnDistributionConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::DistributionConfiguration";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Distributions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-distributions
     * @external
     */
    distributions: Array<CfnDistributionConfiguration.DistributionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::DistributionConfiguration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html#cfn-imagebuilder-distributionconfiguration-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ImageBuilder::DistributionConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDistributionConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::DistributionConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-distributionconfiguration.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::DistributionConfiguration
 */
export declare namespace CfnDistributionConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html
     * @external
     */
    interface DistributionProperty {
        /**
         * `CfnDistributionConfiguration.DistributionProperty.AmiDistributionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-amidistributionconfiguration
         * @external
         */
        readonly amiDistributionConfiguration?: any | cdk.IResolvable;
        /**
         * `CfnDistributionConfiguration.DistributionProperty.LicenseConfigurationArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-licenseconfigurationarns
         * @external
         */
        readonly licenseConfigurationArns?: string[];
        /**
         * `CfnDistributionConfiguration.DistributionProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-distributionconfiguration-distribution.html#cfn-imagebuilder-distributionconfiguration-distribution-region
         * @external
         */
        readonly region: string;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::Image`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html
 * @external
 */
export interface CfnImageProps {
    /**
     * `AWS::ImageBuilder::Image.ImageRecipeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagerecipearn
     * @external
     */
    readonly imageRecipeArn: string;
    /**
     * `AWS::ImageBuilder::Image.InfrastructureConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-infrastructureconfigurationarn
     * @external
     */
    readonly infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::Image.DistributionConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-distributionconfigurationarn
     * @external
     */
    readonly distributionConfigurationArn?: string;
    /**
     * `AWS::ImageBuilder::Image.EnhancedImageMetadataEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-enhancedimagemetadataenabled
     * @external
     */
    readonly enhancedImageMetadataEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::Image.ImageTestsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagetestsconfiguration
     * @external
     */
    readonly imageTestsConfiguration?: CfnImage.ImageTestsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::Image.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::Image`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::Image
 */
export declare class CfnImage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::Image";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ImageId
     */
    readonly attrImageId: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::Image.ImageRecipeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagerecipearn
     * @external
     */
    imageRecipeArn: string;
    /**
     * `AWS::ImageBuilder::Image.InfrastructureConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-infrastructureconfigurationarn
     * @external
     */
    infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::Image.DistributionConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-distributionconfigurationarn
     * @external
     */
    distributionConfigurationArn: string | undefined;
    /**
     * `AWS::ImageBuilder::Image.EnhancedImageMetadataEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-enhancedimagemetadataenabled
     * @external
     */
    enhancedImageMetadataEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::Image.ImageTestsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-imagetestsconfiguration
     * @external
     */
    imageTestsConfiguration: CfnImage.ImageTestsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::Image.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html#cfn-imagebuilder-image-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ImageBuilder::Image`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::Image`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-image.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::Image
 */
export declare namespace CfnImage {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-image-imagetestsconfiguration.html
     * @external
     */
    interface ImageTestsConfigurationProperty {
        /**
         * `CfnImage.ImageTestsConfigurationProperty.ImageTestsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-image-imagetestsconfiguration.html#cfn-imagebuilder-image-imagetestsconfiguration-imagetestsenabled
         * @external
         */
        readonly imageTestsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnImage.ImageTestsConfigurationProperty.TimeoutMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-image-imagetestsconfiguration.html#cfn-imagebuilder-image-imagetestsconfiguration-timeoutminutes
         * @external
         */
        readonly timeoutMinutes?: number;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::ImagePipeline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 * @external
 */
export interface CfnImagePipelineProps {
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageRecipeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagerecipearn
     * @external
     */
    readonly imageRecipeArn: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.InfrastructureConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-infrastructureconfigurationarn
     * @external
     */
    readonly infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.DistributionConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-distributionconfigurationarn
     * @external
     */
    readonly distributionConfigurationArn?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.EnhancedImageMetadataEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-enhancedimagemetadataenabled
     * @external
     */
    readonly enhancedImageMetadataEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageTestsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration
     * @external
     */
    readonly imageTestsConfiguration?: CfnImagePipeline.ImageTestsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-schedule
     * @external
     */
    readonly schedule?: CfnImagePipeline.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-status
     * @external
     */
    readonly status?: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImagePipeline
 */
export declare class CfnImagePipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::ImagePipeline";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageRecipeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagerecipearn
     * @external
     */
    imageRecipeArn: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.InfrastructureConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-infrastructureconfigurationarn
     * @external
     */
    infrastructureConfigurationArn: string;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.DistributionConfigurationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-distributionconfigurationarn
     * @external
     */
    distributionConfigurationArn: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.EnhancedImageMetadataEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-enhancedimagemetadataenabled
     * @external
     */
    enhancedImageMetadataEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.ImageTestsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration
     * @external
     */
    imageTestsConfiguration: CfnImagePipeline.ImageTestsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-schedule
     * @external
     */
    schedule: CfnImagePipeline.ScheduleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-status
     * @external
     */
    status: string | undefined;
    /**
     * `AWS::ImageBuilder::ImagePipeline.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html#cfn-imagebuilder-imagepipeline-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ImageBuilder::ImagePipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImagePipelineProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImagePipeline
 */
export declare namespace CfnImagePipeline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-imagetestsconfiguration.html
     * @external
     */
    interface ImageTestsConfigurationProperty {
        /**
         * `CfnImagePipeline.ImageTestsConfigurationProperty.ImageTestsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-imagetestsconfiguration.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration-imagetestsenabled
         * @external
         */
        readonly imageTestsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnImagePipeline.ImageTestsConfigurationProperty.TimeoutMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-imagetestsconfiguration.html#cfn-imagebuilder-imagepipeline-imagetestsconfiguration-timeoutminutes
         * @external
         */
        readonly timeoutMinutes?: number;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagepipeline.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImagePipeline
 */
export declare namespace CfnImagePipeline {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-schedule.html
     * @external
     */
    interface ScheduleProperty {
        /**
         * `CfnImagePipeline.ScheduleProperty.PipelineExecutionStartCondition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-schedule.html#cfn-imagebuilder-imagepipeline-schedule-pipelineexecutionstartcondition
         * @external
         */
        readonly pipelineExecutionStartCondition?: string;
        /**
         * `CfnImagePipeline.ScheduleProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagepipeline-schedule.html#cfn-imagebuilder-imagepipeline-schedule-scheduleexpression
         * @external
         */
        readonly scheduleExpression?: string;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::ImageRecipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 * @external
 */
export interface CfnImageRecipeProps {
    /**
     * `AWS::ImageBuilder::ImageRecipe.Components`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-components
     * @external
     */
    readonly components: Array<CfnImageRecipe.ComponentConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.ParentImage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-parentimage
     * @external
     */
    readonly parentImage: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-version
     * @external
     */
    readonly version: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-blockdevicemappings
     * @external
     */
    readonly blockDeviceMappings?: Array<CfnImageRecipe.InstanceBlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::ImageRecipe.WorkingDirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-workingdirectory
     * @external
     */
    readonly workingDirectory?: string;
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 */
export declare class CfnImageRecipe extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::ImageRecipe";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Components`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-components
     * @external
     */
    components: Array<CfnImageRecipe.ComponentConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::ImageRecipe.ParentImage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-parentimage
     * @external
     */
    parentImage: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-version
     * @external
     */
    version: string;
    /**
     * `AWS::ImageBuilder::ImageRecipe.BlockDeviceMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-blockdevicemappings
     * @external
     */
    blockDeviceMappings: Array<CfnImageRecipe.InstanceBlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::ImageRecipe.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::ImageRecipe.WorkingDirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html#cfn-imagebuilder-imagerecipe-workingdirectory
     * @external
     */
    workingDirectory: string | undefined;
    /**
     * Create a new `AWS::ImageBuilder::ImageRecipe`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageRecipeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 */
export declare namespace CfnImageRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentconfiguration.html
     * @external
     */
    interface ComponentConfigurationProperty {
        /**
         * `CfnImageRecipe.ComponentConfigurationProperty.ComponentArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-componentconfiguration.html#cfn-imagebuilder-imagerecipe-componentconfiguration-componentarn
         * @external
         */
        readonly componentArn?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 */
export declare namespace CfnImageRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html
     * @external
     */
    interface EbsInstanceBlockDeviceSpecificationProperty {
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.DeleteOnTermination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-deleteontermination
         * @external
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-encrypted
         * @external
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.Iops`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-iops
         * @external
         */
        readonly iops?: number;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.SnapshotId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-snapshotid
         * @external
         */
        readonly snapshotId?: string;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.VolumeSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-volumesize
         * @external
         */
        readonly volumeSize?: number;
        /**
         * `CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty.VolumeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification.html#cfn-imagebuilder-imagerecipe-ebsinstanceblockdevicespecification-volumetype
         * @external
         */
        readonly volumeType?: string;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::ImageRecipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-imagerecipe.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::ImageRecipe
 */
export declare namespace CfnImageRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html
     * @external
     */
    interface InstanceBlockDeviceMappingProperty {
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-devicename
         * @external
         */
        readonly deviceName?: string;
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.Ebs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-ebs
         * @external
         */
        readonly ebs?: CfnImageRecipe.EbsInstanceBlockDeviceSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.NoDevice`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-nodevice
         * @external
         */
        readonly noDevice?: string;
        /**
         * `CfnImageRecipe.InstanceBlockDeviceMappingProperty.VirtualName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-imagerecipe-instanceblockdevicemapping.html#cfn-imagebuilder-imagerecipe-instanceblockdevicemapping-virtualname
         * @external
         */
        readonly virtualName?: string;
    }
}
/**
 * Properties for defining a `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 * @external
 */
export interface CfnInfrastructureConfigurationProps {
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceProfileName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename
     * @external
     */
    readonly instanceProfileName: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes
     * @external
     */
    readonly instanceTypes?: string[];
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.KeyPair`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair
     * @external
     */
    readonly keyPair?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Logging`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging
     * @external
     */
    readonly logging?: CfnInfrastructureConfiguration.LoggingProperty | any | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.ResourceTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags
     * @external
     */
    readonly resourceTags?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn
     * @external
     */
    readonly snsTopicArn?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.TerminateInstanceOnFailure`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure
     * @external
     */
    readonly terminateInstanceOnFailure?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::InfrastructureConfiguration
 */
export declare class CfnInfrastructureConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ImageBuilder::InfrastructureConfiguration";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceProfileName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename
     * @external
     */
    instanceProfileName: string;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.InstanceTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes
     * @external
     */
    instanceTypes: string[] | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.KeyPair`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair
     * @external
     */
    keyPair: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Logging`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging
     * @external
     */
    logging: CfnInfrastructureConfiguration.LoggingProperty | any | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.ResourceTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags
     * @external
     */
    resourceTags: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn
     * @external
     */
    snsTopicArn: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ImageBuilder::InfrastructureConfiguration.TerminateInstanceOnFailure`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure
     * @external
     */
    terminateInstanceOnFailure: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ImageBuilder::InfrastructureConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInfrastructureConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::InfrastructureConfiguration
 */
export declare namespace CfnInfrastructureConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html
     * @external
     */
    interface LoggingProperty {
        /**
         * `CfnInfrastructureConfiguration.LoggingProperty.S3Logs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-logging.html#cfn-imagebuilder-infrastructureconfiguration-logging-s3logs
         * @external
         */
        readonly s3Logs?: CfnInfrastructureConfiguration.S3LogsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ImageBuilder::InfrastructureConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html
 * @external
 * @cloudformationResource AWS::ImageBuilder::InfrastructureConfiguration
 */
export declare namespace CfnInfrastructureConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html
     * @external
     */
    interface S3LogsProperty {
        /**
         * `CfnInfrastructureConfiguration.S3LogsProperty.S3BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3bucketname
         * @external
         */
        readonly s3BucketName?: string;
        /**
         * `CfnInfrastructureConfiguration.S3LogsProperty.S3KeyPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-infrastructureconfiguration-s3logs.html#cfn-imagebuilder-infrastructureconfiguration-s3logs-s3keyprefix
         * @external
         */
        readonly s3KeyPrefix?: string;
    }
}
