# arlas-persistence-api-python
persistence REST services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 22.0.0-beta.4
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [http://www.gisaia.com/](http://www.gisaia.com/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_persistence_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_persistence_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_persistence_api_python
from arlas_persistence_api_python.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = arlas_persistence_api_python.PersistApi()
zone = 'zone_example' # str | Zone of the document.
key = 'key_example' # str | The key of the data.
value = 'value_example' # str | Value to be persisted.
readers = ['readers_example'] # list[str] | Comma separated values of groups authorized to read the data. (optional)
writers = ['writers_example'] # list[str] | Comma separated values of groups authorized to modify the data. (optional)
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # Store a new piece of data for the provided zone and key (auto generate id).
    api_response = api_instance.create(zone, key, value, readers=readers, writers=writers, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling PersistApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas_persistence_server*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PersistApi* | [**create**](docs/PersistApi.md#create) | **POST** /persist/resource/{zone}/{key} | Store a new piece of data for the provided zone and key (auto generate id).
*PersistApi* | [**delete**](docs/PersistApi.md#delete) | **DELETE** /persist/resource/{zone}/{key} | Delete an entry given its key and id.
*PersistApi* | [**delete_by_id**](docs/PersistApi.md#delete_by_id) | **DELETE** /persist/resource/id/{id} | Delete an entry given its key and id.
*PersistApi* | [**exists_by_id**](docs/PersistApi.md#exists_by_id) | **GET** /persist/resource/exists/id/{id} | Check the existence of an entry given its id.
*PersistApi* | [**exists_by_key**](docs/PersistApi.md#exists_by_key) | **GET** /persist/resource/exists/{zone}/{key} | Check the existence of an entry given its zone and key.
*PersistApi* | [**get_by_id**](docs/PersistApi.md#get_by_id) | **GET** /persist/resource/id/{id} | Fetch an entry given its id.
*PersistApi* | [**get_by_key**](docs/PersistApi.md#get_by_key) | **GET** /persist/resource/{zone}/{key} | Fetch an entry given its zone and key.
*PersistApi* | [**get_groups_by_zone**](docs/PersistApi.md#get_groups_by_zone) | **GET** /persist/groups/{zone} | Returns the users&#39; groups allowed to interact with the given zone.
*PersistApi* | [**list**](docs/PersistApi.md#list) | **GET** /persist/resources/{zone} | Fetch a list of data related to a zone.
*PersistApi* | [**update**](docs/PersistApi.md#update) | **PUT** /persist/resource/id/{id} | Update an existing value.


## Documentation For Models

 - [DataResource](docs/DataResource.md)
 - [DataWithLinks](docs/DataWithLinks.md)
 - [Exists](docs/Exists.md)
 - [Link](docs/Link.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

