# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1
from . import resource


@dataclass
class CSIStorageCapacity(DictMixin):
    """CSIStorageCapacity stores the result of one CSI GetCapacity call. For a given
      StorageClass, this describes the available capacity in a particular topology
      segment.  This can be used when considering where to instantiate new
      PersistentVolumes.
      
      For example this can express things like: - StorageClass "standard" has "1234
      GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass
      "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"
      
      The following three cases all imply that no capacity is available for a
      certain combination: - no object exists with suitable topology and storage
      class name - such an object exists, but the capacity is unset - such an object
      exists, but the capacity is zero
      
      The producer of these objects can decide which approach is more suitable.
      
      They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature
      gate is enabled there and a CSI driver opts into capacity-aware scheduling
      with CSIDriver.StorageCapacity.

      **parameters**

      * **storageClassName** ``str`` - The name of the StorageClass that the reported capacity applies to. It must
        meet the same requirements as the name of a StorageClass object (non-empty,
        DNS subdomain). If that object no longer exists, the CSIStorageCapacity object
        is obsolete and should be removed by its creator. This field is immutable.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **capacity** ``Optional[resource.Quantity]`` - Capacity is the value reported by the CSI driver in its GetCapacityResponse
        for a GetCapacityRequest with topology and parameters that match the previous
        fields.
        The semantic is currently (CSI spec 1.2) defined as: The available capacity,
        in bytes, of the storage that can be used to provision volumes. If not set,
        that information is currently unavailable and treated like zero capacity.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **maximumVolumeSize** ``Optional[resource.Quantity]`` - MaximumVolumeSize is the value reported by the CSI driver in its
        GetCapacityResponse for a GetCapacityRequest with topology and parameters that
        match the previous fields.
        This is defined since CSI spec 1.4.0 as the largest size that may be used in a
        CreateVolumeRequest.capacity_range.required_bytes field to create a volume
        with the same parameters as those in GetCapacityRequest. The corresponding
        value in the Kubernetes API is ResourceRequirements.Requests in a volume
        claim.
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. The name has no particular meaning. It must be be
        a DNS subdomain (dots allowed, 253 characters). To ensure that there are no
        conflicts with other CSI drivers on the cluster, the recommendation is to use
        csisc-<uuid>, a generated name, or a reverse-domain name which ends with the
        unique CSI driver name.
        Objects are namespaced.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **nodeTopology** ``Optional[meta_v1.LabelSelector]`` - NodeTopology defines which nodes have access to the storage for which capacity
        was reported. If not set, the storage is not accessible from any node in the
        cluster. If empty, the storage is accessible from all nodes. This field is
        immutable.
    """
    storageClassName: 'str'
    apiVersion: 'Optional[str]' = None
    capacity: 'Optional[resource.Quantity]' = None
    kind: 'Optional[str]' = None
    maximumVolumeSize: 'Optional[resource.Quantity]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    nodeTopology: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class CSIStorageCapacityList(DictMixin):
    """CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

      **parameters**

      * **items** ``List[CSIStorageCapacity]`` - Items is the list of CSIStorageCapacity objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[CSIStorageCapacity]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class VolumeAttachment(DictMixin):
    """VolumeAttachment captures the intent to attach or detach the specified volume
      to/from the specified node.
      
      VolumeAttachment objects are non-namespaced.

      **parameters**

      * **spec** ``VolumeAttachmentSpec`` - Specification of the desired attach/detach volume behavior. Populated by the
        Kubernetes system.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[VolumeAttachmentStatus]`` - Status of the VolumeAttachment request. Populated by the entity completing the
        attach or detach operation, i.e. the external-attacher.
    """
    spec: 'VolumeAttachmentSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[VolumeAttachmentStatus]' = None


@dataclass
class VolumeAttachmentList(DictMixin):
    """VolumeAttachmentList is a collection of VolumeAttachment objects.

      **parameters**

      * **items** ``List[VolumeAttachment]`` - Items is the list of VolumeAttachments
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[VolumeAttachment]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class VolumeAttachmentSource(DictMixin):
    """VolumeAttachmentSource represents a volume that should be attached. Right now
      only PersistenVolumes can be attached via external attacher, in future we may
      allow also inline volumes in pods. Exactly one member can be set.

      **parameters**

      * **inlineVolumeSpec** ``Optional[core_v1.PersistentVolumeSpec]`` - inlineVolumeSpec contains all the information necessary to attach a persistent
        volume defined by a pod's inline VolumeSource. This field is populated only
        for the CSIMigration feature. It contains translated fields from a pod's
        inline VolumeSource to a PersistentVolumeSpec. This field is alpha-level and
        is only honored by servers that enabled the CSIMigration feature.
      * **persistentVolumeName** ``Optional[str]`` - Name of the persistent volume to attach.
    """
    inlineVolumeSpec: 'Optional[core_v1.PersistentVolumeSpec]' = None
    persistentVolumeName: 'Optional[str]' = None


@dataclass
class VolumeAttachmentSpec(DictMixin):
    """VolumeAttachmentSpec is the specification of a VolumeAttachment request.

      **parameters**

      * **attacher** ``str`` - Attacher indicates the name of the volume driver that MUST handle this
        request. This is the name returned by GetPluginName().
      * **nodeName** ``str`` - The node that the volume should be attached to.
      * **source** ``VolumeAttachmentSource`` - Source represents the volume that should be attached.
    """
    attacher: 'str'
    nodeName: 'str'
    source: 'VolumeAttachmentSource'


@dataclass
class VolumeAttachmentStatus(DictMixin):
    """VolumeAttachmentStatus is the status of a VolumeAttachment request.

      **parameters**

      * **attached** ``bool`` - Indicates the volume is successfully attached. This field must only be set by
        the entity completing the attach operation, i.e. the external-attacher.
      * **attachError** ``Optional[VolumeError]`` - The last error encountered during attach operation, if any. This field must
        only be set by the entity completing the attach operation, i.e. the
        external-attacher.
      * **attachmentMetadata** ``Optional[dict]`` - Upon successful attach, this field is populated with any information returned
        by the attach operation that must be passed into subsequent WaitForAttach or
        Mount calls. This field must only be set by the entity completing the attach
        operation, i.e. the external-attacher.
      * **detachError** ``Optional[VolumeError]`` - The last error encountered during detach operation, if any. This field must
        only be set by the entity completing the detach operation, i.e. the
        external-attacher.
    """
    attached: 'bool'
    attachError: 'Optional[VolumeError]' = None
    attachmentMetadata: 'Optional[dict]' = None
    detachError: 'Optional[VolumeError]' = None


@dataclass
class VolumeError(DictMixin):
    """VolumeError captures an error encountered during a volume operation.

      **parameters**

      * **message** ``Optional[str]`` - String detailing the error encountered during Attach or Detach operation. This
        string maybe logged, so it should not contain sensitive information.
      * **time** ``Optional[meta_v1.Time]`` - Time the error was encountered.
    """
    message: 'Optional[str]' = None
    time: 'Optional[meta_v1.Time]' = None


