# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class PriorityClass(DictMixin):
    """PriorityClass defines mapping from a priority class name to the priority
      integer value. The value can be any valid integer.

      **parameters**

      * **value** ``int`` - The value of this priority class. This is the actual priority that pods
        receive when they have the name of this class in their pod spec.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **description** ``Optional[str]`` - description is an arbitrary string that usually provides guidelines on when
        this priority class should be used.
      * **globalDefault** ``Optional[bool]`` - globalDefault specifies whether this PriorityClass should be considered as the
        default priority for pods that do not have any priority class. Only one
        PriorityClass can be marked as `globalDefault`. However, if more than one
        PriorityClasses exists with their `globalDefault` field set to true, the
        smallest value of such global default PriorityClasses will be used as the
        default priority.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **preemptionPolicy** ``Optional[str]`` - PreemptionPolicy is the Policy for preempting pods with lower priority. One of
        Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This
        field is beta-level, gated by the NonPreemptingPriority feature-gate.
    """
    value: 'int'
    apiVersion: 'Optional[str]' = None
    description: 'Optional[str]' = None
    globalDefault: 'Optional[bool]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    preemptionPolicy: 'Optional[str]' = None


@dataclass
class PriorityClassList(DictMixin):
    """PriorityClassList is a collection of priority classes.

      **parameters**

      * **items** ``List[PriorityClass]`` - items is the list of PriorityClasses
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PriorityClass]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


