# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import util_intstr
from . import core_v1


@dataclass
class AllowedCSIDriver(DictMixin):
    """AllowedCSIDriver represents a single inline CSI Driver that is allowed to be
      used.

      **parameters**

      * **name** ``str`` - Name is the registered name of the CSI driver
    """
    name: 'str'


@dataclass
class AllowedFlexVolume(DictMixin):
    """AllowedFlexVolume represents a single Flexvolume that is allowed to be used.

      **parameters**

      * **driver** ``str`` - driver is the name of the Flexvolume driver.
    """
    driver: 'str'


@dataclass
class AllowedHostPath(DictMixin):
    """AllowedHostPath defines the host volume conditions that will be enabled by a
      policy for pods to use. It requires the path prefix to be defined.

      **parameters**

      * **pathPrefix** ``Optional[str]`` - pathPrefix is the path prefix that the host volume must match. It does not
        support `*`. Trailing slashes are trimmed when validating the path prefix with
        a host path.
        Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not
        allow `/food` or `/etc/foo`
      * **readOnly** ``Optional[bool]`` - when set to true, will allow host volumes matching the pathPrefix only if all
        volume mounts are readOnly.
    """
    pathPrefix: 'Optional[str]' = None
    readOnly: 'Optional[bool]' = None


@dataclass
class FSGroupStrategyOptions(DictMixin):
    """FSGroupStrategyOptions defines the strategy type and options used to create
      the strategy.

      **parameters**

      * **ranges** ``Optional[List[IDRange]]`` - ranges are the allowed ranges of fs groups.  If you would like to force a
        single fs group then supply a single range with the same start and end.
        Required for MustRunAs.
      * **rule** ``Optional[str]`` - rule is the strategy that will dictate what FSGroup is used in the
        SecurityContext.
    """
    ranges: 'Optional[List[IDRange]]' = None
    rule: 'Optional[str]' = None


@dataclass
class HostPortRange(DictMixin):
    """HostPortRange defines a range of host ports that will be enabled by a policy
      for pods to use.  It requires both the start and end to be defined.

      **parameters**

      * **max** ``int`` - max is the end of the range, inclusive.
      * **min** ``int`` - min is the start of the range, inclusive.
    """
    max: 'int'
    min: 'int'


@dataclass
class IDRange(DictMixin):
    """IDRange provides a min/max of an allowed range of IDs.

      **parameters**

      * **max** ``int`` - max is the end of the range, inclusive.
      * **min** ``int`` - min is the start of the range, inclusive.
    """
    max: 'int'
    min: 'int'


@dataclass
class PodDisruptionBudget(DictMixin):
    """PodDisruptionBudget is an object to define the max disruption that can be
      caused to a collection of pods

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PodDisruptionBudgetSpec]`` - Specification of the desired behavior of the PodDisruptionBudget.
      * **status** ``Optional[PodDisruptionBudgetStatus]`` - Most recently observed status of the PodDisruptionBudget.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PodDisruptionBudgetSpec]' = None
    status: 'Optional[PodDisruptionBudgetStatus]' = None


@dataclass
class PodDisruptionBudgetList(DictMixin):
    """PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

      **parameters**

      * **items** ``List[PodDisruptionBudget]`` - items list individual PodDisruptionBudget objects
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PodDisruptionBudget]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PodDisruptionBudgetSpec(DictMixin):
    """PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.

      **parameters**

      * **maxUnavailable** ``Optional[util_intstr.IntOrString]`` - An eviction is allowed if at most "maxUnavailable" pods selected by "selector"
        are unavailable after the eviction, i.e. even in absence of the evicted pod.
        For example, one can prevent all voluntary evictions by specifying 0. This is
        a mutually exclusive setting with "minAvailable".
      * **minAvailable** ``Optional[util_intstr.IntOrString]`` - An eviction is allowed if at least "minAvailable" pods selected by "selector"
        will still be available after the eviction, i.e. even in the absence of the
        evicted pod.  So for example you can prevent all voluntary evictions by
        specifying "100%".
      * **selector** ``Optional[meta_v1.LabelSelector]`` - Label query over pods whose evictions are managed by the disruption budget. A
        null selector selects no pods. An empty selector ({}) also selects no pods,
        which differs from standard behavior of selecting all pods. In policy/v1, an
        empty selector will select all pods in the namespace.
    """
    maxUnavailable: 'Optional[util_intstr.IntOrString]' = None
    minAvailable: 'Optional[util_intstr.IntOrString]' = None
    selector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class PodDisruptionBudgetStatus(DictMixin):
    """PodDisruptionBudgetStatus represents information about the status of a
      PodDisruptionBudget. Status may trail the actual state of a system.

      **parameters**

      * **currentHealthy** ``int`` - current number of healthy pods
      * **desiredHealthy** ``int`` - minimum desired number of healthy pods
      * **disruptionsAllowed** ``int`` - Number of pod disruptions that are currently allowed.
      * **expectedPods** ``int`` - total number of pods counted by this disruption budget
      * **conditions** ``Optional[List[meta_v1.Condition]]`` - Conditions contain conditions for PDB. The disruption controller sets the
        DisruptionAllowed condition. The following are known values for the reason
        field (additional reasons could be added in the future): - SyncFailed: The
        controller encountered an error and wasn't able to compute
                      the number of allowed disruptions. Therefore no disruptions are
                      allowed and the status of the condition will be False.
        - InsufficientPods: The number of pods are either at or below the number
                            required by the PodDisruptionBudget. No disruptions are
                            allowed and the status of the condition will be False.
        - SufficientPods: There are more pods than required by the
        PodDisruptionBudget.
                          The condition will be True, and the number of allowed
                          disruptions are provided by the disruptionsAllowed property.
      * **disruptedPods** ``Optional[dict]`` - DisruptedPods contains information about pods whose eviction was processed by
        the API server eviction subresource handler but has not yet been observed by
        the PodDisruptionBudget controller. A pod will be in this map from the time
        when the API server processed the eviction request to the time when the pod is
        seen by PDB controller as having been marked for deletion (or after a
        timeout). The key in the map is the name of the pod and the value is the time
        when the API server processed the eviction request. If the deletion didn't
        occur and a pod is still there it will be removed from the list automatically
        by PodDisruptionBudget controller after some time. If everything goes smooth
        this map should be empty for the most of the time. Large number of entries in
        the map may indicate problems with pod deletions.
      * **observedGeneration** ``Optional[int]`` - Most recent generation observed when updating this PDB status.
        DisruptionsAllowed and other status information is valid only if
        observedGeneration equals to PDB's object generation.
    """
    currentHealthy: 'int'
    desiredHealthy: 'int'
    disruptionsAllowed: 'int'
    expectedPods: 'int'
    conditions: 'Optional[List[meta_v1.Condition]]' = None
    disruptedPods: 'Optional[dict]' = None
    observedGeneration: 'Optional[int]' = None


@dataclass
class PodSecurityPolicy(DictMixin):
    """PodSecurityPolicy governs the ability to make requests that affect the
      Security Context that will be applied to a pod and container. Deprecated in
      1.21.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PodSecurityPolicySpec]`` - spec defines the policy enforced.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PodSecurityPolicySpec]' = None


@dataclass
class PodSecurityPolicyList(DictMixin):
    """PodSecurityPolicyList is a list of PodSecurityPolicy objects.

      **parameters**

      * **items** ``List[PodSecurityPolicy]`` - items is a list of schema objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PodSecurityPolicy]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PodSecurityPolicySpec(DictMixin):
    """PodSecurityPolicySpec defines the policy enforced.

      **parameters**

      * **fsGroup** ``FSGroupStrategyOptions`` - fsGroup is the strategy that will dictate what fs group is used by the
        SecurityContext.
      * **runAsUser** ``RunAsUserStrategyOptions`` - runAsUser is the strategy that will dictate the allowable RunAsUser values
        that may be set.
      * **seLinux** ``SELinuxStrategyOptions`` - seLinux is the strategy that will dictate the allowable labels that may be
        set.
      * **supplementalGroups** ``SupplementalGroupsStrategyOptions`` - supplementalGroups is the strategy that will dictate what supplemental groups
        are used by the SecurityContext.
      * **allowPrivilegeEscalation** ``Optional[bool]`` - allowPrivilegeEscalation determines if a pod can request to allow privilege
        escalation. If unspecified, defaults to true.
      * **allowedCSIDrivers** ``Optional[List[AllowedCSIDriver]]`` - AllowedCSIDrivers is an allowlist of inline CSI drivers that must be
        explicitly set to be embedded within a pod spec. An empty value indicates that
        any CSI driver can be used for inline ephemeral volumes. This is a beta field,
        and is only honored if the API server enables the CSIInlineVolume feature
        gate.
      * **allowedCapabilities** ``Optional[List[str]]`` - allowedCapabilities is a list of capabilities that can be requested to add to
        the container. Capabilities in this field may be added at the pod author's
        discretion. You must not list a capability in both allowedCapabilities and
        requiredDropCapabilities.
      * **allowedFlexVolumes** ``Optional[List[AllowedFlexVolume]]`` - allowedFlexVolumes is an allowlist of Flexvolumes.  Empty or nil indicates
        that all Flexvolumes may be used.  This parameter is effective only when the
        usage of the Flexvolumes is allowed in the "volumes" field.
      * **allowedHostPaths** ``Optional[List[AllowedHostPath]]`` - allowedHostPaths is an allowlist of host paths. Empty indicates that all host
        paths may be used.
      * **allowedProcMountTypes** ``Optional[List[str]]`` - AllowedProcMountTypes is an allowlist of allowed ProcMountTypes. Empty or nil
        indicates that only the DefaultProcMountType may be used. This requires the
        ProcMountType feature flag to be enabled.
      * **allowedUnsafeSysctls** ``Optional[List[str]]`` - allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults
        to none. Each entry is either a plain sysctl name or ends in "*" in which case
        it is considered as a prefix of allowed sysctls. Single * means all unsafe
        sysctls are allowed. Kubelet has to allowlist all allowed unsafe sysctls
        explicitly to avoid rejection.
        Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows
        "foo.bar", "foo.baz", etc.
      * **defaultAddCapabilities** ``Optional[List[str]]`` - defaultAddCapabilities is the default set of capabilities that will be added
        to the container unless the pod spec specifically drops the capability.  You
        may not list a capability in both defaultAddCapabilities and
        requiredDropCapabilities. Capabilities added here are implicitly allowed, and
        need not be included in the allowedCapabilities list.
      * **defaultAllowPrivilegeEscalation** ``Optional[bool]`` - defaultAllowPrivilegeEscalation controls the default setting for whether a
        process can gain more privileges than its parent process.
      * **forbiddenSysctls** ``Optional[List[str]]`` - forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none.
        Each entry is either a plain sysctl name or ends in "*" in which case it is
        considered as a prefix of forbidden sysctls. Single * means all sysctls are
        forbidden.
        Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids
        "foo.bar", "foo.baz", etc.
      * **hostIPC** ``Optional[bool]`` - hostIPC determines if the policy allows the use of HostIPC in the pod spec.
      * **hostNetwork** ``Optional[bool]`` - hostNetwork determines if the policy allows the use of HostNetwork in the pod
        spec.
      * **hostPID** ``Optional[bool]`` - hostPID determines if the policy allows the use of HostPID in the pod spec.
      * **hostPorts** ``Optional[List[HostPortRange]]`` - hostPorts determines which host port ranges are allowed to be exposed.
      * **privileged** ``Optional[bool]`` - privileged determines if a pod can request to be run as privileged.
      * **readOnlyRootFilesystem** ``Optional[bool]`` - readOnlyRootFilesystem when set to true will force containers to run with a
        read only root file system.  If the container specifically requests to run
        with a non-read only root file system the PSP should deny the pod. If set to
        false the container may run with a read only root file system if it wishes but
        it will not be forced to.
      * **requiredDropCapabilities** ``Optional[List[str]]`` - requiredDropCapabilities are the capabilities that will be dropped from the
        container.  These are required to be dropped and cannot be added.
      * **runAsGroup** ``Optional[RunAsGroupStrategyOptions]`` - RunAsGroup is the strategy that will dictate the allowable RunAsGroup values
        that may be set. If this field is omitted, the pod's RunAsGroup can take any
        value. This field requires the RunAsGroup feature gate to be enabled.
      * **runtimeClass** ``Optional[RuntimeClassStrategyOptions]`` - runtimeClass is the strategy that will dictate the allowable RuntimeClasses
        for a pod. If this field is omitted, the pod's runtimeClassName field is
        unrestricted. Enforcement of this field depends on the RuntimeClass feature
        gate being enabled.
      * **volumes** ``Optional[List[str]]`` - volumes is an allowlist of volume plugins. Empty indicates that no volumes may
        be used. To allow all volumes you may use '*'.
    """
    fsGroup: 'FSGroupStrategyOptions'
    runAsUser: 'RunAsUserStrategyOptions'
    seLinux: 'SELinuxStrategyOptions'
    supplementalGroups: 'SupplementalGroupsStrategyOptions'
    allowPrivilegeEscalation: 'Optional[bool]' = None
    allowedCSIDrivers: 'Optional[List[AllowedCSIDriver]]' = None
    allowedCapabilities: 'Optional[List[str]]' = None
    allowedFlexVolumes: 'Optional[List[AllowedFlexVolume]]' = None
    allowedHostPaths: 'Optional[List[AllowedHostPath]]' = None
    allowedProcMountTypes: 'Optional[List[str]]' = None
    allowedUnsafeSysctls: 'Optional[List[str]]' = None
    defaultAddCapabilities: 'Optional[List[str]]' = None
    defaultAllowPrivilegeEscalation: 'Optional[bool]' = None
    forbiddenSysctls: 'Optional[List[str]]' = None
    hostIPC: 'Optional[bool]' = None
    hostNetwork: 'Optional[bool]' = None
    hostPID: 'Optional[bool]' = None
    hostPorts: 'Optional[List[HostPortRange]]' = None
    privileged: 'Optional[bool]' = None
    readOnlyRootFilesystem: 'Optional[bool]' = None
    requiredDropCapabilities: 'Optional[List[str]]' = None
    runAsGroup: 'Optional[RunAsGroupStrategyOptions]' = None
    runtimeClass: 'Optional[RuntimeClassStrategyOptions]' = None
    volumes: 'Optional[List[str]]' = None


@dataclass
class RunAsGroupStrategyOptions(DictMixin):
    """RunAsGroupStrategyOptions defines the strategy type and any options used to
      create the strategy.

      **parameters**

      * **rule** ``str`` - rule is the strategy that will dictate the allowable RunAsGroup values that
        may be set.
      * **ranges** ``Optional[List[IDRange]]`` - ranges are the allowed ranges of gids that may be used. If you would like to
        force a single gid then supply a single range with the same start and end.
        Required for MustRunAs.
    """
    rule: 'str'
    ranges: 'Optional[List[IDRange]]' = None


@dataclass
class RunAsUserStrategyOptions(DictMixin):
    """RunAsUserStrategyOptions defines the strategy type and any options used to
      create the strategy.

      **parameters**

      * **rule** ``str`` - rule is the strategy that will dictate the allowable RunAsUser values that may
        be set.
      * **ranges** ``Optional[List[IDRange]]`` - ranges are the allowed ranges of uids that may be used. If you would like to
        force a single uid then supply a single range with the same start and end.
        Required for MustRunAs.
    """
    rule: 'str'
    ranges: 'Optional[List[IDRange]]' = None


@dataclass
class RuntimeClassStrategyOptions(DictMixin):
    """RuntimeClassStrategyOptions define the strategy that will dictate the
      allowable RuntimeClasses for a pod.

      **parameters**

      * **allowedRuntimeClassNames** ``List[str]`` - allowedRuntimeClassNames is an allowlist of RuntimeClass names that may be
        specified on a pod. A value of "*" means that any RuntimeClass name is
        allowed, and must be the only item in the list. An empty list requires the
        RuntimeClassName field to be unset.
      * **defaultRuntimeClassName** ``Optional[str]`` - defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The
        default MUST be allowed by the allowedRuntimeClassNames list. A value of nil
        does not mutate the Pod.
    """
    allowedRuntimeClassNames: 'List[str]'
    defaultRuntimeClassName: 'Optional[str]' = None


@dataclass
class SELinuxStrategyOptions(DictMixin):
    """SELinuxStrategyOptions defines the strategy type and any options used to
      create the strategy.

      **parameters**

      * **rule** ``str`` - rule is the strategy that will dictate the allowable labels that may be set.
      * **seLinuxOptions** ``Optional[core_v1.SELinuxOptions]`` - seLinuxOptions required to run as; required for MustRunAs More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
    """
    rule: 'str'
    seLinuxOptions: 'Optional[core_v1.SELinuxOptions]' = None


@dataclass
class SupplementalGroupsStrategyOptions(DictMixin):
    """SupplementalGroupsStrategyOptions defines the strategy type and options used
      to create the strategy.

      **parameters**

      * **ranges** ``Optional[List[IDRange]]`` - ranges are the allowed ranges of supplemental groups.  If you would like to
        force a single supplemental group then supply a single range with the same
        start and end. Required for MustRunAs.
      * **rule** ``Optional[str]`` - rule is the strategy that will dictate what supplemental groups is used in the
        SecurityContext.
    """
    ranges: 'Optional[List[IDRange]]' = None
    rule: 'Optional[str]' = None


