# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import util_intstr


@dataclass
class Eviction(DictMixin):
    """Eviction evicts a pod from its node subject to certain policies and safety
      constraints. This is a subresource of Pod.  A request to cause such an
      eviction is created by POSTing to .../pods/<pod name>/evictions.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **deleteOptions** ``Optional[meta_v1.DeleteOptions]`` - DeleteOptions may be provided
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - ObjectMeta describes the pod that is being evicted.
    """
    apiVersion: 'Optional[str]' = None
    deleteOptions: 'Optional[meta_v1.DeleteOptions]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None


@dataclass
class PodDisruptionBudget(DictMixin):
    """PodDisruptionBudget is an object to define the max disruption that can be
      caused to a collection of pods

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[PodDisruptionBudgetSpec]`` - Specification of the desired behavior of the PodDisruptionBudget.
      * **status** ``Optional[PodDisruptionBudgetStatus]`` - Most recently observed status of the PodDisruptionBudget.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[PodDisruptionBudgetSpec]' = None
    status: 'Optional[PodDisruptionBudgetStatus]' = None


@dataclass
class PodDisruptionBudgetList(DictMixin):
    """PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

      **parameters**

      * **items** ``List[PodDisruptionBudget]`` - Items is a list of PodDisruptionBudgets
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PodDisruptionBudget]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None


@dataclass
class PodDisruptionBudgetSpec(DictMixin):
    """PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.

      **parameters**

      * **maxUnavailable** ``Optional[util_intstr.IntOrString]`` - An eviction is allowed if at most "maxUnavailable" pods selected by "selector"
        are unavailable after the eviction, i.e. even in absence of the evicted pod.
        For example, one can prevent all voluntary evictions by specifying 0. This is
        a mutually exclusive setting with "minAvailable".
      * **minAvailable** ``Optional[util_intstr.IntOrString]`` - An eviction is allowed if at least "minAvailable" pods selected by "selector"
        will still be available after the eviction, i.e. even in the absence of the
        evicted pod.  So for example you can prevent all voluntary evictions by
        specifying "100%".
      * **selector** ``Optional[meta_v1.LabelSelector]`` - Label query over pods whose evictions are managed by the disruption budget. A
        null selector will match no pods, while an empty ({}) selector will select all
        pods within the namespace.
    """
    maxUnavailable: 'Optional[util_intstr.IntOrString]' = None
    minAvailable: 'Optional[util_intstr.IntOrString]' = None
    selector: 'Optional[meta_v1.LabelSelector]' = None


@dataclass
class PodDisruptionBudgetStatus(DictMixin):
    """PodDisruptionBudgetStatus represents information about the status of a
      PodDisruptionBudget. Status may trail the actual state of a system.

      **parameters**

      * **currentHealthy** ``int`` - current number of healthy pods
      * **desiredHealthy** ``int`` - minimum desired number of healthy pods
      * **disruptionsAllowed** ``int`` - Number of pod disruptions that are currently allowed.
      * **expectedPods** ``int`` - total number of pods counted by this disruption budget
      * **conditions** ``Optional[List[meta_v1.Condition]]`` - Conditions contain conditions for PDB. The disruption controller sets the
        DisruptionAllowed condition. The following are known values for the reason
        field (additional reasons could be added in the future): - SyncFailed: The
        controller encountered an error and wasn't able to compute
                      the number of allowed disruptions. Therefore no disruptions are
                      allowed and the status of the condition will be False.
        - InsufficientPods: The number of pods are either at or below the number
                            required by the PodDisruptionBudget. No disruptions are
                            allowed and the status of the condition will be False.
        - SufficientPods: There are more pods than required by the
        PodDisruptionBudget.
                          The condition will be True, and the number of allowed
                          disruptions are provided by the disruptionsAllowed property.
      * **disruptedPods** ``Optional[dict]`` - DisruptedPods contains information about pods whose eviction was processed by
        the API server eviction subresource handler but has not yet been observed by
        the PodDisruptionBudget controller. A pod will be in this map from the time
        when the API server processed the eviction request to the time when the pod is
        seen by PDB controller as having been marked for deletion (or after a
        timeout). The key in the map is the name of the pod and the value is the time
        when the API server processed the eviction request. If the deletion didn't
        occur and a pod is still there it will be removed from the list automatically
        by PodDisruptionBudget controller after some time. If everything goes smooth
        this map should be empty for the most of the time. Large number of entries in
        the map may indicate problems with pod deletions.
      * **observedGeneration** ``Optional[int]`` - Most recent generation observed when updating this PDB status.
        DisruptionsAllowed and other status information is valid only if
        observedGeneration equals to PDB's object generation.
    """
    currentHealthy: 'int'
    desiredHealthy: 'int'
    disruptionsAllowed: 'int'
    expectedPods: 'int'
    conditions: 'Optional[List[meta_v1.Condition]]' = None
    disruptedPods: 'Optional[dict]' = None
    observedGeneration: 'Optional[int]' = None


